
--
-- Ensure correct encoding
--
SET NAMES utf8;


--
-- Table structure for table `lang_languages`
--


DROP TABLE IF EXISTS `lang_languages`;
CREATE TABLE `lang_languages` (
  `lang_id` int(11) NOT NULL auto_increment,
  `lang_code` char(2) NOT NULL default '',
  `lang_description` varchar(100) default NULL,
  `lang_is_rtl` TINYINT DEFAULT 0,
  UNIQUE KEY `lang_id` (`lang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 ;


--
-- Dumping data for table `lang_languages`
--

INSERT INTO `lang_languages`   (`lang_id`, `lang_code`, `lang_description`, `lang_is_rtl`) VALUES
(1, 'en', 'English (Standard)', 0),
(2, 'se', 'Swedish', 0),
(3, 'es', 'Spanish (Spain)', 0),
(4, 'el', 'Spanish (Latin American)', 0),
(5, 'de', 'German', 0),
(6, 'du', 'Dutch', 0),
(7, 'he', 'Hebrew', 1),
(8, 'fr', 'French (Standard)', 0),
(9, 'fq', 'French (Canadian)', 0),
(10, 'zh', 'Chinese (Simplified)', 0),
(11, 'zt', 'Chinese (Traditional)', 0),
(12, 'ru', 'Russian', 0),
(13, 'hy', 'Armenian', 0),
(14, 'id', 'Bahasa Indonesia', 0),
(15, 'gr', 'Greek', 0),
(16, 'ei', 'English (Indian)', 0),
(17, 'pe', 'Portuguese (European)', 0),
(18, 'pt', 'Portuguese (Brazilian)', 0),
(19, 'ar', 'Arabic', 1),
(20, 'da', 'Danish', 0),
(21, 'tr', 'Turkish', 0),
(22, 'po', 'Polish', 0),
(23, 'it', 'Italian', 0),
(24, 'hi', 'Hindi', 0),
(25, 'ro', 'Romanian', 0),
(26, 'vi', 'Vietnamese', 0),
(27, 'sq', 'Albanian', 0),
(28, 'cs', 'Czech', 0),
(29, 'uk', 'Ukrainian', 0),
(30, 'fa', 'Persian', 1),
(31, 'ja', 'Japanese', 0),
(32, 'fi', 'Finnish', 0),
(33, 'mr', 'Marathi', 0),
(34, 'ta', 'Tamil', 0),
(35, 'dd', 'dummy', 0);

--


-- 
-- Table structure for table `lang_constants`
-- 


DROP TABLE IF EXISTS `lang_constants`;
CREATE TABLE `lang_constants` (
  `cons_id` int(11) NOT NULL auto_increment,
  `constant_name` mediumtext BINARY,
  UNIQUE KEY `cons_id` (`cons_id`),
  KEY `constant_name` (`constant_name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=9896 ;


-- 
-- Dumping data for table `lang_constants`
--

INSERT INTO `lang_constants`   (`cons_id`, `constant_name`) VALUES
(1, 'A'),
(2, 'A check number or claim number to identify the payment'),
(3, 'A claim must be selected to enable this menu.'),
(4, 'A client certificate for the admin user'),
(5, 'A clinical document is attached'),
(6, 'A clinical document is attached.'),
(7, 'A code of this type is already selected. Erase the field first if you need to replace it.'),
(8, 'A distributor is required'),
(9, 'A GCAC visit form should be added to this visit.'),
(10, 'A large application like openEMR is used by a multitude of users with varying roles and degrees of responsibility. It is imperative that access to various parts of the program be granted to users on a need to know basis. To achieve this - Access Control Lists (ACL) are used.'),
(11, 'A lot number is required'),
(12, 'A lot number is required!'),
(13, 'A lowercase letter'),
(14, 'A number'),
(15, 'A Patient Must Be Selected to Generate This Report'),
(16, 'A patient with this ID already exists.'),
(17, 'A patient with this name already exists.'),
(18, 'A patient with this SS already exists.'),
(19, 'A Payment is Required!. Please input a payment line item entry.'),
(20, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen (a negative number will show the past appointments in descending order)'),
(21, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen.'),
(22, 'A product was selected but there is no product section in this form.'),
(23, 'A referral source may be specified for each visit.'),
(24, 'A related IPPF code is required!'),
(25, 'A short description of this group that will appear when you hover over the newly created group (ARO).'),
(26, 'A special character'),
(27, 'A unique value to identify this field, not visible to the user'),
(28, 'A visit already exists for this group today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(29, 'A visit already exists for this patient today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(30, 'a.c.'),
(31, 'a.m.'),
(32, 'A/C{{anterior chamber}}'),
(33, 'A/F Level Right:'),
(34, 'AB'),
(35, 'Abbreviation'),
(36, 'Abcess:'),
(37, 'Abdominal'),
(38, 'Able to Bear Weight four (4) steps:'),
(39, 'Abn'),
(40, 'ABN1'),
(41, 'Abnormal'),
(42, 'Abnormal Blood Test'),
(43, 'Abnormal Hair Growth'),
(44, 'Abnormal Mammogram'),
(45, 'Abort'),
(46, 'Abortion'),
(47, 'Abortion Issues'),
(48, 'Abortion Method'),
(49, 'Abortion-Related Categories'),
(50, 'Abortions'),
(51, 'About'),
(52, 'About Portal Dashboard'),
(53, 'About the calendar'),
(54, 'About Your Portal'),
(55, 'Above upper panic limits'),
(56, 'Absences by Diagnosis'),
(57, 'Accept'),
(58, 'Accept Assignment'),
(59, 'Accept Payment for'),
(60, 'Accept Payment for '),
(61, 'Accepts Assignment'),
(62, 'Access Control'),
(63, 'Access Control List Administration'),
(64, 'Access Control List Help'),
(65, 'Access Control Lists'),
(66, 'Access date'),
(67, 'Access denied'),
(68, 'Access is then granted selectively to portions of the program on a need to know basis.'),
(69, 'access not allowed'),
(70, 'Access not allowed'),
(71, 'Access Not Authorized'),
(72, 'Access Your Medical Records'),
(73, 'Access Your Patient Portal'),
(74, 'Accident'),
(75, 'Account'),
(76, 'Account Id issued for NewCrop eRx service, used to separate multi-facility accounts.'),
(77, 'Account Id issued for Weno eRx service.'),
(78, 'Account Id issued for Your clinics eRx service.'),
(79, 'Account is validated. Send new credentials?'),
(80, 'Account Name'),
(81, 'Account Name issued for NewCrop eRx service.'),
(82, 'Account Password issued for NewCrop eRx service.'),
(83, 'Accounting'),
(84, 'Accounting (acct)'),
(85, 'Accountings'),
(86, 'Acct'),
(87, 'ACD{{anterior chamber depth}}'),
(88, 'Aches'),
(89, 'Acknowledge as my Electronic Signature'),
(90, 'Acknowledgment Requested (ISA14)'),
(91, 'Acknowledgments, Licensing and Certification'),
(92, 'ACL'),
(93, 'ACL Administration'),
(94, 'ACL Administration (acl)'),
(95, 'ACL Administration Not Authorized'),
(96, 'ACL Fine Granular Control'),
(97, 'ACL Updated Successfully'),
(98, 'Acne'),
(99, 'ACO'),
(100, 'ACOM{{Anterior Segment}}'),
(101, 'Act'),
(102, 'Act Date'),
(103, 'Action'),
(104, 'Action Taken'),
(105, 'Action Taken Time'),
(106, 'Action User'),
(107, 'Actions'),
(108, 'Activate'),
(109, 'Activate CCR/CCD Reporting'),
(110, 'activate to sort column ascending'),
(111, 'activate to sort column descending'),
(112, 'Activate UB04/837I Claim Support'),
(113, 'Active'),
(114, 'Active Alert'),
(115, 'Active Alert Rules'),
(116, 'Active Alerts/Reminders'),
(117, 'Active Chart'),
(118, 'Active Directory - Domains Base'),
(119, 'Active Directory - Domains Controllers'),
(120, 'Active Directory - Suffix Of Account'),
(121, 'Active Encounter'),
(122, 'Active Issue Codes'),
(123, 'Active lists'),
(124, 'Active Messages'),
(125, 'Active Patient'),
(126, 'Active Plans'),
(127, 'Active Templates'),
(128, 'Activity'),
(129, 'Activity Type'),
(130, 'Actual Receipts'),
(131, 'Acuity'),
(132, 'ACUITY'),
(133, 'Acuity with Autorefraction'),
(134, 'Acuity with Contact Lenses'),
(135, 'Acuity with correction'),
(136, 'Acuity with Cycloplegic Refraction'),
(137, 'Acuity with Manifest Refraction'),
(138, 'Acuity with Pinhole'),
(139, 'Acuity without correction'),
(140, 'Acute Intoxication/Withdrawal'),
(141, 'Acute Manifestation of a Chronic Condition'),
(142, 'Acute on Chronic'),
(143, 'Ad Reviewed'),
(144, 'add'),
(145, 'Add'),
(146, 'ADD'),
(147, 'Add a Company'),
(148, 'Add a condition'),
(149, 'Add a New Recall'),
(150, 'Add a Pharmacy'),
(151, 'Add all rules to plan'),
(152, 'add an event for '),
(153, 'Add as a new note'),
(154, 'Add as New'),
(155, 'Add as new patient'),
(156, 'Add Bottom Border Row'),
(157, 'Add Buttons'),
(158, 'Add Buttons for Special Chars,Texts to be Displayed on Top of the Editor for inclusion to the text on a Click'),
(159, 'Add Category'),
(160, 'Add Constant'),
(161, 'Add Context'),
(162, 'Add Copay'),
(163, 'Add criteria'),
(164, 'Add Custom Button'),
(165, 'Add Data Bottom Border'),
(166, 'Add desired privileges by moving items (ACOs) from the \'Inactive\' column to the \'Active\' column.'),
(167, 'Add Diagnosis'),
(168, 'Add Drug'),
(169, 'Add encounter'),
(170, 'Add Encounter'),
(171, 'Add encounter/notes'),
(172, 'Add Facility'),
(173, 'Add Field'),
(174, 'Add following lines to the Apache configuration file'),
(175, 'Add Group'),
(176, 'Add group'),
(177, 'Add ICD Code'),
(178, 'Add Immunization'),
(179, 'Add is not authorized!'),
(180, 'Add Issue'),
(181, 'Add item to track'),
(182, 'Add Language'),
(183, 'Add manually'),
(184, 'Add modifiers for this field type. You may select more than one.'),
(185, 'Add More Items'),
(186, 'Add New'),
(187, 'Add new'),
(188, 'Add new category : '),
(189, 'Add new certificates to the Apache configuration file'),
(190, 'Add New Component'),
(191, 'Add New Components'),
(192, 'Add new database'),
(193, 'Add New Group'),
(194, 'ADD NEW GROUP'),
(195, 'Add New Issue'),
(196, 'Add new lot and transaction'),
(197, 'Add New Note'),
(198, 'Add new note'),
(199, 'Add New Partner'),
(200, 'Add New Patient'),
(201, 'ADD NEW PLAN'),
(202, 'Add Note'),
(203, 'Add Onsite Portal Activity'),
(204, 'Add Package'),
(205, 'Add Patient'),
(206, 'Add Patient Record'),
(207, 'Add Prescription'),
(208, 'Add Procedure'),
(209, 'Add Provider Number'),
(210, 'Add Recall'),
(211, 'Add Rehab'),
(212, 'Add Rule'),
(213, 'Add Time to Date'),
(214, 'Add to'),
(215, 'Add to Medication List'),
(216, 'Add Top Level'),
(217, 'Add Transaction'),
(218, 'Add User'),
(219, 'Add User To Group'),
(220, 'Add.{{Additional Measurements}}'),
(221, 'Add/Edit eRx'),
(222, 'Add/Edit Patient Transaction'),
(223, 'added'),
(224, 'Adding'),
(225, 'Adding a participant'),
(226, 'Adding demographics is not authorized.'),
(227, 'Adding item to track failed'),
(228, 'Addison Syndrom'),
(229, 'Addison Syndrome'),
(230, 'Additional Attributes'),
(231, 'Additional Data Points'),
(232, 'Additional Date:'),
(233, 'Additional Diagnosis:'),
(234, 'Additional Findings'),
(235, 'Additional History'),
(236, 'Additional history notes'),
(237, 'Additional Info'),
(238, 'Additional Labs'),
(239, 'Additional Notes'),
(240, 'Additional notes for this result or recommendation'),
(241, 'Additional Notes:'),
(242, 'Additional Notes: '),
(243, 'Additional X-RAY Notes:'),
(244, 'Additionally, the corresponding US Snomed Extension Package can be imported separately after installing the International (English version) Snomed Release'),
(245, 'Additonal Rx{{Additional glasses}}'),
(246, 'addonly'),
(247, 'addonly - can read and add but not modify'),
(248, 'Addr Bk'),
(249, 'Addr Book'),
(250, 'Address'),
(251, 'Address and Postal Code'),
(252, 'Address and State'),
(253, 'Address Book'),
(254, 'Address book entry for the company performing this procedure'),
(255, 'Address book entry for the distributor'),
(256, 'Address book entry for the vendor'),
(257, 'Address Book Types'),
(258, 'Address Label'),
(259, 'Address Labels'),
(260, 'Address Only'),
(261, 'Address, City, State and Postal Code'),
(262, 'Address, State and Postal Code'),
(263, 'Address1'),
(264, 'Address2'),
(265, 'ADDRESSED TO'),
(266, 'ADDRESSEE'),
(267, 'ADD{{Bifocal Add}}'),
(268, 'ADD{{Near Add}}'),
(269, 'Adj'),
(270, 'Adj Amount'),
(271, 'Adjust'),
(272, 'Adjustment'),
(273, 'Adjustment Amt'),
(274, 'Adjustment Reasons'),
(275, 'Adjustment value for code '),
(276, 'Adjustments'),
(277, 'Adm adjust'),
(278, 'Admin'),
(279, 'Admin Email Address'),
(280, 'Administer Via'),
(281, 'Administered'),
(282, 'Administered By'),
(283, 'Administered Date'),
(284, 'Administered Site'),
(285, 'Administration'),
(286, 'Administration (admin)'),
(287, 'Administration Site'),
(288, 'Administrators'),
(289, 'Administrators can do anything'),
(290, 'Admit Date'),
(291, 'Adnexa'),
(292, 'Adopted Child'),
(293, 'Adult Weight Screening and Follow-Up'),
(294, 'Adult Weight Screening and Follow-Up (CQM)'),
(295, 'Advance Directive'),
(296, 'Advance Directives'),
(297, 'Advance Directives Warning'),
(298, 'Advance Options'),
(299, 'Advanced'),
(300, 'Advanced - Finer Access Control'),
(301, 'Advice'),
(302, 'Afar'),
(303, 'Affect normal'),
(304, 'Afrikaans'),
(305, 'after'),
(306, 'after (PM)'),
(307, 'After hrs calls'),
(308, 'After migration from the old password mechanisms where passwords are stored in the users table without salt is complete, this flag should be set to false so that only authentication by the new method is possible'),
(309, 'After performing above configurations, import the admin client certificate to the browser and restart Apache server (empty password).'),
(310, 'After saving the PDF, click [View Log] to check for errors.'),
(311, 'After saving the TEXT file(s), click [View Log] to check for errors.'),
(312, 'After saving your batch, click [View Log] to check for errors.'),
(313, 'After that the Match column will show the selected patient ID, or 0 to create.'),
(314, 'After the information is correctly entered, click the Save button.'),
(315, 'After Uploading click the button \"Import\"'),
(316, 'After Uploading, click \"Import\"'),
(317, 'AfterCare Planning'),
(318, 'Again'),
(319, 'Age'),
(320, 'Age By'),
(321, 'Age Category'),
(322, 'Age data is out of range.'),
(323, 'Age Display Format'),
(324, 'Age format for \"age from\" is not valid'),
(325, 'Age format for \"age up to\" is not valid'),
(326, 'Age From'),
(327, 'Age in Years for Display Format Change'),
(328, 'Age max'),
(329, 'Age min'),
(330, 'Age Range'),
(331, 'Aging Columns'),
(332, 'Aging Columns:'),
(333, 'Akan'),
(334, 'Albanian'),
(335, 'Alcohol'),
(336, 'Alcohol consumption'),
(337, 'Alcohol Use'),
(338, 'Alert'),
(339, 'Alert Count'),
(340, 'Alert on and after birthday'),
(341, 'Alert on patient birthday'),
(342, 'Alert only on birthday'),
(343, 'Alert Time'),
(344, 'Alerts'),
(345, 'Alerts Log'),
(346, 'Alerts/Reminders'),
(347, 'Alert{{Mental Status}}'),
(348, 'ALEUT'),
(349, 'All'),
(350, 'ALL'),
(351, 'all'),
(352, 'All (Collated Format A)'),
(353, 'All (Collated Format B)'),
(354, 'All (Cumulative)'),
(355, 'All Alerts'),
(356, 'All Automated Measure Calculations (AMC)'),
(357, 'All Categories'),
(358, 'All Clinical Quality Measures (CQM)'),
(359, 'All Codes'),
(360, 'All Dates'),
(361, 'All Day'),
(362, 'All day event'),
(363, 'All demographics fields, with search and duplication check'),
(364, 'All Encounters'),
(365, 'All Facilities'),
(366, 'All Injuries/Problems/Issues'),
(367, 'All Languages Allowed'),
(368, 'All Messages'),
(369, 'All Official Clinical Quality Measures (CQM) Measure Groups'),
(370, 'All or part of the first name'),
(371, 'All or part of the last name'),
(372, 'All or part of the organization'),
(373, 'All Patients'),
(374, 'All Products'),
(375, 'All Providers'),
(376, 'All Reviewed and Negative:'),
(377, 'All set. Click Send Request below to finish registration'),
(378, 'All Topics'),
(379, 'All Users'),
(380, 'Allergic'),
(381, 'Allergic to'),
(382, 'Allergies'),
(383, 'Allergies:'),
(384, 'Allergy'),
(385, 'Allergy import successfully completed'),
(386, 'Allergy Issue List'),
(387, 'Allergy Reaction'),
(388, 'ALLERGY WARNING'),
(389, 'Allergy Warning'),
(390, 'Allocate'),
(391, 'Allow'),
(392, 'Allow Administrators to Delete Patients'),
(393, 'Allow all available languages as choices on menu at login.'),
(394, 'Allow Check In before the appointment\'s time.'),
(395, 'Allow creation of claims containing diagnoses but not procedures or charges. Most clinics do not want this.'),
(396, 'Allow Debugging Language'),
(397, 'Allow Early Check In'),
(398, 'Allow Email'),
(399, 'Allow email messages?'),
(400, 'Allow Email?'),
(401, 'Allow Encounter Claims'),
(402, 'Allow Health Info Exchange'),
(403, 'Allow Health Information Exchange'),
(404, 'Allow Immunization Info Share'),
(405, 'Allow Immunization Info Sharing'),
(406, 'Allow Immunization Registry Use'),
(407, 'Allow institutional claims support.'),
(408, 'Allow Mail Message'),
(409, 'Allow multiple databases'),
(410, 'Allow Notice'),
(411, 'Allow Patient Flow Board to Select Patients for Drug Testing.'),
(412, 'Allow Patient Portal'),
(413, 'Allow Postal Mail'),
(414, 'Allow SMS'),
(415, 'Allow SMS (text messages)?'),
(416, 'Allow Statement Exclusions from Printing'),
(417, 'Allow submitted events to be made active instantly?'),
(418, 'Allow telephone messages?'),
(419, 'Allow to use with multiple database'),
(420, 'Allow users to publish Global Events'),
(421, 'Allow users to publish Personal Calendars'),
(422, 'Allow Version 2 Onsite New Patient Registration Widget'),
(423, 'Allow Version 2 Onsite Online Payments'),
(424, 'Allow Version 2 Onsite Patient to make payments online.'),
(425, 'Allow Version 2 Patients to Reset Credentials'),
(426, 'Allow Voice Call'),
(427, 'Allow Voice Message'),
(428, 'Allowed'),
(429, 'Allowed Languages'),
(430, 'Allowed to discount prices (in Fee Sheet or Checkout form) (disc)'),
(431, 'Allowed(c)'),
(432, 'Allows E-Sign on the entire encounter'),
(433, 'Allows E-Signing Individual Forms'),
(434, 'Allows Mail'),
(435, 'Allows Voice msgs'),
(436, 'already exists'),
(437, 'already exists.'),
(438, 'Already registered'),
(439, 'Already used, choose another identifier'),
(440, 'Already used, choose another title'),
(441, 'Alt Address'),
(442, 'alter'),
(443, 'Alternate Cover Test'),
(444, 'Alternatively, you may use the search page to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse.  You can do this by clicking the Browse button and selecting the file to upload, and then clicking Search to perform the upload and display the corresponding invoices.  In this case the other parameters mentioned above do not apply and will be ignored.  Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(445, 'AM'),
(446, 'AM Program'),
(447, 'Amblyopia'),
(448, 'Ambulance - Air or Water'),
(449, 'Ambulance - Land'),
(450, 'Ambulatory Surgical Center'),
(451, 'AMC'),
(452, 'AMC Tracking'),
(453, 'AMC-2011'),
(454, 'AMC-2014'),
(455, 'AMC-2014 Stage I'),
(456, 'AMC-2014 Stage II'),
(457, 'AMD{{age related macular degeneration}}'),
(458, 'Amend Existing Note'),
(459, 'Amendment From'),
(460, 'Amendment List'),
(461, 'Amendment Status'),
(462, 'Amendments'),
(463, 'Amendments (write,addonly optional)'),
(464, 'Amendments for'),
(465, 'American Indian'),
(466, 'American Indian or Alaska Native'),
(467, 'AMEX'),
(468, 'Amharic'),
(469, 'Amount'),
(470, 'Amount Administered'),
(471, 'Amount Charges'),
(472, 'Amount Charges:'),
(473, 'Amount Due'),
(474, 'Amount for Past Balance'),
(475, 'Amount for This Visit'),
(476, 'Amount Paid'),
(477, 'Amount:'),
(478, 'Amplitudes'),
(479, 'Amsler'),
(480, 'Amt Billed'),
(481, 'An e-mail with your new account credentials will be sent to the e-mail address supplied earlier. You may still review or edit any part of your information by using the top step buttons to go to the appropriate panels. Note to be sure you have given your correct e-mail address. If after receiving credentials and you have trouble with access to the portal, please contact administration.'),
(482, 'An end date later than the start date is required for repeated events!'),
(483, 'An error occured signing the form'),
(484, 'An error occurred while dumping OpenEMR web directory tree'),
(485, 'An error occurred while dumping phpGACL web directory tree'),
(486, 'An error occurred while dumping SQL-Ledger web directory tree'),
(487, 'An error occurred: Missing file to upload: Use back button!'),
(488, 'An incomplete GCAC issue has been created and linked. Someone will need to complete it later.'),
(489, 'An undefined error occurred, please contact your systems administrator.'),
(490, 'An unexpected error has occurred.'),
(491, 'An uppercase letter'),
(492, 'Analyzed'),
(493, 'and'),
(494, 'AND'),
(495, 'And'),
(496, 'and '),
(497, 'and all subordinate data? This action will be logged'),
(498, 'and modifier'),
(499, 'and processed.'),
(500, 'and restart Apache server.'),
(501, 'and the Reason is'),
(502, 'Anemia'),
(503, 'Ankle'),
(504, 'Ankle + heel'),
(505, 'Ankle Evaluation Form'),
(506, 'Ankle Problems'),
(507, 'Ankylosing Sondlilitis'),
(508, 'Ankylosing Spondlilitis'),
(509, 'Anorexia'),
(510, 'Another thing you can do in the posting window is request secondary billing. If you select this checkbox before saving, then the original claim will be re-opened and queued on the Billing page, and will be processed during the next billing run.'),
(511, 'Answering Service'),
(512, 'ante'),
(513, 'Anterior Chamber Depth'),
(514, 'Anterior Segment'),
(515, 'Anterior Segment Default Values'),
(516, 'ant{{anterior}}'),
(517, 'Anus nl, no rectal tenderness/mass'),
(518, 'Anxiety'),
(519, 'Any'),
(520, 'any'),
(521, 'Any carotid bruits appreciated?'),
(522, 'Any Category'),
(523, 'Any changes here will be reviewed by provider staff before commiting to chart. The following apply'),
(524, 'any date'),
(525, 'Any part of the desired code or its description'),
(526, 'Any part of the desired specialty'),
(527, 'Any part of the drug id or drug name'),
(528, 'Any part of the immunization id or immunization name'),
(529, 'Any part of the patient name, or \"last,first\", or \"X-Y\"'),
(530, 'Anyother Relevant Information'),
(531, 'Anything else occur at the same time?'),
(532, 'APD{{afferent pupillary defect}}'),
(533, 'API key for SMS Gateway.'),
(534, 'Apnea'),
(535, 'App'),
(536, 'Appearance'),
(537, 'Appearance:'),
(538, 'Append this note'),
(539, 'Append to the existing note'),
(540, 'Append to this note'),
(541, 'Append to This Note'),
(542, 'Appendectomy'),
(543, 'appendectomy'),
(544, 'Applicable Patients'),
(545, 'Application'),
(546, 'Application name for login page and main window title.'),
(547, 'Application Receiver Code (GS03 - If blank ISA08 will be used)'),
(548, 'Application Sender Code (GS02)'),
(549, 'Application Title'),
(550, 'Applies to the Vitals form and Growth Chart'),
(551, 'Applies to Vitals form'),
(552, 'Apply the changes to the Current event only, to this and all Future occurrences, or to All occurrences?'),
(553, 'apply to affected area'),
(554, 'apply to skin'),
(555, 'Applying'),
(556, 'Applying Patch to site'),
(557, 'Appointment'),
(558, 'Appointment Category'),
(559, 'Appointment Date'),
(560, 'Appointment Display Sets - Color 1'),
(561, 'Appointment Display Sets - Color 2'),
(562, 'Appointment Display Sets - Color 3'),
(563, 'Appointment Display Sets - Color 4'),
(564, 'Appointment Display Sets - Ignore Display Limit (Last Set)'),
(565, 'Appointment Display Style'),
(566, 'Appointment made by'),
(567, 'Appointment Reminder Rule'),
(568, 'Appointment Reminders'),
(569, 'Appointment status'),
(570, 'Appointment Statuses'),
(571, 'Appointment within'),
(572, 'Appointment/Event Color'),
(573, 'Appointments'),
(574, 'Appointments (write optional)'),
(575, 'Appointments (write,wsome optional)'),
(576, 'Appointments (write,wsome optional) (appt)'),
(577, 'Appointments - Group Summary - Number to Display'),
(578, 'Appointments - Onsite Patient Portal - Number to Display'),
(579, 'Appointments - Patient Summary - Number to Display'),
(580, 'Appointments and Encounters'),
(581, 'Appointments for'),
(582, 'Appointments Report'),
(583, 'Appointments-Encounters Report'),
(584, 'Appropriate Testing for Children with Pharyngitis (CQM)'),
(585, 'Approve'),
(586, 'Approve Order'),
(587, 'Approve the patient from Patient/Client->Import->Pending Approval'),
(588, 'Approved'),
(589, 'Approved Events Administration'),
(590, 'Approved Successfully'),
(591, 'Apps'),
(592, 'Appt Date'),
(593, 'Appt Status'),
(594, 'Appt Time'),
(595, 'Appt-Enc'),
(596, 'Appt. Reminders'),
(597, 'Appts'),
(598, 'Appt{{Abbreviation for appointment}}'),
(599, 'App{{Applanation abbreviation}}'),
(600, 'Apr'),
(601, 'April'),
(602, 'AP{{applanation}}'),
(603, 'Arabic'),
(604, 'Aragonese'),
(605, 'Archive'),
(606, 'Archive Log Files'),
(607, 'Archive old files'),
(608, 'Are access control group names to be translated?'),
(609, 'Are appointment category names to be translated?'),
(610, 'Are document category names to be translated?'),
(611, 'Are fees charged for this type?'),
(612, 'are off'),
(613, 'are on'),
(614, 'Are patient note titles to be translated?'),
(615, 'Are the codes stored in external sql tables (0-No, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2)) ?'),
(616, 'Are you prepared to complete a new GCAC issue for this visit?'),
(617, 'Are you sure to clear chat history?'),
(618, 'Are you sure to post for today?'),
(619, 'Are you sure you want to approve these events?'),
(620, 'Are you sure you want to cancel your changes?'),
(621, 'Are you sure you want to completely remove this form?'),
(622, 'Are you sure you want to delete'),
(623, 'Are you sure you want to delete this disclosure?'),
(624, 'Are you sure you want to delete this event?'),
(625, 'Are you sure you want to delete this item from the database?'),
(626, 'Are you sure you want to delete this note?'),
(627, 'Are you sure you want to delete this plan?'),
(628, 'Are you sure you want to edit these events?'),
(629, 'Are you sure you want to hide these events?'),
(630, 'Are you sure you want to remove namespace'),
(631, 'Are you sure you want to transmit it again?'),
(632, 'Are you sure you want to view these events?'),
(633, 'Are you sure you wish to delete the entire group named'),
(634, 'Are you sure you wish to delete the entire list'),
(635, 'Are you sure you wish to delete the field in'),
(636, 'Are you sure you wish to delete the selected fields?'),
(637, 'Are you sure you\'d like to continue with these actions?'),
(638, 'Area not specified'),
(639, 'Arm'),
(640, 'Armenian'),
(641, 'ARNear{{Auto-refraction near acuity}}'),
(642, 'ARNear{{autorefraction near}}'),
(643, 'Arrival'),
(644, 'Arrive Time'),
(645, 'Arrived'),
(646, 'Arrived late'),
(647, 'Arrythmia'),
(648, 'Arthritis'),
(649, 'Arthritis / degen joint diseas'),
(650, 'Arthritis / degen joint disease'),
(651, 'AR{{Autorefraction Acuity}}'),
(652, 'AR{{autorefraction}}'),
(653, 'as'),
(654, 'As appears on documents'),
(655, 'As Of'),
(656, 'As will appear on documents.'),
(657, 'ASC'),
(658, 'Asian'),
(659, 'Assamese'),
(660, 'Assess Penicillin Allergy'),
(661, 'Assessment'),
(662, 'Assign it to this one?'),
(663, 'Assigned To'),
(664, 'Assistant'),
(665, 'Assisted Living Facility'),
(666, 'Associate'),
(667, 'Associated'),
(668, 'Associated Notes.'),
(669, 'Assume patients permit Messaging'),
(670, 'Assume patients receive HIPAA policy'),
(671, 'Asthma'),
(672, 'at'),
(673, 'At least one search parameter is required if you select All.'),
(674, 'At the Navicular'),
(675, 'At the Navicular:'),
(676, 'Athletic team'),
(677, 'Athletic Team'),
(678, 'Athletic/Injury'),
(679, 'ATNA audit CA certificate'),
(680, 'ATNA audit host'),
(681, 'ATNA audit local certificate'),
(682, 'ATNA audit port'),
(683, 'Atropine 1%'),
(684, 'Attending physician'),
(685, 'Attention'),
(686, 'Attention: Pending Documents'),
(687, 'Attn'),
(688, 'Attributes'),
(689, 'Audiological physician'),
(690, 'Audit CDR Engine Queries'),
(691, 'Audit Changes'),
(692, 'Audit Log Tamper'),
(693, 'Audit Log Tamper Report'),
(694, 'Audit log tampering evident at entry number'),
(695, 'Audit Log Validated Successfully'),
(696, 'Audit Log Validation Failed'),
(697, 'Audit Logging Backups'),
(698, 'Audit Logging Miscellaneous'),
(699, 'Audit Logging Order'),
(700, 'Audit Logging Patient Record'),
(701, 'Audit Logging Scheduling'),
(702, 'Audit Logging Security Administration'),
(703, 'Audit Logging SELECT Query'),
(704, 'Aug'),
(705, 'August'),
(706, 'Aunt'),
(707, 'Auth'),
(708, 'Auth/notes'),
(709, 'Authenticator'),
(710, 'Author'),
(711, 'Authorization group'),
(712, 'Authorization Status'),
(713, 'Authorizations'),
(714, 'Authorize'),
(715, 'Authorize - any encounters'),
(716, 'Authorize - any encounters (auth_a)'),
(717, 'Authorize - my encounters'),
(718, 'Authorize - my encounters (auth)'),
(719, 'Authorize as my Electronic Signature.'),
(720, 'Authorize.net'),
(721, 'Authorized'),
(722, 'Authorized Id'),
(723, 'Authorized Only'),
(724, 'Authorized Users'),
(725, 'Auto Refraction'),
(726, 'Auto Send'),
(727, 'Auto Sign-Off [days]'),
(728, 'Auto Transfer'),
(729, 'Auto-Create New Encounters'),
(730, 'Auto-generated'),
(731, 'Auto-Refraction'),
(732, 'Automated Measure Calculations (AMC)'),
(733, 'Automated Measure Calculations (AMC) - 2011'),
(734, 'Automated Measure Calculations (AMC) - 2014'),
(735, 'Automated Measure Calculations (AMC) - 2014 Stage I'),
(736, 'Automated Measure Calculations (AMC) - 2014 Stage II'),
(737, 'Automated Measure Calculations (AMC) Tracking'),
(738, 'Automated Measures (AMC)'),
(739, 'Automated Voice Message permission'),
(740, 'Automatic'),
(741, 'Automatic from sale'),
(742, 'Automatically applies correct extension on successful upload'),
(743, 'Automatically create a new encounter when an appointment check in status is selected.'),
(744, 'Automatically create a new encounter when appointment status is set to \"@\" (arrived).'),
(745, 'Automatically replicate justification codes in Fee Sheet'),
(746, 'Automatically replicate justification codes in Fee Sheet (basically fills in the blanks with the justification code above it).'),
(747, 'Automobile Medical'),
(748, 'autosaved'),
(749, 'Auto{{autorefraction}}'),
(750, 'Available Appointments Calendar'),
(751, 'Available categories'),
(752, 'Available Services'),
(753, 'Available Times'),
(754, 'Available Tracks'),
(755, 'Avaric'),
(756, 'Avery Label type for printing patient labels from popups in left nav screen'),
(757, 'Avestan'),
(758, 'Avg Monthly'),
(759, 'AVM'),
(760, 'AVM Confirmed'),
(761, 'AVM OK'),
(762, 'Avulsion / avulsion fracture'),
(763, 'Avulsion lateral malleolus'),
(764, 'Avulsion medial malleolus '),
(765, 'Awareness-Based'),
(766, 'Axial Length'),
(767, 'Axillary'),
(768, 'Axis{{Axis in a glasses prescription}}'),
(769, 'Axis{{Axis of a glasses prescription}}'),
(770, 'AXIS{{Axis of a glasses prescription}}'),
(771, 'AxLength{{axial Length}}'),
(772, 'Aymara'),
(773, 'Azerbaijani'),
(774, 'b.i.d.'),
(775, 'Back'),
(776, 'back'),
(777, 'Back eight visits'),
(778, 'Back eleven visits'),
(779, 'Back five visits'),
(780, 'Back four visits'),
(781, 'Back nine visits'),
(782, 'Back one visit'),
(783, 'Back Pain'),
(784, 'Back Problems'),
(785, 'Back seven visits'),
(786, 'Back six visits'),
(787, 'Back Surgery'),
(788, 'Back ten visits'),
(789, 'Back three visits'),
(790, 'Back to Admin Page'),
(791, 'Back To Editor'),
(792, 'Back to encounter'),
(793, 'Back to Patient'),
(794, 'Back To Patient'),
(795, 'Back to Users'),
(796, 'Back To View'),
(797, 'Back twelve visits'),
(798, 'Back two visits'),
(799, 'Background Services'),
(800, 'Backup'),
(801, 'Backup file has been created. Will now send download.'),
(802, 'Backup List'),
(803, 'Backup Successfully taken in'),
(804, 'Bad check'),
(805, 'Bad debt'),
(806, 'Bahasa Indonesia'),
(807, 'Bal'),
(808, 'Balance'),
(809, 'balance'),
(810, 'Balance Amt'),
(811, 'Balance Due'),
(812, 'Balance Payment'),
(813, 'Balanced'),
(814, 'Bambara'),
(815, 'Bank Draft'),
(816, 'Barcode Label'),
(817, 'Barcode Label Type'),
(818, 'Barcode type for printing barcode labels from popups in left nav screen.'),
(819, 'Base of fifth (5th) Metarsal'),
(820, 'Base of fifth (5th) Metarsal:'),
(821, 'Base URL for FHIR Server. Url should end with /'),
(822, 'Bashkir'),
(823, 'Basque'),
(824, 'Batch Claim'),
(825, 'Batch Communication Tool'),
(826, 'Batch Communication Tool (batchcom)'),
(827, 'Batch Payment Entry'),
(828, 'Batch Payments'),
(829, 'Batch processing initiated; this may take a while.'),
(830, 'Batch Results'),
(831, 'BatchCom'),
(832, 'BAT{{Brightness Acuity Testing}}'),
(833, 'BC{{Base Curve}}'),
(834, 'Be patient, some files can take several minutes to process!'),
(835, 'Be patient, this can take a while.'),
(836, 'because that id does not exist.'),
(837, 'before'),
(838, 'before (PM)'),
(839, 'Begin'),
(840, 'Begin Date'),
(841, 'Beginning Date for Ledger Report'),
(842, 'Beginning date of service yyyy-mm-dd'),
(843, 'Beginning hour of day for calendar events.'),
(844, 'Belarusian'),
(845, 'Belching'),
(846, 'Below lower panic limits'),
(847, 'Bengali'),
(848, 'Bengali- Bangla'),
(849, 'Best of Luck.'),
(850, 'between'),
(851, 'bg{{image canvas label}}'),
(852, 'Bidirectional'),
(853, 'Bifocal'),
(854, 'Bifocals'),
(855, 'Bihari'),
(856, 'Bilateral'),
(857, 'Bilateral:'),
(858, 'Bill Date'),
(859, 'Bill Date:'),
(860, 'Bill/Collect'),
(861, 'Billed'),
(862, 'Billed Date'),
(863, 'Billing'),
(864, 'Billing (write optional)'),
(865, 'Billing (write optional) (bill)'),
(866, 'Billing Attn'),
(867, 'Billing Code Descriptions'),
(868, 'Billing Code for Requested Service'),
(869, 'Billing codes'),
(870, 'Billing Data'),
(871, 'Billing Department'),
(872, 'Billing Facility'),
(873, 'Billing Information'),
(874, 'Billing Location'),
(875, 'Billing Log Append'),
(876, 'Billing Log Option'),
(877, 'Billing Log Overwrite'),
(878, 'Billing log setting to append or overwrite the log file.'),
(879, 'Billing Manager'),
(880, 'Billing Note'),
(881, 'Billing Note for '),
(882, 'Billing Note:'),
(883, 'Billing queue results'),
(884, 'Billing queue results:'),
(885, 'Billing Report'),
(886, 'Billing Status'),
(887, 'Billing Status = Unbilled'),
(888, 'billing to '),
(889, 'Billing View'),
(890, 'Binocular Pupillary Diameter - Distance'),
(891, 'Binocular Pupillary Diameter - Near'),
(892, 'Biopsy'),
(893, 'Birth Certificate'),
(894, 'Birth Date'),
(895, 'Birth-24 months'),
(896, 'Birthing Center'),
(897, 'Bislama'),
(898, 'Black'),
(899, 'Black list'),
(900, 'Black Lung'),
(901, 'Black or African American'),
(902, 'Bladder Cancer'),
(903, 'Bladder Infections'),
(904, 'Blank'),
(905, 'Blank Forms'),
(906, 'Bleeding Problems'),
(907, 'Blind Spots'),
(908, 'Blindness'),
(909, 'Bloating'),
(910, 'Block all files types that are not found in the White List. Can find interface to edit the White List at Administration->Files.'),
(911, 'Blocked'),
(912, 'Blood'),
(913, 'Blood Pressure'),
(914, 'Blood pressure'),
(915, 'Bloody Nose'),
(916, 'Blue Cross Blue Shield'),
(917, 'Blue lines in this report are informational. Black lines show previously existing information.  Green lines show changes that were successfully applied.  Red lines indicate errors, or changes that were not applied; these must be processed manually.  Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(918, 'Blurred Vision'),
(919, 'BMI'),
(920, 'BMI Status'),
(921, 'Body'),
(922, 'Body Region'),
(923, 'Body Site'),
(924, 'Body site, if applicable'),
(925, 'Bone Tenderness:'),
(926, 'Bone Tenderness: Medial Malleolus'),
(927, 'Boolean'),
(928, 'Bosnian'),
(929, 'Bot'),
(930, 'Both'),
(931, 'Both Ears'),
(932, 'both ears'),
(933, 'Bottom'),
(934, 'Bottom Margin (px)'),
(935, 'BOX 10 A. Employment related '),
(936, 'BOX 10 B. Auto Accident '),
(937, 'BOX 10 C. Other Accident '),
(938, 'BOX 10 D. EPSDT Referral Code'),
(939, 'Box 10. a. Employment related:'),
(940, 'Box 10. b. Auto Accident:'),
(941, 'Box 10. c. Other Accident:'),
(942, 'Box 10. d. EPSDT Referral Code:'),
(943, 'BOX 14 Date Qualifier'),
(944, 'BOX 14. Is Populated from the Encounter Screen as the Onset Date'),
(945, 'Box 14. Onset Date:'),
(946, 'BOX 15 Other Date Qualifier'),
(947, 'BOX 15. Date of same or similar illness (yyyy-mm-dd):'),
(948, 'BOX 15. Date of same or similar illness/Other Date (yyyy-mm-dd):'),
(949, 'Box 15. Other Date:'),
(950, 'BOX 16. Date unable to work from'),
(951, 'BOX 16. Date unable to work from (yyyy-mm-dd):'),
(952, 'Box 16. Date unable to work from:'),
(953, 'BOX 16. Date unable to work to'),
(954, 'BOX 16. Date unable to work to (yyyy-mm-dd):'),
(955, 'Box 16. Date unable to work to:'),
(956, 'BOX 17. Provider'),
(957, 'BOX 17. Provider Qualifier'),
(958, 'Box 17. Provider Qualifier:'),
(959, 'Box 17. Provider:'),
(960, 'BOX 18. Hospitalization date from'),
(961, 'BOX 18. Hospitalization date from (yyyy-mm-dd): '),
(962, 'Box 18. Hospitalization date from:'),
(963, 'BOX 18. Hospitalization date to'),
(964, 'BOX 18. Hospitalization date to (yyyy-mm-dd): '),
(965, 'Box 18. Hospitalization date to:'),
(966, 'Box 20. Is Outside Lab used?'),
(967, 'BOX 20. Is Outside Lab used?'),
(968, 'Box 22. Medicaid Resubmission Code (ICD-9) '),
(969, 'BOX 22. Medicaid Resubmission Code (ICD-9) '),
(970, 'Box 23. Prior Authorization No. '),
(971, 'BOX 23. Prior Authorization No. '),
(972, 'BP'),
(973, 'BP Diastolic'),
(974, 'BP Systolic'),
(975, 'BPD'),
(976, 'Bpd'),
(977, 'BPD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(978, 'BPD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(979, 'BPS'),
(980, 'Bps'),
(981, 'Brand'),
(982, 'Brazilian Portuguese'),
(983, 'Breast'),
(984, 'Breast Biopsy'),
(985, 'Breast Discharge'),
(986, 'Breast Disease'),
(987, 'Breast Exam'),
(988, 'Breast Mass'),
(989, 'Breath'),
(990, 'Breath Sounds:'),
(991, 'Breton'),
(992, 'Brightness Acuity Testing'),
(993, 'Broken Bones'),
(994, 'broken form'),
(995, 'Bronchitis Form'),
(996, 'Brother'),
(997, 'Brow'),
(998, 'Browse'),
(999, 'Browse for Record'),
(1000, 'Bruising/haematoma'),
(1001, 'Build Your Plan'),
(1002, 'Bulgarian'),
(1003, 'Bulging Right:'),
(1004, 'Burmese'),
(1005, 'Burning with Urination'),
(1006, 'Burning With Urination'),
(1007, 'Business Associate Agreement'),
(1008, 'Business Phone'),
(1009, 'Busy'),
(1010, 'but not yet processed.'),
(1011, 'Buttock'),
(1012, 'Buttock + S.I.'),
(1013, 'by'),
(1014, 'By'),
(1015, 'By default the User Memberships section is selected and all the active registered users will be listed in alphabetical order by their user names.'),
(1016, 'by mouth'),
(1017, 'By/Source'),
(1018, 'By:'),
(1019, 'by{{made by/manufacturer}}'),
(1020, 'B{{both sides}}'),
(1021, 'C'),
(1022, 'CA Certificate for verifying the RFC 5425 TLS syslog server.'),
(1023, 'Cache Lifetime (in seconds)'),
(1024, 'Cache template output?'),
(1025, 'Caffeine'),
(1026, 'Caffeine consumption'),
(1027, 'Calendar'),
(1028, 'Calendar Ending Hour'),
(1029, 'Calendar Interval'),
(1030, 'Calendar Screen'),
(1031, 'Calendar Settings'),
(1032, 'Calendar Settings (calendar)'),
(1033, 'Calendar Starting Hour'),
(1034, 'Calendar UI'),
(1035, 'Calendar View'),
(1036, 'calendar_external to events'),
(1037, 'Call Back Notes'),
(1038, 'Call to addForm() goes here.<br>'),
(1039, 'Callback'),
(1040, 'Callback Performed'),
(1041, 'Callback requested'),
(1042, 'Calories'),
(1043, 'Cambodian'),
(1044, 'CAMOS'),
(1045, 'Can not determine OS!'),
(1046, 'Can not set this unless the Summary of Care Sent toggle is set.'),
(1047, 'Can\'t find file!'),
(1048, 'Can\'t upload'),
(1049, 'Canada'),
(1050, 'Cancel'),
(1051, 'cancel'),
(1052, 'Cancel Changes'),
(1053, 'Canceled'),
(1054, 'Canceled < 24h'),
(1055, 'Cancer'),
(1056, 'Cancer Screening: Colon Cancer Screening'),
(1057, 'Cancer Screening: Mammogram'),
(1058, 'Cancer Screening: Pap Smear'),
(1059, 'Cancer Screening: Prostate Cancer Screening'),
(1060, 'Cannot add this entry because it already exists!'),
(1061, 'Cannot add/update this entry because a duplicate already exists!'),
(1062, 'cannot be archived, ignored'),
(1063, 'cannot be converted to JPEG. Perhaps ImageMagick is not installed?'),
(1064, 'cannot be deleted, ignored'),
(1065, 'cannot be displayed inline because its type is not supported by the browser.'),
(1066, 'cannot be displayed inline becuase its type is not supported by the browser'),
(1067, 'cannot be displayed inline becuase its type is not supported by the browser.'),
(1068, 'Cannot create'),
(1069, 'Cannot create file'),
(1070, 'Cannot delete (from SFTP server) file'),
(1071, 'Cannot delete file'),
(1072, 'Cannot determine a destination filename'),
(1073, 'Cannot find '),
(1074, 'Cannot find a destination filename'),
(1075, 'Cannot find a skip source field for'),
(1076, 'Cannot find a skip target field for'),
(1077, 'Cannot find patient from SQL-Ledger customer id'),
(1078, 'Cannot find postscript document reference in '),
(1079, 'Cannot find provider from SQL-Ledger employee = '),
(1080, 'Cannot Modify Payments.Undistributed is Negative.'),
(1081, 'Cannot open'),
(1082, 'Cannot open '),
(1083, 'Cannot Post for Insurance.The Paying Entity selected is Patient.'),
(1084, 'Cannot Post for Patient.The Paying Entity selected is Insurance.'),
(1085, 'Cannot Post Payments.Undistributed is Negative.'),
(1086, 'Cannot read'),
(1087, 'Cannot read directory'),
(1088, 'Cannot update because you are not editing an existing entry!'),
(1089, 'Capitalize'),
(1090, 'Capitalize all'),
(1091, 'capsule'),
(1092, 'Card'),
(1093, 'Card CVV'),
(1094, 'Card Expiry Date'),
(1095, 'Card Name'),
(1096, 'Card Number'),
(1097, 'Card Type'),
(1098, 'Cardiac'),
(1099, 'Cardiac Catheterization'),
(1100, 'Cardiac Echo'),
(1101, 'Cardiovascular'),
(1102, 'Care Coordination'),
(1103, 'Care Coordination Only'),
(1104, 'Care giver'),
(1105, 'Care Plan'),
(1106, 'Care Plan Form'),
(1107, 'Care Team'),
(1108, 'Carotid Bruit'),
(1109, 'Carotid{{carotid arteries}}'),
(1110, 'Cartilage / chondral / disc damage'),
(1111, 'Cartilage injury'),
(1112, 'Cartoid pulsations nl, pedal pulses nl'),
(1113, 'CAR{{carotid arteries}}'),
(1114, 'cash'),
(1115, 'Cash'),
(1116, 'Cash Rec'),
(1117, 'Cash Receipts by Provider'),
(1118, 'Catalan- Valencian'),
(1119, 'Cataract'),
(1120, 'Cataract Surgery'),
(1121, 'Cataracts'),
(1122, 'Categories'),
(1123, 'Categories for'),
(1124, 'Category'),
(1125, 'category'),
(1126, 'Category '),
(1127, 'Category changed.'),
(1128, 'Category Color Schema'),
(1129, 'Category Details'),
(1130, 'Category Limits'),
(1131, 'Category Name'),
(1132, 'Category name is empty'),
(1133, 'Category/Title'),
(1134, 'Caucasian'),
(1135, 'Causes Receipts to Print Encounter/Primary Provider Info'),
(1136, 'cc Distance{{with correction at distance}}'),
(1137, 'cc Near{{with correction at Near}}'),
(1138, 'CCD'),
(1139, 'CCDA'),
(1140, 'ccDist{{ACT with Correction Distance}}'),
(1141, 'ccDist{{with correction distance}}'),
(1142, 'ccNear{{ACT with Correction Near}}'),
(1143, 'ccNear{{with correction at near}}'),
(1144, 'CCR'),
(1145, 'CCR Approve'),
(1146, 'CCR Patient Review'),
(1147, 'CCR Review and Approve'),
(1148, 'CC{{Chief Complaint}}'),
(1149, 'cc{{with correction}}'),
(1150, 'CC{{with correction}}'),
(1151, 'CDC Code'),
(1152, 'CDC-NIP Code'),
(1153, 'CDR'),
(1154, 'CDR Reports Processing Priority'),
(1155, 'Cell'),
(1156, 'Cell Phone'),
(1157, 'Cell phone number'),
(1158, 'Cell Phone Number'),
(1159, 'Central Certification'),
(1160, 'Central Macular Thickness'),
(1161, 'Central/South American'),
(1162, 'Certificate Authority crt file location cannot be empty'),
(1163, 'Certificate Authority key file location cannot be empty'),
(1164, 'Certificate to send to RFC 5425 TLS syslog server.'),
(1165, 'Certificate User'),
(1166, 'Certificates'),
(1167, 'Chamorro'),
(1168, 'ChampUS'),
(1169, 'ChampUSVA'),
(1170, 'change'),
(1171, 'Change'),
(1172, 'Change Activity'),
(1173, 'Change any item available and when ready click Send for review. The changes will be flagged and staff notified to review changes before commiting them to chart. During the time period before changes are reviewed the Revised button will show Pending and profile data is still available for changes. When accessing profile in pending state all previous edits will appear in Blue and current chart values in Red. You may revert any edit to chart value by clicking that red item (or vica versa) but remember that when you click Send for Review then items that populate the field items are the ones that are sent. Revert Edits button changes everything back to chart values and you may make changes from there. So to recap: Items in BLUE are patient edits with items in RED being original values before any edits.'),
(1174, 'Change failed! CouchDB connect error?'),
(1175, 'Change in Vision'),
(1176, 'Change In Vision'),
(1177, 'Change Password'),
(1178, 'Change Status for'),
(1179, 'Changed'),
(1180, 'Changed Bowel'),
(1181, 'Changing patient ID for document'),
(1182, 'Channels'),
(1183, 'Characteristics'),
(1184, 'Characters Remaining'),
(1185, 'Charge'),
(1186, 'Charge adjustment'),
(1187, 'Charge Coded'),
(1188, 'Charge Total'),
(1189, 'Charges'),
(1190, 'Chart'),
(1191, 'Chart Activity'),
(1192, 'Chart Check-in/out Activity Report'),
(1193, 'Chart ID'),
(1194, 'Chart ID:'),
(1195, 'Chart Label'),
(1196, 'Chart Location Activity'),
(1197, 'Chart Note'),
(1198, 'Chart Number'),
(1199, 'Chart pulled'),
(1200, 'Chart Storage Locations'),
(1201, 'Chart Tracker'),
(1202, 'Chart Trk'),
(1203, 'Charts Checked Out'),
(1204, 'Charts Out'),
(1205, 'Chat'),
(1206, 'Chat history'),
(1207, 'Chechen'),
(1208, 'Check'),
(1209, 'check'),
(1210, 'Check All'),
(1211, 'Check All - Components'),
(1212, 'Check Amount'),
(1213, 'Check Date'),
(1214, 'Check expiration dates.'),
(1215, 'Check for differences of translations with custom language table.'),
(1216, 'Check if you plan to print postcards locally'),
(1217, 'Check if you plan to send postcards via MedEx'),
(1218, 'Check if you plan to use Avery Labels for Reminders or Recalls'),
(1219, 'Check In'),
(1220, 'Check In To'),
(1221, 'Check Input Data'),
(1222, 'Check items to graph'),
(1223, 'Check Lab Results'),
(1224, 'Check mark indicates reviewed'),
(1225, 'Check No'),
(1226, 'Check Number'),
(1227, 'Check Out'),
(1228, 'Check Out Time'),
(1229, 'Check Payment'),
(1230, 'Check the box if this is an encrypted file'),
(1231, 'Check this if you want providers to see all appointments by default and not just their own.'),
(1232, 'Check to create problem from this diagnosis'),
(1233, 'Check/EOB Date:'),
(1234, 'Check/EOB No.:'),
(1235, 'Check/Ref Number'),
(1236, 'Check/Reference Number'),
(1237, 'Checkbox list'),
(1238, 'checkbox list'),
(1239, 'checkbox w/ text'),
(1240, 'Checkbox w/text'),
(1241, 'Checkbox(es)'),
(1242, 'Checkboxes above indicate if you want to reject and delete the HL7 file.'),
(1243, 'Checkboxes w/text'),
(1244, 'Checked'),
(1245, 'checked'),
(1246, 'Checked box = yes ,  empty = no'),
(1247, 'Checked Drug Formulary?'),
(1248, 'Checked Out'),
(1249, 'Checked out'),
(1250, 'Checking the Groups and Access Controls checkbox will reveal this section that lists all the categories with sub-categories (ACOs), i.e. the parts of the program controlled by the access control list privileges.'),
(1251, 'Checking the lock checkbox will prevent any futher edits on any forms in this encounter.'),
(1252, 'Checkout'),
(1253, 'Checksum'),
(1254, 'Chest'),
(1255, 'Chest CTAB'),
(1256, 'Chest Pain'),
(1257, 'Chest Pain:'),
(1258, 'Chest Pains'),
(1259, 'Chest physician'),
(1260, 'Chg'),
(1261, 'Chichewa- Chewa- Nyanja'),
(1262, 'Chief Complaint'),
(1263, 'Chief Complaint 2'),
(1264, 'Chief Complaint 3'),
(1265, 'Child'),
(1266, 'Child in-law'),
(1267, 'Childhood immunization Status (CQM)'),
(1268, 'Chills'),
(1269, 'Chinese'),
(1270, 'Chinese (Simplified)'),
(1271, 'Chinese (Traditional)'),
(1272, 'Chiropractic'),
(1273, 'Choices'),
(1274, 'Cholecystectomy'),
(1275, 'cholecystectomy'),
(1276, 'Cholecystestomy'),
(1277, 'Choose'),
(1278, 'choose'),
(1279, 'Choose a period or dates (YYYY-MM-DD)'),
(1280, 'Choose a section and click an item within it; then in the other section you will see the related items highlighted, and you can click in that section to add and delete relationships.'),
(1281, 'Choose Criteria'),
(1282, 'Choose CSV table'),
(1283, 'Choose Download or Display Inline'),
(1284, 'Choose File'),
(1285, 'Choose from list'),
(1286, 'Choose Layout Direction'),
(1287, 'Choose list'),
(1288, 'Choose one of the four return values that reflect varying degrees of privilege.'),
(1289, 'Choose Paper Size'),
(1290, 'Choose Patient'),
(1291, 'Choose PDF languange Preference'),
(1292, 'Choose print format for this encounter report.'),
(1293, 'Choose the layout (need to logout and then login to see this new setting).'),
(1294, 'Choose your default encounter view'),
(1295, 'Chronic Bronchitis'),
(1296, 'Chronic Joint Pain'),
(1297, 'Chronic Kidney Disease (CKD)'),
(1298, 'Chronic or Inactive Problems'),
(1299, 'Chronic Problems'),
(1300, 'Chronic synovitis / effusion / joint pain / gout'),
(1301, 'Chronic/Inactive Problems'),
(1302, 'Chronic/Recurrent'),
(1303, 'Chuvash'),
(1304, 'Cigs'),
(1305, 'Cirrhosis of the Liver'),
(1306, 'Cirrhosis Of The Liver'),
(1307, 'City'),
(1308, 'City Name'),
(1309, 'City, State'),
(1310, 'City, State Zip'),
(1311, 'City/State'),
(1312, 'Claim'),
(1313, 'Claim '),
(1314, 'Claim Edit'),
(1315, 'Claim Status'),
(1316, 'Claim test has completed running'),
(1317, 'Claim Type'),
(1318, 'Claim was generated to file'),
(1319, 'Claim was generated to file '),
(1320, 'Claims'),
(1321, 'Classification'),
(1322, 'Clear'),
(1323, 'clear'),
(1324, 'CLEAR ACTIVE PATIENT'),
(1325, 'CLEAR ACTIVE THERAPY GROUP'),
(1326, 'Clear All'),
(1327, 'Clear Filters'),
(1328, 'Clear history'),
(1329, 'Clear HL7 Data'),
(1330, 'Clear Justification'),
(1331, 'Clear Pad'),
(1332, 'Clear Signature'),
(1333, 'Clear Smarty Cache'),
(1334, 'Clearing house info required for EDI 270 batch creation.'),
(1335, 'CLIA Number'),
(1336, 'Click'),
(1337, 'Click \'export\' to export your Category, Subcategory, Item, Content data to a text file. Any resemblance of this file to an XML file is purely coincidental. The opening and closing tags must be on the same line, they must be lowercase with no spaces. To import, browse for a file and click \'import\'. If the data is completely different, it will merge with your existing data. If there are similar item names, The old one will be kept and the new one saved with a number added to the end.'),
(1338, 'Click a spot on the graphic to add a new annotation, click it again to remove it'),
(1339, 'Click Download Certificate to download the certificates in the file ssl.zip'),
(1340, 'click for more'),
(1341, 'Click for more details'),
(1342, 'Click for order summary'),
(1343, 'Click for results'),
(1344, 'Click for Shorthand Help.'),
(1345, 'Click here'),
(1346, 'Click Here to add a new patient.'),
(1347, 'Click here to add new injury change status and edit daily activity'),
(1348, 'Click here to add new row'),
(1349, 'Click here to choose a date'),
(1350, 'Click here to choose a date and time'),
(1351, 'Click here to choose a start date'),
(1352, 'Click here to choose date time'),
(1353, 'Click here to choose date time from'),
(1354, 'Click here to choose date time to'),
(1355, 'Click Here to Configure This module'),
(1356, 'Click here to delete the row'),
(1357, 'Click Here to Disable This module'),
(1358, 'Click here to duplicate the row'),
(1359, 'Click here to edit list of available Lens Materials'),
(1360, 'Click here to edit list of available Lens Treatment Options'),
(1361, 'Click here to Edit the Contact Lens Brand List'),
(1362, 'Click here to Edit the Course/Occurrence List'),
(1363, 'Click here to Edit the Manufacter List'),
(1364, 'Click here to Edit the Supplier List'),
(1365, 'Click here to Edit this Doctor\'s Plan options'),
(1366, 'Click here to Edit this Doctor\'s Quick Pick list'),
(1367, 'Click here to Edit this Provider\'s Exam Default values'),
(1368, 'Click Here to Enable This module'),
(1369, 'Click Here to Install This module'),
(1370, 'click here to search'),
(1371, 'Click here to see observation results'),
(1372, 'click here to update priority, category and nickname settings'),
(1373, 'click here to update priority, category, nickname and access control settings'),
(1374, 'Click here to view all.'),
(1375, 'Click here to view and graph'),
(1376, 'Click here to view and graph all labdata.'),
(1377, 'Click here to view and graph all vitals.'),
(1378, 'Click here to view patient details'),
(1379, 'Click here to view them all.'),
(1380, 'Click here to view/edit more details'),
(1381, 'Click in signature on file'),
(1382, 'Click Install button to install database release from the following date'),
(1383, 'Click OK if you are sure.'),
(1384, 'Click OK to Clear or Cancel to continue processing.'),
(1385, 'Click on any of the time parts to increase it'),
(1386, 'Click on the \'Add Group\' button to create this new group (ARO).'),
(1387, 'Click on the icon next to the \'Access Control List Administration\' title to go to the phpGACL page.'),
(1388, 'Click on the the following link to learn more about what is involved.'),
(1389, 'Click Patient Name to Open Patient File'),
(1390, 'Click Refresh to view all results, or please input search criteria above to view specific results.'),
(1391, 'Click the \'Add New Group\' button to display the \'New Group Information\' section.'),
(1392, 'Click the \'Delete Group\' button to completely remove this group.'),
(1393, 'Click the \'Remove Group\' button to display the \'Remove Group Form\'.'),
(1394, 'Click the \'Yes\' radio button.'),
(1395, 'Click the pencil icon to grant and remove access privileges to the selected user'),
(1396, 'Click the slashed-eye icon to close.'),
(1397, 'Click this to display/hide additional tests'),
(1398, 'Click to add a diagnosis'),
(1399, 'Click to add new components'),
(1400, 'Click to add new consultation'),
(1401, 'Click to choose diagnoses to justify.'),
(1402, 'Click to display shorthand field names.'),
(1403, 'Click to download'),
(1404, 'Click to edit'),
(1405, 'Click to edit description'),
(1406, 'Click to edit this event'),
(1407, 'Click to generate the report'),
(1408, 'Click to Hide'),
(1409, 'Click to make chat this current recipient only...'),
(1410, 'Click to manually configure access control, recommended for advanced users'),
(1411, 'Click to match patient'),
(1412, 'Click to print'),
(1413, 'Click to receive (add) new lot'),
(1414, 'Click to select'),
(1415, 'Click To Select'),
(1416, 'Click to select an industry-standard code for this procedure'),
(1417, 'Click to select group'),
(1418, 'Click to select optional procedure code'),
(1419, 'Click to select or change coding'),
(1420, 'Click to select or change CVX code'),
(1421, 'Click to select or change diagnoses'),
(1422, 'Click to select or change service codes'),
(1423, 'Click to select patient'),
(1424, 'Click to select related code'),
(1425, 'Click to select services to perform if this result is abnormal'),
(1426, 'Click to select the desired procedure'),
(1427, 'Click to Show'),
(1428, 'Click to sort'),
(1429, 'Click to view'),
(1430, 'Click to view or edit'),
(1431, 'Click to view/edit'),
(1432, 'Click Upgrade button to upgrade database release from the following date'),
(1433, 'Click where indicated above to match the patient.'),
(1434, 'Click:'),
(1435, 'Clicking on the icon next to their name will bring up the \'Edit\' window.'),
(1436, 'Clicking Options will present a multiselection drop menu to add behaviors to the selected data type. Typing after pull down activates allows search in options.'),
(1437, 'Client Certificate Expiration Days'),
(1438, 'Client certificate validation period'),
(1439, 'Client certificate validity should be a valid number.'),
(1440, 'Client Copy'),
(1441, 'Client ID'),
(1442, 'Client medical history summary'),
(1443, 'Client Name'),
(1444, 'Client Number'),
(1445, 'Client Profile - New Clients'),
(1446, 'Client Profile - Unique Clients'),
(1447, 'Clients'),
(1448, 'Clinic'),
(1449, 'Clinic Copy'),
(1450, 'Clinic Daily Record'),
(1451, 'Clinic ID'),
(1452, 'Clinical'),
(1453, 'Clinical Decision Rules Alert Manager'),
(1454, 'Clinical History'),
(1455, 'Clinical Instructions'),
(1456, 'Clinical Instructions Form'),
(1457, 'Clinical Plans'),
(1458, 'Clinical Quality Measures (CQM)'),
(1459, 'Clinical Quality Measures (CQM) - 2011'),
(1460, 'Clinical Quality Measures (CQM) - 2014'),
(1461, 'Clinical Reminders'),
(1462, 'Clinical Reminders/Alerts (write,addonly optional)'),
(1463, 'Clinical Reports'),
(1464, 'Clinical Rule Action Category'),
(1465, 'Clinical Rule Action Item'),
(1466, 'Clinical Rule Filter Methods'),
(1467, 'Clinical Rule Target Methods'),
(1468, 'Clinical Rules'),
(1469, 'Clinical Rules Age Intervals'),
(1470, 'Clinical Rules Comparisons'),
(1471, 'Clinical Rules Encounter Types'),
(1472, 'Clinical Rules Reminder Due Options'),
(1473, 'Clinical Rules Reminder Inactivation Options'),
(1474, 'Clinical Rules Reminder Intervals'),
(1475, 'Clinical Rules Reminder Methods'),
(1476, 'Clinical Rules Target Intervals'),
(1477, 'Clinical targets'),
(1478, 'Clinical Term'),
(1479, 'Clinical Term Code(s)'),
(1480, 'Clinical View'),
(1481, 'Clinicians'),
(1482, 'Clone'),
(1483, 'Clone Past Visit'),
(1484, 'Close'),
(1485, 'close'),
(1486, 'Close All Current Rx Panels and make this a Preference to stay closed'),
(1487, 'Close and make this a Preference to stay closed'),
(1488, 'Close this panel and delete this Rx'),
(1489, 'Close this panel and make this a Preference to stay closed'),
(1490, 'Close Window'),
(1491, 'close window'),
(1492, 'Close...'),
(1493, 'Closed'),
(1494, 'cm'),
(1495, 'CMS 1500 incl FORM'),
(1496, 'CMS 1500 Margins'),
(1497, 'CMS 1500 Paper Form Format'),
(1498, 'CMS 1500 PDF'),
(1499, 'CMS 1500 PREPRINTED FORM'),
(1500, 'CMS 1500 TEXT'),
(1501, 'CMS 1500: Box 31 Format'),
(1502, 'CMS 1500: Date in Box 31 (Signature)'),
(1503, 'CMS ID'),
(1504, 'CMS ID For Encounter Claims'),
(1505, 'CMS Portal'),
(1506, 'CMS Portal Login'),
(1507, 'CMS Portal Login ID'),
(1508, 'CMS Portal not enabled!'),
(1509, 'CMS Portal Password'),
(1510, 'CMS Portal Request'),
(1511, 'CMS Portal Site Address'),
(1512, 'CMS Portal Username'),
(1513, 'Cmsportal Login'),
(1514, 'CMT{{Central Macular Thickness}}'),
(1515, 'CN VII{{cranial nerve seven}}'),
(1516, 'CN V{{cranial nerve five}}'),
(1517, 'CN2-12 intact'),
(1518, 'CN5{{cranial nerve five}}'),
(1519, 'CN7{{cranial nerve seven}}'),
(1520, 'Co Pay'),
(1521, 'Co Pay Paid'),
(1522, 'Co-managing/referring provider'),
(1523, 'CO-PAY'),
(1524, 'Co-Payment'),
(1525, 'Code'),
(1526, 'code'),
(1527, 'Code Finder'),
(1528, 'Code must be two letter lowercase'),
(1529, 'Code or symbol to indicate currency'),
(1530, 'Code Text'),
(1531, 'Code Type'),
(1532, 'code type'),
(1533, 'Code type not recognized'),
(1534, 'Code type not yet defined'),
(1535, 'Code Types'),
(1536, 'Code(s)'),
(1537, 'Coded'),
(1538, 'Codes'),
(1539, 'Coding'),
(1540, 'Coding (click for education)'),
(1541, 'Coding - any encounters (write,wsome optional)'),
(1542, 'Coding - any encounters (write,wsome optional) (coding_a)'),
(1543, 'Coding - my encounters (write,wsome optional)'),
(1544, 'Coding - my encounters (write,wsome optional) (coding)'),
(1545, 'Coding complete'),
(1546, 'Coding done'),
(1547, 'Coding Engine'),
(1548, 'Coding not authorized'),
(1549, 'Coffee'),
(1550, 'Coffee Use'),
(1551, 'Coins'),
(1552, 'Coinsurance'),
(1553, 'Coll w/o'),
(1554, 'Collaborator'),
(1555, 'Collapse'),
(1556, 'collapse'),
(1557, 'Collapse All'),
(1558, 'Collapse all'),
(1559, 'collapse all'),
(1560, 'Collected'),
(1561, 'Collection Date'),
(1562, 'Collections'),
(1563, 'Collections Report'),
(1564, 'Colon Cancer'),
(1565, 'Colon Cancer Screening'),
(1566, 'Colon Cancer Surgery'),
(1567, 'Colonoscopy'),
(1568, 'colonoscopy'),
(1569, 'Color'),
(1570, 'Color for even sets (except when last set is even and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(1571, 'Color for odd sets (except when last set is odd and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(1572, 'Color for the last set when all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed).'),
(1573, 'Color for the last set when not all member appointments are displayed.'),
(1574, 'Color Vision'),
(1575, 'Color:Abbr'),
(1576, 'Column'),
(1577, 'Columns'),
(1578, 'Combine Reminders'),
(1579, 'Combining Lots'),
(1580, 'Comma'),
(1581, 'Comment'),
(1582, 'Comments'),
(1583, 'Comments for this result or recommendation'),
(1584, 'Commercial Insurance Co.'),
(1585, 'Commit Changes'),
(1586, 'Communication'),
(1587, 'Communication Engine'),
(1588, 'Communications'),
(1589, 'Community health physician'),
(1590, 'Community Mental Health Center'),
(1591, 'Company'),
(1592, 'Company Name'),
(1593, 'Complete'),
(1594, 'Complete Visit Time'),
(1595, 'Completed'),
(1596, 'completed'),
(1597, 'Completed Ad'),
(1598, 'Completed?'),
(1599, 'Completely remove the ability to display the Patient Flow Board.'),
(1600, 'Completion Status'),
(1601, 'Complications by Service Provider'),
(1602, 'Complications of Abortion'),
(1603, 'Components'),
(1604, 'Compose Message'),
(1605, 'Compose new'),
(1606, 'Comprehensive Inpatient Rehabilitation Facility'),
(1607, 'Comprehensive Outpatient Rehabilitation Facility'),
(1608, 'Computer Aided Medical Ordering System'),
(1609, 'Conclusions'),
(1610, 'Condition'),
(1611, 'Condition field not found'),
(1612, 'Condition Status'),
(1613, 'Config'),
(1614, 'Configuration'),
(1615, 'Configuration Export/Import'),
(1616, 'Configuration saved successfully'),
(1617, 'Configure Apache and OpenEMR to use Client side SSL certificates.'),
(1618, 'Configure Apache to use Client side SSL certificates'),
(1619, 'Configure Apache to use HTTPS.'),
(1620, 'Configure Openemr to use Client side SSL certificates'),
(1621, 'Configure tracks'),
(1622, 'Configure Tracks'),
(1623, 'Confirm'),
(1624, 'Confirm Create New Patient'),
(1625, 'Confirm Email Address'),
(1626, 'Confirm New Password'),
(1627, 'Confirm Payment'),
(1628, 'Confirm to Delete Current Thread?'),
(1629, 'Confirm to Delete Selected?'),
(1630, 'Confirmed'),
(1631, 'Conflicted Allergies'),
(1632, 'Conflicted Medications'),
(1633, 'Conflicted Problems'),
(1634, 'Congenital'),
(1635, 'Conjuntiva, pupils'),
(1636, 'Conj{{Conjunctiva}}'),
(1637, 'Connection error'),
(1638, 'Connectors'),
(1639, 'Constant'),
(1640, 'constant name'),
(1641, 'Constant name is blank'),
(1642, 'constants'),
(1643, 'Constipation'),
(1644, 'Constitutional'),
(1645, 'Construction Firm'),
(1646, 'Consultant physician'),
(1647, 'Consultation Brief Description'),
(1648, 'Contact'),
(1649, 'Contact Email'),
(1650, 'Contact Email Address'),
(1651, 'Contact EMR Direct to subscribe to the phiMail Direct messaging service'),
(1652, 'contact info'),
(1653, 'Contact Lens'),
(1654, 'Contact Lens Refraction'),
(1655, 'Contact Lenses'),
(1656, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.'),
(1657, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service'),
(1658, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing to the NewCrop eRx service.'),
(1659, 'Contact mi-squared at http://www.mi-squared.com/products-services/openemr/ or ZH Healthcare at https://blueehr.com/contact-us/ for subscribing to the NewCrop eRx service.'),
(1660, 'Contact name'),
(1661, 'Contact Open Med Practice, www.openmedpractice.com for subscribing to the Weno Free eRx service.'),
(1662, 'Contact or Notify Phone'),
(1663, 'Contact Person'),
(1664, 'Contact Phone'),
(1665, 'Contact Phone Number'),
(1666, 'Contact Relationship'),
(1667, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service'),
(1668, 'Contacts'),
(1669, 'contain at least three of the four following items:'),
(1670, 'Container Group Name'),
(1671, 'Content'),
(1672, 'content'),
(1673, 'Contents'),
(1674, 'Context'),
(1675, 'Context name can\'t be empty'),
(1676, 'Continue'),
(1677, 'Continuity of Care Document (CCD)'),
(1678, 'Continuity of Care Record (CCR)'),
(1679, 'Contra Clients'),
(1680, 'Contraception'),
(1681, 'Contraception Issues'),
(1682, 'Contraceptive Complication (specify)'),
(1683, 'Contraceptive Method'),
(1684, 'Contraceptive Products'),
(1685, 'Contraceptive services previously started'),
(1686, 'Contraceptives Start'),
(1687, 'Contrast Acuity'),
(1688, 'Contrast Acuity Testing'),
(1689, 'Contrastart'),
(1690, 'Contrast{{Constrast Visual Acuity}}'),
(1691, 'Control ID'),
(1692, 'Control No.'),
(1693, 'Controlled Substance?'),
(1694, 'Convergence'),
(1695, 'Convergence Amps'),
(1696, 'Conversation'),
(1697, 'Convert a JavaScript object into a JSON string, and send it to the server.'),
(1698, 'Convert between plus and minus cylinder'),
(1699, 'Coordinating Counselors'),
(1700, 'COPAY'),
(1701, 'Copay'),
(1702, 'CoPay'),
(1703, 'Copay not positive'),
(1704, 'Copay Paid'),
(1705, 'Copays'),
(1706, 'COPD'),
(1707, 'Copy Pages to Patient Chart'),
(1708, 'Copy these values into current visit.'),
(1709, 'Copy Values'),
(1710, 'Copying the database file. This will take some time...'),
(1711, 'Copyright Notice'),
(1712, 'Cor Disease'),
(1713, 'Core'),
(1714, 'Cornea'),
(1715, 'Cornish'),
(1716, 'Coronary Artery Bypass'),
(1717, 'Coronary Artery Bypass Graft (CABG)'),
(1718, 'Corrected'),
(1719, 'Corsican'),
(1720, 'CouchDB'),
(1721, 'CouchDB Connection Failed.'),
(1722, 'CouchDB Database'),
(1723, 'CouchDB database name'),
(1724, 'CouchDB host'),
(1725, 'CouchDB HostName'),
(1726, 'CouchDB Log Enable'),
(1727, 'CouchDB Password'),
(1728, 'CouchDB Port'),
(1729, 'CouchDB port'),
(1730, 'CouchDB save failed'),
(1731, 'CouchDB UserName'),
(1732, 'Cough'),
(1733, 'Cough:'),
(1734, 'could not connect to server'),
(1735, 'Could not find RxNorm Table! Please install.'),
(1736, 'Could not import the document. Please contact the EMR vendor.'),
(1737, 'could not open table'),
(1738, 'Could not read file'),
(1739, 'Could not read the file'),
(1740, 'Could not send email due to a server problem, '),
(1741, 'Could not send email due to a server problem.'),
(1742, 'Could not send email due to a server problem. '),
(1743, 'Couldn\'t create backup dir:'),
(1744, 'Couldn\'t remove dir:'),
(1745, 'Couldn\'t remove old backup file:'),
(1746, 'Couldn\'t remove old export file: '),
(1747, 'Coumadin Management - INR Monitoring'),
(1748, 'Couns by Method'),
(1749, 'Counseling'),
(1750, 'Counseling activities'),
(1751, 'Counselors'),
(1752, 'Counter Referral Form'),
(1753, 'COUNTER REFERRAL FORM'),
(1754, 'Counter-Referral'),
(1755, 'Country'),
(1756, 'Country Code'),
(1757, 'Country Data Type'),
(1758, 'Country list'),
(1759, 'Country List (write,addonly optional)'),
(1760, 'Country List (write,addonly optional) (country)'),
(1761, 'Country Name should be represent in two letters. (Example: United States is US)'),
(1762, 'county'),
(1763, 'County'),
(1764, 'Coupon'),
(1765, 'Course'),
(1766, 'Cousin'),
(1767, 'CPOE'),
(1768, 'CPT'),
(1769, 'CPT Code'),
(1770, 'CPT Codes'),
(1771, 'CPT4 Procedure/Service'),
(1772, 'CPTII Performance Measures'),
(1773, 'CQM'),
(1774, 'Crackles:'),
(1775, 'Cranial Nerve 5: Trigeminal Nerve'),
(1776, 'Cranial Nerve 7: Facial Nerve'),
(1777, 'cream'),
(1778, 'Create a Client side SSL certificate for each user or client machine.'),
(1779, 'Create a client side SSL certificate for either a user or a client hostname.'),
(1780, 'Create a new track'),
(1781, 'Create a reminder to schedule a future visit'),
(1782, 'Create an Event'),
(1783, 'Create and download a full backup'),
(1784, 'Create and modify tracks'),
(1785, 'Create Backup'),
(1786, 'Create batch'),
(1787, 'Create Client Certificate'),
(1788, 'Create Client side SSL certificates'),
(1789, 'Create custom white list of MIME content type of a files to secure your documents system'),
(1790, 'Create Date'),
(1791, 'Create Duplicate'),
(1792, 'Create Encounter'),
(1793, 'Create Eventlog Backup'),
(1794, 'Create new issue'),
(1795, 'Create New Patient'),
(1796, 'Create new Track'),
(1797, 'Create Offsite Portal Credentials'),
(1798, 'Create Onsite Portal Credentials'),
(1799, 'Create Patient Note'),
(1800, 'Create the SSL Certificate Authority and Server certificates.'),
(1801, 'Create Visit'),
(1802, 'Created'),
(1803, 'Creating anyway'),
(1804, 'Creating export file'),
(1805, 'Creating new track failed'),
(1806, 'Creating this file on remote host failed'),
(1807, 'Creator'),
(1808, 'credit'),
(1809, 'Credit Card'),
(1810, 'Credits'),
(1811, 'Cree'),
(1812, 'Criteria'),
(1813, 'Croatian'),
(1814, 'Crohn\'s Disease'),
(1815, 'Crohns Disease'),
(1816, 'CR{{Cycloplegic Refraction}}'),
(1817, 'CSV'),
(1818, 'CSV Export'),
(1819, 'CSV File'),
(1820, 'CSV Tables'),
(1821, 'CSV to calendar_external table'),
(1822, 'CTL{{Contact Lens Vision}}'),
(1823, 'CTL{{Contact Lens}}'),
(1824, 'CU.MM'),
(1825, 'Cuban'),
(1826, 'Cup'),
(1827, 'Currency Decimal Places'),
(1828, 'Currency Decimal Point Symbol'),
(1829, 'Currency Designator'),
(1830, 'Currency Thousands Separator'),
(1831, 'Current'),
(1832, 'Current Alcohol'),
(1833, 'Current Consultation'),
(1834, 'Current Criteria'),
(1835, 'Current day highlight color'),
(1836, 'Current every day smoker'),
(1837, 'Current Eye Meds'),
(1838, 'Current file name was changed to'),
(1839, 'Current Glasses'),
(1840, 'Current Hash'),
(1841, 'Current Location'),
(1842, 'Current Logged in User'),
(1843, 'Current Medications'),
(1844, 'Current Password'),
(1845, 'Current Patient'),
(1846, 'Current patient unavailable here. Use Patient Documents'),
(1847, 'Current Provider'),
(1848, 'Current Pt Only'),
(1849, 'Current Recreational Drugs'),
(1850, 'Current RX'),
(1851, 'Current some day smoker'),
(1852, 'Current Status'),
(1853, 'Current Status Time'),
(1854, 'Current Target'),
(1855, 'Current user'),
(1856, 'Current Value'),
(1857, 'Currently Active'),
(1858, 'Currently Busy'),
(1859, 'Currently off-line'),
(1860, 'Currently Running'),
(1861, 'Currently there are no facilities.'),
(1862, 'Currently working on making this document'),
(1863, 'Cushing Syndrom'),
(1864, 'Cushing Syndrome'),
(1865, 'Custodial Care Facility'),
(1866, 'Custodian'),
(1867, 'Custom'),
(1868, 'Custom Billing Phone Number'),
(1869, 'Custom Greeting'),
(1870, 'Custom input?'),
(1871, 'Custom Statement message'),
(1872, 'Custom Table'),
(1873, 'Custom text for Flow Board postcards. After changing text, print samples before printing mass quantities!'),
(1874, 'CVV'),
(1875, 'Cvx Code'),
(1876, 'CVX Code'),
(1877, 'CVX Code Mapping'),
(1878, 'CVX Immunization'),
(1879, 'CV{{Cardiovascular}}'),
(1880, 'Cycle'),
(1881, 'Cyclo 1%'),
(1882, 'CycloMydril'),
(1883, 'Cycloplegic (Wet) Refraction'),
(1884, 'Cyl{{Cylinder}}'),
(1885, 'CYL{{Cylinder}}'),
(1886, 'CYP'),
(1887, 'CYP Factor'),
(1888, 'CYP Report'),
(1889, 'Czech'),
(1890, 'D'),
(1891, 'D&C'),
(1892, 'D&E'),
(1893, 'D&V Full OU{{Ductions and Versions full both eyes}}'),
(1894, 'D.O.B.'),
(1895, 'daily'),
(1896, 'Daily Record'),
(1897, 'Daily Report'),
(1898, 'Daily Summary Report'),
(1899, 'Danish'),
(1900, 'Dashboard'),
(1901, 'Data Alike is already in database, please change code and/or description'),
(1902, 'Data Alike is already in database, please change constant name'),
(1903, 'Data Cols'),
(1904, 'Data Enterer'),
(1905, 'Data Entry - Social Security Number'),
(1906, 'Data Error'),
(1907, 'Data from'),
(1908, 'Data integrity has been compromised'),
(1909, 'data of all encounters so far'),
(1910, 'Data Type'),
(1911, 'Database'),
(1912, 'Database is not installed.'),
(1913, 'Database name'),
(1914, 'Database Patch'),
(1915, 'Database Reporting'),
(1916, 'Database Reporting (database)'),
(1917, 'Database upgrade finished.'),
(1918, 'DataCols must be a number between 1 and 999'),
(1919, 'Date'),
(1920, 'DATE'),
(1921, 'Date & Time Administered'),
(1922, 'Date / Time'),
(1923, 'Date Administered'),
(1924, 'Date and time of sample collection'),
(1925, 'Date and time of this observation'),
(1926, 'Date and time of this report'),
(1927, 'Date and time that the sample was collected'),
(1928, 'Date Cannot be greater than Today'),
(1929, 'Date contraceptive services initially provided'),
(1930, 'Date Created'),
(1931, 'Date Deceased'),
(1932, 'Date Destroyed'),
(1933, 'Date Display Format'),
(1934, 'Date format for \"appointment end\" is not valid'),
(1935, 'Date format for \"appointment start\" is not valid'),
(1936, 'Date format for \"Next Appointment\" is not valid'),
(1937, 'Date format for \"not seen since\" is not valid'),
(1938, 'Date format for \"seen before\" is not valid'),
(1939, 'Date format for \"seen since\" is not valid'),
(1940, 'Date Immunization Information Statements Given'),
(1941, 'Date is missing for code '),
(1942, 'Date Master Criteria'),
(1943, 'Date of appointments'),
(1944, 'Date of appointments mm/dd/yyyy'),
(1945, 'Date of bank deposit yyyy-mm-dd'),
(1946, 'Date of Billing'),
(1947, 'Date of Birth'),
(1948, 'Date of birth'),
(1949, 'Date Of Birth'),
(1950, 'Date of Birth and Age'),
(1951, 'Date of Entry'),
(1952, 'Date of exit'),
(1953, 'Date of Injury'),
(1954, 'Date of Onset'),
(1955, 'Date of onset or hospitalization'),
(1956, 'Date of onset, surgery or start of medication'),
(1957, 'Date of payment yyyy-mm-dd'),
(1958, 'Date of recovery or end of medication'),
(1959, 'Date of referral'),
(1960, 'Date of registration'),
(1961, 'Date of reply'),
(1962, 'Date of Report'),
(1963, 'Date of Service'),
(1964, 'Date of service'),
(1965, 'Date Of Service'),
(1966, 'Date of Service = Today'),
(1967, 'Date of service mm/dd/yyyy'),
(1968, 'Date of Service:'),
(1969, 'Date Of Signature'),
(1970, 'Date of Status Change'),
(1971, 'Date of this letter'),
(1972, 'Date of this order'),
(1973, 'Date of this report'),
(1974, 'Date of VIS Statement'),
(1975, 'Date Ordered'),
(1976, 'Date Range'),
(1977, 'Date Selector'),
(1978, 'Date selector'),
(1979, 'Date Sent'),
(1980, 'Date The Message Was Sent'),
(1981, 'Date Time'),
(1982, 'Date values Cannot be Blank.'),
(1983, 'Date VIS Presented'),
(1984, 'Date VIS Published'),
(1985, 'Date/Appt'),
(1986, 'Date/Notes'),
(1987, 'Date/Notes of Last'),
(1988, 'Date/Time'),
(1989, 'Date:'),
(1990, 'dated'),
(1991, 'Dated Message Log'),
(1992, 'Dated reminders maximum alerts to show'),
(1993, 'Day'),
(1994, 'day'),
(1995, 'Day Sheet Report'),
(1996, 'Day View'),
(1997, 'Day(s)'),
(1998, 'Day(s) M-F'),
(1999, 'days'),
(2000, 'Days'),
(2001, 'days ago'),
(2002, 'Days and Games Missed'),
(2003, 'Days From Last Encounter'),
(2004, 'Days Missed'),
(2005, 'days of each other'),
(2006, 'Days Of Week'),
(2007, 'Days per Column:'),
(2008, 'Days/Col'),
(2009, 'Days/Col:'),
(2010, 'DB installed'),
(2011, 'DD/MM/YYYY'),
(2012, 'De Identification'),
(2013, 'De Identification Process is completed'),
(2014, 'De Identification Process is ongoing'),
(2015, 'De Identification process is started and running in background'),
(2016, 'De Identified data may not be complete'),
(2017, 'De-identification files will be saved in'),
(2018, 'DEA'),
(2019, 'Deactivate'),
(2020, 'Deactivated'),
(2021, 'Deaf'),
(2022, 'Debug Information'),
(2023, 'DEBUG OUTPUT'),
(2024, 'Debugging'),
(2025, 'Dec'),
(2026, 'DECEASED'),
(2027, 'DECEASED (1 day ago)'),
(2028, 'DECEASED (Today)'),
(2029, 'Deceased Date'),
(2030, 'Deceased Date should not be greater than Today'),
(2031, 'Deceased Reason'),
(2032, 'December'),
(2033, 'Decimal pounds or pounds and ounces separated by #(e.g. 5#4)'),
(2034, 'Declined To Specify'),
(2035, 'Deductible'),
(2036, 'Deductible Met'),
(2037, 'deep'),
(2038, 'Default'),
(2039, 'Default Calendar View'),
(2040, 'Default Encounter Form ID'),
(2041, 'Default Encounter View'),
(2042, 'Default Facility'),
(2043, 'Default font (need to logout/login after change this setting)'),
(2044, 'Default font size (need to logout/login after change this setting)'),
(2045, 'Default Language'),
(2046, 'Default language if no other is allowed or chosen.'),
(2047, 'Default left print margin for CMS 1500'),
(2048, 'Default left print margin for UB04'),
(2049, 'Default List (write,addonly optional)'),
(2050, 'Default List (write,addonly optional) (default)'),
(2051, 'Default Method'),
(2052, 'Default Password Expiration Days'),
(2053, 'Default password expiration period in days. 0 means this feature is disabled.'),
(2054, 'Default Patient Country'),
(2055, 'Default Patient Country sent to NewCrop eRx, only if patient country is not set.'),
(2056, 'Default Price Level'),
(2057, 'Default Priority'),
(2058, 'Default Provider'),
(2059, 'Default provider changed'),
(2060, 'Default Range'),
(2061, 'Default Reason for Visit'),
(2062, 'Default Rendering Provider in Fee Sheet'),
(2063, 'Default Search Code Type'),
(2064, 'Default Second Tab'),
(2065, 'Default selection for rendering provider in fee sheet.'),
(2066, 'Default Setting'),
(2067, 'Default state of New Window checkbox in the patient list.'),
(2068, 'Default Template'),
(2069, 'Default to a provider for line item in the fee sheet'),
(2070, 'Default to a provider for line item in the fee sheet.(only applicable if Support line item billing in option above)'),
(2071, 'Default to previous value'),
(2072, 'Default top print margin for CMS 1500'),
(2073, 'Default top print margin for UB04'),
(2074, 'Default Units'),
(2075, 'Default Value'),
(2076, 'Default Visit Category'),
(2077, 'Default Warehouse'),
(2078, 'Default X12 Partner'),
(2079, 'Default/Global'),
(2080, 'Default: Checked. When checked, messages are processed for patients with Patient Demographic Choice (Phone/Text/Email) set to \'Unassigned\' or \'Yes\'. If this is unchecked, a given type of message can only be sent if its Demographic Choice = \'Yes\'.'),
(2081, 'Defaults'),
(2082, 'Define a default visit category'),
(2083, 'Del'),
(2084, 'del'),
(2085, 'Delayed Recurrence (> 12 Mo)'),
(2086, 'Delete'),
(2087, 'delete'),
(2088, 'Delete Categories with ID(s) : '),
(2089, 'Delete Category'),
(2090, 'Delete Document'),
(2091, 'Delete Encounter Form'),
(2092, 'Delete failed!'),
(2093, 'Delete Group'),
(2094, 'Delete List'),
(2095, 'Delete Onsite Portal Activity'),
(2096, 'Delete Pages'),
(2097, 'Delete Patient, Encounter, Form, Issue, Document, Payment, Billing or Transaction'),
(2098, 'Delete Plan'),
(2099, 'Delete Row'),
(2100, 'Delete Selected Items'),
(2101, 'Delete Selected Requests'),
(2102, 'Delete Successful'),
(2103, 'Delete successful.'),
(2104, 'Delete this document'),
(2105, 'Delete this form'),
(2106, 'Delete this message'),
(2107, 'Delete this note'),
(2108, 'Deleted Successfully'),
(2109, 'Deleted Successfully.'),
(2110, 'Deleting'),
(2111, 'Deleting this event cannot be undone. It cannot be recovered once it is gone. Are you sure you wish to delete this event?'),
(2112, 'Deletion failed because group has appointments or encounters'),
(2113, 'Delivered'),
(2114, 'Delivery Confirmed'),
(2115, 'Delivery is not allowed to the specified Direct Address.'),
(2116, 'Delivery is not currently permitted to the specified Direct Address.'),
(2117, 'Delivery of the attached clinical document was requested by the patient'),
(2118, 'Delivery of the attached clinical document was requested by the patient.'),
(2119, 'Dementia'),
(2120, 'Demographic changes made here are recorded system-wide'),
(2121, 'Demographics'),
(2122, 'Demographics (write,addonly optional)'),
(2123, 'Demographics (write,addonly optional) (demo)'),
(2124, 'Demographics Fields'),
(2125, 'Demographics filter criteria'),
(2126, 'Demographics Legend Red: Charted Values. Blue: Patient Edits'),
(2127, 'Demographics not authorized'),
(2128, 'Demographics not authorized.'),
(2129, 'Denied'),
(2130, 'denies'),
(2131, 'Denominator'),
(2132, 'Denominator Exception'),
(2133, 'Denominator Exclusion'),
(2134, 'Dental'),
(2135, 'Dental Issue List'),
(2136, 'Dental Issues'),
(2137, 'Dependency Modules'),
(2138, 'Dependency Problem'),
(2139, 'Depending on the type of bill you are testing you will see HCFA like output on a blank page for HCFA bills, you will see many lines of somewhat garbled text  and information if you are testing an X12 claim. That garbled text is the X12 EDI 4010A format. Occasionally you will see odd characters that look like dominoes or  squiglies, these are control characters such as page feeds and are normal.'),
(2140, 'Deposit Date'),
(2141, 'Deposit Date Cannot be greater than Today'),
(2142, 'Deposit Date:'),
(2143, 'Depressed'),
(2144, 'Depression'),
(2145, 'Dermatology'),
(2146, 'Derm{{dermatologic}}'),
(2147, 'DERM{{Dermatology}}'),
(2148, 'DESC'),
(2149, 'Description'),
(2150, 'description'),
(2151, 'Description is default text'),
(2152, 'Description of the Disclosure'),
(2153, 'Description of this procedure or result code'),
(2154, 'Description Translation'),
(2155, 'Desired Filename'),
(2156, 'Destination'),
(2157, 'Destination Filename'),
(2158, 'Destroy Lot'),
(2159, 'Destroy...'),
(2160, 'Destroyed'),
(2161, 'Destroyed Drugs'),
(2162, 'Destroyed Drugs Report'),
(2163, 'Detail'),
(2164, 'Detail\'s group was saved successfully'),
(2165, 'Detailed exam'),
(2166, 'Detailed HPI'),
(2167, 'Details'),
(2168, 'Developer'),
(2169, 'Developmental abnormality'),
(2170, 'Deviation'),
(2171, 'Diabetes'),
(2172, 'Diabetes Mellitus'),
(2173, 'Diabetes: Blood Pressure Management (CQM)'),
(2174, 'Diabetes: Eye Exam'),
(2175, 'Diabetes: Eye Exam (CQM)'),
(2176, 'Diabetes: Foot Exam'),
(2177, 'Diabetes: Foot Exam (CQM)'),
(2178, 'Diabetes: HbA1c Poor Control (CQM)'),
(2179, 'Diabetes: Hemoglobin A1C'),
(2180, 'Diabetes: LDL Management & Control (CQM)'),
(2181, 'Diabetes: Urine Microalbumin'),
(2182, 'Diag'),
(2183, 'Diagnoses'),
(2184, 'Diagnosis'),
(2185, 'Diagnosis Code'),
(2186, 'Diagnosis Codes'),
(2187, 'Diagnosis Date'),
(2188, 'Diagnosis must be coded into a linked encounter'),
(2189, 'Diagnosis Name'),
(2190, 'Diagnosis Report'),
(2191, 'Diagnosis Reporting'),
(2192, 'Diagnosis Reporting Only'),
(2193, 'Diagnosis Title'),
(2194, 'Diagnosis:'),
(2195, 'Diagnosis: '),
(2196, 'Diagnostic'),
(2197, 'Diagnostic Tests:'),
(2198, 'Dials'),
(2199, 'Diam{{Diameter}}'),
(2200, 'DIAM{{Diameter}}'),
(2201, 'Diaphragms/Caps'),
(2202, 'Diarrhea'),
(2203, 'Diastolic'),
(2204, 'Dictation'),
(2205, 'Dictation: '),
(2206, 'Did you receive a copy of the HIPAA Notice?'),
(2207, 'Diffuse:'),
(2208, 'Digitally Signed'),
(2209, 'Dilated with'),
(2210, 'Dilation orders/risks reviewed'),
(2211, 'Dim'),
(2212, 'Direct'),
(2213, 'DIRECT ADDRESS'),
(2214, 'Direct Address'),
(2215, 'Direct Email'),
(2216, 'Direct Mail'),
(2217, 'Direct Message Log'),
(2218, 'Direct Message Received.'),
(2219, 'Direct messaging is currently unavailable.'),
(2220, 'Direct Messaging Send Failure.'),
(2221, 'Directions'),
(2222, 'Director Name'),
(2223, 'Directory delete failed; continuing.'),
(2224, 'Disability'),
(2225, 'Disable'),
(2226, 'Disable Calendar'),
(2227, 'Disable Chart Tracker'),
(2228, 'Disable Immunizations'),
(2229, 'Disable Old Metric Vitals Form'),
(2230, 'Disable Patient Flow Board'),
(2231, 'Disable phpMyAdmin'),
(2232, 'Disable Prescriptions'),
(2233, 'Disable User Groups'),
(2234, 'disabled'),
(2235, 'Disabled'),
(2236, 'Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)'),
(2237, 'Disc'),
(2238, 'DISC'),
(2239, 'Discard'),
(2240, 'Discarded'),
(2241, 'Discharge'),
(2242, 'Discharge From Urethra'),
(2243, 'Discharge Medications'),
(2244, 'Discharge Right'),
(2245, 'Discharge Right:'),
(2246, 'Discharge Summary'),
(2247, 'Discharge Time'),
(2248, 'Discharged'),
(2249, 'Disclosure Info'),
(2250, 'Disclosure Type'),
(2251, 'Disclosure Types'),
(2252, 'Disclosures'),
(2253, 'Disclosures (write,addonly optional)'),
(2254, 'Discontinue'),
(2255, 'Discount'),
(2256, 'Discount Amount'),
(2257, 'Discount Level'),
(2258, 'Discount Percentage'),
(2259, 'Discounts as Monetary Amounts'),
(2260, 'Discounts at checkout time are entered as money amounts, as opposed to percentage.'),
(2261, 'Discrete Result'),
(2262, 'Disease'),
(2263, 'Disease with presumed immunity'),
(2264, 'Dislocation'),
(2265, 'Dismiss'),
(2266, 'Dismiss Help'),
(2267, 'Disp #'),
(2268, 'Dispatch'),
(2269, 'Dispatch Received Document'),
(2270, 'Dispense Rx'),
(2271, 'Dispense this Rx'),
(2272, 'Dispense this RX'),
(2273, 'Dispensed'),
(2274, 'Display'),
(2275, 'Display Additional measurements (Ks, IOL cals, etc)'),
(2276, 'Display advance directives in the demographics page.'),
(2277, 'Display Documents'),
(2278, 'Display event dates in block?'),
(2279, 'Display Format for US Weights'),
(2280, 'Display how many events?'),
(2281, 'Display Invoice Number or Patient Name in the Cash Receipt Report'),
(2282, 'Display Invoice Number or Patient Name or Both in the Sales Report'),
(2283, 'Display location in block?'),
(2284, 'Display Name'),
(2285, 'Display the Autorefraction Panel'),
(2286, 'Display the calendar?'),
(2287, 'Display the Contact Lens Panel'),
(2288, 'Display the Encounter Billing Note or Patient Billing Note or Both in the Billing Screen.'),
(2289, 'Display the Manifest Refraction panel'),
(2290, 'Display the patient\'s current glasses'),
(2291, 'Display the recurrent appointment widget in the patient summary.'),
(2292, 'Display the Units Column on the Billing Screen'),
(2293, 'Display today\'s events in the block?'),
(2294, 'Display topic in block?'),
(2295, 'Display upcoming events in block?'),
(2296, 'Displayed Columns'),
(2297, 'Displaying the following number of most recent disclosures:'),
(2298, 'Displaying the following number of most recent notes'),
(2299, 'Displaying the following number of most recent notes:'),
(2300, 'Distance'),
(2301, 'Distance from the \'top\' of the envelope in mm'),
(2302, 'Distance from the right most edge of the envelope in portrait position in mm'),
(2303, 'Distribution'),
(2304, 'Distributions'),
(2305, 'Distributor'),
(2306, 'Dist{{distance}}'),
(2307, 'Divehi- Dhivehi- Maldivian-'),
(2308, 'Divergence'),
(2309, 'Divergence Amps'),
(2310, 'Diverticulitis'),
(2311, 'Diverticulitis Surgery'),
(2312, 'Divirticulitis'),
(2313, 'Divirticulitis Surgery'),
(2314, 'Divorced'),
(2315, 'Dizziness:'),
(2316, 'Do not allow SQL queries to be outputted to screen.'),
(2317, 'Do not change'),
(2318, 'Do not display Allergies uploaded after visiting NewCrop eRx.'),
(2319, 'Do not display Allergy uploaded to NewCrop'),
(2320, 'Do not display Medications uploaded after visiting NewCrop eRx.'),
(2321, 'Do not display Medications uploaded to NewCrop'),
(2322, 'Do not display NewCrop eRx Allergy uploaded'),
(2323, 'Do not display NewCrop eRx Medications uploaded'),
(2324, 'Do not display the calendar.'),
(2325, 'Do not display the patient flow board.'),
(2326, 'Do not display the Recall Board.'),
(2327, 'Do not inventory and sell any products'),
(2328, 'Do not know what to do!'),
(2329, 'Do Not Print'),
(2330, 'Do not require patient notes to be authorized'),
(2331, 'Do Not Resuscitate Order'),
(2332, 'do not save'),
(2333, 'do not substitute'),
(2334, 'Do Not Use Safe Apostrophe'),
(2335, 'do nothing'),
(2336, 'Do you really want to change Warehouse?'),
(2337, 'Do You Really Want to Continue'),
(2338, 'Do you really want to delete'),
(2339, 'Do you really want to delete the selection?'),
(2340, 'Do you really want to delete this group'),
(2341, 'Do you really want to delete?'),
(2342, 'Do you want to continue?'),
(2343, 'Do you want to delete this?'),
(2344, 'Do you want to delete?'),
(2345, 'Do you want to remove this record?'),
(2346, 'Do you wish to continue adding this new patient?'),
(2347, 'Do you wish to continue with the new name?'),
(2348, 'Do you wish to PERMANENTLY delete this immunization record?'),
(2349, 'DOB'),
(2350, 'DOB is missing, please enter if possible'),
(2351, 'Doc Id'),
(2352, 'Docs'),
(2353, 'Doctor'),
(2354, 'Doctor:'),
(2355, 'Doctor\'s name and signature'),
(2356, 'Document'),
(2357, 'document'),
(2358, 'document 3 and their status to reach the detailed HPI level'),
(2359, 'Document Categories'),
(2360, 'Document category for lab results does not exist'),
(2361, 'Document category name for storage of electronically received lab results.'),
(2362, 'Document category name for storage of electronically received MDM documents.'),
(2363, 'Document Category or Discard'),
(2364, 'Document clinical findings in Shorthand Format'),
(2365, 'Document could not be moved to patient id'),
(2366, 'Document created'),
(2367, 'Document Date'),
(2368, 'Document date and issue updated successfully'),
(2369, 'Document ID'),
(2370, 'Document Library'),
(2371, 'Document moved to new category'),
(2372, 'Document moved to patient id'),
(2373, 'Document passed integrity check'),
(2374, 'Document passed integrity check.'),
(2375, 'Document Storage Method'),
(2376, 'Document successfully renamed.'),
(2377, 'Document tagged to Encounter successfully'),
(2378, 'Document Template Management'),
(2379, 'Document Templates'),
(2380, 'Document(s)'),
(2381, 'Document/Imaging Store'),
(2382, 'Documentation for a Detailed HPI requires'),
(2383, 'Documents'),
(2384, 'documents'),
(2385, 'Documents (write,addonly optional)'),
(2386, 'Documents (write,addonly optional) (docs)'),
(2387, 'Documents setup error'),
(2388, 'DOC{{document format}}'),
(2389, 'DOE'),
(2390, 'Does anything make it better? Worse?'),
(2391, 'Does it occur in certain situations?'),
(2392, 'Does not equal'),
(2393, 'does not match the PV1 encounter number'),
(2394, 'does not seem valid'),
(2395, 'Does this type allow related codes?'),
(2396, 'Domestic Partner'),
(2397, 'Don\'t Save'),
(2398, 'Don\'t Save'),
(2399, 'Don\'t Save Changes'),
(2400, 'DONATE NOW!'),
(2401, 'Done'),
(2402, 'Done with:'),
(2403, 'Done.  Will now send download.'),
(2404, 'DOS'),
(2405, 'Dosage'),
(2406, 'Dose'),
(2407, 'Double click on a DX\'s handle'),
(2408, 'Double Click on this icon to pop up document in a new viewer.'),
(2409, 'double click to edit'),
(2410, 'Double Clicking a NPI box will bring up a current Users dialog for providers.'),
(2411, 'Double Vision'),
(2412, 'Download'),
(2413, 'DOWNLOAD'),
(2414, 'Download all patient documents'),
(2415, 'Download Anyway'),
(2416, 'Download billing file, post to accounting and mark as billed'),
(2417, 'Download CCDA file'),
(2418, 'Download Certificates'),
(2419, 'Download configuration data'),
(2420, 'Download CSV File'),
(2421, 'Download document template for this patient and visit'),
(2422, 'Download Documents'),
(2423, 'download encrypted file'),
(2424, 'Download Fax'),
(2425, 'Download HL7 file'),
(2426, 'Download Offsite Portal Connection Files'),
(2427, 'Download or Delete a Template'),
(2428, 'Download PDF'),
(2429, 'Download QRDA Category III File'),
(2430, 'Download Selected Statements'),
(2431, 'Dr Check'),
(2432, 'Dr Visit'),
(2433, 'Dr.'),
(2434, 'Drafts'),
(2435, 'Drag a DX over by its handle'),
(2436, 'Drag the arrow for each diagnosis to sort the list.'),
(2437, 'Drag to move'),
(2438, 'Draw'),
(2439, 'Dribbling'),
(2440, 'Drivers License or State ID'),
(2441, 'Drop files here to upload'),
(2442, 'Drug'),
(2443, 'Drug - Drug Interaction'),
(2444, 'Drug Code'),
(2445, 'Drug Finder'),
(2446, 'Drug Forms'),
(2447, 'Drug ID missing!'),
(2448, 'Drug Intervals'),
(2449, 'Drug Inventory'),
(2450, 'Drug Name'),
(2451, 'Drug Routes'),
(2452, 'Drug Screen'),
(2453, 'Drug Screen Completed'),
(2454, 'Drug Screen Report'),
(2455, 'Drug Units'),
(2456, 'Drug Use'),
(2457, 'Drug-Drug'),
(2458, 'Drug1 Name{{Drug1 Interaction}}'),
(2459, 'Drug2 Name{{Drug2 Interaction}}'),
(2460, 'Drugs'),
(2461, 'Drugs and Products'),
(2462, 'Dry Mouth'),
(2463, 'DSMIV Diagnosis'),
(2464, 'DT 1'),
(2465, 'DT 2'),
(2466, 'DT 3'),
(2467, 'DT 4'),
(2468, 'DT 5'),
(2469, 'DTaP 1'),
(2470, 'DTaP 2'),
(2471, 'DTaP 3'),
(2472, 'DTaP 4'),
(2473, 'DTaP 5'),
(2474, 'Due'),
(2475, 'Due Date'),
(2476, 'Due date mm/dd/yyyy or yyyy-mm-dd'),
(2477, 'Due Date:'),
(2478, 'Due Ins'),
(2479, 'Due Pt'),
(2480, 'Due Soon'),
(2481, 'Due Status'),
(2482, 'Due Status Update'),
(2483, 'Dumping OpenEMR database'),
(2484, 'Dumping OpenEMR web directory tree'),
(2485, 'Dumping phpGACL database'),
(2486, 'Dumping phpGACL web directory tree'),
(2487, 'Dumping SQL-Ledger database'),
(2488, 'Dumping SQL-Ledger web directory tree'),
(2489, 'Dup Check'),
(2490, 'Dup Check on only Edit'),
(2491, 'Dup Check on only New'),
(2492, 'Duplicate Rx -- unchanged from current Rx{{The refraction did not change, New Rx=old Rx}}'),
(2493, 'Duplicated ID on line'),
(2494, 'Duplicated name on line'),
(2495, 'DUPLICATION WARNING'),
(2496, 'Durable Power of Attorney'),
(2497, 'Duration'),
(2498, 'duration'),
(2499, 'Dutch'),
(2500, 'Dx Rep'),
(2501, 'Dysphagia'),
(2502, 'Dyspnea:'),
(2503, 'Dysuria'),
(2504, 'Dzongkha'),
(2505, 'E(T){{intermittent esotropia}}'),
(2506, 'E-Mail'),
(2507, 'E-mail'),
(2508, 'E-Mail Address'),
(2509, 'E-mail Messaging'),
(2510, 'E-mail OK'),
(2511, 'E-Prescription?'),
(2512, 'E-Reports'),
(2513, 'e-Rx'),
(2514, 'e-Rx EPCS'),
(2515, 'e-Rx Renewal'),
(2516, 'e-signed'),
(2517, 'Each of these groups (AROs) has access to pre-determined parts of the program (ACOs).'),
(2518, 'Each recipient must set their own messages as completed.'),
(2519, 'Early Recurrence (<2 Mo)'),
(2520, 'Ears'),
(2521, 'ECG'),
(2522, 'eClaims'),
(2523, 'ECL{{equivalent contact lens power at the corneal level}}'),
(2524, 'ECOM{{external comments abbreviation}}'),
(2525, 'Edema'),
(2526, 'EDI File'),
(2527, 'edi history'),
(2528, 'EDI History'),
(2529, 'EDI History (under Fees) for storing and interpreting EDI claim response files'),
(2530, 'EDI-271 File Upload'),
(2531, 'EDI-271 Response File Upload'),
(2532, 'Edit'),
(2533, 'edit'),
(2534, 'Edit Allergies'),
(2535, 'Edit Appointment'),
(2536, 'Edit Categories'),
(2537, 'Edit Current Patient'),
(2538, 'Edit Definitions'),
(2539, 'Edit definitions'),
(2540, 'Edit Diagnoses for'),
(2541, 'Edit Disclosure'),
(2542, 'Edit Document'),
(2543, 'EDIT EXISTING GROUP'),
(2544, 'Edit Facilities'),
(2545, 'Edit Facility'),
(2546, 'Edit Facility Information'),
(2547, 'Edit Facility Specific User Information'),
(2548, 'Edit File in'),
(2549, 'Edit form'),
(2550, 'Edit Global Settings'),
(2551, 'Edit is not authorized!'),
(2552, 'Edit layout'),
(2553, 'Edit Layout Properties'),
(2554, 'Edit list'),
(2555, 'Edit Onsite Portal Activity'),
(2556, 'Edit Payment'),
(2557, 'Edit Structure'),
(2558, 'Edit Template'),
(2559, 'Edit this form'),
(2560, 'Edit User'),
(2561, 'Edit User Settings'),
(2562, 'Edit your entered data'),
(2563, 'Editing failed'),
(2564, 'Education'),
(2565, 'Education Date'),
(2566, 'Educational materials for'),
(2567, 'ee the  * GNU General Public License for more details.  *   * You should have received a copy of the GNU General Public License  * along with this program; if not, write to the Free '),
(2568, 'Effective Date'),
(2569, 'Effective Dates'),
(2570, 'Effectiveness'),
(2571, 'eg. aching, burning, radiating pain'),
(2572, 'EIN'),
(2573, 'Either type a search term in appropriate box or double click box to see available codes.'),
(2574, 'Ejaculations'),
(2575, 'Elbow'),
(2576, 'Elbow Problems'),
(2577, 'Electronic'),
(2578, 'Electronic document received'),
(2579, 'Electronic Notes'),
(2580, 'Electronic Remits'),
(2581, 'Electronic Reports'),
(2582, 'electronically signed on'),
(2583, 'Eligibility'),
(2584, 'Eligibility 270 Inquiry Batch'),
(2585, 'Eligibility Response'),
(2586, 'Eligibility status for Vaccine for Children supplied vaccine'),
(2587, 'Eligible'),
(2588, 'Ellipse'),
(2589, 'Email'),
(2590, 'email'),
(2591, 'EMAIL'),
(2592, 'Email Address'),
(2593, 'Email address is missing'),
(2594, 'Email address of the sender for patient reminders. Replies to patient reminders will be directed to this address. It is important to use an address from your clinic\'s domain to avoid help prevent patient reminders from going to junk mail folders.'),
(2595, 'Email address, if any, to receive administrative notifications.'),
(2596, 'Email address, if any, to receive emergency login user activation messages.'),
(2597, 'Email Auth'),
(2598, 'EMAIL Confimed'),
(2599, 'Email Direct'),
(2600, 'Email from Batchcom'),
(2601, 'Email Notification'),
(2602, 'Email Notification Hours'),
(2603, 'Email Notification Report'),
(2604, 'Email Notification Settings Updated Successfully'),
(2605, 'Email Selected Statements'),
(2606, 'Email send before'),
(2607, 'Email Sender'),
(2608, 'Email Sent'),
(2609, 'Email sent to'),
(2610, 'Email Subject'),
(2611, 'email subject'),
(2612, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***'),
(2613, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***{{Do Not translate the ***NAME*** elements of this constant.}}'),
(2614, 'Email Transport Method'),
(2615, 'Email was sent to following address'),
(2616, 'emails not sent'),
(2617, 'Emergency Care'),
(2618, 'Emergency contact'),
(2619, 'Emergency Contact'),
(2620, 'Emergency Contact Person'),
(2621, 'Emergency Contact Phone Number'),
(2622, 'Emergency Contraception'),
(2623, 'Emergency Login'),
(2624, 'Emergency Login ACL is chosen. The user is still in active state, please de-activate the user and activate the same when required during emergency situations. Visit Administration->Users for activation or de-activation.'),
(2625, 'Emergency Login activation email will be circulated only if following settings in the interface/globals.php file are configured:'),
(2626, 'Emergency Login Email Address'),
(2627, 'Emergency Login user can do anything'),
(2628, 'Emergency Phone'),
(2629, 'Emergency Room - Hospital'),
(2630, 'Emotional / Behavioral Conditions & Complications'),
(2631, 'Emphysema'),
(2632, 'Employee'),
(2633, 'Employer'),
(2634, 'Employer Address'),
(2635, 'Employer Data'),
(2636, 'Employer Name'),
(2637, 'EMPTY'),
(2638, 'Empty'),
(2639, 'Empty Password Not Allowed'),
(2640, 'Empty table'),
(2641, 'Empty value in \"Email Hours\"'),
(2642, 'Empty value in \"Email Sender\"'),
(2643, 'Empty value in \"Email Subject\"'),
(2644, 'Empty value in \"Email Text\"'),
(2645, 'Empty value in \"Name of Provider\"'),
(2646, 'Empty value in \"Password\"'),
(2647, 'Empty value in \"SMS Hours\"'),
(2648, 'Empty value in \"SMS Text\"'),
(2649, 'Empty value in \"Username\"'),
(2650, 'EMR Direct'),
(2651, 'Enable'),
(2652, 'Enable Alert Log'),
(2653, 'Enable Alert Logging'),
(2654, 'Enable Allergy Check'),
(2655, 'Enable Allergy Check Against Medications and Prescriptions'),
(2656, 'Enable AMC Prompting'),
(2657, 'Enable AMC Report Itemization'),
(2658, 'Enable AMC Reporting'),
(2659, 'Enable AMC Tracking'),
(2660, 'Enable amendments feature'),
(2661, 'Enable ATNA Auditing'),
(2662, 'Enable Audit Log Encryption'),
(2663, 'Enable Audit Logging'),
(2664, 'Enable Audit Trail and Node Authentication (ATNA).'),
(2665, 'Enable Automated Measure Calculations (AMC) Reporting'),
(2666, 'Enable Batch Payment'),
(2667, 'Enable C-CDA Alternate Service'),
(2668, 'Enable Client SSL'),
(2669, 'Enable client SSL certificate authentication.'),
(2670, 'Enable Clinical Active Reminder Popup'),
(2671, 'Enable Clinical Decisions Rules (CDR)'),
(2672, 'Enable Clinical Passive New Reminder(s) Popup'),
(2673, 'Enable Clinical Passive Reminder Widget'),
(2674, 'Enable Clinical Quality Measure (CQM) Reporting'),
(2675, 'Enable Clinical Reminder Popup'),
(2676, 'Enable Clinical Reminder Widget'),
(2677, 'Enable CMS Portal'),
(2678, 'Enable CQM Report Itemization'),
(2679, 'Enable CQM Reporting'),
(2680, 'Enable EDI History'),
(2681, 'Enable EDI History In Left Menu'),
(2682, 'Enable Extension'),
(2683, 'Enable Facility'),
(2684, 'Enable Fees In Left Menu'),
(2685, 'Enable Fees Submenu'),
(2686, 'Enable FHIR Provider Client Service'),
(2687, 'Enable Group Therapy'),
(2688, 'Enable Hylafax Support'),
(2689, 'Enable import status message after visiting NewCrop eRx.'),
(2690, 'Enable import status message for NewCrop erx'),
(2691, 'Enable Itemization of AMC Reports'),
(2692, 'Enable Itemization of CQM Reports'),
(2693, 'Enable Itemization of Standard Clinical Rules Reports'),
(2694, 'Enable Lab Exchange'),
(2695, 'Enable lock toggle'),
(2696, 'Enable log for document uploads/downloads to CouchDB'),
(2697, 'Enable logging of all SQL SELECT queries.'),
(2698, 'Enable logging of backup related activities.'),
(2699, 'Enable logging of CDR Engine Queries.'),
(2700, 'Enable logging of miscellaneous activities.'),
(2701, 'Enable logging of ordering activities.'),
(2702, 'Enable logging of patient record modifications.'),
(2703, 'Enable logging of scheduling activities.'),
(2704, 'Enable logging of security and administration activities.'),
(2705, 'Enable MedEx Communication Service'),
(2706, 'Enable NewCrop eRx import status message'),
(2707, 'Enable NewCrop eRx Service'),
(2708, 'Enable NewCrop eRx Service.'),
(2709, 'Enable Offsite Patient Portal'),
(2710, 'Enable Offsite Patient Portal.'),
(2711, 'Enable Onsite Patient Portal'),
(2712, 'Enable Onsite Patient Portal Document Download'),
(2713, 'Enable Onsite Patient Portal.'),
(2714, 'Enable Patient Reminder Widget'),
(2715, 'Enable phiMail Direct Messaging Service'),
(2716, 'Enable Posting'),
(2717, 'Enable Prompting For Automated Measure Calculations (AMC) Required Data'),
(2718, 'Enable Random Drug Testing'),
(2719, 'Enable Reporting of Tracking Date For Automated Measure Calculations (AMC)'),
(2720, 'Enable Scanner Support'),
(2721, 'Enable Standard Report Itemization'),
(2722, 'Enable support for the open source WordPress Portal by Sunset Systems'),
(2723, 'Enable the Medical Information Integration, LLC Lab Exchange Service.'),
(2724, 'Enable the OpenEMR Support LLC Lab Exchange Service.'),
(2725, 'Enable User Certificate Authentication'),
(2726, 'Enable Version 1 Onsite Patient Portal'),
(2727, 'Enable Version 2 Onsite Patient Portal'),
(2728, 'Enable Version 2 Onsite Patient Portal new patient to self register.'),
(2729, 'Enable Weno eRx Service'),
(2730, 'Enable ZMG, LLC eRx service'),
(2731, 'enabled'),
(2732, 'Enabled Services'),
(2733, 'Enables groups module in system.'),
(2734, 'Enables the ability to download documents in the Onsite Patient Portal by the user.'),
(2735, 'Enables the old Charges panel for entering billing codes and payments. Not recommended, use the Fee Sheet instead.'),
(2736, 'Enables to submit changes for all appointments of a recurrence at once.'),
(2737, 'Enc'),
(2738, 'Encnter'),
(2739, 'Encounter'),
(2740, 'encounter'),
(2741, 'Encounter '),
(2742, 'encounter acute inpatient or ED'),
(2743, 'Encounter Balance'),
(2744, 'Encounter Billing Note'),
(2745, 'Encounter Checkup Procedure'),
(2746, 'Encounter Count'),
(2747, 'encounter data'),
(2748, 'Encounter Date'),
(2749, 'Encounter Diagnosis'),
(2750, 'Encounter Dt / Rsn'),
(2751, 'Encounter EDI Record'),
(2752, 'Encounter Esigned'),
(2753, 'Encounter Forms'),
(2754, 'encounter health and behavior assessment'),
(2755, 'Encounter History'),
(2756, 'Encounter ID'),
(2757, 'encounter influenza'),
(2758, 'Encounter Information (encounters)'),
(2759, 'Encounter number'),
(2760, 'Encounter Number'),
(2761, 'encounter nursing discharge'),
(2762, 'encounter nursing facility'),
(2763, 'encounter occupational therapy'),
(2764, 'encounter office visit'),
(2765, 'encounter outpatient'),
(2766, 'encounter outpatient w/PCP & obgyn'),
(2767, 'Encounter Page Size'),
(2768, 'Encounter Payment'),
(2769, 'encounter pregnancy'),
(2770, 'encounter preventive medicine - individual counseling'),
(2771, 'encounter preventive medicine 40 and older'),
(2772, 'encounter preventive medicine group counseling'),
(2773, 'encounter preventive medicine other services'),
(2774, 'encounter preventive medicine services 18 and older'),
(2775, 'Encounter Preview'),
(2776, 'encounter psychiatric & psychologic'),
(2777, 'Encounter statistics'),
(2778, 'Encounter Summary'),
(2779, 'Encounter type'),
(2780, 'Encounter was coded'),
(2781, 'Encounter:'),
(2782, 'Encounter: encounter non-acute inpt, outpatient, or ophthalmology'),
(2783, 'Encounters'),
(2784, 'Encounters & Forms'),
(2785, 'Encounters &amp; Forms'),
(2786, 'Encounters not authorized'),
(2787, 'Encounters Report'),
(2788, 'Encounters Section'),
(2789, 'Encrypted File'),
(2790, 'Encryption'),
(2791, 'End'),
(2792, 'End (yyyy-mm-dd): '),
(2793, 'End Date'),
(2794, 'End date'),
(2795, 'End Date From'),
(2796, 'End date must be equal or bigger than start date'),
(2797, 'End date must be later than Begin date!'),
(2798, 'End date should be greater than Begin date'),
(2799, 'End Date To'),
(2800, 'End Date:'),
(2801, 'End of Day by Provider or allow Totals Only'),
(2802, 'End Of Day Report'),
(2803, 'End of report'),
(2804, 'End Time'),
(2805, 'End-Stage Renal Disease Beneficiary in MCP with Employer`s Group Plan'),
(2806, 'End-Stage Renal Disease Treatment Facility'),
(2807, 'Ending date'),
(2808, 'Ending date of service yyyy-mm-dd'),
(2809, 'Ending DOS mm/dd/yyyy if you wish to enter a range'),
(2810, 'Ending hour of day for calendar events.'),
(2811, 'Endo Abnormal Blood'),
(2812, 'Endocrine'),
(2813, 'Endoscopy'),
(2814, 'ENDO{{Endocrine}}'),
(2815, 'Engineer'),
(2816, 'Engineering Firm'),
(2817, 'English'),
(2818, 'English '),
(2819, 'English (Indian)'),
(2820, 'English (Standard)'),
(2821, 'Enscript command used by Hylafax.'),
(2822, 'Ensure OpenEMR has write privileges to directory'),
(2823, 'ENT Discharge'),
(2824, 'ENT Pain'),
(2825, 'Enter a diagnosis code to exclude all invoices not containing it'),
(2826, 'Enter an amendment...'),
(2827, 'Enter body of letter here'),
(2828, 'Enter City'),
(2829, 'Enter Database root Password'),
(2830, 'Enter Database root Username'),
(2831, 'Enter Details'),
(2832, 'Enter Diagnosis'),
(2833, 'Enter Drugs'),
(2834, 'Enter E-Mail Address'),
(2835, 'Enter email address to receive registration.'),
(2836, 'Enter Encounter'),
(2837, 'Enter Encounter Number'),
(2838, 'Enter Immunizations'),
(2839, 'Enter Key'),
(2840, 'Enter Last'),
(2841, 'Enter new data'),
(2842, 'Enter new office note here'),
(2843, 'Enter new State'),
(2844, 'Enter Recipient\'s Direct Address'),
(2845, 'Enter Self if None'),
(2846, 'Enter the LOINC code for this procedure'),
(2847, 'Enter the Re Identification code'),
(2848, 'Enter values in this section to create a new group also known as Access Request Object (ARO)'),
(2849, 'Enter your credentials'),
(2850, 'Enter your search criteria above'),
(2851, 'Entered By'),
(2852, 'Entered in Error'),
(2853, 'entries'),
(2854, 'Envelope Height in mm'),
(2855, 'Envelope Width in mm'),
(2856, 'Envelope x-axis starting pt'),
(2857, 'Envelope y-axis starting pt'),
(2858, 'Environmental'),
(2859, 'EOB Data Entry'),
(2860, 'EOB Data Entry (eob)'),
(2861, 'EOB Id'),
(2862, 'EOB Posting - Electronic Remittances'),
(2863, 'EOB Posting - Instructions'),
(2864, 'EOB Posting - Invoice'),
(2865, 'EOB Posting - Patient Note'),
(2866, 'EOB Posting - Search'),
(2867, 'EOBs'),
(2868, 'Epilepsy'),
(2869, 'Episode'),
(2870, 'EPSDT'),
(2871, 'EPSDT:'),
(2872, 'Equals'),
(2873, 'Equivalent contact lens power at the corneal level'),
(2874, 'ERA'),
(2875, 'ERA Files'),
(2876, 'ERA Posting'),
(2877, 'Erase'),
(2878, 'Eraser'),
(2879, 'Erections'),
(2880, 'Error'),
(2881, 'ERROR'),
(2882, 'Error confirming receipt of lab results'),
(2883, 'Error creating directory!'),
(2884, 'Error getting lab results from Lab Exchange Network'),
(2885, 'Error in \"Gender\" selection'),
(2886, 'Error in \"HIPAA\" selection'),
(2887, 'Error in \"Process\" selection'),
(2888, 'Error in \"SMS Gateway\" selection'),
(2889, 'Error in \"Sort By\" selection'),
(2890, 'Error in gzip compression of file: '),
(2891, 'Error in YES or NO option'),
(2892, 'Error number'),
(2893, 'Error opening uploaded file for reading'),
(2894, 'Error processing file'),
(2895, 'Error processing upload'),
(2896, 'Error Removing Message'),
(2897, 'Error retrieving results from Lab Exchange Network'),
(2898, 'Error retrieving values.'),
(2899, 'Error saving document'),
(2900, 'Error when granting file privilege to the OpenEMR user.'),
(2901, 'Error while adding new plan'),
(2902, 'Error while deleting the plan'),
(2903, 'error while registering form!'),
(2904, 'Error while saving to the file'),
(2905, 'Error while updating the plan'),
(2906, 'Error while writing to file'),
(2907, 'ERROR!... in Update'),
(2908, 'error(s) encountered from new results'),
(2909, 'Error, the file does not exist'),
(2910, 'ERROR, unable to collect data from server'),
(2911, 'Error, unable to create client certificate.'),
(2912, 'Error, unable to create the admin.p12 certificate.'),
(2913, 'Error, unable to create the Certificate Authority certificate.'),
(2914, 'Error, unable to create the Server certificate.'),
(2915, 'Error, unable to open file'),
(2916, 'Error, User Certificate Authentication is not enabled in OpenEMR'),
(2917, 'Error. Try again later'),
(2918, 'Error. You need to install the Archive/Tar.php php module.'),
(2919, 'ERROR: could not open table.sql, broken form?'),
(2920, 'Error: Duplicated field ID'),
(2921, 'Error: duplicated ID'),
(2922, 'Error: duplicated ID on line'),
(2923, 'Error: duplicated name on line'),
(2924, 'ERROR: Field'),
(2925, 'ERROR: Missing ZipArchive PHP Module'),
(2926, 'ERROR: No ICD import directory.'),
(2927, 'Error: passwords don\'t match. Please check your typing.'),
(2928, 'Error: passwords don\'t match. Please check your typing.'),
(2929, 'Error: the file does not exist'),
(2930, 'ERROR: The following variable contains invalid characters'),
(2931, 'ERROR: Unable to copy the file.'),
(2932, 'Error: Unable to create downloadable archive'),
(2933, 'ERROR: Unable to Create Zip Archive.'),
(2934, 'ERROR: Unable to extract the file.'),
(2935, 'ERROR: Unable to load the file into the database.'),
(2936, 'ERROR: Unable to set the version number.'),
(2937, 'Errors'),
(2938, 'eRx Account Status'),
(2939, 'eRx Logs'),
(2940, 'ERX Name'),
(2941, 'ERX Password'),
(2942, 'ERX Role'),
(2943, 'ERX User'),
(2944, 'Erythema:'),
(2945, 'eSign'),
(2946, 'eSign Log'),
(2947, 'Eskimo'),
(2948, 'Esophoria'),
(2949, 'Esotropia'),
(2950, 'Esperanto'),
(2951, 'Established Patient'),
(2952, 'Estonian'),
(2953, 'Ethnicity'),
(2954, 'Ethnicity or Race'),
(2955, 'Ethnicity-Race List (write,addonly optional)'),
(2956, 'Ethnicity-Race List (write,addonly optional) (ethrace)'),
(2957, 'Ethnoracial'),
(2958, 'ETIN'),
(2959, 'ETOH'),
(2960, 'ET{{esotropia}}'),
(2961, 'Event'),
(2962, 'Event Begins'),
(2963, 'Event Category'),
(2964, 'Event Date'),
(2965, 'event date or starting date'),
(2966, 'Event Description'),
(2967, 'Event Details'),
(2968, 'Event does not repeat'),
(2969, 'Event Duration'),
(2970, 'Event duration in minutes'),
(2971, 'Event Fee'),
(2972, 'Event Location'),
(2973, 'Event repeats every'),
(2974, 'Event repeats on'),
(2975, 'Event start time'),
(2976, 'Event title'),
(2977, 'Event Title'),
(2978, 'Event Website'),
(2979, 'Events'),
(2980, 'Events for'),
(2981, 'Events open in new window'),
(2982, 'Events Scheduled'),
(2983, 'every'),
(2984, 'Every'),
(2985, 'Every 2nd'),
(2986, 'every 3 hours'),
(2987, 'Every 3rd'),
(2988, 'every 4 hours'),
(2989, 'Every 4th'),
(2990, 'every 5 hours'),
(2991, 'Every 5th'),
(2992, 'every 6 hours'),
(2993, 'Every 6th'),
(2994, 'every 8 hours'),
(2995, 'Every Fourth'),
(2996, 'Every name in the address book appears here, not only physicians.'),
(2997, 'Every Other'),
(2998, 'Every Third'),
(2999, 'Every, every other, every 3rd, etc.'),
(3000, 'Ewe'),
(3001, 'Exam and test results'),
(3002, 'Exam results'),
(3003, 'Exam Room #'),
(3004, 'Exam Room Number'),
(3005, 'Examination'),
(3006, 'Examination Date'),
(3007, 'Example'),
(3008, 'Example Privacy_Agreement.txt becomes Privacy Agreement button in Patient Documents'),
(3009, 'Examples'),
(3010, 'Exams/Tests'),
(3011, 'Exam{{Physical Exam}}'),
(3012, 'Except'),
(3013, 'Excessive Tearing'),
(3014, 'Excluded Appointments - Tooltip - Number to Display'),
(3015, 'Excluded Patients'),
(3016, 'Exclusion'),
(3017, 'Exclusive Provider Organization (EPO)'),
(3018, 'Executive Paper Size'),
(3019, 'Exercise'),
(3020, 'Exercise patterns'),
(3021, 'Exercise Patterns'),
(3022, 'Exist'),
(3023, 'Exit'),
(3024, 'Exit from Administration'),
(3025, 'Exit Mail'),
(3026, 'Exophoria'),
(3027, 'Exotropia'),
(3028, 'Exp'),
(3029, 'Exp Date'),
(3030, 'Expand'),
(3031, 'expand'),
(3032, 'Expand All'),
(3033, 'Expand All Document Categories'),
(3034, 'Expand All Document Categories by Default'),
(3035, 'Expanded View'),
(3036, 'Expected form_encounter.pid to be '),
(3037, 'Expiration'),
(3038, 'Expiration Date'),
(3039, 'Expires'),
(3040, 'expires in'),
(3041, 'Export'),
(3042, 'Export as CSV'),
(3043, 'Export Billing'),
(3044, 'Export Configuration'),
(3045, 'Export File'),
(3046, 'Export Individual Invoices'),
(3047, 'Export OFX'),
(3048, 'Export Patient Demographics'),
(3049, 'Export Patient Demographics XML'),
(3050, 'Export PQRI Report'),
(3051, 'Export QRDA Report'),
(3052, 'Export Selected as CSV'),
(3053, 'Export Selected to Collections'),
(3054, 'Export to CSV'),
(3055, 'Export to external billing system'),
(3056, 'Exposure to Foreign Countries'),
(3057, 'Exposure To Foreign Countries'),
(3058, 'Ext Time Collected'),
(3059, 'Extended family'),
(3060, 'External'),
(3061, 'External Data'),
(3062, 'External Data Loads'),
(3063, 'External Database Import Utility'),
(3064, 'External Exam'),
(3065, 'External Exam Default Values'),
(3066, 'External ID'),
(3067, 'External Id'),
(3068, 'External identifier'),
(3069, 'External Only'),
(3070, 'External Organization'),
(3071, 'External Provider'),
(3072, 'External Referral'),
(3073, 'External Referral Followups'),
(3074, 'External referral?'),
(3075, 'External Referrals'),
(3076, 'Extract the zip file'),
(3077, 'Extracting the file. This will take some time...'),
(3078, 'Exudate:'),
(3079, 'Eye'),
(3080, 'Eye Coding Fields'),
(3081, 'Eye Coding Terms'),
(3082, 'Eye Contact Lens Brand list'),
(3083, 'Eye Contact Lens Manufacturer list'),
(3084, 'Eye Contact Lens Supplier list'),
(3085, 'Eye Dx{{eye diagnosis}}'),
(3086, 'Eye Exam'),
(3087, 'Eye Exam Default Values for New Providers'),
(3088, 'Eye Irritation'),
(3089, 'Eye Lens Material'),
(3090, 'Eye Lens Treatments'),
(3091, 'Eye Med'),
(3092, 'Eye Orders Defaults'),
(3093, 'Eye Pain'),
(3094, 'Eye QP List ANTSEG for New Providers'),
(3095, 'Eye QP List EXT for New Providers'),
(3096, 'Eye QP List RETINA for New Providers'),
(3097, 'Eye Redness'),
(3098, 'Eye Surgery'),
(3099, 'Eyedropper'),
(3100, 'Eyes'),
(3101, 'E{{esophoria}}'),
(3102, 'F'),
(3103, 'F/H Blood Problems'),
(3104, 'F/H Female Hirsutism/Striae'),
(3105, 'Facilities'),
(3106, 'Facility'),
(3107, 'facility'),
(3108, 'Facility Administration'),
(3109, 'Facility City'),
(3110, 'Facility Code'),
(3111, 'Facility Color Schema'),
(3112, 'Facility Country code'),
(3113, 'Facility Fax'),
(3114, 'Facility ID'),
(3115, 'Facility Name'),
(3116, 'Facility NPI'),
(3117, 'Facility Phone'),
(3118, 'Facility Specific User Information'),
(3119, 'Facility State'),
(3120, 'Facility Street'),
(3121, 'Facility Taxonomy'),
(3122, 'Facility Zip'),
(3123, 'Facility Zip Code'),
(3124, 'Facility:'),
(3125, 'FAIL'),
(3126, 'failed'),
(3127, 'Failed'),
(3128, 'Failed - already has group with the same name'),
(3129, 'Failed Patients'),
(3130, 'Failed to add patient to portal'),
(3131, 'Failed to compute a unique filename'),
(3132, 'Failed to create'),
(3133, 'Failed to create folder'),
(3134, 'Failed to create new group'),
(3135, 'Failed to create temporary folder. CouchDB will not work.'),
(3136, 'Failed to generate'),
(3137, 'Failed to get URL:'),
(3138, 'Failed to send'),
(3139, 'Failed UTF8 encoding check! Could not automatically fix.'),
(3140, 'Failed.'),
(3141, 'failure'),
(3142, 'Failure'),
(3143, 'FAILURE NOTICE: Direct Message Send Failed.'),
(3144, 'FAILURE: Couldn\'t create the zip'),
(3145, 'FAILURE: No patients for measure'),
(3146, 'Falls: Screening, Risk-Assessment, and Plan of Care to Prevent Future Falls (CQM)'),
(3147, 'Family Health History'),
(3148, 'Family History'),
(3149, 'Family History of Glaucoma'),
(3150, 'Family History:'),
(3151, 'Family Member'),
(3152, 'Family Payment'),
(3153, 'Family Size'),
(3154, 'Fancy'),
(3155, 'Faroese'),
(3156, 'Farsi'),
(3157, 'Fatal'),
(3158, 'Father'),
(3159, 'Fathers History'),
(3160, 'Fatigue'),
(3161, 'Fatigued'),
(3162, 'Fax'),
(3163, 'Fax Count'),
(3164, 'Fax number'),
(3165, 'Fax sending failed'),
(3166, 'Fax/Scan'),
(3167, 'Faxes In'),
(3168, 'Faxes Out'),
(3169, 'Features'),
(3170, 'Feb'),
(3171, 'February'),
(3172, 'FECA'),
(3173, 'Federal Drug ID'),
(3174, 'Federal EIN'),
(3175, 'Federal Tax ID'),
(3176, 'Federally Qualified Health Center'),
(3177, 'Fee'),
(3178, 'fee'),
(3179, 'Fee is not allowed'),
(3180, 'Fee Sheet'),
(3181, 'Fee Sheet Options'),
(3182, 'Fees'),
(3183, 'Female'),
(3184, 'Female AP'),
(3185, 'Female Condoms'),
(3186, 'Female G'),
(3187, 'Female LC'),
(3188, 'Female P'),
(3189, 'Female Symptoms'),
(3190, 'Female VSC'),
(3191, 'Fetch'),
(3192, 'Fetching following file from portal'),
(3193, 'Fever'),
(3194, 'Fever:'),
(3195, 'FH Blood Problems'),
(3196, 'FHIR Server Base Address'),
(3197, 'FH{{Family History}}'),
(3198, 'Fibroids'),
(3199, 'Field'),
(3200, 'Field \'name\' cannot be NULL'),
(3201, 'Field ID'),
(3202, 'Field type to use for employer or subscriber country in demographics.'),
(3203, 'Field type to use for employer or subscriber state in demographics.'),
(3204, 'Field(s) are missing!'),
(3205, 'FIELD: Text(.a); '),
(3206, 'Fields in This Form'),
(3207, 'Fields{{visual fields}}'),
(3208, 'Fifth account message'),
(3209, 'Fijian'),
(3210, 'File'),
(3211, 'File base name becomes Menu selection'),
(3212, 'file in the Documentation directory to learn how to automate the process of creating log backups'),
(3213, 'file location'),
(3214, 'File management'),
(3215, 'file missing'),
(3216, 'File Name'),
(3217, 'File not found'),
(3218, 'File Not Found'),
(3219, 'File on server (modification date)'),
(3220, 'File path not found.'),
(3221, 'File privilege granted to OpenEMR user.'),
(3222, 'File retrieval from CouchDB failed'),
(3223, 'File Room'),
(3224, 'File to upload'),
(3225, 'File to Upload'),
(3226, 'File with same name already exists at location:'),
(3227, 'Filename'),
(3228, 'Filename must end with \".pdf\"'),
(3229, 'Files'),
(3230, 'Files type white list'),
(3231, 'Files with empty thumbnail'),
(3232, 'Filipino'),
(3233, 'fill'),
(3234, 'Fill any of the Below Row.'),
(3235, 'Fill here only if sending email notification to patients'),
(3236, 'Fill in the values below'),
(3237, 'Fill Instructions'),
(3238, 'Fill the Row.'),
(3239, 'Fill your first and last name'),
(3240, 'Filter'),
(3241, 'Filter for Constants'),
(3242, 'Filter for Definitions'),
(3243, 'filtered from'),
(3244, 'filters'),
(3245, 'Filters'),
(3246, 'Final'),
(3247, 'Final Diagnosis'),
(3248, 'Final diagnosis by specialist'),
(3249, 'Final Status'),
(3250, 'Financial'),
(3251, 'Financial Close Date (yyyy-mm-dd)'),
(3252, 'Financial Reporting - anything'),
(3253, 'Financial Reporting - anything (rep_a)'),
(3254, 'Financial Reporting - my encounters'),
(3255, 'Financial Reporting - my encounters (rep)'),
(3256, 'Financial Review'),
(3257, 'Financial Review Date'),
(3258, 'Financial Summary by Service Code'),
(3259, 'Find'),
(3260, 'Find Available'),
(3261, 'Find Available Appointments'),
(3262, 'Find Patient'),
(3263, 'Find Patient Education Materials'),
(3264, 'Findings'),
(3265, 'Findings by specialist'),
(3266, 'Fine'),
(3267, 'Finish'),
(3268, 'Finish Payments'),
(3269, 'Finished'),
(3270, 'finished'),
(3271, 'Finnish'),
(3272, 'First'),
(3273, 'First account message'),
(3274, 'First day in the week'),
(3275, 'First day of the week'),
(3276, 'First Modern Contraception at this Clinic (with Prior Contraceptive Use)'),
(3277, 'First Modern Contraceptive Use (Lifetime)'),
(3278, 'First Name'),
(3279, 'First name'),
(3280, 'First Name:'),
(3281, 'First Visit or Consultation'),
(3282, 'First visit: No Old Records'),
(3283, 'First-time visits only'),
(3284, 'Firstname Lastname'),
(3285, 'Fitness'),
(3286, 'Fitness Level'),
(3287, 'Fitness level for this player on this day'),
(3288, 'Fitness Testing'),
(3289, 'Fitness to Play'),
(3290, 'Fix encounter dates - any encounters'),
(3291, 'Fix encounter dates - any encounters (date_a)'),
(3292, 'Fix this'),
(3293, 'FL'),
(3294, 'Flash'),
(3295, 'Flatulence'),
(3296, 'Flow'),
(3297, 'Flow Board'),
(3298, 'Flow Board will only display completed checkouts for this many minutes. Zero is continuous display.'),
(3299, 'Flow Board: Allow Date Range'),
(3300, 'Flow Board: Disable'),
(3301, 'Flow Board: display completed checkouts (minutes)'),
(3302, 'Flow Board: Enable Random Drug Testing'),
(3303, 'Flow Board: Ending Date'),
(3304, 'Flow Board: Max tests per Patient per year'),
(3305, 'Flow Board: Percentage of Patients to Drug Test'),
(3306, 'Flow Board: Show Encounter Number'),
(3307, 'Flow Board: Show Patient ID'),
(3308, 'Flow Board: Show Staff Action'),
(3309, 'Flow Board: Show Visit Reason'),
(3310, 'Flow Board: Timer Refresh Interval'),
(3311, 'Flu season'),
(3312, 'Flu Season'),
(3313, 'Flu Vaccination'),
(3314, 'Fluid and electrolyte problem'),
(3315, 'FMS'),
(3316, 'Folio Paper Size'),
(3317, 'Follow manually'),
(3318, 'Follow these instructions for installing or upgrading the following database'),
(3319, 'Follow Up'),
(3320, 'Follow Up Note'),
(3321, 'Follow Up Reason'),
(3322, 'Following audit log entry number is missing'),
(3323, 'Following is a new custom constant:'),
(3324, 'Following is a new custom language:'),
(3325, 'Following is a new definition (Language, Constant, Definition):'),
(3326, 'Following rows in the audit log have been tampered'),
(3327, 'Followup Services'),
(3328, 'Followups Indicated'),
(3329, 'Font Size'),
(3330, 'Font Size in Pt'),
(3331, 'Food Intolerance'),
(3332, 'Foot'),
(3333, 'Foot Problems'),
(3334, 'Foot:'),
(3335, 'Football Injuries'),
(3336, 'Football Injury'),
(3337, 'Football Injury Report'),
(3338, 'Footwear Type'),
(3339, 'for'),
(3340, 'For'),
(3341, 'for '),
(3342, 'For an existing patient, go to Patient Summary->Documents. For a new patient, go to Miscellanous->New Documents'),
(3343, 'For code'),
(3344, 'For Dates'),
(3345, 'For Encounter Claims'),
(3346, 'For example:'),
(3347, 'For HCFA 02/12 Box 15 is Other Date with a qualifier to specify what the date indicates'),
(3348, 'For HCFA 02/12 Onset date specified on the Encounter Form needs a qualifier'),
(3349, 'for Invoice'),
(3350, 'For Medicare only, forces the referring provider to be the same as the rendering provider.'),
(3351, 'for OBR placer order number'),
(3352, 'for patient'),
(3353, 'For Provider'),
(3354, 'For Referred Organization/Practitioner'),
(3355, 'For the past'),
(3356, 'for this patient not yet assigned to any encounter.'),
(3357, 'for variable'),
(3358, 'for:'),
(3359, 'Force Billing Widget Open'),
(3360, 'Force Create New Patient'),
(3361, 'Force Show'),
(3362, 'Forearm'),
(3363, 'Form'),
(3364, 'form'),
(3365, 'Form element not found'),
(3366, 'Form Keys'),
(3367, 'Form signed successfully'),
(3368, 'Format'),
(3369, 'format'),
(3370, 'Format for age display'),
(3371, 'Format incorrect for NDC'),
(3372, 'Format used to display most dates.'),
(3373, 'Format used to display most times.'),
(3374, 'Formatted Report'),
(3375, 'Former smoker'),
(3376, 'Forms'),
(3377, 'Forms Administration'),
(3378, 'Forms Administration (forms)'),
(3379, 'Forms Esigned'),
(3380, 'Formularies inserted into table'),
(3381, 'Forward'),
(3382, 'Forward message to practice.'),
(3383, 'Forward Pages via Fax'),
(3384, 'Forwarded'),
(3385, 'Forwarded Portal Message Re: '),
(3386, 'Foster Child'),
(3387, 'Fourth'),
(3388, 'Fourth account message'),
(3389, 'Fracture'),
(3390, 'Fracture at the Navicula'),
(3391, 'Fracture lateral malleolus'),
(3392, 'Fracture medial malleolus'),
(3393, 'Fracture, Base of fifth (5th) Metatarsal'),
(3394, 'Frame'),
(3395, 'Frame support required'),
(3396, 'French'),
(3397, 'French (Canadian)'),
(3398, 'French (Standard)'),
(3399, 'Frequency'),
(3400, 'Frequent Colds'),
(3401, 'Frequent Illness'),
(3402, 'Fri'),
(3403, 'Friday'),
(3404, 'Friend'),
(3405, 'From'),
(3406, 'FROM'),
(3407, 'from'),
(3408, 'From Date Cannot be Greater than To Date.'),
(3409, 'From date should be less than To date'),
(3410, 'From Period'),
(3411, 'From:'),
(3412, 'From: '),
(3413, 'FROM_CITY'),
(3414, 'FROM_EMAIL'),
(3415, 'FROM_FNAME'),
(3416, 'FROM_LNAME'),
(3417, 'FROM_MNAME'),
(3418, 'FROM_PHONE'),
(3419, 'FROM_PHONECELL'),
(3420, 'FROM_POSTAL'),
(3421, 'FROM_STATE'),
(3422, 'FROM_STREET'),
(3423, 'FROM_TITLE'),
(3424, 'FROM_VALEDICTORY'),
(3425, 'Front Office'),
(3426, 'Front Office Receipts'),
(3427, 'Front Office Receipts Report'),
(3428, 'Front Rec'),
(3429, 'Frontal Right:'),
(3430, 'Fr{{Friday}}'),
(3431, 'FTCF{{Full to count fingers}}'),
(3432, 'FTN{{Finger Tension abbreviation}}'),
(3433, 'FT{{finger tension}}'),
(3434, 'Fula- Fulah- Pulaar- Pular'),
(3435, 'Full Name'),
(3436, 'Full or Initial'),
(3437, 'Full path to directory containing MySQL executables.'),
(3438, 'Full path to directory containing Perl executables.'),
(3439, 'Full path to directory for event log backup.'),
(3440, 'Full path to directory used for temporary files.'),
(3441, 'Full Play'),
(3442, 'Full Screen'),
(3443, 'Full Training'),
(3444, 'Fullscreen'),
(3445, 'Fully Paid'),
(3446, 'Functional and Cognitive Status'),
(3447, 'Functional and Cognitive Status Form'),
(3448, 'Functional Cognitive Status'),
(3449, 'Functional Condition'),
(3450, 'Funding Source'),
(3451, 'Future'),
(3452, 'Future Appointments'),
(3453, 'F{{Friday}}'),
(3454, 'G'),
(3455, 'G/DL'),
(3456, 'Galician'),
(3457, 'Gall Bladder Condition'),
(3458, 'Gall Stones'),
(3459, 'Game Period'),
(3460, 'Games'),
(3461, 'Games Missed'),
(3462, 'games/events'),
(3463, 'Games/Events Missed'),
(3464, 'Ganda'),
(3465, 'Gastritis'),
(3466, 'Gastro Pain'),
(3467, 'Gastrointestinal'),
(3468, 'GCAC Statistics Report'),
(3469, 'GCAC Stats'),
(3470, 'GCAC visit form is missing'),
(3471, 'Gender'),
(3472, 'Gender '),
(3473, 'General'),
(3474, 'General data'),
(3475, 'General Issue List'),
(3476, 'General physician'),
(3477, 'General Service Category'),
(3478, 'General Theme (need to logout/login after change this setting)'),
(3479, 'Generally, the first field in a group should be Label Cols = 1 Data Cols = number of Layout columns from Group Properties.'),
(3480, 'Generate'),
(3481, 'Generate and download CMS 1500 paper claims'),
(3482, 'Generate and download CMS 1500 paper claims on Preprinted form'),
(3483, 'Generate and download HCFA 1500 paper claims'),
(3484, 'Generate and download UB-04 CMS1450'),
(3485, 'Generate and download UB-04 CMS1450 with form'),
(3486, 'Generate and download X12 batch'),
(3487, 'Generate and download X12 encounter claim batch'),
(3488, 'Generate and transmit permissible prescriptions electronically (All Prescriptions).'),
(3489, 'Generate and transmit permissible prescriptions electronically (Not including controlled substances).'),
(3490, 'Generate and transmit permissible prescriptions electronically.'),
(3491, 'Generate CMS 1500'),
(3492, 'Generate CMS 1500 PDF'),
(3493, 'Generate CMS 1500 TEXT'),
(3494, 'Generate HCFA'),
(3495, 'Generate Institutional X12 837I'),
(3496, 'Generate Invoice'),
(3497, 'Generate Letter'),
(3498, 'Generate Letter regarding '),
(3499, 'Generate new key'),
(3500, 'Generate PQRI report (Method A)'),
(3501, 'Generate PQRI report (Method A) - 2011'),
(3502, 'Generate PQRI report (Method E)'),
(3503, 'Generate PQRI report (Method E) - 2011'),
(3504, 'Generate QRDA I – 2014'),
(3505, 'Generate QRDA III - 2014'),
(3506, 'Generate Report'),
(3507, 'Generate safe key'),
(3508, 'Generate thumbnail'),
(3509, 'Generate thumbnail images'),
(3510, 'Generate Thumbnails'),
(3511, 'Generate Username And Password For'),
(3512, 'Generate X12'),
(3513, 'Generate X12 837I'),
(3514, 'Generate X12 Encounter'),
(3515, 'Generate/Download QRDA I - 2014'),
(3516, 'Generated on'),
(3517, 'Generated thumbnail(s)'),
(3518, 'Generates'),
(3519, 'Genericname1'),
(3520, 'Genericname2'),
(3521, 'Genericval1'),
(3522, 'Genericval2'),
(3523, 'Genitourinary'),
(3524, 'Genitourinary medicine physician'),
(3525, 'GEN{{General}}'),
(3526, 'Georgian'),
(3527, 'German'),
(3528, 'Gest age'),
(3529, 'Gestational Age'),
(3530, 'Get History'),
(3531, 'GET HL7'),
(3532, 'Get HL7'),
(3533, 'Get Started'),
(3534, 'GI{{Gastrointestinal}}'),
(3535, 'Glare{{Acuity under Glare conditions}}'),
(3536, 'Glaucoma'),
(3537, 'Glaucoma Family History'),
(3538, 'Glaucoma Zone'),
(3539, 'Global'),
(3540, 'Global All Patients'),
(3541, 'Global Default Patient Country'),
(3542, 'Global ID'),
(3543, 'Global Settings'),
(3544, 'Globals'),
(3545, 'GM/DL'),
(3546, 'go'),
(3547, 'GO'),
(3548, 'Go'),
(3549, 'Go Back'),
(3550, 'Go to'),
(3551, 'Go to week of'),
(3552, 'Go Today'),
(3553, 'Goal A'),
(3554, 'Goal and Methods'),
(3555, 'Goal B'),
(3556, 'Goal C'),
(3557, 'Gonioscopy'),
(3558, 'Gonio{{Gonioscopy abbreviation}}'),
(3559, 'Grade of Injury'),
(3560, 'Grade:'),
(3561, 'grams'),
(3562, 'Grand Total'),
(3563, 'Grand Totals'),
(3564, 'Grandchild'),
(3565, 'Grandparent'),
(3566, 'Graphable'),
(3567, 'Great Grandparent'),
(3568, 'Greater Than'),
(3569, 'Greater Than or Equal To'),
(3570, 'Greek'),
(3571, 'Greek, Modern'),
(3572, 'Group'),
(3573, 'Group appointments'),
(3574, 'Group Attendance Form'),
(3575, 'Group Attendance Statuses'),
(3576, 'Group detailed log of appointment in patient record'),
(3577, 'Group Details'),
(3578, 'Group Encounter'),
(3579, 'Group Encounter Form'),
(3580, 'Group encounter log'),
(3581, 'Group Finder'),
(3582, 'Group Home'),
(3583, 'Group Id'),
(3584, 'Group name'),
(3585, 'Group Name'),
(3586, 'Group names cannot be blank'),
(3587, 'Group names cannot start with numbers or spaces.'),
(3588, 'Group names cannot start with numbers.'),
(3589, 'Group Number'),
(3590, 'Group number'),
(3591, 'Group Payment'),
(3592, 'Group Properties'),
(3593, 'Group Search'),
(3594, 'Group Statuses'),
(3595, 'Group Type'),
(3596, 'Group\'s name'),
(3597, 'Group:'),
(3598, 'Groupname'),
(3599, 'Groups'),
(3600, 'Groups and Access Controls'),
(3601, 'Growth Chart'),
(3602, 'Growth-Chart'),
(3603, 'gtts(drops)'),
(3604, 'Guamanian'),
(3605, 'Guarani'),
(3606, 'Guaraní'),
(3607, 'Guardian'),
(3608, 'Guardian Email Address'),
(3609, 'Guardian\'s Name'),
(3610, 'Guardians Name'),
(3611, 'Guest counselors'),
(3612, 'Gujarati'),
(3613, 'GU{{Genitourinary}}'),
(3614, 'Gynecological Exam'),
(3615, 'h'),
(3616, 'H(T){{intermittent hypertropia}}'),
(3617, 'h.s.'),
(3618, 'H/O Hepatitis'),
(3619, 'had been successfully deleted. Any sub-categories if present were moved below'),
(3620, 'Haematoma / bruising'),
(3621, 'HAI Status'),
(3622, 'Haitian- Haitian Creole'),
(3623, 'Half-Sibling'),
(3624, 'Hand + fingers'),
(3625, 'Hand Problems'),
(3626, 'Handicapped dependent'),
(3627, 'Happy Birthday'),
(3628, 'Hard Disk'),
(3629, 'Hardship w/o'),
(3630, 'has been linked to visit'),
(3631, 'has expired'),
(3632, 'Hash'),
(3633, 'Hash did not exist for this file. A new hash was generated.'),
(3634, 'Hash does not match. Data integrity has been compromised.'),
(3635, 'Hausa'),
(3636, 'Hawaiian'),
(3637, 'Hazardous Activities'),
(3638, 'Hazardous activities'),
(3639, 'HB{{abbreviation for Horizontal Prism Base}}'),
(3640, 'HCFA FORM'),
(3641, 'HCFA left margin in points'),
(3642, 'HCFA Margins'),
(3643, 'HCFA top margin in points'),
(3644, 'HCPCS Procedure/Service'),
(3645, 'he PostCalendar '),
(3646, 'Head'),
(3647, 'Head Circ'),
(3648, 'Head Circumference'),
(3649, 'Headache'),
(3650, 'Headaches'),
(3651, 'health care operations'),
(3652, 'Health Care Operations'),
(3653, 'Health centre/clinic'),
(3654, 'Health Maintenance Organization'),
(3655, 'Health Maintenance Organization (HMO) Medicare Risk'),
(3656, 'Hearing Loss'),
(3657, 'Heart Attack'),
(3658, 'Heart Disease'),
(3659, 'Heart Failure'),
(3660, 'Heart Problem'),
(3661, 'Heart Problems'),
(3662, 'Heart Surgery'),
(3663, 'Heart Transplant'),
(3664, 'HEART:'),
(3665, 'Heartburn'),
(3666, 'Heat or Cold'),
(3667, 'Heat Or Cold'),
(3668, 'Heavy tobacco smoker'),
(3669, 'Hebrew'),
(3670, 'Hebrew (modern)'),
(3671, 'HEENT'),
(3672, 'Height'),
(3673, 'Height/Length'),
(3674, 'Help'),
(3675, 'help'),
(3676, 'Help content goes here'),
(3677, 'Hematemesis'),
(3678, 'Hematochezia'),
(3679, 'Hematologic'),
(3680, 'Hematuria'),
(3681, 'Hemoglobin'),
(3682, 'Hemoglobin A1C'),
(3683, 'Hemoptysis'),
(3684, 'Hepatitis'),
(3685, 'Hepatitis A 1'),
(3686, 'Hepatitis A 2'),
(3687, 'Hepatitis B 1'),
(3688, 'Hepatitis B 2'),
(3689, 'Hepatitis B 3'),
(3690, 'here'),
(3691, 'Here you can customize the ACL further.'),
(3692, 'Herero'),
(3693, 'Hernia Repair'),
(3694, 'Herniated Disc'),
(3695, 'Herpes'),
(3696, 'Hertel Exophthalmometry'),
(3697, 'HERT{{Hertel exophthalmometry}}'),
(3698, 'Hesitancy'),
(3699, 'heyyo. you have been here for '),
(3700, 'Hib 1'),
(3701, 'Hib 2'),
(3702, 'Hib 3'),
(3703, 'Hib 4'),
(3704, 'Hidden'),
(3705, 'Hidden Events Administration'),
(3706, 'Hide'),
(3707, 'Hide Billing Widget'),
(3708, 'Hide Details'),
(3709, 'Hide Empty E-Sign Logs On Report'),
(3710, 'Hide Encryption/Decryption Options In Document Management'),
(3711, 'Hide Menu'),
(3712, 'Hide print feature'),
(3713, 'Hide Reminders'),
(3714, 'hide this field'),
(3715, 'Hide/Show Columns'),
(3716, 'HIE'),
(3717, 'High'),
(3718, 'High (high)'),
(3719, 'High Blood Pressure'),
(3720, 'Hindi'),
(3721, 'Hip + groin'),
(3722, 'Hip and groin'),
(3723, 'Hip Problems'),
(3724, 'Hip Replacement'),
(3725, 'Hipaa Message'),
(3726, 'HIPAA Notice Received'),
(3727, 'Hiri Motu'),
(3728, 'Hirsutism/Striae'),
(3729, 'Hispanic'),
(3730, 'Hispanic - Other (Born in US)'),
(3731, 'Hispanic - Other (Born outside US)'),
(3732, 'Hispanic or Latino'),
(3733, 'Historical information -source unspecified'),
(3734, 'History'),
(3735, 'History & Lifestyle'),
(3736, 'History Data'),
(3737, 'History Date'),
(3738, 'History Fields'),
(3739, 'History Murmur'),
(3740, 'History not authorized'),
(3741, 'History of Heart Murmur'),
(3742, 'History of Present Illness: A detailed HPI may be completed by using either four or more HPI elements OR the status of three chronic or inactive problems.'),
(3743, 'History Order'),
(3744, 'History order'),
(3745, 'Hits'),
(3746, 'HIV'),
(3747, 'Hives'),
(3748, 'HL7'),
(3749, 'HL7 Code'),
(3750, 'HL7 Viewer'),
(3751, 'HL7-V3 Concept Code'),
(3752, 'HMOL/L'),
(3753, 'Hmong'),
(3754, 'Hold down [Ctrl] for multiple selections or to unselect'),
(3755, 'Hold down Ctrl to select multiple items'),
(3756, 'Hold down Ctrl to select multiple squads'),
(3757, 'Holidays management'),
(3758, 'Home'),
(3759, 'Home Phone'),
(3760, 'Home Phone Number'),
(3761, 'Homeless'),
(3762, 'Homeless or similar?'),
(3763, 'Homeless Shelter'),
(3764, 'Homeless, etc'),
(3765, 'Homeless, etc.'),
(3766, 'Hooks'),
(3767, 'Horiz Base{{abbreviation for Horizontal Prism Base}}'),
(3768, 'Horiz Prism{{abbreviation for Horizontal Prism Power}}'),
(3769, 'Horizontal Prism Base'),
(3770, 'Horizontal Prism Power'),
(3771, 'Hospice'),
(3772, 'Host'),
(3773, 'Host Name'),
(3774, 'Host Name cannot be empty'),
(3775, 'hour'),
(3776, 'Hour'),
(3777, 'Hours'),
(3778, 'hours'),
(3779, 'How bad is it? 0-10, mild, mod, severe?'),
(3780, 'How did Injury Occur?'),
(3781, 'How did Injury Occur?:'),
(3782, 'How did they hear about us'),
(3783, 'How long does it last?'),
(3784, 'How many months ahead to query for upcoming events?'),
(3785, 'How Referred'),
(3786, 'How to sort a drop-lists'),
(3787, 'How-to Build the Impression/Plan'),
(3788, 'HPI'),
(3789, 'HPI Elements'),
(3790, 'HPI:'),
(3791, 'HP{{abbreviation for Horizontal Prism Power}}'),
(3792, 'HT'),
(3793, 'HTML'),
(3794, 'HTML Output?'),
(3795, 'HTN{{hypertension}}'),
(3796, 'Https link for the OpenEMR Support LLC Lab Exchange Service.'),
(3797, 'HT{{hyperphoria}}'),
(3798, 'Hungarian'),
(3799, 'Hylafax Directory'),
(3800, 'Hylafax Enscript Command'),
(3801, 'Hylafax Server'),
(3802, 'Hylafax server hostname.'),
(3803, 'Hyperactive'),
(3804, 'Hyperphoria'),
(3805, 'Hypertension'),
(3806, 'Hypertension: Blood Pressure Measurement'),
(3807, 'Hypertension: Blood Pressure Measurement (CQM)'),
(3808, 'Hyperthyroidism'),
(3809, 'hypo(T){{intermittent hypotropia}}'),
(3810, 'Hypothyroidism'),
(3811, 'Hypotropia'),
(3812, 'hypoT{{hypotropia}}'),
(3813, 'Hysterectomy'),
(3814, 'I'),
(3815, 'I am busy during this time.'),
(3816, 'I do not have permission to read '),
(3817, 'I have read and accept the'),
(3818, 'I have read and my practice agrees to the'),
(3819, 'I know but we need it!'),
(3820, 'ICD'),
(3821, 'ICD10 Diagnosis'),
(3822, 'ICD10 Procedure/Service'),
(3823, 'ICD9'),
(3824, 'ICD9 Diagnosis'),
(3825, 'ICD9 Procedure/Service'),
(3826, 'Icelandic'),
(3827, 'icon'),
(3828, 'Icon Legend'),
(3829, 'ID'),
(3830, 'id'),
(3831, 'Id'),
(3832, 'ID cannot be blank'),
(3833, 'ID Card'),
(3834, 'ID Number (ETIN)'),
(3835, 'IDays'),
(3836, 'identified as'),
(3837, 'Identifier(one word)'),
(3838, 'Identifying Code'),
(3839, 'Idle Session Timeout Seconds'),
(3840, 'Ido'),
(3841, 'if'),
(3842, 'If a field\'s Data Col = 0 the data field will immediately follow its label field on the same line'),
(3843, 'If a field\'s Label Col = 0 the label will immediately follow the previous data field in the Order sequence, on the same line as the Data field.'),
(3844, 'If a field\'s Label Col = 1 the label field will go to a new line unless the previous field\'s total column values (Label + Data) is less than number of Layout columns from Group Properties or Layout Properties.'),
(3845, 'If all data for all columns are complete for this form'),
(3846, 'If billing justification is used enter the name of the diagnosis code type.'),
(3847, 'If enabled, uses the specified active directory for login and authentication.'),
(3848, 'if entered, select only those who have had this service'),
(3849, 'If name, any part of lastname or lastname,firstname'),
(3850, 'If patient has appointment click OK to create encounter otherwise, cancel this and then create an encounter for today visit.'),
(3851, 'If paying by'),
(3852, 'If person is deceased, then enter date of death.'),
(3853, 'If privileges have to be modified then it can be done either one user at a time at Administration > Users or more conveniently on this page i.e. Administration > ACL where all users are listed on one page and more options are available.'),
(3854, 'If SMTP is used, the server`s hostname or IP address.'),
(3855, 'If SMTP is used, the server`s TCP port number (usually 25).'),
(3856, 'If the csv file has been uploaded, then click on the \"Import holiday events\" button. NOTE that clicking on the button will remove all the existing rows in the calendar_external table'),
(3857, 'If this page does not refresh, reload the Messages page manually'),
(3858, 'If unassigned will default to php.ini setting for date.timezone.'),
(3859, 'if unemployed enter Student'),
(3860, 'If YMD is selected for age display, switch to just Years when patients older than this value in years'),
(3861, 'If you are having troubles logging into your account.'),
(3862, 'If you change e-RX Role for ePrescription, it may affect the ePrescription workflow. If you face any difficulty, contact your ePrescription vendor.'),
(3863, 'If you click on any user in the \'User Memberships\' section you will now see these newly created group (ARO) in the \'Inactive\' column. These can now be assigned in the usual fashion as needed.'),
(3864, 'If you click on the edit icon next to this newly created group (ARO) you will note that the \'Active\' column contains only a single entry - Placeholder (Maintains empty ACLs). As yet this new group (ARO) has NO access to any part of the program as there are no ACOs assigned in the \'Active\' column.'),
(3865, 'If you continue to experience this error please contact support.'),
(3866, 'If you do not select a match the patient will be created.'),
(3867, 'If you have already filled the calendar_external table, then click on \"Synchronize\" button to have the holidays in the calendar view. NOTE that clicking on the button will remove all the existing items in the calendar view related to holidays'),
(3868, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file.  You may click on any of these invoice numbers (as described below) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the Process ERA File button at the bottom of the page.  This will produce a new window with a detailed report.'),
(3869, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file.  This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date.  Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(3870, 'If you made changes and want to re-send it, delete the original (in Communications) and try again.'),
(3871, 'If you want to change data types, or add rows or columns'),
(3872, 'If you want to upgrade the database, then place the database zip file in the following directory'),
(3873, 'Igbo'),
(3874, 'Ignore'),
(3875, 'IIS Code'),
(3876, 'Illness'),
(3877, 'IM'),
(3878, 'Image canvas'),
(3879, 'Image Results'),
(3880, 'Images'),
(3881, 'Imaging'),
(3882, 'Imaging Service'),
(3883, 'Immune System'),
(3884, 'Immunization'),
(3885, 'Immunization Administered Site'),
(3886, 'Immunization Code'),
(3887, 'Immunization Completion Status'),
(3888, 'Immunization Date'),
(3889, 'Immunization Expiration Date'),
(3890, 'Immunization Information Source'),
(3891, 'Immunization Lot Number'),
(3892, 'Immunization Manufacturer'),
(3893, 'Immunization Observation Criteria'),
(3894, 'Immunization Observation Results'),
(3895, 'Immunization Ordering Provider'),
(3896, 'Immunization Refusal Reason'),
(3897, 'Immunization Registry'),
(3898, 'Immunization Registry Status'),
(3899, 'Immunization Registry Status Effective Date'),
(3900, 'Immunization Report'),
(3901, 'Immunization Service'),
(3902, 'Immunization Title'),
(3903, 'Immunization Vaccine Eligibility Results'),
(3904, 'Immunizations'),
(3905, 'Immunize'),
(3906, 'Immunologic'),
(3907, 'Immuno{{immunologic}}'),
(3908, 'IMMUNO{{Immunology/Rheumatology}}'),
(3909, 'Implants'),
(3910, 'Import'),
(3911, 'Import All'),
(3912, 'Import CCDA'),
(3913, 'Import CCR'),
(3914, 'Import certificate to the browser.'),
(3915, 'Import Configuration'),
(3916, 'Import deferred for time-to-live'),
(3917, 'Import Formularies'),
(3918, 'Import holiday events'),
(3919, 'Import Holidays'),
(3920, 'Import Patient'),
(3921, 'Import Patient Demographics'),
(3922, 'Import Patient Demographics XML'),
(3923, 'Import Pharmacies'),
(3924, 'Important Codes'),
(3925, 'IMPORTANT: This upload tool is only for uploading documents on patients that are not yet entered into the system. To upload files for patients whom already have been entered into the system, please use the upload tool linked within the Patient Summary screen.'),
(3926, 'Imported Allergies'),
(3927, 'Imported from Accounting'),
(3928, 'Imported Medications'),
(3929, 'Imported Problems'),
(3930, 'Impression/Plan'),
(3931, 'Impression/Plan Builder'),
(3932, 'Improved'),
(3933, 'IMP{{impression}}'),
(3934, 'in'),
(3935, 'IN'),
(3936, 'In Current Chat'),
(3937, 'in each eye'),
(3938, 'In exam room'),
(3939, 'in left eye'),
(3940, 'in nostril'),
(3941, 'In Office'),
(3942, 'In Portrait mode, determines the height of the envelope along the y-axis in mm'),
(3943, 'In Portrait mode, determines the width of the envelope along the x-axis in mm'),
(3944, 'in right eye'),
(3945, 'In the patient\'s words'),
(3946, 'In Use'),
(3947, 'in-house'),
(3948, 'In-process'),
(3949, 'Inactive'),
(3950, 'Inactive - Lost to follow - up'),
(3951, 'Inactive - Moved or gone elsewhere'),
(3952, 'Inactive - Permanently inactive'),
(3953, 'Inactive - Unspecified'),
(3954, 'Inactive Days'),
(3955, 'Inactive Messages'),
(3956, 'Inbox'),
(3957, 'INCITS Code'),
(3958, 'Include all values reported for each result code'),
(3959, 'Include Checksum'),
(3960, 'Include Completed'),
(3961, 'Include Inactive'),
(3962, 'Include inactive users'),
(3963, 'Include Uncategorized'),
(3964, 'Include Unstructured data'),
(3965, 'Include Vitals'),
(3966, 'Include vitals data?'),
(3967, 'Included Providers'),
(3968, 'including CVF{{Confrontational Visual Fields}} and Pupils'),
(3969, 'Inclusion'),
(3970, 'Income'),
(3971, 'Incoming results requiring attention:'),
(3972, 'Incomplete'),
(3973, 'Incomplete Abortion Treatment'),
(3974, 'Incontinence'),
(3975, 'Incorporate clinical lab-test results into certified EHR technology as structured data.'),
(3976, 'Incorrect password!'),
(3977, 'increased:'),
(3978, 'Indemnity Insurance'),
(3979, 'Independent Clinic'),
(3980, 'Independent Laboratory'),
(3981, 'Indeterminate'),
(3982, 'Indian'),
(3983, 'Indian Health Service Free-standing Facility'),
(3984, 'Indian Health Service Provider-based Facility'),
(3985, 'Indicates abnormality'),
(3986, 'Indicates if this issue is an ophthalmic-specific medication'),
(3987, 'Indicates if this issue is currently active'),
(3988, 'Indications'),
(3989, 'Indicator for specialized usage'),
(3990, 'Indigent Patients'),
(3991, 'Indigent Patients Report'),
(3992, 'Indigents'),
(3993, 'Individual access can be tailored to fit the needs by assigning a user to one or more groups (AROs). The user will then inherit all the privileges, i.e have access to parts of the program (ACO), of each group (ARO) the user belongs to.'),
(3994, 'Individual pages can override 2nd and 3rd options by implementing a log message.'),
(3995, 'Indonesian'),
(3996, 'Induced Abortion'),
(3997, 'Industry'),
(3998, 'Ineligible'),
(3999, 'Infection / Abscess'),
(4000, 'Infections'),
(4001, 'Infert Couns'),
(4002, 'Infertility'),
(4003, 'Influenza 1'),
(4004, 'Influenza 2'),
(4005, 'Influenza Immunization for Patients >= 50 Years Old'),
(4006, 'Influenza Immunization for Patients >= 50 Years Old (CQM)'),
(4007, 'Influenza Vaccine'),
(4008, 'Info'),
(4009, 'Info test 1'),
(4010, 'Info test 2'),
(4011, 'Info test 3'),
(4012, 'Info test 4'),
(4013, 'Info test 5'),
(4014, 'Info test 6'),
(4015, 'Informant'),
(4016, 'Information Source'),
(4017, 'inf{{inferior}}'),
(4018, 'inhalations'),
(4019, 'Inhale'),
(4020, 'inhilations'),
(4021, 'Initial Patient Population'),
(4022, 'Initial Treatment'),
(4023, 'Initial User'),
(4024, 'Initially Open Group'),
(4025, 'Inj/Rehab'),
(4026, 'Injectables'),
(4027, 'Injection'),
(4028, 'Injured Body Part'),
(4029, 'Injured Out'),
(4030, 'Injury'),
(4031, 'Injury Mechanism'),
(4032, 'Injury Overview Report'),
(4033, 'Injury Surveillance'),
(4034, 'Injury Type'),
(4035, 'Injury/illness-related'),
(4036, 'Inline'),
(4037, 'Inpatient Hospital'),
(4038, 'Inpatient Psychiatric Facility'),
(4039, 'Input does not begin with a MSH segment'),
(4040, 'Input Fields'),
(4041, 'INR'),
(4042, 'Ins 1'),
(4043, 'Ins 2 or Ins 3'),
(4044, 'Ins Address'),
(4045, 'Ins adjust'),
(4046, 'Ins bundling'),
(4047, 'Ins Code'),
(4048, 'Ins Group'),
(4049, 'Ins Name'),
(4050, 'Ins overpaid'),
(4051, 'Ins Policy'),
(4052, 'Ins refund'),
(4053, 'Ins Summary'),
(4054, 'Ins/fin issue'),
(4055, 'Ins1'),
(4056, 'Ins2'),
(4057, 'Ins3'),
(4058, 'Insert'),
(4059, 'Insert failed: '),
(4060, 'Insert normals'),
(4061, 'Insert normals - 100/100'),
(4062, 'Insert normals - 11/11'),
(4063, 'Insert old events into tables'),
(4064, 'Insert special field'),
(4065, 'Inserted'),
(4066, 'Insomnia'),
(4067, 'Inspect the log'),
(4068, 'Inspection'),
(4069, 'Instability / subluxation'),
(4070, 'INSTALL'),
(4071, 'Install'),
(4072, 'Install Code Set'),
(4073, 'install DB'),
(4074, 'Install Layout Service Codes'),
(4075, 'Installed Release'),
(4076, 'Instructed'),
(4077, 'Instruction'),
(4078, 'Instructions'),
(4079, 'Instructions:'),
(4080, 'Insufficient inventory for product'),
(4081, 'Insufficient inventory for product ID'),
(4082, 'Insulin Dependent Diabetes'),
(4083, 'Insurance'),
(4084, 'insurance'),
(4085, 'Insurance Adj'),
(4086, 'Insurance Adjustment'),
(4087, 'Insurance Balance'),
(4088, 'Insurance Balance Due'),
(4089, 'Insurance Comp'),
(4090, 'Insurance Companies'),
(4091, 'Insurance Company'),
(4092, 'Insurance Company Search/Add'),
(4093, 'Insurance Credit'),
(4094, 'Insurance Data'),
(4095, 'Insurance information on file'),
(4096, 'Insurance Numbers'),
(4097, 'Insurance Payment'),
(4098, 'Insurance Payments'),
(4099, 'Insurance Provider'),
(4100, 'Insurance Search/Select/Add'),
(4101, 'Insurance Types'),
(4102, 'Insurances'),
(4103, 'Insured'),
(4104, 'Intake Conclusion'),
(4105, 'Intake Date'),
(4106, 'Integers1-100'),
(4107, 'Intellectual Decline'),
(4108, 'Inter-pupillary distance'),
(4109, 'Interlingua'),
(4110, 'Interlingue'),
(4111, 'Intermediate Care Facility/Mentally Retarded'),
(4112, 'Intermittent Esotropia'),
(4113, 'Intermittent Exotropia'),
(4114, 'intermittent hyperphoria'),
(4115, 'Intermittent hypotropia'),
(4116, 'Internal Allergies'),
(4117, 'Internal error - no pages were selected!'),
(4118, 'Internal error - patient ID was not provided!'),
(4119, 'Internal error accessing uploaded file!'),
(4120, 'Internal error in tableNameFromLayout'),
(4121, 'Internal error!'),
(4122, 'Internal error, no drug ID specified!'),
(4123, 'Internal error: Cannot find MSH-10'),
(4124, 'Internal error: claim '),
(4125, 'Internal error: encounter \''),
(4126, 'Internal error: pid or encounter is missing.'),
(4127, 'Internal error: we do not seem to be in an encounter!'),
(4128, 'Internal Identifier (pid)'),
(4129, 'Internal Medications'),
(4130, 'Internal Problems'),
(4131, 'Internal Referrals'),
(4132, 'Internal Time Collected'),
(4133, 'International Duty'),
(4134, 'Interpreter'),
(4135, 'Interpreter needed?'),
(4136, 'Interstitial Lung Disease'),
(4137, 'Interval'),
(4138, 'Interval (minutes)'),
(4139, 'Interval between message checks (set to zero for manual checks only)'),
(4140, 'Intervention'),
(4141, 'Intervention Provided'),
(4142, 'Intolerance'),
(4143, 'Intradermal'),
(4144, 'Intramuscular'),
(4145, 'intramuscularly'),
(4146, 'Intraocular Pressures'),
(4147, 'Intraocular Pressures (mmHg) by Date'),
(4148, 'intravenously'),
(4149, 'Introduction'),
(4150, 'Inuktitut'),
(4151, 'Inupiaq'),
(4152, 'Invalid character in'),
(4153, 'Invalid Credit Card Number'),
(4154, 'Invalid Credit Card Values: Please correct'),
(4155, 'Invalid date range'),
(4156, 'Invalid encapsulated data encoding type'),
(4157, 'Invalid layout ID'),
(4158, 'Invalid length for'),
(4159, 'Invalid non-numeric character in'),
(4160, 'Invalid or missing payer in source for code '),
(4161, 'Invalid recipient address. Please try again.'),
(4162, 'Invalid Service Codes'),
(4163, 'Invalid source designation \"'),
(4164, 'Invalid Total!'),
(4165, 'Invalid username or password'),
(4166, 'InvAmt'),
(4167, 'Inventory'),
(4168, 'Inventory Activity'),
(4169, 'Inventory and sell both drugs and non-drug products'),
(4170, 'Inventory and sell drugs only'),
(4171, 'Inventory is not available for this order.'),
(4172, 'Inventory List'),
(4173, 'Inventory Transactions'),
(4174, 'Invoice'),
(4175, 'invoice'),
(4176, 'Invoice Balance'),
(4177, 'Invoice Balance cannot be posted. No Encounter is created.'),
(4178, 'Invoice Date'),
(4179, 'Invoice has no date!'),
(4180, 'Invoice Number'),
(4181, 'Invoice Reference Number'),
(4182, 'Invoice reference number pool, if used'),
(4183, 'Invoice Reference Number Pools'),
(4184, 'Invoice Refno Pool'),
(4185, 'Invoice:'),
(4186, 'IOP Chart'),
(4187, 'IOP Dilated{{Dilated Intraocular Pressure}}'),
(4188, 'IOP Graph'),
(4189, 'IPPF'),
(4190, 'IPPF Abortion'),
(4191, 'IPPF Contraception'),
(4192, 'IPPF SRH Data for'),
(4193, 'IPPF Statistics Report'),
(4194, 'IPPF Stats'),
(4195, 'IPV 1'),
(4196, 'IPV 2'),
(4197, 'IPV 3'),
(4198, 'IPV 4'),
(4199, 'Iris'),
(4200, 'Irish'),
(4201, 'Irregular Heart Beat'),
(4202, 'Irritability'),
(4203, 'Irritation'),
(4204, 'is a different language version of the following database'),
(4205, 'is a different version of the following database'),
(4206, 'is a more recent version of the following database'),
(4207, 'is a required field.'),
(4208, 'is a root node and can not be deleted.'),
(4209, 'is an extension of the following database'),
(4210, 'Is Authorizing Signature'),
(4211, 'Is it ok to map these CVX codes to already existent immunizations?'),
(4212, 'is misplaced or unknown'),
(4213, 'is not a valid email address'),
(4214, 'Is not selected'),
(4215, 'is not valid'),
(4216, 'is not valid (decimal fractions are OK).'),
(4217, 'Is PHP using Safe Mode?'),
(4218, 'Is selected'),
(4219, 'Is text from form layouts to be translated?'),
(4220, 'Is text from lists to be translated?'),
(4221, 'Is The File Encrypted?'),
(4222, 'Is this a Clinical Term code type?'),
(4223, 'Is this a diagnosis type?'),
(4224, 'Is this a Medical Problem code type?'),
(4225, 'Is this a Medication type?'),
(4226, 'Is this a procedure/service type?'),
(4227, 'Is this active?'),
(4228, 'Is this code type active?'),
(4229, 'Is this code type used in claims?'),
(4230, 'Is this Okay?'),
(4231, 'Is this really OK?'),
(4232, 'Is this type hidden in the fee sheet?'),
(4233, 'Is this using external sql tables? If it is, then choose the format.'),
(4234, 'is too long'),
(4235, 'ISO 639-2 Code'),
(4236, 'Issue'),
(4237, 'issue'),
(4238, 'Issue Date'),
(4239, 'Issue ID'),
(4240, 'Issue Subtypes'),
(4241, 'Issue Title'),
(4242, 'Issue Type'),
(4243, 'Issue Types'),
(4244, 'Issues'),
(4245, 'Issues (Injuries/Medical/Allergy)'),
(4246, 'Issues (Injuries/Medical/Allergy):'),
(4247, 'Issues and Encounters'),
(4248, 'Issues and Encounters for'),
(4249, 'Issues List'),
(4250, 'Issues not authorized'),
(4251, 'Issues Section'),
(4252, 'It also lets you create new groups (AROs) as well as remove existing ones.'),
(4253, 'Italian'),
(4254, 'Item'),
(4255, 'item'),
(4256, 'items'),
(4257, 'Items load failed'),
(4258, 'IU/L'),
(4259, 'IUD'),
(4260, 'IV'),
(4261, 'Jaeger'),
(4262, 'Jaeger{{Near Acuity Type Jaeger}}'),
(4263, 'Jan'),
(4264, 'January'),
(4265, 'Japanese'),
(4266, 'Jaundice'),
(4267, 'Javanese'),
(4268, 'Job Description'),
(4269, 'Job ID'),
(4270, 'Joint dislocations'),
(4271, 'Joint Pain'),
(4272, 'Joint sprains'),
(4273, 'Jul'),
(4274, 'July'),
(4275, 'Jun'),
(4276, 'June'),
(4277, 'Just below the check information is a blue area where you put in your search parameters.  You can search by patient name, chart number, encounter number or date of service, or any combination of these.  You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient).  Click the Search button to perform the search.'),
(4278, 'Just Mine'),
(4279, 'Justification Entries'),
(4280, 'Justify'),
(4281, 'Justify Dx'),
(4282, 'Justify/Save'),
(4283, 'J{{Justify Header}}'),
(4284, 'k, here\'s the rest '),
(4285, 'K1{{Keratometry 1}}'),
(4286, 'K2{{Keratometry 2}}'),
(4287, 'Kalaallisut, Greenlandic'),
(4288, 'Kannada'),
(4289, 'Kanuri'),
(4290, 'Kashmiri'),
(4291, 'Kazakh'),
(4292, 'key'),
(4293, 'Key'),
(4294, 'Key for multiple database credentials encryption'),
(4295, 'Keywords'),
(4296, 'kg'),
(4297, 'kg/m^2'),
(4298, 'Khmer'),
(4299, 'Kidney Cancer'),
(4300, 'Kidney Failure'),
(4301, 'Kidney Infections'),
(4302, 'Kidney Stones'),
(4303, 'Kidney Transplant'),
(4304, 'Kikuyu, Gikuyu'),
(4305, 'Kinyarwanda'),
(4306, 'Kiosk'),
(4307, 'Kirundi'),
(4308, 'Knee'),
(4309, 'Knee Problems'),
(4310, 'Knee Replacement'),
(4311, 'Komi'),
(4312, 'Kongo'),
(4313, 'Korean'),
(4314, 'Kurdish'),
(4315, 'Kwanyama, Kuanyama'),
(4316, 'Kyrgyz'),
(4317, 'Lab'),
(4318, 'Lab Documents'),
(4319, 'Lab Exchange Site Address'),
(4320, 'Lab Exchange Site ID'),
(4321, 'Lab Exchange Token ID'),
(4322, 'Lab Order'),
(4323, 'Lab overview'),
(4324, 'Lab Overview'),
(4325, 'Lab Query Status'),
(4326, 'Lab Report'),
(4327, 'Lab Result'),
(4328, 'Lab Results'),
(4329, 'Lab Results (write,addonly optional)'),
(4330, 'Lab Results Category Name'),
(4331, 'Lab Results Report'),
(4332, 'Lab Service'),
(4333, 'Lab Test Results'),
(4334, 'Lab/File'),
(4335, 'Label'),
(4336, 'Label cannot be blank'),
(4337, 'Label Cols'),
(4338, 'Label for this type'),
(4339, 'Label printed by'),
(4340, 'LabelCols must be a number between 1 and 999'),
(4341, 'Labels'),
(4342, 'Laboratory Information'),
(4343, 'Laboratory Test'),
(4344, 'Labs'),
(4345, 'Laceration / skin condition'),
(4346, 'Laceration/abrasion'),
(4347, 'LAC{{left anterior chamber}}'),
(4348, 'LADate'),
(4349, 'LAD{{left adnexa}}'),
(4350, 'Landscape'),
(4351, 'Language'),
(4352, 'Language Code'),
(4353, 'Language definition added'),
(4354, 'Language Interface Tool'),
(4355, 'Language Interface Tool (language)'),
(4356, 'Language List (write,addonly optional)'),
(4357, 'Language List (write,addonly optional) (language)'),
(4358, 'Language Name'),
(4359, 'Language:'),
(4360, 'Lao'),
(4361, 'Laotian'),
(4362, 'Laser Interferometry'),
(4363, 'Laser Interferometry Acuity'),
(4364, 'Last'),
(4365, 'Last Activity Date'),
(4366, 'Last Appendectomy'),
(4367, 'Last Bill Date:'),
(4368, 'Last Breast Exam'),
(4369, 'Last Calendar Year'),
(4370, 'Last Cataract Surgery'),
(4371, 'Last Cholecystestomy'),
(4372, 'last date of this event'),
(4373, 'Last Encounter'),
(4374, 'Last Gyn. Exam'),
(4375, 'Last Heart Surgery'),
(4376, 'Last Hernia Repair'),
(4377, 'Last Hip Replacement'),
(4378, 'Last Hysterectomy'),
(4379, 'Last Knee Replacement'),
(4380, 'Last Level Billed'),
(4381, 'Last Mammogram'),
(4382, 'Last Menstrual Period'),
(4383, 'Last Modified'),
(4384, 'Last Month'),
(4385, 'Last Name'),
(4386, 'Last name'),
(4387, 'Last name, first name'),
(4388, 'Last name, first name (title)'),
(4389, 'Last name, first name (title: comments)'),
(4390, 'Last Name:'),
(4391, 'Last Physical Exam'),
(4392, 'Last Prostate Exam'),
(4393, 'Last Rectal Exam'),
(4394, 'Last Reviewed'),
(4395, 'Last Run Started At'),
(4396, 'Last Saved'),
(4397, 'Last Sigmoid/Colonoscopy'),
(4398, 'Last Stmt'),
(4399, 'Last Tonsillectomy'),
(4400, 'Last update by'),
(4401, 'Last Verified On'),
(4402, 'Last Visit'),
(4403, 'Last X-ray'),
(4404, 'Late Recurrence (2-12 Mo)'),
(4405, 'Lateral Malleolus'),
(4406, 'Lateral malleolus:'),
(4407, 'Laterality'),
(4408, 'Laterality of this procedure, if applicable'),
(4409, 'laterally displaced PMI:'),
(4410, 'Latest Health Alerts'),
(4411, 'Latest Medical Records'),
(4412, 'Latest Results Only'),
(4413, 'Latest Visit or Consultation'),
(4414, 'Latin'),
(4415, 'Latvian'),
(4416, 'lat{{lateral}}'),
(4417, 'Law Firm'),
(4418, 'Lawyer'),
(4419, 'Layout'),
(4420, 'Layout (need to logout/login after change this setting)'),
(4421, 'Layout Based'),
(4422, 'Layout Columns'),
(4423, 'Layout Editor'),
(4424, 'Layout groups'),
(4425, 'Layout ID'),
(4426, 'Layout Properties'),
(4427, 'Layout Style'),
(4428, 'Layout-Based Transaction Forms'),
(4429, 'Layout-Based Visit Forms'),
(4430, 'Layouts'),
(4431, 'lb'),
(4432, 'LBF Encounter Form Preview'),
(4433, 'LBF_Validations'),
(4434, 'lbs'),
(4435, 'LB{{left brow}}'),
(4436, 'LCMT{{left Central Macular Thickness}}'),
(4437, 'LCUP{{left cup}}'),
(4438, 'LC{{left conjunctiva}}'),
(4439, 'LDL'),
(4440, 'LD{{left disc}}'),
(4441, 'leave blank if still active'),
(4442, 'Leave Blank To Keep Original Filename'),
(4443, 'Leave blank to keep password unchanged.'),
(4444, 'Leave Message With'),
(4445, 'Leave The Form'),
(4446, 'Leaving the pass phrase blank will not encrypt the document'),
(4447, 'Ledger'),
(4448, 'Left'),
(4449, 'Left Arm'),
(4450, 'Left Deltoid'),
(4451, 'Left Ear'),
(4452, 'left ear'),
(4453, 'Left Gluteus Medius'),
(4454, 'Left Lens'),
(4455, 'Left Lower Forearm'),
(4456, 'Left Margin (mm)'),
(4457, 'Left Thigh'),
(4458, 'Left Vastus Lateralis'),
(4459, 'Left w/o visit'),
(4460, 'Left:'),
(4461, 'Left: '),
(4462, 'Leg Pain/Cramping'),
(4463, 'Legal'),
(4464, 'Legal Authenticator'),
(4465, 'Legal Paper Size'),
(4466, 'Legend:'),
(4467, 'Length'),
(4468, 'Length of modifier, 0 if none'),
(4469, 'Lens'),
(4470, 'Lens Material'),
(4471, 'Lens Material Options'),
(4472, 'Lens Thickness'),
(4473, 'Lens Treatments'),
(4474, 'Less Than'),
(4475, 'Less Than or Equal To'),
(4476, 'Less-private information (write,addonly optional)'),
(4477, 'Less-private information (write,addonly optional) (relaxed)'),
(4478, 'Letter'),
(4479, 'Letter Generator'),
(4480, 'Letter Paper Size'),
(4481, 'Letterhead that doctor signs'),
(4482, 'Letterhead that patient signs'),
(4483, 'Lev Fn{{levator function}}'),
(4484, 'Levator Function'),
(4485, 'Level of urgency'),
(4486, 'LF{{levator function}}'),
(4487, 'LH{{left hertel measurement}}'),
(4488, 'Liability'),
(4489, 'Liability Medical'),
(4490, 'Library'),
(4491, 'License/ID'),
(4492, 'Licensed Prescriber First Name'),
(4493, 'Licensed Prescriber Last Name'),
(4494, 'Licensed Prescriber NPI'),
(4495, 'Licensed Prescriber Title (Prefix)'),
(4496, 'LicensedPrescriber Last name'),
(4497, 'LicensedPrescriber NPI'),
(4498, 'LicensedPrescriber UPIN'),
(4499, 'Life partner'),
(4500, 'Life threatening severity'),
(4501, 'Lifestyle'),
(4502, 'Lifestyle status'),
(4503, 'Ligament tear or sprain'),
(4504, 'Light tobacco smoker'),
(4505, 'Limburgish, Limburgan, Limburger'),
(4506, 'Limit Of Events'),
(4507, 'Limited Exam'),
(4508, 'Limited HPI'),
(4509, 'Limits'),
(4510, 'Line'),
(4511, 'Lingala'),
(4512, 'Link'),
(4513, 'Link To Patient'),
(4514, 'Linked'),
(4515, 'Linked document'),
(4516, 'Linked procedure order'),
(4517, 'linked to document'),
(4518, 'linked to procedure order'),
(4519, 'List'),
(4520, 'List box'),
(4521, 'list box'),
(4522, 'list box w/ add'),
(4523, 'List box w/add'),
(4524, 'List Editor'),
(4525, 'List encounters'),
(4526, 'List groups'),
(4527, 'List Insurance Companies'),
(4528, 'List item ID'),
(4529, 'List items can not start with a number.'),
(4530, 'List items contains illegal character(s).'),
(4531, 'List layout items'),
(4532, 'List lists'),
(4533, 'List Name'),
(4534, 'List names cannot start with numbers.'),
(4535, 'List of previous refractions'),
(4536, 'List of previously dispensed Spectacle and Contact Lens Rxs'),
(4537, 'List Prescriptions'),
(4538, 'List used by above Country Data Type option.'),
(4539, 'List used by above State Data Type option.'),
(4540, 'Listening port of the RFC 5425 TLS syslog server.'),
(4541, 'Lists'),
(4542, 'Lists (lists)'),
(4543, 'Lithuanian'),
(4544, 'Living Will'),
(4545, 'LI{{Laser Interferometry Acuity}}'),
(4546, 'LI{{Laser Interferometry}}'),
(4547, 'LK{{left cornea}}'),
(4548, 'LLL:'),
(4549, 'LLL{{left lower eyelid}}'),
(4550, 'LL{{left iris}}'),
(4551, 'LL{{left lens}}'),
(4552, 'LMAC{{left macula}}'),
(4553, 'LMC{{left medial chathus}}'),
(4554, 'LMP'),
(4555, 'Load Compendium'),
(4556, 'Load Definitions'),
(4557, 'Load Lab Configuration'),
(4558, 'Load OE Question Options'),
(4559, 'Load Order Definitions'),
(4560, 'Load Order Entry Questions'),
(4561, 'LOAD SUCCESSFUL. Codes inserted'),
(4562, 'LOADING'),
(4563, 'Loading'),
(4564, 'Loading the files into the database. This will take some time...'),
(4565, 'Loading... Please wait'),
(4566, 'LOC'),
(4567, 'Local'),
(4568, 'Local Content'),
(4569, 'Local Filesystem'),
(4570, 'Locale'),
(4571, 'Locality'),
(4572, 'Location'),
(4573, 'location of the openemr machine and may contain sensitive data, so it is recommended to manually delete the files after its use'),
(4574, 'Location of this lot'),
(4575, 'Location unspecified'),
(4576, 'Location where Hylafax stores faxes.'),
(4577, 'Location where scans are stored.'),
(4578, 'Location:'),
(4579, 'Lock'),
(4580, 'Lock an e-signed form individually'),
(4581, 'Lock e-signed encounters and their forms'),
(4582, 'Lock?'),
(4583, 'Locked'),
(4584, 'Log all NewCrop eRx Requests and / or Responses.'),
(4585, 'Log entire document'),
(4586, 'Log In'),
(4587, 'Log in'),
(4588, 'Log Out'),
(4589, 'Logged in'),
(4590, 'Logged in as'),
(4591, 'Logged in as: '),
(4592, 'Logged out.'),
(4593, 'Logging'),
(4594, 'Login'),
(4595, 'login'),
(4596, 'Login name of WordPress user for portal access'),
(4597, 'Login to remote host'),
(4598, 'Login to this remote host failed'),
(4599, 'Logout'),
(4600, 'logout'),
(4601, 'Logs'),
(4602, 'Logs Viewer'),
(4603, 'LOINC'),
(4604, 'LOINC Code'),
(4605, 'Look Up'),
(4606, 'Lot'),
(4607, 'Lot ID missing!'),
(4608, 'Lot Number'),
(4609, 'Low'),
(4610, 'Low Priority'),
(4611, 'Lower leg'),
(4612, 'Lower Lids'),
(4613, 'Lowest Priority'),
(4614, 'LP{{left peripheral retina}}'),
(4615, 'LT{{lens thickness}}'),
(4616, 'Luba-Katanga'),
(4617, 'Luhn'),
(4618, 'LUL{{left upper eyelid}}'),
(4619, 'Lumbar spine'),
(4620, 'LUNCH'),
(4621, 'Lunch'),
(4622, 'Lung Cancer'),
(4623, 'Lung Cancer Surgery'),
(4624, 'LUNGS:'),
(4625, 'Lungs:'),
(4626, 'Lupus'),
(4627, 'Luxembourgish, Letzeburgesch'),
(4628, 'LV{{left vessels}}'),
(4629, 'L{{left side}}'),
(4630, 'L{{left}}'),
(4631, 'M'),
(4632, 'MA Category'),
(4633, 'MA Client Accepting Abortion'),
(4634, 'MA Stats'),
(4635, 'Macedonian'),
(4636, 'Macula'),
(4637, 'Mail'),
(4638, 'Mail Order'),
(4639, 'Mail Sent'),
(4640, 'Main'),
(4641, 'Main Address'),
(4642, 'Main Counselors'),
(4643, 'Main Menu Role'),
(4644, 'Main Provider'),
(4645, 'Main Top Pane Screen'),
(4646, 'Main Top Pane Screen(Or Default First Tab)'),
(4647, 'Maintain active medication allergy list.'),
(4648, 'Maintain active medication list.'),
(4649, 'Maintain an up-to-date problem list of current and active diagnoses.'),
(4650, 'Make modifications to current categories.'),
(4651, 'Make new appointment for'),
(4652, 'Make Payment'),
(4653, 'Make subsequent fields in the same row, Label = 0 Data = 0 and ensure enough columns are available from previous items to allow space for this new item. Otherwise result could be unpredictable'),
(4654, 'Make sure \"'),
(4655, 'Making batch text files for uploading to Clearing House and will mark as billed'),
(4656, 'Malagasy'),
(4657, 'Malaise:'),
(4658, 'Malay'),
(4659, 'Malayalam'),
(4660, 'Male'),
(4661, 'Male Condoms'),
(4662, 'Male VSC'),
(4663, 'Maltese'),
(4664, 'Mammogram'),
(4665, 'Manage'),
(4666, 'Manage Hooks'),
(4667, 'Manage Lists'),
(4668, 'Manage modules'),
(4669, 'Manage Modules'),
(4670, 'Manage Templates'),
(4671, 'Manage Translations'),
(4672, 'Management'),
(4673, 'Manager'),
(4674, 'Mandatory'),
(4675, 'Mandatory and specified fields'),
(4676, 'Mandatory or specified fields only, dup check, no search'),
(4677, 'Mandatory or specified fields only, search and dup check'),
(4678, 'Mandatory or specified fields only, use patient validation Zend module'),
(4679, 'Manifest (Dry) Refraction'),
(4680, 'Manual'),
(4681, 'Manual Posting'),
(4682, 'Manual Processing Required'),
(4683, 'Manually retrieve description on Fee Sheet'),
(4684, 'Manually type into the New DX box above.'),
(4685, 'Manufacturer'),
(4686, 'Manx'),
(4687, 'Many code items have a lookup/hint.'),
(4688, 'Maori'),
(4689, 'Mar'),
(4690, 'Marathi'),
(4691, 'Marathi (Marathi)'),
(4692, 'Marathi (Marāṭhī)'),
(4693, 'March'),
(4694, 'Marginal Reflex Distance'),
(4695, 'Marital'),
(4696, 'Marital Status'),
(4697, 'Mark all as read'),
(4698, 'Mark as Billed'),
(4699, 'Mark as billed but skip billing'),
(4700, 'Mark as Cleared'),
(4701, 'Mark as not billed'),
(4702, 'Mark Note as Completed'),
(4703, 'Mark these reports as reviewed'),
(4704, 'Marked as cleared'),
(4705, 'Married'),
(4706, 'Marshallese'),
(4707, 'Mask'),
(4708, 'Mask for Invoice Numbers'),
(4709, 'Mask for Patient IDs'),
(4710, 'Mask for Product IDs'),
(4711, 'Mass Immunization Center'),
(4712, 'Match'),
(4713, 'Match case'),
(4714, 'Match Found'),
(4715, 'Matched Patient'),
(4716, 'MaternalAunt'),
(4717, 'MaternalCousin'),
(4718, 'MaternalGrandparent'),
(4719, 'MaternalGreatgrandparent'),
(4720, 'MaternalUncle'),
(4721, 'Matrix'),
(4722, 'max'),
(4723, 'Max'),
(4724, 'max file count reached'),
(4725, 'max file count reached - reload names below'),
(4726, 'Max Size'),
(4727, 'Maxillary Right:'),
(4728, 'Maximum Age'),
(4729, 'Maximum characters'),
(4730, 'Maximum idle time in seconds before logout. Default is 7200 (2 hours).'),
(4731, 'Maximum number of times a Patient can be tested in a year'),
(4732, 'Maximum number of times a Patient can be tested in a year. Zero is no limit.'),
(4733, 'Maximum reasonable inventory, 0 if not applicable'),
(4734, 'Maximum Size'),
(4735, 'Maximum Size (entering 0 will allow any size)'),
(4736, 'Maximum size of thumbnail file'),
(4737, 'May'),
(4738, 'MC'),
(4739, 'mcg'),
(4740, 'MDM Document Category Name'),
(4741, 'Means none of last three passwords are allowed when changing a password.'),
(4742, 'Measure Blood Pressure'),
(4743, 'Measure Group Code'),
(4744, 'Measure INR'),
(4745, 'Measurement'),
(4746, 'Medial Canthi'),
(4747, 'Medial malleolus:'),
(4748, 'Medicaid'),
(4749, 'Medical'),
(4750, 'Medical Abortion'),
(4751, 'Medical Administration'),
(4752, 'Medical History'),
(4753, 'Medical Issue'),
(4754, 'Medical issue'),
(4755, 'Medical Problem'),
(4756, 'Medical problem'),
(4757, 'Medical Problem Issue List'),
(4758, 'Medical Problems'),
(4759, 'Medical Record'),
(4760, 'Medical Record #'),
(4761, 'Medical Records'),
(4762, 'Medical Records and History (write,addonly optional) (med)'),
(4763, 'Medical Records Sent'),
(4764, 'Medical Specialty'),
(4765, 'Medical Summary Given'),
(4766, 'Medical System'),
(4767, 'Medical Type'),
(4768, 'Medical/History (write,addonly optional)'),
(4769, 'Medicare Part B'),
(4770, 'Medicare Referrer Is Renderer'),
(4771, 'Medication'),
(4772, 'Medication Allergy List'),
(4773, 'Medication Issue List'),
(4774, 'Medication List'),
(4775, 'Medication Reconciliation Performed?'),
(4776, 'Medications'),
(4777, 'Medications Allergy List'),
(4778, 'Medications:'),
(4779, 'Medicine Units'),
(4780, 'Medium'),
(4781, 'MedlinePlus Connect'),
(4782, 'med{{medial}}'),
(4783, 'Member Association Statistics Report'),
(4784, 'Memory Problems'),
(4785, 'Men'),
(4786, 'Men and Women'),
(4787, 'Men Only'),
(4788, 'Menarche'),
(4789, 'Menopause'),
(4790, 'Menstrual Flow'),
(4791, 'Menstrual Frequency'),
(4792, 'Mental Illness'),
(4793, 'Mental Status'),
(4794, 'Menu'),
(4795, 'Menu Text'),
(4796, 'Menus'),
(4797, 'Merge'),
(4798, 'Merge complete.'),
(4799, 'Merge Patients'),
(4800, 'Merge to any patient'),
(4801, 'Message'),
(4802, 'Message and Reminder Center'),
(4803, 'Message Center'),
(4804, 'Message content is not plain text so it has been stored as a document.'),
(4805, 'Message from patient'),
(4806, 'Message Log'),
(4807, 'Message Sent'),
(4808, 'Message Status'),
(4809, 'Message Title'),
(4810, 'Message to patient'),
(4811, 'Message to Reviewer'),
(4812, 'Message type'),
(4813, 'MESSAGE:'),
(4814, 'Messages'),
(4815, 'Messages Screen'),
(4816, 'Messages You have sent Today'),
(4817, 'Messaging'),
(4818, 'Method'),
(4819, 'Method and Specific Product'),
(4820, 'Method Change at this Clinic'),
(4821, 'Method for sending outgoing email.'),
(4822, 'Method of Destruction'),
(4823, 'Mexican/MexAmer/Chicano'),
(4824, 'Mexico'),
(4825, 'mg'),
(4826, 'mg/1cc'),
(4827, 'mg/2cc'),
(4828, 'mg/3cc'),
(4829, 'mg/4cc'),
(4830, 'mg/5cc'),
(4831, 'MG/DL'),
(4832, 'mid'),
(4833, 'Middle'),
(4834, 'Middle Name'),
(4835, 'Middle name'),
(4836, 'Midlevel Prescriber'),
(4837, 'Midlevel Prescriber DEA'),
(4838, 'Midlevel Prescriber First name'),
(4839, 'Midlevel Prescriber Last name'),
(4840, 'Midlevel Prescriber Prefix'),
(4841, 'Midlevel Prescriber UPIN'),
(4842, 'Mid{{Middle Distance Add}}'),
(4843, 'Mid{{middle Rx strength}}'),
(4844, 'Mid{{Middle segment in a trifocal glasses prescription}}'),
(4845, 'mid{{middle}}'),
(4846, 'Mien'),
(4847, 'Migrant or seasonal worker?'),
(4848, 'Migrant Seasonal'),
(4849, 'Migrant/Seasonal'),
(4850, 'Mil/CU.MM'),
(4851, 'Mild'),
(4852, 'Mild to moderate'),
(4853, 'Military Treatment Facility'),
(4854, 'MIME Type'),
(4855, 'MimeType'),
(4856, 'Min'),
(4857, 'min'),
(4858, 'Mini'),
(4859, 'Minimum Age'),
(4860, 'Minor joint strain +/- synovitis'),
(4861, 'minute'),
(4862, 'Minute'),
(4863, 'minutes'),
(4864, 'Minutes'),
(4865, 'Mirth IP'),
(4866, 'Misc'),
(4867, 'Misc Billing Options'),
(4868, 'Misc Billing Options for HCFA-1500'),
(4869, 'Misc Billing Options HCFA'),
(4870, 'Miscellaneous'),
(4871, 'Miscellaneous Billing Options for HCFA-1500'),
(4872, 'Missed'),
(4873, 'missing'),
(4874, 'Missing a required field'),
(4875, 'Missing a required field and will be highlighted'),
(4876, 'Missing Fee'),
(4877, 'Missing Mods Only'),
(4878, 'Missing or Invalid'),
(4879, 'Missing PID.'),
(4880, 'Missing report date'),
(4881, 'Missing slash after payer in source for code '),
(4882, 'Missing Title'),
(4883, 'Mixed'),
(4884, 'mL'),
(4885, 'ml'),
(4886, 'MM/DD/YYYY'),
(4887, 'mm/hg'),
(4888, 'mmHg'),
(4889, 'MMR 1'),
(4890, 'MMR 2'),
(4891, 'mm{{millimeters}}'),
(4892, 'Mobile'),
(4893, 'Mobile Phone'),
(4894, 'Mobile Unit'),
(4895, 'Mod'),
(4896, 'Mod Date'),
(4897, 'Mode - Do Not Show SQL Queries'),
(4898, 'Moderate'),
(4899, 'Moderate Priority'),
(4900, 'Moderate to severe'),
(4901, 'Moderate/Low Priority'),
(4902, 'Modern/images'),
(4903, 'Modifier'),
(4904, 'Modifier 22: Increased Procedural Services: When the work required to provide a service is substantially greater than typically required, it may be identified by adding modifier 22 to the usual procedure code.'),
(4905, 'Modifier 24: Unrelated Evaluation and Management Service by the Same Physician During a Postoperative Period'),
(4906, 'Modifier 25: Significant, separately identifiable evaluation and management (E/M) service by the same physician on the day of a procedure or other service'),
(4907, 'Modifier 57: Indicates an Evaluation and Management (E/M) service resulted in the initial decision to perform surgery either the day before a major surgery (90 day global) or the day of a major surgery.'),
(4908, 'Modifier(s)'),
(4909, 'Modifiers'),
(4910, 'Modify'),
(4911, 'Modify Date'),
(4912, 'Modify Patient Form'),
(4913, 'Modify Payments'),
(4914, 'Modifying'),
(4915, 'ModLength'),
(4916, 'Module'),
(4917, 'Module Directory not found'),
(4918, 'Module Installer'),
(4919, 'Module Name'),
(4920, 'Module name already exist'),
(4921, 'Modules'),
(4922, 'Mon'),
(4923, 'Mon thru Fri'),
(4924, 'Mon, Wed &amp; Fri'),
(4925, 'Monday'),
(4926, 'Mongolian'),
(4927, 'Monocular Pupillary Diameter - Distance'),
(4928, 'Monocular Pupillary Diameter - Near'),
(4929, 'month'),
(4930, 'Month'),
(4931, 'Month View'),
(4932, 'Month(s)'),
(4933, 'Monthly Income'),
(4934, 'months'),
(4935, 'Months'),
(4936, 'Mood/Affect Nml{{Mood and affect normal}}'),
(4937, 'More options'),
(4938, 'More than 100 records found. Please narrow your search criteria.'),
(4939, 'More than 50 results, please make your search more specific.'),
(4940, 'Most column headers can be clicked to change sort order'),
(4941, 'Most often this is due to a Username/Password mismatch'),
(4942, 'Most recent from'),
(4943, 'Most recent lab data:'),
(4944, 'Most recent visit'),
(4945, 'Most recent vitals from:'),
(4946, 'Mother'),
(4947, 'Mother\'s Name'),
(4948, 'Mothers History'),
(4949, 'Mothers Name'),
(4950, 'Motility'),
(4951, 'Mouth'),
(4952, 'Move'),
(4953, 'Move Document to Category:'),
(4954, 'Move Down'),
(4955, 'Move failed!'),
(4956, 'Move the individual items from \'Active\' to \'Inactive\' or vice-versa by selecting the items and pressing the relevant button with the double chevron.'),
(4957, 'Move to Patient'),
(4958, 'Move to...'),
(4959, 'Move Up'),
(4960, 'Moving'),
(4961, 'Mo{{Monday}}'),
(4962, 'MPD-D{{abbreviation for Monocular Pupillary Diameter - Distance}}'),
(4963, 'MPD-N{{abbreviation for Monocular Pupillary Diameter - Near}}'),
(4964, 'Mr.'),
(4965, 'MRD{{marginal reflex distance}}'),
(4966, 'MRN (pid)'),
(4967, 'MRNear{{Manifest Near Acuity}}'),
(4968, 'MRNear{{manifest refraction near}}'),
(4969, 'Mrs.'),
(4970, 'MR{{Manifest Refraction}}'),
(4971, 'Ms.'),
(4972, 'MSH-11'),
(4973, 'MSH-3.1'),
(4974, 'MSH-4.1'),
(4975, 'MSH-5.1'),
(4976, 'MSH-6.1'),
(4977, 'MSH.8 message type is not supported'),
(4978, 'MSH.8 message type is not valid'),
(4979, 'MSP Code'),
(4980, 'MSP Remit Codes'),
(4981, 'Multi Language Tool'),
(4982, 'Multi-select desired DX(s) and click the'),
(4983, 'Multiple areas'),
(4984, 'Multiple DataBase'),
(4985, 'Multiple files can be uploaded at one time by selecting them using CTRL+Click or SHIFT+Click.'),
(4986, 'Multiple Lots'),
(4987, 'Multiple modifiers can be separated by colons or spaces, maximum of 4 (M1:M2:M3:M4)'),
(4988, 'Multiple Select List'),
(4989, 'Multipledb'),
(4990, 'Multiracial'),
(4991, 'Murmur:'),
(4992, 'Musc Ache'),
(4993, 'Musc Aches'),
(4994, 'Musc Redness'),
(4995, 'Musc Stiffness'),
(4996, 'Musc Swelling'),
(4997, 'Musc Warm'),
(4998, 'Muscle'),
(4999, 'Muscle injury'),
(5000, 'Musculoskeletal'),
(5001, 'Musculo{{musculoskeletal}}'),
(5002, 'Must be current email address on file.'),
(5003, 'Must be empty if SMTP authentication is not used.'),
(5004, 'Must choose at least one day!'),
(5005, 'Mutually Defined'),
(5006, 'MVA'),
(5007, 'MVX Code'),
(5008, 'My Default Values'),
(5009, 'My Health'),
(5010, 'My Messages'),
(5011, 'My Term'),
(5012, 'Myself'),
(5013, 'M{{Monday}}'),
(5014, 'Māori'),
(5015, 'N.B.{{Nota bene}}'),
(5016, 'N/A'),
(5017, 'n/a'),
(5018, 'N/A{{not applicable}}'),
(5019, 'Name'),
(5020, 'NAME'),
(5021, 'Name (click for more)'),
(5022, 'Name 1'),
(5023, 'Name 2'),
(5024, 'Name and Title of Immunization Administrator'),
(5025, 'Name in EMR'),
(5026, 'Name must be like codetype_code_language.pdf, for example icd9_274.11_en.pdf'),
(5027, 'Name of Events'),
(5028, 'Name of insurance company'),
(5029, 'Name of Provider'),
(5030, 'Name of the sender for patient reminders.'),
(5031, 'Name of the Surgeon'),
(5032, 'Name on Card'),
(5033, 'Name Translation'),
(5034, 'Name/Value'),
(5035, 'Name:'),
(5036, 'Names'),
(5037, 'Namespace'),
(5038, 'Narcotic drugs imported'),
(5039, 'NARES:'),
(5040, 'NARES: Normal Right'),
(5041, 'Narrative'),
(5042, 'nasal'),
(5043, 'Nasal mucosa pink, septum midline'),
(5044, 'Nation Notes'),
(5045, 'Nation Notes (nationnotes)'),
(5046, 'Nation Notes (nn_configure)'),
(5047, 'Nation Notes Configure'),
(5048, 'Nation Notes Replace Buttons'),
(5049, 'Nationality'),
(5050, 'NationNotes'),
(5051, 'Native Data Loads'),
(5052, 'Native Hawaiian or Other Pacific Islander'),
(5053, 'Natural Child'),
(5054, 'Natural child'),
(5055, 'Natural Parent'),
(5056, 'Natural Sibling'),
(5057, 'Nauru'),
(5058, 'Nausea'),
(5059, 'Navajo, Navaho'),
(5060, 'Navigation'),
(5061, 'Navigation area includes encounter forms'),
(5062, 'Navigation area uses full height of frameset'),
(5063, 'Navigation Area Visit Forms'),
(5064, 'Navigation Area Width'),
(5065, 'Navigation menu consists of pairs of radio buttons'),
(5066, 'Navigation menu is a tree view'),
(5067, 'Navigation uses a sliding menu'),
(5068, 'NCI CONCEPT ID'),
(5069, 'NCOM{{Neuro comments}}'),
(5070, 'NCPDP'),
(5071, 'NDC'),
(5072, 'NDC Data'),
(5073, 'NDC Number'),
(5074, 'Ndonga'),
(5075, 'Near'),
(5076, 'Near Acuity AutoRefraction'),
(5077, 'Near Acuity Manifest Refraction'),
(5078, 'Near Acuity with Autorefraction'),
(5079, 'Near Acuity with Correction'),
(5080, 'Near Acuity with Manifest (Dry) refraction'),
(5081, 'Near Acuity without Correction'),
(5082, 'Near Point of Accomodation'),
(5083, 'Near Point of Convergence'),
(5084, 'Neck'),
(5085, 'Neck Problems'),
(5086, 'Neck supple'),
(5087, 'Need more than one drug.'),
(5088, 'Need to enter a description'),
(5089, 'Need to enter a Return Value'),
(5090, 'Need to enter identifier'),
(5091, 'Need to enter title'),
(5092, 'Needs Auth'),
(5093, 'Needs Justify'),
(5094, 'Needs secondary billing'),
(5095, 'Negative'),
(5096, 'Negative payments not accepted'),
(5097, 'Negatives'),
(5098, 'Neg{{negative}}'),
(5099, 'Neighbor'),
(5100, 'Neo 10%'),
(5101, 'Neo 2.5%'),
(5102, 'Nepali'),
(5103, 'Nerve injury'),
(5104, 'Neural condition / nerve damage'),
(5105, 'Neuro'),
(5106, 'Neuro Numbness'),
(5107, 'Neuro Weakness'),
(5108, 'Neuro-physiology'),
(5109, 'Neuro/Phys Exam Default Values'),
(5110, 'Neurologic'),
(5111, 'Neurology'),
(5112, 'Neuro{{neurologic}}'),
(5113, 'NEURO{{Neurology}}'),
(5114, 'Never'),
(5115, 'Never Alcohol'),
(5116, 'Never smoker'),
(5117, 'New'),
(5118, 'New =>'),
(5119, 'New Acceptors'),
(5120, 'New Alerts'),
(5121, 'New Allergy'),
(5122, 'New amendment request'),
(5123, 'New Appointment'),
(5124, 'New Categories'),
(5125, 'New Category'),
(5126, 'New Clients'),
(5127, 'New Consultation'),
(5128, 'New Crop'),
(5129, 'New Definition set added'),
(5130, 'New Document'),
(5131, 'New Documents'),
(5132, 'New Due Clinical Reminders'),
(5133, 'New Dx{{new diagnosis}}'),
(5134, 'New Encounter'),
(5135, 'New encounter created with id'),
(5136, 'New Encounter Form'),
(5137, 'New encounters not authorized'),
(5138, 'New Enctr'),
(5139, 'New Facility Information'),
(5140, 'New file'),
(5141, 'New Files'),
(5142, 'New form validation'),
(5143, 'New Group'),
(5144, 'New group encounter created with id'),
(5145, 'New Group Encounter Form'),
(5146, 'New Group Information'),
(5147, 'New group was saved successfully'),
(5148, 'New Immunization Record'),
(5149, 'New Inj/Status'),
(5150, 'New Items (see above for details)'),
(5151, 'New Layout'),
(5152, 'New Limit of Events'),
(5153, 'New List'),
(5154, 'New Message'),
(5155, 'new messages'),
(5156, 'New Note'),
(5157, 'New Orders'),
(5158, 'New Paragraph'),
(5159, 'New Password'),
(5160, 'New Patient'),
(5161, 'NEW PATIENT'),
(5162, 'New Patient Encounter'),
(5163, 'New Patient Form'),
(5164, 'New Patient ID'),
(5165, 'New patient registration received from patient portal. Reminder to check for possible new appointment'),
(5166, 'New Patients'),
(5167, 'New Payment'),
(5168, 'New Portal Login'),
(5169, 'New Pt'),
(5170, 'New Recall'),
(5171, 'New results from Lab Exchange'),
(5172, 'New Search'),
(5173, 'New Submissions'),
(5174, 'New User'),
(5175, 'New Value'),
(5176, 'New Visit'),
(5177, 'New/Search'),
(5178, 'NewCrop Account Status'),
(5179, 'NewCrop Admin'),
(5180, 'NewCrop call failed'),
(5181, 'NewCrop Doctor'),
(5182, 'NewCrop eRx Account Id'),
(5183, 'NewCrop eRx Account Name'),
(5184, 'NewCrop eRx Debug Setting'),
(5185, 'NewCrop eRx Default Patient Country'),
(5186, 'NewCrop eRx Name'),
(5187, 'NewCrop eRx Partner Name'),
(5188, 'NewCrop eRx Password'),
(5189, 'NewCrop eRX Role'),
(5190, 'NewCrop eRx Role'),
(5191, 'NewCrop eRx Site Address'),
(5192, 'NewCrop eRx SOAP Request Time-To-Live for Allergies'),
(5193, 'NewCrop eRx SOAP Request Time-To-Live for Medications'),
(5194, 'NewCrop eRx User Role'),
(5195, 'NewCrop eRx User Role * invalid selection *'),
(5196, 'NewCrop eRx Web Service Address'),
(5197, 'NewCrop Manager'),
(5198, 'NewCrop MedEntry'),
(5199, 'NewCrop Midlevel Prescriber'),
(5200, 'NewCrop Nurse'),
(5201, 'NewCrop Supervising Doctor'),
(5202, 'Newer'),
(5203, 'NewRx'),
(5204, 'Newspaper'),
(5205, 'Next'),
(5206, 'Next Appointment Date'),
(5207, 'Next Day'),
(5208, 'Next Month'),
(5209, 'Next month (hold for menu)'),
(5210, 'Next of Kin Relationship'),
(5211, 'Next Scheduled Run'),
(5212, 'Next Visit'),
(5213, 'Next Visit Orders'),
(5214, 'Next Week'),
(5215, 'Next year (hold for menu)'),
(5216, 'Nick Name'),
(5217, 'Nickname'),
(5218, 'Niece/Nephew'),
(5219, 'Night Sweats'),
(5220, 'NKDA{{No known drug allergies}}'),
(5221, 'Nl ext genitalia, vag mucosa, cervix'),
(5222, 'No'),
(5223, 'NO'),
(5224, 'no'),
(5225, 'No access'),
(5226, 'No active patient reminders.'),
(5227, 'No adenopathy (2 areas required)'),
(5228, 'No adjustment reason type found for'),
(5229, 'No adnexal tenderness/masses'),
(5230, 'No alert'),
(5231, 'No amendment requests available'),
(5232, 'No Appointments'),
(5233, 'No archive files present'),
(5234, 'No Archives'),
(5235, 'No audit log tampering detected in the selected date range.'),
(5236, 'No automatic refresh'),
(5237, 'No billing system is currently active'),
(5238, 'No Bills Found to Include in OFX Export'),
(5239, 'No Bills Found to Include in OFX Export<br>'),
(5240, 'No Changes Detected'),
(5241, 'No code was specified!'),
(5242, 'No Configuration Defined for this Module'),
(5243, 'No data available in table'),
(5244, 'No Data to Process'),
(5245, 'No Diagnosis'),
(5246, 'no diagnosis was auto-generated from the clinical findings.'),
(5247, 'No Documents'),
(5248, 'No Documents Found'),
(5249, 'No Encounter could be created'),
(5250, 'No encounter...'),
(5251, 'No end date'),
(5252, 'No entries found, use the form below to add an entry.'),
(5253, 'No errors found'),
(5254, 'No Events'),
(5255, 'No Fax Number Saved For The Selected Organization'),
(5256, 'No files staged for installation'),
(5257, 'No group was selected'),
(5258, 'No hernia'),
(5259, 'No Hooks Available in this Module'),
(5260, 'No Hooks enabled for this Module'),
(5261, 'No injury/illness'),
(5262, 'No Insurance Companies Found'),
(5263, 'No interactions found'),
(5264, 'No Issues'),
(5265, 'No issues in this encounter.'),
(5266, 'No items under selected category'),
(5267, 'No items were selected!'),
(5268, 'No Known Allergies'),
(5269, 'No Known Clinical Instructions'),
(5270, 'No Known Encounters'),
(5271, 'No Known Immunizations'),
(5272, 'No Known Lab Results'),
(5273, 'No Known Medications'),
(5274, 'No Known Plan of Care'),
(5275, 'No Known Problems'),
(5276, 'No Known Procedures'),
(5277, 'No Known Referrals'),
(5278, 'No Known Social Functional Status'),
(5279, 'No Known Social History'),
(5280, 'No Known Vitals'),
(5281, 'No lab data documented.'),
(5282, 'No log file exist for the selected date'),
(5283, 'No logging'),
(5284, 'No logs older than 7 days'),
(5285, 'No masses, tenderness'),
(5286, 'No match Patient record found for the given Re Idenitification code'),
(5287, 'No matches for'),
(5288, 'No matches found. Try search again.'),
(5289, 'No matches were found.'),
(5290, 'No matches were found. Create the new patient now?'),
(5291, 'No matching records found'),
(5292, 'No Name'),
(5293, 'No new messages on'),
(5294, 'No new results found'),
(5295, 'No notes'),
(5296, 'No ogrganomegoly'),
(5297, 'No openings were found for this period.'),
(5298, 'No other phone numbers listed'),
(5299, 'No parameters selected'),
(5300, 'No Partners Found'),
(5301, 'No Patient record found for given Selection criteria'),
(5302, 'No Patient record found for the given Re Identification code'),
(5303, 'No peripheral edema'),
(5304, 'No Pharmacies Found'),
(5305, 'No Prescriptions Found'),
(5306, 'No prescriptions selected'),
(5307, 'No presenting illness/injury'),
(5308, 'No previous entries.'),
(5309, 'No Primary Business Entity selected in facility list'),
(5310, 'No prior encounters.'),
(5311, 'No procedures in this encounter.'),
(5312, 'No provider was matched'),
(5313, 'No Providers Found'),
(5314, 'No rash or abnormal lesions'),
(5315, 'No records available'),
(5316, 'No records found'),
(5317, 'No records found.'),
(5318, 'No records found. Please expand your search criteria.'),
(5319, 'No reminder/recall'),
(5320, 'No Reminders'),
(5321, 'No Result Found, for the above search criteria.'),
(5322, 'No Results'),
(5323, 'No results found'),
(5324, 'No Results Found For Search'),
(5325, 'No results found, please try again.'),
(5326, 'No results, please tray again.'),
(5327, 'No results, please try again.'),
(5328, 'No Settings avaliable in this module'),
(5329, 'No Show'),
(5330, 'No show'),
(5331, 'no signature in document'),
(5332, 'No signatures on file'),
(5333, 'No Sinus Tenderness:'),
(5334, 'No skin dimpling or breast nodules'),
(5335, 'NO SUCH CONTEXT NAME'),
(5336, 'No table selected! Select a table.'),
(5337, 'No testicular tenderness, masses'),
(5338, 'No Thanks'),
(5339, 'No thrills or heaves'),
(5340, 'No track selected'),
(5341, 'No tracks have been documented.'),
(5342, 'No visit'),
(5343, 'No vitals have been documented.'),
(5344, 'No, Cancel'),
(5345, 'No-fault Insurance including Auto is Primary'),
(5346, 'No:'),
(5347, 'Nocturia'),
(5348, 'Non Paid'),
(5349, 'Non Reported Report'),
(5350, 'Non specific injury'),
(5351, 'Non-electronic'),
(5352, 'Non-Insulin Dependent Diabetes'),
(5353, 'Non-Insured'),
(5354, 'Non-residential Substance Abuse Treatment Facility'),
(5355, 'Non-SRH Medical'),
(5356, 'Non-SRH Non-Medical'),
(5357, 'None'),
(5358, 'none'),
(5359, 'None defined'),
(5360, 'None documented'),
(5361, 'None have been documented'),
(5362, 'None of the above'),
(5363, 'None of the Top Distribution Row Can be Completly Blank.'),
(5364, 'None Selected'),
(5365, 'None{{Encounter}}'),
(5366, 'None{{Patient}}'),
(5367, 'Noninsulin Dependent Diabetes'),
(5368, 'Nor'),
(5369, 'Normal'),
(5370, 'Normal (normal)'),
(5371, 'Normal BL'),
(5372, 'Normal Cardiac Exam:'),
(5373, 'Normal Cardiac Exam: '),
(5374, 'Normal Lung Exam:'),
(5375, 'Normal Lung Exam: '),
(5376, 'Normal Office Visit'),
(5377, 'Normal Oropharynx:'),
(5378, 'Normal Right'),
(5379, 'Normal Right:'),
(5380, 'Normal View'),
(5381, 'normal:'),
(5382, 'Normally this should be checked. Not related to access control.'),
(5383, 'North Ndebele'),
(5384, 'Northern Sami'),
(5385, 'Norwegian'),
(5386, 'Norwegian Bokmal'),
(5387, 'Norwegian Bokmål'),
(5388, 'Norwegian Nynorsk'),
(5389, 'Nose'),
(5390, 'Nosebleed'),
(5391, 'not a letter or number'),
(5392, 'Not active'),
(5393, 'Not Administered'),
(5394, 'Not all fields are required for all codes or code types.'),
(5395, 'Not Allowed'),
(5396, 'Not allowed to delete the Administrators group'),
(5397, 'Not Allowed to Edit'),
(5398, 'Not allowed to inactivate all security objects'),
(5399, 'Not allowed to inactivate anything from the Administrators ACL'),
(5400, 'Not allowed to remove the admin user from the Administrators group'),
(5401, 'Not allowed to remove this user from the Administrators group'),
(5402, 'Not Applicable'),
(5403, 'Not authorised to access PostCalendar module'),
(5404, 'Not authorized'),
(5405, 'Not Authorized'),
(5406, 'Not authorized for this squad!'),
(5407, 'Not authorized for this squad.'),
(5408, 'Not authorized to manage users!'),
(5409, 'Not authorized to sign results'),
(5410, 'Not authorized to view this encounter'),
(5411, 'Not Available'),
(5412, 'Not Billed'),
(5413, 'Not billed'),
(5414, 'Not Checked'),
(5415, 'Not checked out'),
(5416, 'Not Coded'),
(5417, 'Not documented'),
(5418, 'Not Due'),
(5419, 'Not Esigned'),
(5420, 'Not Examined'),
(5421, 'Not Examined:'),
(5422, 'Not Examined: '),
(5423, 'Not For Diagnostic Use'),
(5424, 'not found'),
(5425, 'Not Found'),
(5426, 'not found!'),
(5427, 'Not Hispanic or Latino'),
(5428, 'Not installed'),
(5429, 'Not Installed'),
(5430, 'Not Possible'),
(5431, 'Not seen since'),
(5432, 'Not sent'),
(5433, 'Not Sent Yet'),
(5434, 'Not Specified'),
(5435, 'Not Specified.'),
(5436, 'Not VFC eligible'),
(5437, 'Note'),
(5438, 'Note Codes'),
(5439, 'Note it will take 5-10 minutes to fully process after you click Install'),
(5440, 'Note it will take 5-10 minutes to fully process after you click Upgrade'),
(5441, 'Note that Audit Logging needs to be enabled above'),
(5442, 'Note there is no \'Save\' button.'),
(5443, 'Note Type'),
(5444, 'Note: 12:00 noon is PM, not AM'),
(5445, 'NOTE: Importing external data can take more than an hour depending on your hardware configuration. For example, one of the RxNorm data tables contain in excess of 6 million rows.'),
(5446, 'NOTE: Only the Biannual International Snomed Release is currently supported'),
(5447, 'NOTE: Only the Biannual International Snomed Releases and the US Snomed Releases are currently supported'),
(5448, 'NOTE: Only the full monthly RxNorm release is currently supported'),
(5449, 'NOTE: Only the XML formats and Eligible Professionals valuesets supported'),
(5450, 'NOTE: The import can take up to several hours'),
(5451, 'Note: This code has not been authorized.'),
(5452, 'Note: This code was not entered by an authorized user. Only authorized codes may be uploaded to the Open Medical Billing Network for processing. If you wish to upload these codes, please select an authorized user here.'),
(5453, 'Note: This copay was entered against billing that has not been authorized. Please review status.'),
(5454, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed (for example, file.jpg will become file.1.jpg). Filenames are considered unique per patient, not per category.'),
(5455, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed. For example \'<i>file.jpg</i>\' will become \'<i>file.jpg.1</i>\'. Filenames are considered unique per patient, not per category. '),
(5456, 'Notes'),
(5457, 'NOTES'),
(5458, 'Notes - any encounters (write,addonly optional)'),
(5459, 'Notes - any encounters (write,addonly optional) (notes_a)'),
(5460, 'Notes - my encounters (write,addonly optional)'),
(5461, 'Notes - my encounters (write,addonly optional) (notes)'),
(5462, 'Notes by'),
(5463, 'Notes not authorized'),
(5464, 'Nothing found - sorry'),
(5465, 'Nothing Pending for Approval'),
(5466, 'Nothing Recorded'),
(5467, 'Nothing to display'),
(5468, 'Nothing to import for Allergy'),
(5469, 'Nothing to import for Prescription'),
(5470, 'Nothing to Post! Please review entries or use Cancel to exit transaction'),
(5471, 'Nothing to show'),
(5472, 'Nothing was selected'),
(5473, 'Notice Received'),
(5474, 'NOTICE:: PostCalendar Submission/Modification'),
(5475, 'Notification'),
(5476, 'Notification Email Address'),
(5477, 'Notification FAILED'),
(5478, 'Notification FAILED: Not Portal Authorized'),
(5479, 'Notification sent to'),
(5480, 'Notification Settings'),
(5481, 'Notifications'),
(5482, 'Notify Admin About Event Submission/Modification?'),
(5483, 'Notify Patient'),
(5484, 'Notify via Patient Portal'),
(5485, 'Nov'),
(5486, 'November'),
(5487, 'Now posting for:'),
(5488, 'Now printing'),
(5489, 'Now printing $stmt_count statements and updating encounters.'),
(5490, 'Now printing $stmt_count statements and updating invoices.'),
(5491, 'Now printing $stmt_count statements; encounters will not be updated.'),
(5492, 'Now printing $stmt_count statements; invoices will not be updated.'),
(5493, 'NPA{{near point of accomodation}}'),
(5494, 'NPC{{near point of convergence}}'),
(5495, 'NPI'),
(5496, 'NQF'),
(5497, 'Number'),
(5498, 'Number labs'),
(5499, 'Number of Appointments on Statement'),
(5500, 'Number of Appointments to display in the Group Summary'),
(5501, 'Number of Appointments to display in the Onsite Patient Portal'),
(5502, 'Number of Appointments to display in the Patient Summary'),
(5503, 'Number of columns in year view.'),
(5504, 'Number of days before showing fifth account message'),
(5505, 'Number of days before showing first account message'),
(5506, 'Number of days before showing first account message.'),
(5507, 'Number of days before showing fourth account message'),
(5508, 'Number of days before showing second account message'),
(5509, 'Number of days before showing third account message'),
(5510, 'Number of days that the client certificate is valid.'),
(5511, 'Number of days to search from the start date'),
(5512, 'Number of digits after decimal point for currency, usually 0 or 2.'),
(5513, 'Number of encounters to display per page.'),
(5514, 'Number of Excluded Appointments to display in the Tooltip'),
(5515, 'Number of games or events missed, if any'),
(5516, 'Number of hours in advance to send email notifications.'),
(5517, 'Number of hours in advance to send Phone notification.'),
(5518, 'Number of hours in advance to send SMS notifications.'),
(5519, 'Number of Minutes to display completed checkouts'),
(5520, 'Number of Minutes to display completed checkouts. Zero is continuous display'),
(5521, 'Number of past history columns'),
(5522, 'Number of patients to display per page in the patient list.'),
(5523, 'Numbness'),
(5524, 'Numerator'),
(5525, 'Numeric display order'),
(5526, 'Nuosu'),
(5527, 'Nursing Facility'),
(5528, 'Nutrition'),
(5529, 'Nutritional'),
(5530, 'O.A.F.V.'),
(5531, 'O2 Sat'),
(5532, 'Obesity I'),
(5533, 'Obesity II'),
(5534, 'Obesity III'),
(5535, 'Objective'),
(5536, 'Obligatory participation'),
(5537, 'Observation'),
(5538, 'Observation Criteria'),
(5539, 'Observation Criteria Value'),
(5540, 'Observation Form'),
(5541, 'Observation Results'),
(5542, 'Observation Results in Immunization'),
(5543, 'Occitan'),
(5544, 'Occupation'),
(5545, 'Occupational physician'),
(5546, 'occurred while uploading file named'),
(5547, 'Occurrence'),
(5548, 'Oct'),
(5549, 'October'),
(5550, 'OD'),
(5551, 'OD{{right eye}}'),
(5552, 'oeFHIR'),
(5553, 'of'),
(5554, 'of quantity'),
(5555, 'of tablets'),
(5556, 'of the month every'),
(5557, 'Ofc Notes'),
(5558, 'Off'),
(5559, 'Off Campus-Outpatient Hospital'),
(5560, 'Off: No Service.'),
(5561, 'Office'),
(5562, 'Office Announcements'),
(5563, 'Office Note'),
(5564, 'Office Notes'),
(5565, 'Office Visit'),
(5566, 'Official Clinical Quality Measures (CQM) Measure Groups'),
(5567, 'Offsite Https link for the Patient Portal.'),
(5568, 'Offsite Https link for the Patient Portal.(Patient Link)'),
(5569, 'Offsite Patient Portal Password'),
(5570, 'Offsite Patient Portal Password(Put Blank If not Registered).'),
(5571, 'Offsite Patient Portal Provider ID'),
(5572, 'Offsite Patient Portal Provider ID(Put Blank If not Registered).'),
(5573, 'Offsite Patient Portal Site Address'),
(5574, 'Offsite Patient Portal Site Address (Patient Link)'),
(5575, 'Offsite Patient Portal Username'),
(5576, 'Offsite Patient Portal Username(Put Blank If not Registered).'),
(5577, 'Offsite Portal web Service Failed'),
(5578, 'Offspring'),
(5579, 'Offspring History'),
(5580, 'Oh Snap!'),
(5581, 'ointment'),
(5582, 'Ojibwe, Ojibwa'),
(5583, 'OK'),
(5584, 'OK to close this other popup window?'),
(5585, 'OK to link the GCAC issue dated'),
(5586, 'Old'),
(5587, 'Old Church Slavonic, Church Slavonic, Old Bulgarian'),
(5588, 'Old Clients'),
(5589, 'Old fracture non / malunion'),
(5590, 'Old style layout with no left menu'),
(5591, 'Old-style static form without search or duplication check'),
(5592, 'Older'),
(5593, 'Older than'),
(5594, 'Omit'),
(5595, 'Omit circumferences'),
(5596, 'Omit employer information in patient demographics'),
(5597, 'Omit Employers'),
(5598, 'Omit form, route and interval which then become part of dosage'),
(5599, 'Omit insurance and some other things from the demographics form'),
(5600, 'Omit internal users?'),
(5601, 'Omit method of payment from the co-pay panel'),
(5602, 'omit to autoassign'),
(5603, 'On'),
(5604, 'on'),
(5605, 'on file email'),
(5606, 'On Hand'),
(5607, 'On Order'),
(5608, 'On Site'),
(5609, 'On this date there is a holiday, use it anyway?'),
(5610, 'On: HAPI FHIR.'),
(5611, 'On: Smart on FHIR.'),
(5612, 'Once completed, view and store this encounter as a PDF file'),
(5613, 'Once the Primary Business Facility is set, changing the facility id will affect NewCrop ePrescription.'),
(5614, 'Once the Primary Business Facility is set, it should not be changed. Changing the facility will affect the working in NewCrop ePrescription.'),
(5615, 'Once you change your password, you will have to re-login.'),
(5616, 'Oncology: Medical and Radiation – Pain Intensity Quantified (CQM)'),
(5617, 'One Day Ago'),
(5618, 'One Day Ahead'),
(5619, 'One Month Ago'),
(5620, 'One Month Ahead'),
(5621, 'One Year Ago'),
(5622, 'One Year Ahead'),
(5623, 'Online'),
(5624, 'Online Support'),
(5625, 'Online Support Link'),
(5626, 'Only Active'),
(5627, 'Only applicable if a provider or collated list was chosen above. PRIMARY only selects patients that the provider is the primary provider. ENCOUNTER selects all patients that the provider has seen.'),
(5628, 'Only entries with a Code are billable'),
(5629, 'Only for comparisons'),
(5630, 'Only for HTML5 compatible browsers.'),
(5631, 'only if billing location'),
(5632, 'Only Inactive'),
(5633, 'Only Mine'),
(5634, 'Only recall to provider, no reminder'),
(5635, 'Only reminder to provider, no recall'),
(5636, 'Only Show Diagnosis Reporting Codes'),
(5637, 'Only Show Service Code Finance Reporting Codes'),
(5638, 'Only upload active prescriptions'),
(5639, 'Only upload active prescriptions to NewCrop eRx.'),
(5640, 'Onset'),
(5641, 'Onset of Current Symptoms or Illness'),
(5642, 'Onset of Illness:'),
(5643, 'Onset of Ilness: '),
(5644, 'Onset of Swelling:'),
(5645, 'Onset/hosp. date:'),
(5646, 'Onsite Activity Views'),
(5647, 'Onsite Patient Activities'),
(5648, 'Onsite Patient Portal'),
(5649, 'Onsite Patient Portal Site Address'),
(5650, 'Onsite Portal'),
(5651, 'Onsite Portal Activities'),
(5652, 'Oops!'),
(5653, 'Open'),
(5654, 'Open Demographics in New Window from Patient Flow Board'),
(5655, 'Open Encounter'),
(5656, 'Open Fee Sheet'),
(5657, 'Open in New Window'),
(5658, 'Open Med Practice and its suppliers use their commercially reasonable efforts to provide the most current and complete data available to them concerning prescription histories, drug interactions and formularies, patient allergies and other factors, but by your use of this service you acknowledge that (1) the completeness and accuracy of such data depends upon the completeness and accuracy with which it is entered into connected electronic databases by physicians, physician’s offices, pharmaceutical benefits managers, electronic medical records firms, and other network participants, (2) such data is subject to error or omission in input, storage or retrieval, transmission and display, technical disruption, power or service outages, or other interruptions in electronic communication, any or all of which may be beyond the control of Open Med Practice and its suppliers, and (3) some information may be unavailable due to regulatory, contractual, privacy or other legal restrictions. You are responsible to use your clinical judgment at all times in rendering medical service and advice.'),
(5659, 'Open Patient'),
(5660, 'Open Patient in New Window'),
(5661, 'Open the Quick Pick panels'),
(5662, 'Open the Shorthand Window and display Shorthand Codes'),
(5663, 'Open Today`s Visit'),
(5664, 'Open/Close the Anterior Segment drawing panel'),
(5665, 'Open/Close the Anterior Segment Exam Quick Picks panel'),
(5666, 'Open/Close the detailed HPI panel'),
(5667, 'Open/Close the External drawing panel'),
(5668, 'Open/Close the External Exam Quick Picks panel'),
(5669, 'Open/Close the HPI Canvas'),
(5670, 'Open/Close the Imp/Plan drawing panel'),
(5671, 'Open/Close the Impression/Plan Builder panel'),
(5672, 'Open/Close the Neuro drawing panel'),
(5673, 'Open/Close the Neuro Exam Quick Picks panel'),
(5674, 'Open/Close the PMH draw panel'),
(5675, 'Open/Close the PMSFH summary panel'),
(5676, 'Open/Close the Retina drawing panel'),
(5677, 'Open/Close the Retinal Exam Quick Picks panel'),
(5678, 'Open/Close the Shorthand Window and display Shorthand Codes'),
(5679, 'Open/Close the Shorthand Window and display Shorthand Codes next to each field'),
(5680, 'OpenEMR already has a Certificate Authority configured.'),
(5681, 'OpenEMR Application Category'),
(5682, 'OpenEMR Database Upgrade'),
(5683, 'OpenEMR Database Upgrade for De-identification'),
(5684, 'OpenEMR does not recognize the incoming file in the contrib directory. This is most likely because you need to configure the release in the supported_external_dataloads table in the MySQL database.'),
(5685, 'OpenEMR must be configured to use certificates before it can create client certificates.'),
(5686, 'OpenEMR Portal'),
(5687, 'OpenEMR Product Registration'),
(5688, 'OpenEMR requires Javascript to perform user authentication.'),
(5689, 'OpenEMR Users'),
(5690, 'Openings'),
(5691, 'Opens in Bottom frame'),
(5692, 'Opens in Top frame'),
(5693, 'Operation Failed'),
(5694, 'Operator'),
(5695, 'Opthalmic'),
(5696, 'Optic Discs'),
(5697, 'Optic Nerve Analysis'),
(5698, 'Option'),
(5699, 'Option to save method of document storage.'),
(5700, 'Option to support inventory and sales of products'),
(5701, 'Optional'),
(5702, 'Optional category name for an ID Card image that can be viewed from the patient summary page.'),
(5703, 'Optional category name for photo images that can be viewed from the patient summary page.'),
(5704, 'Optional category name of a document to link to from the patient summary page. Lets you click on a patient name to see their ID card.'),
(5705, 'Optional default range for manual entry of results'),
(5706, 'Optional default units for manual entry of results'),
(5707, 'Optional Destination Name'),
(5708, 'Optional drug name, use % as a wildcard'),
(5709, 'Optional end date'),
(5710, 'Optional end date mm/dd/yyyy'),
(5711, 'Optional immunization name or code, use % as a wildcard'),
(5712, 'Optional information about this event'),
(5713, 'Optional lot number, use % as a wildcard'),
(5714, 'Optional numeric patient ID'),
(5715, 'Optional procedure code'),
(5716, 'Optional procedure/service code'),
(5717, 'Options'),
(5718, 'OR'),
(5719, 'Or'),
(5720, 'or choose'),
(5721, 'or click and drag for faster selection.'),
(5722, 'Or create this new field ID'),
(5723, 'Or Out To'),
(5724, 'or select from inventory'),
(5725, 'or Shift-click to decrease it'),
(5726, 'Or upload ERA file:'),
(5727, 'or utilize the Impression/Plan Builder'),
(5728, 'Oral'),
(5729, 'Oral mucosa pink, throat clear'),
(5730, 'Order'),
(5731, 'Order and Result Types'),
(5732, 'Order Catalog'),
(5733, 'Order Date'),
(5734, 'Order Descriptions'),
(5735, 'Order From'),
(5736, 'Order ID'),
(5737, 'Order must be a number between 1 and 999'),
(5738, 'Order must be a number between 1 and 9999'),
(5739, 'Order Name'),
(5740, 'Order Priorities'),
(5741, 'Order Processor'),
(5742, 'Order Results'),
(5743, 'Order Status'),
(5744, 'Order Statuses'),
(5745, 'Order Summary'),
(5746, 'Order Tracks'),
(5747, 'Order Type'),
(5748, 'Order Types'),
(5749, 'Order/Result Type'),
(5750, 'Ordered'),
(5751, 'Ordered By'),
(5752, 'Ordered Procedure'),
(5753, 'Ordering Provider'),
(5754, 'Orders'),
(5755, 'Orders Path'),
(5756, 'Organ injury'),
(5757, 'Organization'),
(5758, 'Organization Name'),
(5759, 'Organizational Unit Name'),
(5760, 'Organizations'),
(5761, 'Orientated x 3'),
(5762, 'Oriented TPP{{oriented to person and place}}'),
(5763, 'Original'),
(5764, 'Original Checksum'),
(5765, 'Original file'),
(5766, 'Original file deletion error'),
(5767, 'Oriya'),
(5768, 'Oromo'),
(5769, 'OROPHARYNX: '),
(5770, 'Ortho'),
(5771, 'Orthophoric'),
(5772, 'Orthopnea'),
(5773, 'ORTHO{{Orthopedics}}'),
(5774, 'Ortho{{orthophoric}}'),
(5775, 'OR{{as in AND/OR, ie. not an abbreviation}}'),
(5776, 'OS'),
(5777, 'Osetoarthritis'),
(5778, 'Ossetian, Ossetic'),
(5779, 'Osteopathy'),
(5780, 'OS{{left eye}}'),
(5781, 'Other'),
(5782, 'OTHER'),
(5783, 'other'),
(5784, 'Other (specify)'),
(5785, 'Other - Specified'),
(5786, 'Other adult'),
(5787, 'Other Documents'),
(5788, 'Other Federal Program'),
(5789, 'Other HCFA'),
(5790, 'Other injury not elsewhere specified'),
(5791, 'Other Liability Insurance is Primary'),
(5792, 'other month'),
(5793, 'Other Non-Federal Programs'),
(5794, 'Other Notes'),
(5795, 'Other Pertinent Symptoms'),
(5796, 'Other Pertinent Symptoms:'),
(5797, 'Other Place of Service'),
(5798, 'Other Provider'),
(5799, 'Other pt resp'),
(5800, 'Other Registry'),
(5801, 'Other stress/Over use injury'),
(5802, 'Other Surgical'),
(5803, 'Other/Generic Abortion-Related'),
(5804, 'Other/Miscellaneous'),
(5805, 'Others'),
(5806, 'otherwise you will destroy references to/from existing data.'),
(5807, 'Ottawa Ankle Rules'),
(5808, 'OU'),
(5809, 'Our Out To'),
(5810, 'OUT'),
(5811, 'Out Of Office'),
(5812, 'Out Time'),
(5813, 'Outbound Referral'),
(5814, 'Outcome'),
(5815, 'Outline Data Col'),
(5816, 'Outline Entire Row'),
(5817, 'Outlook'),
(5818, 'Outpatient Hospital'),
(5819, 'Output Type'),
(5820, 'OU{{both eyes}}'),
(5821, 'Over'),
(5822, 'Overall Status Of Discharge'),
(5823, 'OVERDUE'),
(5824, 'Overlay CMS 1500 on the Preprinted form'),
(5825, 'Override (if necessary) the appointment display limit to allow all appointments to be displayed for the last set'),
(5826, 'Override HIPAA choice'),
(5827, 'Overuse'),
(5828, 'Overview'),
(5829, 'Overweight'),
(5830, 'Overwrite HIPAA choice'),
(5831, 'Owner'),
(5832, 'Oxygen Saturation'),
(5833, 'oz'),
(5834, 'P'),
(5835, 'p.c.'),
(5836, 'p.m.'),
(5837, 'p.r.n.'),
(5838, 'Pachymetry'),
(5839, 'Pachymetry: Central Corneal Thickness'),
(5840, 'Pachy{{Pachymetry}}'),
(5841, 'Pacific Islander'),
(5842, 'Paedeatric'),
(5843, 'Page'),
(5844, 'Page Validation'),
(5845, 'Pages'),
(5846, 'Paid'),
(5847, 'Paid amount that you will allocate'),
(5848, 'Paid Amt'),
(5849, 'Paid Via'),
(5850, 'Pain'),
(5851, 'Pali'),
(5852, 'Palliative care physician'),
(5853, 'Palpitation'),
(5854, 'PAM{{Potential Acuity Meter}}'),
(5855, 'Pan'),
(5856, 'Panjabi, Punjabi'),
(5857, 'Pap Smear'),
(5858, 'Paper'),
(5859, 'Paper Size'),
(5860, 'Paralysis'),
(5861, 'Parent'),
(5862, 'parent in-law'),
(5863, 'Parent Recall'),
(5864, 'Parent Written Record'),
(5865, 'Parental decision'),
(5866, 'Parse HL7'),
(5867, 'Partially Administered'),
(5868, 'Participant\'s name'),
(5869, 'participants'),
(5870, 'Participants '),
(5871, 'Partner'),
(5872, 'Partner Name'),
(5873, 'Partner Name issued for NewCrop eRx service.'),
(5874, 'Pashto, Pushto'),
(5875, 'Pass Phrase'),
(5876, 'Pass phrase to decrypt document'),
(5877, 'Passed Patients'),
(5878, 'Passive Alert'),
(5879, 'Passive Alert Rules'),
(5880, 'password'),
(5881, 'Password'),
(5882, 'Password Change'),
(5883, 'Password change successful'),
(5884, 'Password change successful.'),
(5885, 'Password does not meet minimum requirements and should contain at least three of the four following items: A number, a lowercase letter, an uppercase letter, a special character (Not a leter or number).'),
(5886, 'Password Expiration Grace Period'),
(5887, 'Password for Phone Gateway.'),
(5888, 'Password for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(5889, 'Password for SMS Gateway'),
(5890, 'Password for SMS Gateway.'),
(5891, 'Password for the above user'),
(5892, 'Password security has recently been upgraded.'),
(5893, 'Password to connect to CouchDB'),
(5894, 'Password too short. Minimum 8 characters required.'),
(5895, 'Password:'),
(5896, 'Passwords do not match'),
(5897, 'Passwords do not match.'),
(5898, 'Passwords Don\'t match!'),
(5899, 'Passwords must be 8-12 characters long and include one capital letter, one lower case letter and one special character'),
(5900, 'Past Appoinments'),
(5901, 'Past Appointment Display Widget'),
(5902, 'Past Appointments'),
(5903, 'Past Date'),
(5904, 'Past due'),
(5905, 'Past Due'),
(5906, 'Past Due Interval (Clinical Reminders)'),
(5907, 'Past Due Interval (Patient Reminders)'),
(5908, 'Past Encounter List'),
(5909, 'Past Encounters'),
(5910, 'Past Encounters and Documents'),
(5911, 'Past Encounters for'),
(5912, 'Past Medical History'),
(5913, 'Past meetings'),
(5914, 'Past Ocular History'),
(5915, 'Past Ocular Surgery'),
(5916, 'Past Surgical History'),
(5917, 'Past Therapy Group Encounters'),
(5918, 'Past Year'),
(5919, 'Paste HL7 Data'),
(5920, 'Paste the data to import into the text area below:'),
(5921, 'Pat'),
(5922, 'Pat Ledger'),
(5923, 'Patch'),
(5924, 'PaternalAunt'),
(5925, 'PaternalCousin'),
(5926, 'PaternalGrandparent'),
(5927, 'PaternalGreatgrandparent'),
(5928, 'PaternalUncle'),
(5929, 'Path for Event Log Backup'),
(5930, 'Path to CA Certificate File'),
(5931, 'Path to CA Key File'),
(5932, 'Path to MySQL Binaries'),
(5933, 'Path to Perl Binaries'),
(5934, 'Path to Temporary Files'),
(5935, 'Patient'),
(5936, 'patient'),
(5937, 'PATIENT'),
(5938, 'Patient Access'),
(5939, 'Patient Address'),
(5940, 'Patient Address is missing'),
(5941, 'Patient Adj'),
(5942, 'Patient Adjustment'),
(5943, 'Patient allergies'),
(5944, 'Patient Allergies'),
(5945, 'Patient already in form'),
(5946, 'Patient Appointment'),
(5947, 'Patient Balance'),
(5948, 'Patient Balance Due'),
(5949, 'Patient Billing Note'),
(5950, 'Patient birthday alert requires turning off'),
(5951, 'Patient Characteristics'),
(5952, 'Patient chart ID'),
(5953, 'Patient Chat'),
(5954, 'Patient Checkout'),
(5955, 'Patient Checkout for '),
(5956, 'Patient City'),
(5957, 'Patient City is missing'),
(5958, 'Patient city missing'),
(5959, 'Patient Communication sent'),
(5960, 'Patient Comunication Sent'),
(5961, 'Patient Country'),
(5962, 'Patient Country is missing. Also you have not set default Patient Country in Global Settings'),
(5963, 'Patient Coverage'),
(5964, 'Patient Credentials Reset'),
(5965, 'Patient Credit'),
(5966, 'Patient Dashboard'),
(5967, 'Patient Data'),
(5968, 'Patient Date Of Birth'),
(5969, 'Patient Date Of Birth is missing'),
(5970, 'Patient decision'),
(5971, 'Patient Default'),
(5972, 'Patient Details'),
(5973, 'Patient DOB'),
(5974, 'Patient DOB missing'),
(5975, 'Patient Document'),
(5976, 'Patient Document Template Upload'),
(5977, 'Patient Document Templates'),
(5978, 'Patient Documents'),
(5979, 'Patient Education'),
(5980, 'Patient Education Materials'),
(5981, 'Patient Encounter'),
(5982, 'Patient Encounter Form'),
(5983, 'Patient Encounters'),
(5984, 'Patient Finder'),
(5985, 'Patient Finder Screen'),
(5986, 'Patient First name'),
(5987, 'Patient First Name'),
(5988, 'Patient First name is missing'),
(5989, 'Patient Flow Board'),
(5990, 'Patient Flow Board Report'),
(5991, 'Patient Flow Board Rooms'),
(5992, 'Patient Flow Board Timer Interval'),
(5993, 'Patient Gender'),
(5994, 'Patient Gender is missing'),
(5995, 'Patient has not authorized the Patient Portal.'),
(5996, 'Patient History'),
(5997, 'Patient History / Lifestyle'),
(5998, 'Patient Home phone'),
(5999, 'Patient ID'),
(6000, 'Patient Id'),
(6001, 'Patient ID card'),
(6002, 'Patient ID Category Name'),
(6003, 'Patient Images'),
(6004, 'Patient Immunization'),
(6005, 'Patient Information'),
(6006, 'Patient Information (patients)'),
(6007, 'Patient Instructions'),
(6008, 'Patient Insurance Distribution'),
(6009, 'Patient Insurance Distribution Report'),
(6010, 'Patient Issues'),
(6011, 'Patient Label Type'),
(6012, 'Patient Last name'),
(6013, 'Patient Last Name'),
(6014, 'Patient Last name is missing'),
(6015, 'Patient Ledger'),
(6016, 'Patient Ledger by Date'),
(6017, 'Patient Level Billing Note (Collections)'),
(6018, 'Patient List'),
(6019, 'Patient List Columns'),
(6020, 'Patient List Creation'),
(6021, 'Patient List New Window'),
(6022, 'Patient List Page Size'),
(6023, 'Patient Lookup Errors'),
(6024, 'Patient Mail'),
(6025, 'Patient may change their logon from portal login dialog.'),
(6026, 'Patient Medical Problems'),
(6027, 'Patient Medications'),
(6028, 'Patient Message'),
(6029, 'Patient Messages'),
(6030, 'Patient Messaging'),
(6031, 'Patient must be set manually'),
(6032, 'Patient Name'),
(6033, 'Patient Name & Address'),
(6034, 'Patient Name and ID'),
(6035, 'Patient Name and Invoice'),
(6036, 'Patient Name Required'),
(6037, 'Patient Name/ID'),
(6038, 'Patient Note'),
(6039, 'Patient Note Types'),
(6040, 'Patient Notes'),
(6041, 'Patient Notes (write,addonly optional)'),
(6042, 'Patient Notes (write,addonly optional) (notes)'),
(6043, 'Patient Number'),
(6044, 'Patient Payment'),
(6045, 'Patient Payments'),
(6046, 'Patient Photo Category Name'),
(6047, 'Patient Portal'),
(6048, 'Patient Portal (patientportal)'),
(6049, 'Patient Portal (portal)'),
(6050, 'Patient Portal connectivity issue'),
(6051, 'Patient Portal is turned off'),
(6052, 'Patient Portal Login'),
(6053, 'Patient Portal Secure'),
(6054, 'Patient Portal Web Address'),
(6055, 'Patient Printed Report'),
(6056, 'Patient Recalls'),
(6057, 'Patient Record Report'),
(6058, 'Patient Record Request'),
(6059, 'Patient Records Request'),
(6060, 'Patient Religion'),
(6061, 'Patient Reminder'),
(6062, 'Patient Reminder Batch Job'),
(6063, 'Patient Reminder Creation Processing Priority'),
(6064, 'Patient Reminder Rules'),
(6065, 'Patient Reminder Sender Email'),
(6066, 'Patient Reminder Sender Name'),
(6067, 'Patient Reminders'),
(6068, 'Patient Reminders (write,addonly optional)'),
(6069, 'Patient Report'),
(6070, 'Patient Reports'),
(6071, 'Patient Request'),
(6072, 'Patient Requested Medical Records'),
(6073, 'Patient Resource'),
(6074, 'Patient Results'),
(6075, 'Patient Search'),
(6076, 'Patient search or select.'),
(6077, 'Patient Search Results Style'),
(6078, 'Patient Search/Add Screen'),
(6079, 'Patient Setting'),
(6080, 'Patient sex missing'),
(6081, 'Patient Signed'),
(6082, 'Patient Signed Date'),
(6083, 'Patient State'),
(6084, 'Patient state missing'),
(6085, 'Patient Statement Bill'),
(6086, 'Patient statements can be generated as plain text or with a modern graphical appearance.'),
(6087, 'Patient Street Address'),
(6088, 'Patient street missing'),
(6089, 'Patient Summary'),
(6090, 'Patient Surveys'),
(6091, 'Patient Transactions'),
(6092, 'Patient validation'),
(6093, 'Patient Zip'),
(6094, 'Patient Zip Code missing'),
(6095, 'Patient\'s number'),
(6096, 'patient(s) in the database that match the demographic information you have entered.'),
(6097, 'Patient/Client'),
(6098, 'Patient:'),
(6099, 'PatientID'),
(6100, 'Patients'),
(6101, 'Patients Processed'),
(6102, 'Patients with debt'),
(6103, 'Pay'),
(6104, 'Pay attention to the \"Done with\" checkboxes.  After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected!  Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(6105, 'Pay Date:'),
(6106, 'Pay Invoice'),
(6107, 'Pay Status'),
(6108, 'Payee Name'),
(6109, 'Payer'),
(6110, 'Payer Type'),
(6111, 'Paying'),
(6112, 'Paying Entity'),
(6113, 'Payment'),
(6114, 'payment'),
(6115, 'Payment Adjustment Code'),
(6116, 'Payment against'),
(6117, 'Payment Amount'),
(6118, 'Payment Amount must be Numeric'),
(6119, 'Payment Category'),
(6120, 'Payment Date'),
(6121, 'payment entered on'),
(6122, 'Payment From'),
(6123, 'Payment Gateways'),
(6124, 'Payment Information'),
(6125, 'Payment Ins'),
(6126, 'Payment List'),
(6127, 'Payment Method'),
(6128, 'Payment Sort By'),
(6129, 'Payment Status'),
(6130, 'Payment successfully sent for authorization. You will be notified when payment is posted. Until payment is accepted and you are notified, you may resubmit this payment at anytime with new amounts or different credit card. Thank you'),
(6131, 'Payment Tracking Id'),
(6132, 'Payment Type'),
(6133, 'Payment Validated: Save?'),
(6134, 'Payment value for code '),
(6135, 'Payments'),
(6136, 'Payor'),
(6137, 'PCP'),
(6138, 'Pct (%) of rows'),
(6139, 'PD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(6140, 'PD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(6141, 'PDF'),
(6142, 'PDF buttons will save, mark claim reviewed and download claim'),
(6143, 'PDF Download Selected Statements'),
(6144, 'PDF Language'),
(6145, 'Pdf With Form'),
(6146, 'Pdf Without Form'),
(6147, 'PD{{Inter-pupillary distance}}'),
(6148, 'PD{{pupillary distance}}'),
(6149, 'Pelvis and buttock'),
(6150, 'Pemphigus'),
(6151, 'Pencil'),
(6152, 'pend'),
(6153, 'Pending'),
(6154, 'Pending Action'),
(6155, 'Pending Approval'),
(6156, 'Pending Auth since'),
(6157, 'Pending F/U'),
(6158, 'Pending followup'),
(6159, 'Pending Followup from Results'),
(6160, 'Pending Orders'),
(6161, 'Pending Res'),
(6162, 'Pending Review'),
(6163, 'Pending Rx Count'),
(6164, 'Penicillin Allergy'),
(6165, 'Pennington Firm OpenEMR  v'),
(6166, 'Peptic Ulcer Disease'),
(6167, 'Per Encounter'),
(6168, 'per min'),
(6169, 'Per Nostril'),
(6170, 'per nostril'),
(6171, 'Per Oris'),
(6172, 'per oris'),
(6173, 'Per Rectum'),
(6174, 'per rectum'),
(6175, 'Percent'),
(6176, 'Percentage of Patients to Drug Test'),
(6177, 'Percentage of Patients to select for Random Drug Testing.'),
(6178, 'Percentile'),
(6179, 'Perforated Right:'),
(6180, 'Perform Search'),
(6181, 'Perform this action'),
(6182, 'Performance Percentage'),
(6183, 'performed'),
(6184, 'Performer'),
(6185, 'Performing Laboratory Facility'),
(6186, 'Performing organization'),
(6187, 'Period'),
(6188, 'Period in days where a user may login with an expired password.'),
(6189, 'Perioperative Care'),
(6190, 'Periph'),
(6191, 'Peripheral'),
(6192, 'Periph{{peripheral retina}}'),
(6193, 'Periph{{periphery}}'),
(6194, 'Permit unsalted passwords'),
(6195, 'Persian'),
(6196, 'Persian (Farsi)'),
(6197, 'Person'),
(6198, 'Personalize'),
(6199, 'Persons needing a recall, no appt scheduled yet'),
(6200, 'PG'),
(6201, 'Pharm'),
(6202, 'Pharm Com Count'),
(6203, 'Pharmacies'),
(6204, 'Pharmacy'),
(6205, 'Pharmacy Dispensary'),
(6206, 'Pharmacy Dispensary (drugs)'),
(6207, 'Pharmacy Id'),
(6208, 'Pharmacy not assigned to the patient'),
(6209, 'Pheumothorax'),
(6210, 'phiMail Allow CCD Send'),
(6211, 'phiMail Allow CCR Send'),
(6212, 'phiMail Message Check Interval (minutes)'),
(6213, 'phiMail notification user'),
(6214, 'phiMail Password'),
(6215, 'phiMail Server Address'),
(6216, 'phiMail Username'),
(6217, 'PHIN Questions'),
(6218, 'Phone'),
(6219, 'Phone Biz'),
(6220, 'Phone call list'),
(6221, 'Phone Call List'),
(6222, 'Phone Call List report'),
(6223, 'Phone call made by'),
(6224, 'Phone Cell'),
(6225, 'Phone Contact'),
(6226, 'Phone Gateway Password'),
(6227, 'Phone Gateway URL'),
(6228, 'Phone Gateway Username'),
(6229, 'Phone Home'),
(6230, 'Phone Notification Hour'),
(6231, 'Phone Number'),
(6232, 'Phone number'),
(6233, 'Phone number for billing inquiries'),
(6234, 'Phone Number for Vendor Support that Appears on the About Page.'),
(6235, 'Phone(W)'),
(6236, 'Photophobia'),
(6237, 'Photos'),
(6238, 'PHP compressed'),
(6239, 'PHP CURL module should be enabled in your server.'),
(6240, 'PHP extracted'),
(6241, 'php-GACL access controls are turned off'),
(6242, 'PHP-gacl is not installed'),
(6243, 'Physical Exam'),
(6244, 'Physician'),
(6245, 'Physician Request'),
(6246, 'Physician Signature'),
(6247, 'Physician Type'),
(6248, 'Physicians'),
(6249, 'PH{{pinhole acuity}}'),
(6250, 'PH{{Pinhole Vision}}'),
(6251, 'PH{{Pinhole}}'),
(6252, 'pick'),
(6253, 'Pick'),
(6254, 'Pick a CSS theme.'),
(6255, 'Pick a general theme (need to logout/login after change this setting).'),
(6256, 'PID'),
(6257, 'Pid'),
(6258, 'PID (Pelvic Inflammatory Disease)'),
(6259, 'Pill Size'),
(6260, 'Pills'),
(6261, 'Pinhole Vision'),
(6262, 'Place of Employment-Worksite'),
(6263, 'Place the database zip file in the following directory if want the option to install'),
(6264, 'Place the downloaded ICD 10 database zip files into the following directory'),
(6265, 'Place the downloaded ICD 9 database zip file into the following directory'),
(6266, 'Place the downloaded RxNorm database zip file into the following directory'),
(6267, 'Place the downloaded Snomed database zip file into the following directory'),
(6268, 'Place the downloaded VALUESET database zip file into the following directory'),
(6269, 'Placeholder'),
(6270, 'Placeholder (Maintains empty ACLs)'),
(6271, 'Placeholder (Maintains empty ACLs) (filler)'),
(6272, 'Placeholder (placeholder)'),
(6273, 'Plain Text'),
(6274, 'Plan'),
(6275, 'Plan Added Successfully'),
(6276, 'Plan Already in list_options'),
(6277, 'Plan copay if known'),
(6278, 'Plan Name'),
(6279, 'Plan Name Already Exists'),
(6280, 'Plan Name Already Taken'),
(6281, 'Plan Name Missing'),
(6282, 'Plan of Care'),
(6283, 'Plan of Care Type'),
(6284, 'Plan Set'),
(6285, 'Plan Status Changed'),
(6286, 'Plan Status Failed to Change'),
(6287, 'Plan Updated Successfully'),
(6288, 'Plan:'),
(6289, 'Planned Activity'),
(6290, 'Planned Date'),
(6291, 'Plans'),
(6292, 'Plans Configuration'),
(6293, 'Player'),
(6294, 'Playing Position'),
(6295, 'Please call if any of the above information is incorrect'),
(6296, 'Please call if any of the above information is incorrect.'),
(6297, 'Please call or message if any of the above information is incorrect.'),
(6298, 'Please call our office to schedule'),
(6299, 'Please change your password.'),
(6300, 'Please Choose a file'),
(6301, 'Please choose a patient'),
(6302, 'Please choose a valid selection from the list.'),
(6303, 'Please choose a valid selection.'),
(6304, 'Please choose a value for'),
(6305, 'Please choose date range criteria above, and click Refresh to view results.'),
(6306, 'Please choose the proper formatted EDI-271 file'),
(6307, 'Please Click download button to download the De Identified data'),
(6308, 'Please Click download button to download the Re Identified data'),
(6309, 'Please close this window.'),
(6310, 'Please compare the new name'),
(6311, 'Please consider sending in a donation to'),
(6312, 'Please contact your provider.'),
(6313, 'Please contact your systems administrator, the following component(s) are required but are missing.'),
(6314, 'Please correct the value(s) before proceeding!'),
(6315, 'Please create the following directory before proceeding'),
(6316, 'Please do not accept this prescription unless it was received via facimile.'),
(6317, 'Please do not accept this prescription unless it was received via facsimile.'),
(6318, 'Please do NOT use your browsers stop or reload button while this page is running unless more than 10 minutes have elapsed, this will not cause the process to  stop on the server and will consume uneccesary resources.'),
(6319, 'PLEASE ENABLE CURL EXTENSION'),
(6320, 'PLEASE ENABLE OPENSSL EXTENSION'),
(6321, 'PLEASE ENABLE SOAP EXTENSION'),
(6322, 'PLEASE ENABLE XML EXTENSION'),
(6323, 'Please enter a date for Last Reviewed.'),
(6324, 'Please enter a date.'),
(6325, 'Please enter a dollar amount using only numbers and a decimal point.'),
(6326, 'Please enter a due date'),
(6327, 'Please enter a message'),
(6328, 'Please enter a monetary amount using only numbers and a decimal point.'),
(6329, 'Please Enter a New Password'),
(6330, 'Please enter a title!'),
(6331, 'Please enter a valid Direct Address above.'),
(6332, 'Please enter at least the item\'s name'),
(6333, 'Please enter at least the track\'s name'),
(6334, 'Please enter card comfirmation authorization'),
(6335, 'Please enter correct Re Identification code'),
(6336, 'Please Enter End Date greater than Begin Date!'),
(6337, 'Please enter new search string'),
(6338, 'Please enter the correct Re Identification code'),
(6339, 'Please enter the password'),
(6340, 'Please fill in credit information and send for review.'),
(6341, 'Please Fill the Check Number'),
(6342, 'Please Fill the Check/Ref Number'),
(6343, 'Please Fill the Date'),
(6344, 'Please Fill the Payment Amount'),
(6345, 'Please Fill the Payment Category'),
(6346, 'Please Fill the Payment From'),
(6347, 'Please Fill the Post To Date'),
(6348, 'Please fill them in before continuing.'),
(6349, 'Please indicate visit reason'),
(6350, 'Please input search criteria above, and click Submit to start report.'),
(6351, 'Please input search criteria above, and click Submit to view results.'),
(6352, 'Please input search criteria above, and click Submit to view results. (Results will be displayed in a pop up window)'),
(6353, 'Please login again.'),
(6354, 'Please note that this can take a very long time, up to several minutes, your web browser may not appear very active during this time but generating a bill is a  complicated process and your web browser is merely waiting for more information.'),
(6355, 'Please Note: constants are case sensitive and any string is allowed.'),
(6356, 'Please only use alphabetic characters'),
(6357, 'Please only use alphabetic characters with no spaces'),
(6358, 'Please pay this amount'),
(6359, 'Please place your install files in following directory'),
(6360, 'Please provide a valid e-mail address to proceed'),
(6361, 'Please provide a valid email address'),
(6362, 'Please refer to'),
(6363, 'Please reset the password.'),
(6364, 'Please restart the apache server before playing with de-identification'),
(6365, 'Please return this bottom part with your payment'),
(6366, 'Please see http://www.open-emr.org/wiki/index.php/LBV_Forms for more on this topic'),
(6367, 'Please see the attached PDF.'),
(6368, 'Please Select'),
(6369, 'Please select a format'),
(6370, 'Please select a language'),
(6371, 'Please Select a Patient.'),
(6372, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(6373, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(6374, 'Please select a procedure provider'),
(6375, 'Please Select A Recipient'),
(6376, 'Please select a start date and end date'),
(6377, 'Please select a valid recipient'),
(6378, 'Please Select an Active Group'),
(6379, 'Please select an adjustment reason for code '),
(6380, 'Please select an event'),
(6381, 'Please select any Search Option.'),
(6382, 'Please select at least one criteria to download'),
(6383, 'Please select at least one patient.'),
(6384, 'Please select at least one prescription!'),
(6385, 'Please select encounter'),
(6386, 'Please select From date'),
(6387, 'Please select image procedure'),
(6388, 'Please select the desired pages to copy or forward:'),
(6389, 'Please Select the Payment Method'),
(6390, 'Please select To date'),
(6391, 'Please Select Type Of Payment.'),
(6392, 'Please select visit category'),
(6393, 'Please select X12 partner, required to create the 270 batch'),
(6394, 'Please set'),
(6395, 'Please set de_identification_config variable back to zero'),
(6396, 'Please set pharmacy in patient\'s chart!'),
(6397, 'Please Specify at least One Direct Address'),
(6398, 'Please start new De Identification process'),
(6399, 'Please upgrade OpenEMR Database to include De Identification procedures, function, tables'),
(6400, 'Please view De Identification error log table for more details'),
(6401, 'Please visit De Identification screen after some time'),
(6402, 'Please visit Re Identification screen after some time'),
(6403, 'Please visit the screen after some time'),
(6404, 'Please wait...'),
(6405, 'Plot item'),
(6406, 'Plot selected Items'),
(6407, 'Plural'),
(6408, 'plus 1 year'),
(6409, 'plus 2 years'),
(6410, 'plus 3 years'),
(6411, 'PM'),
(6412, 'PM Program'),
(6413, 'PMH'),
(6414, 'PMH Dx'),
(6415, 'PMH{{Past Medical History}}'),
(6416, 'PMSFH Panel'),
(6417, 'PMSFH{{Abbreviation for Past medical Surgical Family and Social History}}'),
(6418, 'Pmt Method'),
(6419, 'PND'),
(6420, 'Pneumococcal Conjugate 1'),
(6421, 'Pneumococcal Conjugate 2'),
(6422, 'Pneumococcal Conjugate 3'),
(6423, 'Pneumococcal Conjugate 4'),
(6424, 'Pneumococcal Vaccine'),
(6425, 'Pneumonia Vaccination'),
(6426, 'Pneumonia Vaccination Status for Older Adults'),
(6427, 'Pneumonia Vaccination Status for Older Adults (CQM)'),
(6428, 'Podiatric'),
(6429, 'Podiatry'),
(6430, 'POH{{Past Ocular History}}'),
(6431, 'Point of Service (POS)'),
(6432, 'Policy'),
(6433, 'Policy Begin Date'),
(6434, 'Policy effective date'),
(6435, 'Policy No'),
(6436, 'Policy Number'),
(6437, 'Polish'),
(6438, 'Polydypsia'),
(6439, 'Polygon'),
(6440, 'Polyps'),
(6441, 'Polyuria'),
(6442, 'Poor Appetite'),
(6443, 'Poor Circulation'),
(6444, 'Poor Hearing'),
(6445, 'Pop Out Full Screen.'),
(6446, 'Pop ups need to be enabled to see these reports'),
(6447, 'Populate Fee Sheet'),
(6448, 'Populate the year view with events?'),
(6449, 'Popups'),
(6450, 'Port'),
(6451, 'Portal'),
(6452, 'Portal Activity'),
(6453, 'Portal Dashboard'),
(6454, 'Portal ID'),
(6455, 'Portal ID does not match request from portal!'),
(6456, 'Portal Only'),
(6457, 'Portal password is missing'),
(6458, 'Portal Requests'),
(6459, 'Portal Uses Server Base Path (internal)'),
(6460, 'Portrait'),
(6461, 'Portuguese'),
(6462, 'Portuguese (Brazilian)'),
(6463, 'Portuguese (European)'),
(6464, 'POS Code'),
(6465, 'Position'),
(6466, 'Position of Gaze'),
(6467, 'Positive'),
(6468, 'Positives'),
(6469, 'Possible'),
(6470, 'Post Date'),
(6471, 'Post For'),
(6472, 'Post Nasal Drip'),
(6473, 'Post Payment'),
(6474, 'Post Payments'),
(6475, 'Post surgical'),
(6476, 'Post to accounting and mark as billed'),
(6477, 'Post To Date'),
(6478, 'Post To Date Cannot be greater than Today'),
(6479, 'Post To Date Must be greater than the Financial Close Date.'),
(6480, 'Post-Abortion Care'),
(6481, 'Post-Abortion Contraception'),
(6482, 'Post-Abortion Counseling'),
(6483, 'Post-Abortion Followup'),
(6484, 'Postal'),
(6485, 'Postal Code'),
(6486, 'Postal code'),
(6487, 'Postal Code and Box Number'),
(6488, 'PostCalendar'),
(6489, 'PostCalendar Administration'),
(6490, 'PostCalendar Category Settings'),
(6491, 'PostCalendar Global Settings'),
(6492, 'Postcard'),
(6493, 'POSTCARD'),
(6494, 'Postcard printed by'),
(6495, 'Postcards'),
(6496, 'Posted on'),
(6497, 'Posterior Segment'),
(6498, 'Posting'),
(6499, 'Posting Date'),
(6500, 'post{{posterior}}'),
(6501, 'Pos{{Abbreviation for Position}}'),
(6502, 'POS{{Past Ocular Surgery}}'),
(6503, 'Potential Acuity'),
(6504, 'Potential Acuity Meter'),
(6505, 'Powered by'),
(6506, 'PPE + Prev Med/Surg Hx'),
(6507, 'PQRI'),
(6508, 'PQRI Registry ID'),
(6509, 'PQRI Registry Name'),
(6510, 'Practice'),
(6511, 'Practice Default Setting'),
(6512, 'Practice Settings'),
(6513, 'Practice Settings (practice)'),
(6514, 'Practitioner'),
(6515, 'Pre Participation Assessment'),
(6516, 'Pre Pay'),
(6517, 'Pre Payment'),
(6518, 'Pre-Abortion Consultation'),
(6519, 'Pre-Abortion Counseling'),
(6520, 'Pre-payment Amount'),
(6521, 'Pref Cat'),
(6522, 'Preference'),
(6523, 'Preferences'),
(6524, 'Preferences updated successfully'),
(6525, 'Preferred Event Category'),
(6526, 'Preferred Language'),
(6527, 'Preferred Pharmacy'),
(6528, 'Preferred Provider Organization (PPO)'),
(6529, 'Preg Test'),
(6530, 'Preliminary'),
(6531, 'Preparing To Run Report'),
(6532, 'Prepay'),
(6533, 'Prescription'),
(6534, 'prescription has reached its limit of'),
(6535, 'Prescription History'),
(6536, 'Prescription History import successfully completed'),
(6537, 'Prescription Label'),
(6538, 'Prescription Report'),
(6539, 'Prescription successfully removed.'),
(6540, 'Prescription Transmit Review'),
(6541, 'Prescriptions'),
(6542, 'Prescriptions (write,addonly optional)'),
(6543, 'Prescriptions and Dispensations'),
(6544, 'Prescriptions and other referrals'),
(6545, 'Prescriptions and/or referrals by specialist'),
(6546, 'Prescriptions Report'),
(6547, 'Prescriptions/Referrals'),
(6548, 'Present'),
(6549, 'Presenting Complaint'),
(6550, 'Presenting Issue(s)'),
(6551, 'Press Continue to proceed'),
(6552, 'Press this icon to build your Impression/Plan.'),
(6553, 'Presumed Diagnosis'),
(6554, 'Presumed diagnosis by specialist'),
(6555, 'Prev'),
(6556, 'Prev Med/Surg Hx'),
(6557, 'Prev. month (hold for menu)'),
(6558, 'Prev. year (hold for menu)'),
(6559, 'Preventative Care'),
(6560, 'Prevention Rehab'),
(6561, 'Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention (CQM)'),
(6562, 'Preview Event'),
(6563, 'Preview file'),
(6564, 'Preview not available for this document type'),
(6565, 'Preview of'),
(6566, 'Previous'),
(6567, 'Previous Consultations'),
(6568, 'Previous Day'),
(6569, 'Previous History/Screening'),
(6570, 'Previous Month'),
(6571, 'Previous Week'),
(6572, 'Price'),
(6573, 'Price changed'),
(6574, 'Price Discounting'),
(6575, 'Price Level'),
(6576, 'Price level changed'),
(6577, 'Price Level:'),
(6578, 'Pricelevel'),
(6579, 'Prices'),
(6580, 'Primary'),
(6581, 'Primary Business Entity'),
(6582, 'Primary Business Entity tax id is used as account id for NewCrop ePrescription. Changing the facility will affect the working in NewCrop.'),
(6583, 'Primary Business Entity tax id is used as the account id for NewCrop ePrescription.'),
(6584, 'Primary Care'),
(6585, 'Primary Care Provider'),
(6586, 'Primary Facility City'),
(6587, 'Primary Facility Country code'),
(6588, 'Primary Facility State'),
(6589, 'Primary Facility Street Address'),
(6590, 'Primary Facility Zip Code'),
(6591, 'Primary Ins'),
(6592, 'Primary Insurance'),
(6593, 'Primary Insurance Data'),
(6594, 'Primary Insurance Provider'),
(6595, 'Primary Provider'),
(6596, 'Print'),
(6597, 'Print (HTML)'),
(6598, 'Print (PDF)'),
(6599, 'Print Amendments'),
(6600, 'Print Any Encounter'),
(6601, 'Print Blank Referral Form'),
(6602, 'Print Command'),
(6603, 'Print Custom Message'),
(6604, 'Print Date'),
(6605, 'Print End of Day Report 1'),
(6606, 'Print End of Day Report 2'),
(6607, 'Print End of Day Report 3'),
(6608, 'Print Entire Listing'),
(6609, 'Print Format'),
(6610, 'Print Four Panel'),
(6611, 'Print Ledger'),
(6612, 'Print locally'),
(6613, 'Print message'),
(6614, 'Print Multiple'),
(6615, 'Print Multiple To Fax'),
(6616, 'Print name, sign and date.'),
(6617, 'Print Notes'),
(6618, 'Print Page 1'),
(6619, 'Print Page 2'),
(6620, 'Print Patient Address Label'),
(6621, 'Print Patient Billing Note'),
(6622, 'Print Receipts by Provider'),
(6623, 'Print Record'),
(6624, 'Print remotely'),
(6625, 'Print Report'),
(6626, 'Print Selected Statements'),
(6627, 'Print Shot Record'),
(6628, 'Print the Next Appointment on the Bottom of the Ledger'),
(6629, 'Print This Encounter'),
(6630, 'Print this form'),
(6631, 'Print this note'),
(6632, 'Print This Note'),
(6633, 'Print To'),
(6634, 'Print To Fax'),
(6635, 'Print View'),
(6636, 'printable'),
(6637, 'Printable Version'),
(6638, 'Printed'),
(6639, 'Printer'),
(6640, 'Printing Log Option'),
(6641, 'Printing results:'),
(6642, 'Printing skipped; see test output in'),
(6643, 'Printing skipped; see test output in '),
(6644, 'Prints the CMS 1500 on the Preprinted form'),
(6645, 'Prior Auth'),
(6646, 'Prior Authorization Form'),
(6647, 'Prior Exam'),
(6648, 'Prior Eye Meds'),
(6649, 'Prior IMP/PLAN'),
(6650, 'Prior Visit'),
(6651, 'Prior Visits'),
(6652, 'Priority'),
(6653, 'Priority '),
(6654, 'Prism'),
(6655, 'Prism Diopters'),
(6656, 'Prison Correctional Facility'),
(6657, 'Private'),
(6658, 'Problem'),
(6659, 'Problem DX'),
(6660, 'Problem List'),
(6661, 'Problems'),
(6662, 'Problems/Issues'),
(6663, 'Proc Bat'),
(6664, 'Proc Cat'),
(6665, 'Proc Load'),
(6666, 'Proc Pending Rev'),
(6667, 'Proc Prov'),
(6668, 'Proc Res'),
(6669, 'Procedure'),
(6670, 'Procedure Body Sites'),
(6671, 'Procedure Boolean Results'),
(6672, 'Procedure Code'),
(6673, 'Procedure Codes'),
(6674, 'Procedure Lateralities'),
(6675, 'Procedure Name'),
(6676, 'Procedure Order'),
(6677, 'Procedure order'),
(6678, 'Procedure Order for'),
(6679, 'Procedure order not found'),
(6680, 'Procedure Orders and Reports'),
(6681, 'Procedure Picker'),
(6682, 'Procedure provider'),
(6683, 'Procedure Provider'),
(6684, 'Procedure Providers'),
(6685, 'Procedure Report'),
(6686, 'Procedure Report Statuses'),
(6687, 'Procedure Result Abnormal'),
(6688, 'Procedure Result Statuses'),
(6689, 'Procedure Results'),
(6690, 'Procedure Routes'),
(6691, 'Procedure Specimen Types'),
(6692, 'Procedure Statistics Report'),
(6693, 'Procedure Type'),
(6694, 'Procedure Types'),
(6695, 'Procedure Units'),
(6696, 'Procedure/Service'),
(6697, 'Procedures'),
(6698, 'Proceeding to Preferences'),
(6699, 'Process'),
(6700, 'Process and Send Reminders'),
(6701, 'Process ERA File'),
(6702, 'Process New Files'),
(6703, 'Process new files for CSV records'),
(6704, 'Process Reminders'),
(6705, 'Process takes some time'),
(6706, 'Processed'),
(6707, 'Processed By'),
(6708, 'Processed Date'),
(6709, 'processed successfully'),
(6710, 'Processing'),
(6711, 'Processing and Sending Patient Reminders'),
(6712, 'Processing format'),
(6713, 'Processing Patient Reminders'),
(6714, 'Processing Time'),
(6715, 'Product'),
(6716, 'Product added'),
(6717, 'Product Contraceptive Method'),
(6718, 'Product deleted'),
(6719, 'Production'),
(6720, 'Products'),
(6721, 'Products but no prescription drugs and no templates'),
(6722, 'Products Provided'),
(6723, 'Prof.'),
(6724, 'Profile'),
(6725, 'Profile Demographics'),
(6726, 'Profiles'),
(6727, 'Prog.{{Progressive lenses}}'),
(6728, 'Progress'),
(6729, 'Progress Notes'),
(6730, 'Progressive'),
(6731, 'Properties'),
(6732, 'Prostate Cancer'),
(6733, 'Prostate Cancer Screening'),
(6734, 'Prostate Exam'),
(6735, 'Prostate Problems'),
(6736, 'Prostate w/o enlrgmt, nodules, tender'),
(6737, 'Protection Indicator'),
(6738, 'Protection Indicator Effective Date'),
(6739, 'Protocol'),
(6740, 'Provide absolute path'),
(6741, 'Provide absolute path of file'),
(6742, 'Provide clinical summaries for patients for each office visit (New).'),
(6743, 'Provide clinical summaries for patients for each office visit.'),
(6744, 'Provide patients with an electronic copy of their health information (including diagnostic test results, problem list, medication lists, medication allergies), upon request.'),
(6745, 'Provide patients with timely electronic access to their health information (including lab results, problem list, medication lists, medication allergies) within four business days of the information being available to the EP.'),
(6746, 'Provide Records to Patient for Visit'),
(6747, 'Provide valid Email Address'),
(6748, 'Provided Clinical Summary?'),
(6749, 'Provided Education Resource(s)?'),
(6750, 'Provider'),
(6751, 'Provider Access'),
(6752, 'Provider Dashboard'),
(6753, 'Provider Id'),
(6754, 'Provider ID'),
(6755, 'Provider ID at Specified Facility'),
(6756, 'Provider Matching Errors'),
(6757, 'provider name'),
(6758, 'Provider not available, please choose another.'),
(6759, 'Provider not available, use it anyway?'),
(6760, 'Provider Number'),
(6761, 'Provider Number (Type)'),
(6762, 'Provider Qualifier Code'),
(6763, 'Provider Relationship'),
(6764, 'Provider Type'),
(6765, 'Provider/Warehouse'),
(6766, 'Provider:'),
(6767, 'Providers'),
(6768, 'Providers NPI'),
(6769, 'Providers See Entire Calendar'),
(6770, 'Prv'),
(6771, 'PSA'),
(6772, 'Psoriasis'),
(6773, 'Psych'),
(6774, 'Psych Diagnosis'),
(6775, 'Psych Medication'),
(6776, 'Psychiatric'),
(6777, 'Psychiatric Brief Letter'),
(6778, 'Psychiatric Diagnosis'),
(6779, 'Psychiatric Examination'),
(6780, 'Psychiatric Facility-Partial Hospitalization'),
(6781, 'Psychiatric History'),
(6782, 'Psychiatric Intake'),
(6783, 'Psychiatric Medication'),
(6784, 'Psychiatric Residential Treatment Center'),
(6785, 'Psych{{psychiatric}}'),
(6786, 'PSYCH{{Psychiatry}}'),
(6787, 'Pt %'),
(6788, 'Pt Notes'),
(6789, 'Pt Notes/Auth'),
(6790, 'Pt overpaid'),
(6791, 'Pt Paid'),
(6792, 'Pt Rec Request'),
(6793, 'Pt refund'),
(6794, 'Pt released'),
(6795, 'Pt Report'),
(6796, 'PT Student, or leave blank'),
(6797, 'PT_CITY'),
(6798, 'PT_DOB'),
(6799, 'PT_EMAIL'),
(6800, 'PT_FNAME'),
(6801, 'PT_LNAME'),
(6802, 'PT_MNAME'),
(6803, 'PT_PHONE_CELL'),
(6804, 'PT_PHONE_HOME'),
(6805, 'PT_POSTAL'),
(6806, 'PT_SSN'),
(6807, 'PT_STATE'),
(6808, 'PT_STREET'),
(6809, 'Pubid'),
(6810, 'Public'),
(6811, 'Public Agency'),
(6812, 'Public Health Clinic'),
(6813, 'Public health physician'),
(6814, 'Public Health Service (PHS) or Other Federal Agency'),
(6815, 'Public Patient Id'),
(6816, 'Publicity Code'),
(6817, 'Publicity Code Effective Date'),
(6818, 'Publish'),
(6819, 'Publish Patient to FHIR Server'),
(6820, 'Pubpid'),
(6821, 'Puerto Rican'),
(6822, 'puff'),
(6823, 'Pulmonary'),
(6824, 'PULM{{Pulmonary}}'),
(6825, 'Pulse'),
(6826, 'Punjabi'),
(6827, 'Pupils'),
(6828, 'Purchase'),
(6829, 'Purchase/Return'),
(6830, 'Purchases'),
(6831, 'Pyschiatry'),
(6832, 'P{{Justify Header}}'),
(6833, 'Pāli'),
(6834, 'q.3h'),
(6835, 'q.4h'),
(6836, 'q.5h'),
(6837, 'q.6h'),
(6838, 'q.8h'),
(6839, 'q.d.'),
(6840, 'q.i.d.'),
(6841, 'QOE'),
(6842, 'QOH'),
(6843, 'QOH is less than monthly usage'),
(6844, 'Qty'),
(6845, 'QTY'),
(6846, 'Quality'),
(6847, 'Quality Measures (CQM)'),
(6848, 'Quantity'),
(6849, 'Quantity changed'),
(6850, 'Quantity for NDC'),
(6851, 'Quantity On Hand'),
(6852, 'quantity seems unusable'),
(6853, 'Quechua'),
(6854, 'Query Error'),
(6855, 'Question Mark'),
(6856, 'Queue for HCFA batch processing'),
(6857, 'Queue for HCFA batch processing and printing'),
(6858, 'Queue for UB-92 batch processing'),
(6859, 'Queue for UB-92 batch processing and printing'),
(6860, 'Queued'),
(6861, 'Queued Events Administration'),
(6862, 'Queued for'),
(6863, 'Queued for Transfer'),
(6864, 'Queued Submissions Administration'),
(6865, 'Quick Picks'),
(6866, 'Quit'),
(6867, 'Quit Alcohol'),
(6868, 'R'),
(6869, 'R/LG{{right/left gonioscopy}}'),
(6870, 'R/LPACH{{right/left pachymetry}}'),
(6871, 'R/LSCH1{{right/left Schirmers I (w/o anesthesia)}}'),
(6872, 'R/LSCH2{{right/left Schirmers II (w/ anesthesia)}}'),
(6873, 'R/LTBUT{{right/left Tear Break Up Time}}'),
(6874, 'RA for Patient, Encounter, or Trace'),
(6875, 'Race'),
(6876, 'Race and Ethnicity'),
(6877, 'Race/Ethnicity'),
(6878, 'RAC{{right anterior chamber}}'),
(6879, 'Radio'),
(6880, 'Radio buttons'),
(6881, 'RAD{{right adnexa}}'),
(6882, 'Random Drug Screen'),
(6883, 'Range'),
(6884, 'Rashes'),
(6885, 'Rate'),
(6886, 'Rather than granting access to each ACO individually for each user the program grants access to groups that request these privileges. These groups are called Access Request Objects (ARO).'),
(6887, 'Ratio'),
(6888, 'Raw Report'),
(6889, 'RB{{right brow}}'),
(6890, 'RCMT{{right Central Macular Thickness}}'),
(6891, 'RCOM{{right comments}}'),
(6892, 'RCUP{{right cup}}'),
(6893, 'RC{{right conjunctiva}}'),
(6894, 'RD{{retinal detachment}}'),
(6895, 'RD{{right disc}}'),
(6896, 'Re Identification'),
(6897, 'Re Identification Process is completed'),
(6898, 'Re Identification Process is ongoing'),
(6899, 'Re-identification files will be saved in'),
(6900, 'Re-Injury?'),
(6901, 'Re-Open'),
(6902, 'Re-Open Visit'),
(6903, 'Re-opened'),
(6904, 'Re-opening this visit will cause a void. Payment information will need to be re-entered. Do you want to proceed?'),
(6905, 'Reaction'),
(6906, 'Reactions'),
(6907, 'Reactivate'),
(6908, 'react{{reactivity}}'),
(6909, 'Read'),
(6910, 'Read Only'),
(6911, 'Read-only from History'),
(6912, 'Real Name'),
(6913, 'Really delete'),
(6914, 'Reason'),
(6915, 'Reason Deceased'),
(6916, 'Reason for Death'),
(6917, 'Reason for Referral'),
(6918, 'Reason for referral'),
(6919, 'Reason for Visit'),
(6920, 'Reason/Form'),
(6921, 'Reason/Plan'),
(6922, 'Recall'),
(6923, 'Recall Board'),
(6924, 'Recall Board: Disable'),
(6925, 'Recall Campaigns'),
(6926, 'Recall only - any method'),
(6927, 'Recall only - no calls'),
(6928, 'Recall Reason'),
(6929, 'Recall Schedule'),
(6930, 'Recall to provider'),
(6931, 'Recall When'),
(6932, 'Recalls'),
(6933, 'Receipt'),
(6934, 'Receipt for Payment'),
(6935, 'Receipt Generated'),
(6936, 'Receipts by Payment Method Report'),
(6937, 'Receipts Summary'),
(6938, 'Received'),
(6939, 'Received By'),
(6940, 'Received Faxes'),
(6941, 'Received, not reviewed'),
(6942, 'Received, unreviewed'),
(6943, 'Receiver'),
(6944, 'Receiver ID'),
(6945, 'Receiver ID (ISA08)'),
(6946, 'Receiver ID Qualifier (ISA07)'),
(6947, 'Receiver IDs'),
(6948, 'Recent three passwords are not allowed.'),
(6949, 'Recently Completed'),
(6950, 'Recipient'),
(6951, 'Recipient List Is Empty'),
(6952, 'Recipient Name'),
(6953, 'Recipient of the Disclosure'),
(6954, 'Recipient required unless status is Done'),
(6955, 'Recommendation'),
(6956, 'Recommendation For Follow Up'),
(6957, 'Recommendations'),
(6958, 'Recommendations and treatment'),
(6959, 'Recommendations by specialist'),
(6960, 'RECORD'),
(6961, 'Record'),
(6962, 'Record already exist'),
(6963, 'Record and chart changes in vital signs ( Height / Weight / BP with in scope ).'),
(6964, 'Record and chart changes in vital signs (BP out of scope).'),
(6965, 'Record and chart changes in vital signs (Height / Weight out of scope).'),
(6966, 'Record and chart changes in vital signs (New).'),
(6967, 'Record and chart changes in vital signs (SET 1).'),
(6968, 'Record and chart changes in vital signs.'),
(6969, 'Record demographics.'),
(6970, 'Record Disclosure'),
(6971, 'Record of Fitness'),
(6972, 'Record Payment'),
(6973, 'Record Request'),
(6974, 'Record Request Date'),
(6975, 'Record smoking status for patients 13 years old or older.'),
(6976, 'Records'),
(6977, 'records found'),
(6978, 'records found.'),
(6979, 'records per page'),
(6980, 'Recreational drug use'),
(6981, 'Recreational Drugs'),
(6982, 'Rectal'),
(6983, 'Rectal Exam'),
(6984, 'rectally'),
(6985, 'Rectangle'),
(6986, 'Recurrence'),
(6987, 'Recurrent Appointment Display Widget'),
(6988, 'Recurrent Appointments'),
(6989, 'Red Desaturation'),
(6990, 'Red Desat{{red desaturation}}'),
(6991, 'Redirection'),
(6992, 'Redness'),
(6993, 'Redo'),
(6994, 'reduced:'),
(6995, 'Refer'),
(6996, 'Refer By'),
(6997, 'Refer Date'),
(6998, 'Refer To'),
(6999, 'Refer to Message'),
(7000, 'Reference classification (risk level)'),
(7001, 'Reference range of results'),
(7002, 'Reference Reason'),
(7003, 'Reference this Account Id: '),
(7004, 'Referer'),
(7005, 'Referer name and signature'),
(7006, 'Referral'),
(7007, 'Referral By'),
(7008, 'Referral Card'),
(7009, 'Referral Date'),
(7010, 'Referral Form'),
(7011, 'REFERRAL FORM'),
(7012, 'Referral ID'),
(7013, 'Referral Provider'),
(7014, 'Referral Reason'),
(7015, 'Referral Source'),
(7016, 'Referral Source for Encounters'),
(7017, 'Referral To'),
(7018, 'Referrals'),
(7019, 'Referrals Report'),
(7020, 'Referred by'),
(7021, 'Referred By'),
(7022, 'Referred to'),
(7023, 'Referrer'),
(7024, 'Referrer Address'),
(7025, 'Referrer Diagnosis'),
(7026, 'Referrer diagnosis'),
(7027, 'Referrerid'),
(7028, 'Referring physician and practice'),
(7029, 'Referring provider'),
(7030, 'Referring Provider'),
(7031, 'ReFill'),
(7032, 'Refill'),
(7033, 'Refills'),
(7034, 'refills'),
(7035, 'Reflexes normal'),
(7036, 'Refraction Comments'),
(7037, 'Refraction Method'),
(7038, 'Refractive States'),
(7039, 'Refresh'),
(7040, 'Refresh Screen'),
(7041, 'Refreshing Reminders'),
(7042, 'Refund'),
(7043, 'Refused'),
(7044, 'Refused To State'),
(7045, 'reg_re'),
(7046, 'regarding'),
(7047, 'register'),
(7048, 'Register'),
(7049, 'Register your installation with OEMR to receive important notifications, such as security fixes and new release announcements.'),
(7050, 'Registered'),
(7051, 'registered'),
(7052, 'Registered email'),
(7053, 'Registered id'),
(7054, 'Registered Modules'),
(7055, 'Registration Date'),
(7056, 'Registration Form'),
(7057, 'Rehabilitation'),
(7058, 'Rehabilitation physician'),
(7059, 'Rejected'),
(7060, 'Relapse Potential'),
(7061, 'Relate To'),
(7062, 'Related'),
(7063, 'Related Issue'),
(7064, 'Related Patient Notes'),
(7065, 'Relation(s) / Children'),
(7066, 'Relations'),
(7067, 'Relationship'),
(7068, 'Relative ordering of this entity'),
(7069, 'Relatives'),
(7070, 'Relatives Blood Pressure'),
(7071, 'Relatives Cancer'),
(7072, 'Relatives Diabetes'),
(7073, 'Relatives Epilepsy'),
(7074, 'Relatives Heart'),
(7075, 'Relatives Mental Illness'),
(7076, 'Relatives Stroke'),
(7077, 'Relatives Suicide'),
(7078, 'Relatives Tuberculosis'),
(7079, 'Relay Health credentials are missing from this user account.'),
(7080, 'Relay Health ID'),
(7081, 'Release'),
(7082, 'Release Date'),
(7083, 'Religion'),
(7084, 'Religious Affiliation'),
(7085, 'Religious exemption'),
(7086, 'Reload'),
(7087, 'reload names below'),
(7088, 'Relogin'),
(7089, 'Remdr'),
(7090, 'Remember Selected Facility'),
(7091, 'Reminder'),
(7092, 'Reminder Campaigns'),
(7093, 'Reminder done'),
(7094, 'Reminder intervals'),
(7095, 'Reminder Not Sent Yet'),
(7096, 'Reminder only - any method'),
(7097, 'Reminder only - no calls'),
(7098, 'Reminder Sent'),
(7099, 'Reminder Sent On'),
(7100, 'Reminder to provider'),
(7101, 'Reminder/recall - any method'),
(7102, 'Reminder/recall - no calls'),
(7103, 'Reminder/recall - to provider'),
(7104, 'Reminders'),
(7105, 'REMIT TO'),
(7106, 'Remote Host'),
(7107, 'Remove'),
(7108, 'Remove all rules from plan'),
(7109, 'Remove Bottom Pane'),
(7110, 'Remove Group'),
(7111, 'REMOVE GROUP'),
(7112, 'Remove Group Form'),
(7113, 'Remove Tab'),
(7114, 'Remove this Prescription from the list of RXs dispensed'),
(7115, 'Removes support for immunizations'),
(7116, 'Removes support for phpMyAdmin'),
(7117, 'Removes support for prescriptions'),
(7118, 'Removes the bottom pane by default on start up.'),
(7119, 'Removes the Chart Tracker feature'),
(7120, 'Renal Stones'),
(7121, 'Rename'),
(7122, 'Rename Group'),
(7123, 'Rendering'),
(7124, 'Rendering Provider'),
(7125, 'Rendering Provider Number'),
(7126, 'Rendering Provider Number (Type)'),
(7127, 'Reorder'),
(7128, 'Reorder At'),
(7129, 'Reorder point has been reached'),
(7130, 'Reorder point, 0 if not applicable'),
(7131, 'Rep'),
(7132, 'Repeat'),
(7133, 'Repeat New Password'),
(7134, 'Repeat password'),
(7135, 'Repeating event'),
(7136, 'Repeating Info:'),
(7137, 'Repeats'),
(7138, 'REPLACE'),
(7139, 'Replace entire code set'),
(7140, 'replaced'),
(7141, 'Replies'),
(7142, 'Replies retrieved'),
(7143, 'Reply'),
(7144, 'Reply Date'),
(7145, 'Reply From'),
(7146, 'Reply to this message'),
(7147, 'Report'),
(7148, 'report'),
(7149, 'Report - Clinical'),
(7150, 'Report - Patient List Creation'),
(7151, 'Report by'),
(7152, 'Report Content'),
(7153, 'Report Date'),
(7154, 'Report End (Relinquished Care Date)'),
(7155, 'Report has been sent to the patient.'),
(7156, 'Report History/Results'),
(7157, 'Report of visit'),
(7158, 'Report Results'),
(7159, 'Report Results/History'),
(7160, 'Report Start (Assumed Care Date)'),
(7161, 'Report Status'),
(7162, 'Report Totals'),
(7163, 'Report was faxed. Click to view.'),
(7164, 'Report/ Form'),
(7165, 'Report?'),
(7166, 'Reportable'),
(7167, 'Reported'),
(7168, 'Reported Date'),
(7169, 'Reports'),
(7170, 'Request & Response'),
(7171, 'Request Description'),
(7172, 'Request ID is missing!'),
(7173, 'Request ignored - claims processing is already running!'),
(7174, 'Request New Appointment'),
(7175, 'Request Only'),
(7176, 'Request Status'),
(7177, 'Request Type'),
(7178, 'Request type not implemented'),
(7179, 'Requested By'),
(7180, 'Requested Date'),
(7181, 'Requested Service'),
(7182, 'Require Audit'),
(7183, 'Require Strong Passwords'),
(7184, 'Require Unique Passwords'),
(7185, 'Required'),
(7186, 'Required Co Pay'),
(7187, 'Required Field Missing: Please choose the EDI-271 file to upload'),
(7188, 'Required field missing: Please enter the First name'),
(7189, 'Required field missing: Please enter the Last name'),
(7190, 'Required field missing: Please enter the User Name'),
(7191, 'Required fields'),
(7192, 'Requirements'),
(7193, 'RESERVED'),
(7194, 'Reserved'),
(7195, 'Reserved for use to define Scheduled Vacation Time'),
(7196, 'Reserved to define when a provider may not have available appointments after.'),
(7197, 'Reserved to define when an event did not occur as specified.'),
(7198, 'Reserved todefine when a provider may haveavailable appointments after.'),
(7199, 'Reset'),
(7200, 'Reset button resets the edited claim to the fee sheet version. If subsequently saved, it will replace last claim version and be considered reviewed. Otherwise, claim is reset to fee sheet version.'),
(7201, 'Reset claim form to Fee Sheet Version'),
(7202, 'Reset Credentials'),
(7203, 'Reset Offsite Portal Credentials'),
(7204, 'Reset Onsite Portal Credentials'),
(7205, 'Reset to no patient'),
(7206, 'Reset Version'),
(7207, 'Resident physician'),
(7208, 'Residential Substance Abuse Treatment Facility'),
(7209, 'Resn'),
(7210, 'Resolved'),
(7211, 'Resource (select one)'),
(7212, 'Resources'),
(7213, 'Respiration'),
(7214, 'Respirator effort unlabored'),
(7215, 'Respiratory'),
(7216, 'Response'),
(7217, 'Response Only'),
(7218, 'Restore'),
(7219, 'Restore Archive'),
(7220, 'Restrict non-authorized users to the Schedule Facilities set in User admin.'),
(7221, 'Restrict Users to Facilities'),
(7222, 'Restricted Training'),
(7223, 'Result'),
(7224, 'Result Name'),
(7225, 'Result Status'),
(7226, 'Result status or abnormality is missing'),
(7227, 'Result, use % as a wildcard'),
(7228, 'Results'),
(7229, 'Results and'),
(7230, 'Results Found For Search'),
(7231, 'Results Group'),
(7232, 'Results Only'),
(7233, 'Results Path'),
(7234, 'Results per page'),
(7235, 'Results/Details'),
(7236, 'Retina'),
(7237, 'Retina Default Values'),
(7238, 'Retinal Exam'),
(7239, 'Retracted Right:'),
(7240, 'Return'),
(7241, 'Return above part with your payment'),
(7242, 'Return button simply returns, then refreshes billing manager'),
(7243, 'Return Home'),
(7244, 'Return to calendar'),
(7245, 'Return To Report Results'),
(7246, 'Return to this page and you will be able to complete the ICD10 installation process by clicking on the ICD10 section header'),
(7247, 'Return to this page and you will be able to complete the ICD9 installation process by clicking on the ICD9 section header'),
(7248, 'Return to this page and you will be able to complete the RxNorm installation process by clicking on the RXNORM section header'),
(7249, 'Return to this page and you will be able to complete the Snomed installation process by clicking on the SNOMED section header'),
(7250, 'Return to this page and you will be able to complete the Valueset installation process by clicking on the VALUESET section header'),
(7251, 'Return Value'),
(7252, 'Return Visit'),
(7253, 'Returned to Play'),
(7254, 'Reuse of three previous passwords not allowed!'),
(7255, 'Revenue'),
(7256, 'Revenue Code'),
(7257, 'Revenue Code for this item. Type for hints/search'),
(7258, 'Revert'),
(7259, 'Revert Edits'),
(7260, 'Review'),
(7261, 'Review & Approve'),
(7262, 'Review all the parameters that are entered and only then move to the next step. This is because once you create a group (ARO) you will NOT be able of modify any of the data that you have entered in THIS section. You can only delete the entire group (ARO) and start afresh.'),
(7263, 'Review and Approve'),
(7264, 'Review Audits'),
(7265, 'Review of PMH:'),
(7266, 'Review of System'),
(7267, 'Review Of Systems'),
(7268, 'Review of Systems Checks'),
(7269, 'Review Status'),
(7270, 'Review UB04'),
(7271, 'Reviewed'),
(7272, 'Reviewed Date'),
(7273, 'Revise'),
(7274, 'Revision'),
(7275, 'Rheumatoid Arthritis'),
(7276, 'Rheumotoid Arthritis'),
(7277, 'RH{{right hertel measurement}}'),
(7278, 'Right'),
(7279, 'Right Arm'),
(7280, 'Right Deltoid'),
(7281, 'Right Ear'),
(7282, 'right ear'),
(7283, 'Right Gluteus Medius'),
(7284, 'Right Lens'),
(7285, 'Right Lower Forearm'),
(7286, 'Right Margin (mm)'),
(7287, 'Right Thigh'),
(7288, 'Right Vastus Lateralis'),
(7289, 'Right:'),
(7290, 'Ringing in Ears'),
(7291, 'Ringing In Ears'),
(7292, 'Risk Category Assessment'),
(7293, 'Risk Factors'),
(7294, 'Risk Level'),
(7295, 'RI{{right iris}}'),
(7296, 'RK{{right cornea}}'),
(7297, 'RLL:'),
(7298, 'RLL{{right lower eyelid}}'),
(7299, 'RL{{right lens}}'),
(7300, 'RMAC{{right macula}}'),
(7301, 'RMC{{right medial canthus}}'),
(7302, 'ROM'),
(7303, 'Romanian'),
(7304, 'Romansh'),
(7305, 'Room 1'),
(7306, 'Room 2'),
(7307, 'Room 3'),
(7308, 'Room Number'),
(7309, 'Roommate'),
(7310, 'Roster'),
(7311, 'ROS{{Review of Systems}}'),
(7312, 'Round and Reactive'),
(7313, 'Route'),
(7314, 'Route of administration, if applicable'),
(7315, 'Routed'),
(7316, 'Rows'),
(7317, 'RP{{right peripheral retina}}'),
(7318, 'RRR without MOR'),
(7319, 'Rub:'),
(7320, 'Rubs:'),
(7321, 'Rule'),
(7322, 'Rule Add'),
(7323, 'Rule Detail'),
(7324, 'Rule Developer'),
(7325, 'Rule Edit'),
(7326, 'Rule Funding Source'),
(7327, 'Rule Release'),
(7328, 'Rule Set'),
(7329, 'Rule Set and Plan Set selections are not consistent. Please fix and Submit again.'),
(7330, 'Rule Title'),
(7331, 'Rules'),
(7332, 'rules already in plan'),
(7333, 'Rules Configuration'),
(7334, 'RUL{{right upper eyelid}}'),
(7335, 'Run Setup again or contact support for assistance'),
(7336, 'Running Command: '),
(7337, 'Rupture'),
(7338, 'Rural Health Clinic'),
(7339, 'Russian'),
(7340, 'RV{{right vessels}}'),
(7341, 'Rx'),
(7342, 'RX'),
(7343, 'Rx Bottom Margin (px)'),
(7344, 'RX Date'),
(7345, 'Rx Details'),
(7346, 'Rx Dispensed History'),
(7347, 'Rx Enable DEA #'),
(7348, 'Rx Enable NPI'),
(7349, 'Rx Enable State Lic. #'),
(7350, 'Rx History'),
(7351, 'Rx ID'),
(7352, 'Rx Left Margin (px)'),
(7353, 'Rx Log'),
(7354, 'Rx NLM Drug-Drug'),
(7355, 'Rx Paper Size'),
(7356, 'Rx Right Margin (px)'),
(7357, 'Rx Show DEA #'),
(7358, 'Rx Show NPI'),
(7359, 'Rx Show State Lic. #'),
(7360, 'Rx Top Margin (px)'),
(7361, 'Rx Type'),
(7362, 'Rx Type{{Type of glasses prescription}}'),
(7363, 'Rx/Distance'),
(7364, 'RXCUI Medication'),
(7365, 'RxNorm'),
(7366, 'RxNorm Database'),
(7367, 'R{{right side}}'),
(7368, 'R{{right}}'),
(7369, 'S'),
(7370, 'S.S.'),
(7371, 'S3:'),
(7372, 'S4:'),
(7373, 'SA  *  * To read the license please read the docs/license.txt or visit  * http://www.gnu.org/copyleft/gpl.html  *  */  //========================================================================= // '),
(7374, 'Safe key database'),
(7375, 'Sale'),
(7376, 'Sales'),
(7377, 'Sales by Item'),
(7378, 'Sales by Product Report'),
(7379, 'Saliva'),
(7380, 'Same Day'),
(7381, 'Samoan'),
(7382, 'Sample'),
(7383, 'Sanction Type'),
(7384, 'Sango'),
(7385, 'Sanskrit (Samskrta)'),
(7386, 'Sanskrit (Saṁskṛta)'),
(7387, 'Sardinian'),
(7388, 'Sat'),
(7389, 'Sat &amp; Sun'),
(7390, 'Saturday'),
(7391, 'Save'),
(7392, 'SAVE'),
(7393, 'Save Activity'),
(7394, 'Save and Checkout'),
(7395, 'Save and Close'),
(7396, 'Save and Continue'),
(7397, 'Save and Delete Request'),
(7398, 'Save and Dispense'),
(7399, 'Save and Print'),
(7400, 'Save and Transmit'),
(7401, 'Save as New'),
(7402, 'Save as new note'),
(7403, 'Save button saves claim and marks reviewed'),
(7404, 'Save Category'),
(7405, 'Save Certificate Settings'),
(7406, 'Save Changes'),
(7407, 'Save Claim'),
(7408, 'Save claim for batch processing'),
(7409, 'Save codes history'),
(7410, 'Save Completed'),
(7411, 'Save Current'),
(7412, 'Save for printing to a pre printed sheet'),
(7413, 'Save for printing with form'),
(7414, 'Save Form'),
(7415, 'Save Immunization'),
(7416, 'Save New Field'),
(7417, 'Save New Group'),
(7418, 'Save New List'),
(7419, 'Save new template'),
(7420, 'Save omission selections'),
(7421, 'Save Patient Demographics'),
(7422, 'Save Payer'),
(7423, 'Save Report as PDF'),
(7424, 'Save Successful'),
(7425, 'Save Successful for chart ID'),
(7426, 'Save to Chart'),
(7427, 'Save Transaction'),
(7428, 'Saved Successfully'),
(7429, 'Saved to Documents->Onsite Portal->Reviewed - Open there to move or rename.'),
(7430, 'Sa{{Saturday}}'),
(7431, 'sc Distance{{without correction distance}}'),
(7432, 'sc Near{{without correction near}}'),
(7433, 'Scanned'),
(7434, 'Scanned Encounter Note'),
(7435, 'Scanner Directory'),
(7436, 'Scanner In'),
(7437, 'scDist{{ACT without Correction Distance}}'),
(7438, 'scDist{{without correction distance}}'),
(7439, 'Schedule'),
(7440, 'Schedule Facilities:'),
(7441, 'Schedule New Appointment'),
(7442, 'Scheduled'),
(7443, 'Scheduling'),
(7444, 'Schirmer I'),
(7445, 'Schirmer II'),
(7446, 'Schirmers I'),
(7447, 'Schirmers I (w/o anesthesia)'),
(7448, 'Schirmers II'),
(7449, 'Schirmers II (w/ anesthesia)'),
(7450, 'School'),
(7451, 'SCHOOL NOTE'),
(7452, 'School Record'),
(7453, 'Sclera'),
(7454, 'scNear{{ACT without Correction Near}}'),
(7455, 'scNear{{without correction near}}'),
(7456, 'Scoliosis'),
(7457, 'Scottish Gaelic- Gaelic'),
(7458, 'Screen'),
(7459, 'Screening / Testing'),
(7460, 'SC{{Acuity without correction}}'),
(7461, 'sc{{without correction}}'),
(7462, 'SC{{without correction}}'),
(7463, 'SE'),
(7464, 'SE Address'),
(7465, 'SE City'),
(7466, 'SE Country'),
(7467, 'SE Locality'),
(7468, 'SE Postal Code'),
(7469, 'SE State'),
(7470, 'SE Zip Code'),
(7471, 'Search'),
(7472, 'SEARCH'),
(7473, 'search'),
(7474, 'search again'),
(7475, 'Search all columns'),
(7476, 'Search Appointment'),
(7477, 'Search by'),
(7478, 'Search by:'),
(7479, 'Search Diagnoses'),
(7480, 'Search for'),
(7481, 'Search for:'),
(7482, 'Search In'),
(7483, 'Search in'),
(7484, 'Search Not Available'),
(7485, 'Search or Add Patient'),
(7486, 'Search Payment'),
(7487, 'Search Products'),
(7488, 'Search Results'),
(7489, 'Search Results:'),
(7490, 'Search Selected'),
(7491, 'Search Services'),
(7492, 'Search string does not match with list in database'),
(7493, 'Search string should have at least three characters'),
(7494, 'Search Text'),
(7495, 'Search the Events'),
(7496, 'Search/Add'),
(7497, 'Search/Add Insurer'),
(7498, 'Searching for appointments'),
(7499, 'Searching...'),
(7500, 'Seatbelt'),
(7501, 'Seatbelt use'),
(7502, 'Seatbelt Use'),
(7503, 'Second'),
(7504, 'second'),
(7505, 'Second account message'),
(7506, 'Secondary'),
(7507, 'Secondary Insurance'),
(7508, 'Secondary Insurance Data'),
(7509, 'Secondary Insurance Provider'),
(7510, 'Secondary Medicare Type'),
(7511, 'seconds'),
(7512, 'Section ID'),
(7513, 'Section ID and Name Cannot be Empty'),
(7514, 'Section Name'),
(7515, 'Section saved successfully'),
(7516, 'Secure Chat'),
(7517, 'Secure Electronic Messaging'),
(7518, 'Secure Messaging'),
(7519, 'Secure Password Required'),
(7520, 'Secure Patient Chat'),
(7521, 'Secure Upload Files with White List'),
(7522, 'Security'),
(7523, 'See All'),
(7524, 'See All Messages'),
(7525, 'See Authorizations'),
(7526, 'See Growth-Chart'),
(7527, 'See messages from the last set of generated claims'),
(7528, 'See the Clinical Reminders widget for more details'),
(7529, 'Seen since'),
(7530, 'Seen within'),
(7531, 'Segment name'),
(7532, 'Segments Batch Claim'),
(7533, 'Seizures'),
(7534, 'Sel'),
(7535, 'Select'),
(7536, 'select'),
(7537, 'Select a Component'),
(7538, 'Select a Context'),
(7539, 'Select a percentage of the rows or or select dates'),
(7540, 'Select a Time Span'),
(7541, 'Select a User'),
(7542, 'Select a validation rule'),
(7543, 'Select All'),
(7544, 'Select Amendment Date'),
(7545, 'Select amendments to print'),
(7546, 'Select CAMOS Entries for Printing'),
(7547, 'Select Case'),
(7548, 'Select category'),
(7549, 'Select Communication Preferences'),
(7550, 'Select corresponding checkboxes to delete'),
(7551, 'Select Criteria to Remove'),
(7552, 'Select CSV table'),
(7553, 'Select Data Required for De Identification'),
(7554, 'Select data to be included in De Identified data'),
(7555, 'Select date'),
(7556, 'Select desired squad'),
(7557, 'Select Diagnosis'),
(7558, 'Select Diagnosis for De Identification request'),
(7559, 'Select Drug'),
(7560, 'Select Drugs'),
(7561, 'Select Drugs for De Identification request'),
(7562, 'Select EDI-271 file'),
(7563, 'Select Encounter'),
(7564, 'Select field'),
(7565, 'Select Field'),
(7566, 'Select Fields'),
(7567, 'Select for printing'),
(7568, 'Select Group'),
(7569, 'Select Image Procedure'),
(7570, 'Select Immunizations'),
(7571, 'Select Immunizations for De Identification request'),
(7572, 'Select Insurance, by typing'),
(7573, 'Select Issue'),
(7574, 'Select items'),
(7575, 'Select Language'),
(7576, 'Select List'),
(7577, 'Select Month'),
(7578, 'Select One'),
(7579, 'Select one or more diagnosis codes to justify the service'),
(7580, 'Select one or more files to upload'),
(7581, 'Select output'),
(7582, 'Select Pharmacy'),
(7583, 'SELECT PLAN'),
(7584, 'Select Primary Physician'),
(7585, 'Select Requested By'),
(7586, 'Select Role'),
(7587, 'Select SMS Gateway'),
(7588, 'Select source'),
(7589, 'Select State and City to Import for Pharmacy'),
(7590, 'Select Template'),
(7591, 'Select the configuration items to export'),
(7592, 'Select the default font'),
(7593, 'Select the default font size'),
(7594, 'Select the diagnoses to include in the Impression/Plan.'),
(7595, 'Select the group (ARO) that you wish to remove.'),
(7596, 'Select the issue primarily responsible for any missed events on this day'),
(7597, 'Select to print patient address labels from popups in left nav screen.'),
(7598, 'Select to transmit'),
(7599, 'Select Track'),
(7600, 'Select Type'),
(7601, 'Select User'),
(7602, 'SELECT Users FROM The Dropdown LIST'),
(7603, 'Select Users From The Dropdown List'),
(7604, 'Select which languages, if any, may be chosen at login. (only pertinent if above All Languages Allowed is turned off)'),
(7605, 'Select Year'),
(7606, 'Select Yes to confirm group deletion'),
(7607, 'Select1'),
(7608, 'Select2'),
(7609, 'Selected'),
(7610, 'Selected Encounter'),
(7611, 'Selected Files'),
(7612, 'Selected files and data will be removed from folders and tables'),
(7613, 'Selecting this will create a message that needs to be processed by each recipient individually (this is not a group task).'),
(7614, 'Seleted Message id'),
(7615, 'Self'),
(7616, 'Self Pay'),
(7617, 'SEND'),
(7618, 'Send'),
(7619, 'Send A Dated Reminder'),
(7620, 'Send a Reminder'),
(7621, 'Send an email to '),
(7622, 'Send Complete - Prescription(s) Return Status'),
(7623, 'Send Emails'),
(7624, 'Send for Review'),
(7625, 'Send in progress'),
(7626, 'Send It'),
(7627, 'Send message'),
(7628, 'Send message from the permanent group therapist to the personal therapist'),
(7629, 'Send Notes'),
(7630, 'Send Reminders Batch'),
(7631, 'Send reminders to patients per patient preference for preventive/follow up care.'),
(7632, 'Send Request'),
(7633, 'Send Selected to Trash'),
(7634, 'Send Summaries with Referrals'),
(7635, 'Send this file'),
(7636, 'Send This Message'),
(7637, 'Send to'),
(7638, 'Send To'),
(7639, 'SEND TO'),
(7640, 'Send to all'),
(7641, 'Send To HIE failed'),
(7642, 'Send to portal'),
(7643, 'Send to Portal'),
(7644, 'Send to Trash'),
(7645, 'Sender'),
(7646, 'Sender ID'),
(7647, 'Sender ID (ISA06)'),
(7648, 'Sender ID Qualifier (ISA05)'),
(7649, 'Sender IDs'),
(7650, 'sender name'),
(7651, 'Sending Invoice to Patient Portal Completed'),
(7652, 'Sending To'),
(7653, 'Sensitivities'),
(7654, 'Sensitivities (sensitivities)'),
(7655, 'Sensitivity:'),
(7656, 'Sensory exam normal'),
(7657, 'Sent'),
(7658, 'Sent - Confirmed'),
(7659, 'Sent By, Leave Blank For All'),
(7660, 'Sent by:'),
(7661, 'Sent Date'),
(7662, 'Sent Items'),
(7663, 'Sent Medical Records?'),
(7664, 'Sent successfully'),
(7665, 'Sent Summary of Care Electronically?'),
(7666, 'Sent Summary of Care?'),
(7667, 'sent to printer.'),
(7668, 'Sent To, Leave Blank For All'),
(7669, 'Sent to:'),
(7670, 'Sent, but delivery not yet confirmed.'),
(7671, 'Sent, not received'),
(7672, 'Sep'),
(7673, 'Separated'),
(7674, 'September'),
(7675, 'Seq'),
(7676, 'Sequence'),
(7677, 'Serbian'),
(7678, 'Serv Rep'),
(7679, 'Server error: try again later'),
(7680, 'Server Login'),
(7681, 'Server may be offline'),
(7682, 'Server message:'),
(7683, 'Service'),
(7684, 'Service added'),
(7685, 'Service Category'),
(7686, 'Service Code'),
(7687, 'Service Code Finance Reporting'),
(7688, 'Service Codes'),
(7689, 'Service Date'),
(7690, 'Service Date:'),
(7691, 'Service deleted'),
(7692, 'Service Facility'),
(7693, 'Service is not compatible with the sex of this client.'),
(7694, 'Service Location'),
(7695, 'Service Name'),
(7696, 'Service provided by specialist'),
(7697, 'Service provider changed'),
(7698, 'Service Reporting'),
(7699, 'Service Reporting Only'),
(7700, 'Services'),
(7701, 'Services by Category'),
(7702, 'Services Provided'),
(7703, 'Services provided'),
(7704, 'Services/Products'),
(7705, 'Session Type'),
(7706, 'Set'),
(7707, 'Set a facility cookie to remember the selected facility between logins.'),
(7708, 'Set As Completed'),
(7709, 'Set POS code in encounter'),
(7710, 'Set processing priority for CDR engine based reports.'),
(7711, 'Set processing priority for creation of Patient Reminders (in full clinic mode).'),
(7712, 'Set this to the full absolute path. For creating client SSL certificates for HTTPS.'),
(7713, 'Set To'),
(7714, 'Set to Default'),
(7715, 'set value to'),
(7716, 'Sets the font of the address text on the envelope in mm'),
(7717, 'Setting the version number in the database...'),
(7718, 'Settings'),
(7719, 'Setup MedEx'),
(7720, 'Severe'),
(7721, 'Severe Migraine'),
(7722, 'Severity'),
(7723, 'Severity of Pain'),
(7724, 'Severity of Pain:'),
(7725, 'Sex'),
(7726, 'Sexually Transmitted Disease'),
(7727, 'SFTP'),
(7728, 'Sha-1 Hash'),
(7729, 'Sharing'),
(7730, 'Shell command for printing from the server.'),
(7731, 'Shift'),
(7732, 'Shona'),
(7733, 'Short Description'),
(7734, 'Shorthand'),
(7735, 'Shorthand Help'),
(7736, 'Shortness of Breath'),
(7737, 'Shortness Of Breath'),
(7738, 'Shortness Of Breath 2'),
(7739, 'Shot Record'),
(7740, 'Shot Record as of:'),
(7741, 'Should be Enabled'),
(7742, 'should be like nnnnn-nnnn-nn'),
(7743, 'Should be two letters'),
(7744, 'should contain 10 digits'),
(7745, 'should contain only 10 digits'),
(7746, 'Shoulder'),
(7747, 'Shoulder + clavicle'),
(7748, 'Shoulder Problems'),
(7749, 'Show'),
(7750, 'Show Active'),
(7751, 'Show Additional Insurance Information'),
(7752, 'Show Aging on Custom Statement'),
(7753, 'Show All'),
(7754, 'Show all payment history in Patient Ledger'),
(7755, 'Show all procedures'),
(7756, 'Show All Results'),
(7757, 'Show All Transactions'),
(7758, 'Show as Busy'),
(7759, 'Show Authorized Only'),
(7760, 'Show Available Times'),
(7761, 'Show both US and metric (main unit is metric)'),
(7762, 'Show both US and metric (main unit is US)'),
(7763, 'Show Current Signature On File'),
(7764, 'Show Details'),
(7765, 'Show Diagnoses Section'),
(7766, 'Show Errors Only?'),
(7767, 'Show Extra Logo on Login'),
(7768, 'Show Graph'),
(7769, 'Show hovering event text on mouseover?'),
(7770, 'Show how many events on admin pages?'),
(7771, 'Show Inactive'),
(7772, 'Show Insurance Address Information in the Insurance Panel of Demographics.'),
(7773, 'Show IOP by Date'),
(7774, 'Show IOP by Time'),
(7775, 'Show Menu'),
(7776, 'Show metric only'),
(7777, 'Show Mini Logo 1'),
(7778, 'Show Mini Logo 2'),
(7779, 'Show Notes'),
(7780, 'Show only latest values reported for each result code'),
(7781, 'Show only procedures not omitted'),
(7782, 'Show Patient Encounter Number in Patient Flow Board'),
(7783, 'Show Patient ID in Patient Flow Board'),
(7784, 'Show Patient Notes'),
(7785, 'Show pounds and ounces'),
(7786, 'Show pounds as decimal value'),
(7787, 'Show Primary Complete'),
(7788, 'Show Products Section'),
(7789, 'Show Receipt'),
(7790, 'Show Reminders'),
(7791, 'Show Report'),
(7792, 'Show search/submit links in block?'),
(7793, 'Show Selected for Drug Screens'),
(7794, 'Show Services Section'),
(7795, 'Show Status of Drug Screens'),
(7796, 'Show the custom state form for the add list widget (will ask for title and abbreviation).'),
(7797, 'Show this category on the patient summary screen even if no issues have been entered for this category.'),
(7798, 'Show Title on Login'),
(7799, 'Show track history'),
(7800, 'Show Unbilled Only'),
(7801, 'Show US only'),
(7802, 'Show Visit Reason in Patient Flow Board'),
(7803, 'Show/Hide the Selection Area'),
(7804, 'Showing'),
(7805, 'Showing 0 to 0 of 0 entries'),
(7806, 'Showing page'),
(7807, 'Showing result'),
(7808, 'Shutting Down Service ...'),
(7809, 'Sibling'),
(7810, 'Sibling History'),
(7811, 'Sibling in-law'),
(7812, 'Siblings'),
(7813, 'Sickle Cell'),
(7814, 'Sig'),
(7815, 'Sigmoid/Colonoscopy'),
(7816, 'Sign'),
(7817, 'Sign In'),
(7818, 'Sign Lab Results (write,addonly optional)'),
(7819, 'Sign Lab Results (write,addonly optional) (sign)'),
(7820, 'Sign Results'),
(7821, 'Sign-up'),
(7822, 'Sign-up successful for'),
(7823, 'Signature'),
(7824, 'Signature on File'),
(7825, 'Signature On File'),
(7826, 'Signature:'),
(7827, 'Signed Rx'),
(7828, 'Significant Other'),
(7829, 'Significant Swelling:'),
(7830, 'Simplified'),
(7831, 'Simplified Co-Pay'),
(7832, 'Simplified Demographics'),
(7833, 'Simplified Prescriptions'),
(7834, 'Since'),
(7835, 'Sincerely,'),
(7836, 'Sindhi'),
(7837, 'Single'),
(7838, 'Single-selection list'),
(7839, 'Single-selection list with ability to add to the list'),
(7840, 'Singular'),
(7841, 'Sinhala'),
(7842, 'Sinhala, Sinhalese'),
(7843, 'Sinus Problems'),
(7844, 'Sinus Surgery'),
(7845, 'SINUS TENDERNESS:'),
(7846, 'Sinusitis'),
(7847, 'Sister'),
(7848, 'Site'),
(7849, 'Site ID'),
(7850, 'Site ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(7851, 'Site ID for the OpenEMR Support LLC Lab Exchange Service.'),
(7852, 'Site Worker'),
(7853, 'Six Months Ago'),
(7854, 'Six Months Ahead'),
(7855, 'Size'),
(7856, 'size'),
(7857, 'Size must be a number between 1 and 999'),
(7858, 'Size/List'),
(7859, 'Skilled Nursing Facility'),
(7860, 'Skin'),
(7861, 'Skin Cancer'),
(7862, 'Skin Disease'),
(7863, 'Skin Other'),
(7864, 'Skip Authorization of Patient Notes'),
(7865, 'Skipping section'),
(7866, 'Skipping SQL-Ledger dump - not implemented for Windows server'),
(7867, 'Sl.No'),
(7868, 'Slab Off'),
(7869, 'Sleep'),
(7870, 'Sleep patterns'),
(7871, 'Sleep Patterns'),
(7872, 'Sleeping'),
(7873, 'Sliding'),
(7874, 'Slovak'),
(7875, 'Slovene'),
(7876, 'Sm debt w/o'),
(7877, 'Smarty Cache has been cleared'),
(7878, 'Smoker, current status unknown'),
(7879, 'Smoking'),
(7880, 'Smoking Status'),
(7881, 'SMS'),
(7882, 'SMS Auth'),
(7883, 'SMS Confirmed'),
(7884, 'SMS Gateway'),
(7885, 'SMS Gateway API key'),
(7886, 'SMS Gateway API Key'),
(7887, 'SMS Gateway Password'),
(7888, 'SMS Gateway Username'),
(7889, 'SMS Messages'),
(7890, 'SMS Notification'),
(7891, 'SMS Notification Hours'),
(7892, 'SMS Notification Settings Updated Successfully'),
(7893, 'SMS OK'),
(7894, 'SMS send before'),
(7895, 'SMS Sent'),
(7896, 'SMS Text Usable Tags'),
(7897, 'SMS Text, Usable Tag: ***NAME***, ***PROVIDER***, ***DATE***, ***STARTTIME***, ***ENDTIME***<br> i.e. Dear ***NAME***'),
(7898, 'SMS Text, Usable Tags: '),
(7899, 'SMS Zone'),
(7900, 'SMS/Email Alert Settings'),
(7901, 'SMS/Email Alert Settings Updated Successfully'),
(7902, 'SMTP Password for Authentication'),
(7903, 'SMTP Security Protocol'),
(7904, 'SMTP security protocol to connect with. Required by some servers such as gmail.'),
(7905, 'SMTP Server Hostname'),
(7906, 'SMTP Server Port Number'),
(7907, 'SMTP User for Authentication'),
(7908, 'SNOMED'),
(7909, 'SNOMED (RF1) Clinical Term'),
(7910, 'SNOMED (RF1) Diagnosis'),
(7911, 'SNOMED (RF1) Procedure'),
(7912, 'SNOMED (RF2) Diagnosis'),
(7913, 'SNOMED Clinical Term'),
(7914, 'SNOMED Database'),
(7915, 'SNOMED Diagnosis'),
(7916, 'SNOMED Procedure'),
(7917, 'SNOMED-CT Code'),
(7918, 'Snoring'),
(7919, 'SOAP'),
(7920, 'Soap Import Status'),
(7921, 'Soc Hx{{Social History}}'),
(7922, 'Social'),
(7923, 'Social Difficulties'),
(7924, 'Social History'),
(7925, 'Social History Element'),
(7926, 'Social History:'),
(7927, 'Social Security Number'),
(7928, 'Social Security(Optional)'),
(7929, 'solution'),
(7930, 'Somali'),
(7931, 'Somatic Context'),
(7932, 'Some authorizations were not displayed. Click here to view all'),
(7933, 'Some codes were not displayed.'),
(7934, 'Some encounters were not displayed. Click here to view all.'),
(7935, 'Some error has occured during De Identification Process'),
(7936, 'Some notes were not displayed.'),
(7937, 'Some office notes were not displayed. Click here to view all.'),
(7938, 'some words'),
(7939, 'Someone else has just changed this visit. Please cancel this page and try again.'),
(7940, 'Something went wrong'),
(7941, 'Something went wrong.'),
(7942, 'Something went wrong. Please try again.'),
(7943, 'Soon Due Interval (Clinical Reminders)'),
(7944, 'Soon Due Interval (Patient Reminders)'),
(7945, 'Sore Throat'),
(7946, 'Sorry No Appointment is Fixed'),
(7947, 'Sorry you are not privileged enough. Enrollment is limited to Adminstrator accounts.'),
(7948, 'Sorry! Not Authorized.'),
(7949, 'Sorry, there was a problem uploading your file'),
(7950, 'Sorry, there was a problem!'),
(7951, 'Sort alphabetically'),
(7952, 'Sort by'),
(7953, 'Sort By'),
(7954, 'Sort by Category'),
(7955, 'Sort by Checksum'),
(7956, 'Sort by Comments'),
(7957, 'Sort by Crt User'),
(7958, 'Sort by date'),
(7959, 'Sort by date/time'),
(7960, 'Sort by Event'),
(7961, 'Sort by Group'),
(7962, 'Sort by New Checksum'),
(7963, 'Sort by Old Checksum'),
(7964, 'Sort by PatientID'),
(7965, 'Sort by seq'),
(7966, 'Sort by Success'),
(7967, 'Sort by Tamper date/time'),
(7968, 'Sort by User'),
(7969, 'Sort by vaccine'),
(7970, 'Sort Down'),
(7971, 'Sort Result by'),
(7972, 'Sort Up'),
(7973, 'Source'),
(7974, 'Source CSV File'),
(7975, 'Source File'),
(7976, 'Source File Path'),
(7977, 'Source is missing for code '),
(7978, 'Source Lot'),
(7979, 'Source of the document'),
(7980, 'Source Patient'),
(7981, 'Source patient has no DOB'),
(7982, 'Source patient not found'),
(7983, 'Source:'),
(7984, 'South Ndebele'),
(7985, 'Southern Sotho'),
(7986, 'Space'),
(7987, 'SPACE'),
(7988, 'Span Entire Row'),
(7989, 'Spanish'),
(7990, 'Spanish (Latin American)'),
(7991, 'Spanish (Spain)'),
(7992, 'Spanish- Castilian'),
(7993, 'Special characters are not allowed'),
(7994, 'Special treatment for the Vitals form'),
(7995, 'Specialist'),
(7996, 'Specialist name and signature'),
(7997, 'Specialized physician'),
(7998, 'Specialty'),
(7999, 'Specialty Systems'),
(8000, 'Specialty:'),
(8001, 'Specific'),
(8002, 'Specific Application'),
(8003, 'Specific Contraceptive Service'),
(8004, 'Specific Result'),
(8005, 'Specific Service'),
(8006, 'Specified'),
(8007, 'Specifies formatting for codes. # = digit, * = any character. Empty if not used.'),
(8008, 'Specifies formatting for codes. # = digit, @ = alpha, * = any character. Empty if not used.'),
(8009, 'Specifies formatting for invoice reference numbers.  # = digit, * = any character.  Empty if not used.'),
(8010, 'Specifies formatting for invoice reference numbers.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(8011, 'Specifies formatting for product NDC fields.  # = digit, * = any character.  Empty if not used.'),
(8012, 'Specifies formatting for product NDC fields.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(8013, 'Specifies formatting for the external patient ID.  # = digit, * = any character.  Empty if not used.'),
(8014, 'Specifies formatting for the external patient ID.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(8015, 'Specimen'),
(8016, 'Specimen number/identifier'),
(8017, 'Specimen Type'),
(8018, 'Specimen type'),
(8019, 'Speech Dictation'),
(8020, 'Spermicides'),
(8021, 'Sph{{Sphere}}'),
(8022, 'SPH{{Sphere}}'),
(8023, 'Splenectomy'),
(8024, 'Spouse'),
(8025, 'Spouses History'),
(8026, 'Sputum'),
(8027, 'Sputum:'),
(8028, 'SQ'),
(8029, 'sql'),
(8030, 'SQL-Ledger'),
(8031, 'Squad'),
(8032, 'Squad Membership'),
(8033, 'Squads'),
(8034, 'Squads (squads)'),
(8035, 'SRH'),
(8036, 'SRH - Family Planning'),
(8037, 'SRH Non Family Planning'),
(8038, 'SRH Referrals'),
(8039, 'SRH Visit Form'),
(8040, 'Srv Date'),
(8041, 'SS'),
(8042, 'SSL Certificate Administration'),
(8043, 'SSN'),
(8044, 'Stability'),
(8045, 'Stack Trace'),
(8046, 'Staged Releases'),
(8047, 'Standard'),
(8048, 'Standard check'),
(8049, 'Standard Code'),
(8050, 'Standard Measures'),
(8051, 'Standard Measures (Active Alerts)'),
(8052, 'Standard Measures (Passive Alerts)'),
(8053, 'Standard Measures (Patient Reminders)'),
(8054, 'Standard Name'),
(8055, 'Standard; Simplified: only title, start date, comments and an Active checkbox;no diagnosis, occurrence, end date, referred-by or sports fields. ; Football Injury'),
(8056, 'Start'),
(8057, 'Start (yyyy-mm-dd): '),
(8058, 'Start Another Report'),
(8059, 'Start Batch Processing'),
(8060, 'Start Date'),
(8061, 'Start date'),
(8062, 'Start Date at This Clinic'),
(8063, 'Start Date should not be greater than End Date'),
(8064, 'Start date:'),
(8065, 'Start Date:'),
(8066, 'Start Time'),
(8067, 'Starting date'),
(8068, 'Starting Date'),
(8069, 'Starting Date From'),
(8070, 'Starting Date To'),
(8071, 'stat'),
(8072, 'State'),
(8073, 'State Data Type'),
(8074, 'State Lic. #'),
(8075, 'State License Number'),
(8076, 'State list'),
(8077, 'State List (write,addonly optional)'),
(8078, 'State List (write,addonly optional) (state)'),
(8079, 'State List Widget Custom Fields'),
(8080, 'State Or Province'),
(8081, 'State/Locality'),
(8082, 'State/Parish'),
(8083, 'State:'),
(8084, 'Statement Appearance'),
(8085, 'STATEMENT SUMMARY'),
(8086, 'statements and updating invoices.'),
(8087, 'Statements Sent:'),
(8088, 'statements; invoices will not be updated.'),
(8089, 'Static Text'),
(8090, 'Statistics'),
(8091, 'Stats'),
(8092, 'Status'),
(8093, 'Status in the group'),
(8094, 'Status in the meeting'),
(8095, 'Status Of Admission'),
(8096, 'Status of Claim'),
(8097, 'Status quo'),
(8098, 'Status Type'),
(8099, 'STD/AIDS Couns'),
(8100, 'Stength and Conditioning'),
(8101, 'Step Child'),
(8102, 'Step Parent'),
(8103, 'Step Sibling'),
(8104, 'Stepchild'),
(8105, 'Steps for uploading CCR XML'),
(8106, 'Steps to install the DSM IV database'),
(8107, 'Steps to install the ICD 10 database'),
(8108, 'Steps to install the ICD 9 database'),
(8109, 'Steps to install the RxNorm database'),
(8110, 'Steps to install the Snomed database'),
(8111, 'Steps to install the VALUSET database'),
(8112, 'Stereopsis'),
(8113, 'Stiff Joints'),
(8114, 'Stiffness'),
(8115, 'Stock Months'),
(8116, 'Stomach Pains'),
(8117, 'Stop'),
(8118, 'STOP'),
(8119, 'Store your safe key at settings globals in security tab'),
(8120, 'Stored Hash'),
(8121, 'Strabismus'),
(8122, 'Strain of muscle'),
(8123, 'Stream'),
(8124, 'Street'),
(8125, 'Street Address'),
(8126, 'Street and Number'),
(8127, 'Strength'),
(8128, 'Strength and Conditioning'),
(8129, 'Strep Throat'),
(8130, 'Stress fracture'),
(8131, 'Stress Test'),
(8132, 'Stroke'),
(8133, 'stroke'),
(8134, 'Strong password means at least 8 characters, and at least three of: a number, a lowercase letter, an uppercase letter, a special character.'),
(8135, 'Style'),
(8136, 'Style of form used for adding new patients'),
(8137, 'Style your messsage and/or add Image/Video'),
(8138, 'Stylings'),
(8139, 'Sub-category'),
(8140, 'Sub-Total'),
(8141, 'Subcategory'),
(8142, 'subcategory'),
(8143, 'subcutaneously'),
(8144, 'Subject'),
(8145, 'Subjective'),
(8146, 'Sublingual'),
(8147, 'sublingual'),
(8148, 'Submit'),
(8149, 'submit'),
(8150, 'Submit All Content'),
(8151, 'Submit and Delete Request'),
(8152, 'Submit Changes For All Appts At Once'),
(8153, 'Submit Event'),
(8154, 'submit form'),
(8155, 'Submit Payment for Authorization'),
(8156, 'Submit Selected Content'),
(8157, 'Submitted'),
(8158, 'submitted'),
(8159, 'Submitted by'),
(8160, 'Submitter EDI Access Number (PER06)'),
(8161, 'Subscriber'),
(8162, 'Subscriber Address'),
(8163, 'Subscriber City'),
(8164, 'Subscriber Country'),
(8165, 'Subscriber Date of Birth'),
(8166, 'Subscriber Employer'),
(8167, 'Subscriber Employer (SE)'),
(8168, 'Subscriber Employer Address'),
(8169, 'Subscriber Employer City'),
(8170, 'Subscriber Employer Country'),
(8171, 'Subscriber Employer State'),
(8172, 'Subscriber Employer Street'),
(8173, 'Subscriber Employer Zip'),
(8174, 'Subscriber Employer Zip Code'),
(8175, 'Subscriber First Name'),
(8176, 'Subscriber Last Name'),
(8177, 'Subscriber Middle Name'),
(8178, 'Subscriber Phone'),
(8179, 'Subscriber Relationship'),
(8180, 'Subscriber relationship is not self but name is the same! Is this really OK?'),
(8181, 'Subscriber relationship is not self but SS number is the same!'),
(8182, 'Subscriber relationship is self but name is different! Is this really OK?'),
(8183, 'Subscriber relationship is self but SS number is different!'),
(8184, 'Subscriber Sex'),
(8185, 'Subscriber SS'),
(8186, 'Subscriber State'),
(8187, 'Subscriber Zip'),
(8188, 'Subscribter Phone'),
(8189, 'Substance'),
(8190, 'Substance Refusal Reason'),
(8191, 'Substitution'),
(8192, 'substitution allowed'),
(8193, 'Subtitle'),
(8194, 'Subtype'),
(8195, 'Success'),
(8196, 'success'),
(8197, 'Success confirming receipt of lab result'),
(8198, 'Success getting lab results'),
(8199, 'Success retrieving results from Lab Exchange Network'),
(8200, 'Successful Transfers'),
(8201, 'Successfully added category'),
(8202, 'successfully added to category,'),
(8203, 'Successfully Completed'),
(8204, 'Successfully Deleted'),
(8205, 'Successfully Imported the details. Please approve the patient from the Pending Approval Screen'),
(8206, 'Successfully installed the database.'),
(8207, 'Successfully installed the following database'),
(8208, 'Successfully Modified'),
(8209, 'Successfully Saved.Would you like to Allocate?'),
(8210, 'Successfully Saved.Would you like to Distribute?'),
(8211, 'Successfully Sent'),
(8212, 'successfully stored.'),
(8213, 'Successfully upgraded the database.'),
(8214, 'Successfully upgraded the following database'),
(8215, 'successfully.'),
(8216, 'Suffix'),
(8217, 'Suggestions for the Imp/Plan are built from the Exam, the Past Ocular History (POH and POS) and the Past Medical History (PMH)'),
(8218, 'Suicide'),
(8219, 'Summary'),
(8220, 'Summary of'),
(8221, 'Summary of Acuities for this patient'),
(8222, 'Summary Of Care Provided?'),
(8223, 'Summary of Care Provided?'),
(8224, 'Summary of Care Sent'),
(8225, 'Summary of Care Sent Electronically'),
(8226, 'Sun'),
(8227, 'Sundanese'),
(8228, 'Sunday'),
(8229, 'Superbill'),
(8230, 'Superbill Codes'),
(8231, 'Superbill Codes Administration'),
(8232, 'Superbill Codes Administration (superbill)'),
(8233, 'Superbill Report'),
(8234, 'Superbill/Fee Sheet'),
(8235, 'Superbills'),
(8236, 'Superbills, sometimes referred to as Encounter Forms or Routing Slips, are an essential part of most medical practices.'),
(8237, 'Superuser'),
(8238, 'Superuser - can delete patients, encounters, issues (super)'),
(8239, 'Supervising'),
(8240, 'Supervising Doctor'),
(8241, 'Supervising Doctor DEA'),
(8242, 'Supervising Doctor First name'),
(8243, 'Supervising Doctor Last name'),
(8244, 'Supervising Doctor NPI'),
(8245, 'Supervising Doctor UPIN'),
(8246, 'Supervising Provider'),
(8247, 'Supplier'),
(8248, 'Supplier facility name'),
(8249, 'Support calendar events that apply to multiple providers'),
(8250, 'Support export/import of configuration data via the Backup page.'),
(8251, 'Support Multi-Provider Events'),
(8252, 'Support Phone Number'),
(8253, 'Support provider in line item in fee sheet'),
(8254, 'Supports AES-256-CBC encryption/decryption only.'),
(8255, 'Supports TripleDES encryption/decryption only.'),
(8256, 'sup{{superior}}'),
(8257, 'Surface Type'),
(8258, 'Surgeon'),
(8259, 'Surgeries'),
(8260, 'Surgery'),
(8261, 'Surgery Issue List'),
(8262, 'Suspended'),
(8263, 'suspension'),
(8264, 'Su{{Sunday}}'),
(8265, 'Svc Date'),
(8266, 'Svc Date:'),
(8267, 'Swahili'),
(8268, 'Swati'),
(8269, 'Sweating:'),
(8270, 'Swedish'),
(8271, 'Swelling'),
(8272, 'Swelling Right'),
(8273, 'Swollen Joints'),
(8274, 'Swollen Lymph Nodes'),
(8275, 'Symbol used as the decimal point for currency. Not used if Decimal Places is 0.'),
(8276, 'Symbol used to separate thousands for currency.'),
(8277, 'Symptoms'),
(8278, 'Synchronize'),
(8279, 'Synchronize translations with custom language table.'),
(8280, 'Synchronized new custom constant:'),
(8281, 'Synchronized new custom language:'),
(8282, 'Synchronized new definition (Language, Constant, Definition):'),
(8283, 'Syncope'),
(8284, 'Syndromic Surveillance'),
(8285, 'Syndromic Surveillance - Non Reported Issues'),
(8286, 'Syndromic Surveillance Report'),
(8287, 'Synovitis, impingement, bursitis'),
(8288, 'System'),
(8289, 'Systolic'),
(8290, 'S{{Saturday}}'),
(8291, 's{{suffix to make Document plural, ie. Documents}}'),
(8292, 'S{{Sunday}}'),
(8293, 'T'),
(8294, 't.i.d.'),
(8295, 'T.V.'),
(8296, 'Table'),
(8297, 'Table Action'),
(8298, 'Table Args'),
(8299, 'Table Code'),
(8300, 'Table creation failed'),
(8301, 'Table update failed'),
(8302, 'Tables'),
(8303, 'tablet'),
(8304, 'Tabs'),
(8305, 'Tabs Layout Theme (need to logout/login after change this setting)'),
(8306, 'Tag to Encounter'),
(8307, 'Tag to Image Procedure'),
(8308, 'Tagalog'),
(8309, 'Tahitian'),
(8310, 'Tajik'),
(8311, 'Take'),
(8312, 'Take Insurance, from Drop Down'),
(8313, 'Take Payment From, from Drop Down'),
(8314, 'Takeback'),
(8315, 'Takes long'),
(8316, 'Tall Navigation Area'),
(8317, 'Tamil'),
(8318, 'Tamper Date'),
(8319, 'Tampered Checksum'),
(8320, 'Target and source DOB do not match'),
(8321, 'Target and source pid may not be the same!'),
(8322, 'Target and source SSN do not match'),
(8323, 'Target Date'),
(8324, 'Target Patient'),
(8325, 'Target patient has no DOB'),
(8326, 'Target patient not found'),
(8327, 'Target/Action Groups'),
(8328, 'Targets'),
(8329, 'Taskman: Documents in openEMR'),
(8330, 'Tatar'),
(8331, 'Tax Id'),
(8332, 'Tax ID'),
(8333, 'Tax Rate'),
(8334, 'Taxes'),
(8335, 'Taxonomy'),
(8336, 'TA{{temporal arteries}}'),
(8337, 'TB'),
(8338, 'TBUT'),
(8339, 'TBUT{{tear breakup time}}'),
(8340, 'Td'),
(8341, 'Team Injury Overview'),
(8342, 'Team Roster'),
(8343, 'Team Roster View'),
(8344, 'Team/Squad'),
(8345, 'Tear Break Up Time'),
(8346, 'Tel'),
(8347, 'Telephone Country Code'),
(8348, 'Tell me more'),
(8349, 'Telugu'),
(8350, 'Temp'),
(8351, 'Temp Location'),
(8352, 'Temp Method'),
(8353, 'Temp. Art.{{temporal arteries}}'),
(8354, 'Temperature'),
(8355, 'Template'),
(8356, 'Template Name'),
(8357, 'Template names cannot start with numbers.'),
(8358, 'Template selector changed'),
(8359, 'Template:'),
(8360, 'Templates'),
(8361, 'Temporal Art.{{Temporal Artery}}'),
(8362, 'Temporal Arteries'),
(8363, 'Temporal Artery'),
(8364, 'Temporary Lodging'),
(8365, 'temp{{temporal}}'),
(8366, 'Tendon injury'),
(8367, 'Tendonitis / osis / bursitis'),
(8368, 'Tension'),
(8369, 'Tentative Invoice Ref No'),
(8370, 'Terms and Conditions'),
(8371, 'Tertiary'),
(8372, 'Tertiary Insurance'),
(8373, 'Tertiary Insurance Data'),
(8374, 'Tertiary Insurance provider'),
(8375, 'Test only, skip updates'),
(8376, 'Test Scheduling'),
(8377, 'Test System'),
(8378, 'Test/Order'),
(8379, 'Tests Performed'),
(8380, 'Text'),
(8381, 'Text Diagnosis'),
(8382, 'Text field'),
(8383, 'Text for Custom statement message.'),
(8384, 'Text for fifth account message.'),
(8385, 'Text for first account message.'),
(8386, 'Text for fourth account message.'),
(8387, 'Text for second account message.'),
(8388, 'Text for third account message.'),
(8389, 'Text Message permission'),
(8390, 'Text-date'),
(8391, 'text-date'),
(8392, 'Textarea'),
(8393, 'textarea'),
(8394, 'Textbox'),
(8395, 'textbox'),
(8396, 'Textbox list'),
(8397, 'textbox list'),
(8398, 'Thai'),
(8399, 'Thank You'),
(8400, 'Thank you for choosing'),
(8401, 'The \'Clear\' button will remove all annotations.'),
(8402, 'The \'Edit\' window is divided into two columns, \'Active\' and \'Inactive\'. The groups (AROs) that are listed in the active column are those groups that the user belongs to.'),
(8403, 'The *Tab* key creates each entry.'),
(8404, 'The above statement failed'),
(8405, 'The ACL page two sections.'),
(8406, 'The Apache SSL server certificate and public key'),
(8407, 'The Certificate Authority certificate'),
(8408, 'The claim file: '),
(8409, 'The compatible staged US Extension SNOMED package has already been installed.'),
(8410, 'The corresponding private key'),
(8411, 'The data integrity test failed for this form'),
(8412, 'The default code type to search for in the Fee Sheet.'),
(8413, 'The default installation has six such groups - Accounting, Administrators, Clinicians, Emergency Login, Front Office and Physicians.'),
(8414, 'the Denial code is'),
(8415, 'the Denial Group code is'),
(8416, 'The destination form was closed'),
(8417, 'The destination form was closed; I cannot act on your selection.'),
(8418, 'The Encounter Preview button is useful for showing encounter type layout forms as seen when using form in an encounter. Note, this feature is only useful for showing encounter forms and won\'t display system forms like Demographics'),
(8419, 'The entire collection of ACOs forms the Access Control List (ACL).'),
(8420, 'The entity performing this procedure'),
(8421, 'The EP, eligible hospital or CAH who receives a patient from another setting of care or provider of care or believes an encounter is relevant should perform medication reconciliation.'),
(8422, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure A).'),
(8423, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure B).'),
(8424, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral.'),
(8425, 'The event(s) have been approved.'),
(8426, 'The event(s) have been hidden.'),
(8427, 'The exported data appears in the text area below.  You can copy and paste this into an email or to any other desired destination.'),
(8428, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination (or) download the below link.'),
(8429, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.'),
(8430, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.{{MARK FOR DELETION DURING NEXT TRANSLATION BUILD}}'),
(8431, 'The file could not be saved to CouchDB.'),
(8432, 'The file could not be succesfully renamed, this error is usually related to permissions problems on the storage system.'),
(8433, 'The file could not be succesfully stored, this error is usually related to permissions problems on the storage system'),
(8434, 'The first (\"target\") chart is the one that is considered the most complete and accurate. Demographics, history and insurance sections for this one will be retained.'),
(8435, 'The first step is to download the SNOMED CT release. Access to SNOMED CT is provided by IHTSDO and their member countries. For more information see'),
(8436, 'The first step is to download the VALUESET release. Access to VALUESET is provided by NLM. Only valueset for Eligible Professionals need to be downloaded and it should be downloaded in XML format from Sorted By CMS ID column. For more details see the below link'),
(8437, 'The first step is to open an account with the Unified Medical Language System web site'),
(8438, 'The following calendar event has been added:'),
(8439, 'The following calendar event has been modifed:'),
(8440, 'The following categories will be removed from your category List'),
(8441, 'The following database release is currently installed'),
(8442, 'The following documents were attached to this Direct message:'),
(8443, 'The following EDI file has been uploaded'),
(8444, 'The following Emergency Login User is activated:'),
(8445, 'The following errors occurred'),
(8446, 'The following field has an invalid value'),
(8447, 'The following fields are empty.'),
(8448, 'The following fields are required'),
(8449, 'The following fields have to be filled to send a request.'),
(8450, 'The following fields have to be filled to send request.'),
(8451, 'The following International Snomed Release languages are supported'),
(8452, 'The following problems have the same diagnosis codes. Encounter issues will not be updated. Please use the encounter interface instead.'),
(8453, 'The group (ARO) that you created will now appear in alphabetical order in the \'Groups and Access Controls\' section.'),
(8454, 'The hostname of the ATNA audit repository machine.'),
(8455, 'The initial window is the invoice search page.  At the top you may enter a source (e.g. check number), pay date and check amount.  The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim.  The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(8456, 'The input should be a CSV file with 3 columns: layout ID, code type and code.'),
(8457, 'The installation directory needs to be created.'),
(8458, 'The installed International SNOMED version is not compatible with the staged US Extension SNOMED package.'),
(8459, 'The installed International SNOMED version is out of date and not compatible with the staged US Extension SNOMED file.'),
(8460, 'The installed version and the staged files are the same.'),
(8461, 'The installed version is a more recent version than the staged files.'),
(8462, 'The IP address of your domain controller(s).'),
(8463, 'The items listed in the \'Active\' column delineate the privileges of this group (ARO) and constitutes this group\'s Access Control List (ACL).'),
(8464, 'The label that appears to the user on the form'),
(8465, 'The length should not exceed the following number of characters'),
(8466, 'The merge will not run unless SSN and DOB for the two charts are identical. DOBs cannot be empty.'),
(8467, 'The message could not be sent at this time.'),
(8468, 'The new category will be a sub-category of '),
(8469, 'The new password can not be the same as the current password.'),
(8470, 'The new password fields are not the same.'),
(8471, 'The Number of Future Appointments to Display on the Statement.'),
(8472, 'The number of staged files is incorrect. Only place the file that you wish to install/upgrade to.'),
(8473, 'The number of staged files is incorrect. Only place the files that you wish to install/upgrade to.'),
(8474, 'The option Span Entire Row is useful when using Static Text in allowing text to wrap and span entire row regardless of column settings. Another use could be to create an empty row as spacer or add additional option Add Bottom Border to create a line break.Only Bottom Border Row is useful here.'),
(8475, 'The options for Outline and Border will either wrap a row in thin border or add a border to the bottom of an item.'),
(8476, 'The page will be redirected to Demographics. You can edit the country field and clickthrough to NewCrop again.'),
(8477, 'The page you requested was not found. Please check that you typed the URL correctly.'),
(8478, 'The parts of the program to which access can be controlled are called Access Control Objects (ACOs). '),
(8479, 'The password must be at least eight characters, and should'),
(8480, 'The password you entered is invalid'),
(8481, 'The Past Ocular History (POH) and Past Medical History (PMH) are negative.'),
(8482, 'The patient already registered to the group'),
(8483, 'The patient record request has been recorded.'),
(8484, 'The patient reminders have been sent'),
(8485, 'The patient reminders have been updated'),
(8486, 'The patient was not logged in when submitting this form'),
(8487, 'The Patients Rights'),
(8488, 'The payments posted cannot go below this date.This ensures that after taking the final report nobody post for previous dates.'),
(8489, 'The portal has data for this patient and form. Load it now?'),
(8490, 'The raw data feed release can be obtained from'),
(8491, 'The remaining information below applies only if you are posting manually, or if you are doing manual corrections.'),
(8492, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it'),
(8493, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it.'),
(8494, 'The screen refresh time in Seconds for the Patient Flow Board Screen.'),
(8495, 'The second (\"source\") chart will have its demographics, history and insurance sections discarded.  Its other data will be merged into the target chart.'),
(8496, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those.  You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both.  You can also click the \"W\" on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(8497, 'The staged files release dates are not all from the same release.'),
(8498, 'The staged files revisions are not all from the same release.'),
(8499, 'The staged US Extension SNOMED package can not be installed until after the International SNOMED package has been installed.'),
(8500, 'the status of three chronic/inactive problems'),
(8501, 'The suffix of the account.'),
(8502, 'The system does not permit uploading files of with size 0.'),
(8503, 'The system does not permit uploading files with MIME content type'),
(8504, 'The time granularity of the calendar and the smallest interval in minutes for an appointment slot.'),
(8505, 'The Title will be the name of the new group (ARO) that you are going to create.'),
(8506, 'The translated label that will appear on the form in current language'),
(8507, 'The translated Title that will appear in current language'),
(8508, 'The translation of description in current language'),
(8509, 'The translation tables are synchronized.'),
(8510, 'The type of this entity'),
(8511, 'The user\'s actual privileges are determined by the access to the parts of the program i.e. (ACO) that each group (ARO) has.'),
(8512, 'The vendor-specific code identifying this procedure or result'),
(8513, 'The X12 files as well as the resulting HTML output reports are archived in the \"era\" subdirectory of the main OpenEMR installation directory.  You will want to refer to these archives from time to time.  The URL is '),
(8514, 'The zip file will contain the following items'),
(8515, 'Theme'),
(8516, 'Theme of the tabs layout (need to logout and then login to see this new setting).'),
(8517, 'Theme of the tabs layout (need to logout and then login to see this new setting). Note this is only applicable if use the Light or Manila general theme below.'),
(8518, 'Then the raw data feed release can be obtained from'),
(8519, 'Therapeutic Injections'),
(8520, 'Therapy'),
(8521, 'Therapy group'),
(8522, 'Therapy Group'),
(8523, 'Therapy Group Encounter'),
(8524, 'Therapy Group Finder'),
(8525, 'There are'),
(8526, 'There are currently no prescriptions'),
(8527, 'There are errors with your submission.  These are outlined below.'),
(8528, 'There are multiple patients with portal login'),
(8529, 'There are no charts checked out.'),
(8530, 'There are no disclosures recorded for this patient.'),
(8531, 'There are no Glasses or Contact Lens Presciptions on file for this patient'),
(8532, 'There are no New Submissions'),
(8533, 'There are no notes on file for this patient.'),
(8534, 'There are no record(s) found.'),
(8535, 'There are no transactions on file for this patient.'),
(8536, 'There are three actions that can be performed here - edit an existing group (ARO), add a new group (ARO) or delete an existing group (ARO).'),
(8537, 'There has been a mail error sending to'),
(8538, 'There is a lab order'),
(8539, 'There is a Post error'),
(8540, 'There is already a category named'),
(8541, 'There is already a subcategory named'),
(8542, 'There is already an item named'),
(8543, 'There is already an open patient record request.'),
(8544, 'There is no COA entry for AR account '),
(8545, 'There is no COA entry for cash account '),
(8546, 'There is no COA entry for income account '),
(8547, 'There is no current patient'),
(8548, 'There is no local content for this topic.'),
(8549, 'There is no match for invoice id'),
(8550, 'There is no match for invoice id = '),
(8551, 'There is no parts entry for services ID '),
(8552, 'There is no patient with portal login'),
(8553, 'There was a problem sending the message.'),
(8554, 'There was an error while processing your request.'),
(8555, 'There was an OpenEMR SQL Escaping ERROR of the following string'),
(8556, 'These ACOs are grouped into ten broad categories that are part of the default installation. They are - Administration, Accounting, Patient Information, Encounter Information, Squads, Sensitivities, Lists, Placeholder, Nation Notes and Patient Portal. Each of these categories has one or several sub-categories that provide access to specific parts of the program.'),
(8557, 'These are the 2012 links'),
(8558, 'These groups (AROs) can then be given a set of privileges by assigning different categories (ACOs).'),
(8559, 'These lists are used to determine who can access what in openEMR. They work in a top down manner, i.e. initially everybody is denied access to those parts of the program controlled by the ACL.'),
(8560, 'These sub-categories represent the actual Access Control Objects (ACOs).'),
(8561, 'Thickened Right:'),
(8562, 'Thigh'),
(8563, 'Thigh + hamstring'),
(8564, 'Things that back office can only read'),
(8565, 'Things that back office can read and enter but not modify'),
(8566, 'Things that back office can read and modify'),
(8567, 'Things that back office can read and partly modify'),
(8568, 'Things that clinicians can only read'),
(8569, 'Things that clinicians can read and enter but not modify'),
(8570, 'Things that clinicians can read and modify'),
(8571, 'Things that clinicians can read and partly modify'),
(8572, 'Things that front office can only read'),
(8573, 'Things that front office can read and enter but not modify'),
(8574, 'Things that front office can read and modify'),
(8575, 'Things that front office can read and partly modify'),
(8576, 'Things that physicians can only read'),
(8577, 'Things that physicians can read and enter but not modify'),
(8578, 'Things that physicians can read and modify'),
(8579, 'Things that physicians can read and partly modify'),
(8580, 'Third'),
(8581, 'Third account message'),
(8582, 'This account already exists.'),
(8583, 'This action CANNOT be undone.'),
(8584, 'This action cannot be undone.'),
(8585, 'This action cannot be undone. Are you sure you wish to delete this form?'),
(8586, 'This action will be logged'),
(8587, 'This action will reset your claim!'),
(8588, 'This Allows a Date Range to be Selected in Patient Flow Board.'),
(8589, 'This appointment slot is already used, please choose another.'),
(8590, 'This appointment slot is already used, use it anyway?'),
(8591, 'This appointment slot is not available, please choose another.'),
(8592, 'This Calendar Year'),
(8593, 'This claim has been canceled.'),
(8594, 'This claim has been closed.'),
(8595, 'This claim has been denied.Reason:-'),
(8596, 'This claim has been forwarded to next level.'),
(8597, 'This code type does not accept relations.'),
(8598, 'This context contains categories, which will be deleted. Do you still want to continue?'),
(8599, 'This Conversation'),
(8600, 'This determines how appointments display on the calendar.'),
(8601, 'This determines which color schema used for appointment'),
(8602, 'This Enables provider in line item in the fee sheet'),
(8603, 'This Encounter'),
(8604, 'This encounter has been billed. If you need to change it, it must be re-opened.'),
(8605, 'This encounter has been billed. To make changes, re-open it or select Add More Items.'),
(8606, 'This encounter is locked. No new forms can be added.'),
(8607, 'This EOB item does not meet minimum print requirements setup in Globals or there is an unknown error.'),
(8608, 'This fax has already been sent.'),
(8609, 'This feature is not yet available'),
(8610, 'This feature is very experimental and not fully tested. Use at your own risk!'),
(8611, 'This feature will allow the default POS facility code to be overriden from the encounter.'),
(8612, 'This invoice number has been changed to '),
(8613, 'This is a child of result'),
(8614, 'This is done in Administration > Users.'),
(8615, 'This is not a valid request'),
(8616, 'This is the Beginning date for the Ledger Report.'),
(8617, 'This is the chart that is to be merged into the main chart and then deleted.'),
(8618, 'This is the default left print margin for CMS 1500. It will adjust the final printed output left or right.'),
(8619, 'This is the default left print margin for UB04. It will adjust the final printed output left or right.'),
(8620, 'This is the default top print margin for CMS 1500. It will adjust the final printed output up or down.'),
(8621, 'This is the default top print margin for UB04. It will adjust the final printed output up or down.'),
(8622, 'This is the Ending date for the Patient Flow Board Date Range. (only applicable if Allow Date Range in option above is Enabled)'),
(8623, 'This is the latest of multiple result values.'),
(8624, 'This is the main chart that is to receive the merged data.'),
(8625, 'This layout does not exist.'),
(8626, 'This layout ID already exists'),
(8627, 'this location'),
(8628, 'This message text is not saved automatically. Copy and save it as appropriate for the content.'),
(8629, 'This module is being used by '),
(8630, 'This module is in test mode. The database will not be changed.'),
(8631, 'This module promotes efficient entry of EOB data.'),
(8632, 'This Month to Date'),
(8633, 'This name already exists under this parent.'),
(8634, 'This namespace already exists in database'),
(8635, 'This new category will be a sub-category of '),
(8636, 'This order was already transmitted on'),
(8637, 'This page allows you to review each of the supported external dataloads that you can install and upgrade. Each section below can be expanded by clicking on the section header to review the status of the particular database of interest.'),
(8638, 'This page deactivated for security reasons.'),
(8639, 'This page will inline include the login page, so that we do not have to click relogin every time.'),
(8640, 'This patient has no activity.'),
(8641, 'This patient ID is already in use!'),
(8642, 'This portals authentication.'),
(8643, 'This product allows only one lot per warehouse.'),
(8644, 'This protocol is not implemented'),
(8645, 'This report currently only works for ICD9 codes.'),
(8646, 'This section allows you to create and remove groups and modify or grant access privileges to existing groups. Check the check box to display section'),
(8647, 'This section DOES NOT let you create new ACOs.'),
(8648, 'This sets the Default Calendar View, Default is Day.'),
(8649, 'This specifies the Printing of the Custom End of Day Report grouped Provider or allow the Printing of Totals Only'),
(8650, 'This specifies whether to include date in Box 31.'),
(8651, 'This specifies which revision of the form the billing module should generate'),
(8652, 'This step will generate a file which you have to save for future use. The file cannot be generated again. Do you want to proceed?'),
(8653, 'This user is not a member of any group'),
(8654, 'This user will receive notification of new incoming Direct messages'),
(8655, 'This utility is experimental.  Back up your database and documents before using it!'),
(8656, 'This visit begins new contraceptive use'),
(8657, 'This visit will need a GCAC form, referral or procedure service.'),
(8658, 'This was the older metric-only Vitals form, now deprecated.'),
(8659, 'This Week to Date'),
(8660, 'This will abandon your unsaved changes. Are you sure?'),
(8661, 'This will activate the CCR(Continuity of Care Record) and CCD(Continuity of Care Document) reporting.'),
(8662, 'This will allow printing of a custom Message on the statements.'),
(8663, 'This will allow printing of the Patient Billing Note on the statements.'),
(8664, 'This will allow selection of the debugging (\'dummy\') language.'),
(8665, 'This will allow the use of the custom End of Day report and indicate which report to use.'),
(8666, 'This will allow use of the custom Dunning Messages on the statements.'),
(8667, 'This will be a \"dry run\" with no physical data updates.'),
(8668, 'This will clear the data from all Anterior Segment Exam fields'),
(8669, 'This will clear the data from all External Exam fields'),
(8670, 'This will clear the data from all Retina Exam fields'),
(8671, 'This will create a backup in tar format and then send it to your web browser so you can save it'),
(8672, 'This will deactivate document the encryption and decryption features, and hide them in the UI.'),
(8673, 'This will disable the Edit button on all forms whose parent encounter is e-signed'),
(8674, 'This will disable the Edit button on any form that is e-signed'),
(8675, 'This will Display the Invoice Number in the Sales Report or the Patient Name and ID or Patient Name and Invoice Number.'),
(8676, 'This will enable signing an entire encounter, rather than individual forms'),
(8677, 'This will enable signing individual forms separately'),
(8678, 'This will enable the Ability to Exclude Selected Patient Statements from Printing.'),
(8679, 'This will force the Billing Widget in the Patient Summary screen to always be open.'),
(8680, 'This will give the user the option to lock (separate locking and signing)'),
(8681, 'This will hide empty e-sign logs on the patient report'),
(8682, 'This will hide the Billing Widget in the Patient Summary screen'),
(8683, 'This will merge two patient charts into one.  It is useful when a patient has been duplicated by mistake.  If that happens often, fix your office procedures - do not run this routinely!'),
(8684, 'This will not prevent you from going to the e-Prescriptions site.'),
(8685, 'This Will Print the Next Appointment on the Bottom of the Patient Ledger'),
(8686, 'This will Show Aging on the custom Statement.'),
(8687, 'This will turn off use of safe apostrophe, which is done by converting \' and \" to `.(it is highly recommended that this setting is turned off and that safe apostrophe\'s are used)'),
(8688, 'This will use the custom immunizations list rather than the standard CVX immunization list.'),
(8689, 'This will use the custom Statment showing the description instead of the codes.'),
(8690, 'Thoracic physician'),
(8691, 'Thoracic spine'),
(8692, 'Thous/CU.MM'),
(8693, 'Three Months Ago'),
(8694, 'Three Months Ahead'),
(8695, 'Three or four digits at back of your card'),
(8696, 'Thrills'),
(8697, 'Throat'),
(8698, 'Throat Cancer'),
(8699, 'Throat Cancer Surgery'),
(8700, 'Thrombosis/Stroke'),
(8701, 'Thu'),
(8702, 'Thumbnail size'),
(8703, 'Thurdsay'),
(8704, 'Thursday'),
(8705, 'Thyroid normal'),
(8706, 'Thyroid Problems'),
(8707, 'Th{{Thursday}}'),
(8708, 'TIA'),
(8709, 'Tibetan Standard, Tibetan, Central'),
(8710, 'TID'),
(8711, 'Tigrinya'),
(8712, 'Time'),
(8713, 'Time Display Format'),
(8714, 'Time Increment for Add (minutes 1-60)'),
(8715, 'Time selection'),
(8716, 'Time slot is available, saving event'),
(8717, 'Time slot is open, saving event'),
(8718, 'Time Zone'),
(8719, 'Time-To-Live for Allergies SOAP Request in seconds'),
(8720, 'Time-To-Live for Medications SOAP Request in seconds'),
(8721, 'Time-To-Live for NewCrop eRx Allergies SOAP Request in seconds.'),
(8722, 'Time-To-Live for NewCrop eRx Medications SOAP Request in seconds.'),
(8723, 'Timed event'),
(8724, 'Times array (N/A)'),
(8725, 'Timestamp and Text'),
(8726, 'Timing'),
(8727, 'TIN'),
(8728, 'Tinnitus'),
(8729, 'Tips'),
(8730, 'Title'),
(8731, 'Title V'),
(8732, 'TitleCols must be a number between 1 and 999'),
(8733, 'Titles'),
(8734, 'TM\'S:'),
(8735, 'TMs/EAMs/EE, ext nose'),
(8736, 'to'),
(8737, 'To'),
(8738, 'TO'),
(8739, 'to absolute path of file'),
(8740, 'To add notes, please click '),
(8741, 'To add notes, please click here'),
(8742, 'To Affected Area'),
(8743, 'to affected area'),
(8744, 'To automatically open the specified form. Some sports teams use football_injury_audit here.'),
(8745, 'To Billing View'),
(8746, 'to category'),
(8747, 'To Clinical View'),
(8748, 'To copay'),
(8749, 'To date must be later than From date!'),
(8750, 'To ded\'ble'),
(8751, 'To Dems'),
(8752, 'To Disable client side SSL certificates, comment above lines in Apache configuration file and set'),
(8753, 'To Disable HTTPS, comment the above lines in Apache configuration file and restart Apache server.'),
(8754, 'To edit an existing group (ARO) click on the icon next to the desired group. This will bring up the edit window.'),
(8755, 'To enable Client side ssl certificates'),
(8756, 'To Enable Client side SSL certificates authentication, HTTPS should be enabled.'),
(8757, 'To Enable only HTTPS, perform the above changes and restart Apache server. If you want to configure client side certificates also, please configure them in the next section.'),
(8758, 'To Enctr'),
(8759, 'To filter by sex'),
(8760, 'To History'),
(8761, 'To Issues'),
(8762, 'To link this encounter/consult to an existing issue, click the '),
(8763, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click [Save]. Hold down [Ctrl] button to select multiple issues.'),
(8764, 'to login again'),
(8765, 'To move the groups from one column to another select one or more items from the column that you need to move them out of and press the relevant button with the double chevrons.'),
(8766, 'To record disclosures, please click'),
(8767, 'To resend, delete the file from Communications and try again.'),
(8768, 'to run'),
(8769, 'To see to all the ACOs that are available click on the eye icon.'),
(8770, 'To select multiple groups hold down the \'Shift\' or \'Ctrl\' keys while clicking.'),
(8771, 'To setup https access with client certificate authentication, do the following'),
(8772, 'To Skin'),
(8773, 'to skin'),
(8774, 'to this visit?'),
(8775, 'To upload CCR document of already existing patient use Patient Summary Screen->Documents. For CCR document of a new patient use Miscellanous->New Documents screen'),
(8776, 'To:'),
(8777, 'To: '),
(8778, 'TO_CITY'),
(8779, 'TO_FAX'),
(8780, 'TO_FNAME'),
(8781, 'TO_LNAME'),
(8782, 'TO_MNAME'),
(8783, 'TO_ORGANIZATION'),
(8784, 'TO_PHONE'),
(8785, 'TO_PHONECELL'),
(8786, 'TO_POSTAL'),
(8787, 'TO_STATE'),
(8788, 'TO_STREET'),
(8789, 'TO_TITLE'),
(8790, 'TO_VALEDICTORY'),
(8791, 'Tobacco'),
(8792, 'Tobacco Cessation Intervention'),
(8793, 'Tobacco Cessation Intervention (CQM)'),
(8794, 'Tobacco use'),
(8795, 'Tobacco Use'),
(8796, 'Tobacco Use Assessment'),
(8797, 'Tobacco Use Assessment (CQM)'),
(8798, 'Today'),
(8799, 'TODAY'),
(8800, 'today'),
(8801, 'Today\'s Balance'),
(8802, 'Today\'s Charges'),
(8803, 'Today\'s Date'),
(8804, 'Today\'s Events'),
(8805, 'Toggle'),
(8806, 'Toggle All'),
(8807, 'Toggle navigation'),
(8808, 'Toggle the Patient Panel'),
(8809, 'Toggle the right-sided PMSFH panel'),
(8810, 'Token ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(8811, 'Token ID for the OpenEMR Support LLC Lab Exchange Service.'),
(8812, 'Tonga (Tonga Islands)'),
(8813, 'Tonsillectomy'),
(8814, 'tonsillectomy'),
(8815, 'Tooltips'),
(8816, 'Top'),
(8817, 'Top Margin (mm)'),
(8818, 'Topic'),
(8819, 'Total'),
(8820, 'total'),
(8821, 'Total active actions'),
(8822, 'Total active reminders after update'),
(8823, 'Total active reminders before update'),
(8824, 'Total Adj'),
(8825, 'Total amount due'),
(8826, 'Total Amount Paid'),
(8827, 'Total Balance Due'),
(8828, 'Total Charge'),
(8829, 'Total Charges'),
(8830, 'Total Clients'),
(8831, 'Total Co-Pay'),
(8832, 'Total Cost'),
(8833, 'Total Distribution for following check number is not full'),
(8834, 'total entries'),
(8835, 'Total failed reminders sent via email'),
(8836, 'Total failed reminders sent via phone'),
(8837, 'Total for'),
(8838, 'Total for '),
(8839, 'Total for category'),
(8840, 'Total inactivated reminders'),
(8841, 'Total Minimum Amount of Statement to Allow Printing'),
(8842, 'Total Minimum Dollar Amount of Statement to Allow Printing.(only applicable if Allow Statement Exclusions from Printing is enabled)'),
(8843, 'Total new reminders'),
(8844, 'Total number of appointments'),
(8845, 'Total number of Drug Screen entries'),
(8846, 'Total Number of Immunizations'),
(8847, 'Total Number of Issues'),
(8848, 'Total number of Patient Flow Board entries'),
(8849, 'Total Number of Patients'),
(8850, 'Total Pages'),
(8851, 'Total Patient Balance'),
(8852, 'Total patients'),
(8853, 'Total Patients'),
(8854, 'Total Payments'),
(8855, 'Total Records'),
(8856, 'total records'),
(8857, 'Total Records Found'),
(8858, 'Total size'),
(8859, 'Total SRH & Family Planning'),
(8860, 'Total successful reminders sent via email'),
(8861, 'Total successful reminders sent via phone'),
(8862, 'Total Time'),
(8863, 'Total Transfers'),
(8864, 'Total unchanged reminders'),
(8865, 'Total unsent reminders after sending process'),
(8866, 'Total unsent reminders after update'),
(8867, 'Total unsent reminders before sending process'),
(8868, 'Total unsent reminders before update'),
(8869, 'Total updated reminders'),
(8870, 'Totals'),
(8871, 'Totals for'),
(8872, 'Totals for '),
(8873, 'Totals Only'),
(8874, 'to{{range}}'),
(8875, 'To{{range}}'),
(8876, 'Tpn{{Tonopen abbreviation}}'),
(8877, 'TP{{tonopen}}'),
(8878, 'tr'),
(8879, 'Track'),
(8880, 'Track Report'),
(8881, 'Tracks'),
(8882, 'Train'),
(8883, 'Trainer'),
(8884, 'Training'),
(8885, 'Training Type'),
(8886, 'Transact'),
(8887, 'Transaction'),
(8888, 'transaction'),
(8889, 'Transaction failed, insufficient quantity in destination lot'),
(8890, 'Transaction failed, quantity is less than zero'),
(8891, 'Transaction Type'),
(8892, 'transactions'),
(8893, 'Transactions'),
(8894, 'Transactions (write optional)'),
(8895, 'Transactions, e.g. referrals (write optional) (trans)'),
(8896, 'Transactions/Referrals'),
(8897, 'Transdermal'),
(8898, 'Transfer'),
(8899, 'Transfer date'),
(8900, 'Transfer failed, insufficient quantity in source lot'),
(8901, 'Transfer Summary'),
(8902, 'Transfer to'),
(8903, 'Transferred By'),
(8904, 'Transferred Date'),
(8905, 'Transfers'),
(8906, 'Transition Of Care'),
(8907, 'Transition/Transfer of Care?'),
(8908, 'Translate Access Control Groups'),
(8909, 'Translate Appointment Categories'),
(8910, 'Translate Document Categories'),
(8911, 'Translate Layouts'),
(8912, 'Translate Lists'),
(8913, 'Translate Patient Note Titles'),
(8914, 'translate this'),
(8915, 'Translation'),
(8916, 'Translations'),
(8917, 'Transmit'),
(8918, 'Transmit failed'),
(8919, 'Transmit Order'),
(8920, 'Transmit Selected Orders'),
(8921, 'Trash'),
(8922, 'Trauma'),
(8923, 'Treatment'),
(8924, 'Treatment Completion Status'),
(8925, 'Treatment Goals'),
(8926, 'Treatment Plan'),
(8927, 'Treatment Planning'),
(8928, 'Treatment Received'),
(8929, 'Treatment:'),
(8930, 'Treatment: '),
(8931, 'Tree'),
(8932, 'Trend'),
(8933, 'trftime($month_format, mktime(0, 0, 0, $i, 1, 2000)) );             $month_value'),
(8934, 'Tribal 638 Free-standing Facility'),
(8935, 'Tribal 638 Provider-based Facility'),
(8936, 'Trifocal'),
(8937, 'Trifocals'),
(8938, 'Trigger point / compartment syndrome / DOMS / cramp'),
(8939, 'Trimalleolar'),
(8940, 'Tropic 2.5%'),
(8941, 'Trunk and abdomen'),
(8942, 'Trusted Direct Email Address'),
(8943, 'Trusted Email'),
(8944, 'Trying'),
(8945, 'Trying to create user with existing username!'),
(8946, 'Tsonga'),
(8947, 'tsp'),
(8948, 'Tswana'),
(8949, 'TTS'),
(8950, 'Tuberculosis'),
(8951, 'Tue'),
(8952, 'Tues &amp; Thur'),
(8953, 'Tuesday'),
(8954, 'Tumour'),
(8955, 'Turkish'),
(8956, 'Turkmen'),
(8957, 'Turn Off birthday alert'),
(8958, 'Turn on to show all payment history in Patient Ledger'),
(8959, 'Turn the Tooltips on/off'),
(8960, 'Tu{{Tuesday}}'),
(8961, 'Twi'),
(8962, 'twice daily'),
(8963, 'Two Years Ago'),
(8964, 'Two Years Ahead'),
(8965, 'Tx Date'),
(8966, 'Tympanic Membrane'),
(8967, 'Type'),
(8968, 'Type Id or Name.3 characters minimum (including spaces).'),
(8969, 'Type of columns displayed for patient search results'),
(8970, 'Type of Disclosure'),
(8971, 'Type of Events'),
(8972, 'Type of group'),
(8973, 'Type of screen layout'),
(8974, 'Type or scan the patient identifier here'),
(8975, 'Type to search and select revenue code'),
(8976, 'Type Your message here'),
(8977, 'Types of Orders and Results'),
(8978, 'T{{one letter abbreviation for Tension/Pressure}}'),
(8979, 'T{{Thursday}}'),
(8980, 'T{{Tuesday}}'),
(8981, 'UAC Appl'),
(8982, 'UAC Tot'),
(8983, 'UB04 FORM'),
(8984, 'UB04 FORM PDF'),
(8985, 'UB04 left margin in points'),
(8986, 'UB04 Margins'),
(8987, 'UB04 TEXT PDF'),
(8988, 'UB04 top margin in points'),
(8989, 'UCSMC codes provided by the University of Calgary Sports Medicine Centre'),
(8990, 'Ukrainian'),
(8991, 'Ulcerations'),
(8992, 'Ulcerative Colitis'),
(8993, 'Ulcers:'),
(8994, 'Unable insert version information into database'),
(8995, 'Unable to access directory'),
(8996, 'Unable to access URL'),
(8997, 'Unable to create'),
(8998, 'Unable to create patient document subdirectory'),
(8999, 'Unable to decrypt these comments since the PHP mycrypt module is not installed.'),
(9000, 'Unable to decrypt these comments since the PHP openssl module is not installed.'),
(9001, 'Unable to either create credentials or send email.'),
(9002, 'Unable to find window to build'),
(9003, 'Unable to find your records. Be sure to use your correct Dob, First and Last name and Email of record. If you have opted out of email with none on file then leave blank.'),
(9004, 'Unable to locate the data in this file.'),
(9005, 'Unable to match this payment in ar_activity'),
(9006, 'Unable to modify application config Please give write permission to'),
(9007, 'Unable to save file: Use back button!'),
(9008, 'Unapplied'),
(9009, 'Unassigned'),
(9010, 'Unauthorized'),
(9011, 'Unauthorized access to ePrescription'),
(9012, 'Unauthorized access.'),
(9013, 'Unbilled'),
(9014, 'Unbilled Only'),
(9015, 'Uncategorized'),
(9016, 'Uncle'),
(9017, 'under tongue'),
(9018, 'Underweight'),
(9019, 'Undiagnosed'),
(9020, 'UNDISTRIBUTED'),
(9021, 'Undistributed'),
(9022, 'Undistributed is'),
(9023, 'Undo'),
(9024, 'Undo Checkout'),
(9025, 'Unexpected non-match, creating new patient for segment'),
(9026, 'Unique Clients'),
(9027, 'Unique human-readable identifier for this type'),
(9028, 'Unique New Clients'),
(9029, 'Unique numeric identifier for this type'),
(9030, 'Unique Seen Patients'),
(9031, 'Unique Seen Patients Report'),
(9032, 'Unique SP'),
(9033, 'Unit'),
(9034, 'Units'),
(9035, 'units'),
(9036, 'Units applicable to the result value'),
(9037, 'Units for Visit Forms'),
(9038, 'Units must be a number'),
(9039, 'Units not defined'),
(9040, 'Units/L'),
(9041, 'Unknown'),
(9042, 'unknown (see log)'),
(9043, 'Unknown Error'),
(9044, 'Unknown if ever smoked'),
(9045, 'Unknown or N/A'),
(9046, 'Unknown user id:'),
(9047, 'Unknown version'),
(9048, 'unlink patient'),
(9049, 'Unnamed insurance company'),
(9050, 'Unregistered'),
(9051, 'Unregistered Modules'),
(9052, 'Unrelated Friend'),
(9053, 'Unselect All'),
(9054, 'Unselected'),
(9055, 'Unspecified'),
(9056, 'unstructured'),
(9057, 'UNSUPPORTED database load file'),
(9058, 'Unsupported MDM OBX result type'),
(9059, 'until'),
(9060, 'until date'),
(9061, 'Untimely filing'),
(9062, 'Unused'),
(9063, 'UOR'),
(9064, 'Up to'),
(9065, 'Upcoming Appointments'),
(9066, 'Upcoming Events'),
(9067, 'Update'),
(9068, 'update'),
(9069, 'Update Active'),
(9070, 'Update files'),
(9071, 'Update Info'),
(9072, 'Update List'),
(9073, 'Update Provider Number'),
(9074, 'Update Selected Items'),
(9075, 'Update the chart to activate the Builder.'),
(9076, 'Update the chart to build this list'),
(9077, 'Update the following variables in file'),
(9078, 'Update User Information'),
(9079, 'Updated By'),
(9080, 'Updated fields will be purple.'),
(9081, 'Updated!'),
(9082, 'Updating demographics is not authorized.'),
(9083, 'Updating global configuration defaults'),
(9084, 'Updating version indicators'),
(9085, 'UPGRADE'),
(9086, 'Upgrade'),
(9087, 'Upgrade Database'),
(9088, 'Upgrades the OpenEMR database to include Procedures, Functions and tables needed for De-identification process'),
(9089, 'Upgrading will continue'),
(9090, 'UPIN'),
(9091, 'Upload'),
(9092, 'Upload / Save'),
(9093, 'Upload a Template'),
(9094, 'Upload and Apply'),
(9095, 'Upload and Install'),
(9096, 'Upload configuration data'),
(9097, 'Upload Document'),
(9098, 'Upload failed!'),
(9099, 'Upload Image to'),
(9100, 'Upload import file:'),
(9101, 'Upload Item'),
(9102, 'Upload Patient Education PDF to'),
(9103, 'Upload processed successfully'),
(9104, 'Upload Report'),
(9105, 'Upload Template for'),
(9106, 'Upload the xml file under the category CCR'),
(9107, 'Upload this file:'),
(9108, 'Upon clicking an invoice number the \"manual posting window\" appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected paymants have been received.  Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(9109, 'Upon searching you are presented with a list of invoices.  You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting.  You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(9110, 'Upper arm'),
(9111, 'Upper Lids'),
(9112, 'Urdu'),
(9113, 'Urgency'),
(9114, 'Urgent Care'),
(9115, 'Urgent Care Facility'),
(9116, 'Urine'),
(9117, 'Urine Dribbling'),
(9118, 'Urine Frequency'),
(9119, 'Urine Hesitancy'),
(9120, 'Urine Microalbumin'),
(9121, 'Urine Stream'),
(9122, 'Urine Urgency'),
(9123, 'URL'),
(9124, 'URL for NewCrop eRx Site Address.'),
(9125, 'URL for OpenEMR support.'),
(9126, 'URL for Phone Gateway.'),
(9127, 'URL for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(9128, 'URL for the WordPress site that supports the portal'),
(9129, 'URLs for NewCrop eRx Service Address, separated by a semi-colon.'),
(9130, 'USA'),
(9131, 'Usage'),
(9132, 'Usage Indicator (ISA15)'),
(9133, 'Usage Tips'),
(9134, 'Use % alone in a field to just sort on that column'),
(9135, 'Use 24 hour time format?'),
(9136, 'Use a unique word to identify this group, it has to be a single word, if using two words link them together with an underscore or hyphen.'),
(9137, 'Use Active Directory'),
(9138, 'Use Avery Labels'),
(9139, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate(New).'),
(9140, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate.'),
(9141, 'Use Charges Panel'),
(9142, 'Use CPOE for medication orders directly entered by any licensed healthcare professional who can enter orders into the medical record per state, local and professional guidelines.'),
(9143, 'Use CPOE for medication orders.'),
(9144, 'Use CPOE for medication orders.(Alternative)'),
(9145, 'Use CPOE for procedure orders.'),
(9146, 'Use CPOE for radiology orders.'),
(9147, 'Use Custom Dunning Messages'),
(9148, 'Use Custom End of Day Report'),
(9149, 'Use Custom Immunization List'),
(9150, 'Use Custom Statement'),
(9151, 'Use Date Range'),
(9152, 'Use Defaults'),
(9153, 'Use Delete Option to Remove.'),
(9154, 'Use international date style?'),
(9155, 'Use servers protocol and host in urls (portal internal only).'),
(9156, 'Use source filename'),
(9157, 'Use the fields below for a purchase or transfer.'),
(9158, 'Use this feature only with newly installed sites, '),
(9159, 'Use this section to delete existing groups or Access Request Objects (AROs)'),
(9160, 'Use topics?'),
(9161, 'User'),
(9162, 'User '),
(9163, 'User / Groups'),
(9164, 'User Administration'),
(9165, 'User and Facility Administration'),
(9166, 'User and Group Administration'),
(9167, 'User Cannot be Deleted'),
(9168, 'User Certificate Authentication is disabled'),
(9169, 'User Defined'),
(9170, 'User Defined Area 11'),
(9171, 'User Defined Area 12'),
(9172, 'User Defined Field'),
(9173, 'User Defined List 1'),
(9174, 'User Defined List 2'),
(9175, 'User Defined List 3'),
(9176, 'User Defined List 4'),
(9177, 'User Defined List 5'),
(9178, 'User Defined List 6'),
(9179, 'User Defined List 7'),
(9180, 'User Defined Text 1'),
(9181, 'User Defined Text 2'),
(9182, 'User Defined Text 3'),
(9183, 'User Defined Text 4'),
(9184, 'User Defined Text 5'),
(9185, 'User Defined Text 6'),
(9186, 'User Defined Text 7'),
(9187, 'User Defined Text 8'),
(9188, 'User First name'),
(9189, 'User Id'),
(9190, 'User ID'),
(9191, 'User is required to have this access control for Active Alerts and Passive Alerts'),
(9192, 'User Logon (If 03 above, else leave spaces) (ISA02)'),
(9193, 'User logon Required Indicator (ISA01~ use 00 or 03)'),
(9194, 'User Manual'),
(9195, 'User Memberships'),
(9196, 'User Name'),
(9197, 'User name or Host name cannot be empty'),
(9198, 'User or Host name'),
(9199, 'User Password'),
(9200, 'User Password (ISA04~ if 01 above, else leave spaces)'),
(9201, 'User password required Indicator (ISA03~ use 00 or 01)'),
(9202, 'User Settings'),
(9203, 'User Signature'),
(9204, 'User Specific Setting'),
(9205, 'User\'s New Password'),
(9206, 'Userlist1'),
(9207, 'Userlist2'),
(9208, 'Userlist3'),
(9209, 'Userlist4'),
(9210, 'Userlist5'),
(9211, 'Userlist6'),
(9212, 'Userlist7'),
(9213, 'username'),
(9214, 'Username'),
(9215, 'Username for Phone Gateway.'),
(9216, 'Username for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(9217, 'Username for SMS Gateway'),
(9218, 'Username for SMS Gateway.'),
(9219, 'Username to connect to CouchDB'),
(9220, 'Username:'),
(9221, 'Users'),
(9222, 'Users is the standard windows CN, replace the DC stuff with your domain.'),
(9223, 'Users/Groups/Logs Administration'),
(9224, 'Users/Groups/Logs Administration (users)'),
(9225, 'Usertext1'),
(9226, 'Usertext2'),
(9227, 'Usertext3'),
(9228, 'Usertext4'),
(9229, 'Usertext5'),
(9230, 'Usertext6'),
(9231, 'Usertext7'),
(9232, 'Usertext8'),
(9233, 'uses php <a href=\"http://php.net/strftime\">strftime</a> format'),
(9234, 'Using technology to improve productivity'),
(9235, 'UTIs'),
(9236, 'Uyghur, Uighur'),
(9237, 'Uzbek'),
(9238, 'VACATION'),
(9239, 'Vacation'),
(9240, 'Vaccine'),
(9241, 'Vaccine funding program eligibility category'),
(9242, 'Vaccine Type'),
(9243, 'Vaginal Ring'),
(9244, 'Valedictory'),
(9245, 'validate'),
(9246, 'Validate Log'),
(9247, 'Validation error: Fix and resubmit. Payment values are preserved!'),
(9248, 'Validation error: Fix and resubmit. This popup info is preserved!'),
(9249, 'Validation mechanism for when modifying patient demographics.'),
(9250, 'Validation rule'),
(9251, 'Value'),
(9252, 'Value 1'),
(9253, 'Value 2'),
(9254, 'Value if comparing'),
(9255, 'Value Should be Numeric'),
(9256, 'Var1'),
(9257, 'Var2'),
(9258, 'variable to one to run de-identification upgrade script'),
(9259, 'Variation in red color discrimination between the eyes (eg. OD=100, OS=75)'),
(9260, 'Variation in white (muscle) light brightness discrimination between the eyes (eg. OD=$1.00, OS=$0.75)'),
(9261, 'Varicella 1'),
(9262, 'Varicella 2'),
(9263, 'Varicose Veins'),
(9264, 'Vascular condition'),
(9265, 'Vascular injury'),
(9266, 'Vascular Surgery'),
(9267, 'Va{{Visual Acuities}}'),
(9268, 'VB{{abbreviation for Vertical Prism Base}}'),
(9269, 'VD{{abbreviation for Vertex Distance}}'),
(9270, 'Venda'),
(9271, 'Vendor'),
(9272, 'Verify'),
(9273, 'Version'),
(9274, 'Version 1 Onsite Patient Portal Site Address'),
(9275, 'Version 2 Onsite Patient Portal Site Address'),
(9276, 'Version Number'),
(9277, 'Vert Base{{abbreviation for Vertical Prism Base}}'),
(9278, 'Vert Distance{{abbreviation for Vertex Distance}}'),
(9279, 'Vert Fissure{{vertical fissure height}}'),
(9280, 'Vert Fissure{{vertical fissure}}'),
(9281, 'Vert Fusional Amps'),
(9282, 'Vert Prism{{abbreviation for Vertical Prism Power}}'),
(9283, 'Vertex Distance'),
(9284, 'Vertical Fissure: central height between lid margins'),
(9285, 'Vertical Fusional'),
(9286, 'Vertical Menu Style'),
(9287, 'Vertical Prism Base'),
(9288, 'Vertical Prism Power'),
(9289, 'Vertigo'),
(9290, 'Vessels'),
(9291, 'Veteran`s Administration'),
(9292, 'Veterans Administration Plan'),
(9293, 'Vfc'),
(9294, 'VFC'),
(9295, 'VFC eligible- American Indian/Alaskan Native'),
(9296, 'VFC eligible- Uninsured'),
(9297, 'VFC eligible-Federally Qualified Health Center Patient (under-insured)'),
(9298, 'VFC eligible-Medicaid/Medicaid Managed Care'),
(9299, 'VF{{vertical fissure}}'),
(9300, 'via{{shipped by/supplier}}'),
(9301, 'Vietnamese'),
(9302, 'view'),
(9303, 'View'),
(9304, 'view - can only read but not add or modify'),
(9305, 'View Allergies'),
(9306, 'View an x12-835 ERA file'),
(9307, 'View Batch Claim x12 text'),
(9308, 'View Blank Referral Form'),
(9309, 'View CCD'),
(9310, 'View CCDA'),
(9311, 'View Comprehensive Patient Report'),
(9312, 'View CSV tables'),
(9313, 'View details'),
(9314, 'View document'),
(9315, 'View EDI x12 file'),
(9316, 'View encounter'),
(9317, 'View ERA x12 text'),
(9318, 'View events in a popup window?'),
(9319, 'View Facility Specific User Information'),
(9320, 'View Four Panel'),
(9321, 'View local x12 file'),
(9322, 'View Log'),
(9323, 'View Messages'),
(9324, 'View Page 1'),
(9325, 'View Page 2'),
(9326, 'View Past and Future Reminders'),
(9327, 'View Past Encounter'),
(9328, 'View Past Encounters'),
(9329, 'View Patient'),
(9330, 'View Plan Rules'),
(9331, 'View Printable'),
(9332, 'View Printable Report'),
(9333, 'View Printable Version'),
(9334, 'View related encounters'),
(9335, 'View Report'),
(9336, 'View the README file'),
(9337, 'View the Summary Report sent to Fax Server.'),
(9338, 'View the Summary Report sent via Fax Server on'),
(9339, 'View, Download, Transmit (VDT)  (Measure B)'),
(9340, 'View, Download, Transmit (VDT) (Measure A)'),
(9341, 'View/Add/Update groups'),
(9342, 'View/Create/Update groups appointment in calendar'),
(9343, 'View/Edit Allergies'),
(9344, 'View/edit issue'),
(9345, 'View/Print'),
(9346, 'View:'),
(9347, 'VISA'),
(9348, 'VISA/MC/AMEX/Dis'),
(9349, 'VISA/MC/Discovery/HSA'),
(9350, 'Visceral damage/trauma/surgery'),
(9351, 'VisForm'),
(9352, 'Vision'),
(9353, 'Visit'),
(9354, 'Visit Attributes'),
(9355, 'Visit Categories'),
(9356, 'Visit Category'),
(9357, 'Visit Category:'),
(9358, 'Visit Date'),
(9359, 'Visit date'),
(9360, 'Visit Form Attributes'),
(9361, 'Visit form ID must start with LBF. Transaction form ID must start with LBT.'),
(9362, 'Visit Forms'),
(9363, 'Visit History'),
(9364, 'Visit Patient Home Page'),
(9365, 'Visit Provider Home Page'),
(9366, 'Visit Reason'),
(9367, 'Visit Status'),
(9368, 'Visit Summary'),
(9369, 'Visit Test Server'),
(9370, 'Visit Type'),
(9371, 'Visited Patients'),
(9372, 'Visits'),
(9373, 'Visits From'),
(9374, 'Visual Acuities'),
(9375, 'Visual Acuity'),
(9376, 'Visual Fields'),
(9377, 'Vital Signs'),
(9378, 'Vitals'),
(9379, 'Vitals (Metric)'),
(9380, 'Vitals Form Options'),
(9381, 'Voice'),
(9382, 'Voice Messages'),
(9383, 'Voice Sent'),
(9384, 'Void Checkout and Re-Open'),
(9385, 'Volapuk'),
(9386, 'Volapük'),
(9387, 'Vomiting'),
(9388, 'Voucher Number'),
(9389, 'VP{{abbreviation for Vertical Prism Power}}'),
(9390, 'V{{One letter abbrevation for Vision}}'),
(9391, 'W'),
(9392, 'W Rx{{Acuity with correction}}'),
(9393, 'W2W{{white-to-white}}'),
(9394, 'Waist Circ'),
(9395, 'Waist Circumference'),
(9396, 'Waiting'),
(9397, 'Walk-In'),
(9398, 'Walk-in Retail Health Clinic'),
(9399, 'Walloon'),
(9400, 'Walt Pennington'),
(9401, 'Ward of court'),
(9402, 'Warehouse'),
(9403, 'Warehouse changed'),
(9404, 'Warehouse maximum, 0 if not applicable'),
(9405, 'Warehouse minimum, 0 if not applicable'),
(9406, 'Warehouses'),
(9407, 'Warm'),
(9408, 'Warning'),
(9409, 'WARNING'),
(9410, 'WARNING - FOLLOWING ACTIVE MEDICATIONS ARE ALLERGIES'),
(9411, 'Warning, Check Number already exist in the database'),
(9412, 'Warning, patient has ambiguous codes in the problems list!'),
(9413, 'Warning: A visit was already created for this patient today!'),
(9414, 'Warning: Contraception for a patient under 10 or over 50.'),
(9415, 'Warning: Contraceptive method is not compatible with a male patient.'),
(9416, 'WARNING: If you are using the 2012-10-31 Spanish version, then note you need to unzip it once before placing it in the contrib/snomed (this is because the released file was \"double-zipped\").'),
(9417, 'Warning: Navigation error. Please refresh this page.'),
(9418, 'Warning: Patient ID is not unique!'),
(9419, 'Warning: There is no product matching the contraceptive service.'),
(9420, 'Warning: There is no service matching the contraceptive product.'),
(9421, 'WARNING: This will overwrite configuration information with data from the uploaded file!'),
(9422, 'WARNINGS'),
(9423, 'Warnings'),
(9424, 'WARNINGS and Alerts/Reminders'),
(9425, 'was already uploaded'),
(9426, 'was not found'),
(9427, 'We appreciate prompt payment of balances due'),
(9428, 'We appreciate prompt payment of balances due.'),
(9429, 'we have seen your above patient for evaluation and treatment at our outpatient psychiatry clinic. Thank you for this referral.'),
(9430, 'We ran into some problems connecting your EHR to the MedEx servers'),
(9431, 'Weakness'),
(9432, 'Web Reference'),
(9433, 'Web Search'),
(9434, 'Website'),
(9435, 'Website link for the Onsite Patient Portal.'),
(9436, 'Website link for the Version 1 Onsite Patient Portal.'),
(9437, 'Website link for the Version 2 Onsite Patient Portal.'),
(9438, 'Wed'),
(9439, 'Wednesday'),
(9440, 'Week'),
(9441, 'week'),
(9442, 'Week View'),
(9443, 'Week(s)'),
(9444, 'Weekly Exposures'),
(9445, 'weeks'),
(9446, 'Weeks'),
(9447, 'Weight'),
(9448, 'Weight Assessment and Counseling for Children and Adolescents'),
(9449, 'Weight Assessment and Counseling for Children and Adolescents (CQM)'),
(9450, 'Weight Change'),
(9451, 'Weight Loss'),
(9452, 'Weight loss clinic'),
(9453, 'Welcome'),
(9454, 'Welsh'),
(9455, 'Weno Account Clinic ID information missing'),
(9456, 'Weno Account ID information missing'),
(9457, 'Weno Admin'),
(9458, 'Weno eRx Account Id'),
(9459, 'Weno eRx Account Pass'),
(9460, 'Weno eRx Clinic ID'),
(9461, 'Weno Provider ID'),
(9462, 'Weno Sample Code'),
(9463, 'Weno Service is Enabled'),
(9464, 'Western Frisian'),
(9465, 'We{{Wednesday}}'),
(9466, 'What is to be counted?'),
(9467, 'What kind of sorting will be in the drop lists.'),
(9468, 'Wheezes:'),
(9469, 'Wheezing'),
(9470, 'Wheezing:'),
(9471, 'When a new user is created, access control is granted by the administrator or by a user with similar privileges by selecting which groups (AROs) a user can belong to.'),
(9472, 'When and how often?'),
(9473, 'When Checked, Demographics Will Open in New Window from Patient Flow Board.'),
(9474, 'When Checked, Last Staff to Update Board Will Show in Patient Flow Board.'),
(9475, 'When checked, messages are processed for patients with Patient Demographic Choice: \"Hipaa Notice Received\" set to \"Unassigned\" or \"Yes\". When unchecked, this choice must = \"YES\" to process the patient reminder. For patients with Choice =\"No\", Reminders will need to be processed manually.'),
(9476, 'When Checked, Patient Encounter Number Will Show in Patient Flow Board.'),
(9477, 'When Checked, Patient ID Will Show in Patient Flow Board.'),
(9478, 'When Checked, Visit Reason Will Show in Patient Flow Board.'),
(9479, 'When done, click Submit (below) to apply your choices.'),
(9480, 'Where may related scanned or paper documents be found?'),
(9481, 'Where on your body does it occur?'),
(9482, 'Whether Insured'),
(9483, 'which days are your weekend days?'),
(9484, 'Which notes are to be displayed in the Billing Screen'),
(9485, 'Whiplash'),
(9486, 'White'),
(9487, 'White list'),
(9488, 'White-to-white'),
(9489, 'Who'),
(9490, 'Who replied?'),
(9491, 'Widowed'),
(9492, 'Width'),
(9493, 'Width in pixels of the left navigation frame.'),
(9494, 'will be hidden if'),
(9495, 'will have the following validation rules'),
(9496, 'With checked items plot'),
(9497, 'with import'),
(9498, 'with preferred language'),
(9499, 'With selected:'),
(9500, 'with the old name'),
(9501, 'with value'),
(9502, 'With whom may we leave a message?'),
(9503, 'Withheld'),
(9504, 'within hours'),
(9505, 'within hours:'),
(9506, 'within minutes'),
(9507, 'within minutes:'),
(9508, 'Without Facility'),
(9509, 'Without Provider'),
(9510, 'Without Update'),
(9511, 'Witness'),
(9512, 'wk'),
(9513, 'WNL'),
(9514, 'Wolof'),
(9515, 'Women'),
(9516, 'Women Only'),
(9517, 'WordPress Portal'),
(9518, 'Work'),
(9519, 'WORK NOTE'),
(9520, 'Work Phone'),
(9521, 'Work Phone Number'),
(9522, 'Work related?'),
(9523, 'Work/ Education/ Hobbies'),
(9524, 'Work/School Note'),
(9525, 'workday'),
(9526, 'Worker`s Compensation'),
(9527, 'Workers Compensation Health Plan'),
(9528, 'Working Aged Beneficiary or Spouse with Employer Group Health Plan'),
(9529, 'Working!'),
(9530, 'Working... this may take a minute.'),
(9531, 'Worse'),
(9532, 'Would you like the balance amount to apply to Global Account?'),
(9533, 'Would You Like them to be Marked as Cleared.'),
(9534, 'Would you like to Allocate?'),
(9535, 'Would you like to Cancel Distribution for this Patient?'),
(9536, 'Would you like to Delete Payment Distribution?'),
(9537, 'Would you like to Delete Payments?'),
(9538, 'Would you like to Modify and Finish Payments?'),
(9539, 'Would you like to Modify Payments?'),
(9540, 'Would you like to Post and Finish Payments?'),
(9541, 'Would you like to Post Payments?'),
(9542, 'Would you like to save?'),
(9543, 'Wrist'),
(9544, 'Wrist and hand'),
(9545, 'Wrist Problems'),
(9546, 'write'),
(9547, 'write - can read and fully modify'),
(9548, 'write off'),
(9549, 'Write Once'),
(9550, 'wsome'),
(9551, 'wsome - can read and partially modify'),
(9552, 'WT'),
(9553, 'W{{Current Rx - wearing}}'),
(9554, 'W{{Wednesday}}'),
(9555, 'x Canceled'),
(9556, 'x Cancelled'),
(9557, 'X(T){{intermittent exophoria}}'),
(9558, 'X-ray'),
(9559, 'X-RAY Interpretation:'),
(9560, 'X-Ray Interpretation:'),
(9561, 'X12 only ICN resubmission No.'),
(9562, 'X12 only replacement claim:'),
(9563, 'X12 only: Replacement Claim '),
(9564, 'X12 OPTIONS'),
(9565, 'X12 Partner'),
(9566, 'X12 Partners'),
(9567, 'x12 Segments'),
(9568, 'x12 Text'),
(9569, 'Xhosa'),
(9570, 'XHR Failed:'),
(9571, 'XML'),
(9572, 'XT{{exotropia}}'),
(9573, 'X{{exophoria}}'),
(9574, 'Y'),
(9575, 'year'),
(9576, 'Year'),
(9577, 'Year View'),
(9578, 'Year(s)'),
(9579, 'Years'),
(9580, 'Years or months'),
(9581, 'Years, months and days'),
(9582, 'Yes'),
(9583, 'YES'),
(9584, 'yes'),
(9585, 'YES!'),
(9586, 'Yes, Delete and Log'),
(9587, 'Yes, Delete this form'),
(9588, 'Yes/No'),
(9589, 'Yes:'),
(9590, 'Yiddish'),
(9591, 'Yoruba'),
(9592, 'You are about to delete template'),
(9593, 'You are about to delete the following form from this encounter'),
(9594, 'You are about to permanently replace the existing template. Are you sure you wish to continue?'),
(9595, 'You are currently logged in as'),
(9596, 'You are in Grace Login period. Change your password before'),
(9597, 'You are not allowed to delete this event'),
(9598, 'You are not allowed to edit this event'),
(9599, 'You are not authorized for this.'),
(9600, 'You are not authorized to access this squad'),
(9601, 'You are not authorized to access this squad.'),
(9602, 'You are not authorized to add/edit issues'),
(9603, 'You are not authorized to schedule appointments.'),
(9604, 'You are not authorized to see this encounter.'),
(9605, 'You are not authorized!'),
(9606, 'You are posting against an old encounter?'),
(9607, 'You are sending to yourself!'),
(9608, 'You are using patient validation module'),
(9609, 'You can close the edit box by clicking on the \'slashed eye\' icon next to the group\'s name.'),
(9610, 'You can not access this function directly.'),
(9611, 'You can not change status to \'Arrive\' before the appointment\'s time'),
(9612, 'You cannot access this page directly.'),
(9613, 'You cannot add a blank value for a category!'),
(9614, 'You cannot add a blank value for a subcategory!'),
(9615, 'You cannot add a blank value for an item!'),
(9616, 'You cannot enter a future date with a completed value of YES.'),
(9617, 'You did not choose any actions.'),
(9618, 'You do not have access to view/edit this note'),
(9619, 'You have'),
(9620, 'You have an invoice due for payment in your Patient Documents. There you may pay, download or print the invoice. Thank you.'),
(9621, 'You have attempted to alter content which is locked. Remove the lock if you want to do this. To unlock, remove the line, \'/*lock::*/\''),
(9622, 'You have been successfully logged out.'),
(9623, 'You have chosen to be self insured or currently do not have insurance. Click next to continue registration.'),
(9624, 'You have not entered any clinical services or products. Click Cancel to add them. Or click OK if you want to save as-is.'),
(9625, 'You have to have an understanding how the program is structured and the ability and willingness to modify the underlying code.'),
(9626, 'You have unsaved changes.'),
(9627, 'You have unsaved changes. Abandon them?'),
(9628, 'You have unsaved changes. Do you really want to close this form?'),
(9629, 'You may only upload .txt files'),
(9630, 'You may optionally upload HL7 results from a file'),
(9631, 'You may put text here as the default complaint in the New Patient Encounter form.'),
(9632, 'You may want to try returning to the the previous page and verifying that all fields have been filled out correctly.'),
(9633, 'You must activate Weno first! Go to Administration, Globals, Connectors'),
(9634, 'You must agree to the HIPAA Business Associate Agreement'),
(9635, 'You must agree to the Terms & Conditions before signing up'),
(9636, 'You must enter a pass phrase to encrypt the document'),
(9637, 'You must enter your own password to change user passwords. Leave blank to keep password unchanged.'),
(9638, 'You must first select an item in the section whose radio button is checked.'),
(9639, 'You must first select or add a patient or therapy group.'),
(9640, 'You must first select or add a patient.'),
(9641, 'You must first select or create an encounter.'),
(9642, 'You must select a visit category'),
(9643, 'You must select a visit category.'),
(9644, 'You must select some fields to continue.'),
(9645, 'You should be running this test if this claim appeared to generate successfully but the actual claim file does not contain any data or only an unfinished portion of the amount of data it is supposed to contain. It is obvious with HCFA claims because they are human readable, with X12 claims it is a more difficult process to determine if the claim is properly complete.'),
(9646, 'You should select at least one context'),
(9647, 'You should select at least one Provider'),
(9648, 'You will be automatically redirected to Demographics. You may make the necessary corrections and navigate to NewCrop again.'),
(9649, 'Your Clinical Report'),
(9650, 'Your credentials are provided by your provider'),
(9651, 'your email address'),
(9652, 'Your end date is invalid'),
(9653, 'Your event has been deleted.'),
(9654, 'Your event has been modified.'),
(9655, 'Your event has been submitted.'),
(9656, 'Your file doesn\'t have an extension'),
(9657, 'Your file is too large'),
(9658, 'Your first day of the week.'),
(9659, 'Your installation of OpenEMR has been registered'),
(9660, 'Your Lab Results'),
(9661, 'Your list name has been changed to meet naming requirements.'),
(9662, 'Your message was submitted for delivery to'),
(9663, 'Your name for this category, procedure or result'),
(9664, 'Your new credentials have been sent. Check your email inbox and also possibly your spam folder. Once you log into your patient portal feel free to make an appointment or send us a secure message. We look forward to seeing you soon.'),
(9665, 'your next appointment at'),
(9666, 'Your on file email address'),
(9667, 'Your Password'),
(9668, 'Your Password Expired. Please change your password.'),
(9669, 'Your Password Expires on'),
(9670, 'Your Password Expires today. Please change your password.'),
(9671, 'Your password is your signature'),
(9672, 'Your PostCalendar configuration has been reset to use defaults.'),
(9673, 'Your PostCalendar configuration has been updated.'),
(9674, 'Your repeating frequency must be an integer.'),
(9675, 'Your repeating frequency must be at least 1.'),
(9676, 'Your safe key is'),
(9677, 'Your start date is greater than your end date'),
(9678, 'Your start date is invalid'),
(9679, 'Your submission failed.'),
(9680, 'Your weekend days'),
(9681, 'yyyy-mm-dd'),
(9682, 'YYYY-MM-DD'),
(9683, 'yyyy-mm-dd date associated with this document'),
(9684, 'yyyy-mm-dd date destroyed'),
(9685, 'yyyy-mm-dd date of birth'),
(9686, 'yyyy-mm-dd Date of Birth'),
(9687, 'yyyy-mm-dd date of expiration'),
(9688, 'yyyy-mm-dd Date of onset or hospitalization'),
(9689, 'yyyy-mm-dd date of onset, surgery or start of medication'),
(9690, 'yyyy-mm-dd date of purchase or transfer'),
(9691, 'yyyy-mm-dd date of recovery or end of medication'),
(9692, 'yyyy-mm-dd Date of return to play'),
(9693, 'yyyy-mm-dd Date of service'),
(9694, 'yyyy-mm-dd date of this letter'),
(9695, 'yyyy-mm-dd date returned to play'),
(9696, 'yyyy-mm-dd document date'),
(9697, 'yyyy-mm-dd End Date'),
(9698, 'yyyy-mm-dd event date or starting date'),
(9699, 'yyyy-mm-dd H:m End Date'),
(9700, 'yyyy-mm-dd H:m End date'),
(9701, 'yyyy-mm-dd H:m Start Date'),
(9702, 'yyyy-mm-dd H:m Start date'),
(9703, 'yyyy-mm-dd hh:mm:ss'),
(9704, 'yyyy-mm-dd Hours(24):minutes'),
(9705, 'yyyy-mm-dd last date of this event'),
(9706, 'yyyy-mm-dd Start Date'),
(9707, 'yyyy-mm-dd starting date for search'),
(9708, 'ZEF segment internal error'),
(9709, 'Zend Module'),
(9710, 'Zend Module check in addition to standard check'),
(9711, 'Zero'),
(9712, 'Zhuang, Chuang'),
(9713, 'Zip'),
(9714, 'Zip Code'),
(9715, 'Zip/Country:'),
(9716, 'Zoom'),
(9717, 'Zoom in'),
(9718, 'Zoom out'),
(9719, 'Zoom: click-drag, Pan: shift-click-drag, Restore: double-click'),
(9720, 'Zulu'),
(9721, ' but was '),
(9722, ' could not be accessed.'),
(9723, ' Do you really want to delete'),
(9724, ' Drug'),
(9725, ' emails not sent'),
(9726, ' from'),
(9727, ' has been created. '),
(9728, ' has been re-opened.'),
(9729, ' History'),
(9730, ' is not a number'),
(9731, ' is ready for re-billing.'),
(9732, ' LLL:'),
(9733, ' Lot'),
(9734, ' Medicaid Original Reference No. '),
(9735, ' min'),
(9736, ' not found!'),
(9737, ' Pecularities in many browsers may mean that the output below enters your screen in sudden jerks and that there are long pauses of several seconds where it  appears as though things may have crashed. That is not the case, you will eventually see output coming out line by line. There may be sequential numbers appearing  below, this is to indicate that even though nothing else may be displaying there is activity going on. These numbers will be interspersed with the content of the  billing and that is normal.'),
(9738, ' prescription has reached its limit of'),
(9739, ' until '),
(9740, ' update failed, not in database?'),
(9741, ' was marked as billed only.'),
(9742, ' was queued successfully.'),
(9743, '! Left w/o visit'),
(9744, '\" for code '),
(9745, '\" is CHECKED in PostCalendar Settings!'),
(9746, '# Ins/fin issue'),
(9747, '# of tablets:'),
(9748, '$'),
(9749, '$ Coding done'),
(9750, '$label (yyyy-mm-dd): '),
(9751, '%'),
(9752, '% Canceled < 24h'),
(9753, '% Cancelled <  24h '),
(9754, '\' should exist but does not.'),
(9755, '(% matches any string, _ matches any character)'),
(9756, '([ctrl] + click to select multiple recipients)'),
(9757, '(Back)'),
(9758, '(Click to edit)'),
(9759, '(Email delivery is immediate, while automated VOIP is sent to the service provider for further processing.)'),
(9760, '(More)'),
(9761, '(New Patient)'),
(9762, '(Notes and Authorizations)'),
(9763, '(Patient Notes)'),
(9764, '(Select one of these, or type your own title)'),
(9765, '(Shift-)Click or drag to change value'),
(9766, '* Reminder done'),
(9767, '** Please move surgeries to Issues!'),
(9768, '*Required'),
(9769, '+ Chart pulled'),
(9770, '+1'),
(9771, '+2'),
(9772, '+3'),
(9773, '- None'),
(9774, '- Not Reported'),
(9775, '-- All --'),
(9776, '--Select Role--'),
(9777, '.'),
(9778, '0'),
(9779, '0-10'),
(9780, '0-24'),
(9781, '02/12{{CMS 1500 format date revision setting in globals}}'),
(9782, '08/05{{CMS 1500 format date revision setting in globals}}'),
(9783, '1'),
(9784, '1 = North America. See http://www.wtng.info/ for a list of other country codes.'),
(9785, '1 Day From Now'),
(9786, '1 Month From Now'),
(9787, '1 Week From Now'),
(9788, '1 Year From Now'),
(9789, '1.Rest 2. Ice for two days 3. Compression, leave the dressing in place unless the foot develops numbness or pale color 4. Elevate the foot and leg'),
(9790, '11-14'),
(9791, '12 hr'),
(9792, '15-19'),
(9793, '1mm'),
(9794, '1st'),
(9795, '2'),
(9796, '2 Days From Now'),
(9797, '2 Months From Now'),
(9798, '2 Weeks From Now'),
(9799, '2 Years From Now'),
(9800, '2-20 years'),
(9801, '20-24'),
(9802, '2011 Automated Measure Calculations (AMC)'),
(9803, '2011 Clinical Quality Measures (CQM)'),
(9804, '2011 Official Clinical Quality Measures (CQM) Measure Groups'),
(9805, '2014 Automated Measure Calculations (AMC)'),
(9806, '2014 Automated Measure Calculations (AMC) - Stage I'),
(9807, '2014 Automated Measure Calculations (AMC) - Stage II'),
(9808, '2014 Clinical Quality Measures (CQM)'),
(9809, '2014 Official Clinical Quality Measures (CQM) Measure Groups'),
(9810, '2111-13'),
(9811, '24 hr'),
(9812, '25+'),
(9813, '25-29'),
(9814, '2mm'),
(9815, '2nd'),
(9816, '3 Days From Now'),
(9817, '3 months'),
(9818, '3 Months From Now'),
(9819, '3 times daily'),
(9820, '3 Weeks From Now'),
(9821, '30-34'),
(9822, '35-39'),
(9823, '3mm'),
(9824, '3rd'),
(9825, '4 Days From Now'),
(9826, '4 months'),
(9827, '4 Months From Now'),
(9828, '4 times daily'),
(9829, '4 Weeks From Now'),
(9830, '40-44'),
(9831, '45+'),
(9832, '465.9, URI'),
(9833, '466.0, Bronchitis, Acute NOS'),
(9834, '486.0, Pneumonia, Acute'),
(9835, '491.21, COPD Exacerbation'),
(9836, '491.8, Bronchitis, Chronic'),
(9837, '493.92, Asthma, Acute Exac.'),
(9838, '496.0, COPD'),
(9839, '4mm'),
(9840, '4th'),
(9841, '5 Days From Now'),
(9842, '5 Months From Now'),
(9843, '5 Weeks From Now'),
(9844, '519.7, Bronchospasm'),
(9845, '5mm'),
(9846, '5th'),
(9847, '6 Days From Now'),
(9848, '6 months'),
(9849, '6 Months From Now'),
(9850, '6 Weeks From Now'),
(9851, '6th'),
(9852, '7 Months From Now'),
(9853, '8 Months From Now'),
(9854, '8-12 characters long, including at least one upper case letter, one lower case letter, one number, one special character and no common strings'),
(9855, '824.0 Fracture, medial malleolus, closed'),
(9856, '824.2 Fracture, lateral malleolus, closed'),
(9857, '824.6 Fracture, Trimalleolar, closed'),
(9858, '825.32 Fracture, of Navicular (ankle)'),
(9859, '825.35 Fracture, Base of fifth (5th) Metatarsal'),
(9860, '845.00 ankle sprain NOS'),
(9861, '845.01 Sprain Medial (Deltoid) Lig.'),
(9862, '845.02 Sprain, Calcaneal fibular'),
(9863, '9 Months From Now'),
(9864, '99212 Established - Uncomplicated'),
(9865, '99213 Established - Low Complexity'),
(9866, '< In exam room'),
(9867, '< Not Reported'),
(9868, '= Took Place'),
(9869, '> 3 HPI elements'),
(9870, '> Checked out'),
(9871, '> Did Not Take Place'),
(9872, '?'),
(9873, '? Did Not Attend'),
(9874, '? No show'),
(9875, '@ Arrived'),
(9876, '@ Attended'),
(9877, '[Change View]'),
(9878, '[Date of Last Encounter]'),
(9879, '[Days Since Last Encounter]'),
(9880, '[EOBs]'),
(9881, '[Export OFX]'),
(9882, '[not recommended]'),
(9883, '[Number Of Encounters]'),
(9884, '[Reports]'),
(9885, '[Select All]'),
(9886, '[SQL-Ledger]'),
(9887, '[Start Batch Processing]'),
(9888, '[View Log]'),
(9889, '[View Printable Report]'),
(9890, '^ Pending'),
(9891, '_PC_DUR_HOURS'),
(9892, '_PC_DUR_MINUTES'),
(9893, '_PC_LOCALE'),
(9894, '~ Arrived late'),
(9895, '~ Late Arrival');

--


-- 
-- Table structure for table `lang_definitions`
-- 


DROP TABLE IF EXISTS `lang_definitions`;
CREATE TABLE `lang_definitions` (
  `def_id` int(11) NOT NULL auto_increment,
  `cons_id` int(11) NOT NULL default '0',
  `lang_id` int(11) NOT NULL default '0',
  `definition` mediumtext,
  UNIQUE KEY `def_id` (`def_id`),
  KEY `cons_id` (`cons_id`) 
) ENGINE=InnoDB AUTO_INCREMENT=181486 ;


-- 
-- Dumping data for table `lang_definitions`
--

INSERT INTO `lang_definitions` VALUES (1, 1, 2, 'En');
INSERT INTO `lang_definitions` VALUES (2, 2, 2, 'Ett betalningsnr för att identifiera betalningen');
INSERT INTO `lang_definitions` VALUES (3, 4, 2, 'Klientcertifikat för admin användaren');
INSERT INTO `lang_definitions` VALUES (4, 6, 2, 'Ett klinikdokument är bifogat');
INSERT INTO `lang_definitions` VALUES (5, 8, 2, 'En distributör behövs');
INSERT INTO `lang_definitions` VALUES (6, 9, 2, 'Ett GCAC besöksformulär ska läggas till för detta besök');
INSERT INTO `lang_definitions` VALUES (7, 11, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (8, 12, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (9, 13, 2, 'En liten bokstav');
INSERT INTO `lang_definitions` VALUES (10, 14, 2, 'Ett tal');
INSERT INTO `lang_definitions` VALUES (11, 16, 2, 'En patient med detta ID finns redan');
INSERT INTO `lang_definitions` VALUES (12, 17, 2, 'En patient med detta namn finns redan');
INSERT INTO `lang_definitions` VALUES (13, 18, 2, 'En patient med detta personnummer ( SS ) finns redan');
INSERT INTO `lang_definitions` VALUES (14, 21, 2, 'Ett positivt nummer kommer visa antalet tidigare bokningar i en ruta på patientöversikten.');
INSERT INTO `lang_definitions` VALUES (15, 23, 2, 'Den remitterande instansen kan framgå vid varje besök');
INSERT INTO `lang_definitions` VALUES (16, 24, 2, 'En relaterad IPPF kod krävs!');
INSERT INTO `lang_definitions` VALUES (17, 26, 2, 'Ett specialtecken');
INSERT INTO `lang_definitions` VALUES (18, 27, 2, 'Ett unikt värde, som ej är synlig för användaren, identifierar detta fält.');
INSERT INTO `lang_definitions` VALUES (19, 30, 2, 'Före måltid');
INSERT INTO `lang_definitions` VALUES (20, 31, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (21, 34, 2, 'AB');
INSERT INTO `lang_definitions` VALUES (22, 35, 2, 'Förkortning');
INSERT INTO `lang_definitions` VALUES (23, 36, 2, 'Abscess');
INSERT INTO `lang_definitions` VALUES (24, 37, 2, 'Abdominell');
INSERT INTO `lang_definitions` VALUES (25, 38, 2, 'kan bära vikt fyra (4) steg:');
INSERT INTO `lang_definitions` VALUES (26, 39, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (27, 40, 2, 'ABN1');
INSERT INTO `lang_definitions` VALUES (28, 41, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (29, 42, 2, 'Patologiskt blodprov');
INSERT INTO `lang_definitions` VALUES (30, 43, 2, 'Avvikande hårväxt');
INSERT INTO `lang_definitions` VALUES (31, 44, 2, 'Patologisk mammografi');
INSERT INTO `lang_definitions` VALUES (32, 46, 2, 'Abort');
INSERT INTO `lang_definitions` VALUES (33, 47, 2, 'Abortrelaterad problematik');
INSERT INTO `lang_definitions` VALUES (34, 48, 2, 'Abortmetod');
INSERT INTO `lang_definitions` VALUES (35, 49, 2, 'Abortrelaterade kategorier');
INSERT INTO `lang_definitions` VALUES (36, 50, 2, 'Aborter');
INSERT INTO `lang_definitions` VALUES (37, 53, 2, 'Om kalendern');
INSERT INTO `lang_definitions` VALUES (38, 56, 2, 'Frånvaro av Diagnos');
INSERT INTO `lang_definitions` VALUES (39, 58, 2, 'Acceptera uppdrag');
INSERT INTO `lang_definitions` VALUES (40, 59, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (41, 60, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (42, 61, 2, 'Accepterar uppdrag');
INSERT INTO `lang_definitions` VALUES (43, 62, 2, 'Åtkomstkontroll');
INSERT INTO `lang_definitions` VALUES (44, 63, 2, 'Hantera åtkomst');
INSERT INTO `lang_definitions` VALUES (45, 70, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (46, 71, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (47, 73, 2, 'Öppna patientöversikten');
INSERT INTO `lang_definitions` VALUES (48, 80, 2, 'Konto namn');
INSERT INTO `lang_definitions` VALUES (49, 83, 2, 'Redovisning');
INSERT INTO `lang_definitions` VALUES (50, 88, 2, 'värker');
INSERT INTO `lang_definitions` VALUES (51, 90, 2, 'Begärt godokännande (ISA14)');
INSERT INTO `lang_definitions` VALUES (52, 91, 2, 'Godkännande, licenser och certifikat');
INSERT INTO `lang_definitions` VALUES (53, 92, 2, 'Användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (54, 93, 2, 'Administration av användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (55, 95, 2, 'Ej behörig administrera användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (56, 98, 2, 'Akne');
INSERT INTO `lang_definitions` VALUES (57, 101, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (58, 102, 2, 'Aktivitetsdatum');
INSERT INTO `lang_definitions` VALUES (59, 103, 2, 'Åtgärd');
INSERT INTO `lang_definitions` VALUES (60, 107, 2, 'Åtgärder');
INSERT INTO `lang_definitions` VALUES (61, 109, 2, 'Rapportera fortsatt vårdbegäran (CCR/CCD)');
INSERT INTO `lang_definitions` VALUES (62, 113, 2, 'Aktiva');
INSERT INTO `lang_definitions` VALUES (63, 114, 2, 'Aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (64, 115, 2, 'Regler för aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (65, 116, 2, 'Aktiva påminnelser');
INSERT INTO `lang_definitions` VALUES (66, 121, 2, 'Aktivt besök');
INSERT INTO `lang_definitions` VALUES (67, 122, 2, 'Códigos de questões ativas');
INSERT INTO `lang_definitions` VALUES (68, 123, 2, 'Aktiva listor');
INSERT INTO `lang_definitions` VALUES (69, 125, 2, 'Aktiv patient');
INSERT INTO `lang_definitions` VALUES (70, 126, 2, 'Aktuella planeringar');
INSERT INTO `lang_definitions` VALUES (71, 128, 2, 'Aktiviteter');
INSERT INTO `lang_definitions` VALUES (72, 129, 2, 'Aktivitetstyp');
INSERT INTO `lang_definitions` VALUES (73, 140, 2, 'Akut förgiftning / Utsättning');
INSERT INTO `lang_definitions` VALUES (74, 142, 2, 'Akut försämring av kronisk');
INSERT INTO `lang_definitions` VALUES (75, 144, 2, 'lägg till');
INSERT INTO `lang_definitions` VALUES (76, 145, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (77, 146, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (78, 147, 2, 'Lägg till ett företag');
INSERT INTO `lang_definitions` VALUES (79, 150, 2, 'Lägg till ett apotek');
INSERT INTO `lang_definitions` VALUES (80, 152, 2, 'lägg till ett händelse för');
INSERT INTO `lang_definitions` VALUES (81, 153, 2, 'Lägg till som en ny anteckning');
INSERT INTO `lang_definitions` VALUES (82, 154, 2, 'Lägg till som ny');
INSERT INTO `lang_definitions` VALUES (83, 157, 2, 'Lägg till knappar');
INSERT INTO `lang_definitions` VALUES (84, 158, 2, 'Lägg till knappar för specialtecken och texter att visa längst upp i editorn för inkludering i texten med ett klick');
INSERT INTO `lang_definitions` VALUES (85, 159, 2, 'Lägg till en ny Kategori');
INSERT INTO `lang_definitions` VALUES (86, 160, 2, 'Lägg till en ny Konstant');
INSERT INTO `lang_definitions` VALUES (87, 161, 2, 'Lägg till ett sammanhang');
INSERT INTO `lang_definitions` VALUES (88, 162, 2, 'Lägg till en delbetalning');
INSERT INTO `lang_definitions` VALUES (89, 163, 2, 'Lägg till ett nytt kriterium');
INSERT INTO `lang_definitions` VALUES (90, 164, 2, 'Lägg till anpassad knapp');
INSERT INTO `lang_definitions` VALUES (91, 167, 2, 'Lägg till en ny diagnos');
INSERT INTO `lang_definitions` VALUES (92, 168, 2, 'Lägg till ett nytt Läkemedel');
INSERT INTO `lang_definitions` VALUES (93, 170, 2, 'Lägg till ett nytt besök');
INSERT INTO `lang_definitions` VALUES (94, 171, 2, 'Lägg till ett nytt besök/anteckning');
INSERT INTO `lang_definitions` VALUES (95, 172, 2, 'Lägg till en ny klinik');
INSERT INTO `lang_definitions` VALUES (96, 173, 2, 'Lägg till ett nytt fält');
INSERT INTO `lang_definitions` VALUES (97, 174, 2, 'Lägg till följande meningar till Apache konfigurationsfilen');
INSERT INTO `lang_definitions` VALUES (98, 175, 2, 'Lägg till en ny Grupp');
INSERT INTO `lang_definitions` VALUES (99, 177, 2, 'Lägg till en ny diagnos-kod (ICD)');
INSERT INTO `lang_definitions` VALUES (100, 178, 2, 'Lägg till en ny vaccination');
INSERT INTO `lang_definitions` VALUES (101, 179, 2, 'Inte tillåtet att lägga till!');
INSERT INTO `lang_definitions` VALUES (102, 180, 2, 'Lägg till händelse');
INSERT INTO `lang_definitions` VALUES (103, 182, 2, 'Lägg till ett nytt Språk');
INSERT INTO `lang_definitions` VALUES (104, 186, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (105, 187, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (106, 188, 2, 'Lägg till en ny kategori:');
INSERT INTO `lang_definitions` VALUES (107, 189, 2, 'Lägg till ett nytt certifikat till Apache konfigurationsfil');
INSERT INTO `lang_definitions` VALUES (108, 193, 2, 'Lägg till en ny grupp');
INSERT INTO `lang_definitions` VALUES (109, 196, 2, 'Lägg till en ny lot och överföring');
INSERT INTO `lang_definitions` VALUES (110, 197, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (111, 198, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (112, 199, 2, 'Lägg till en ny partner');
INSERT INTO `lang_definitions` VALUES (113, 202, 2, 'Lägg till en ny anteckning');
INSERT INTO `lang_definitions` VALUES (114, 206, 2, 'Lägg till en ny patient');
INSERT INTO `lang_definitions` VALUES (115, 207, 2, 'Lägg till ett nytt recept');
INSERT INTO `lang_definitions` VALUES (116, 208, 2, 'Lägg till åtgärd');
INSERT INTO `lang_definitions` VALUES (117, 209, 2, 'Lägg till Vårdgivares nummer');
INSERT INTO `lang_definitions` VALUES (118, 211, 2, 'Lägg till rehab');
INSERT INTO `lang_definitions` VALUES (119, 212, 2, 'Lägg till en ny regel');
INSERT INTO `lang_definitions` VALUES (120, 214, 2, 'Tillägg till');
INSERT INTO `lang_definitions` VALUES (121, 215, 2, 'Lägg till i medicinlista');
INSERT INTO `lang_definitions` VALUES (122, 216, 2, 'Tillägg av högsta nivå');
INSERT INTO `lang_definitions` VALUES (123, 217, 2, 'Lägg till en ny överföring');
INSERT INTO `lang_definitions` VALUES (124, 218, 2, 'Lägg till en ny användare');
INSERT INTO `lang_definitions` VALUES (125, 219, 2, 'Lägg till användaren i gruppen');
INSERT INTO `lang_definitions` VALUES (126, 221, 2, 'Lägg till/ändra elektroniskt recept');
INSERT INTO `lang_definitions` VALUES (127, 222, 2, 'Lägg till/ändra patientens överföringar');
INSERT INTO `lang_definitions` VALUES (128, 223, 2, 'tillagd');
INSERT INTO `lang_definitions` VALUES (129, 226, 2, 'Ej tillåtet att lägga till personuppgifter.');
INSERT INTO `lang_definitions` VALUES (130, 228, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (131, 229, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (132, 230, 2, 'Flera attribut');
INSERT INTO `lang_definitions` VALUES (133, 233, 2, 'Ytterligare Diagnos:');
INSERT INTO `lang_definitions` VALUES (134, 235, 2, 'Kompletterande anamnes');
INSERT INTO `lang_definitions` VALUES (135, 236, 2, 'Kompletterande anamnesuppgifter');
INSERT INTO `lang_definitions` VALUES (136, 237, 2, 'Kompletterande Information');
INSERT INTO `lang_definitions` VALUES (137, 238, 2, 'Kompletterande Lab. svar');
INSERT INTO `lang_definitions` VALUES (138, 239, 2, 'Kompletterande noteringar');
INSERT INTO `lang_definitions` VALUES (139, 240, 2, 'Ytterligare noteringar för detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (140, 241, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (141, 242, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (142, 243, 2, 'Ytterligare röntgenanteckningar:');
INSERT INTO `lang_definitions` VALUES (143, 244, 2, 'Som tillägg, motsvarande US Snomed Extension Package can importeras separat efter instalation av den internationella (engelska) Snomed utgåvan');
INSERT INTO `lang_definitions` VALUES (144, 246, 2, 'Lägg endast till');
INSERT INTO `lang_definitions` VALUES (145, 248, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (146, 249, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (147, 250, 2, 'Adress');
INSERT INTO `lang_definitions` VALUES (148, 253, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (149, 254, 2, 'Tillgång till adressboken för företaget som utför denna åtgärd');
INSERT INTO `lang_definitions` VALUES (150, 255, 2, 'Tillgång till adressboken för distributören');
INSERT INTO `lang_definitions` VALUES (151, 256, 2, 'Tillgång till adressboken för försäljare');
INSERT INTO `lang_definitions` VALUES (152, 257, 2, 'Typer av adressböcker');
INSERT INTO `lang_definitions` VALUES (153, 263, 2, 'Adress1');
INSERT INTO `lang_definitions` VALUES (154, 264, 2, 'Adress2');
INSERT INTO `lang_definitions` VALUES (155, 266, 2, 'ADRESSATEN');
INSERT INTO `lang_definitions` VALUES (156, 269, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (157, 270, 2, 'Korrigera mängd');
INSERT INTO `lang_definitions` VALUES (158, 271, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (159, 272, 2, 'Korrigering');
INSERT INTO `lang_definitions` VALUES (160, 273, 2, 'Justera mängd');
INSERT INTO `lang_definitions` VALUES (161, 274, 2, 'Orsak till justering');
INSERT INTO `lang_definitions` VALUES (162, 275, 2, 'Justering av värde för kod');
INSERT INTO `lang_definitions` VALUES (163, 276, 2, 'Justeringar');
INSERT INTO `lang_definitions` VALUES (164, 277, 2, 'Administrera justeringar');
INSERT INTO `lang_definitions` VALUES (165, 278, 2, 'Administrera');
INSERT INTO `lang_definitions` VALUES (166, 279, 2, 'Admin E-postadress');
INSERT INTO `lang_definitions` VALUES (167, 280, 2, 'Administrera via');
INSERT INTO `lang_definitions` VALUES (168, 281, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (169, 282, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (170, 284, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (171, 285, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (172, 287, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (173, 288, 2, 'Administratörer');
INSERT INTO `lang_definitions` VALUES (174, 289, 2, 'Administratörer kan göra allt');
INSERT INTO `lang_definitions` VALUES (175, 290, 2, 'Godkänn datum');
INSERT INTO `lang_definitions` VALUES (176, 293, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (177, 294, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (178, 295, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (179, 296, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (180, 297, 2, 'Varning i avancerade råd');
INSERT INTO `lang_definitions` VALUES (181, 299, 2, 'Avancerad');
INSERT INTO `lang_definitions` VALUES (182, 301, 2, 'Råd');
INSERT INTO `lang_definitions` VALUES (183, 303, 2, 'Neutral grundstämning');
INSERT INTO `lang_definitions` VALUES (184, 307, 2, 'Joursamtal');
INSERT INTO `lang_definitions` VALUES (185, 308, 2, 'Efter flytt från det gamla lösenordshanteringen där lösenord sparadesokrypterat i användartabellenska denna flagga markeras så att enbart inloggning med den nya metoden kan användas');
INSERT INTO `lang_definitions` VALUES (186, 309, 2, 'Efter genomförandet av ovannämnda konfigurationer, importera admin. klientens certifikat till webläsaren och starta om Apache server ( tömma lösenord )');
INSERT INTO `lang_definitions` VALUES (187, 310, 2, 'Efter att PDF sparats, klicka på [View Log] för att söka efter fel.');
INSERT INTO `lang_definitions` VALUES (188, 311, 2, 'Efter sparandet av TEXT filer , klicka på [View Log] för att leta efter fel');
INSERT INTO `lang_definitions` VALUES (189, 312, 2, 'Efter sparandet av ditt parti, klicka på [View Log] för att granska för fel.');
INSERT INTO `lang_definitions` VALUES (190, 314, 2, 'När informationen är korrekt införd, klicka på Spara knappen.');
INSERT INTO `lang_definitions` VALUES (191, 317, 2, 'Planering av eftervård');
INSERT INTO `lang_definitions` VALUES (192, 318, 2, 'Igen');
INSERT INTO `lang_definitions` VALUES (193, 319, 2, 'Ålder');
INSERT INTO `lang_definitions` VALUES (194, 320, 2, 'Ålder av');
INSERT INTO `lang_definitions` VALUES (195, 321, 2, 'Ålderskategori');
INSERT INTO `lang_definitions` VALUES (196, 322, 2, 'Denna Åder är utanför befintlig intervall');
INSERT INTO `lang_definitions` VALUES (197, 323, 2, 'Format för att visa ålder');
INSERT INTO `lang_definitions` VALUES (198, 324, 2, 'Detta format för \"ålder från\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (199, 325, 2, 'Detta format för \"ålder upp till\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (200, 326, 2, 'Ålder från');
INSERT INTO `lang_definitions` VALUES (201, 327, 2, 'Ändra format för att visa ålder i år');
INSERT INTO `lang_definitions` VALUES (202, 328, 2, 'Högsta ålder');
INSERT INTO `lang_definitions` VALUES (203, 329, 2, 'Lägsta ålder');
INSERT INTO `lang_definitions` VALUES (204, 330, 2, 'Åldersintervall');
INSERT INTO `lang_definitions` VALUES (205, 332, 2, 'Kolumner med åldern');
INSERT INTO `lang_definitions` VALUES (206, 334, 2, 'Albansk');
INSERT INTO `lang_definitions` VALUES (207, 335, 2, 'Alkohol');
INSERT INTO `lang_definitions` VALUES (208, 336, 2, 'Alkoholkonsumtion');
INSERT INTO `lang_definitions` VALUES (209, 339, 2, 'Antal varningar');
INSERT INTO `lang_definitions` VALUES (210, 344, 2, 'Varningar');
INSERT INTO `lang_definitions` VALUES (211, 348, 2, 'Aleut-befolkning');
INSERT INTO `lang_definitions` VALUES (212, 349, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (213, 350, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (214, 352, 2, 'Alla (format A)');
INSERT INTO `lang_definitions` VALUES (215, 353, 2, 'Alla (format B)');
INSERT INTO `lang_definitions` VALUES (216, 354, 2, 'Allt ( Kumulativt )');
INSERT INTO `lang_definitions` VALUES (217, 357, 2, 'Alla Kategorier');
INSERT INTO `lang_definitions` VALUES (218, 359, 2, 'Alla koder');
INSERT INTO `lang_definitions` VALUES (219, 361, 2, 'Hela dagen');
INSERT INTO `lang_definitions` VALUES (220, 362, 2, 'Heldagshändelse');
INSERT INTO `lang_definitions` VALUES (221, 363, 2, 'Alla demografiska fält , med sökning och dubbel kontroll');
INSERT INTO `lang_definitions` VALUES (222, 365, 2, 'Alla kliniker');
INSERT INTO `lang_definitions` VALUES (223, 366, 2, 'Alla skador/problem/frågeställningar');
INSERT INTO `lang_definitions` VALUES (224, 367, 2, 'All språk är tillåtna');
INSERT INTO `lang_definitions` VALUES (225, 370, 2, 'Hela förnamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (226, 371, 2, 'Hela efternamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (227, 372, 2, 'Hela organisationen eller delar av namnet');
INSERT INTO `lang_definitions` VALUES (228, 374, 2, 'Alla produkter');
INSERT INTO `lang_definitions` VALUES (229, 375, 2, 'Alla vårdgivare');
INSERT INTO `lang_definitions` VALUES (230, 376, 2, 'Alla granskade och Negativa:');
INSERT INTO `lang_definitions` VALUES (231, 378, 2, 'Alla ämnen');
INSERT INTO `lang_definitions` VALUES (232, 379, 2, 'Alla användare');
INSERT INTO `lang_definitions` VALUES (233, 380, 2, 'Allergisk');
INSERT INTO `lang_definitions` VALUES (234, 382, 2, 'Allergier');
INSERT INTO `lang_definitions` VALUES (235, 383, 2, 'Allergier:');
INSERT INTO `lang_definitions` VALUES (236, 384, 2, 'Allergi');
INSERT INTO `lang_definitions` VALUES (237, 385, 2, 'Import av allergier klart');
INSERT INTO `lang_definitions` VALUES (238, 386, 2, 'Lista på allergier');
INSERT INTO `lang_definitions` VALUES (239, 387, 2, 'Allergisk reaktion');
INSERT INTO `lang_definitions` VALUES (240, 390, 2, 'Tilldela');
INSERT INTO `lang_definitions` VALUES (241, 391, 2, 'Tillåta');
INSERT INTO `lang_definitions` VALUES (242, 393, 2, 'Tillåt alla tillgängliga språk som val i menyn vid inloggning');
INSERT INTO `lang_definitions` VALUES (243, 395, 2, 'Tillåt att skapa krav innehållande diagnoser , men ej procedurer eller betalningar. De flesta kliniker vill inte ha det');
INSERT INTO `lang_definitions` VALUES (244, 396, 2, 'Tillåt debugg språk');
INSERT INTO `lang_definitions` VALUES (245, 398, 2, 'E-post tillåten');
INSERT INTO `lang_definitions` VALUES (246, 399, 2, 'Är e-post meddelande tillåtet ?');
INSERT INTO `lang_definitions` VALUES (247, 400, 2, 'Tillåt e-post?');
INSERT INTO `lang_definitions` VALUES (248, 401, 2, 'Tillåt krav i patient möte');
INSERT INTO `lang_definitions` VALUES (249, 403, 2, 'Tillåt utbyte av hälsoinformationen');
INSERT INTO `lang_definitions` VALUES (250, 405, 2, 'Tillåt att informationen om vaccinationer delas');
INSERT INTO `lang_definitions` VALUES (251, 406, 2, 'Tillåt användning av vaccinationsregistret');
INSERT INTO `lang_definitions` VALUES (252, 408, 2, 'Tillåt e-post meddelanden');
INSERT INTO `lang_definitions` VALUES (253, 412, 2, 'Tillåt patient-inloggning');
INSERT INTO `lang_definitions` VALUES (254, 414, 2, 'Tillåt SMS');
INSERT INTO `lang_definitions` VALUES (255, 415, 2, 'Är SMS meddelanden tillåtna ?');
INSERT INTO `lang_definitions` VALUES (256, 417, 2, 'Tillåt aktuella händelser att vara aktiva omedelbart ?');
INSERT INTO `lang_definitions` VALUES (257, 418, 2, 'Tillåt telefon meddelanden?');
INSERT INTO `lang_definitions` VALUES (258, 420, 2, 'Tillåt användare att publicera Globala Händelser');
INSERT INTO `lang_definitions` VALUES (259, 421, 2, 'Tillåt användare att publicera personliga kalendrar');
INSERT INTO `lang_definitions` VALUES (260, 427, 2, 'Tillåt telefonsvarare');
INSERT INTO `lang_definitions` VALUES (261, 428, 2, 'Tillåten');
INSERT INTO `lang_definitions` VALUES (262, 429, 2, 'Godkända språk');
INSERT INTO `lang_definitions` VALUES (263, 431, 2, 'Godkänt');
INSERT INTO `lang_definitions` VALUES (264, 436, 2, 'finns redan');
INSERT INTO `lang_definitions` VALUES (265, 437, 2, 'Finns redan');
INSERT INTO `lang_definitions` VALUES (266, 439, 2, 'Används redan, välj en annan identitetsbeteckning');
INSERT INTO `lang_definitions` VALUES (267, 440, 2, 'Används redan, välj en annan titel');
INSERT INTO `lang_definitions` VALUES (268, 441, 2, 'Alternativ Adress');
INSERT INTO `lang_definitions` VALUES (269, 442, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (270, 444, 2, 'Alternativt kan du använda sökfunktionen för att lägga upp ett elektroniskt godkännande (X12 83l fil) som du fått från din betalare eller clearingorganisationer. Du kan göra detta genom att klicka på knappen Bläddra och välj den fil som ska laddas upp och sedan klicka på Sök för att ladda upp och visa motsvarande fakturor. I detta fall gäller inte de andra parametrar som nämns ovan och de kommer att ignoreras. Överföring sparar filen men processar ännuinte innehållet - detta är gjort separat enligt nedan.');
INSERT INTO `lang_definitions` VALUES (271, 445, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (272, 446, 2, 'Förmiddagens program');
INSERT INTO `lang_definitions` VALUES (273, 451, 2, 'Automatisk beräkning av åtgärder (AMC)');
INSERT INTO `lang_definitions` VALUES (274, 452, 2, 'Spåra AMC');
INSERT INTO `lang_definitions` VALUES (275, 458, 2, 'Ändra Befintlig notering');
INSERT INTO `lang_definitions` VALUES (276, 465, 2, 'Amerikansk indian');
INSERT INTO `lang_definitions` VALUES (277, 466, 2, 'Amerikans indian eller född i alaska');
INSERT INTO `lang_definitions` VALUES (278, 467, 2, 'AMEX');
INSERT INTO `lang_definitions` VALUES (279, 468, 2, 'Etiopier');
INSERT INTO `lang_definitions` VALUES (280, 469, 2, 'Belopp');
INSERT INTO `lang_definitions` VALUES (281, 470, 2, 'Administrerat belopp');
INSERT INTO `lang_definitions` VALUES (282, 471, 2, 'Begärt belopp');
INSERT INTO `lang_definitions` VALUES (283, 474, 2, 'Belopp från tidigare Saldo');
INSERT INTO `lang_definitions` VALUES (284, 475, 2, 'Belopp för besöket');
INSERT INTO `lang_definitions` VALUES (285, 476, 2, 'Belopp som betalts');
INSERT INTO `lang_definitions` VALUES (286, 477, 2, 'Belopp:');
INSERT INTO `lang_definitions` VALUES (287, 480, 2, 'fakturerat belopp');
INSERT INTO `lang_definitions` VALUES (288, 482, 2, 'Ett slutdatum senare än startdatum krävs för upprepade händelser!');
INSERT INTO `lang_definitions` VALUES (289, 484, 2, 'ett fel uppstod när OpenEMR sparades');
INSERT INTO `lang_definitions` VALUES (290, 485, 2, 'Ett fel uppstod när phpGACL sparades');
INSERT INTO `lang_definitions` VALUES (291, 486, 2, 'Ett fel uppstod när SQL-ledger sparades');
INSERT INTO `lang_definitions` VALUES (292, 488, 2, 'En ofullständig GCAC fråga har inrättats och knutits. Någon kommer att behöva fylla i det senare.');
INSERT INTO `lang_definitions` VALUES (293, 490, 2, 'Ett oförutsett fel uppkom');
INSERT INTO `lang_definitions` VALUES (294, 491, 2, 'En stor bokstav');
INSERT INTO `lang_definitions` VALUES (295, 493, 2, 'och');
INSERT INTO `lang_definitions` VALUES (296, 494, 2, 'OCH');
INSERT INTO `lang_definitions` VALUES (297, 495, 2, 'Och');
INSERT INTO `lang_definitions` VALUES (298, 496, 2, 'och');
INSERT INTO `lang_definitions` VALUES (299, 497, 2, 'och alla underordnade data? Denna åtgärd kommer att loggas');
INSERT INTO `lang_definitions` VALUES (300, 498, 2, 'och modifierare');
INSERT INTO `lang_definitions` VALUES (301, 499, 2, 'och hanterad.');
INSERT INTO `lang_definitions` VALUES (302, 500, 2, 'och starta om Apache servern.');
INSERT INTO `lang_definitions` VALUES (303, 501, 2, 'och orsaken är');
INSERT INTO `lang_definitions` VALUES (304, 502, 2, 'Anemi');
INSERT INTO `lang_definitions` VALUES (305, 503, 2, 'Ankel');
INSERT INTO `lang_definitions` VALUES (306, 504, 2, 'Ankel + häl');
INSERT INTO `lang_definitions` VALUES (307, 505, 2, 'Ankel Utvärderingsformulär');
INSERT INTO `lang_definitions` VALUES (308, 506, 2, 'Ankel problem');
INSERT INTO `lang_definitions` VALUES (309, 507, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (310, 508, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (311, 509, 2, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (312, 510, 2, 'En annan sak du kan göra i utstationering fönstret är att begära en sekundära fakturering. Om du markerar rutan innan du sparar, så kommer den ursprungliga fordran att öppnas igen och köas på faktureringssidan och sedan behandlas under nästa faktureringskörning.');
INSERT INTO `lang_definitions` VALUES (313, 512, 2, 'framåt');
INSERT INTO `lang_definitions` VALUES (314, 517, 2, 'Anus, ingen rektal ömhet');
INSERT INTO `lang_definitions` VALUES (315, 518, 2, 'Ångest');
INSERT INTO `lang_definitions` VALUES (316, 519, 2, 'Valfri');
INSERT INTO `lang_definitions` VALUES (317, 522, 2, 'någon Kategori');
INSERT INTO `lang_definitions` VALUES (318, 525, 2, 'Någon del av en kod eller dess beskrivning');
INSERT INTO `lang_definitions` VALUES (319, 526, 2, 'Någon del av önskad specialitet');
INSERT INTO `lang_definitions` VALUES (320, 527, 2, 'någon del av medicinens namn eller id');
INSERT INTO `lang_definitions` VALUES (321, 528, 2, 'Någon del av vaccinations namn eller id');
INSERT INTO `lang_definitions` VALUES (322, 529, 2, 'Någon del av patientens namn, eller \"efternamn, förnamn \" eller \"X-Y \"');
INSERT INTO `lang_definitions` VALUES (323, 530, 2, 'Någon annan relevant information');
INSERT INTO `lang_definitions` VALUES (324, 533, 2, 'API nyckel till SMS portal');
INSERT INTO `lang_definitions` VALUES (325, 534, 2, 'Andningsuppehåll');
INSERT INTO `lang_definitions` VALUES (326, 536, 2, 'Utseende');
INSERT INTO `lang_definitions` VALUES (327, 537, 2, 'Utseende:');
INSERT INTO `lang_definitions` VALUES (328, 538, 2, 'Lägg till denna notering');
INSERT INTO `lang_definitions` VALUES (329, 539, 2, 'Lägg till den nuvarande noteringen');
INSERT INTO `lang_definitions` VALUES (330, 540, 2, 'Lägg till denna anmärkning');
INSERT INTO `lang_definitions` VALUES (331, 541, 2, 'Bifoga till denna notering');
INSERT INTO `lang_definitions` VALUES (332, 542, 2, 'Appendektomi');
INSERT INTO `lang_definitions` VALUES (333, 544, 2, 'Tällämpliga patienter');
INSERT INTO `lang_definitions` VALUES (334, 545, 2, 'Ansökan');
INSERT INTO `lang_definitions` VALUES (335, 546, 2, 'Namn på program vid inloggning och titel på sidan');
INSERT INTO `lang_definitions` VALUES (336, 547, 2, 'Mottagarkod (GS03. Om blank kommer ISA08 användas)');
INSERT INTO `lang_definitions` VALUES (337, 548, 2, 'Sändarkod (GS02)');
INSERT INTO `lang_definitions` VALUES (338, 549, 2, 'Programmets titel');
INSERT INTO `lang_definitions` VALUES (339, 550, 2, 'Gäller Formulär för vitalparametrar och tillväxtkurva');
INSERT INTO `lang_definitions` VALUES (340, 551, 2, 'Gäller formulär för vitalparametrar');
INSERT INTO `lang_definitions` VALUES (341, 552, 2, 'Tillämpa ändringen på nuvarande händelse, nuvarande och alla kommande händelser eller alla händelser?');
INSERT INTO `lang_definitions` VALUES (342, 553, 2, 'tillämpas på berörda området');
INSERT INTO `lang_definitions` VALUES (343, 554, 2, 'appliceras på huden');
INSERT INTO `lang_definitions` VALUES (344, 555, 2, 'Lägger till');
INSERT INTO `lang_definitions` VALUES (345, 556, 2, 'Lägger till patch till sidan');
INSERT INTO `lang_definitions` VALUES (346, 557, 2, 'Bokning');
INSERT INTO `lang_definitions` VALUES (347, 559, 2, 'Boknings datum');
INSERT INTO `lang_definitions` VALUES (348, 565, 2, 'Sätt att visa bokning');
INSERT INTO `lang_definitions` VALUES (349, 567, 2, 'Påminnelser för bokning');
INSERT INTO `lang_definitions` VALUES (350, 569, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (351, 570, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (352, 571, 2, 'Bokas inom');
INSERT INTO `lang_definitions` VALUES (353, 572, 2, 'Bokning/händelse färg');
INSERT INTO `lang_definitions` VALUES (354, 573, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (355, 574, 2, 'Bokningar ( valfritt att skriva )');
INSERT INTO `lang_definitions` VALUES (356, 575, 2, 'Bokningar (Skriv, några valbara)');
INSERT INTO `lang_definitions` VALUES (357, 580, 2, 'Bokningar och besök');
INSERT INTO `lang_definitions` VALUES (358, 582, 2, 'Bokningsrapport');
INSERT INTO `lang_definitions` VALUES (359, 583, 2, 'Boknings och besöksrapport');
INSERT INTO `lang_definitions` VALUES (360, 585, 2, 'Godkänn');
INSERT INTO `lang_definitions` VALUES (361, 588, 2, 'Godkänd');
INSERT INTO `lang_definitions` VALUES (362, 589, 2, 'Godkända administrativa händelser');
INSERT INTO `lang_definitions` VALUES (363, 595, 2, 'Bokningar-besök');
INSERT INTO `lang_definitions` VALUES (364, 597, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (365, 600, 2, 'Apr');
INSERT INTO `lang_definitions` VALUES (366, 601, 2, 'April');
INSERT INTO `lang_definitions` VALUES (367, 603, 2, 'Arabisk');
INSERT INTO `lang_definitions` VALUES (368, 605, 2, 'Arkivera');
INSERT INTO `lang_definitions` VALUES (369, 608, 2, 'Ska gruppnamnen översättas?');
INSERT INTO `lang_definitions` VALUES (370, 609, 2, 'Ska bokningstyperna översättas?');
INSERT INTO `lang_definitions` VALUES (371, 610, 2, 'Ska dokumenttyperna översättas?');
INSERT INTO `lang_definitions` VALUES (372, 611, 2, 'Ska avgifter tas ut för denna typ?');
INSERT INTO `lang_definitions` VALUES (373, 614, 2, 'Ska överskrifter på patientanteckningar översättas?');
INSERT INTO `lang_definitions` VALUES (374, 615, 2, 'Är koderna lagrade i externa sql-tabeller (0-Nej, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2) )');
INSERT INTO `lang_definitions` VALUES (375, 616, 2, 'Är du beredd att genomföra en ny GCAC fråga för detta besök?');
INSERT INTO `lang_definitions` VALUES (376, 618, 2, 'Är du säker du vill bokföra dagens händelser?');
INSERT INTO `lang_definitions` VALUES (377, 619, 2, 'Är du säker på att du vill godkänna dessa händelser?');
INSERT INTO `lang_definitions` VALUES (378, 621, 2, 'Är du säker på att du vill ta bort detta formulär?');
INSERT INTO `lang_definitions` VALUES (379, 623, 2, 'Är du säker på att du vill ta bort denna friskrivning?');
INSERT INTO `lang_definitions` VALUES (380, 624, 2, 'Är du säker på att du vill ta bort denna händelse?');
INSERT INTO `lang_definitions` VALUES (381, 625, 2, 'Är du säker du vill ta bort detta från databasen?');
INSERT INTO `lang_definitions` VALUES (382, 626, 2, 'Är du säker på att du vill ta bort detta meddelande?');
INSERT INTO `lang_definitions` VALUES (383, 628, 2, 'Är du säker på att du vill ändra dessa händelser?');
INSERT INTO `lang_definitions` VALUES (384, 629, 2, 'Är du säker på att du vill dölja dessa händelser?');
INSERT INTO `lang_definitions` VALUES (385, 632, 2, 'Är du säker på att du vill visa dessa händelser?');
INSERT INTO `lang_definitions` VALUES (386, 633, 2, 'Är du säker på att du vill ta bort hela den valda gruppen');
INSERT INTO `lang_definitions` VALUES (387, 634, 2, 'Är du säker på att du vill ta bort hela listan');
INSERT INTO `lang_definitions` VALUES (388, 635, 2, 'Är du säker på att du vill ta bort fältet i');
INSERT INTO `lang_definitions` VALUES (389, 636, 2, 'Är du säker på att du vill ta bort markerade fält?');
INSERT INTO `lang_definitions` VALUES (390, 637, 2, 'Är du säker på att du vill fortsätta med dessa åtgärder?');
INSERT INTO `lang_definitions` VALUES (391, 638, 2, 'Område är ej specifiserat');
INSERT INTO `lang_definitions` VALUES (392, 639, 2, 'Arm');
INSERT INTO `lang_definitions` VALUES (393, 640, 2, 'Armensk');
INSERT INTO `lang_definitions` VALUES (394, 647, 2, 'Arrytmi');
INSERT INTO `lang_definitions` VALUES (395, 648, 2, 'Artrit');
INSERT INTO `lang_definitions` VALUES (396, 649, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (397, 650, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (398, 653, 2, 'som');
INSERT INTO `lang_definitions` VALUES (399, 655, 2, 'Per');
INSERT INTO `lang_definitions` VALUES (400, 658, 2, 'Asiatisk');
INSERT INTO `lang_definitions` VALUES (401, 661, 2, 'Bedömning');
INSERT INTO `lang_definitions` VALUES (402, 663, 2, 'Tilldelas');
INSERT INTO `lang_definitions` VALUES (403, 664, 2, 'Assistent');
INSERT INTO `lang_definitions` VALUES (404, 671, 2, 'Astma');
INSERT INTO `lang_definitions` VALUES (405, 672, 2, 'på');
INSERT INTO `lang_definitions` VALUES (406, 673, 2, 'Minst en sök parameter krävs om du väljer Alla');
INSERT INTO `lang_definitions` VALUES (407, 674, 2, 'Vid Båtbenet');
INSERT INTO `lang_definitions` VALUES (408, 675, 2, 'Vid Båtbenet:');
INSERT INTO `lang_definitions` VALUES (409, 676, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (410, 677, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (411, 678, 2, 'Idrottsskada');
INSERT INTO `lang_definitions` VALUES (412, 679, 2, 'CA certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (413, 680, 2, 'Värd för ATNA revision');
INSERT INTO `lang_definitions` VALUES (414, 681, 2, 'Lokalt certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (415, 682, 2, 'Posrt för ATNA revision');
INSERT INTO `lang_definitions` VALUES (416, 685, 2, 'Observera');
INSERT INTO `lang_definitions` VALUES (417, 687, 2, 'OBS');
INSERT INTO `lang_definitions` VALUES (418, 690, 2, 'revision CDR urval');
INSERT INTO `lang_definitions` VALUES (419, 697, 2, 'Revisionsloggning backup');
INSERT INTO `lang_definitions` VALUES (420, 698, 2, 'revisionsloggning blandad');
INSERT INTO `lang_definitions` VALUES (421, 699, 2, 'Revisionsloggning sorteringsordning');
INSERT INTO `lang_definitions` VALUES (422, 700, 2, 'Revisionsloggning patientjournal');
INSERT INTO `lang_definitions` VALUES (423, 701, 2, 'revisionsloggning schemaläggning');
INSERT INTO `lang_definitions` VALUES (424, 702, 2, 'Hantera säkerhet för revisorslog');
INSERT INTO `lang_definitions` VALUES (425, 703, 2, 'Urval av revisorlog');
INSERT INTO `lang_definitions` VALUES (426, 704, 2, 'Aug');
INSERT INTO `lang_definitions` VALUES (427, 705, 2, 'Augusti');
INSERT INTO `lang_definitions` VALUES (428, 707, 2, 'Rättigheter');
INSERT INTO `lang_definitions` VALUES (429, 708, 2, 'Rättighet/anteckningar');
INSERT INTO `lang_definitions` VALUES (430, 711, 2, 'Grupprättigheter');
INSERT INTO `lang_definitions` VALUES (431, 712, 2, 'Status på auktorisation');
INSERT INTO `lang_definitions` VALUES (432, 713, 2, 'Tillstånd');
INSERT INTO `lang_definitions` VALUES (433, 714, 2, 'Bemyndiga');
INSERT INTO `lang_definitions` VALUES (434, 715, 2, 'Auktorisera – alla möten');
INSERT INTO `lang_definitions` VALUES (435, 717, 2, 'Auktorisera - Mina möten');
INSERT INTO `lang_definitions` VALUES (436, 720, 2, 'Auktorisera.net');
INSERT INTO `lang_definitions` VALUES (437, 721, 2, 'Auktoriserad');
INSERT INTO `lang_definitions` VALUES (438, 723, 2, 'Enbart auktoriserade');
INSERT INTO `lang_definitions` VALUES (439, 726, 2, 'Skicka automatiskt');
INSERT INTO `lang_definitions` VALUES (440, 729, 2, 'Skapa nytt besök automatiskt');
INSERT INTO `lang_definitions` VALUES (441, 730, 2, 'Autogenererad');
INSERT INTO `lang_definitions` VALUES (442, 732, 2, 'Automatiska beräkningar (AMC)');
INSERT INTO `lang_definitions` VALUES (443, 737, 2, 'Spåra automatiska beräkningar (ATM)');
INSERT INTO `lang_definitions` VALUES (444, 738, 2, 'Automatiska mätningar (AMC)');
INSERT INTO `lang_definitions` VALUES (445, 740, 2, 'Automatiskt');
INSERT INTO `lang_definitions` VALUES (446, 744, 2, 'Automatiskt skapa nytt besök när bokningsstatus är satt till ”@” (Kommit)');
INSERT INTO `lang_definitions` VALUES (447, 747, 2, 'Trafikmedicin');
INSERT INTO `lang_definitions` VALUES (448, 748, 2, 'Sparad automatisk');
INSERT INTO `lang_definitions` VALUES (449, 751, 2, 'Tillgängliga kategorier');
INSERT INTO `lang_definitions` VALUES (450, 753, 2, 'Tillgängliga tider');
INSERT INTO `lang_definitions` VALUES (451, 758, 2, 'Månadsgenomsnitt');
INSERT INTO `lang_definitions` VALUES (452, 762, 2, 'Avulsion / avulsion fraktur');
INSERT INTO `lang_definitions` VALUES (453, 763, 2, 'Avulsion laterala malleolus');
INSERT INTO `lang_definitions` VALUES (454, 764, 2, 'Avulsion mediala malleolus');
INSERT INTO `lang_definitions` VALUES (455, 765, 2, 'Medvetandebaserad');
INSERT INTO `lang_definitions` VALUES (456, 767, 2, 'Axillär');
INSERT INTO `lang_definitions` VALUES (457, 774, 2, '2 ggr/dag');
INSERT INTO `lang_definitions` VALUES (458, 775, 2, 'Tillbaka');
INSERT INTO `lang_definitions` VALUES (459, 776, 2, 'tillbaka');
INSERT INTO `lang_definitions` VALUES (460, 777, 2, 'Bakåt 8 besök');
INSERT INTO `lang_definitions` VALUES (461, 778, 2, 'Bakåt 11 besök');
INSERT INTO `lang_definitions` VALUES (462, 779, 2, 'Bakåt 5 besök');
INSERT INTO `lang_definitions` VALUES (463, 780, 2, 'Bakåt 4 besök');
INSERT INTO `lang_definitions` VALUES (464, 781, 2, 'Bakåt 9 besök');
INSERT INTO `lang_definitions` VALUES (465, 782, 2, 'Bakåt 1 besök');
INSERT INTO `lang_definitions` VALUES (466, 783, 2, 'Ryggsmärta');
INSERT INTO `lang_definitions` VALUES (467, 784, 2, 'Ryggproblem');
INSERT INTO `lang_definitions` VALUES (468, 785, 2, 'Bakåt 7 besök');
INSERT INTO `lang_definitions` VALUES (469, 786, 2, 'Bakåt 6 besök');
INSERT INTO `lang_definitions` VALUES (470, 787, 2, 'Ryggkirurgi');
INSERT INTO `lang_definitions` VALUES (471, 788, 2, 'Bakåt 10 besök');
INSERT INTO `lang_definitions` VALUES (472, 789, 2, 'Bakåt 3 besök');
INSERT INTO `lang_definitions` VALUES (473, 790, 2, 'Tillbaka till Admin sidan');
INSERT INTO `lang_definitions` VALUES (474, 794, 2, 'Tillbaka till patient');
INSERT INTO `lang_definitions` VALUES (475, 795, 2, 'Tillbaka till användare');
INSERT INTO `lang_definitions` VALUES (476, 796, 2, 'Tillbaka till Visa');
INSERT INTO `lang_definitions` VALUES (477, 797, 2, 'Bakåt 12 besök');
INSERT INTO `lang_definitions` VALUES (478, 798, 2, 'Bakåt 2 besök');
INSERT INTO `lang_definitions` VALUES (479, 799, 2, 'Bakgrunds tjänster');
INSERT INTO `lang_definitions` VALUES (480, 800, 2, 'Backup');
INSERT INTO `lang_definitions` VALUES (481, 801, 2, 'Backup-filen har skapats. Kommer nu skicka till nedladdning.');
INSERT INTO `lang_definitions` VALUES (482, 803, 2, 'Backup genomfört i');
INSERT INTO `lang_definitions` VALUES (483, 804, 2, 'Dålig kontroll');
INSERT INTO `lang_definitions` VALUES (484, 805, 2, 'Dålig fordran');
INSERT INTO `lang_definitions` VALUES (485, 806, 2, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (486, 807, 2, 'Bal');
INSERT INTO `lang_definitions` VALUES (487, 808, 2, 'Balans');
INSERT INTO `lang_definitions` VALUES (488, 809, 2, 'balans');
INSERT INTO `lang_definitions` VALUES (489, 810, 2, 'Saldo mängd');
INSERT INTO `lang_definitions` VALUES (490, 811, 2, 'Balanserade skulder');
INSERT INTO `lang_definitions` VALUES (491, 815, 2, 'Bankavdrag');
INSERT INTO `lang_definitions` VALUES (492, 819, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (493, 820, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (494, 824, 2, 'Samlingsfaktura');
INSERT INTO `lang_definitions` VALUES (495, 825, 2, 'Samlingskummunikationsverktyg');
INSERT INTO `lang_definitions` VALUES (496, 827, 2, 'Samlingsbetalning inskrivning');
INSERT INTO `lang_definitions` VALUES (497, 828, 2, 'samlingsbetalning');
INSERT INTO `lang_definitions` VALUES (498, 829, 2, 'Batchprocess påbörjad, detta kan ta ett tag.');
INSERT INTO `lang_definitions` VALUES (499, 830, 2, 'Samlingsresultat');
INSERT INTO `lang_definitions` VALUES (500, 831, 2, 'BatchCom');
INSERT INTO `lang_definitions` VALUES (501, 836, 2, 'För att ID inte existerar');
INSERT INTO `lang_definitions` VALUES (502, 839, 2, 'Starta');
INSERT INTO `lang_definitions` VALUES (503, 840, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (504, 842, 2, 'Tjänstens startdatum åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (505, 843, 2, 'Start klockslag för kalenderhändelse');
INSERT INTO `lang_definitions` VALUES (506, 845, 2, 'Rapningar');
INSERT INTO `lang_definitions` VALUES (507, 847, 2, 'Bengali');
INSERT INTO `lang_definitions` VALUES (508, 850, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (509, 856, 2, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (510, 857, 2, 'Bilaterala:');
INSERT INTO `lang_definitions` VALUES (511, 859, 2, 'Faktura datuma:');
INSERT INTO `lang_definitions` VALUES (512, 860, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (513, 861, 2, 'Fakturerade');
INSERT INTO `lang_definitions` VALUES (514, 863, 2, 'Fakturering');
INSERT INTO `lang_definitions` VALUES (515, 864, 2, 'Fakturering (skriv alternativ)');
INSERT INTO `lang_definitions` VALUES (516, 866, 2, 'Fakturering attestera');
INSERT INTO `lang_definitions` VALUES (517, 868, 2, 'Betalningskod för begärd service');
INSERT INTO `lang_definitions` VALUES (518, 869, 2, 'Betalningskoder');
INSERT INTO `lang_definitions` VALUES (519, 870, 2, 'Faktureringsdata');
INSERT INTO `lang_definitions` VALUES (520, 871, 2, 'Fakturering avdelning');
INSERT INTO `lang_definitions` VALUES (521, 872, 2, 'Fakturering Klinik');
INSERT INTO `lang_definitions` VALUES (522, 873, 2, 'Faktureringsinformation');
INSERT INTO `lang_definitions` VALUES (523, 874, 2, 'Faktureringsadress');
INSERT INTO `lang_definitions` VALUES (524, 879, 2, 'Fakturaansvarig');
INSERT INTO `lang_definitions` VALUES (525, 880, 2, 'Faktura Anmärkning');
INSERT INTO `lang_definitions` VALUES (526, 881, 2, 'Fakturera anmärkning för');
INSERT INTO `lang_definitions` VALUES (527, 882, 2, 'Fakturera notering:');
INSERT INTO `lang_definitions` VALUES (528, 884, 2, 'Fakturera kö resultat:');
INSERT INTO `lang_definitions` VALUES (529, 885, 2, 'Faktureringsrapport');
INSERT INTO `lang_definitions` VALUES (530, 886, 2, 'Faktura status');
INSERT INTO `lang_definitions` VALUES (531, 887, 2, 'Faktura status = Ej skickad');
INSERT INTO `lang_definitions` VALUES (532, 888, 2, 'fakturera till');
INSERT INTO `lang_definitions` VALUES (533, 892, 2, 'Biopsi');
INSERT INTO `lang_definitions` VALUES (534, 894, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (535, 895, 2, 'Födelse – 24 månader');
INSERT INTO `lang_definitions` VALUES (536, 898, 2, 'Svart');
INSERT INTO `lang_definitions` VALUES (537, 900, 2, 'Sotlunga');
INSERT INTO `lang_definitions` VALUES (538, 901, 2, 'Afrikans amerikan');
INSERT INTO `lang_definitions` VALUES (539, 902, 2, 'Cancer i urinblåsan');
INSERT INTO `lang_definitions` VALUES (540, 903, 2, 'Infektioner i urinblåsan');
INSERT INTO `lang_definitions` VALUES (541, 905, 2, 'Blankt formulär');
INSERT INTO `lang_definitions` VALUES (542, 906, 2, 'Problem med blödning');
INSERT INTO `lang_definitions` VALUES (543, 907, 2, 'Blinda punkter');
INSERT INTO `lang_definitions` VALUES (544, 909, 2, 'Svullnad');
INSERT INTO `lang_definitions` VALUES (545, 911, 2, 'Blockerade');
INSERT INTO `lang_definitions` VALUES (546, 912, 2, 'Blod');
INSERT INTO `lang_definitions` VALUES (547, 913, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (548, 914, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (549, 915, 2, 'Näsblod');
INSERT INTO `lang_definitions` VALUES (550, 916, 2, 'Blått kors blå sköld');
INSERT INTO `lang_definitions` VALUES (551, 917, 2, 'Blå linjerna i denna rapport är informativa. Svarta linjer visar tidigare information. Gröna linjerna visar förändringar som tillämpats framgångsrikt. Röda linjer visar fel eller förändringar som inte har genomförts, och dessa måste behandlas manuellt. För närvarande nekas fordringar och betalning reverseringar inte hanteras automatiskt och det kommer att visas i rött.');
INSERT INTO `lang_definitions` VALUES (552, 918, 2, 'Dimsyn');
INSERT INTO `lang_definitions` VALUES (553, 919, 2, 'BMI');
INSERT INTO `lang_definitions` VALUES (554, 920, 2, 'BMI status');
INSERT INTO `lang_definitions` VALUES (555, 922, 2, 'kroppsregion');
INSERT INTO `lang_definitions` VALUES (556, 923, 2, 'Bkroppsdel');
INSERT INTO `lang_definitions` VALUES (557, 924, 2, 'Kroppsdel, om tillämplig');
INSERT INTO `lang_definitions` VALUES (558, 925, 2, 'Benömhet:');
INSERT INTO `lang_definitions` VALUES (559, 926, 2, 'Benömhet: Malleoulus Medialis');
INSERT INTO `lang_definitions` VALUES (560, 927, 2, 'Logisk');
INSERT INTO `lang_definitions` VALUES (561, 931, 2, 'Båda öronen');
INSERT INTO `lang_definitions` VALUES (562, 932, 2, 'båda öronen');
INSERT INTO `lang_definitions` VALUES (563, 933, 2, 'Botten');
INSERT INTO `lang_definitions` VALUES (564, 935, 2, 'RUTA 10 A. Anställningsrelaterad');
INSERT INTO `lang_definitions` VALUES (565, 936, 2, 'RUTA 10 B. Bilolycka');
INSERT INTO `lang_definitions` VALUES (566, 937, 2, 'RUTA 10 C. Övriga olyckor');
INSERT INTO `lang_definitions` VALUES (567, 947, 2, 'Ruta 15. Datum för samma eller liknande sjukdom (åååå-mm-dd)');
INSERT INTO `lang_definitions` VALUES (568, 951, 2, 'FÄLT 16. Datum, oförmögen till arbete från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (569, 954, 2, 'FÄLT 16. Datum, oförmögen att arbeta tills (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (570, 961, 2, 'FÄLT 18. Sjukhusvistelse datum, från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (571, 964, 2, 'FÄLT 18. Sjukhusvistelse till, datum (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (572, 967, 2, 'FÄLT 20. Används externt lab?');
INSERT INTO `lang_definitions` VALUES (573, 969, 2, 'Fält 22. Medicaid återinskickningskod (ICD-9)');
INSERT INTO `lang_definitions` VALUES (574, 971, 2, 'Fält 23. Tidigare godkännande nr.');
INSERT INTO `lang_definitions` VALUES (575, 972, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (576, 973, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (577, 974, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (578, 976, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (579, 980, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (580, 982, 2, 'Brasiliansk portugisiska');
INSERT INTO `lang_definitions` VALUES (581, 983, 2, 'Bröst');
INSERT INTO `lang_definitions` VALUES (582, 984, 2, 'Bröst Biopsi');
INSERT INTO `lang_definitions` VALUES (583, 985, 2, 'Bröst Avsluta');
INSERT INTO `lang_definitions` VALUES (584, 986, 2, 'Bröstsjukdom');
INSERT INTO `lang_definitions` VALUES (585, 987, 2, 'Bröstundersökning');
INSERT INTO `lang_definitions` VALUES (586, 988, 2, 'Bröstvävnad');
INSERT INTO `lang_definitions` VALUES (587, 990, 2, 'Andningsljud:');
INSERT INTO `lang_definitions` VALUES (588, 993, 2, 'Brutna ben');
INSERT INTO `lang_definitions` VALUES (589, 995, 2, 'Bronkit Formulär');
INSERT INTO `lang_definitions` VALUES (590, 998, 2, 'Bläddra');
INSERT INTO `lang_definitions` VALUES (591, 999, 2, 'Bläddra efter journal');
INSERT INTO `lang_definitions` VALUES (592, 1000, 2, 'Blåmärken / hematom');
INSERT INTO `lang_definitions` VALUES (593, 1003, 2, 'Utbuktningen Höger:');
INSERT INTO `lang_definitions` VALUES (594, 1005, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (595, 1006, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (596, 1009, 2, 'Upptagen');
INSERT INTO `lang_definitions` VALUES (597, 1010, 2, 'ännu ej behandlad');
INSERT INTO `lang_definitions` VALUES (598, 1011, 2, 'Skinka');
INSERT INTO `lang_definitions` VALUES (599, 1012, 2, 'Skinkan och SI-led');
INSERT INTO `lang_definitions` VALUES (600, 1013, 2, 'via');
INSERT INTO `lang_definitions` VALUES (601, 1014, 2, 'via');
INSERT INTO `lang_definitions` VALUES (602, 1016, 2, 'via munnen');
INSERT INTO `lang_definitions` VALUES (603, 1017, 2, 'Genom / Källa');
INSERT INTO `lang_definitions` VALUES (604, 1018, 2, 'Av:');
INSERT INTO `lang_definitions` VALUES (605, 1021, 2, 'Kopia');
INSERT INTO `lang_definitions` VALUES (606, 1022, 2, 'CA certifikat för att verifiera RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (607, 1023, 2, 'Cache, livstid (i sekunder)');
INSERT INTO `lang_definitions` VALUES (608, 1024, 2, 'Cache template output?');
INSERT INTO `lang_definitions` VALUES (609, 1026, 2, 'Kaffe konsumtion');
INSERT INTO `lang_definitions` VALUES (610, 1027, 2, 'Kalender');
INSERT INTO `lang_definitions` VALUES (611, 1028, 2, 'Kalender sluttid');
INSERT INTO `lang_definitions` VALUES (612, 1029, 2, 'Kalender interval');
INSERT INTO `lang_definitions` VALUES (613, 1030, 2, 'Kalender skärm');
INSERT INTO `lang_definitions` VALUES (614, 1031, 2, 'Kalenderinställningar');
INSERT INTO `lang_definitions` VALUES (615, 1033, 2, 'Kalender starttid');
INSERT INTO `lang_definitions` VALUES (616, 1034, 2, 'Kalender UI');
INSERT INTO `lang_definitions` VALUES (617, 1035, 2, 'Kalendervy');
INSERT INTO `lang_definitions` VALUES (618, 1038, 2, 'Anrop till addForm() skriv här. <br>');
INSERT INTO `lang_definitions` VALUES (619, 1042, 2, 'Kalorier');
INSERT INTO `lang_definitions` VALUES (620, 1043, 2, 'Kambodjan');
INSERT INTO `lang_definitions` VALUES (621, 1044, 2, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (622, 1050, 2, 'Avbryt');
INSERT INTO `lang_definitions` VALUES (623, 1052, 2, 'Förkasta ändringar');
INSERT INTO `lang_definitions` VALUES (624, 1053, 2, 'Avbruten');
INSERT INTO `lang_definitions` VALUES (625, 1055, 2, 'Cancer');
INSERT INTO `lang_definitions` VALUES (626, 1056, 2, 'Cancer screening: Colon cancer screening');
INSERT INTO `lang_definitions` VALUES (627, 1057, 2, 'Scancer screening: Mammografi');
INSERT INTO `lang_definitions` VALUES (628, 1058, 2, 'Cancer screening: Pap smear');
INSERT INTO `lang_definitions` VALUES (629, 1059, 2, 'Cancer screening: Prostata cancer');
INSERT INTO `lang_definitions` VALUES (630, 1060, 2, 'Det går ej att lägga till detta för att det redan existerar!');
INSERT INTO `lang_definitions` VALUES (631, 1061, 2, 'Kan inte lägga till / uppdatera den här posten eftersom duplikat redan finns!');
INSERT INTO `lang_definitions` VALUES (632, 1062, 2, 'Kan inte lagra. Kastat.');
INSERT INTO `lang_definitions` VALUES (633, 1063, 2, 'kan inte konverteras till JPEG. Kanske ImageMagick inte är installerad?');
INSERT INTO `lang_definitions` VALUES (634, 1064, 2, 'Kan inte tas bort. Utan åtgärd.');
INSERT INTO `lang_definitions` VALUES (635, 1065, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (636, 1066, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (637, 1067, 2, 'kan inte visas online eftersom den typen inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (638, 1068, 2, 'Det går inte att skapa');
INSERT INTO `lang_definitions` VALUES (639, 1073, 2, 'Kan ej hitta');
INSERT INTO `lang_definitions` VALUES (640, 1074, 2, 'Kan ej hitta filnamnet');
INSERT INTO `lang_definitions` VALUES (641, 1077, 2, 'Kan inte hitta patienten från SQL-ledgers kundnummer');
INSERT INTO `lang_definitions` VALUES (642, 1078, 2, 'Kan ej hitta postscript dokumenthänvisning i');
INSERT INTO `lang_definitions` VALUES (643, 1079, 2, 'Kan inte hitta vårdgivaren i SQL-ledger');
INSERT INTO `lang_definitions` VALUES (644, 1080, 2, 'Kan inte ändra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (645, 1082, 2, 'Går inte att öppna');
INSERT INTO `lang_definitions` VALUES (646, 1083, 2, 'Kan inte bokföra på försäkring. Betalningsansvarig är patienten.');
INSERT INTO `lang_definitions` VALUES (647, 1084, 2, 'Kan inte bokföra på patient. Betalningsansvarig är försäkring.');
INSERT INTO `lang_definitions` VALUES (648, 1085, 2, 'Kan inte bokföra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (649, 1086, 2, 'Kan ej läsa');
INSERT INTO `lang_definitions` VALUES (650, 1087, 2, 'Kan ej läsa i mappen');
INSERT INTO `lang_definitions` VALUES (651, 1088, 2, 'Kan inte uppdatera eftersom du inte redigerar en befintlig post!');
INSERT INTO `lang_definitions` VALUES (652, 1089, 2, 'Stor bokstav');
INSERT INTO `lang_definitions` VALUES (653, 1091, 2, 'kapsel');
INSERT INTO `lang_definitions` VALUES (654, 1092, 2, 'Kort');
INSERT INTO `lang_definitions` VALUES (655, 1099, 2, 'Hjärtkateterisering');
INSERT INTO `lang_definitions` VALUES (656, 1100, 2, 'Hjärteko');
INSERT INTO `lang_definitions` VALUES (657, 1101, 2, 'Kardiovaskulära');
INSERT INTO `lang_definitions` VALUES (658, 1110, 2, 'Brosk / menisk skada');
INSERT INTO `lang_definitions` VALUES (659, 1111, 2, 'Broskskada');
INSERT INTO `lang_definitions` VALUES (660, 1112, 2, 'Inga karotispulsar. Inga fotpulsar.');
INSERT INTO `lang_definitions` VALUES (661, 1114, 2, 'kontanter');
INSERT INTO `lang_definitions` VALUES (662, 1115, 2, 'Kontanter');
INSERT INTO `lang_definitions` VALUES (663, 1116, 2, 'Kontantbetalning');
INSERT INTO `lang_definitions` VALUES (664, 1117, 2, 'Kontantkvitton från vårdgivare');
INSERT INTO `lang_definitions` VALUES (665, 1120, 2, 'Kataraktkirurgi');
INSERT INTO `lang_definitions` VALUES (666, 1121, 2, 'Katarakt');
INSERT INTO `lang_definitions` VALUES (667, 1122, 2, 'Kategorier');
INSERT INTO `lang_definitions` VALUES (668, 1123, 2, 'Kategorier av');
INSERT INTO `lang_definitions` VALUES (669, 1124, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (670, 1125, 2, 'kategori');
INSERT INTO `lang_definitions` VALUES (671, 1126, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (672, 1129, 2, 'Kategori Detaljer');
INSERT INTO `lang_definitions` VALUES (673, 1130, 2, 'Kategori Gränser');
INSERT INTO `lang_definitions` VALUES (674, 1131, 2, 'Kategorinamn');
INSERT INTO `lang_definitions` VALUES (675, 1132, 2, 'Kategorinamn är tomt');
INSERT INTO `lang_definitions` VALUES (676, 1133, 2, 'Kategori/Titel');
INSERT INTO `lang_definitions` VALUES (677, 1134, 2, 'Kaukasisk');
INSERT INTO `lang_definitions` VALUES (678, 1135, 2, 'Kvitto på kontaktorsak att skriva för besök. Primär vårdgivar information');
INSERT INTO `lang_definitions` VALUES (679, 1155, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (680, 1156, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (681, 1158, 2, 'Mobiltelefonnummer');
INSERT INTO `lang_definitions` VALUES (682, 1159, 2, 'Central Certifiering');
INSERT INTO `lang_definitions` VALUES (683, 1161, 2, 'Central/sydamerikan');
INSERT INTO `lang_definitions` VALUES (684, 1162, 2, 'CA certifikats fil-mapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (685, 1163, 2, 'CA nyckelfilsmapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (686, 1164, 2, 'CA certifikat för att skicka till RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (687, 1165, 2, 'Certifikat användare');
INSERT INTO `lang_definitions` VALUES (688, 1166, 2, 'Certifikat');
INSERT INTO `lang_definitions` VALUES (689, 1168, 2, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (690, 1169, 2, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (691, 1170, 2, 'ändra');
INSERT INTO `lang_definitions` VALUES (692, 1171, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (693, 1172, 2, 'Ändra Aktivitet');
INSERT INTO `lang_definitions` VALUES (694, 1174, 2, 'Gick inte ändra. CouchDB fel?');
INSERT INTO `lang_definitions` VALUES (695, 1175, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (696, 1176, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (697, 1177, 2, 'Byta lösenord');
INSERT INTO `lang_definitions` VALUES (698, 1179, 2, 'Ändrad');
INSERT INTO `lang_definitions` VALUES (699, 1180, 2, 'Förändrad tarm');
INSERT INTO `lang_definitions` VALUES (700, 1181, 2, 'Byter patientidentitet för dokument');
INSERT INTO `lang_definitions` VALUES (701, 1183, 2, 'Karaktär');
INSERT INTO `lang_definitions` VALUES (702, 1184, 2, 'Tecken kvar');
INSERT INTO `lang_definitions` VALUES (703, 1185, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (704, 1186, 2, 'Justering av avgift');
INSERT INTO `lang_definitions` VALUES (705, 1187, 2, 'Avgift kodad');
INSERT INTO `lang_definitions` VALUES (706, 1189, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (707, 1190, 2, 'Patientkort');
INSERT INTO `lang_definitions` VALUES (708, 1191, 2, 'Patientkort aktivitet');
INSERT INTO `lang_definitions` VALUES (709, 1192, 2, 'Patientkort Check-in/out Aktivitetsrapport?');
INSERT INTO `lang_definitions` VALUES (710, 1193, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (711, 1194, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (712, 1196, 2, 'Patientkort placering Aktivitet');
INSERT INTO `lang_definitions` VALUES (713, 1197, 2, 'Patientkort notering');
INSERT INTO `lang_definitions` VALUES (714, 1198, 2, 'Patientkort nr');
INSERT INTO `lang_definitions` VALUES (715, 1200, 2, 'Patientkort lagring placering');
INSERT INTO `lang_definitions` VALUES (716, 1201, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (717, 1202, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (718, 1203, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (719, 1204, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (720, 1208, 2, 'Betalningsanvisning');
INSERT INTO `lang_definitions` VALUES (721, 1209, 2, 'Betalningsanvisning');
INSERT INTO `lang_definitions` VALUES (722, 1210, 2, 'Alla betalningsanvisningar');
INSERT INTO `lang_definitions` VALUES (723, 1212, 2, 'Betalningsanvisning belopp');
INSERT INTO `lang_definitions` VALUES (724, 1213, 2, 'Betalningsanvisning datum');
INSERT INTO `lang_definitions` VALUES (725, 1215, 2, 'Kontrollera skillnader i översättning med översättningstabellen');
INSERT INTO `lang_definitions` VALUES (726, 1220, 2, 'checka in till');
INSERT INTO `lang_definitions` VALUES (727, 1221, 2, 'Kontrollera indata');
INSERT INTO `lang_definitions` VALUES (728, 1223, 2, 'Kontrollera labdata');
INSERT INTO `lang_definitions` VALUES (729, 1224, 2, 'Markering betyder påtittat');
INSERT INTO `lang_definitions` VALUES (730, 1225, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (731, 1226, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (732, 1229, 2, 'Betalningsanvisning betalning');
INSERT INTO `lang_definitions` VALUES (733, 1230, 2, 'Markera ifall filen är krypterad');
INSERT INTO `lang_definitions` VALUES (734, 1231, 2, 'Markera om vårdgivare ska se alla bokade besök som standard och ej enbart deras egna');
INSERT INTO `lang_definitions` VALUES (735, 1232, 2, 'Markera för att skapa \'Problem\' utifrån denna diagnos');
INSERT INTO `lang_definitions` VALUES (736, 1233, 2, 'Check / EOB Datum:');
INSERT INTO `lang_definitions` VALUES (737, 1234, 2, 'Check / EOB Nr:');
INSERT INTO `lang_definitions` VALUES (738, 1235, 2, 'Check / Ref Nr');
INSERT INTO `lang_definitions` VALUES (739, 1236, 2, 'Check / Referensnummer');
INSERT INTO `lang_definitions` VALUES (740, 1237, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (741, 1238, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (742, 1239, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (743, 1240, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (744, 1244, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (745, 1246, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (746, 1252, 2, 'Kassa');
INSERT INTO `lang_definitions` VALUES (747, 1253, 2, 'Kontrollsumma');
INSERT INTO `lang_definitions` VALUES (748, 1254, 2, 'Bröstkorg');
INSERT INTO `lang_definitions` VALUES (749, 1255, 2, 'Chest CTAB');
INSERT INTO `lang_definitions` VALUES (750, 1256, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (751, 1257, 2, 'Bröstsmärta:');
INSERT INTO `lang_definitions` VALUES (752, 1258, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (753, 1260, 2, 'Byt');
INSERT INTO `lang_definitions` VALUES (754, 1262, 2, 'Huvudproblem');
INSERT INTO `lang_definitions` VALUES (755, 1265, 2, 'Barn');
INSERT INTO `lang_definitions` VALUES (756, 1267, 2, 'Barnvaccinations status');
INSERT INTO `lang_definitions` VALUES (757, 1268, 2, 'Frossbrytningar');
INSERT INTO `lang_definitions` VALUES (758, 1269, 2, 'Kinesiska');
INSERT INTO `lang_definitions` VALUES (759, 1270, 2, 'Kinesiska (Förenklad)');
INSERT INTO `lang_definitions` VALUES (760, 1271, 2, 'Kinesiska (traditionell)');
INSERT INTO `lang_definitions` VALUES (761, 1273, 2, 'Val');
INSERT INTO `lang_definitions` VALUES (762, 1274, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (763, 1276, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (764, 1277, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (765, 1280, 2, 'Välj ett avsnitt och klicka på ett objekt i den ;i den andra sektionen visas relaterade objekt. Klicka på avsnitten om du vill lägga till och ta bort relationer.');
INSERT INTO `lang_definitions` VALUES (766, 1281, 2, 'Välj kriteria');
INSERT INTO `lang_definitions` VALUES (767, 1284, 2, 'Välj fil');
INSERT INTO `lang_definitions` VALUES (768, 1285, 2, 'Välj från lista');
INSERT INTO `lang_definitions` VALUES (769, 1287, 2, 'Välj lista');
INSERT INTO `lang_definitions` VALUES (770, 1292, 2, 'Välj utskriftsformat för besöksrapport');
INSERT INTO `lang_definitions` VALUES (771, 1295, 2, 'Kronisk bronkit');
INSERT INTO `lang_definitions` VALUES (772, 1296, 2, 'Kronisk ledvärk');
INSERT INTO `lang_definitions` VALUES (773, 1297, 2, 'Kroniska njurbesvär');
INSERT INTO `lang_definitions` VALUES (774, 1300, 2, 'Kronisk synovit / utgjutning / ledvärk / gikt');
INSERT INTO `lang_definitions` VALUES (775, 1302, 2, 'Kronisk / Återkommande');
INSERT INTO `lang_definitions` VALUES (776, 1305, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (777, 1306, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (778, 1307, 2, 'Stad');
INSERT INTO `lang_definitions` VALUES (779, 1308, 2, 'Stadsnamn');
INSERT INTO `lang_definitions` VALUES (780, 1309, 2, 'Stad, stat');
INSERT INTO `lang_definitions` VALUES (781, 1310, 2, 'Stad, stat postnummer');
INSERT INTO `lang_definitions` VALUES (782, 1311, 2, 'Stad / stat');
INSERT INTO `lang_definitions` VALUES (783, 1312, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (784, 1313, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (785, 1315, 2, 'Begäran status');
INSERT INTO `lang_definitions` VALUES (786, 1317, 2, 'Begäran typ');
INSERT INTO `lang_definitions` VALUES (787, 1318, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (788, 1319, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (789, 1320, 2, 'Begäran');
INSERT INTO `lang_definitions` VALUES (790, 1321, 2, 'Klassificering');
INSERT INTO `lang_definitions` VALUES (791, 1322, 2, 'Rensa');
INSERT INTO `lang_definitions` VALUES (792, 1324, 2, 'RENSA AKTIV PATIENT');
INSERT INTO `lang_definitions` VALUES (793, 1326, 2, 'Rensa allt');
INSERT INTO `lang_definitions` VALUES (794, 1329, 2, 'Rensa HL7 data');
INSERT INTO `lang_definitions` VALUES (795, 1330, 2, 'Rensa justering');
INSERT INTO `lang_definitions` VALUES (796, 1333, 2, 'Rensa Smarty Cache');
INSERT INTO `lang_definitions` VALUES (797, 1335, 2, 'CLIA Antal');
INSERT INTO `lang_definitions` VALUES (798, 1336, 2, 'Klicka');
INSERT INTO `lang_definitions` VALUES (799, 1337, 2, 'Klicka \'export\' för att exportera din kategori, underkategori, enhet eller innehållsdata till en textfil. Någon likhet mellan denna textfil och en XML-fil är enbart en tillfällighet. Start och sluttaggar måste vara på samma rad, måste vara med små bokstäver och utan mellanrum. För att importera, bläddra efter filen, klicka på \'import\'. Om data är helt annorlunda kommer det läggas till existerande data. Om det finns likvärdiga enhetsnamn kommer de gamla att behållas och de nya läggas till med en siffra i slutet av namnet.');
INSERT INTO `lang_definitions` VALUES (800, 1338, 2, 'Klicka på en plats på bilden för att lägga till notering. Klicka igen för att ta bort den.');
INSERT INTO `lang_definitions` VALUES (801, 1339, 2, 'Klicka ”Download Certificate” för att ladda ner certifikatet i filen ssl.zip');
INSERT INTO `lang_definitions` VALUES (802, 1340, 2, 'Klicka för mer');
INSERT INTO `lang_definitions` VALUES (803, 1341, 2, 'Klicka för mer detaljer');
INSERT INTO `lang_definitions` VALUES (804, 1342, 2, 'Klicka för att beställa summering');
INSERT INTO `lang_definitions` VALUES (805, 1343, 2, 'Klicka för resultat');
INSERT INTO `lang_definitions` VALUES (806, 1345, 2, 'Klicka här');
INSERT INTO `lang_definitions` VALUES (807, 1346, 2, 'Klicka här för att lägga till patient');
INSERT INTO `lang_definitions` VALUES (808, 1347, 2, 'Klicka här för att lägga till ny skada, byta status och ändra dagliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (809, 1349, 2, 'Klicka här för att välja ett datum');
INSERT INTO `lang_definitions` VALUES (810, 1350, 2, 'Klicka här för att välja datum och klockslag');
INSERT INTO `lang_definitions` VALUES (811, 1351, 2, 'Klicka här för att välja startdatum');
INSERT INTO `lang_definitions` VALUES (812, 1370, 2, 'Klicka här för att söka');
INSERT INTO `lang_definitions` VALUES (813, 1372, 2, 'Klicka här för att uppdatera prioritet, kategori och smeknamn inställningar');
INSERT INTO `lang_definitions` VALUES (814, 1374, 2, 'Klicka här, för att se alla.');
INSERT INTO `lang_definitions` VALUES (815, 1375, 2, 'Klicka här för att se och rita');
INSERT INTO `lang_definitions` VALUES (816, 1377, 2, 'Klicka här för att se och rita all vitalparametrar');
INSERT INTO `lang_definitions` VALUES (817, 1378, 2, 'Klicka här för att se patient detaljer');
INSERT INTO `lang_definitions` VALUES (818, 1379, 2, 'Klicka här för att se alla');
INSERT INTO `lang_definitions` VALUES (819, 1380, 2, 'Klicka här för att se/ändra mer detaljer');
INSERT INTO `lang_definitions` VALUES (820, 1382, 2, 'Klicka ”install” knappen för att installera databas utgåva sedan följande datum');
INSERT INTO `lang_definitions` VALUES (821, 1385, 2, 'Klicka någonstans på tid för att öka');
INSERT INTO `lang_definitions` VALUES (822, 1389, 2, 'Klicka på patientnamn för att öppna patientfilen');
INSERT INTO `lang_definitions` VALUES (823, 1390, 2, 'Klicka ”uppdatera” för att se alla resultat eller var vänlig ange sökkriterier ovan för att se specifika resultat');
INSERT INTO `lang_definitions` VALUES (824, 1398, 2, 'Klicka för att lägga till diagnos');
INSERT INTO `lang_definitions` VALUES (825, 1399, 2, 'Lklicka för att lägga till komponent');
INSERT INTO `lang_definitions` VALUES (826, 1400, 2, 'Klicka för att lägga till konsultation');
INSERT INTO `lang_definitions` VALUES (827, 1403, 2, 'Klicka för att ladda ner');
INSERT INTO `lang_definitions` VALUES (828, 1404, 2, 'Klicka för att ändra');
INSERT INTO `lang_definitions` VALUES (829, 1405, 2, 'Klicka för att ändra beskrivning');
INSERT INTO `lang_definitions` VALUES (830, 1406, 2, 'Klicka för att ändra denna händelse');
INSERT INTO `lang_definitions` VALUES (831, 1407, 2, 'Klicka för att skapa rapporten');
INSERT INTO `lang_definitions` VALUES (832, 1412, 2, 'Klicka för att skriva ut');
INSERT INTO `lang_definitions` VALUES (833, 1413, 2, 'Klicka för att lägga till/ta emot ny lot');
INSERT INTO `lang_definitions` VALUES (834, 1414, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (835, 1415, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (836, 1416, 2, 'Klicka för att välja en industristandard kod för denna åtgärd');
INSERT INTO `lang_definitions` VALUES (837, 1418, 2, 'Klicka för att välja valbar åtgärdskod');
INSERT INTO `lang_definitions` VALUES (838, 1420, 2, 'Klicka för att välja eller byta CVX kod');
INSERT INTO `lang_definitions` VALUES (839, 1421, 2, 'Klicka för att välja eller ändra diagnoser');
INSERT INTO `lang_definitions` VALUES (840, 1422, 2, 'Klicka för att välja eller ändra tjänst kod');
INSERT INTO `lang_definitions` VALUES (841, 1423, 2, 'Klicka för att välja patient');
INSERT INTO `lang_definitions` VALUES (842, 1424, 2, 'Klicka för att välja tillhörande kod');
INSERT INTO `lang_definitions` VALUES (843, 1425, 2, 'Klicka för att välja tjänster att utföra om resultatet är avvikande');
INSERT INTO `lang_definitions` VALUES (844, 1426, 2, 'Klicka för att välja önskad åtgärd');
INSERT INTO `lang_definitions` VALUES (845, 1428, 2, 'Klicka för att sortera');
INSERT INTO `lang_definitions` VALUES (846, 1429, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (847, 1430, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (848, 1431, 2, 'Klicka för visa/redigera');
INSERT INTO `lang_definitions` VALUES (849, 1432, 2, 'Klicka Uppdatera knappen för att uppdatera databasutgåvan från följande datum');
INSERT INTO `lang_definitions` VALUES (850, 1434, 2, 'Klicka på:');
INSERT INTO `lang_definitions` VALUES (851, 1437, 2, 'Kund certifikat utgångsdatum');
INSERT INTO `lang_definitions` VALUES (852, 1438, 2, 'kund certifikat giltighetsperiod');
INSERT INTO `lang_definitions` VALUES (853, 1439, 2, 'Kundcertifikats giltighet ska vara ett giltigt nummer');
INSERT INTO `lang_definitions` VALUES (854, 1440, 2, 'kund kopia');
INSERT INTO `lang_definitions` VALUES (855, 1442, 2, 'Sammanfattning av kundens sjukdomshistoria');
INSERT INTO `lang_definitions` VALUES (856, 1443, 2, 'Kund namn');
INSERT INTO `lang_definitions` VALUES (857, 1444, 2, 'Kund nummer');
INSERT INTO `lang_definitions` VALUES (858, 1445, 2, 'Kundprofil - Ny kund');
INSERT INTO `lang_definitions` VALUES (859, 1446, 2, 'Kundprofil - Unika kunder');
INSERT INTO `lang_definitions` VALUES (860, 1447, 2, 'Kunder');
INSERT INTO `lang_definitions` VALUES (861, 1448, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (862, 1449, 2, 'Klinik kopiera');
INSERT INTO `lang_definitions` VALUES (863, 1450, 2, 'Kliniken Daily Record');
INSERT INTO `lang_definitions` VALUES (864, 1451, 2, 'Klinik ID');
INSERT INTO `lang_definitions` VALUES (865, 1452, 2, 'Klinisk');
INSERT INTO `lang_definitions` VALUES (866, 1453, 2, 'Kliniskt beslutsstöd Påminnelsehantering');
INSERT INTO `lang_definitions` VALUES (867, 1454, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (868, 1457, 2, 'Klinisk planering');
INSERT INTO `lang_definitions` VALUES (869, 1458, 2, 'Kliniska kvalitetskrav');
INSERT INTO `lang_definitions` VALUES (870, 1461, 2, 'Klinikens påminnelser');
INSERT INTO `lang_definitions` VALUES (871, 1463, 2, 'Klinikens rapporter');
INSERT INTO `lang_definitions` VALUES (872, 1464, 2, 'Kliniskt beslutsstöd Kategorier');
INSERT INTO `lang_definitions` VALUES (873, 1465, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (874, 1466, 2, 'Kliniskt beslutsstöd Urvalsfunktioner');
INSERT INTO `lang_definitions` VALUES (875, 1467, 2, 'Kliniskt beslutsstöd Mål metoder');
INSERT INTO `lang_definitions` VALUES (876, 1468, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (877, 1469, 2, 'Kliniskt beslutsstöd ålders intervaller');
INSERT INTO `lang_definitions` VALUES (878, 1470, 2, 'Kliniskt beslutsstöd jämförelser');
INSERT INTO `lang_definitions` VALUES (879, 1471, 2, 'Kliniskt beslutsstöd Typer av besök');
INSERT INTO `lang_definitions` VALUES (880, 1472, 2, 'Kliniskt beslutsstöd Påminnelser giltighet inställningar');
INSERT INTO `lang_definitions` VALUES (881, 1473, 2, 'Kliniskt beslutsstöd Påminnelser inaktiveringsinställningar');
INSERT INTO `lang_definitions` VALUES (882, 1474, 2, 'Kliniskt beslutsstöd påminnelser intervaller');
INSERT INTO `lang_definitions` VALUES (883, 1475, 2, 'Kliniskt beslutsstöd påminnelser metoder');
INSERT INTO `lang_definitions` VALUES (884, 1476, 2, 'Kliniskt beslutsstöd Mål intervaller');
INSERT INTO `lang_definitions` VALUES (885, 1477, 2, 'Kliniska mål');
INSERT INTO `lang_definitions` VALUES (886, 1478, 2, 'Kliniskt begrepp');
INSERT INTO `lang_definitions` VALUES (887, 1479, 2, 'Kliniska begrepp koder');
INSERT INTO `lang_definitions` VALUES (888, 1481, 2, 'Kliniskt verksamma');
INSERT INTO `lang_definitions` VALUES (889, 1482, 2, 'Kopiera');
INSERT INTO `lang_definitions` VALUES (890, 1483, 2, 'Kopiera tidigare besök');
INSERT INTO `lang_definitions` VALUES (891, 1484, 2, 'Stäng');
INSERT INTO `lang_definitions` VALUES (892, 1491, 2, 'Stäng fönstret');
INSERT INTO `lang_definitions` VALUES (893, 1493, 2, 'Stängt');
INSERT INTO `lang_definitions` VALUES (894, 1494, 2, 'cm');
INSERT INTO `lang_definitions` VALUES (895, 1496, 2, 'CMS 1500 marginal');
INSERT INTO `lang_definitions` VALUES (896, 1503, 2, 'CMS-id');
INSERT INTO `lang_definitions` VALUES (897, 1517, 2, 'CN2-12 intakta');
INSERT INTO `lang_definitions` VALUES (898, 1520, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (899, 1521, 2, 'Medbetalare Betalning');
INSERT INTO `lang_definitions` VALUES (900, 1523, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (901, 1525, 2, 'Kod');
INSERT INTO `lang_definitions` VALUES (902, 1526, 2, 'kod');
INSERT INTO `lang_definitions` VALUES (903, 1527, 2, 'Kodsökare');
INSERT INTO `lang_definitions` VALUES (904, 1528, 2, 'Kod måste vara två bokstäver (små bokstäver)');
INSERT INTO `lang_definitions` VALUES (905, 1529, 2, 'Kod eller symbol för att ange valuta');
INSERT INTO `lang_definitions` VALUES (906, 1530, 2, 'Kod text');
INSERT INTO `lang_definitions` VALUES (907, 1532, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (908, 1535, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (909, 1536, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (910, 1537, 2, 'Kodad');
INSERT INTO `lang_definitions` VALUES (911, 1538, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (912, 1539, 2, 'Kodning');
INSERT INTO `lang_definitions` VALUES (913, 1541, 2, 'Kodning – alla besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (914, 1543, 2, 'Kodning – mina besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (915, 1548, 2, 'Kodning ej godkänd');
INSERT INTO `lang_definitions` VALUES (916, 1549, 2, 'Kaffe');
INSERT INTO `lang_definitions` VALUES (917, 1552, 2, 'Med-försäkring');
INSERT INTO `lang_definitions` VALUES (918, 1553, 2, 'Förf.saml w / o');
INSERT INTO `lang_definitions` VALUES (919, 1555, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (920, 1556, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (921, 1557, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (922, 1558, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (923, 1559, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (924, 1561, 2, 'samlings datum');
INSERT INTO `lang_definitions` VALUES (925, 1562, 2, 'Samlingar');
INSERT INTO `lang_definitions` VALUES (926, 1563, 2, 'Samlingsrapport');
INSERT INTO `lang_definitions` VALUES (927, 1564, 2, 'Koloncancer');
INSERT INTO `lang_definitions` VALUES (928, 1565, 2, 'Koloncancer screening');
INSERT INTO `lang_definitions` VALUES (929, 1566, 2, 'Koloncancer Kirurgi');
INSERT INTO `lang_definitions` VALUES (930, 1567, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (931, 1568, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (932, 1569, 2, 'Färg');
INSERT INTO `lang_definitions` VALUES (933, 1575, 2, 'Färg förkortning');
INSERT INTO `lang_definitions` VALUES (934, 1576, 2, 'Kolumn');
INSERT INTO `lang_definitions` VALUES (935, 1577, 2, 'Kolumner');
INSERT INTO `lang_definitions` VALUES (936, 1579, 2, 'Slå ihop grupper');
INSERT INTO `lang_definitions` VALUES (937, 1580, 2, 'Komma');
INSERT INTO `lang_definitions` VALUES (938, 1581, 2, 'Kommentar');
INSERT INTO `lang_definitions` VALUES (939, 1582, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (940, 1583, 2, 'Kommentarer om detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (941, 1584, 2, 'Commercial Insurance Co');
INSERT INTO `lang_definitions` VALUES (942, 1585, 2, 'Godkänn Ändringar');
INSERT INTO `lang_definitions` VALUES (943, 1588, 2, 'Förbindelser');
INSERT INTO `lang_definitions` VALUES (944, 1591, 2, 'Företag');
INSERT INTO `lang_definitions` VALUES (945, 1592, 2, 'Företag namn');
INSERT INTO `lang_definitions` VALUES (946, 1593, 2, 'Komplett');
INSERT INTO `lang_definitions` VALUES (947, 1595, 2, 'Avslutat');
INSERT INTO `lang_definitions` VALUES (948, 1598, 2, 'Klar?');
INSERT INTO `lang_definitions` VALUES (949, 1601, 2, 'Komplikationer orsakade av vårdgivare');
INSERT INTO `lang_definitions` VALUES (950, 1602, 2, 'Abortkomplikationer');
INSERT INTO `lang_definitions` VALUES (951, 1603, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (952, 1608, 2, 'Datorstödd Medicinskt beställningssystem');
INSERT INTO `lang_definitions` VALUES (953, 1609, 2, 'Slutsatser');
INSERT INTO `lang_definitions` VALUES (954, 1614, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (955, 1615, 2, 'Inställningar import/export');
INSERT INTO `lang_definitions` VALUES (956, 1617, 2, 'Konfigurera Apache och open EMR för att använda klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (957, 1618, 2, 'Konfigurera Apache att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (958, 1619, 2, 'Konfigurera apache för att använda HTTPS');
INSERT INTO `lang_definitions` VALUES (959, 1620, 2, 'Konfigurera openEMR för att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (960, 1624, 2, 'Bekräfta Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (961, 1626, 2, 'Bekräfta Nytt lösenord');
INSERT INTO `lang_definitions` VALUES (962, 1627, 2, 'Bekräfta Betalning');
INSERT INTO `lang_definitions` VALUES (963, 1634, 2, 'Medfödd');
INSERT INTO `lang_definitions` VALUES (964, 1635, 2, 'Konjunktiva, pupiller');
INSERT INTO `lang_definitions` VALUES (965, 1638, 2, 'Sammanbindningar');
INSERT INTO `lang_definitions` VALUES (966, 1639, 2, 'Konstant');
INSERT INTO `lang_definitions` VALUES (967, 1640, 2, 'Konstant namn');
INSERT INTO `lang_definitions` VALUES (968, 1641, 2, 'Konstantnamn är tomt');
INSERT INTO `lang_definitions` VALUES (969, 1642, 2, 'Konstanter');
INSERT INTO `lang_definitions` VALUES (970, 1643, 2, 'Förstoppning');
INSERT INTO `lang_definitions` VALUES (971, 1644, 2, 'Konstitutionella');
INSERT INTO `lang_definitions` VALUES (972, 1647, 2, 'Konsultation, kortfattad beskrivning');
INSERT INTO `lang_definitions` VALUES (973, 1648, 2, 'Kontakt');
INSERT INTO `lang_definitions` VALUES (974, 1649, 2, 'E-postadress');
INSERT INTO `lang_definitions` VALUES (975, 1650, 2, 'Epostadresser');
INSERT INTO `lang_definitions` VALUES (976, 1651, 2, 'Kontakta EMR direkt för att prenumerera på phiMail Direct meddelande service');
INSERT INTO `lang_definitions` VALUES (977, 1652, 2, 'Kontaktinformation');
INSERT INTO `lang_definitions` VALUES (978, 1655, 2, 'Kontaktlinser');
INSERT INTO `lang_definitions` VALUES (979, 1656, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.');
INSERT INTO `lang_definitions` VALUES (980, 1657, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (981, 1660, 2, 'Kontaktnamn');
INSERT INTO `lang_definitions` VALUES (982, 1663, 2, 'Kontaktperson');
INSERT INTO `lang_definitions` VALUES (983, 1665, 2, 'Kontakttelefonnummer');
INSERT INTO `lang_definitions` VALUES (984, 1667, 2, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (985, 1669, 2, 'Innehåller minst tre av följande fyra enheter:');
INSERT INTO `lang_definitions` VALUES (986, 1670, 2, 'Behållare Gruppnamn');
INSERT INTO `lang_definitions` VALUES (987, 1671, 2, 'Innehåll');
INSERT INTO `lang_definitions` VALUES (988, 1672, 2, 'innehåll');
INSERT INTO `lang_definitions` VALUES (989, 1674, 2, 'Sammanhang');
INSERT INTO `lang_definitions` VALUES (990, 1675, 2, 'Sammanhangsnamn kan inte vara tomt');
INSERT INTO `lang_definitions` VALUES (991, 1676, 2, 'Fortsätt');
INSERT INTO `lang_definitions` VALUES (992, 1677, 2, 'Vårdplanerings dokument');
INSERT INTO `lang_definitions` VALUES (993, 1678, 2, 'Vårdplanering');
INSERT INTO `lang_definitions` VALUES (994, 1679, 2, 'kontraindikationer');
INSERT INTO `lang_definitions` VALUES (995, 1680, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (996, 1681, 2, 'Preventivmedelsproblematik');
INSERT INTO `lang_definitions` VALUES (997, 1682, 2, 'Preventivmedelsproblematik (specificera)');
INSERT INTO `lang_definitions` VALUES (998, 1683, 2, 'Preventivmedel Metod');
INSERT INTO `lang_definitions` VALUES (999, 1684, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1000, 1685, 2, 'Preventivmedel, tjänster som tidigare startats');
INSERT INTO `lang_definitions` VALUES (1001, 1686, 2, 'Preventivmedel start');
INSERT INTO `lang_definitions` VALUES (1002, 1691, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1003, 1692, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1004, 1700, 2, 'medbetalare');
INSERT INTO `lang_definitions` VALUES (1005, 1701, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1006, 1702, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1007, 1703, 2, 'medbetalare nekar');
INSERT INTO `lang_definitions` VALUES (1008, 1705, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1009, 1706, 2, 'COPD');
INSERT INTO `lang_definitions` VALUES (1010, 1707, 2, 'Kopiera Sidor till Patientdiagram');
INSERT INTO `lang_definitions` VALUES (1011, 1709, 2, 'Kopiera Värderingar');
INSERT INTO `lang_definitions` VALUES (1012, 1710, 2, 'Kopiera databasfilen. Detta tar en stund...');
INSERT INTO `lang_definitions` VALUES (1013, 1711, 2, 'Upphovsrättsskydd');
INSERT INTO `lang_definitions` VALUES (1014, 1716, 2, 'Coronary Artery Bypass');
INSERT INTO `lang_definitions` VALUES (1015, 1717, 2, 'Coronary Artery Bypass Graft (CABG)');
INSERT INTO `lang_definitions` VALUES (1016, 1718, 2, 'Rättad');
INSERT INTO `lang_definitions` VALUES (1017, 1720, 2, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (1018, 1721, 2, 'Kunde inte ansluta till CouchDB');
INSERT INTO `lang_definitions` VALUES (1019, 1722, 2, 'CouchDB databas');
INSERT INTO `lang_definitions` VALUES (1020, 1723, 2, 'CouchDB databas namn');
INSERT INTO `lang_definitions` VALUES (1021, 1724, 2, 'CouchDB värd');
INSERT INTO `lang_definitions` VALUES (1022, 1725, 2, 'CouchDB värdnamn');
INSERT INTO `lang_definitions` VALUES (1023, 1726, 2, 'CouchDB log på');
INSERT INTO `lang_definitions` VALUES (1024, 1727, 2, 'CouchDB lösenord');
INSERT INTO `lang_definitions` VALUES (1025, 1728, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1026, 1729, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1027, 1731, 2, 'CouchDB användarnamn');
INSERT INTO `lang_definitions` VALUES (1028, 1732, 2, 'Hosta');
INSERT INTO `lang_definitions` VALUES (1029, 1733, 2, 'Hosta:');
INSERT INTO `lang_definitions` VALUES (1030, 1738, 2, 'Kunde ej läsa fil');
INSERT INTO `lang_definitions` VALUES (1031, 1740, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1032, 1742, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1033, 1743, 2, 'Kunde inte skapa backup');
INSERT INTO `lang_definitions` VALUES (1034, 1744, 2, 'Kunde inte ta bort mapp');
INSERT INTO `lang_definitions` VALUES (1035, 1745, 2, 'Kunde inte ta bort gammal backup fil');
INSERT INTO `lang_definitions` VALUES (1036, 1746, 2, 'Kunde inte ta bort gammal export fil');
INSERT INTO `lang_definitions` VALUES (1037, 1747, 2, 'Waran INR kontroll');
INSERT INTO `lang_definitions` VALUES (1038, 1748, 2, 'Couns av metod');
INSERT INTO `lang_definitions` VALUES (1039, 1749, 2, 'Rådgivning');
INSERT INTO `lang_definitions` VALUES (1040, 1750, 2, 'Rådgivning, Aktivitet');
INSERT INTO `lang_definitions` VALUES (1041, 1753, 2, 'svarsremiss, formulär');
INSERT INTO `lang_definitions` VALUES (1042, 1754, 2, 'Nation');
INSERT INTO `lang_definitions` VALUES (1043, 1755, 2, 'Land');
INSERT INTO `lang_definitions` VALUES (1044, 1757, 2, 'Typ av nationsdata');
INSERT INTO `lang_definitions` VALUES (1045, 1758, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1046, 1759, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1047, 1761, 2, 'Nationsnamn ska representeras av två bokstäver');
INSERT INTO `lang_definitions` VALUES (1048, 1762, 2, 'Landsting');
INSERT INTO `lang_definitions` VALUES (1049, 1764, 2, 'kupong');
INSERT INTO `lang_definitions` VALUES (1050, 1768, 2, 'CPT');
INSERT INTO `lang_definitions` VALUES (1051, 1769, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1052, 1770, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1053, 1771, 2, 'CPT4 Åtgärder/Tjänster');
INSERT INTO `lang_definitions` VALUES (1054, 1772, 2, 'CPTII Mått på utförande');
INSERT INTO `lang_definitions` VALUES (1055, 1773, 2, 'Kvalitetscertifikat (GCP)');
INSERT INTO `lang_definitions` VALUES (1056, 1774, 2, 'Sprickor:');
INSERT INTO `lang_definitions` VALUES (1057, 1777, 2, 'kräm');
INSERT INTO `lang_definitions` VALUES (1058, 1778, 2, 'Skapa klient certifikat SSL för varje användare eller dator');
INSERT INTO `lang_definitions` VALUES (1059, 1779, 2, 'Skapa klientcertifikat för antingen användare eller datornamn');
INSERT INTO `lang_definitions` VALUES (1060, 1782, 2, 'Skapa en händelse');
INSERT INTO `lang_definitions` VALUES (1061, 1783, 2, 'Skapa och ladda ner en fullständig backup');
INSERT INTO `lang_definitions` VALUES (1062, 1785, 2, 'Skapa beackup');
INSERT INTO `lang_definitions` VALUES (1063, 1786, 2, 'Skapa grupp');
INSERT INTO `lang_definitions` VALUES (1064, 1787, 2, 'Skapa kientcertifikat');
INSERT INTO `lang_definitions` VALUES (1065, 1788, 2, 'Skapa klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (1066, 1791, 2, 'Skapa kopia');
INSERT INTO `lang_definitions` VALUES (1067, 1793, 2, 'Skapa backup av händelselog');
INSERT INTO `lang_definitions` VALUES (1068, 1794, 2, 'Skapa ny aktivitet');
INSERT INTO `lang_definitions` VALUES (1069, 1795, 2, 'Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (1070, 1797, 2, 'Skapa externa port rättigheter');
INSERT INTO `lang_definitions` VALUES (1071, 1798, 2, 'Skapa interna port rättigheter');
INSERT INTO `lang_definitions` VALUES (1072, 1799, 2, 'Skapa Patientanteckning');
INSERT INTO `lang_definitions` VALUES (1073, 1800, 2, 'Skapa SSL certifikat utgivare och server certifikat');
INSERT INTO `lang_definitions` VALUES (1074, 1801, 2, 'Skapa besök');
INSERT INTO `lang_definitions` VALUES (1075, 1802, 2, 'Skapad');
INSERT INTO `lang_definitions` VALUES (1076, 1804, 2, 'Skapa exportfil');
INSERT INTO `lang_definitions` VALUES (1077, 1806, 2, 'Skapande av fil på värden misslyckades');
INSERT INTO `lang_definitions` VALUES (1078, 1807, 2, 'Skapare');
INSERT INTO `lang_definitions` VALUES (1079, 1808, 2, 'kredit');
INSERT INTO `lang_definitions` VALUES (1080, 1809, 2, 'Kreditkort');
INSERT INTO `lang_definitions` VALUES (1081, 1810, 2, 'Kredit');
INSERT INTO `lang_definitions` VALUES (1082, 1812, 2, 'Kriterier');
INSERT INTO `lang_definitions` VALUES (1083, 1814, 2, 'Crohn\'s sjukdom');
INSERT INTO `lang_definitions` VALUES (1084, 1815, 2, 'Chrons sjukdom');
INSERT INTO `lang_definitions` VALUES (1085, 1818, 2, 'export av kommaseparerad lista');
INSERT INTO `lang_definitions` VALUES (1086, 1819, 2, 'Kommaseparerad fil');
INSERT INTO `lang_definitions` VALUES (1087, 1820, 2, 'Kommaseparerad tabell');
INSERT INTO `lang_definitions` VALUES (1088, 1824, 2, 'Kubikmillimeter');
INSERT INTO `lang_definitions` VALUES (1089, 1825, 2, 'Kuban');
INSERT INTO `lang_definitions` VALUES (1090, 1827, 2, 'Valuta decimaler');
INSERT INTO `lang_definitions` VALUES (1091, 1828, 2, 'Valuta decimaltecken');
INSERT INTO `lang_definitions` VALUES (1092, 1829, 2, 'Valutatecken');
INSERT INTO `lang_definitions` VALUES (1093, 1830, 2, 'Valuta tusenseparator');
INSERT INTO `lang_definitions` VALUES (1094, 1831, 2, 'Pågående');
INSERT INTO `lang_definitions` VALUES (1095, 1832, 2, 'Alkohol aktuellt');
INSERT INTO `lang_definitions` VALUES (1096, 1833, 2, 'Pågående konsultation');
INSERT INTO `lang_definitions` VALUES (1097, 1834, 2, 'Aktuella kriterier');
INSERT INTO `lang_definitions` VALUES (1098, 1835, 2, 'Markeringsfärg för aktuell dag');
INSERT INTO `lang_definitions` VALUES (1099, 1836, 2, 'Röker dagligen');
INSERT INTO `lang_definitions` VALUES (1100, 1838, 2, 'Nuvarande filnamn är ändrat till');
INSERT INTO `lang_definitions` VALUES (1101, 1840, 2, 'Använder hash');
INSERT INTO `lang_definitions` VALUES (1102, 1841, 2, 'Nuvarande lokalisation');
INSERT INTO `lang_definitions` VALUES (1103, 1843, 2, 'Aktuell medicinering');
INSERT INTO `lang_definitions` VALUES (1104, 1844, 2, 'Aktuellt lösenord');
INSERT INTO `lang_definitions` VALUES (1105, 1845, 2, 'Pågående patient');
INSERT INTO `lang_definitions` VALUES (1106, 1849, 2, 'Aktuella droger');
INSERT INTO `lang_definitions` VALUES (1107, 1851, 2, 'Tillfällighetsrökare');
INSERT INTO `lang_definitions` VALUES (1108, 1857, 2, 'För närvarande Aktiv');
INSERT INTO `lang_definitions` VALUES (1109, 1860, 2, 'Pågår');
INSERT INTO `lang_definitions` VALUES (1110, 1861, 2, 'Ingen aktuell klinik');
INSERT INTO `lang_definitions` VALUES (1111, 1863, 2, 'Cushing Syndrom');
INSERT INTO `lang_definitions` VALUES (1112, 1864, 2, 'Cushings syndrom');
INSERT INTO `lang_definitions` VALUES (1113, 1867, 2, 'Anpassad');
INSERT INTO `lang_definitions` VALUES (1114, 1870, 2, 'Anpassat input');
INSERT INTO `lang_definitions` VALUES (1115, 1872, 2, 'Anpassad tabell');
INSERT INTO `lang_definitions` VALUES (1116, 1876, 2, 'CVX kod');
INSERT INTO `lang_definitions` VALUES (1117, 1877, 2, 'CVX kod koppling');
INSERT INTO `lang_definitions` VALUES (1118, 1878, 2, 'CVX vaccination');
INSERT INTO `lang_definitions` VALUES (1119, 1886, 2, 'CYP');
INSERT INTO `lang_definitions` VALUES (1120, 1887, 2, 'CYP Factor');
INSERT INTO `lang_definitions` VALUES (1121, 1888, 2, 'CYP Rapport');
INSERT INTO `lang_definitions` VALUES (1122, 1889, 2, 'Tjeckisk');
INSERT INTO `lang_definitions` VALUES (1123, 1890, 2, 'D');
INSERT INTO `lang_definitions` VALUES (1124, 1891, 2, 'D & C');
INSERT INTO `lang_definitions` VALUES (1125, 1892, 2, 'D & E');
INSERT INTO `lang_definitions` VALUES (1126, 1894, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1127, 1895, 2, 'dagligen');
INSERT INTO `lang_definitions` VALUES (1128, 1896, 2, 'Daglig registrering');
INSERT INTO `lang_definitions` VALUES (1129, 1899, 2, 'dansk');
INSERT INTO `lang_definitions` VALUES (1130, 1901, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1131, 1902, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1132, 1903, 2, 'Data kolumner');
INSERT INTO `lang_definitions` VALUES (1133, 1906, 2, 'Data fel');
INSERT INTO `lang_definitions` VALUES (1134, 1910, 2, 'Datattyp');
INSERT INTO `lang_definitions` VALUES (1135, 1911, 2, 'Databas');
INSERT INTO `lang_definitions` VALUES (1136, 1912, 2, 'Databas är inte installerad');
INSERT INTO `lang_definitions` VALUES (1137, 1914, 2, 'databas revision');
INSERT INTO `lang_definitions` VALUES (1138, 1915, 2, 'Databasrapportering');
INSERT INTO `lang_definitions` VALUES (1139, 1917, 2, 'Uppdatering av databas avslutad');
INSERT INTO `lang_definitions` VALUES (1140, 1918, 2, 'Datacols måste ha ett nummer mellan 1 och 999');
INSERT INTO `lang_definitions` VALUES (1141, 1919, 2, 'Datum');
INSERT INTO `lang_definitions` VALUES (1142, 1920, 2, 'DATUM');
INSERT INTO `lang_definitions` VALUES (1143, 1921, 2, 'Hantering av datum och tid');
INSERT INTO `lang_definitions` VALUES (1144, 1923, 2, 'Administreringsdatum');
INSERT INTO `lang_definitions` VALUES (1145, 1924, 2, 'datum och tid för insamling');
INSERT INTO `lang_definitions` VALUES (1146, 1925, 2, 'datum och tid för observation');
INSERT INTO `lang_definitions` VALUES (1147, 1927, 2, 'Datum och tid när provet togs');
INSERT INTO `lang_definitions` VALUES (1148, 1928, 2, 'datum kan inte vara senare än idag');
INSERT INTO `lang_definitions` VALUES (1149, 1929, 2, 'Datum då preventivmeddel insattes för första gången');
INSERT INTO `lang_definitions` VALUES (1150, 1930, 2, 'Skapat datum');
INSERT INTO `lang_definitions` VALUES (1151, 1931, 2, 'Datum avslutad');
INSERT INTO `lang_definitions` VALUES (1152, 1932, 2, 'Förstörd datum');
INSERT INTO `lang_definitions` VALUES (1153, 1933, 2, 'Sätt att visa datum');
INSERT INTO `lang_definitions` VALUES (1154, 1934, 2, 'Datumformat för \"mötet slutar\" är inte giltigt');
INSERT INTO `lang_definitions` VALUES (1155, 1935, 2, 'Datumformat för \"mötet startat \"är inte giltig');
INSERT INTO `lang_definitions` VALUES (1156, 1936, 2, 'Datumformat för \"Nästa Möte\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1157, 1937, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1158, 1939, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1159, 1940, 2, 'Datum för vaccinationsinformation');
INSERT INTO `lang_definitions` VALUES (1160, 1941, 2, 'Datum saknas för kod');
INSERT INTO `lang_definitions` VALUES (1161, 1942, 2, 'Huvudsakligt kriterium för datum');
INSERT INTO `lang_definitions` VALUES (1162, 1945, 2, 'Datum för bankinsättning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1163, 1946, 2, 'datum för fakturering');
INSERT INTO `lang_definitions` VALUES (1164, 1947, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1165, 1948, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1166, 1949, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1167, 1951, 2, 'datum för registrering');
INSERT INTO `lang_definitions` VALUES (1168, 1953, 2, 'Datum för skada');
INSERT INTO `lang_definitions` VALUES (1169, 1957, 2, 'Datum för betalning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1170, 1959, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (1171, 1961, 2, 'Svarsdatum');
INSERT INTO `lang_definitions` VALUES (1172, 1962, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1173, 1963, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1174, 1965, 2, 'Datum för tjänst');
INSERT INTO `lang_definitions` VALUES (1175, 1966, 2, 'datum för tjänsten = idag');
INSERT INTO `lang_definitions` VALUES (1176, 1967, 2, 'Datum för tjänst MM / DD / ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1177, 1968, 2, 'Datum för tjänst:');
INSERT INTO `lang_definitions` VALUES (1178, 1969, 2, 'datum för signering');
INSERT INTO `lang_definitions` VALUES (1179, 1970, 2, 'datum för förändrat status');
INSERT INTO `lang_definitions` VALUES (1180, 1972, 2, 'Orderdatum');
INSERT INTO `lang_definitions` VALUES (1181, 1973, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1182, 1974, 2, 'Datum för VIS deklaration');
INSERT INTO `lang_definitions` VALUES (1183, 1975, 2, 'datum beställd');
INSERT INTO `lang_definitions` VALUES (1184, 1978, 2, 'Val av datum');
INSERT INTO `lang_definitions` VALUES (1185, 1979, 2, 'Skickat datum');
INSERT INTO `lang_definitions` VALUES (1186, 1980, 2, 'Datum då meddelande skickades');
INSERT INTO `lang_definitions` VALUES (1187, 1982, 2, 'datumvärde kan inte vara tomt.');
INSERT INTO `lang_definitions` VALUES (1188, 1985, 2, 'datum/planerat besök');
INSERT INTO `lang_definitions` VALUES (1189, 1986, 2, 'Datum/anteckningar');
INSERT INTO `lang_definitions` VALUES (1190, 1987, 2, 'Datum / Anteckningar, senast');
INSERT INTO `lang_definitions` VALUES (1191, 1988, 2, 'datum/tid');
INSERT INTO `lang_definitions` VALUES (1192, 1989, 2, 'Datum:');
INSERT INTO `lang_definitions` VALUES (1193, 1991, 2, 'Daterad meddelande log');
INSERT INTO `lang_definitions` VALUES (1194, 1993, 2, 'Dag');
INSERT INTO `lang_definitions` VALUES (1195, 1994, 2, 'dag');
INSERT INTO `lang_definitions` VALUES (1196, 1996, 2, 'Överblick dag');
INSERT INTO `lang_definitions` VALUES (1197, 1997, 2, 'Dag (ar)');
INSERT INTO `lang_definitions` VALUES (1198, 1998, 2, 'Dag (ar) M-F');
INSERT INTO `lang_definitions` VALUES (1199, 1999, 2, 'dagar');
INSERT INTO `lang_definitions` VALUES (1200, 2000, 2, 'Dagar');
INSERT INTO `lang_definitions` VALUES (1201, 2001, 2, 'dagar sedan');
INSERT INTO `lang_definitions` VALUES (1202, 2002, 2, 'Dagar och spel Missade');
INSERT INTO `lang_definitions` VALUES (1203, 2003, 2, 'Dagar från förra mötet');
INSERT INTO `lang_definitions` VALUES (1204, 2004, 2, 'Missade dagar');
INSERT INTO `lang_definitions` VALUES (1205, 2007, 2, 'Dagar per Kolumn:');
INSERT INTO `lang_definitions` VALUES (1206, 2009, 2, 'dagar/kolumner');
INSERT INTO `lang_definitions` VALUES (1207, 2010, 2, 'DB installerad');
INSERT INTO `lang_definitions` VALUES (1208, 2011, 2, 'DD/MM/ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1209, 2012, 2, 'Avidentifiering');
INSERT INTO `lang_definitions` VALUES (1210, 2013, 2, 'Avidentifiering komplett');
INSERT INTO `lang_definitions` VALUES (1211, 2014, 2, 'Avidentifiering pågår');
INSERT INTO `lang_definitions` VALUES (1212, 2015, 2, 'Avidentifiering påpbörjad och sker i bakgrunden');
INSERT INTO `lang_definitions` VALUES (1213, 2016, 2, 'Avidentifiering kanske inte är komplett');
INSERT INTO `lang_definitions` VALUES (1214, 2017, 2, 'Avidentifierade filer sparas i');
INSERT INTO `lang_definitions` VALUES (1215, 2018, 2, 'Läkemedelsverket (DEA)');
INSERT INTO `lang_definitions` VALUES (1216, 2021, 2, 'Döv');
INSERT INTO `lang_definitions` VALUES (1217, 2022, 2, 'Debuginformation');
INSERT INTO `lang_definitions` VALUES (1218, 2024, 2, 'Debugging');
INSERT INTO `lang_definitions` VALUES (1219, 2025, 2, 'Dec');
INSERT INTO `lang_definitions` VALUES (1220, 2026, 2, 'Avslutad');
INSERT INTO `lang_definitions` VALUES (1221, 2032, 2, 'December');
INSERT INTO `lang_definitions` VALUES (1222, 2033, 2, 'Decimal pound eller pound/ounces delas med # (ex 5#4)');
INSERT INTO `lang_definitions` VALUES (1223, 2035, 2, 'Avdragsgill');
INSERT INTO `lang_definitions` VALUES (1224, 2036, 2, 'Genomförda avdrag');
INSERT INTO `lang_definitions` VALUES (1225, 2038, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (1226, 2039, 2, 'Standard Kalender vy');
INSERT INTO `lang_definitions` VALUES (1227, 2040, 2, 'Standard Besöksformulär Id');
INSERT INTO `lang_definitions` VALUES (1228, 2042, 2, 'Standard Klinik');
INSERT INTO `lang_definitions` VALUES (1229, 2045, 2, 'Standardspråk');
INSERT INTO `lang_definitions` VALUES (1230, 2046, 2, 'Standardspråk ifall inget annat är tillåtet eller valt');
INSERT INTO `lang_definitions` VALUES (1231, 2049, 2, 'Standardlista');
INSERT INTO `lang_definitions` VALUES (1232, 2051, 2, 'Standardmetod');
INSERT INTO `lang_definitions` VALUES (1233, 2052, 2, 'Standard tid för lösenords giltighet');
INSERT INTO `lang_definitions` VALUES (1234, 2053, 2, 'Standardtid för lösenords giltighetstid. 0 innebär oändlig giltighet.');
INSERT INTO `lang_definitions` VALUES (1235, 2054, 2, 'Standard patient land');
INSERT INTO `lang_definitions` VALUES (1236, 2057, 2, 'Standard prioritet');
INSERT INTO `lang_definitions` VALUES (1237, 2058, 2, 'Standard vårdgivare');
INSERT INTO `lang_definitions` VALUES (1238, 2060, 2, 'Standard range');
INSERT INTO `lang_definitions` VALUES (1239, 2061, 2, 'Standard kontaktorsak');
INSERT INTO `lang_definitions` VALUES (1240, 2066, 2, 'Standard inställningar');
INSERT INTO `lang_definitions` VALUES (1241, 2067, 2, 'Normalt status för \'Nytt fönster\' markering i patientlistan');
INSERT INTO `lang_definitions` VALUES (1242, 2068, 2, 'Standardmall');
INSERT INTO `lang_definitions` VALUES (1243, 2074, 2, 'Standard enhet');
INSERT INTO `lang_definitions` VALUES (1244, 2075, 2, 'Standardvärde');
INSERT INTO `lang_definitions` VALUES (1245, 2077, 2, 'Standard lager');
INSERT INTO `lang_definitions` VALUES (1246, 2078, 2, 'Standard X12 Partner');
INSERT INTO `lang_definitions` VALUES (1247, 2079, 2, 'Default / Global');
INSERT INTO `lang_definitions` VALUES (1248, 2083, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1249, 2084, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1250, 2085, 2, 'Fördröjd Återkommande (> 12 mån)');
INSERT INTO `lang_definitions` VALUES (1251, 2086, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1252, 2087, 2, 'ta bort');
INSERT INTO `lang_definitions` VALUES (1253, 2088, 2, 'Radera Kategorier med ID (s):');
INSERT INTO `lang_definitions` VALUES (1254, 2089, 2, 'Radera katogori');
INSERT INTO `lang_definitions` VALUES (1255, 2092, 2, 'Kunde ej radera!');
INSERT INTO `lang_definitions` VALUES (1256, 2093, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (1257, 2094, 2, 'Ta bort lista');
INSERT INTO `lang_definitions` VALUES (1258, 2096, 2, 'Radera Sidor');
INSERT INTO `lang_definitions` VALUES (1259, 2097, 2, 'Ta bort patient, Möte, Formulär, Ämne, Dokument, Betalning, Fakturering eller transaktionstryck');
INSERT INTO `lang_definitions` VALUES (1260, 2099, 2, 'Ta bort rad');
INSERT INTO `lang_definitions` VALUES (1261, 2100, 2, 'Ta bort markerade enheter');
INSERT INTO `lang_definitions` VALUES (1262, 2103, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1263, 2104, 2, 'Radera detta dokument');
INSERT INTO `lang_definitions` VALUES (1264, 2105, 2, 'Radera detta formulär');
INSERT INTO `lang_definitions` VALUES (1265, 2107, 2, 'Radera denna anteckning');
INSERT INTO `lang_definitions` VALUES (1266, 2109, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1267, 2110, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1268, 2111, 2, 'Borttagen händelse kan inte återskapas. Är du säker på att du vill ta bort händelsen?');
INSERT INTO `lang_definitions` VALUES (1269, 2114, 2, 'Leverans bekräftad');
INSERT INTO `lang_definitions` VALUES (1270, 2116, 2, 'Leverans är inte tillåten till specificerad direkt adress.');
INSERT INTO `lang_definitions` VALUES (1271, 2118, 2, 'Leverans av bifogat kliniskt dokument var begärt av patienten');
INSERT INTO `lang_definitions` VALUES (1272, 2119, 2, 'Demens');
INSERT INTO `lang_definitions` VALUES (1273, 2121, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1274, 2122, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1275, 2125, 2, 'Demografi filter kriterier');
INSERT INTO `lang_definitions` VALUES (1276, 2127, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1277, 2128, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1278, 2129, 2, 'Nekad');
INSERT INTO `lang_definitions` VALUES (1279, 2131, 2, 'Nämnare');
INSERT INTO `lang_definitions` VALUES (1280, 2134, 2, 'Dental');
INSERT INTO `lang_definitions` VALUES (1281, 2135, 2, 'Tandvård ärende lista');
INSERT INTO `lang_definitions` VALUES (1282, 2136, 2, 'Tandvårds ärenden');
INSERT INTO `lang_definitions` VALUES (1283, 2139, 2, 'Beroende på vilken typ av räkning som testas kommer man kunna se HCFA liknande utskrift på blankt papper om HFCA-räkning testas, flera rader med blurrig text och information ifall X12-claim testas. Denna text är X12 EDI 4010A format. Ibland ser man udda konstiga tecken som liknar små figurer. Detta är kontrolltecken för sidmatning mm och det är helt normalt.');
INSERT INTO `lang_definitions` VALUES (1284, 2140, 2, 'Insättningsdatum');
INSERT INTO `lang_definitions` VALUES (1285, 2141, 2, 'Insättningsdatum kan inte vara senare än idag.');
INSERT INTO `lang_definitions` VALUES (1286, 2142, 2, 'Insättning Datum:');
INSERT INTO `lang_definitions` VALUES (1287, 2143, 2, 'Deprimerad');
INSERT INTO `lang_definitions` VALUES (1288, 2144, 2, 'Depression');
INSERT INTO `lang_definitions` VALUES (1289, 2149, 2, 'Beskrivning');
INSERT INTO `lang_definitions` VALUES (1290, 2150, 2, 'beskrivning');
INSERT INTO `lang_definitions` VALUES (1291, 2152, 2, 'Beskrivning av upptäckten');
INSERT INTO `lang_definitions` VALUES (1292, 2153, 2, 'Beskrivning av åtgärden eller resultatkod');
INSERT INTO `lang_definitions` VALUES (1293, 2154, 2, 'Beskrivning översättning');
INSERT INTO `lang_definitions` VALUES (1294, 2156, 2, 'Mål');
INSERT INTO `lang_definitions` VALUES (1295, 2157, 2, 'Målfilnamn');
INSERT INTO `lang_definitions` VALUES (1296, 2158, 2, 'Förstör Parti');
INSERT INTO `lang_definitions` VALUES (1297, 2159, 2, 'Förstör ...');
INSERT INTO `lang_definitions` VALUES (1298, 2160, 2, 'Förstörd');
INSERT INTO `lang_definitions` VALUES (1299, 2161, 2, 'Förstörda läkemedel');
INSERT INTO `lang_definitions` VALUES (1300, 2162, 2, 'Förstöras narkotika Rapport');
INSERT INTO `lang_definitions` VALUES (1301, 2163, 2, 'Detalj');
INSERT INTO `lang_definitions` VALUES (1302, 2167, 2, 'Detaljer');
INSERT INTO `lang_definitions` VALUES (1303, 2169, 2, 'Utvecklingsstörning');
INSERT INTO `lang_definitions` VALUES (1304, 2171, 2, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (1305, 2172, 2, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (1306, 2173, 2, 'Diabetes: Blodtryckskontroll');
INSERT INTO `lang_definitions` VALUES (1307, 2174, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1308, 2175, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1309, 2176, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1310, 2177, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1311, 2178, 2, 'Diabetes: HbA1c dåligt reglerat');
INSERT INTO `lang_definitions` VALUES (1312, 2179, 2, 'Diabetes: HbA1c');
INSERT INTO `lang_definitions` VALUES (1313, 2180, 2, 'Diabetes: Blodfetter');
INSERT INTO `lang_definitions` VALUES (1314, 2181, 2, 'Diabetes: Urin microalbumin');
INSERT INTO `lang_definitions` VALUES (1315, 2182, 2, 'Diag');
INSERT INTO `lang_definitions` VALUES (1316, 2183, 2, 'Diagnoser');
INSERT INTO `lang_definitions` VALUES (1317, 2184, 2, 'Diagnos');
INSERT INTO `lang_definitions` VALUES (1318, 2185, 2, 'Diagnoskod');
INSERT INTO `lang_definitions` VALUES (1319, 2187, 2, 'Diagnos datum');
INSERT INTO `lang_definitions` VALUES (1320, 2188, 2, 'Diagnos måste kodas in i ett länkat patientmöte');
INSERT INTO `lang_definitions` VALUES (1321, 2189, 2, 'Diagnos namn');
INSERT INTO `lang_definitions` VALUES (1322, 2190, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1323, 2191, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1324, 2192, 2, 'Diagnos rapport enbart');
INSERT INTO `lang_definitions` VALUES (1325, 2193, 2, 'Diagnos titel');
INSERT INTO `lang_definitions` VALUES (1326, 2194, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1327, 2195, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1328, 2197, 2, 'Diagnostiska tester:');
INSERT INTO `lang_definitions` VALUES (1329, 2198, 2, 'Skala');
INSERT INTO `lang_definitions` VALUES (1330, 2201, 2, 'Membran/kapsel');
INSERT INTO `lang_definitions` VALUES (1331, 2202, 2, 'Diarée');
INSERT INTO `lang_definitions` VALUES (1332, 2204, 2, 'Diktat');
INSERT INTO `lang_definitions` VALUES (1333, 2205, 2, 'Diktat:');
INSERT INTO `lang_definitions` VALUES (1334, 2206, 2, 'Fick du en kopia av denna HIPAA notering?');
INSERT INTO `lang_definitions` VALUES (1335, 2207, 2, 'Diffus');
INSERT INTO `lang_definitions` VALUES (1336, 2208, 2, 'Digitalt signerad');
INSERT INTO `lang_definitions` VALUES (1337, 2216, 2, 'Direkt mail');
INSERT INTO `lang_definitions` VALUES (1338, 2217, 2, 'Log på direktmeddelande');
INSERT INTO `lang_definitions` VALUES (1339, 2218, 2, 'Direkt meddelande mottaget');
INSERT INTO `lang_definitions` VALUES (1340, 2219, 2, 'Direkt meddelande ej tillgängligt');
INSERT INTO `lang_definitions` VALUES (1341, 2220, 2, 'Kunde ej skicka direkt meddelande');
INSERT INTO `lang_definitions` VALUES (1342, 2222, 2, 'Arbetsledare, namn');
INSERT INTO `lang_definitions` VALUES (1343, 2223, 2, 'Kunde ej ta bort mapp. Fortsätt');
INSERT INTO `lang_definitions` VALUES (1344, 2224, 2, 'Funktionshinder');
INSERT INTO `lang_definitions` VALUES (1345, 2226, 2, 'Stäng av kalender');
INSERT INTO `lang_definitions` VALUES (1346, 2227, 2, 'Stäng av spårning av patientkort');
INSERT INTO `lang_definitions` VALUES (1347, 2228, 2, 'Stäng av vaccination');
INSERT INTO `lang_definitions` VALUES (1348, 2229, 2, 'Stäng av gammal metrisk vitala tecken formulär');
INSERT INTO `lang_definitions` VALUES (1349, 2231, 2, 'Stäng av phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (1350, 2232, 2, 'Stäng av receptförskrivning');
INSERT INTO `lang_definitions` VALUES (1351, 2233, 2, 'Stäng av användargrupp');
INSERT INTO `lang_definitions` VALUES (1352, 2234, 2, 'funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1353, 2235, 2, 'Funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1354, 2236, 2, 'Handikappad under 65 år med LGHP-försäkring');
INSERT INTO `lang_definitions` VALUES (1355, 2238, 2, 'Disk');
INSERT INTO `lang_definitions` VALUES (1356, 2241, 2, 'Utskrivning');
INSERT INTO `lang_definitions` VALUES (1357, 2242, 2, 'Flytningar från urinröret');
INSERT INTO `lang_definitions` VALUES (1358, 2244, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1359, 2245, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1360, 2248, 2, 'Utskriven');
INSERT INTO `lang_definitions` VALUES (1361, 2249, 2, 'Kvitto information');
INSERT INTO `lang_definitions` VALUES (1362, 2250, 2, 'Kvitto typ');
INSERT INTO `lang_definitions` VALUES (1363, 2251, 2, 'Kvitton typer');
INSERT INTO `lang_definitions` VALUES (1364, 2252, 2, 'Kvitton');
INSERT INTO `lang_definitions` VALUES (1365, 2255, 2, 'Rabatt');
INSERT INTO `lang_definitions` VALUES (1366, 2256, 2, 'Rabatt Belopp');
INSERT INTO `lang_definitions` VALUES (1367, 2257, 2, 'Rabatt nivå');
INSERT INTO `lang_definitions` VALUES (1368, 2258, 2, 'Rabatt procent');
INSERT INTO `lang_definitions` VALUES (1369, 2259, 2, 'Rabatt som belopp');
INSERT INTO `lang_definitions` VALUES (1370, 2260, 2, 'Rabatt vid checkout skrivs in som belopp i stället för som procent');
INSERT INTO `lang_definitions` VALUES (1371, 2261, 2, 'Diskreta resultat');
INSERT INTO `lang_definitions` VALUES (1372, 2262, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1373, 2264, 2, 'Förskjutning');
INSERT INTO `lang_definitions` VALUES (1374, 2267, 2, 'Antal:');
INSERT INTO `lang_definitions` VALUES (1375, 2268, 2, 'Skicka i väg');
INSERT INTO `lang_definitions` VALUES (1376, 2269, 2, 'Skicka mottagna dokument');
INSERT INTO `lang_definitions` VALUES (1377, 2273, 2, 'Utlämnad');
INSERT INTO `lang_definitions` VALUES (1378, 2276, 2, 'Visa avancerade inställningar på demografisidan');
INSERT INTO `lang_definitions` VALUES (1379, 2278, 2, 'Visa händelsedatum i blocket?');
INSERT INTO `lang_definitions` VALUES (1380, 2279, 2, 'Visa format får US vikter?');
INSERT INTO `lang_definitions` VALUES (1381, 2280, 2, 'Visa hur många händelser?');
INSERT INTO `lang_definitions` VALUES (1382, 2283, 2, 'Visa plats i blocket?');
INSERT INTO `lang_definitions` VALUES (1383, 2284, 2, 'Visa namn');
INSERT INTO `lang_definitions` VALUES (1384, 2286, 2, 'Visa kalender?');
INSERT INTO `lang_definitions` VALUES (1385, 2293, 2, 'Display dagens händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1386, 2294, 2, 'Visa ämne i blocket?');
INSERT INTO `lang_definitions` VALUES (1387, 2295, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1388, 2296, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1389, 2297, 2, 'Visa följande antal av de senaste meddelandena.');
INSERT INTO `lang_definitions` VALUES (1390, 2298, 2, 'Visa följande antal av senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1391, 2299, 2, 'Visa följande antal av de senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1392, 2303, 2, 'Distrubition');
INSERT INTO `lang_definitions` VALUES (1393, 2304, 2, 'Distribution');
INSERT INTO `lang_definitions` VALUES (1394, 2305, 2, 'Leverantör');
INSERT INTO `lang_definitions` VALUES (1395, 2310, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1396, 2311, 2, 'Divertikulit kirurgi');
INSERT INTO `lang_definitions` VALUES (1397, 2312, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1398, 2313, 2, 'Divertikulit Kirurgi');
INSERT INTO `lang_definitions` VALUES (1399, 2314, 2, 'Skild');
INSERT INTO `lang_definitions` VALUES (1400, 2315, 2, 'Yrsel:');
INSERT INTO `lang_definitions` VALUES (1401, 2317, 2, 'Ändra inte');
INSERT INTO `lang_definitions` VALUES (1402, 2319, 2, 'Visa inte Allergi uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1403, 2321, 2, 'Visa inte medicinering uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1404, 2324, 2, 'Visa inte kalender');
INSERT INTO `lang_definitions` VALUES (1405, 2327, 2, 'Lagra och sälj inga produkter');
INSERT INTO `lang_definitions` VALUES (1406, 2330, 2, 'Kräv inte att patientanteckningar blir godkända');
INSERT INTO `lang_definitions` VALUES (1407, 2331, 2, 'Inte HLR beslut');
INSERT INTO `lang_definitions` VALUES (1408, 2332, 2, 'spara inte');
INSERT INTO `lang_definitions` VALUES (1409, 2333, 2, 'ersätt inte');
INSERT INTO `lang_definitions` VALUES (1410, 2335, 2, 'gör ingenting');
INSERT INTO `lang_definitions` VALUES (1411, 2338, 2, 'Vill du verkligen radera?');
INSERT INTO `lang_definitions` VALUES (1412, 2339, 2, 'Vill du verkligen radera detta urval?');
INSERT INTO `lang_definitions` VALUES (1413, 2340, 2, 'Vill du verkligen ta bort den här gruppen');
INSERT INTO `lang_definitions` VALUES (1414, 2342, 2, 'Vill du fortsätta?');
INSERT INTO `lang_definitions` VALUES (1415, 2343, 2, 'Vill du ta bort detta?');
INSERT INTO `lang_definitions` VALUES (1416, 2344, 2, 'Vill du ta bort?');
INSERT INTO `lang_definitions` VALUES (1417, 2345, 2, 'Vill du ta bort denna post?');
INSERT INTO `lang_definitions` VALUES (1418, 2346, 2, 'Vill du fortsätta att lägga till den nya patienten?');
INSERT INTO `lang_definitions` VALUES (1419, 2347, 2, 'Vill du fortsätta med det nya namnet?');
INSERT INTO `lang_definitions` VALUES (1420, 2348, 2, 'Vill du PERMANENT ta bort vaccinationsregistreringen?');
INSERT INTO `lang_definitions` VALUES (1421, 2349, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1422, 2350, 2, 'Födelsedatum saknas, ange om möjligt');
INSERT INTO `lang_definitions` VALUES (1423, 2352, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1424, 2353, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (1425, 2354, 2, 'Läkare:');
INSERT INTO `lang_definitions` VALUES (1426, 2355, 2, 'Läkares namn och underskrift');
INSERT INTO `lang_definitions` VALUES (1427, 2356, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1428, 2357, 2, 'dokument');
INSERT INTO `lang_definitions` VALUES (1429, 2359, 2, 'Dokument Kategorier');
INSERT INTO `lang_definitions` VALUES (1430, 2365, 2, 'Dokument kan inte flyttas till patienten id');
INSERT INTO `lang_definitions` VALUES (1431, 2367, 2, 'Dokument Datum');
INSERT INTO `lang_definitions` VALUES (1432, 2368, 2, 'Dokumentets datum och utförande uppdaterats');
INSERT INTO `lang_definitions` VALUES (1433, 2369, 2, 'Dokument id');
INSERT INTO `lang_definitions` VALUES (1434, 2371, 2, 'Dokument är flyttat till ny kategori');
INSERT INTO `lang_definitions` VALUES (1435, 2372, 2, 'Dokument är flyttat till patienten id');
INSERT INTO `lang_definitions` VALUES (1436, 2374, 2, 'Dokument kontrollerat');
INSERT INTO `lang_definitions` VALUES (1437, 2375, 2, 'Sätt att lagra dokument');
INSERT INTO `lang_definitions` VALUES (1438, 2376, 2, 'Namnbyte av dokument lyckats');
INSERT INTO `lang_definitions` VALUES (1439, 2381, 2, 'Dokument/avbildning lagrad');
INSERT INTO `lang_definitions` VALUES (1440, 2383, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1441, 2385, 2, 'Dokument (skriva, tilllägg frivilligt)');
INSERT INTO `lang_definitions` VALUES (1442, 2389, 2, 'Inskrivningsdatum');
INSERT INTO `lang_definitions` VALUES (1443, 2393, 2, 'stämmer inte med PV1 besöksnummer');
INSERT INTO `lang_definitions` VALUES (1444, 2394, 2, 'Verkar inte giltig');
INSERT INTO `lang_definitions` VALUES (1445, 2395, 2, 'Tillåter denna typ relaterade koder?');
INSERT INTO `lang_definitions` VALUES (1446, 2396, 2, 'Sambo');
INSERT INTO `lang_definitions` VALUES (1447, 2397, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1448, 2398, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1449, 2399, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1450, 2401, 2, 'Klart');
INSERT INTO `lang_definitions` VALUES (1451, 2402, 2, 'Klar med:');
INSERT INTO `lang_definitions` VALUES (1452, 2403, 2, 'Klar. Skickas för nedladdning');
INSERT INTO `lang_definitions` VALUES (1453, 2404, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1454, 2405, 2, 'Dosering');
INSERT INTO `lang_definitions` VALUES (1455, 2409, 2, 'dubbelklicka för att redigera');
INSERT INTO `lang_definitions` VALUES (1456, 2411, 2, 'Dubbelseende');
INSERT INTO `lang_definitions` VALUES (1457, 2412, 2, 'Ladda ner');
INSERT INTO `lang_definitions` VALUES (1458, 2415, 2, 'Ladda ner ändå');
INSERT INTO `lang_definitions` VALUES (1459, 2416, 2, 'Ladda ner faktura fil, bokför och markera som skickad.');
INSERT INTO `lang_definitions` VALUES (1460, 2418, 2, 'Ladda ner certifikat');
INSERT INTO `lang_definitions` VALUES (1461, 2419, 2, 'Ladda ner configurationsdata');
INSERT INTO `lang_definitions` VALUES (1462, 2423, 2, 'ladda ner krypterad fil');
INSERT INTO `lang_definitions` VALUES (1463, 2428, 2, 'Ladda ner PDF');
INSERT INTO `lang_definitions` VALUES (1464, 2430, 2, 'Ladda ner utvald redogörelse');
INSERT INTO `lang_definitions` VALUES (1465, 2431, 2, 'Läkarkontroll');
INSERT INTO `lang_definitions` VALUES (1466, 2432, 2, 'Läkarbesök');
INSERT INTO `lang_definitions` VALUES (1467, 2433, 2, 'Dr.');
INSERT INTO `lang_definitions` VALUES (1468, 2437, 2, 'Drag för att flytta');
INSERT INTO `lang_definitions` VALUES (1469, 2439, 2, 'Dribblande');
INSERT INTO `lang_definitions` VALUES (1470, 2440, 2, 'Körkortsnr');
INSERT INTO `lang_definitions` VALUES (1471, 2442, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1472, 2445, 2, 'Leta läkemedel');
INSERT INTO `lang_definitions` VALUES (1473, 2446, 2, 'Läkemedelsformulär');
INSERT INTO `lang_definitions` VALUES (1474, 2447, 2, 'Läkemeddels ID saknas!');
INSERT INTO `lang_definitions` VALUES (1475, 2448, 2, 'Läkemedel intervall');
INSERT INTO `lang_definitions` VALUES (1476, 2449, 2, 'Inventarielista, läkemedel');
INSERT INTO `lang_definitions` VALUES (1477, 2450, 2, 'Läkemedelsnamn');
INSERT INTO `lang_definitions` VALUES (1478, 2451, 2, 'Läkemedel administrationssätt');
INSERT INTO `lang_definitions` VALUES (1479, 2455, 2, 'Läkemedel, enheter');
INSERT INTO `lang_definitions` VALUES (1480, 2460, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1481, 2461, 2, 'Läkemedel och produkter');
INSERT INTO `lang_definitions` VALUES (1482, 2462, 2, 'Muntorrhet');
INSERT INTO `lang_definitions` VALUES (1483, 2463, 2, 'DSM-4 Diagnos');
INSERT INTO `lang_definitions` VALUES (1484, 2464, 2, 'DT 1');
INSERT INTO `lang_definitions` VALUES (1485, 2465, 2, 'DT 2');
INSERT INTO `lang_definitions` VALUES (1486, 2466, 2, 'DT 3');
INSERT INTO `lang_definitions` VALUES (1487, 2467, 2, 'DT 4');
INSERT INTO `lang_definitions` VALUES (1488, 2468, 2, 'DT 5');
INSERT INTO `lang_definitions` VALUES (1489, 2469, 2, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (1490, 2470, 2, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (1491, 2471, 2, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (1492, 2472, 2, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (1493, 2473, 2, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (1494, 2474, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1495, 2475, 2, 'Förfallodatum');
INSERT INTO `lang_definitions` VALUES (1496, 2476, 2, 'Förfallodatum mm / dd / yyyy eller åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1497, 2477, 2, 'Förfallodatum:');
INSERT INTO `lang_definitions` VALUES (1498, 2479, 2, 'Förfaller patienter');
INSERT INTO `lang_definitions` VALUES (1499, 2480, 2, 'Förfaller snart');
INSERT INTO `lang_definitions` VALUES (1500, 2481, 2, 'Förfallostatus');
INSERT INTO `lang_definitions` VALUES (1501, 2482, 2, 'Uppdatera förfallostatus');
INSERT INTO `lang_definitions` VALUES (1502, 2483, 2, 'Dumping OpenEMR database');
INSERT INTO `lang_definitions` VALUES (1503, 2484, 2, 'Dumping OpenEMR web directory tree');
INSERT INTO `lang_definitions` VALUES (1504, 2485, 2, 'Dumping phpGACL database');
INSERT INTO `lang_definitions` VALUES (1505, 2486, 2, 'Dumping phpGACL web directory tree');
INSERT INTO `lang_definitions` VALUES (1506, 2487, 2, 'Dumping SQL-Ledger database');
INSERT INTO `lang_definitions` VALUES (1507, 2488, 2, 'Dumping SQL-Ledger web directory tree');
INSERT INTO `lang_definitions` VALUES (1508, 2489, 2, 'Dubletter kontroll');
INSERT INTO `lang_definitions` VALUES (1509, 2493, 2, 'Dubletter av ID');
INSERT INTO `lang_definitions` VALUES (1510, 2494, 2, 'Dubletter av namn');
INSERT INTO `lang_definitions` VALUES (1511, 2495, 2, 'DUBLETTER VARNING');
INSERT INTO `lang_definitions` VALUES (1512, 2496, 2, 'Varaktig fullmakt');
INSERT INTO `lang_definitions` VALUES (1513, 2497, 2, 'Varaktighet');
INSERT INTO `lang_definitions` VALUES (1514, 2498, 2, 'varaktighet');
INSERT INTO `lang_definitions` VALUES (1515, 2499, 2, 'Holländsk');
INSERT INTO `lang_definitions` VALUES (1516, 2501, 2, 'Dysfagi');
INSERT INTO `lang_definitions` VALUES (1517, 2502, 2, 'Dyspné:');
INSERT INTO `lang_definitions` VALUES (1518, 2503, 2, 'Urinvägsbesvär');
INSERT INTO `lang_definitions` VALUES (1519, 2511, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1520, 2512, 2, 'E-rapport');
INSERT INTO `lang_definitions` VALUES (1521, 2513, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1522, 2515, 2, 'Förnya E-recept');
INSERT INTO `lang_definitions` VALUES (1523, 2518, 2, 'Varje mottagare måste själv ange att meddelanden är avslutade');
INSERT INTO `lang_definitions` VALUES (1524, 2519, 2, 'Tidig Återkommande (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (1525, 2520, 2, 'Öron');
INSERT INTO `lang_definitions` VALUES (1526, 2521, 2, 'EKG');
INSERT INTO `lang_definitions` VALUES (1527, 2522, 2, 'Elektronisk begäran');
INSERT INTO `lang_definitions` VALUES (1528, 2525, 2, 'Ödem');
INSERT INTO `lang_definitions` VALUES (1529, 2532, 2, 'Redigera');
INSERT INTO `lang_definitions` VALUES (1530, 2534, 2, 'Redigera allergier');
INSERT INTO `lang_definitions` VALUES (1531, 2536, 2, 'Edit Kategorier');
INSERT INTO `lang_definitions` VALUES (1532, 2539, 2, 'Redigera definitioner');
INSERT INTO `lang_definitions` VALUES (1533, 2540, 2, 'Redigera diagnoser för');
INSERT INTO `lang_definitions` VALUES (1534, 2544, 2, 'Redigera Kliniker');
INSERT INTO `lang_definitions` VALUES (1535, 2546, 2, 'Redigera Klinikinformation');
INSERT INTO `lang_definitions` VALUES (1536, 2549, 2, 'Redigera form');
INSERT INTO `lang_definitions` VALUES (1537, 2552, 2, 'Redigera layout');
INSERT INTO `lang_definitions` VALUES (1538, 2554, 2, 'Redigera lista');
INSERT INTO `lang_definitions` VALUES (1539, 2557, 2, 'Redigera Struktur');
INSERT INTO `lang_definitions` VALUES (1540, 2564, 2, 'Utbildning');
INSERT INTO `lang_definitions` VALUES (1541, 2565, 2, 'Information');
INSERT INTO `lang_definitions` VALUES (1542, 2568, 2, 'Ikraftträdandedatum');
INSERT INTO `lang_definitions` VALUES (1543, 2570, 2, 'Effektivitet');
INSERT INTO `lang_definitions` VALUES (1544, 2574, 2, 'Ejaculation');
INSERT INTO `lang_definitions` VALUES (1545, 2575, 2, 'Armbåge');
INSERT INTO `lang_definitions` VALUES (1546, 2576, 2, 'Problem med armbågen');
INSERT INTO `lang_definitions` VALUES (1547, 2580, 2, 'Elektronisk remiss');
INSERT INTO `lang_definitions` VALUES (1548, 2589, 2, 'Email');
INSERT INTO `lang_definitions` VALUES (1549, 2600, 2, 'E-post från Batchcom');
INSERT INTO `lang_definitions` VALUES (1550, 2601, 2, 'E-postmeddelande');
INSERT INTO `lang_definitions` VALUES (1551, 2606, 2, 'E-post skicka innan');
INSERT INTO `lang_definitions` VALUES (1552, 2607, 2, 'Email, skicka');
INSERT INTO `lang_definitions` VALUES (1553, 2610, 2, 'Epost Ämnesord');
INSERT INTO `lang_definitions` VALUES (1554, 2612, 2, 'Email Text, användbara Tag: *** NAMN ***, dvs Bäste *** NAMN ***');
INSERT INTO `lang_definitions` VALUES (1555, 2619, 2, 'ICE Kontakt');
INSERT INTO `lang_definitions` VALUES (1556, 2620, 2, 'ICE kontaktperson');
INSERT INTO `lang_definitions` VALUES (1557, 2621, 2, 'ICE kontakt telefonnummer');
INSERT INTO `lang_definitions` VALUES (1558, 2622, 2, 'Akut Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1559, 2628, 2, 'ICE Telefon');
INSERT INTO `lang_definitions` VALUES (1560, 2631, 2, 'Emfysem');
INSERT INTO `lang_definitions` VALUES (1561, 2632, 2, 'Anställd');
INSERT INTO `lang_definitions` VALUES (1562, 2633, 2, 'Arbetsgivare');
INSERT INTO `lang_definitions` VALUES (1563, 2634, 2, 'Arbetsgivarens adress');
INSERT INTO `lang_definitions` VALUES (1564, 2635, 2, 'Arbetsgivare Data');
INSERT INTO `lang_definitions` VALUES (1565, 2636, 2, 'Arbetsgivarens namn');
INSERT INTO `lang_definitions` VALUES (1566, 2638, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1567, 2641, 2, 'Ta bort värdet i \"E-tider\"');
INSERT INTO `lang_definitions` VALUES (1568, 2642, 2, 'Ta bort värde \"Email, skicka\"');
INSERT INTO `lang_definitions` VALUES (1569, 2643, 2, 'Ta bort värde i \"Email, ämne\"');
INSERT INTO `lang_definitions` VALUES (1570, 2644, 2, 'Ta bort i \"text\"');
INSERT INTO `lang_definitions` VALUES (1571, 2645, 2, 'Ta bort i \"Försörjarens namn\"');
INSERT INTO `lang_definitions` VALUES (1572, 2646, 2, 'Ta bort i \"Lösenord\"');
INSERT INTO `lang_definitions` VALUES (1573, 2647, 2, 'Ta bort \"SMS tider\"');
INSERT INTO `lang_definitions` VALUES (1574, 2648, 2, 'Ta bort \"SMS text\"');
INSERT INTO `lang_definitions` VALUES (1575, 2649, 2, 'Ta bort värdet i \"Användarnamn\"');
INSERT INTO `lang_definitions` VALUES (1576, 2731, 2, 'aktiverat');
INSERT INTO `lang_definitions` VALUES (1577, 2737, 2, 'Möte');
INSERT INTO `lang_definitions` VALUES (1578, 2739, 2, 'Patientmöte');
INSERT INTO `lang_definitions` VALUES (1579, 2740, 2, 'patientmöte');
INSERT INTO `lang_definitions` VALUES (1580, 2741, 2, 'Patientmöter');
INSERT INTO `lang_definitions` VALUES (1581, 2753, 2, 'Patientmöte formulär');
INSERT INTO `lang_definitions` VALUES (1582, 2759, 2, 'Patientmöte antal/nummer');
INSERT INTO `lang_definitions` VALUES (1583, 2780, 2, 'Patientmöte har kodats');
INSERT INTO `lang_definitions` VALUES (1584, 2781, 2, 'Patientmöte:');
INSERT INTO `lang_definitions` VALUES (1585, 2783, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (1586, 2784, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1587, 2785, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1588, 2786, 2, 'Encounters inte godkända');
INSERT INTO `lang_definitions` VALUES (1589, 2787, 2, 'Patientmöte, rapport');
INSERT INTO `lang_definitions` VALUES (1590, 2788, 2, 'Patientmöte, avsnitt');
INSERT INTO `lang_definitions` VALUES (1591, 2791, 2, 'Slut');
INSERT INTO `lang_definitions` VALUES (1592, 2792, 2, 'Slutar (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (1593, 2793, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1594, 2794, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1595, 2800, 2, 'Slutdatum:');
INSERT INTO `lang_definitions` VALUES (1596, 2804, 2, 'Sluttid');
INSERT INTO `lang_definitions` VALUES (1597, 2808, 2, 'Tjänsten slutar åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1598, 2812, 2, 'Endokrina');
INSERT INTO `lang_definitions` VALUES (1599, 2813, 2, 'Endoskopi');
INSERT INTO `lang_definitions` VALUES (1600, 2817, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1601, 2818, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1602, 2819, 2, 'Engelsk (indien)');
INSERT INTO `lang_definitions` VALUES (1603, 2820, 2, 'Engelsk (standard)');
INSERT INTO `lang_definitions` VALUES (1604, 2823, 2, 'ENT Ansvarsfrihet');
INSERT INTO `lang_definitions` VALUES (1605, 2824, 2, 'ENT Smärta');
INSERT INTO `lang_definitions` VALUES (1606, 2825, 2, 'Skriv en diagnos kod för att utesluta alla fakturor som inte innehåller det');
INSERT INTO `lang_definitions` VALUES (1607, 2850, 2, 'Ange dina sökkriterier ovan');
INSERT INTO `lang_definitions` VALUES (1608, 2858, 2, 'Miljöpåverkan');
INSERT INTO `lang_definitions` VALUES (1609, 2859, 2, 'EOB Data tillträde');
INSERT INTO `lang_definitions` VALUES (1610, 2863, 2, 'EOB Boknings - Instruktioner');
INSERT INTO `lang_definitions` VALUES (1611, 2864, 2, 'EOB Boknings - Faktura');
INSERT INTO `lang_definitions` VALUES (1612, 2865, 2, 'EOB Boknings - Patient Anmärkning');
INSERT INTO `lang_definitions` VALUES (1613, 2866, 2, 'EOB Boknings - Sök');
INSERT INTO `lang_definitions` VALUES (1614, 2868, 2, 'Epilepsi');
INSERT INTO `lang_definitions` VALUES (1615, 2877, 2, 'Radera');
INSERT INTO `lang_definitions` VALUES (1616, 2879, 2, 'Erektion');
INSERT INTO `lang_definitions` VALUES (1617, 2880, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1618, 2885, 2, 'Fel i \"kön\" val');
INSERT INTO `lang_definitions` VALUES (1619, 2886, 2, 'Fel i \"HIPAA\" val');
INSERT INTO `lang_definitions` VALUES (1620, 2887, 2, 'Fel i \"Process\" val');
INSERT INTO `lang_definitions` VALUES (1621, 2888, 2, 'Fel i \"SMS Gateway\" val');
INSERT INTO `lang_definitions` VALUES (1622, 2889, 2, 'Fel i \"Sortera efter\" val');
INSERT INTO `lang_definitions` VALUES (1623, 2891, 2, 'Fel i JA eller NEJ alternativ');
INSERT INTO `lang_definitions` VALUES (1624, 2903, 2, 'fel under registrering!');
INSERT INTO `lang_definitions` VALUES (1625, 2904, 2, 'Fel vid sparande av fil');
INSERT INTO `lang_definitions` VALUES (1626, 2906, 2, 'Fel vid skrivning till fil');
INSERT INTO `lang_definitions` VALUES (1627, 2910, 2, 'FEL, kunde inte samla in data från servern');
INSERT INTO `lang_definitions` VALUES (1628, 2919, 2, 'FEL: kunde inte öppna table.sql bruten form?');
INSERT INTO `lang_definitions` VALUES (1629, 2927, 2, 'Fel: lösenord matchar inte. Kontrollera din stavning.');
INSERT INTO `lang_definitions` VALUES (1630, 2937, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1631, 2944, 2, 'Erythema:');
INSERT INTO `lang_definitions` VALUES (1632, 2951, 2, 'Redan känd patient');
INSERT INTO `lang_definitions` VALUES (1633, 2953, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1634, 2954, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1635, 2955, 2, 'Modersmål/tolkspråk Lista');
INSERT INTO `lang_definitions` VALUES (1636, 2958, 2, 'ETIN');
INSERT INTO `lang_definitions` VALUES (1637, 2961, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1638, 2962, 2, 'Händelse Begins');
INSERT INTO `lang_definitions` VALUES (1639, 2963, 2, 'Händelse Kategori');
INSERT INTO `lang_definitions` VALUES (1640, 2964, 2, 'Händelse Datum');
INSERT INTO `lang_definitions` VALUES (1641, 2966, 2, 'Händelse, Beskrivning');
INSERT INTO `lang_definitions` VALUES (1642, 2967, 2, 'Händelse, detaljer');
INSERT INTO `lang_definitions` VALUES (1643, 2968, 2, 'Händelsen upprepas ej');
INSERT INTO `lang_definitions` VALUES (1644, 2969, 2, 'Händelse, Varaktighet');
INSERT INTO `lang_definitions` VALUES (1645, 2970, 2, 'Händelsens tid i minuter');
INSERT INTO `lang_definitions` VALUES (1646, 2971, 2, 'Händelse, Avgift');
INSERT INTO `lang_definitions` VALUES (1647, 2972, 2, 'Event Location');
INSERT INTO `lang_definitions` VALUES (1648, 2973, 2, 'Händelsen upprepas varje');
INSERT INTO `lang_definitions` VALUES (1649, 2974, 2, 'Händelsen upprepas den');
INSERT INTO `lang_definitions` VALUES (1650, 2975, 2, 'Händelse börjar timme');
INSERT INTO `lang_definitions` VALUES (1651, 2976, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1652, 2977, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1653, 2978, 2, 'Händelse Website');
INSERT INTO `lang_definitions` VALUES (1654, 2979, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1655, 2980, 2, 'Händelser för');
INSERT INTO `lang_definitions` VALUES (1656, 2981, 2, 'Händelsen öppnas i nytt fönster');
INSERT INTO `lang_definitions` VALUES (1657, 2983, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1658, 2984, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1659, 2986, 2, 'var 3:e timme');
INSERT INTO `lang_definitions` VALUES (1660, 2988, 2, 'var 4:e timme');
INSERT INTO `lang_definitions` VALUES (1661, 2990, 2, 'var 5:e timme');
INSERT INTO `lang_definitions` VALUES (1662, 2992, 2, 'var 6 timme');
INSERT INTO `lang_definitions` VALUES (1663, 2994, 2, 'var 8 timme');
INSERT INTO `lang_definitions` VALUES (1664, 2995, 2, 'Var fjärde');
INSERT INTO `lang_definitions` VALUES (1665, 2997, 2, 'Varannan');
INSERT INTO `lang_definitions` VALUES (1666, 2998, 2, 'Var tredje');
INSERT INTO `lang_definitions` VALUES (1667, 2999, 2, 'Varje, var andra, var 3:e, etc');
INSERT INTO `lang_definitions` VALUES (1668, 3001, 2, 'Tenta och testresultat');
INSERT INTO `lang_definitions` VALUES (1669, 3002, 2, 'Testresultat');
INSERT INTO `lang_definitions` VALUES (1670, 3006, 2, 'Examination Datum');
INSERT INTO `lang_definitions` VALUES (1671, 3010, 2, 'Exams / Tester');
INSERT INTO `lang_definitions` VALUES (1672, 3013, 2, 'Överdrivet rivande');
INSERT INTO `lang_definitions` VALUES (1673, 3020, 2, 'Motions mönster');
INSERT INTO `lang_definitions` VALUES (1674, 3021, 2, 'Övningsmönster');
INSERT INTO `lang_definitions` VALUES (1675, 3024, 2, 'lämna från Administration');
INSERT INTO `lang_definitions` VALUES (1676, 3035, 2, 'Utökad vy');
INSERT INTO `lang_definitions` VALUES (1677, 3036, 2, 'Förväntad form_mötes.pid att');
INSERT INTO `lang_definitions` VALUES (1678, 3037, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1679, 3038, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1680, 3039, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1681, 3041, 2, 'Exportera');
INSERT INTO `lang_definitions` VALUES (1682, 3042, 2, 'Exportera som CSV');
INSERT INTO `lang_definitions` VALUES (1683, 3054, 2, 'Exportera till CSV');
INSERT INTO `lang_definitions` VALUES (1684, 3055, 2, 'Exportera till externa faktureringssystem');
INSERT INTO `lang_definitions` VALUES (1685, 3056, 2, 'Exponering för andra länder');
INSERT INTO `lang_definitions` VALUES (1686, 3072, 2, 'Extern remiss');
INSERT INTO `lang_definitions` VALUES (1687, 3074, 2, 'Extern remiss?');
INSERT INTO `lang_definitions` VALUES (1688, 3075, 2, 'Externa remisser');
INSERT INTO `lang_definitions` VALUES (1689, 3102, 2, 'F');
INSERT INTO `lang_definitions` VALUES (1690, 3105, 2, 'Kliniker');
INSERT INTO `lang_definitions` VALUES (1691, 3106, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (1692, 3107, 2, 'klinik');
INSERT INTO `lang_definitions` VALUES (1693, 3108, 2, 'Klinikadm');
INSERT INTO `lang_definitions` VALUES (1694, 3110, 2, 'Klinikkod');
INSERT INTO `lang_definitions` VALUES (1695, 3116, 2, 'Klinik NPI');
INSERT INTO `lang_definitions` VALUES (1696, 3124, 2, 'Klinik:');
INSERT INTO `lang_definitions` VALUES (1697, 3127, 2, 'Misslyckades');
INSERT INTO `lang_definitions` VALUES (1698, 3148, 2, 'Familjehistoria');
INSERT INTO `lang_definitions` VALUES (1699, 3150, 2, 'Familjehistoria:');
INSERT INTO `lang_definitions` VALUES (1700, 3153, 2, 'Familj Storlek');
INSERT INTO `lang_definitions` VALUES (1701, 3158, 2, 'Fader');
INSERT INTO `lang_definitions` VALUES (1702, 3161, 2, 'Fatigue');
INSERT INTO `lang_definitions` VALUES (1703, 3162, 2, 'Fax');
INSERT INTO `lang_definitions` VALUES (1704, 3167, 2, 'Fax in');
INSERT INTO `lang_definitions` VALUES (1705, 3168, 2, 'Fax ut');
INSERT INTO `lang_definitions` VALUES (1706, 3171, 2, 'Februari');
INSERT INTO `lang_definitions` VALUES (1707, 3173, 2, 'Läkemedel ID');
INSERT INTO `lang_definitions` VALUES (1708, 3175, 2, 'Skatt ID');
INSERT INTO `lang_definitions` VALUES (1709, 3177, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (1710, 3178, 2, 'avgift');
INSERT INTO `lang_definitions` VALUES (1711, 3180, 2, 'Avgift blankett');
INSERT INTO `lang_definitions` VALUES (1712, 3182, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (1713, 3183, 2, 'Kvinna');
INSERT INTO `lang_definitions` VALUES (1714, 3185, 2, 'Kvinnliga Kondomer');
INSERT INTO `lang_definitions` VALUES (1715, 3190, 2, 'Kvinna VSC');
INSERT INTO `lang_definitions` VALUES (1716, 3193, 2, 'Feber');
INSERT INTO `lang_definitions` VALUES (1717, 3194, 2, 'Feber:');
INSERT INTO `lang_definitions` VALUES (1718, 3227, 2, 'Filnamn');
INSERT INTO `lang_definitions` VALUES (1719, 3235, 2, 'Fyll här endast om du skickar e-postmeddelande till patienter');
INSERT INTO `lang_definitions` VALUES (1720, 3245, 2, 'Filter');
INSERT INTO `lang_definitions` VALUES (1721, 3247, 2, 'Slutgiltig diagnos');
INSERT INTO `lang_definitions` VALUES (1722, 3248, 2, 'Slutgiltig diagnos av specialist');
INSERT INTO `lang_definitions` VALUES (1723, 3250, 2, 'Finansiella');
INSERT INTO `lang_definitions` VALUES (1724, 3257, 2, 'Financial Review Datum');
INSERT INTO `lang_definitions` VALUES (1725, 3259, 2, 'Hitta');
INSERT INTO `lang_definitions` VALUES (1726, 3260, 2, 'Hitta Ledig');
INSERT INTO `lang_definitions` VALUES (1727, 3261, 2, 'Sök Ledig mötestider');
INSERT INTO `lang_definitions` VALUES (1728, 3262, 2, 'Hitta Patientient');
INSERT INTO `lang_definitions` VALUES (1729, 3264, 2, 'Undersökningsresultat');
INSERT INTO `lang_definitions` VALUES (1730, 3265, 2, 'Undersökningsresultat av specialist');
INSERT INTO `lang_definitions` VALUES (1731, 3266, 2, 'Fin');
INSERT INTO `lang_definitions` VALUES (1732, 3272, 2, 'Första');
INSERT INTO `lang_definitions` VALUES (1733, 3275, 2, 'Första dagen i veckan');
INSERT INTO `lang_definitions` VALUES (1734, 3278, 2, 'Förnamn');
INSERT INTO `lang_definitions` VALUES (1735, 3280, 2, 'Förnamn:');
INSERT INTO `lang_definitions` VALUES (1736, 3285, 2, 'Fitness');
INSERT INTO `lang_definitions` VALUES (1737, 3289, 2, 'Fitness att spela');
INSERT INTO `lang_definitions` VALUES (1738, 3313, 2, 'Influensavaccination');
INSERT INTO `lang_definitions` VALUES (1739, 3314, 2, 'Vätske-och elektrolyt problem');
INSERT INTO `lang_definitions` VALUES (1740, 3317, 2, 'Följa manuellt');
INSERT INTO `lang_definitions` VALUES (1741, 3332, 2, 'Fot');
INSERT INTO `lang_definitions` VALUES (1742, 3333, 2, 'Fotproblem');
INSERT INTO `lang_definitions` VALUES (1743, 3334, 2, 'Fot:');
INSERT INTO `lang_definitions` VALUES (1744, 3337, 2, 'Fotboll Skaderapport');
INSERT INTO `lang_definitions` VALUES (1745, 3338, 2, 'Skotyp');
INSERT INTO `lang_definitions` VALUES (1746, 3339, 2, 'för');
INSERT INTO `lang_definitions` VALUES (1747, 3358, 2, 'för:');
INSERT INTO `lang_definitions` VALUES (1748, 3362, 2, 'Underarm');
INSERT INTO `lang_definitions` VALUES (1749, 3363, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1750, 3368, 2, 'Format');
INSERT INTO `lang_definitions` VALUES (1751, 3371, 2, 'Format felaktigt för NDC');
INSERT INTO `lang_definitions` VALUES (1752, 3376, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1753, 3377, 2, 'Formulär administration');
INSERT INTO `lang_definitions` VALUES (1754, 3383, 2, 'Vidarebefordra Sidor via Fax');
INSERT INTO `lang_definitions` VALUES (1755, 3387, 2, 'Fjärde');
INSERT INTO `lang_definitions` VALUES (1756, 3389, 2, 'Fraktur');
INSERT INTO `lang_definitions` VALUES (1757, 3390, 2, 'Fracture på Navicula');
INSERT INTO `lang_definitions` VALUES (1758, 3391, 2, 'Fracture laterala malleolus');
INSERT INTO `lang_definitions` VALUES (1759, 3392, 2, 'Fracture mediala malleolus');
INSERT INTO `lang_definitions` VALUES (1760, 3402, 2, 'Fre');
INSERT INTO `lang_definitions` VALUES (1761, 3403, 2, 'Fredag');
INSERT INTO `lang_definitions` VALUES (1762, 3405, 2, 'Från');
INSERT INTO `lang_definitions` VALUES (1763, 3411, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1764, 3412, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1765, 3425, 2, 'Reception');
INSERT INTO `lang_definitions` VALUES (1766, 3426, 2, 'Reception, kvitton');
INSERT INTO `lang_definitions` VALUES (1767, 3427, 2, 'Reception, kvitton, rapport');
INSERT INTO `lang_definitions` VALUES (1768, 3429, 2, 'Frontal Höger:');
INSERT INTO `lang_definitions` VALUES (1769, 3443, 2, 'All utbildning');
INSERT INTO `lang_definitions` VALUES (1770, 3458, 2, 'Gallsten');
INSERT INTO `lang_definitions` VALUES (1771, 3459, 2, 'Game Period');
INSERT INTO `lang_definitions` VALUES (1772, 3460, 2, 'Spel');
INSERT INTO `lang_definitions` VALUES (1773, 3462, 2, 'spel / evenemang');
INSERT INTO `lang_definitions` VALUES (1774, 3465, 2, 'Gastrit');
INSERT INTO `lang_definitions` VALUES (1775, 3467, 2, 'Gastrointestinala');
INSERT INTO `lang_definitions` VALUES (1776, 3468, 2, 'GCAC Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (1777, 3472, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (1778, 3473, 2, 'Allmänt');
INSERT INTO `lang_definitions` VALUES (1779, 3477, 2, 'Allmänna Tjänstekategori');
INSERT INTO `lang_definitions` VALUES (1780, 3483, 2, 'Skapa och hämta HCFA 1500 papper fordringar');
INSERT INTO `lang_definitions` VALUES (1781, 3486, 2, 'Skapa och hämta X12 parti');
INSERT INTO `lang_definitions` VALUES (1782, 3498, 2, 'Generera Skrivelse angående');
INSERT INTO `lang_definitions` VALUES (1783, 3506, 2, 'Generera rapport');
INSERT INTO `lang_definitions` VALUES (1784, 3516, 2, 'Skapad på');
INSERT INTO `lang_definitions` VALUES (1785, 3518, 2, 'Genererar');
INSERT INTO `lang_definitions` VALUES (1786, 3536, 2, 'Glaukom');
INSERT INTO `lang_definitions` VALUES (1787, 3539, 2, 'Global');
INSERT INTO `lang_definitions` VALUES (1788, 3546, 2, 'gå');
INSERT INTO `lang_definitions` VALUES (1789, 3548, 2, 'Gå');
INSERT INTO `lang_definitions` VALUES (1790, 3560, 2, 'Grad:');
INSERT INTO `lang_definitions` VALUES (1791, 3562, 2, 'Totalsumma');
INSERT INTO `lang_definitions` VALUES (1792, 3563, 2, 'Totalsummor');
INSERT INTO `lang_definitions` VALUES (1793, 3572, 2, 'Grupp');
INSERT INTO `lang_definitions` VALUES (1794, 3589, 2, 'Gruppnummer');
INSERT INTO `lang_definitions` VALUES (1795, 3597, 2, 'Grupp:');
INSERT INTO `lang_definitions` VALUES (1796, 3598, 2, 'Gruppnamn');
INSERT INTO `lang_definitions` VALUES (1797, 3600, 2, 'Grupper och åtkomstkontroller');
INSERT INTO `lang_definitions` VALUES (1798, 3603, 2, 'Droppar');
INSERT INTO `lang_definitions` VALUES (1799, 3620, 2, 'Hematom / blåmärken');
INSERT INTO `lang_definitions` VALUES (1800, 3624, 2, 'Hand + fingrar');
INSERT INTO `lang_definitions` VALUES (1801, 3625, 2, 'Handproblem');
INSERT INTO `lang_definitions` VALUES (1802, 3629, 2, 'Umbäranden w / o');
INSERT INTO `lang_definitions` VALUES (1803, 3637, 2, 'Farliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (1804, 3645, 2, 'han PostCalendar');
INSERT INTO `lang_definitions` VALUES (1805, 3646, 2, 'Huvud');
INSERT INTO `lang_definitions` VALUES (1806, 3650, 2, 'Huvudvärk');
INSERT INTO `lang_definitions` VALUES (1807, 3657, 2, 'Heart Attack');
INSERT INTO `lang_definitions` VALUES (1808, 3659, 2, 'Hjärtsvikt');
INSERT INTO `lang_definitions` VALUES (1809, 3661, 2, 'Hjärtproblem');
INSERT INTO `lang_definitions` VALUES (1810, 3662, 2, 'Hjärtkirurgi');
INSERT INTO `lang_definitions` VALUES (1811, 3663, 2, 'Heart Transplant');
INSERT INTO `lang_definitions` VALUES (1812, 3664, 2, 'Heart:');
INSERT INTO `lang_definitions` VALUES (1813, 3672, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (1814, 3674, 2, 'Hjälp');
INSERT INTO `lang_definitions` VALUES (1815, 3675, 2, 'hjälp');
INSERT INTO `lang_definitions` VALUES (1816, 3681, 2, 'Hemoglobin');
INSERT INTO `lang_definitions` VALUES (1817, 3684, 2, 'Hepatit');
INSERT INTO `lang_definitions` VALUES (1818, 3693, 2, 'Bråck Reparation');
INSERT INTO `lang_definitions` VALUES (1819, 3694, 2, 'Diskbråck');
INSERT INTO `lang_definitions` VALUES (1820, 3695, 2, 'Herpes');
INSERT INTO `lang_definitions` VALUES (1821, 3699, 2, 'heyyo. du har varit här i');
INSERT INTO `lang_definitions` VALUES (1822, 3704, 2, 'Dolda');
INSERT INTO `lang_definitions` VALUES (1823, 3705, 2, 'Dolda Händelser Administration');
INSERT INTO `lang_definitions` VALUES (1824, 3706, 2, 'Gömma');
INSERT INTO `lang_definitions` VALUES (1825, 3708, 2, 'Dölj detaljer');
INSERT INTO `lang_definitions` VALUES (1826, 3711, 2, 'Göm meny');
INSERT INTO `lang_definitions` VALUES (1827, 3713, 2, 'Göm påminnelser');
INSERT INTO `lang_definitions` VALUES (1828, 3715, 2, 'Göm/Visa kolumner');
INSERT INTO `lang_definitions` VALUES (1829, 3717, 2, 'Hög');
INSERT INTO `lang_definitions` VALUES (1830, 3719, 2, 'Högt blodtryck');
INSERT INTO `lang_definitions` VALUES (1831, 3721, 2, 'Höft + ljumske');
INSERT INTO `lang_definitions` VALUES (1832, 3722, 2, 'Höft och ljumske');
INSERT INTO `lang_definitions` VALUES (1833, 3723, 2, 'Hip Problem');
INSERT INTO `lang_definitions` VALUES (1834, 3724, 2, 'Höftledsplastik');
INSERT INTO `lang_definitions` VALUES (1835, 3726, 2, 'Ej Tilldelad');
INSERT INTO `lang_definitions` VALUES (1836, 3729, 2, 'Spansktalande');
INSERT INTO `lang_definitions` VALUES (1837, 3734, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (1838, 3736, 2, 'Historikdata');
INSERT INTO `lang_definitions` VALUES (1839, 3754, 2, 'Håll ner [Ctrl] för flera val eller avmarkera');
INSERT INTO `lang_definitions` VALUES (1840, 3755, 2, 'Håll ned Ctrl för att välja flera objekt');
INSERT INTO `lang_definitions` VALUES (1841, 3756, 2, 'Håll ned Ctrl för att välja flera patruller');
INSERT INTO `lang_definitions` VALUES (1842, 3758, 2, 'Hem');
INSERT INTO `lang_definitions` VALUES (1843, 3759, 2, 'Hemtelefon');
INSERT INTO `lang_definitions` VALUES (1844, 3762, 2, 'Hemlös eller liknande?');
INSERT INTO `lang_definitions` VALUES (1845, 3764, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1846, 3765, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1847, 3777, 2, 'Timmar');
INSERT INTO `lang_definitions` VALUES (1848, 3780, 2, 'Hur uppstod skadan?');
INSERT INTO `lang_definitions` VALUES (1849, 3781, 2, 'Hur uppstod skadan?:');
INSERT INTO `lang_definitions` VALUES (1850, 3784, 2, 'Hur många månader att fråga efter kommande evenemang?');
INSERT INTO `lang_definitions` VALUES (1851, 3803, 2, 'Hyperaktiv');
INSERT INTO `lang_definitions` VALUES (1852, 3808, 2, 'Hyperthyroidism');
INSERT INTO `lang_definitions` VALUES (1853, 3810, 2, 'Hypotyreoidism');
INSERT INTO `lang_definitions` VALUES (1854, 3813, 2, 'Hysterektomi');
INSERT INTO `lang_definitions` VALUES (1855, 3815, 2, 'Jag är upptagen under denna tid.');
INSERT INTO `lang_definitions` VALUES (1856, 3816, 2, 'Jag har inte behörighet att läsa');
INSERT INTO `lang_definitions` VALUES (1857, 3837, 2, 'Identifierare (ett ord)');
INSERT INTO `lang_definitions` VALUES (1858, 3845, 2, 'Om alla uppgifter för alla kolumner är komplett för denna form');
INSERT INTO `lang_definitions` VALUES (1859, 3849, 2, 'Om namn, någon del av efternamn eller efternamn, förnamn');
INSERT INTO `lang_definitions` VALUES (1860, 3852, 2, 'Om personen avlidit ange dödsdatum');
INSERT INTO `lang_definitions` VALUES (1861, 3859, 2, 'om arbetslösa lägg till student');
INSERT INTO `lang_definitions` VALUES (1862, 3871, 2, 'Om du vill ändra datatyper, lägg till rader eller kolumner');
INSERT INTO `lang_definitions` VALUES (1863, 3876, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1864, 3884, 2, 'Vaccinering');
INSERT INTO `lang_definitions` VALUES (1865, 3891, 2, 'Vaccin, Lotnummer');
INSERT INTO `lang_definitions` VALUES (1866, 3892, 2, 'Vaccin, tillverkare');
INSERT INTO `lang_definitions` VALUES (1867, 3904, 2, 'Vaccineringar');
INSERT INTO `lang_definitions` VALUES (1868, 3905, 2, 'Vaccinera');
INSERT INTO `lang_definitions` VALUES (1869, 3909, 2, 'Implantat');
INSERT INTO `lang_definitions` VALUES (1870, 3910, 2, 'Importera');
INSERT INTO `lang_definitions` VALUES (1871, 3920, 2, 'Importera patient');
INSERT INTO `lang_definitions` VALUES (1872, 3921, 2, 'Importera Patientdemografi');
INSERT INTO `lang_definitions` VALUES (1873, 3927, 2, 'Importerad från Accounting');
INSERT INTO `lang_definitions` VALUES (1874, 3932, 2, 'förbättrad');
INSERT INTO `lang_definitions` VALUES (1875, 3934, 2, 'i');
INSERT INTO `lang_definitions` VALUES (1876, 3937, 2, 'i båda ögonen');
INSERT INTO `lang_definitions` VALUES (1877, 3939, 2, 'i vänster öga');
INSERT INTO `lang_definitions` VALUES (1878, 3940, 2, 'i näsborre');
INSERT INTO `lang_definitions` VALUES (1879, 3941, 2, 'Arbetar');
INSERT INTO `lang_definitions` VALUES (1880, 3944, 2, 'i höger öga');
INSERT INTO `lang_definitions` VALUES (1881, 3954, 2, 'Inaktiv Dagar');
INSERT INTO `lang_definitions` VALUES (1882, 3965, 2, 'Inkludera mätväden');
INSERT INTO `lang_definitions` VALUES (1883, 3970, 2, 'Inkomst');
INSERT INTO `lang_definitions` VALUES (1884, 3977, 2, 'ökat:');
INSERT INTO `lang_definitions` VALUES (1885, 3978, 2, 'Ansvarsförsäkring');
INSERT INTO `lang_definitions` VALUES (1886, 3981, 2, 'Obestämd');
INSERT INTO `lang_definitions` VALUES (1887, 3987, 2, 'Indikerar om detta problem/frågeställning är aktiv');
INSERT INTO `lang_definitions` VALUES (1888, 3991, 2, 'Hjälpbehövande Patienter Rapport');
INSERT INTO `lang_definitions` VALUES (1889, 3999, 2, 'Infektion / Abscess');
INSERT INTO `lang_definitions` VALUES (1890, 4000, 2, 'Infektioner');
INSERT INTO `lang_definitions` VALUES (1891, 4001, 2, 'Infert Couns');
INSERT INTO `lang_definitions` VALUES (1892, 4008, 2, 'Info');
INSERT INTO `lang_definitions` VALUES (1893, 4009, 2, 'Info test 1');
INSERT INTO `lang_definitions` VALUES (1894, 4010, 2, 'Info test 2');
INSERT INTO `lang_definitions` VALUES (1895, 4011, 2, 'Info test 3');
INSERT INTO `lang_definitions` VALUES (1896, 4012, 2, 'Info test 4');
INSERT INTO `lang_definitions` VALUES (1897, 4013, 2, 'Info test 5');
INSERT INTO `lang_definitions` VALUES (1898, 4014, 2, 'Info test 6');
INSERT INTO `lang_definitions` VALUES (1899, 4018, 2, 'inhalation');
INSERT INTO `lang_definitions` VALUES (1900, 4020, 2, 'inhalationer');
INSERT INTO `lang_definitions` VALUES (1901, 4023, 2, 'Ursprunglig användare');
INSERT INTO `lang_definitions` VALUES (1902, 4026, 2, 'Injeserbara');
INSERT INTO `lang_definitions` VALUES (1903, 4029, 2, 'Skadade ut');
INSERT INTO `lang_definitions` VALUES (1904, 4031, 2, 'Skademekanism');
INSERT INTO `lang_definitions` VALUES (1905, 4032, 2, 'Skada, översiktsrapport');
INSERT INTO `lang_definitions` VALUES (1906, 4034, 2, 'Skada Typ');
INSERT INTO `lang_definitions` VALUES (1907, 4040, 2, 'Inmatningsfält');
INSERT INTO `lang_definitions` VALUES (1908, 4045, 2, 'Ins justera');
INSERT INTO `lang_definitions` VALUES (1909, 4046, 2, 'Ins paketering');
INSERT INTO `lang_definitions` VALUES (1910, 4050, 2, 'Ins överskjutande');
INSERT INTO `lang_definitions` VALUES (1911, 4052, 2, 'Ins återbetalning');
INSERT INTO `lang_definitions` VALUES (1912, 4053, 2, 'Ins Sammering');
INSERT INTO `lang_definitions` VALUES (1913, 4055, 2, 'Ins1');
INSERT INTO `lang_definitions` VALUES (1914, 4056, 2, 'Ins2');
INSERT INTO `lang_definitions` VALUES (1915, 4057, 2, 'Ins3');
INSERT INTO `lang_definitions` VALUES (1916, 4059, 2, 'isättning misslyckades:');
INSERT INTO `lang_definitions` VALUES (1917, 4063, 2, 'Sätt gamla händelser i tabeller');
INSERT INTO `lang_definitions` VALUES (1918, 4066, 2, 'Insomnia');
INSERT INTO `lang_definitions` VALUES (1919, 4068, 2, 'Inspektion');
INSERT INTO `lang_definitions` VALUES (1920, 4069, 2, 'Instabilitet / subluxation');
INSERT INTO `lang_definitions` VALUES (1921, 4073, 2, 'installera DB');
INSERT INTO `lang_definitions` VALUES (1922, 4076, 2, 'Instruerad');
INSERT INTO `lang_definitions` VALUES (1923, 4079, 2, 'Instruktioner:');
INSERT INTO `lang_definitions` VALUES (1924, 4082, 2, 'Insulinberoende diabetiker');
INSERT INTO `lang_definitions` VALUES (1925, 4083, 2, 'Försäkring');
INSERT INTO `lang_definitions` VALUES (1926, 4084, 2, 'försäkring');
INSERT INTO `lang_definitions` VALUES (1927, 4090, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1928, 4091, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1929, 4092, 2, 'Försäkringsbolag Sök / Köp');
INSERT INTO `lang_definitions` VALUES (1930, 4094, 2, 'Försäkring Data');
INSERT INTO `lang_definitions` VALUES (1931, 4096, 2, 'Försäkring Number');
INSERT INTO `lang_definitions` VALUES (1932, 4099, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1933, 4117, 2, 'Internt fel - inga sidor valdes!');
INSERT INTO `lang_definitions` VALUES (1934, 4118, 2, 'Internt fel - patient-ID fanns inte!');
INSERT INTO `lang_definitions` VALUES (1935, 4121, 2, 'Internt fel!');
INSERT INTO `lang_definitions` VALUES (1936, 4124, 2, 'Internt fel: påstående');
INSERT INTO `lang_definitions` VALUES (1937, 4125, 2, 'Internt fel: möter\"');
INSERT INTO `lang_definitions` VALUES (1938, 4131, 2, 'Inre Övergångar');
INSERT INTO `lang_definitions` VALUES (1939, 4134, 2, 'Tolk');
INSERT INTO `lang_definitions` VALUES (1940, 4136, 2, 'Interstitiell lungsjukdom');
INSERT INTO `lang_definitions` VALUES (1941, 4137, 2, 'Interval');
INSERT INTO `lang_definitions` VALUES (1942, 4142, 2, 'Intolerans');
INSERT INTO `lang_definitions` VALUES (1943, 4145, 2, 'intramuskulärt');
INSERT INTO `lang_definitions` VALUES (1944, 4148, 2, 'intravenöst');
INSERT INTO `lang_definitions` VALUES (1945, 4149, 2, 'Introduktion');
INSERT INTO `lang_definitions` VALUES (1946, 4160, 2, 'Ogiltig eller saknas betalaren i källan för kod');
INSERT INTO `lang_definitions` VALUES (1947, 4162, 2, 'Ogiltig Service Kod');
INSERT INTO `lang_definitions` VALUES (1948, 4163, 2, 'Ogiltig källdestination\"');
INSERT INTO `lang_definitions` VALUES (1949, 4167, 2, 'Inventering');
INSERT INTO `lang_definitions` VALUES (1950, 4171, 2, 'Inventering är inte tillgänglig för denna beställning.');
INSERT INTO `lang_definitions` VALUES (1951, 4172, 2, 'Inventeringslista');
INSERT INTO `lang_definitions` VALUES (1952, 4174, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (1953, 4175, 2, 'faktura');
INSERT INTO `lang_definitions` VALUES (1954, 4178, 2, 'Fakturadatum');
INSERT INTO `lang_definitions` VALUES (1955, 4179, 2, 'Fakturanhar inget datum!');
INSERT INTO `lang_definitions` VALUES (1956, 4185, 2, 'Faktura:');
INSERT INTO `lang_definitions` VALUES (1957, 4201, 2, 'Oregelbunden hjärtrytm');
INSERT INTO `lang_definitions` VALUES (1958, 4202, 2, 'Retlighet');
INSERT INTO `lang_definitions` VALUES (1959, 4203, 2, 'Irritation');
INSERT INTO `lang_definitions` VALUES (1960, 4207, 2, 'är ett obligatoriskt fält.');
INSERT INTO `lang_definitions` VALUES (1961, 4216, 2, 'inte är giltig (decimalbråk är OK).');
INSERT INTO `lang_definitions` VALUES (1962, 4217, 2, 'Är PHP använder felsäkert läge?');
INSERT INTO `lang_definitions` VALUES (1963, 4236, 2, 'Frågeställning');
INSERT INTO `lang_definitions` VALUES (1964, 4237, 2, 'frågeställning');
INSERT INTO `lang_definitions` VALUES (1965, 4244, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (1966, 4246, 2, 'Aktuellt (Problem / Medicin / Allergi):');
INSERT INTO `lang_definitions` VALUES (1967, 4247, 2, 'Information och Patientmöten');
INSERT INTO `lang_definitions` VALUES (1968, 4248, 2, 'Information och möten för');
INSERT INTO `lang_definitions` VALUES (1969, 4250, 2, 'Problematik, ej behörig');
INSERT INTO `lang_definitions` VALUES (1970, 4251, 2, 'Frågeställningssektion');
INSERT INTO `lang_definitions` VALUES (1971, 4254, 2, 'Artikel');
INSERT INTO `lang_definitions` VALUES (1972, 4255, 2, 'artikel');
INSERT INTO `lang_definitions` VALUES (1973, 4257, 2, 'Poster laddades inte');
INSERT INTO `lang_definitions` VALUES (1974, 4264, 2, 'Januari');
INSERT INTO `lang_definitions` VALUES (1975, 4268, 2, 'Jobb-beskrivning');
INSERT INTO `lang_definitions` VALUES (1976, 4269, 2, 'Jobb id');
INSERT INTO `lang_definitions` VALUES (1977, 4270, 2, 'Led dislokation');
INSERT INTO `lang_definitions` VALUES (1978, 4271, 2, 'Led smärta');
INSERT INTO `lang_definitions` VALUES (1979, 4272, 2, 'Led vrickning');
INSERT INTO `lang_definitions` VALUES (1980, 4274, 2, 'Juli');
INSERT INTO `lang_definitions` VALUES (1981, 4276, 2, 'Juni');
INSERT INTO `lang_definitions` VALUES (1982, 4278, 2, 'Bara min');
INSERT INTO `lang_definitions` VALUES (1983, 4280, 2, 'Motivera');
INSERT INTO `lang_definitions` VALUES (1984, 4282, 2, 'Motivera / Spara');
INSERT INTO `lang_definitions` VALUES (1985, 4284, 2, 'k, här är resten');
INSERT INTO `lang_definitions` VALUES (1986, 4295, 2, 'Nyckelord');
INSERT INTO `lang_definitions` VALUES (1987, 4299, 2, 'Njurcancer');
INSERT INTO `lang_definitions` VALUES (1988, 4300, 2, 'Njursvikt');
INSERT INTO `lang_definitions` VALUES (1989, 4301, 2, 'Njure Infektioner');
INSERT INTO `lang_definitions` VALUES (1990, 4302, 2, 'Njursten');
INSERT INTO `lang_definitions` VALUES (1991, 4303, 2, 'Njurtransplantation');
INSERT INTO `lang_definitions` VALUES (1992, 4308, 2, 'Knä');
INSERT INTO `lang_definitions` VALUES (1993, 4309, 2, 'Knä Problem');
INSERT INTO `lang_definitions` VALUES (1994, 4310, 2, 'Knä Ersättning /protes');
INSERT INTO `lang_definitions` VALUES (1995, 4317, 2, 'Lab');
INSERT INTO `lang_definitions` VALUES (1996, 4326, 2, 'Lab Rapport');
INSERT INTO `lang_definitions` VALUES (1997, 4335, 2, 'Etikett');
INSERT INTO `lang_definitions` VALUES (1998, 4337, 2, 'Label Cols');
INSERT INTO `lang_definitions` VALUES (1999, 4341, 2, 'Etiketter');
INSERT INTO `lang_definitions` VALUES (2000, 4344, 2, 'Labs');
INSERT INTO `lang_definitions` VALUES (2001, 4345, 2, 'Laceration / hudkodition');
INSERT INTO `lang_definitions` VALUES (2002, 4346, 2, 'Laceration / nötning');
INSERT INTO `lang_definitions` VALUES (2003, 4351, 2, 'Språk');
INSERT INTO `lang_definitions` VALUES (2004, 4352, 2, 'Språk-kod');
INSERT INTO `lang_definitions` VALUES (2005, 4353, 2, 'Språk definition tillagd');
INSERT INTO `lang_definitions` VALUES (2006, 4358, 2, 'Språknamn');
INSERT INTO `lang_definitions` VALUES (2007, 4359, 2, 'Språk:');
INSERT INTO `lang_definitions` VALUES (2008, 4364, 2, 'Sist');
INSERT INTO `lang_definitions` VALUES (2009, 4365, 2, 'Datum för senaste aktivitet');
INSERT INTO `lang_definitions` VALUES (2010, 4367, 2, 'Sista betalnings dag på faktura:');
INSERT INTO `lang_definitions` VALUES (2011, 4373, 2, 'Senaste patientmötet');
INSERT INTO `lang_definitions` VALUES (2012, 4385, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2013, 4386, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2014, 4390, 2, 'Efternamn:');
INSERT INTO `lang_definitions` VALUES (2015, 4396, 2, 'Senast sparad');
INSERT INTO `lang_definitions` VALUES (2016, 4400, 2, 'Senast uppdaterad av');
INSERT INTO `lang_definitions` VALUES (2017, 4402, 2, 'Senaste besöket');
INSERT INTO `lang_definitions` VALUES (2018, 4404, 2, 'Sen Återkommande (2-12 mån)');
INSERT INTO `lang_definitions` VALUES (2019, 4409, 2, 'sidled fördrivna PMI:');
INSERT INTO `lang_definitions` VALUES (2020, 4423, 2, 'Layout Editor');
INSERT INTO `lang_definitions` VALUES (2021, 4430, 2, 'Layouter');
INSERT INTO `lang_definitions` VALUES (2022, 4439, 2, 'LDL');
INSERT INTO `lang_definitions` VALUES (2023, 4441, 2, 'lämna tom om fortfarande aktiv');
INSERT INTO `lang_definitions` VALUES (2024, 4443, 2, 'Lämna tomt för att hålla lösenord oförändrad.');
INSERT INTO `lang_definitions` VALUES (2025, 4444, 2, 'Kontakt via');
INSERT INTO `lang_definitions` VALUES (2026, 4445, 2, 'Lämna Form');
INSERT INTO `lang_definitions` VALUES (2027, 4448, 2, 'Vänster');
INSERT INTO `lang_definitions` VALUES (2028, 4451, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2029, 4452, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2030, 4460, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2031, 4461, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2032, 4462, 2, 'Ben smärta / Kramper');
INSERT INTO `lang_definitions` VALUES (2033, 4463, 2, 'Rättsärenden');
INSERT INTO `lang_definitions` VALUES (2034, 4466, 2, 'Förklaring:');
INSERT INTO `lang_definitions` VALUES (2035, 4467, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (2036, 4478, 2, 'Brev');
INSERT INTO `lang_definitions` VALUES (2037, 4479, 2, 'Brevgenerator');
INSERT INTO `lang_definitions` VALUES (2038, 4488, 2, 'Ansvar');
INSERT INTO `lang_definitions` VALUES (2039, 4489, 2, 'Ansvar för medicinskt');
INSERT INTO `lang_definitions` VALUES (2040, 4491, 2, 'passnr');
INSERT INTO `lang_definitions` VALUES (2041, 4501, 2, 'Livsstil');
INSERT INTO `lang_definitions` VALUES (2042, 4503, 2, 'Ligament skada eller vrickning');
INSERT INTO `lang_definitions` VALUES (2043, 4506, 2, 'Begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2044, 4519, 2, 'Förteckning');
INSERT INTO `lang_definitions` VALUES (2045, 4524, 2, 'List Editor');
INSERT INTO `lang_definitions` VALUES (2046, 4527, 2, 'Lista Insurance Companies');
INSERT INTO `lang_definitions` VALUES (2047, 4532, 2, 'Lista listor');
INSERT INTO `lang_definitions` VALUES (2048, 4533, 2, 'Lista Namn');
INSERT INTO `lang_definitions` VALUES (2049, 4537, 2, 'Lista recept');
INSERT INTO `lang_definitions` VALUES (2050, 4541, 2, 'Listor');
INSERT INTO `lang_definitions` VALUES (2051, 4556, 2, 'Ladda definitioner');
INSERT INTO `lang_definitions` VALUES (2052, 4562, 2, 'Laddar');
INSERT INTO `lang_definitions` VALUES (2053, 4567, 2, 'Lokalt');
INSERT INTO `lang_definitions` VALUES (2054, 4571, 2, 'Lokalitet');
INSERT INTO `lang_definitions` VALUES (2055, 4572, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2056, 4575, 2, 'Lokalisation ospecificerad');
INSERT INTO `lang_definitions` VALUES (2057, 4578, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2058, 4589, 2, 'Inloggad');
INSERT INTO `lang_definitions` VALUES (2059, 4590, 2, 'Inloggad som');
INSERT INTO `lang_definitions` VALUES (2060, 4591, 2, 'Inloggad som:');
INSERT INTO `lang_definitions` VALUES (2061, 4592, 2, 'Utloggad.');
INSERT INTO `lang_definitions` VALUES (2062, 4594, 2, 'Logga in');
INSERT INTO `lang_definitions` VALUES (2063, 4595, 2, 'logga in');
INSERT INTO `lang_definitions` VALUES (2064, 4599, 2, 'Logout');
INSERT INTO `lang_definitions` VALUES (2065, 4600, 2, 'logout');
INSERT INTO `lang_definitions` VALUES (2066, 4601, 2, 'Loggar');
INSERT INTO `lang_definitions` VALUES (2067, 4605, 2, 'Slå upp');
INSERT INTO `lang_definitions` VALUES (2068, 4606, 2, 'Batch');
INSERT INTO `lang_definitions` VALUES (2069, 4608, 2, 'Batchnummer');
INSERT INTO `lang_definitions` VALUES (2070, 4609, 2, 'låg');
INSERT INTO `lang_definitions` VALUES (2071, 4611, 2, 'Benet');
INSERT INTO `lang_definitions` VALUES (2072, 4619, 2, 'Lumbal delen av ryggraden');
INSERT INTO `lang_definitions` VALUES (2073, 4620, 2, 'LUNCH');
INSERT INTO `lang_definitions` VALUES (2074, 4621, 2, 'Lunch');
INSERT INTO `lang_definitions` VALUES (2075, 4622, 2, 'Lung Cancer');
INSERT INTO `lang_definitions` VALUES (2076, 4623, 2, 'Lung Cancer kirurgi');
INSERT INTO `lang_definitions` VALUES (2077, 4624, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2078, 4625, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2079, 4631, 2, 'M');
INSERT INTO `lang_definitions` VALUES (2080, 4632, 2, 'MA Kategori');
INSERT INTO `lang_definitions` VALUES (2081, 4641, 2, 'Huvudadress');
INSERT INTO `lang_definitions` VALUES (2082, 4650, 2, 'Gör ändringar i nuvarande kategorier.');
INSERT INTO `lang_definitions` VALUES (2083, 4654, 2, 'Försäkra \"');
INSERT INTO `lang_definitions` VALUES (2084, 4657, 2, 'Sjukdomskänsla:');
INSERT INTO `lang_definitions` VALUES (2085, 4660, 2, 'Man');
INSERT INTO `lang_definitions` VALUES (2086, 4661, 2, 'Manlig Kondomer');
INSERT INTO `lang_definitions` VALUES (2087, 4664, 2, 'Mammogram');
INSERT INTO `lang_definitions` VALUES (2088, 4672, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (2089, 4681, 2, 'Manuell post');
INSERT INTO `lang_definitions` VALUES (2090, 4685, 2, 'Tillverkare');
INSERT INTO `lang_definitions` VALUES (2091, 4693, 2, 'Mars');
INSERT INTO `lang_definitions` VALUES (2092, 4696, 2, 'Civilstånd');
INSERT INTO `lang_definitions` VALUES (2093, 4699, 2, 'Markera som faktureras men hoppa fakturering');
INSERT INTO `lang_definitions` VALUES (2094, 4700, 2, 'Markera som avklarad');
INSERT INTO `lang_definitions` VALUES (2095, 4701, 2, 'Markera som ej fakturerad');
INSERT INTO `lang_definitions` VALUES (2096, 4704, 2, 'Markerad som avslutad');
INSERT INTO `lang_definitions` VALUES (2097, 4705, 2, 'Gift');
INSERT INTO `lang_definitions` VALUES (2098, 4727, 2, 'Maxillary Höger:');
INSERT INTO `lang_definitions` VALUES (2099, 4737, 2, 'Maj');
INSERT INTO `lang_definitions` VALUES (2100, 4738, 2, 'MC');
INSERT INTO `lang_definitions` VALUES (2101, 4739, 2, 'mcg');
INSERT INTO `lang_definitions` VALUES (2102, 4749, 2, 'Medicinsk');
INSERT INTO `lang_definitions` VALUES (2103, 4756, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2104, 4758, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2105, 4759, 2, 'Journal');
INSERT INTO `lang_definitions` VALUES (2106, 4760, 2, 'Journal #');
INSERT INTO `lang_definitions` VALUES (2107, 4761, 2, 'Journaler');
INSERT INTO `lang_definitions` VALUES (2108, 4768, 2, 'Journal / Historia ( frivilligt att skriva )');
INSERT INTO `lang_definitions` VALUES (2109, 4771, 2, 'Medicin');
INSERT INTO `lang_definitions` VALUES (2110, 4776, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (2111, 4778, 2, 'Läkemedel:');
INSERT INTO `lang_definitions` VALUES (2112, 4779, 2, 'Medicinska enheter');
INSERT INTO `lang_definitions` VALUES (2113, 4780, 2, 'Medium');
INSERT INTO `lang_definitions` VALUES (2114, 4783, 2, 'Ledamot Association Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (2115, 4784, 2, 'Minnes Problem');
INSERT INTO `lang_definitions` VALUES (2116, 4785, 2, 'Män');
INSERT INTO `lang_definitions` VALUES (2117, 4786, 2, 'Män och kvinnor');
INSERT INTO `lang_definitions` VALUES (2118, 4787, 2, 'Män Endast');
INSERT INTO `lang_definitions` VALUES (2119, 4789, 2, 'Klimakteriet');
INSERT INTO `lang_definitions` VALUES (2120, 4792, 2, 'Psykisk sjukdom');
INSERT INTO `lang_definitions` VALUES (2121, 4801, 2, 'Meddelande');
INSERT INTO `lang_definitions` VALUES (2122, 4802, 2, 'Meddelanden och Påminnelser');
INSERT INTO `lang_definitions` VALUES (2123, 4813, 2, 'MEDELANDE:');
INSERT INTO `lang_definitions` VALUES (2124, 4814, 2, 'Meddelanden');
INSERT INTO `lang_definitions` VALUES (2125, 4818, 2, 'Metod');
INSERT INTO `lang_definitions` VALUES (2126, 4822, 2, 'Metod för förstöring');
INSERT INTO `lang_definitions` VALUES (2127, 4825, 2, 'mg');
INSERT INTO `lang_definitions` VALUES (2128, 4826, 2, 'mg/ml');
INSERT INTO `lang_definitions` VALUES (2129, 4827, 2, 'g');
INSERT INTO `lang_definitions` VALUES (2130, 4828, 2, 'g/ml');
INSERT INTO `lang_definitions` VALUES (2131, 4833, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (2132, 4834, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2133, 4835, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2134, 4847, 2, 'Migrerande eller säsongsarbetare?');
INSERT INTO `lang_definitions` VALUES (2135, 4849, 2, 'Migrerande / Säsong');
INSERT INTO `lang_definitions` VALUES (2136, 4863, 2, 'minuter');
INSERT INTO `lang_definitions` VALUES (2137, 4864, 2, 'Protokoll');
INSERT INTO `lang_definitions` VALUES (2138, 4870, 2, 'Diverse');
INSERT INTO `lang_definitions` VALUES (2139, 4872, 2, 'Missade');
INSERT INTO `lang_definitions` VALUES (2140, 4883, 2, 'Blandat');
INSERT INTO `lang_definitions` VALUES (2141, 4885, 2, 'ml');
INSERT INTO `lang_definitions` VALUES (2142, 4892, 2, 'Mobil');
INSERT INTO `lang_definitions` VALUES (2143, 4893, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (2144, 4922, 2, 'Mån');
INSERT INTO `lang_definitions` VALUES (2145, 4923, 2, 'Mån tills fredag');
INSERT INTO `lang_definitions` VALUES (2146, 4924, 2, 'Måndag, onsdag och fredag');
INSERT INTO `lang_definitions` VALUES (2147, 4925, 2, 'Måndag');
INSERT INTO `lang_definitions` VALUES (2148, 4929, 2, 'månad');
INSERT INTO `lang_definitions` VALUES (2149, 4930, 2, 'Månad');
INSERT INTO `lang_definitions` VALUES (2150, 4931, 2, 'Månadsvy');
INSERT INTO `lang_definitions` VALUES (2151, 4932, 2, 'Månad (er)');
INSERT INTO `lang_definitions` VALUES (2152, 4933, 2, 'Månadsinkomst');
INSERT INTO `lang_definitions` VALUES (2153, 4939, 2, 'Mer än 50 resultat, gör din sökning mer specifik.');
INSERT INTO `lang_definitions` VALUES (2154, 4946, 2, 'Moder');
INSERT INTO `lang_definitions` VALUES (2155, 4952, 2, 'Flytta');
INSERT INTO `lang_definitions` VALUES (2156, 4957, 2, 'Flytta till patient');
INSERT INTO `lang_definitions` VALUES (2157, 4958, 2, 'Flytta till...');
INSERT INTO `lang_definitions` VALUES (2158, 4959, 2, 'flytta up');
INSERT INTO `lang_definitions` VALUES (2159, 4964, 2, 'Herr.');
INSERT INTO `lang_definitions` VALUES (2160, 4969, 2, 'Fru.');
INSERT INTO `lang_definitions` VALUES (2161, 4971, 2, 'Fröken');
INSERT INTO `lang_definitions` VALUES (2162, 4981, 2, 'Multi Language Tool');
INSERT INTO `lang_definitions` VALUES (2163, 4983, 2, 'Flera områden');
INSERT INTO `lang_definitions` VALUES (2164, 4991, 2, 'Sorla:');
INSERT INTO `lang_definitions` VALUES (2165, 4992, 2, 'Muskel värk');
INSERT INTO `lang_definitions` VALUES (2166, 4998, 2, 'Muskel');
INSERT INTO `lang_definitions` VALUES (2167, 4999, 2, 'Muskel skada');
INSERT INTO `lang_definitions` VALUES (2168, 5000, 2, 'Muskuloskeletala');
INSERT INTO `lang_definitions` VALUES (2169, 5005, 2, 'Ömsesidigt Definierad');
INSERT INTO `lang_definitions` VALUES (2170, 5019, 2, 'Namn');
INSERT INTO `lang_definitions` VALUES (2171, 5022, 2, 'Namn 1');
INSERT INTO `lang_definitions` VALUES (2172, 5023, 2, 'Namn 2');
INSERT INTO `lang_definitions` VALUES (2173, 5024, 2, 'Namn på administratör');
INSERT INTO `lang_definitions` VALUES (2174, 5028, 2, 'Namn på försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2175, 5029, 2, 'Namn på Provider');
INSERT INTO `lang_definitions` VALUES (2176, 5035, 2, 'Namn:');
INSERT INTO `lang_definitions` VALUES (2177, 5039, 2, 'Narės:');
INSERT INTO `lang_definitions` VALUES (2178, 5040, 2, 'Narės: Normal Rätt');
INSERT INTO `lang_definitions` VALUES (2179, 5043, 2, 'Nasal mucosa rosa, septumets mittlinje');
INSERT INTO `lang_definitions` VALUES (2180, 5049, 2, 'Nationalitet');
INSERT INTO `lang_definitions` VALUES (2181, 5060, 2, 'Navigering');
INSERT INTO `lang_definitions` VALUES (2182, 5084, 2, 'Nacke');
INSERT INTO `lang_definitions` VALUES (2183, 5085, 2, 'Nackproblem');
INSERT INTO `lang_definitions` VALUES (2184, 5088, 2, 'Måste ange en beskrivning');
INSERT INTO `lang_definitions` VALUES (2185, 5089, 2, 'Ange ett returvärde');
INSERT INTO `lang_definitions` VALUES (2186, 5090, 2, 'Ange identifieraren');
INSERT INTO `lang_definitions` VALUES (2187, 5091, 2, 'Ange titel');
INSERT INTO `lang_definitions` VALUES (2188, 5094, 2, 'Ange sekundära fakturering');
INSERT INTO `lang_definitions` VALUES (2189, 5103, 2, 'Nervskada');
INSERT INTO `lang_definitions` VALUES (2190, 5104, 2, 'Neurala tillstånd / nervskada');
INSERT INTO `lang_definitions` VALUES (2191, 5117, 2, 'Ny');
INSERT INTO `lang_definitions` VALUES (2192, 5118, 2, 'Ny =>');
INSERT INTO `lang_definitions` VALUES (2193, 5119, 2, 'Nya mottagare');
INSERT INTO `lang_definitions` VALUES (2194, 5123, 2, 'Nytt möte');
INSERT INTO `lang_definitions` VALUES (2195, 5124, 2, 'Nya kategorier');
INSERT INTO `lang_definitions` VALUES (2196, 5126, 2, 'Nya kunder');
INSERT INTO `lang_definitions` VALUES (2197, 5127, 2, 'Ny konsultation');
INSERT INTO `lang_definitions` VALUES (2198, 5129, 2, 'Nytt definitionset tillagt');
INSERT INTO `lang_definitions` VALUES (2199, 5136, 2, 'Nya Patientbesöksformulär');
INSERT INTO `lang_definitions` VALUES (2200, 5137, 2, 'Nya möten som inte godkänts');
INSERT INTO `lang_definitions` VALUES (2201, 5139, 2, 'Nya Klinikinformation');
INSERT INTO `lang_definitions` VALUES (2202, 5143, 2, 'Ny grupp');
INSERT INTO `lang_definitions` VALUES (2203, 5152, 2, 'Ny begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2204, 5160, 2, 'Ny Patient');
INSERT INTO `lang_definitions` VALUES (2205, 5161, 2, 'NY PATIENT');
INSERT INTO `lang_definitions` VALUES (2206, 5162, 2, 'Nytt Patientbesök');
INSERT INTO `lang_definitions` VALUES (2207, 5164, 2, 'Nytt patient-ID');
INSERT INTO `lang_definitions` VALUES (2208, 5173, 2, 'Nya förslag');
INSERT INTO `lang_definitions` VALUES (2209, 5174, 2, 'Ny användare');
INSERT INTO `lang_definitions` VALUES (2210, 5176, 2, 'Nytt besök');
INSERT INTO `lang_definitions` VALUES (2211, 5177, 2, 'Ny/Sök');
INSERT INTO `lang_definitions` VALUES (2212, 5204, 2, 'Dagstidning');
INSERT INTO `lang_definitions` VALUES (2213, 5205, 2, 'Nästa');
INSERT INTO `lang_definitions` VALUES (2214, 5207, 2, 'Nästa dag');
INSERT INTO `lang_definitions` VALUES (2215, 5208, 2, 'Nästa Månad');
INSERT INTO `lang_definitions` VALUES (2216, 5214, 2, 'Nästa vecka');
INSERT INTO `lang_definitions` VALUES (2217, 5217, 2, 'Alias');
INSERT INTO `lang_definitions` VALUES (2218, 5219, 2, 'Nattliga svettningar');
INSERT INTO `lang_definitions` VALUES (2219, 5222, 2, 'Nej');
INSERT INTO `lang_definitions` VALUES (2220, 5223, 2, 'NEJ');
INSERT INTO `lang_definitions` VALUES (2221, 5225, 2, 'Ingen tillgång');
INSERT INTO `lang_definitions` VALUES (2222, 5237, 2, 'Inget faktureringssystem är aktivt');
INSERT INTO `lang_definitions` VALUES (2223, 5241, 2, 'Ingen kod specificerades!');
INSERT INTO `lang_definitions` VALUES (2224, 5245, 2, 'Ingen diagnos');
INSERT INTO `lang_definitions` VALUES (2225, 5251, 2, 'Inget slutdatum');
INSERT INTO `lang_definitions` VALUES (2226, 5252, 2, 'Inga poster funna, använda formuläret nedan för att lägga till en post.');
INSERT INTO `lang_definitions` VALUES (2227, 5254, 2, 'Inga händelser');
INSERT INTO `lang_definitions` VALUES (2228, 5257, 2, 'Ingen grupp valdes');
INSERT INTO `lang_definitions` VALUES (2229, 5258, 2, 'Inga bråck');
INSERT INTO `lang_definitions` VALUES (2230, 5262, 2, 'Nr Insurance Companies Found');
INSERT INTO `lang_definitions` VALUES (2231, 5297, 2, 'Inga tider hittades för denna period.');
INSERT INTO `lang_definitions` VALUES (2232, 5300, 2, 'Inga Partners hittades');
INSERT INTO `lang_definitions` VALUES (2233, 5303, 2, 'Inga perifera ödem');
INSERT INTO `lang_definitions` VALUES (2234, 5304, 2, 'Inga apotek hittades');
INSERT INTO `lang_definitions` VALUES (2235, 5305, 2, 'Inga recept hittades');
INSERT INTO `lang_definitions` VALUES (2236, 5307, 2, 'Ingen sjukdom / skada visas');
INSERT INTO `lang_definitions` VALUES (2237, 5324, 2, 'Inga resultat hittades i sökningen');
INSERT INTO `lang_definitions` VALUES (2238, 5326, 2, 'Inga resultat, försök igen.');
INSERT INTO `lang_definitions` VALUES (2239, 5329, 2, 'Ej kommit på avtalad tid');
INSERT INTO `lang_definitions` VALUES (2240, 5334, 2, 'Ingen hud dimpling eller bröst knölar');
INSERT INTO `lang_definitions` VALUES (2241, 5346, 2, 'Nr:');
INSERT INTO `lang_definitions` VALUES (2242, 5350, 2, 'Icke specifika skada');
INSERT INTO `lang_definitions` VALUES (2243, 5352, 2, 'Icke-insulinberoende diabetes');
INSERT INTO `lang_definitions` VALUES (2244, 5355, 2, 'Icke-SRH Medical');
INSERT INTO `lang_definitions` VALUES (2245, 5356, 2, 'Icke-SRH icke-medicinska');
INSERT INTO `lang_definitions` VALUES (2246, 5357, 2, 'Ingen');
INSERT INTO `lang_definitions` VALUES (2247, 5358, 2, 'ingen');
INSERT INTO `lang_definitions` VALUES (2248, 5362, 2, 'Inget av ovanstående');
INSERT INTO `lang_definitions` VALUES (2249, 5368, 2, 'Inte heller');
INSERT INTO `lang_definitions` VALUES (2250, 5369, 2, 'Normal');
INSERT INTO `lang_definitions` VALUES (2251, 5381, 2, 'Normal:');
INSERT INTO `lang_definitions` VALUES (2252, 5394, 2, 'Alla fält är obligatoriska för alla nummer eller kod typer.');
INSERT INTO `lang_definitions` VALUES (2253, 5395, 2, 'Ej tillåtet');
INSERT INTO `lang_definitions` VALUES (2254, 5396, 2, 'Ej tillåtet att ta bort gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2255, 5398, 2, 'Ej tillåtet att inaktivera alla trygghet objekt');
INSERT INTO `lang_definitions` VALUES (2256, 5399, 2, 'Ej tillåtet att inaktivera allt från Administratörer ACL');
INSERT INTO `lang_definitions` VALUES (2257, 5400, 2, 'Ej tillåtet att ta bort admin-användare från gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2258, 5403, 2, 'Ej behörighet att nå PostCalendar modulen');
INSERT INTO `lang_definitions` VALUES (2259, 5420, 2, 'Inte undersökt');
INSERT INTO `lang_definitions` VALUES (2260, 5421, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2261, 5422, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2262, 5431, 2, 'Inte sett sedan');
INSERT INTO `lang_definitions` VALUES (2263, 5437, 2, 'kommentera');
INSERT INTO `lang_definitions` VALUES (2264, 5443, 2, 'Kommentartyp');
INSERT INTO `lang_definitions` VALUES (2265, 5452, 2, 'Anmärkning: Denna kod har inte förts in av en auktoriserad användare. Endast godkända koder kan laddas upp till Open Medical Billing nätverket för bearbetning. Om du vill ladda upp dessa nummer kan du välja en auktoriserad användare här.');
INSERT INTO `lang_definitions` VALUES (2266, 5455, 2, 'OBS: Överföra filer med duplikat namn gör att filerna automatiskt ska döpas. Till exempel \"<i> file.jpg </ i>\" blir \"<i> file.jpg.1 </ i>\". Filnamnen anses unika per patient, inte per kategori.');
INSERT INTO `lang_definitions` VALUES (2267, 5456, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (2268, 5472, 2, 'Ingenting valdes');
INSERT INTO `lang_definitions` VALUES (2269, 5474, 2, 'MEDDELANDE: PostCalendar Inlämning / Modifiering');
INSERT INTO `lang_definitions` VALUES (2270, 5475, 2, 'Besked');
INSERT INTO `lang_definitions` VALUES (2271, 5482, 2, 'Meddela Admin Om Händelse Inlämning / Modifieringsförslag?');
INSERT INTO `lang_definitions` VALUES (2272, 5486, 2, 'November');
INSERT INTO `lang_definitions` VALUES (2273, 5495, 2, 'NPI');
INSERT INTO `lang_definitions` VALUES (2274, 5497, 2, 'Nummer');
INSERT INTO `lang_definitions` VALUES (2275, 5503, 2, 'Antal kolumner i år-vy.');
INSERT INTO `lang_definitions` VALUES (2276, 5535, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2277, 5544, 2, 'Yrke');
INSERT INTO `lang_definitions` VALUES (2278, 5547, 2, 'Förekomst');
INSERT INTO `lang_definitions` VALUES (2279, 5549, 2, 'Oktober');
INSERT INTO `lang_definitions` VALUES (2280, 5555, 2, 'tabletter');
INSERT INTO `lang_definitions` VALUES (2281, 5556, 2, 'i månaden per');
INSERT INTO `lang_definitions` VALUES (2282, 5564, 2, 'Mottagningskommentarer');
INSERT INTO `lang_definitions` VALUES (2283, 5565, 2, 'Mottagningsbesök');
INSERT INTO `lang_definitions` VALUES (2284, 5578, 2, 'Avkomma');
INSERT INTO `lang_definitions` VALUES (2285, 5581, 2, 'salva');
INSERT INTO `lang_definitions` VALUES (2286, 5583, 2, 'OK');
INSERT INTO `lang_definitions` VALUES (2287, 5588, 2, 'Gamla klienter');
INSERT INTO `lang_definitions` VALUES (2288, 5602, 2, 'underlåtit att autoassign');
INSERT INTO `lang_definitions` VALUES (2289, 5604, 2, 'på');
INSERT INTO `lang_definitions` VALUES (2290, 5606, 2, 'På Hand');
INSERT INTO `lang_definitions` VALUES (2291, 5607, 2, 'På beställning');
INSERT INTO `lang_definitions` VALUES (2292, 5615, 2, 'När du byter lösenord måste du logga in på nytt.');
INSERT INTO `lang_definitions` VALUES (2293, 5626, 2, 'Endast aktiva');
INSERT INTO `lang_definitions` VALUES (2294, 5631, 2, 'endast om faktureringsadress');
INSERT INTO `lang_definitions` VALUES (2295, 5632, 2, 'Endast Inaktiva');
INSERT INTO `lang_definitions` VALUES (2296, 5633, 2, 'Endast Min');
INSERT INTO `lang_definitions` VALUES (2297, 5642, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2298, 5643, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2299, 5644, 2, 'Uppkomsten av Svullnad:');
INSERT INTO `lang_definitions` VALUES (2300, 5645, 2, 'Debut / Inskrivning. Datum:');
INSERT INTO `lang_definitions` VALUES (2301, 5653, 2, 'Öppen');
INSERT INTO `lang_definitions` VALUES (2302, 5688, 2, 'OpenEMR kräver Javascript för att utföra användarverifiering.');
INSERT INTO `lang_definitions` VALUES (2303, 5698, 2, 'Alternativ');
INSERT INTO `lang_definitions` VALUES (2304, 5701, 2, 'Valfritt');
INSERT INTO `lang_definitions` VALUES (2305, 5712, 2, 'Frivillig information om denna händelse');
INSERT INTO `lang_definitions` VALUES (2306, 5715, 2, 'Valfri procedurkodkod');
INSERT INTO `lang_definitions` VALUES (2307, 5718, 2, 'ELLER');
INSERT INTO `lang_definitions` VALUES (2308, 5719, 2, 'Eller');
INSERT INTO `lang_definitions` VALUES (2309, 5720, 2, 'Eller välj');
INSERT INTO `lang_definitions` VALUES (2310, 5726, 2, 'Eller ladda upp ERA fil:');
INSERT INTO `lang_definitions` VALUES (2311, 5730, 2, 'Ordning');
INSERT INTO `lang_definitions` VALUES (2312, 5756, 2, 'Organskada');
INSERT INTO `lang_definitions` VALUES (2313, 5757, 2, 'Organisation');
INSERT INTO `lang_definitions` VALUES (2314, 5761, 2, 'Orienterad x 3');
INSERT INTO `lang_definitions` VALUES (2315, 5776, 2, 'P.O. (via munnen)');
INSERT INTO `lang_definitions` VALUES (2316, 5781, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2317, 5783, 2, 'annan');
INSERT INTO `lang_definitions` VALUES (2318, 5790, 2, 'Andra skador inte specificerade på någon annan plats');
INSERT INTO `lang_definitions` VALUES (2319, 5792, 2, 'annan månad');
INSERT INTO `lang_definitions` VALUES (2320, 5793, 2, 'Andra icke-federala program');
INSERT INTO `lang_definitions` VALUES (2321, 5795, 2, 'Andra relevanta Symtom');
INSERT INTO `lang_definitions` VALUES (2322, 5796, 2, 'Andra relevanta Symtom:');
INSERT INTO `lang_definitions` VALUES (2323, 5802, 2, 'Andra kirurgiska');
INSERT INTO `lang_definitions` VALUES (2324, 5808, 2, 'OU');
INSERT INTO `lang_definitions` VALUES (2325, 5814, 2, 'Utfall');
INSERT INTO `lang_definitions` VALUES (2326, 5817, 2, 'Outlook');
INSERT INTO `lang_definitions` VALUES (2327, 5827, 2, 'Överutnyttjande');
INSERT INTO `lang_definitions` VALUES (2328, 5835, 2, 'vid behov');
INSERT INTO `lang_definitions` VALUES (2329, 5842, 2, 'Pedriatisk');
INSERT INTO `lang_definitions` VALUES (2330, 5845, 2, 'Sidor');
INSERT INTO `lang_definitions` VALUES (2331, 5846, 2, 'Betald');
INSERT INTO `lang_definitions` VALUES (2332, 5847, 2, 'Betalt belopp som du kommer att fördela');
INSERT INTO `lang_definitions` VALUES (2333, 5849, 2, 'Betalas via');
INSERT INTO `lang_definitions` VALUES (2334, 5871, 2, 'Partner');
INSERT INTO `lang_definitions` VALUES (2335, 5881, 2, 'Lösenord');
INSERT INTO `lang_definitions` VALUES (2336, 5882, 2, 'Ändra lösenord');
INSERT INTO `lang_definitions` VALUES (2337, 5889, 2, 'Lösenord för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2338, 5895, 2, 'Lösenord:');
INSERT INTO `lang_definitions` VALUES (2339, 5909, 2, 'Tidigare möten');
INSERT INTO `lang_definitions` VALUES (2340, 5910, 2, 'Tidigare möten och dokument');
INSERT INTO `lang_definitions` VALUES (2341, 5919, 2, 'Klistra in HL7 Data');
INSERT INTO `lang_definitions` VALUES (2342, 5944, 2, 'Patient Allergier');
INSERT INTO `lang_definitions` VALUES (2343, 5946, 2, 'Patient träff/bokning');
INSERT INTO `lang_definitions` VALUES (2344, 5952, 2, 'Patient diagram ID');
INSERT INTO `lang_definitions` VALUES (2345, 5967, 2, 'Patientdata');
INSERT INTO `lang_definitions` VALUES (2346, 5975, 2, 'Patientdokument');
INSERT INTO `lang_definitions` VALUES (2347, 5981, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2348, 5982, 2, 'Patientmötesformulär');
INSERT INTO `lang_definitions` VALUES (2349, 5983, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2350, 5984, 2, 'Patientsök');
INSERT INTO `lang_definitions` VALUES (2351, 5996, 2, 'Patienthistoria');
INSERT INTO `lang_definitions` VALUES (2352, 5997, 2, 'Patientens historia / Livsstil');
INSERT INTO `lang_definitions` VALUES (2353, 5999, 2, 'Patient-ID');
INSERT INTO `lang_definitions` VALUES (2354, 6004, 2, 'Patient -vaccination');
INSERT INTO `lang_definitions` VALUES (2355, 6008, 2, 'Ej tilldelad!');
INSERT INTO `lang_definitions` VALUES (2356, 6010, 2, 'Patient -problem');
INSERT INTO `lang_definitions` VALUES (2357, 6018, 2, 'Patientlista');
INSERT INTO `lang_definitions` VALUES (2358, 6026, 2, 'Patientens medicinska problem');
INSERT INTO `lang_definitions` VALUES (2359, 6027, 2, 'Patient -Mediciner');
INSERT INTO `lang_definitions` VALUES (2360, 6033, 2, 'Patient: Namn och Adress');
INSERT INTO `lang_definitions` VALUES (2361, 6039, 2, 'Patientanteckning, typ');
INSERT INTO `lang_definitions` VALUES (2362, 6040, 2, 'Patient -kommentarer');
INSERT INTO `lang_definitions` VALUES (2363, 6043, 2, 'Patientnummer');
INSERT INTO `lang_definitions` VALUES (2364, 6057, 2, 'Patient -Journalrapport');
INSERT INTO `lang_definitions` VALUES (2365, 6069, 2, 'Patientrapport');
INSERT INTO `lang_definitions` VALUES (2366, 6071, 2, 'Patientförfrågan');
INSERT INTO `lang_definitions` VALUES (2367, 6089, 2, 'Patient -Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2368, 6091, 2, 'Patient -Remisser m.m.');
INSERT INTO `lang_definitions` VALUES (2369, 6097, 2, 'Patient / Klient');
INSERT INTO `lang_definitions` VALUES (2370, 6098, 2, 'Patient:');
INSERT INTO `lang_definitions` VALUES (2371, 6100, 2, 'Patienter');
INSERT INTO `lang_definitions` VALUES (2372, 6103, 2, 'Betala');
INSERT INTO `lang_definitions` VALUES (2373, 6105, 2, 'Betalningsdatum:');
INSERT INTO `lang_definitions` VALUES (2374, 6109, 2, 'Betalare');
INSERT INTO `lang_definitions` VALUES (2375, 6110, 2, 'Betalare Typ');
INSERT INTO `lang_definitions` VALUES (2376, 6111, 2, 'Utbetalande');
INSERT INTO `lang_definitions` VALUES (2377, 6113, 2, 'Betalning');
INSERT INTO `lang_definitions` VALUES (2378, 6120, 2, 'Betalningsdatum');
INSERT INTO `lang_definitions` VALUES (2379, 6127, 2, 'Betalningsmetod');
INSERT INTO `lang_definitions` VALUES (2380, 6134, 2, 'Betalning värde för kod');
INSERT INTO `lang_definitions` VALUES (2381, 6135, 2, 'Betalningar');
INSERT INTO `lang_definitions` VALUES (2382, 6153, 2, 'Oavslutad');
INSERT INTO `lang_definitions` VALUES (2383, 6158, 2, 'Oklart');
INSERT INTO `lang_definitions` VALUES (2384, 6169, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2385, 6170, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2386, 6173, 2, 'Rektalt');
INSERT INTO `lang_definitions` VALUES (2387, 6174, 2, 'rektalt');
INSERT INTO `lang_definitions` VALUES (2388, 6180, 2, 'Utför sökning');
INSERT INTO `lang_definitions` VALUES (2389, 6181, 2, 'Utför åtgärden');
INSERT INTO `lang_definitions` VALUES (2390, 6203, 2, 'Apotek');
INSERT INTO `lang_definitions` VALUES (2391, 6204, 2, 'Patient Insurance Distribution');
INSERT INTO `lang_definitions` VALUES (2392, 6209, 2, 'Pheumothorax');
INSERT INTO `lang_definitions` VALUES (2393, 6218, 2, 'Telefon');
INSERT INTO `lang_definitions` VALUES (2394, 6220, 2, 'Telefon samtalslistan');
INSERT INTO `lang_definitions` VALUES (2395, 6231, 2, 'Telefonnummer');
INSERT INTO `lang_definitions` VALUES (2396, 6243, 2, 'Hälsokontroll');
INSERT INTO `lang_definitions` VALUES (2397, 6245, 2, 'Läkares Begäran');
INSERT INTO `lang_definitions` VALUES (2398, 6246, 2, 'Läkares Underskrift');
INSERT INTO `lang_definitions` VALUES (2399, 6248, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (2400, 6252, 2, 'välj');
INSERT INTO `lang_definitions` VALUES (2401, 6259, 2, 'Tablett Storlek');
INSERT INTO `lang_definitions` VALUES (2402, 6260, 2, 'Tabletter');
INSERT INTO `lang_definitions` VALUES (2403, 6273, 2, 'Vanlig text');
INSERT INTO `lang_definitions` VALUES (2404, 6274, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2405, 6278, 2, 'Planering namn');
INSERT INTO `lang_definitions` VALUES (2406, 6288, 2, 'Planering:');
INSERT INTO `lang_definitions` VALUES (2407, 6291, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2408, 6293, 2, 'Spelare');
INSERT INTO `lang_definitions` VALUES (2409, 6294, 2, 'Position');
INSERT INTO `lang_definitions` VALUES (2410, 6304, 2, 'Välj ett värde för');
INSERT INTO `lang_definitions` VALUES (2411, 6309, 2, 'Stäng detta fönster');
INSERT INTO `lang_definitions` VALUES (2412, 6310, 2, 'Jämför det nya namnet');
INSERT INTO `lang_definitions` VALUES (2413, 6356, 2, 'Vänligen använ endast alfabetiska tecken');
INSERT INTO `lang_definitions` VALUES (2414, 6357, 2, 'Vänligen använd endast alfabetiska tecken utan mellanslag');
INSERT INTO `lang_definitions` VALUES (2415, 6358, 2, 'Vänligen betala detta belopp');
INSERT INTO `lang_definitions` VALUES (2416, 6380, 2, 'Välj en händelse');
INSERT INTO `lang_definitions` VALUES (2417, 6411, 2, 'EM');
INSERT INTO `lang_definitions` VALUES (2418, 6425, 2, 'Lunginflammations Vaccination');
INSERT INTO `lang_definitions` VALUES (2419, 6432, 2, 'Förhållningssätt');
INSERT INTO `lang_definitions` VALUES (2420, 6440, 2, 'Polyper');
INSERT INTO `lang_definitions` VALUES (2421, 6442, 2, 'Dålig apptit');
INSERT INTO `lang_definitions` VALUES (2422, 6443, 2, 'Dålig cirkulation');
INSERT INTO `lang_definitions` VALUES (2423, 6444, 2, 'Dålig hörsel');
INSERT INTO `lang_definitions` VALUES (2424, 6449, 2, 'Popup-fönster');
INSERT INTO `lang_definitions` VALUES (2425, 6484, 2, 'Postnr');
INSERT INTO `lang_definitions` VALUES (2426, 6485, 2, 'Postnummer');
INSERT INTO `lang_definitions` VALUES (2427, 6499, 2, 'Överförings Datum');
INSERT INTO `lang_definitions` VALUES (2428, 6510, 2, 'Practice');
INSERT INTO `lang_definitions` VALUES (2429, 6529, 2, 'Graviditets test');
INSERT INTO `lang_definitions` VALUES (2430, 6532, 2, 'Förskottsbetalning');
INSERT INTO `lang_definitions` VALUES (2431, 6537, 2, 'Receptbelagda märken');
INSERT INTO `lang_definitions` VALUES (2432, 6541, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2433, 6543, 2, 'Föreskrifter och dispenser');
INSERT INTO `lang_definitions` VALUES (2434, 6544, 2, 'Recept och andra råd');
INSERT INTO `lang_definitions` VALUES (2435, 6545, 2, 'Recept och andra råd av specialist');
INSERT INTO `lang_definitions` VALUES (2436, 6546, 2, 'recept rapport');
INSERT INTO `lang_definitions` VALUES (2437, 6547, 2, 'Recept/råd');
INSERT INTO `lang_definitions` VALUES (2438, 6549, 2, 'Presentera Klagomål');
INSERT INTO `lang_definitions` VALUES (2439, 6551, 2, 'Tryck på fortsätt för att fortsätta');
INSERT INTO `lang_definitions` VALUES (2440, 6553, 2, 'Förmodad diagnos');
INSERT INTO `lang_definitions` VALUES (2441, 6554, 2, 'Förmodad diagnos från specialist');
INSERT INTO `lang_definitions` VALUES (2442, 6555, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2443, 6566, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2444, 6567, 2, 'Föregående konsultation');
INSERT INTO `lang_definitions` VALUES (2445, 6568, 2, 'Föregående dag');
INSERT INTO `lang_definitions` VALUES (2446, 6570, 2, 'Föregående månad');
INSERT INTO `lang_definitions` VALUES (2447, 6571, 2, 'Föregående vecka');
INSERT INTO `lang_definitions` VALUES (2448, 6572, 2, 'Pris');
INSERT INTO `lang_definitions` VALUES (2449, 6575, 2, 'Prisnivå');
INSERT INTO `lang_definitions` VALUES (2450, 6577, 2, 'Prisnivå:');
INSERT INTO `lang_definitions` VALUES (2451, 6580, 2, 'Primär');
INSERT INTO `lang_definitions` VALUES (2452, 6592, 2, 'Primära Försäkring');
INSERT INTO `lang_definitions` VALUES (2453, 6593, 2, 'Primära Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2454, 6594, 2, 'Primär försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2455, 6596, 2, 'Skriv ut');
INSERT INTO `lang_definitions` VALUES (2456, 6601, 2, 'Printa blankt remissformulär');
INSERT INTO `lang_definitions` VALUES (2457, 6614, 2, 'Skriv ut flera');
INSERT INTO `lang_definitions` VALUES (2458, 6631, 2, 'Skriv ut denna anmärkning');
INSERT INTO `lang_definitions` VALUES (2459, 6632, 2, 'Skriv ut Denna Anmärkning');
INSERT INTO `lang_definitions` VALUES (2460, 6636, 2, 'Utskrivbar');
INSERT INTO `lang_definitions` VALUES (2461, 6637, 2, 'Utskriftsversion');
INSERT INTO `lang_definitions` VALUES (2462, 6641, 2, 'Skriva ut resultat:');
INSERT INTO `lang_definitions` VALUES (2463, 6653, 2, 'Prioritet');
INSERT INTO `lang_definitions` VALUES (2464, 6657, 2, 'Privat');
INSERT INTO `lang_definitions` VALUES (2465, 6662, 2, 'Problem/anledningar');
INSERT INTO `lang_definitions` VALUES (2466, 6669, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2467, 6697, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2468, 6699, 2, 'Process');
INSERT INTO `lang_definitions` VALUES (2469, 6710, 2, 'Bearbetning');
INSERT INTO `lang_definitions` VALUES (2470, 6720, 2, 'Produkter');
INSERT INTO `lang_definitions` VALUES (2471, 6723, 2, 'Prof.');
INSERT INTO `lang_definitions` VALUES (2472, 6732, 2, 'Prostata Cancer');
INSERT INTO `lang_definitions` VALUES (2473, 6734, 2, 'Prostata undersökning');
INSERT INTO `lang_definitions` VALUES (2474, 6735, 2, 'Prostata problem');
INSERT INTO `lang_definitions` VALUES (2475, 6750, 2, 'Vårdgivare');
INSERT INTO `lang_definitions` VALUES (2476, 6753, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2477, 6754, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2478, 6755, 2, 'Vårdgivare ID på specificerad klinik');
INSERT INTO `lang_definitions` VALUES (2479, 6756, 2, 'Kan ej matcha vårdgivare');
INSERT INTO `lang_definitions` VALUES (2480, 6760, 2, 'Vårdgivare, nummmer');
INSERT INTO `lang_definitions` VALUES (2481, 6766, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2482, 6767, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2483, 6771, 2, 'PSA');
INSERT INTO `lang_definitions` VALUES (2484, 6772, 2, 'Psoriasis');
INSERT INTO `lang_definitions` VALUES (2485, 6774, 2, 'Psykisk diagnos');
INSERT INTO `lang_definitions` VALUES (2486, 6775, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2487, 6776, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2488, 6825, 2, 'Puls');
INSERT INTO `lang_definitions` VALUES (2489, 6834, 2, 'Var 3:e timme');
INSERT INTO `lang_definitions` VALUES (2490, 6835, 2, 'Var 4:e timme');
INSERT INTO `lang_definitions` VALUES (2491, 6836, 2, 'Var 5:e timme');
INSERT INTO `lang_definitions` VALUES (2492, 6837, 2, 'Var 6:e timme');
INSERT INTO `lang_definitions` VALUES (2493, 6838, 2, 'Var 8:e timme');
INSERT INTO `lang_definitions` VALUES (2494, 6839, 2, '1 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2495, 6840, 2, '4ggr/dag');
INSERT INTO `lang_definitions` VALUES (2496, 6844, 2, 'Antal');
INSERT INTO `lang_definitions` VALUES (2497, 6846, 2, 'Kvalitet');
INSERT INTO `lang_definitions` VALUES (2498, 6848, 2, 'Kvantitet');
INSERT INTO `lang_definitions` VALUES (2499, 6850, 2, 'Kvantitet för NDC');
INSERT INTO `lang_definitions` VALUES (2500, 6860, 2, 'köad');
INSERT INTO `lang_definitions` VALUES (2501, 6861, 2, 'Kö Evenemang Administration');
INSERT INTO `lang_definitions` VALUES (2502, 6862, 2, 'köad för');
INSERT INTO `lang_definitions` VALUES (2503, 6864, 2, 'Kö föreläggande Administration');
INSERT INTO `lang_definitions` VALUES (2504, 6875, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2505, 6876, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2506, 6877, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2507, 6879, 2, 'Radio');
INSERT INTO `lang_definitions` VALUES (2508, 6880, 2, 'Radioknapp');
INSERT INTO `lang_definitions` VALUES (2509, 6884, 2, 'Utslag');
INSERT INTO `lang_definitions` VALUES (2510, 6885, 2, 'Betygsätta');
INSERT INTO `lang_definitions` VALUES (2511, 6887, 2, 'Andel');
INSERT INTO `lang_definitions` VALUES (2512, 6903, 2, 'Åter öppnas');
INSERT INTO `lang_definitions` VALUES (2513, 6906, 2, 'Reaktioner');
INSERT INTO `lang_definitions` VALUES (2514, 6912, 2, 'Riktigt namn');
INSERT INTO `lang_definitions` VALUES (2515, 6914, 2, 'Anledning');
INSERT INTO `lang_definitions` VALUES (2516, 6915, 2, 'Orsak till avslutande');
INSERT INTO `lang_definitions` VALUES (2517, 6918, 2, 'Anledning till remiss');
INSERT INTO `lang_definitions` VALUES (2518, 6919, 2, 'Anledning till besök');
INSERT INTO `lang_definitions` VALUES (2519, 6920, 2, 'Orsak / Form');
INSERT INTO `lang_definitions` VALUES (2520, 6933, 2, 'Kvitto');
INSERT INTO `lang_definitions` VALUES (2521, 6934, 2, 'Kvitto för betalning');
INSERT INTO `lang_definitions` VALUES (2522, 6937, 2, 'Kvitton Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2523, 6938, 2, 'Mottagna');
INSERT INTO `lang_definitions` VALUES (2524, 6939, 2, 'Mottagna av');
INSERT INTO `lang_definitions` VALUES (2525, 6940, 2, 'Mottagna fax');
INSERT INTO `lang_definitions` VALUES (2526, 6943, 2, 'Mottagare');
INSERT INTO `lang_definitions` VALUES (2527, 6944, 2, 'Mottagare ID');
INSERT INTO `lang_definitions` VALUES (2528, 6957, 2, 'Rekomendationer');
INSERT INTO `lang_definitions` VALUES (2529, 6958, 2, 'Rekomendationer och behandling');
INSERT INTO `lang_definitions` VALUES (2530, 6959, 2, 'Rekomendationer av specialist');
INSERT INTO `lang_definitions` VALUES (2531, 6994, 2, 'reduceras:');
INSERT INTO `lang_definitions` VALUES (2532, 6995, 2, 'Remitera');
INSERT INTO `lang_definitions` VALUES (2533, 6996, 2, 'Remiterad av');
INSERT INTO `lang_definitions` VALUES (2534, 6997, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (2535, 6998, 2, 'Remiteras till');
INSERT INTO `lang_definitions` VALUES (2536, 7000, 2, 'Prioritetsnivå (Risknivå)');
INSERT INTO `lang_definitions` VALUES (2537, 7002, 2, 'Orsak till remiss');
INSERT INTO `lang_definitions` VALUES (2538, 7005, 2, 'Remittent, namn och signatur');
INSERT INTO `lang_definitions` VALUES (2539, 7006, 2, 'Remiss');
INSERT INTO `lang_definitions` VALUES (2540, 7007, 2, 'Remitterad av');
INSERT INTO `lang_definitions` VALUES (2541, 7008, 2, 'Remisskort');
INSERT INTO `lang_definitions` VALUES (2542, 7009, 2, 'Remissdadum');
INSERT INTO `lang_definitions` VALUES (2543, 7010, 2, 'Remissformulär');
INSERT INTO `lang_definitions` VALUES (2544, 7011, 2, 'REMISSFORMULÄR');
INSERT INTO `lang_definitions` VALUES (2545, 7015, 2, 'Remisskälla');
INSERT INTO `lang_definitions` VALUES (2546, 7017, 2, 'Remitteras till');
INSERT INTO `lang_definitions` VALUES (2547, 7018, 2, 'remittering');
INSERT INTO `lang_definitions` VALUES (2548, 7019, 2, 'remiss');
INSERT INTO `lang_definitions` VALUES (2549, 7020, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2550, 7021, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2551, 7022, 2, 'Remitterats till');
INSERT INTO `lang_definitions` VALUES (2552, 7023, 2, 'Remiterats av');
INSERT INTO `lang_definitions` VALUES (2553, 7033, 2, 'Påfyllnad');
INSERT INTO `lang_definitions` VALUES (2554, 7034, 2, 'påfyllnad');
INSERT INTO `lang_definitions` VALUES (2555, 7035, 2, 'Reflexer normala');
INSERT INTO `lang_definitions` VALUES (2556, 7039, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2557, 7050, 2, 'Registrerad');
INSERT INTO `lang_definitions` VALUES (2558, 7051, 2, 'registrerade');
INSERT INTO `lang_definitions` VALUES (2559, 7055, 2, 'Registreringsdag');
INSERT INTO `lang_definitions` VALUES (2560, 7057, 2, 'Rehabilitering');
INSERT INTO `lang_definitions` VALUES (2561, 7062, 2, 'Relaterat');
INSERT INTO `lang_definitions` VALUES (2562, 7067, 2, 'Förhållande');
INSERT INTO `lang_definitions` VALUES (2563, 7069, 2, 'Anhöriga');
INSERT INTO `lang_definitions` VALUES (2564, 7083, 2, 'Religion');
INSERT INTO `lang_definitions` VALUES (2565, 7088, 2, 'Relogin');
INSERT INTO `lang_definitions` VALUES (2566, 7110, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (2567, 7137, 2, 'Upprepar');
INSERT INTO `lang_definitions` VALUES (2568, 7144, 2, 'Svars Datum');
INSERT INTO `lang_definitions` VALUES (2569, 7147, 2, 'Rapport');
INSERT INTO `lang_definitions` VALUES (2570, 7169, 2, 'Rapporter');
INSERT INTO `lang_definitions` VALUES (2571, 7185, 2, 'Nödvändig');
INSERT INTO `lang_definitions` VALUES (2572, 7193, 2, 'RESERVERAD');
INSERT INTO `lang_definitions` VALUES (2573, 7194, 2, 'reserverad');
INSERT INTO `lang_definitions` VALUES (2574, 7210, 2, 'Löst');
INSERT INTO `lang_definitions` VALUES (2575, 7222, 2, 'Begränsat Utbildning');
INSERT INTO `lang_definitions` VALUES (2576, 7223, 2, 'Resultat');
INSERT INTO `lang_definitions` VALUES (2577, 7239, 2, 'Infällda Höger:');
INSERT INTO `lang_definitions` VALUES (2578, 7240, 2, 'Avkastning');
INSERT INTO `lang_definitions` VALUES (2579, 7251, 2, 'Returvärde');
INSERT INTO `lang_definitions` VALUES (2580, 7252, 2, 'Återresa');
INSERT INTO `lang_definitions` VALUES (2581, 7268, 2, 'Översyn av System Kontroller');
INSERT INTO `lang_definitions` VALUES (2582, 7274, 2, 'Revision');
INSERT INTO `lang_definitions` VALUES (2583, 7278, 2, 'Höger');
INSERT INTO `lang_definitions` VALUES (2584, 7281, 2, 'Höger öra');
INSERT INTO `lang_definitions` VALUES (2585, 7282, 2, 'höger öra');
INSERT INTO `lang_definitions` VALUES (2586, 7289, 2, 'Höger:');
INSERT INTO `lang_definitions` VALUES (2587, 7290, 2, 'Ringningar i öron');
INSERT INTO `lang_definitions` VALUES (2588, 7291, 2, 'Tinitus');
INSERT INTO `lang_definitions` VALUES (2589, 7313, 2, 'Rutt');
INSERT INTO `lang_definitions` VALUES (2590, 7316, 2, 'Rader');
INSERT INTO `lang_definitions` VALUES (2591, 7319, 2, 'Massera:');
INSERT INTO `lang_definitions` VALUES (2592, 7320, 2, 'Gnuggar:');
INSERT INTO `lang_definitions` VALUES (2593, 7336, 2, 'Kör kommando:');
INSERT INTO `lang_definitions` VALUES (2594, 7341, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2595, 7342, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2596, 7369, 2, 'K');
INSERT INTO `lang_definitions` VALUES (2597, 7370, 2, 'Personnr');
INSERT INTO `lang_definitions` VALUES (2598, 7380, 2, 'Samma dag');
INSERT INTO `lang_definitions` VALUES (2599, 7383, 2, 'Sanktions Typ');
INSERT INTO `lang_definitions` VALUES (2600, 7388, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2601, 7389, 2, 'Lördag & söndag');
INSERT INTO `lang_definitions` VALUES (2602, 7390, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2603, 7391, 2, 'Spara');
INSERT INTO `lang_definitions` VALUES (2604, 7398, 2, 'Spara och fördela');
INSERT INTO `lang_definitions` VALUES (2605, 7401, 2, 'Spara som ny');
INSERT INTO `lang_definitions` VALUES (2606, 7406, 2, 'Spara ändringar');
INSERT INTO `lang_definitions` VALUES (2607, 7415, 2, 'Spara vaccination');
INSERT INTO `lang_definitions` VALUES (2608, 7427, 2, 'Spara transaktionen');
INSERT INTO `lang_definitions` VALUES (2609, 7433, 2, 'Inskannade');
INSERT INTO `lang_definitions` VALUES (2610, 7439, 2, 'Schema');
INSERT INTO `lang_definitions` VALUES (2611, 7456, 2, 'Skolios');
INSERT INTO `lang_definitions` VALUES (2612, 7463, 2, 'SE');
INSERT INTO `lang_definitions` VALUES (2613, 7464, 2, 'SE Adress');
INSERT INTO `lang_definitions` VALUES (2614, 7465, 2, 'SE Stad');
INSERT INTO `lang_definitions` VALUES (2615, 7466, 2, 'SE Land');
INSERT INTO `lang_definitions` VALUES (2616, 7471, 2, 'Söka');
INSERT INTO `lang_definitions` VALUES (2617, 7473, 2, 'söka');
INSERT INTO `lang_definitions` VALUES (2618, 7474, 2, 'Sök igen');
INSERT INTO `lang_definitions` VALUES (2619, 7478, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2620, 7481, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2621, 7485, 2, 'Sök efter eller lägg till patient');
INSERT INTO `lang_definitions` VALUES (2622, 7489, 2, 'Sökresultat:');
INSERT INTO `lang_definitions` VALUES (2623, 7495, 2, 'Sök i Evenemang');
INSERT INTO `lang_definitions` VALUES (2624, 7497, 2, 'Sök / Lägg till försäkringsgivaren');
INSERT INTO `lang_definitions` VALUES (2625, 7502, 2, 'Bilbältesanvändning');
INSERT INTO `lang_definitions` VALUES (2626, 7503, 2, 'Andra');
INSERT INTO `lang_definitions` VALUES (2627, 7506, 2, 'Sekundär');
INSERT INTO `lang_definitions` VALUES (2628, 7507, 2, 'Sekundär Försäkring');
INSERT INTO `lang_definitions` VALUES (2629, 7508, 2, 'Sekundär Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2630, 7523, 2, 'Se Alla');
INSERT INTO `lang_definitions` VALUES (2631, 7525, 2, 'Se Auktoriseringar');
INSERT INTO `lang_definitions` VALUES (2632, 7529, 2, 'Sett sedan');
INSERT INTO `lang_definitions` VALUES (2633, 7535, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (2634, 7543, 2, 'Välj Alla');
INSERT INTO `lang_definitions` VALUES (2635, 7603, 2, 'Selecionar usuários da lista suspensa');
INSERT INTO `lang_definitions` VALUES (2636, 7616, 2, 'Egen lön');
INSERT INTO `lang_definitions` VALUES (2637, 7625, 2, 'Överföring pågår');
INSERT INTO `lang_definitions` VALUES (2638, 7645, 2, 'Avsändare');
INSERT INTO `lang_definitions` VALUES (2639, 7646, 2, 'Avsändar ID');
INSERT INTO `lang_definitions` VALUES (2640, 7655, 2, 'Känslighet:');
INSERT INTO `lang_definitions` VALUES (2641, 7664, 2, 'Skickats');
INSERT INTO `lang_definitions` VALUES (2642, 7667, 2, 'skickas till skrivaren.');
INSERT INTO `lang_definitions` VALUES (2643, 7673, 2, 'Separerade');
INSERT INTO `lang_definitions` VALUES (2644, 7674, 2, 'September');
INSERT INTO `lang_definitions` VALUES (2645, 7690, 2, 'Service Datum:');
INSERT INTO `lang_definitions` VALUES (2646, 7694, 2, 'Service Location');
INSERT INTO `lang_definitions` VALUES (2647, 7700, 2, 'Tjänster');
INSERT INTO `lang_definitions` VALUES (2648, 7701, 2, 'Tjänster efter kategori');
INSERT INTO `lang_definitions` VALUES (2649, 7702, 2, 'Tjänster som Tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2650, 7703, 2, 'Tjänster som tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2651, 7718, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (2652, 7721, 2, 'Svår huvudvärk');
INSERT INTO `lang_definitions` VALUES (2653, 7723, 2, 'Svårighetsgrad av smärta');
INSERT INTO `lang_definitions` VALUES (2654, 7724, 2, 'Svårighetsgrad av smärta:');
INSERT INTO `lang_definitions` VALUES (2655, 7725, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (2656, 7726, 2, 'Sexuellt överförbara sjukdomar');
INSERT INTO `lang_definitions` VALUES (2657, 7729, 2, 'Dela');
INSERT INTO `lang_definitions` VALUES (2658, 7736, 2, 'Andnöd');
INSERT INTO `lang_definitions` VALUES (2659, 7742, 2, 'bör vara som nnnnn-nnnn-nn');
INSERT INTO `lang_definitions` VALUES (2660, 7746, 2, 'Axel');
INSERT INTO `lang_definitions` VALUES (2661, 7747, 2, 'Axel + nyckelben');
INSERT INTO `lang_definitions` VALUES (2662, 7748, 2, 'Axelproblem');
INSERT INTO `lang_definitions` VALUES (2663, 7749, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2664, 7758, 2, 'Visa som upptagen');
INSERT INTO `lang_definitions` VALUES (2665, 7759, 2, 'Visa endast behöriga');
INSERT INTO `lang_definitions` VALUES (2666, 7764, 2, 'Visa detaljer');
INSERT INTO `lang_definitions` VALUES (2667, 7791, 2, 'Visa rapport');
INSERT INTO `lang_definitions` VALUES (2668, 7800, 2, 'Visa endast icke fakturerad');
INSERT INTO `lang_definitions` VALUES (2669, 7812, 2, 'Syskon');
INSERT INTO `lang_definitions` VALUES (2670, 7823, 2, 'Underskrift');
INSERT INTO `lang_definitions` VALUES (2671, 7826, 2, 'Underskrift:');
INSERT INTO `lang_definitions` VALUES (2672, 7829, 2, 'Betydande Svullnad:');
INSERT INTO `lang_definitions` VALUES (2673, 7837, 2, 'Singel');
INSERT INTO `lang_definitions` VALUES (2674, 7855, 2, 'Storlek');
INSERT INTO `lang_definitions` VALUES (2675, 7858, 2, 'Storlek / Lista');
INSERT INTO `lang_definitions` VALUES (2676, 7860, 2, 'Hud');
INSERT INTO `lang_definitions` VALUES (2677, 7871, 2, 'sömn mönster');
INSERT INTO `lang_definitions` VALUES (2678, 7872, 2, 'sover');
INSERT INTO `lang_definitions` VALUES (2679, 7926, 2, 'Social History:');
INSERT INTO `lang_definitions` VALUES (2680, 7929, 2, 'lösning');
INSERT INTO `lang_definitions` VALUES (2681, 7934, 2, 'Vissa möten visas inte. Klicka här för att visa alla.');
INSERT INTO `lang_definitions` VALUES (2682, 7936, 2, 'Vissa anteckningar visades inte');
INSERT INTO `lang_definitions` VALUES (2683, 7938, 2, 'några ord');
INSERT INTO `lang_definitions` VALUES (2684, 7952, 2, 'Sortera efter');
INSERT INTO `lang_definitions` VALUES (2685, 7973, 2, 'Källa');
INSERT INTO `lang_definitions` VALUES (2686, 7977, 2, 'Källa saknas för kod');
INSERT INTO `lang_definitions` VALUES (2687, 7983, 2, 'Källa:');
INSERT INTO `lang_definitions` VALUES (2688, 7996, 2, 'Specialist namn och signatur');
INSERT INTO `lang_definitions` VALUES (2689, 7998, 2, 'Specialtet');
INSERT INTO `lang_definitions` VALUES (2690, 8000, 2, 'Specialitet:');
INSERT INTO `lang_definitions` VALUES (2691, 8001, 2, 'Särskilda');
INSERT INTO `lang_definitions` VALUES (2692, 8005, 2, 'Särskilda tjänster');
INSERT INTO `lang_definitions` VALUES (2693, 8019, 2, 'Tal diktamen');
INSERT INTO `lang_definitions` VALUES (2694, 8020, 2, 'Spermiedödande');
INSERT INTO `lang_definitions` VALUES (2695, 8024, 2, 'Maka');
INSERT INTO `lang_definitions` VALUES (2696, 8027, 2, 'Sputum:');
INSERT INTO `lang_definitions` VALUES (2697, 8041, 2, 'Personnummmer');
INSERT INTO `lang_definitions` VALUES (2698, 8043, 2, 'Persnr');
INSERT INTO `lang_definitions` VALUES (2699, 8044, 2, 'Stabilitet');
INSERT INTO `lang_definitions` VALUES (2700, 8047, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (2701, 8056, 2, 'Start');
INSERT INTO `lang_definitions` VALUES (2702, 8057, 2, 'Start (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (2703, 8060, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2704, 8062, 2, 'Start datum vid denna klinik');
INSERT INTO `lang_definitions` VALUES (2705, 8064, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2706, 8065, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2707, 8066, 2, 'Start tid');
INSERT INTO `lang_definitions` VALUES (2708, 8068, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2709, 8072, 2, 'Stat');
INSERT INTO `lang_definitions` VALUES (2710, 8081, 2, 'församling');
INSERT INTO `lang_definitions` VALUES (2711, 8090, 2, 'Statistik');
INSERT INTO `lang_definitions` VALUES (2712, 8091, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2713, 8092, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2714, 8097, 2, 'Oförändrat');
INSERT INTO `lang_definitions` VALUES (2715, 8113, 2, 'Stela leder');
INSERT INTO `lang_definitions` VALUES (2716, 8116, 2, 'Ont i magen');
INSERT INTO `lang_definitions` VALUES (2717, 8122, 2, 'Överbelastade muskler');
INSERT INTO `lang_definitions` VALUES (2718, 8124, 2, 'Gata');
INSERT INTO `lang_definitions` VALUES (2719, 8126, 2, 'Gatu nummer');
INSERT INTO `lang_definitions` VALUES (2720, 8127, 2, 'styrka');
INSERT INTO `lang_definitions` VALUES (2721, 8130, 2, 'Stress fraktur');
INSERT INTO `lang_definitions` VALUES (2722, 8131, 2, 'Stresstest');
INSERT INTO `lang_definitions` VALUES (2723, 8132, 2, 'Stroke');
INSERT INTO `lang_definitions` VALUES (2724, 8140, 2, 'Delsumma');
INSERT INTO `lang_definitions` VALUES (2725, 8141, 2, 'Underkategori');
INSERT INTO `lang_definitions` VALUES (2726, 8142, 2, 'underkategori');
INSERT INTO `lang_definitions` VALUES (2727, 8143, 2, 'subkutant');
INSERT INTO `lang_definitions` VALUES (2728, 8145, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (2729, 8146, 2, 'Sublingual');
INSERT INTO `lang_definitions` VALUES (2730, 8147, 2, 'sublingual');
INSERT INTO `lang_definitions` VALUES (2731, 8148, 2, 'Lämna in');
INSERT INTO `lang_definitions` VALUES (2732, 8153, 2, 'Lämna in händelsen');
INSERT INTO `lang_definitions` VALUES (2733, 8154, 2, 'lämna in blanketten');
INSERT INTO `lang_definitions` VALUES (2734, 8159, 2, 'Inlämnat av');
INSERT INTO `lang_definitions` VALUES (2735, 8161, 2, 'Prenuremant');
INSERT INTO `lang_definitions` VALUES (2736, 8162, 2, 'Prenuremants Adress');
INSERT INTO `lang_definitions` VALUES (2737, 8191, 2, 'Ersättare');
INSERT INTO `lang_definitions` VALUES (2738, 8192, 2, 'Ersättare tillåts');
INSERT INTO `lang_definitions` VALUES (2739, 8218, 2, 'Självmord');
INSERT INTO `lang_definitions` VALUES (2740, 8219, 2, 'Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2741, 8226, 2, 'Sön');
INSERT INTO `lang_definitions` VALUES (2742, 8228, 2, 'Söndag');
INSERT INTO `lang_definitions` VALUES (2743, 8260, 2, 'Kirurgi');
INSERT INTO `lang_definitions` VALUES (2744, 8262, 2, 'avstänga');
INSERT INTO `lang_definitions` VALUES (2745, 8263, 2, 'Uppslammad vätska');
INSERT INTO `lang_definitions` VALUES (2746, 8270, 2, 'Svenska');
INSERT INTO `lang_definitions` VALUES (2747, 8294, 2, '3 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2748, 8300, 2, 'Tabell skapas inte');
INSERT INTO `lang_definitions` VALUES (2749, 8301, 2, 'Tabell uppdateringen misslyckades');
INSERT INTO `lang_definitions` VALUES (2750, 8303, 2, 'tablett');
INSERT INTO `lang_definitions` VALUES (2751, 8311, 2, 'Ta');
INSERT INTO `lang_definitions` VALUES (2752, 8315, 2, 'Tar lång tid');
INSERT INTO `lang_definitions` VALUES (2753, 8334, 2, 'Skatter');
INSERT INTO `lang_definitions` VALUES (2754, 8355, 2, 'Mall');
INSERT INTO `lang_definitions` VALUES (2755, 8359, 2, 'Mall:');
INSERT INTO `lang_definitions` VALUES (2756, 8376, 2, 'Testa schema');
INSERT INTO `lang_definitions` VALUES (2757, 8377, 2, 'Testa system');
INSERT INTO `lang_definitions` VALUES (2758, 8399, 2, 'Tack');
INSERT INTO `lang_definitions` VALUES (2759, 8408, 2, 'Påstående ärendet:');
INSERT INTO `lang_definitions` VALUES (2760, 8425, 2, 'Händelsen har godkänts.');
INSERT INTO `lang_definitions` VALUES (2761, 8426, 2, 'Händelsen har gömts undan');
INSERT INTO `lang_definitions` VALUES (2762, 8438, 2, 'Följande kalenderhändelse har lagts till:');
INSERT INTO `lang_definitions` VALUES (2763, 8439, 2, 'Följande kalenderhändelse har modifierats:');
INSERT INTO `lang_definitions` VALUES (2764, 8519, 2, 'Terapeutiska Injektioner');
INSERT INTO `lang_definitions` VALUES (2765, 8527, 2, 'Det är fel med din ansökan. Dessa beskrivs nedan.');
INSERT INTO `lang_definitions` VALUES (2766, 8532, 2, 'Det finns inga nya synpunkter');
INSERT INTO `lang_definitions` VALUES (2767, 8554, 2, 'Det uppstod ett fel när din begäran behandlades.');
INSERT INTO `lang_definitions` VALUES (2768, 8561, 2, 'Förtjockad Höger:');
INSERT INTO `lang_definitions` VALUES (2769, 8562, 2, 'Lår');
INSERT INTO `lang_definitions` VALUES (2770, 8563, 2, 'Lår + knäsena');
INSERT INTO `lang_definitions` VALUES (2771, 8580, 2, 'Tredje');
INSERT INTO `lang_definitions` VALUES (2772, 8603, 2, 'Pågående besök');
INSERT INTO `lang_definitions` VALUES (2773, 8612, 2, 'Detta fakturanumret har ändrats till');
INSERT INTO `lang_definitions` VALUES (2774, 8640, 2, 'Denna patient har ingen aktivitet');
INSERT INTO `lang_definitions` VALUES (2775, 8641, 2, 'Denna patients ID används redan!');
INSERT INTO `lang_definitions` VALUES (2776, 8701, 2, 'Tor');
INSERT INTO `lang_definitions` VALUES (2777, 8703, 2, 'torsdag');
INSERT INTO `lang_definitions` VALUES (2778, 8704, 2, 'Torsdag');
INSERT INTO `lang_definitions` VALUES (2779, 8705, 2, 'Sköldkörtel normal');
INSERT INTO `lang_definitions` VALUES (2780, 8712, 2, 'Tid');
INSERT INTO `lang_definitions` VALUES (2781, 8723, 2, 'beräkna tid på händelse');
INSERT INTO `lang_definitions` VALUES (2782, 8725, 2, 'Tidsstämpel och Text');
INSERT INTO `lang_definitions` VALUES (2783, 8730, 2, 'Titel');
INSERT INTO `lang_definitions` VALUES (2784, 8736, 2, 'till');
INSERT INTO `lang_definitions` VALUES (2785, 8737, 2, 'Till');
INSERT INTO `lang_definitions` VALUES (2786, 8738, 2, 'TILL');
INSERT INTO `lang_definitions` VALUES (2787, 8742, 2, 'På det påverkade området');
INSERT INTO `lang_definitions` VALUES (2788, 8743, 2, 'på det påverkade området');
INSERT INTO `lang_definitions` VALUES (2789, 8746, 2, 'till kategori');
INSERT INTO `lang_definitions` VALUES (2790, 8748, 2, 'Till medbetalare');
INSERT INTO `lang_definitions` VALUES (2791, 8758, 2, 'Till Besök');
INSERT INTO `lang_definitions` VALUES (2792, 8759, 2, 'Om du vill filtrera efter kön');
INSERT INTO `lang_definitions` VALUES (2793, 8760, 2, 'Till Historik');
INSERT INTO `lang_definitions` VALUES (2794, 8761, 2, 'Till frågor');
INSERT INTO `lang_definitions` VALUES (2795, 8763, 2, 'För att länka detta besök till objekt i ovanstående lista, markera önskade objekt och klicka sedan på [spara]. Håll ner [Ctrl] för att markera fler objekt.');
INSERT INTO `lang_definitions` VALUES (2796, 8764, 2, 'för att logga in igen');
INSERT INTO `lang_definitions` VALUES (2797, 8772, 2, 'Huden');
INSERT INTO `lang_definitions` VALUES (2798, 8773, 2, 'huden');
INSERT INTO `lang_definitions` VALUES (2799, 8774, 2, 'Till detta besök?');
INSERT INTO `lang_definitions` VALUES (2800, 8776, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2801, 8777, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2802, 8791, 2, 'Tobak');
INSERT INTO `lang_definitions` VALUES (2803, 8794, 2, 'Tobaks användande');
INSERT INTO `lang_definitions` VALUES (2804, 8798, 2, 'Idag');
INSERT INTO `lang_definitions` VALUES (2805, 8803, 2, 'Dagens datum');
INSERT INTO `lang_definitions` VALUES (2806, 8804, 2, 'Dagens händelser');
INSERT INTO `lang_definitions` VALUES (2807, 8813, 2, 'Tonsillektomi');
INSERT INTO `lang_definitions` VALUES (2808, 8816, 2, 'Topp');
INSERT INTO `lang_definitions` VALUES (2809, 8818, 2, 'Ämne');
INSERT INTO `lang_definitions` VALUES (2810, 8819, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2811, 8820, 2, 'totalt');
INSERT INTO `lang_definitions` VALUES (2812, 8826, 2, 'Sammanlagt belopp som betalats');
INSERT INTO `lang_definitions` VALUES (2813, 8829, 2, 'Totala kostnader');
INSERT INTO `lang_definitions` VALUES (2814, 8830, 2, 'Totalt antal Kunder');
INSERT INTO `lang_definitions` VALUES (2815, 8837, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2816, 8838, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2817, 8839, 2, 'Totalt för kategori');
INSERT INTO `lang_definitions` VALUES (2818, 8849, 2, 'Totalt antal patienter');
INSERT INTO `lang_definitions` VALUES (2819, 8870, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2820, 8871, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2821, 8872, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2822, 8885, 2, 'Utbildnings sort');
INSERT INTO `lang_definitions` VALUES (2823, 8886, 2, 'Remiss m.m.');
INSERT INTO `lang_definitions` VALUES (2824, 8887, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2825, 8888, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2826, 8891, 2, 'Transaktionstyp');
INSERT INTO `lang_definitions` VALUES (2827, 8893, 2, 'Transaktioner');
INSERT INTO `lang_definitions` VALUES (2828, 8894, 2, 'Transaktioner (skriva valfritt)');
INSERT INTO `lang_definitions` VALUES (2829, 8896, 2, 'Transaktioner / Övergångar');
INSERT INTO `lang_definitions` VALUES (2830, 8914, 2, 'översätt detta');
INSERT INTO `lang_definitions` VALUES (2831, 8915, 2, 'översätta');
INSERT INTO `lang_definitions` VALUES (2832, 8922, 2, 'Trauma');
INSERT INTO `lang_definitions` VALUES (2833, 8925, 2, 'Behandlings mål');
INSERT INTO `lang_definitions` VALUES (2834, 8926, 2, 'Behandlings plan');
INSERT INTO `lang_definitions` VALUES (2835, 8929, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2836, 8930, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2837, 8947, 2, 'tesked');
INSERT INTO `lang_definitions` VALUES (2838, 8951, 2, 'Tis');
INSERT INTO `lang_definitions` VALUES (2839, 8953, 2, 'Tisdag');
INSERT INTO `lang_definitions` VALUES (2840, 8954, 2, 'Tumör');
INSERT INTO `lang_definitions` VALUES (2841, 8962, 2, 'två gånger dagligen');
INSERT INTO `lang_definitions` VALUES (2842, 8967, 2, 'Typ');
INSERT INTO `lang_definitions` VALUES (2843, 8974, 2, 'Skriv in eller skanna patientidentifikation här');
INSERT INTO `lang_definitions` VALUES (2844, 8991, 2, 'Ulcerations');
INSERT INTO `lang_definitions` VALUES (2845, 8992, 2, 'Ulcerös kolit');
INSERT INTO `lang_definitions` VALUES (2846, 8993, 2, 'Sår:');
INSERT INTO `lang_definitions` VALUES (2847, 9009, 2, 'Ej tilldelad');
INSERT INTO `lang_definitions` VALUES (2848, 9012, 2, 'Obehörig åtkomst.');
INSERT INTO `lang_definitions` VALUES (2849, 9017, 2, 'under tungan');
INSERT INTO `lang_definitions` VALUES (2850, 9018, 2, 'Undervikt');
INSERT INTO `lang_definitions` VALUES (2851, 9019, 2, 'odiagnosticerad');
INSERT INTO `lang_definitions` VALUES (2852, 9024, 2, 'Ångra Kassa');
INSERT INTO `lang_definitions` VALUES (2853, 9026, 2, 'Unika Kunder');
INSERT INTO `lang_definitions` VALUES (2854, 9028, 2, 'Unika nya kunder');
INSERT INTO `lang_definitions` VALUES (2855, 9033, 2, 'Enhet');
INSERT INTO `lang_definitions` VALUES (2856, 9034, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (2857, 9035, 2, 'enheter');
INSERT INTO `lang_definitions` VALUES (2858, 9041, 2, 'Okänt');
INSERT INTO `lang_definitions` VALUES (2859, 9045, 2, 'Okänd eller N / A');
INSERT INTO `lang_definitions` VALUES (2860, 9049, 2, 'Namnlöst försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2861, 9050, 2, 'Oregistrerad');
INSERT INTO `lang_definitions` VALUES (2862, 9053, 2, 'Avmarkera alla');
INSERT INTO `lang_definitions` VALUES (2863, 9054, 2, 'Omarkerat');
INSERT INTO `lang_definitions` VALUES (2864, 9055, 2, 'Ospecificerad');
INSERT INTO `lang_definitions` VALUES (2865, 9059, 2, 'tills');
INSERT INTO `lang_definitions` VALUES (2866, 9062, 2, 'Outnyttjad');
INSERT INTO `lang_definitions` VALUES (2867, 9064, 2, 'Upp till');
INSERT INTO `lang_definitions` VALUES (2868, 9065, 2, 'Kommande möten');
INSERT INTO `lang_definitions` VALUES (2869, 9066, 2, 'Kommande evenemang');
INSERT INTO `lang_definitions` VALUES (2870, 9067, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2871, 9068, 2, 'uppdatera');
INSERT INTO `lang_definitions` VALUES (2872, 9070, 2, 'Uppdateringsfilerna');
INSERT INTO `lang_definitions` VALUES (2873, 9071, 2, 'Uppdatera Info');
INSERT INTO `lang_definitions` VALUES (2874, 9091, 2, 'Uppladdning');
INSERT INTO `lang_definitions` VALUES (2875, 9097, 2, 'Ladda upp dokument');
INSERT INTO `lang_definitions` VALUES (2876, 9100, 2, 'Ladda upp fil att importera:');
INSERT INTO `lang_definitions` VALUES (2877, 9104, 2, 'Ladda upp rapport');
INSERT INTO `lang_definitions` VALUES (2878, 9107, 2, 'Ladda upp den här filen:');
INSERT INTO `lang_definitions` VALUES (2879, 9110, 2, 'Överarmen');
INSERT INTO `lang_definitions` VALUES (2880, 9113, 2, 'Brådskande');
INSERT INTO `lang_definitions` VALUES (2881, 9118, 2, 'Urin Frekvens');
INSERT INTO `lang_definitions` VALUES (2882, 9119, 2, 'Urin Tveksamhet');
INSERT INTO `lang_definitions` VALUES (2883, 9123, 2, 'URL');
INSERT INTO `lang_definitions` VALUES (2884, 9135, 2, 'Använd 24-timmars format?');
INSERT INTO `lang_definitions` VALUES (2885, 9152, 2, 'Använd Standardinställningar');
INSERT INTO `lang_definitions` VALUES (2886, 9154, 2, 'Använd internationellt utseende på datum?');
INSERT INTO `lang_definitions` VALUES (2887, 9160, 2, 'Använd ämnen?');
INSERT INTO `lang_definitions` VALUES (2888, 9161, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2889, 9164, 2, 'Användaradministration');
INSERT INTO `lang_definitions` VALUES (2890, 9165, 2, 'Användar-och Facility Administration');
INSERT INTO `lang_definitions` VALUES (2891, 9166, 2, 'Användare och grupp Administration');
INSERT INTO `lang_definitions` VALUES (2892, 9169, 2, 'Användardefinierad');
INSERT INTO `lang_definitions` VALUES (2893, 9170, 2, 'Användar definierad Area 11');
INSERT INTO `lang_definitions` VALUES (2894, 9171, 2, 'Användar definierad Area 12');
INSERT INTO `lang_definitions` VALUES (2895, 9195, 2, 'Användare Medlemskap');
INSERT INTO `lang_definitions` VALUES (2896, 9214, 2, 'Användarnamn');
INSERT INTO `lang_definitions` VALUES (2897, 9217, 2, 'Användarnamn för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2898, 9220, 2, 'Användarnamn:');
INSERT INTO `lang_definitions` VALUES (2899, 9221, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2900, 9223, 2, 'Användare / grupper / Logs Administration');
INSERT INTO `lang_definitions` VALUES (2901, 9238, 2, 'SEMESTER');
INSERT INTO `lang_definitions` VALUES (2902, 9239, 2, 'Semester');
INSERT INTO `lang_definitions` VALUES (2903, 9240, 2, 'Vaccin');
INSERT INTO `lang_definitions` VALUES (2904, 9251, 2, 'Wert');
INSERT INTO `lang_definitions` VALUES (2905, 9252, 2, 'Wert 1');
INSERT INTO `lang_definitions` VALUES (2906, 9253, 2, 'Wert 2');
INSERT INTO `lang_definitions` VALUES (2907, 9255, 2, 'Wert muss numerisch sein');
INSERT INTO `lang_definitions` VALUES (2908, 9264, 2, 'Blodkärls kondition');
INSERT INTO `lang_definitions` VALUES (2909, 9265, 2, 'Blodkärsl skada');
INSERT INTO `lang_definitions` VALUES (2910, 9266, 2, 'Kärlkirurgi');
INSERT INTO `lang_definitions` VALUES (2911, 9273, 2, 'Version');
INSERT INTO `lang_definitions` VALUES (2912, 9289, 2, 'Svindel');
INSERT INTO `lang_definitions` VALUES (2913, 9302, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2914, 9303, 2, 'Visa');
INSERT INTO `lang_definitions` VALUES (2915, 9305, 2, 'Visa allergier');
INSERT INTO `lang_definitions` VALUES (2916, 9311, 2, 'Visa Omfattande Patient Rapport');
INSERT INTO `lang_definitions` VALUES (2917, 9314, 2, 'Visa dokument');
INSERT INTO `lang_definitions` VALUES (2918, 9316, 2, 'Visa möte');
INSERT INTO `lang_definitions` VALUES (2919, 9318, 2, 'Visa händelser i ett popup-fönster?');
INSERT INTO `lang_definitions` VALUES (2920, 9324, 2, 'Visa Sida 1');
INSERT INTO `lang_definitions` VALUES (2921, 9325, 2, 'Visa sida 2');
INSERT INTO `lang_definitions` VALUES (2922, 9334, 2, 'Se relaterade möten');
INSERT INTO `lang_definitions` VALUES (2923, 9346, 2, 'Visa:');
INSERT INTO `lang_definitions` VALUES (2924, 9347, 2, 'VISA');
INSERT INTO `lang_definitions` VALUES (2925, 9348, 2, 'VISA/MC/AMEX/Dis');
INSERT INTO `lang_definitions` VALUES (2926, 9350, 2, 'Visceral skada / trauma / kirurgi');
INSERT INTO `lang_definitions` VALUES (2927, 9357, 2, 'Besökskategori:');
INSERT INTO `lang_definitions` VALUES (2928, 9358, 2, 'Besöks Datum');
INSERT INTO `lang_definitions` VALUES (2929, 9372, 2, 'Besök');
INSERT INTO `lang_definitions` VALUES (2930, 9373, 2, 'Besök från');
INSERT INTO `lang_definitions` VALUES (2931, 9377, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2932, 9378, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2933, 9379, 2, 'Vitalparametrar (metriska)');
INSERT INTO `lang_definitions` VALUES (2934, 9380, 2, 'Vitalparametrar Formulär inställningar');
INSERT INTO `lang_definitions` VALUES (2935, 9387, 2, 'Kräkningar');
INSERT INTO `lang_definitions` VALUES (2936, 9391, 2, 'W');
INSERT INTO `lang_definitions` VALUES (2937, 9396, 2, 'Väntar');
INSERT INTO `lang_definitions` VALUES (2938, 9407, 2, 'Varm');
INSERT INTO `lang_definitions` VALUES (2939, 9409, 2, 'VARNING');
INSERT INTO `lang_definitions` VALUES (2940, 9413, 2, 'Varning: Ett besök var redan skapat för denna patient idag!');
INSERT INTO `lang_definitions` VALUES (2941, 9418, 2, 'Varning: patient-ID är inte unikt!');
INSERT INTO `lang_definitions` VALUES (2942, 9431, 2, 'Svaghet');
INSERT INTO `lang_definitions` VALUES (2943, 9434, 2, 'Hemsida');
INSERT INTO `lang_definitions` VALUES (2944, 9438, 2, 'Ons');
INSERT INTO `lang_definitions` VALUES (2945, 9439, 2, 'Onsdag');
INSERT INTO `lang_definitions` VALUES (2946, 9440, 2, 'Vecka');
INSERT INTO `lang_definitions` VALUES (2947, 9441, 2, 'vecka');
INSERT INTO `lang_definitions` VALUES (2948, 9442, 2, 'Veckovy');
INSERT INTO `lang_definitions` VALUES (2949, 9443, 2, 'Veckan (s)');
INSERT INTO `lang_definitions` VALUES (2950, 9447, 2, 'Vikt');
INSERT INTO `lang_definitions` VALUES (2951, 9450, 2, 'Vikt förändring');
INSERT INTO `lang_definitions` VALUES (2952, 9451, 2, 'Viktminskning');
INSERT INTO `lang_definitions` VALUES (2953, 9466, 2, 'Vad är det som räknas?');
INSERT INTO `lang_definitions` VALUES (2954, 9470, 2, 'Wheezing:');
INSERT INTO `lang_definitions` VALUES (2955, 9485, 2, 'Whiplash');
INSERT INTO `lang_definitions` VALUES (2956, 9489, 2, 'Vem');
INSERT INTO `lang_definitions` VALUES (2957, 9490, 2, 'Vem har svarat?');
INSERT INTO `lang_definitions` VALUES (2958, 9491, 2, 'Änka/änkeman');
INSERT INTO `lang_definitions` VALUES (2959, 9492, 2, 'Vidd');
INSERT INTO `lang_definitions` VALUES (2960, 9493, 2, 'Vidd i punkter på vänstra navigeringsfönstret');
INSERT INTO `lang_definitions` VALUES (2961, 9499, 2, 'Med vald:');
INSERT INTO `lang_definitions` VALUES (2962, 9500, 2, 'med det gamla namnet');
INSERT INTO `lang_definitions` VALUES (2963, 9502, 2, 'Med vem kan vi lämna ett meddelande?');
INSERT INTO `lang_definitions` VALUES (2964, 9503, 2, 'Återtagen/innehållen');
INSERT INTO `lang_definitions` VALUES (2965, 9504, 2, 'inom några timmar');
INSERT INTO `lang_definitions` VALUES (2966, 9505, 2, 'inom några timmar:');
INSERT INTO `lang_definitions` VALUES (2967, 9506, 2, 'inom några minuter');
INSERT INTO `lang_definitions` VALUES (2968, 9507, 2, 'inom några minuter:');
INSERT INTO `lang_definitions` VALUES (2969, 9510, 2, 'Utan Updatering');
INSERT INTO `lang_definitions` VALUES (2970, 9511, 2, 'vittne');
INSERT INTO `lang_definitions` VALUES (2971, 9515, 2, 'Kvinnor');
INSERT INTO `lang_definitions` VALUES (2972, 9516, 2, 'Enbart kvinnor');
INSERT INTO `lang_definitions` VALUES (2973, 9518, 2, 'Arbete');
INSERT INTO `lang_definitions` VALUES (2974, 9520, 2, 'Telefon, arbete');
INSERT INTO `lang_definitions` VALUES (2975, 9521, 2, 'Telefon, Arbete, Nummer');
INSERT INTO `lang_definitions` VALUES (2976, 9522, 2, 'Arbetsrelaterat?');
INSERT INTO `lang_definitions` VALUES (2977, 9523, 2, 'Arbete/ Utbildning/ Hobby');
INSERT INTO `lang_definitions` VALUES (2978, 9524, 2, 'Arbete / Skola Anmärkning');
INSERT INTO `lang_definitions` VALUES (2979, 9525, 2, 'arbetsdag');
INSERT INTO `lang_definitions` VALUES (2980, 9531, 2, 'förvärrad');
INSERT INTO `lang_definitions` VALUES (2981, 9543, 2, 'Handled');
INSERT INTO `lang_definitions` VALUES (2982, 9544, 2, 'Handled och hand');
INSERT INTO `lang_definitions` VALUES (2983, 9545, 2, 'Handleds Problem');
INSERT INTO `lang_definitions` VALUES (2984, 9546, 2, 'skriv');
INSERT INTO `lang_definitions` VALUES (2985, 9548, 2, 'avskriva');
INSERT INTO `lang_definitions` VALUES (2986, 9556, 2, 'x inställt');
INSERT INTO `lang_definitions` VALUES (2987, 9558, 2, 'Röntgen');
INSERT INTO `lang_definitions` VALUES (2988, 9559, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2989, 9560, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2990, 9563, 2, 'Endast X12: Ersättningskrav');
INSERT INTO `lang_definitions` VALUES (2991, 9565, 2, 'X12 Partner');
INSERT INTO `lang_definitions` VALUES (2992, 9566, 2, 'X12 Partners');
INSERT INTO `lang_definitions` VALUES (2993, 9574, 2, 'Y');
INSERT INTO `lang_definitions` VALUES (2994, 9575, 2, 'år');
INSERT INTO `lang_definitions` VALUES (2995, 9576, 2, 'År');
INSERT INTO `lang_definitions` VALUES (2996, 9577, 2, 'År Visa');
INSERT INTO `lang_definitions` VALUES (2997, 9578, 2, 'År');
INSERT INTO `lang_definitions` VALUES (2998, 9582, 2, 'Ja');
INSERT INTO `lang_definitions` VALUES (2999, 9583, 2, 'JA');
INSERT INTO `lang_definitions` VALUES (3000, 9584, 2, 'ja');
INSERT INTO `lang_definitions` VALUES (3001, 9585, 2, 'JA!');
INSERT INTO `lang_definitions` VALUES (3002, 9586, 2, 'Ja, radera och logga');
INSERT INTO `lang_definitions` VALUES (3003, 9588, 2, 'Ja/Nej');
INSERT INTO `lang_definitions` VALUES (3004, 9589, 2, 'Ja:');
INSERT INTO `lang_definitions` VALUES (3005, 9594, 2, 'Du håller på att permanent ersätta den befintliga mallen. Är du säker på att du vill fortsätta?');
INSERT INTO `lang_definitions` VALUES (3006, 9597, 2, 'Det är inte tillåtet att ta bort denna händelse');
INSERT INTO `lang_definitions` VALUES (3007, 9598, 2, 'Du har inte tillåtelse att redigera den här händelsen');
INSERT INTO `lang_definitions` VALUES (3008, 9599, 2, 'Du har inte behörighet för detta.');
INSERT INTO `lang_definitions` VALUES (3009, 9601, 2, 'Du har inte behörighet att komma åt den här gruppen.');
INSERT INTO `lang_definitions` VALUES (3010, 9602, 2, 'Du har inte behörighet att lägga till / redigera frågor');
INSERT INTO `lang_definitions` VALUES (3011, 9604, 2, 'Du har inte behörighet att se det här mötet.');
INSERT INTO `lang_definitions` VALUES (3012, 9610, 2, 'Du kan inte komma åt denna funktion direkt.');
INSERT INTO `lang_definitions` VALUES (3013, 9612, 2, 'Du kan inte komma åt den här sidan direkt.');
INSERT INTO `lang_definitions` VALUES (3014, 9617, 2, 'Du har inte valt några åtgärder.');
INSERT INTO `lang_definitions` VALUES (3015, 9618, 2, 'Du har inte behörighet att se / redigera denna anmärkning');
INSERT INTO `lang_definitions` VALUES (3016, 9640, 2, 'Du måste först välja eller lägga till en patient.');
INSERT INTO `lang_definitions` VALUES (3017, 9641, 2, 'Du måste först välja eller skapa ett möte.');
INSERT INTO `lang_definitions` VALUES (3018, 9644, 2, 'Du måste välja några områden för att fortsätta.');
INSERT INTO `lang_definitions` VALUES (3019, 9652, 2, 'Ditt slutdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3020, 9653, 2, 'Din händelse har strukits.');
INSERT INTO `lang_definitions` VALUES (3021, 9654, 2, 'Din händelse har ändrats.');
INSERT INTO `lang_definitions` VALUES (3022, 9655, 2, 'Din händelse har lämnats in.');
INSERT INTO `lang_definitions` VALUES (3023, 9661, 2, 'Din namnlista har ändrats för att uppfylla namngivnings krav.');
INSERT INTO `lang_definitions` VALUES (3024, 9672, 2, 'Din Post Kalender konfiguration har återställts att använda standardvärden.');
INSERT INTO `lang_definitions` VALUES (3025, 9673, 2, 'Din Post Kalender konfiguration har uppdaterats.');
INSERT INTO `lang_definitions` VALUES (3026, 9674, 2, 'Den upprepade frekvens måste vara ett heltal.');
INSERT INTO `lang_definitions` VALUES (3027, 9675, 2, 'Den upprepade frekvensen måste vara minst 1.');
INSERT INTO `lang_definitions` VALUES (3028, 9677, 2, 'Ditt startdatum är större än ditt slutdatum');
INSERT INTO `lang_definitions` VALUES (3029, 9678, 2, 'Ditt startdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3030, 9679, 2, 'Ditt förslag misslyckats.');
INSERT INTO `lang_definitions` VALUES (3031, 9681, 2, 'åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (3032, 9683, 2, 'åååå-mm-dd dag är förknippade med detta dokument');
INSERT INTO `lang_definitions` VALUES (3033, 9685, 2, 'åååå-mm-dd födelsedatum');
INSERT INTO `lang_definitions` VALUES (3034, 9686, 2, 'åååå-mm-dd Födelsedatum');
INSERT INTO `lang_definitions` VALUES (3035, 9687, 2, 'ååå-mm-dd datum för utlöpande');
INSERT INTO `lang_definitions` VALUES (3036, 9688, 2, 'åååå-mm-dd Datum för uppkomsten eller sjukhusvistelse');
INSERT INTO `lang_definitions` VALUES (3037, 9689, 2, 'åååå-mm-dd datum debut, kirurgi eller början av medicinering');
INSERT INTO `lang_definitions` VALUES (3038, 9691, 2, 'åååå-mm-dd dagen för tillfrisknande eller slutet av medicinering');
INSERT INTO `lang_definitions` VALUES (3039, 9693, 2, 'åååå-mm-dd Delgivningsdatum');
INSERT INTO `lang_definitions` VALUES (3040, 9694, 2, 'åååå-mm-dd dagen för denna skrivelse');
INSERT INTO `lang_definitions` VALUES (3041, 9696, 2, 'åååå-mm-dd dokumentets datum');
INSERT INTO `lang_definitions` VALUES (3042, 9698, 2, 'åååå-mm-dd händelse datum eller startdatum');
INSERT INTO `lang_definitions` VALUES (3043, 9705, 2, 'åååå-mm-dd sista datum för detta evenemang');
INSERT INTO `lang_definitions` VALUES (3044, 9711, 2, 'noll');
INSERT INTO `lang_definitions` VALUES (3045, 9713, 2, 'postadress');
INSERT INTO `lang_definitions` VALUES (3046, 9714, 2, 'postnummer');
INSERT INTO `lang_definitions` VALUES (3047, 9715, 2, 'land');
INSERT INTO `lang_definitions` VALUES (3048, 9721, 2, 'men var');
INSERT INTO `lang_definitions` VALUES (3049, 9722, 2, 'gick inte att komma åt');
INSERT INTO `lang_definitions` VALUES (3050, 9723, 2, 'Vill du verkligen radera');
INSERT INTO `lang_definitions` VALUES (3051, 9724, 2, 'läkemedel');
INSERT INTO `lang_definitions` VALUES (3052, 9725, 2, 'e-postmeddelande ej skickat');
INSERT INTO `lang_definitions` VALUES (3053, 9726, 2, 'från');
INSERT INTO `lang_definitions` VALUES (3054, 9727, 2, 'har skapats');
INSERT INTO `lang_definitions` VALUES (3055, 9728, 2, 'har återupptagits');
INSERT INTO `lang_definitions` VALUES (3056, 9729, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (3057, 9730, 2, 'är inget nummer');
INSERT INTO `lang_definitions` VALUES (3058, 9731, 2, 'är redo för ny fakturering');
INSERT INTO `lang_definitions` VALUES (3059, 9732, 2, 'LLL:');
INSERT INTO `lang_definitions` VALUES (3060, 9733, 2, 'Batchnr');
INSERT INTO `lang_definitions` VALUES (3061, 9734, 2, 'Medicaid orginal referensnr.');
INSERT INTO `lang_definitions` VALUES (3062, 9736, 2, 'finns ej!');
INSERT INTO `lang_definitions` VALUES (3063, 9739, 2, 'Tills');
INSERT INTO `lang_definitions` VALUES (3064, 9740, 2, 'Uppdateringen misslyckades, inte i databasen?');
INSERT INTO `lang_definitions` VALUES (3065, 9741, 2, 'präglades som faktureras endast.');
INSERT INTO `lang_definitions` VALUES (3066, 9742, 2, 'var kö framgångsrikt.');
INSERT INTO `lang_definitions` VALUES (3067, 9743, 2, '! Lämnat utan besök');
INSERT INTO `lang_definitions` VALUES (3068, 9744, 2, '\" För kod');
INSERT INTO `lang_definitions` VALUES (3069, 9745, 2, '\" Kontrolleras PostCalendar Inställningar!');
INSERT INTO `lang_definitions` VALUES (3070, 9748, 2, 'kr');
INSERT INTO `lang_definitions` VALUES (3071, 9749, 2, 'Kodningen av kronor är färdig');
INSERT INTO `lang_definitions` VALUES (3072, 9750, 2, '$ etikett (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3073, 9751, 2, '%');
INSERT INTO `lang_definitions` VALUES (3074, 9753, 2, '% Annullerat <24h');
INSERT INTO `lang_definitions` VALUES (3075, 9754, 2, 'bör finnas, men finns inte.');
INSERT INTO `lang_definitions` VALUES (3076, 9755, 2, '(% Matchar alla strängar, _ matchar alla tecken)');
INSERT INTO `lang_definitions` VALUES (3077, 9757, 2, '(Tillbaka)');
INSERT INTO `lang_definitions` VALUES (3078, 9758, 2, '(Klicka för att redigera)');
INSERT INTO `lang_definitions` VALUES (3079, 9760, 2, '(Mer)');
INSERT INTO `lang_definitions` VALUES (3080, 9761, 2, '(Ny Patient)');
INSERT INTO `lang_definitions` VALUES (3081, 9762, 2, '(Anteckningar och Auktoriseringar)');
INSERT INTO `lang_definitions` VALUES (3082, 9763, 2, '(Patient anteckningar)');
INSERT INTO `lang_definitions` VALUES (3083, 9764, 2, '(Välj ett av dessa, eller skriv din egen rubrik)');
INSERT INTO `lang_definitions` VALUES (3084, 9766, 2, '* Påminnelse skickad');
INSERT INTO `lang_definitions` VALUES (3085, 9767, 2, '** Gör om kirurgi till enheter');
INSERT INTO `lang_definitions` VALUES (3086, 9768, 2, '* Obligatorisk');
INSERT INTO `lang_definitions` VALUES (3087, 9769, 2, '+ Patientkort hämtat');
INSERT INTO `lang_definitions` VALUES (3088, 9773, 2, '- Ingen');
INSERT INTO `lang_definitions` VALUES (3089, 9775, 2, '-- Alla --');
INSERT INTO `lang_definitions` VALUES (3090, 9776, 2, '--Välj uppdrag--');
INSERT INTO `lang_definitions` VALUES (3091, 9777, 2, '.');
INSERT INTO `lang_definitions` VALUES (3092, 9778, 2, '0');
INSERT INTO `lang_definitions` VALUES (3093, 9779, 2, '0-10');
INSERT INTO `lang_definitions` VALUES (3094, 9780, 2, '0-24');
INSERT INTO `lang_definitions` VALUES (3095, 9783, 2, '1');
INSERT INTO `lang_definitions` VALUES (3096, 9784, 2, '46 = Sverige. Se http://www.wtng.info för lista på andra landskoder');
INSERT INTO `lang_definitions` VALUES (3097, 9789, 2, '1.Vila 2. Lägg på is i två dagar 3. Komprimering lämna förbandet på plats om inte foten utvecklar domningar eller blek färg 4. Ha foten och ben i Upphöjt läge.');
INSERT INTO `lang_definitions` VALUES (3098, 9790, 2, '11-14');
INSERT INTO `lang_definitions` VALUES (3099, 9791, 2, '12 hr');
INSERT INTO `lang_definitions` VALUES (3100, 9792, 2, '15-19');
INSERT INTO `lang_definitions` VALUES (3101, 9801, 2, '20-24');
INSERT INTO `lang_definitions` VALUES (3102, 9810, 2, '2111-13');
INSERT INTO `lang_definitions` VALUES (3103, 9813, 2, '25-29');
INSERT INTO `lang_definitions` VALUES (3104, 9815, 2, '2:a');
INSERT INTO `lang_definitions` VALUES (3105, 9817, 2, '3 månader');
INSERT INTO `lang_definitions` VALUES (3106, 9819, 2, '3 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3107, 9821, 2, '30-34');
INSERT INTO `lang_definitions` VALUES (3108, 9822, 2, '35-39');
INSERT INTO `lang_definitions` VALUES (3109, 9824, 2, '3:e');
INSERT INTO `lang_definitions` VALUES (3110, 9826, 2, '4 månader');
INSERT INTO `lang_definitions` VALUES (3111, 9828, 2, '4 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3112, 9830, 2, '40-44');
INSERT INTO `lang_definitions` VALUES (3113, 9831, 2, '45');
INSERT INTO `lang_definitions` VALUES (3114, 9840, 2, '4:e');
INSERT INTO `lang_definitions` VALUES (3115, 9846, 2, '5:e');
INSERT INTO `lang_definitions` VALUES (3116, 9847, 2, '6 dagar från nu');
INSERT INTO `lang_definitions` VALUES (3117, 9848, 2, '6 månader');
INSERT INTO `lang_definitions` VALUES (3118, 9849, 2, '6 månader från nu');
INSERT INTO `lang_definitions` VALUES (3119, 9850, 2, '6 veckor från nu');
INSERT INTO `lang_definitions` VALUES (3120, 9851, 2, '6:e');
INSERT INTO `lang_definitions` VALUES (3121, 9852, 2, '7 månader från nu');
INSERT INTO `lang_definitions` VALUES (3122, 9853, 2, '8 månader från nu');
INSERT INTO `lang_definitions` VALUES (3123, 9855, 2, '824.0 Sluten fraktur mediala malleolen');
INSERT INTO `lang_definitions` VALUES (3124, 9856, 2, '824.2 Sluten fraktur laterala malleolen');
INSERT INTO `lang_definitions` VALUES (3125, 9857, 2, '842.6 Sluten trimalleolarfraktur');
INSERT INTO `lang_definitions` VALUES (3126, 9858, 2, '825.32 Fraktur os naviculare (fotled)');
INSERT INTO `lang_definitions` VALUES (3127, 9859, 2, '825.35 Fraktur basen av 5:e metatarsalbenet');
INSERT INTO `lang_definitions` VALUES (3128, 9860, 2, '845.00 Stukad fotled UNS');
INSERT INTO `lang_definitions` VALUES (3129, 9861, 2, '845.01 Stukad fotled deltoideus lig.');
INSERT INTO `lang_definitions` VALUES (3130, 9862, 2, '845.02 Stukad fortled, fc-ligament');
INSERT INTO `lang_definitions` VALUES (3131, 9863, 2, '9 månader från nu');
INSERT INTO `lang_definitions` VALUES (3132, 9864, 2, '99212 Etablerade - okomplicerad');
INSERT INTO `lang_definitions` VALUES (3133, 9865, 2, '99213 Etablerade - Låg komplexitet');
INSERT INTO `lang_definitions` VALUES (3134, 9866, 2, '< I undersökningsrummet');
INSERT INTO `lang_definitions` VALUES (3135, 9870, 2, '> Avslutat');
INSERT INTO `lang_definitions` VALUES (3136, 9872, 2, '?');
INSERT INTO `lang_definitions` VALUES (3137, 9874, 2, '? Har ej dykt upp på avtalad tid');
INSERT INTO `lang_definitions` VALUES (3138, 9875, 2, 'Anlänt');
INSERT INTO `lang_definitions` VALUES (3139, 9877, 2, '[Ändra vy]');
INSERT INTO `lang_definitions` VALUES (3140, 9878, 2, '[Datum för senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3141, 9879, 2, '[Dagar sedan senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3142, 9882, 2, '[rekommenderas inte]');
INSERT INTO `lang_definitions` VALUES (3143, 9883, 2, '[Antalet möten]');
INSERT INTO `lang_definitions` VALUES (3144, 9884, 2, '[Rapporter]');
INSERT INTO `lang_definitions` VALUES (3145, 9885, 2, '[Markera alla]');
INSERT INTO `lang_definitions` VALUES (3146, 9886, 2, '[SQL-Ledger]');
INSERT INTO `lang_definitions` VALUES (3147, 9887, 2, '[Starta batchprocess]');
INSERT INTO `lang_definitions` VALUES (3148, 9888, 2, '[Titta på logg]');
INSERT INTO `lang_definitions` VALUES (3149, 9889, 2, '[Se utskrivbar rapport]');
INSERT INTO `lang_definitions` VALUES (3150, 9891, 2, '_PC_DUR_HOURS');
INSERT INTO `lang_definitions` VALUES (3151, 9892, 2, '_PC_DUR_MINUTES');
INSERT INTO `lang_definitions` VALUES (3152, 9893, 2, '_PC_LOCALE');
INSERT INTO `lang_definitions` VALUES (3153, 9894, 2, '~ Kommit sent');
INSERT INTO `lang_definitions` VALUES (3154, 1, 3, 'Un, Una');
INSERT INTO `lang_definitions` VALUES (3155, 2, 3, 'Un número de cheque o reclamación para identificar el pago');
INSERT INTO `lang_definitions` VALUES (3156, 4, 3, 'Un certificado de cliente para el usuario administrador');
INSERT INTO `lang_definitions` VALUES (3157, 5, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3158, 6, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3159, 8, 3, 'Se requiere un distribuidor');
INSERT INTO `lang_definitions` VALUES (3160, 9, 3, 'Formulario de visita GCAC debe ser agregado a esta visita');
INSERT INTO `lang_definitions` VALUES (3161, 11, 3, 'Un número de lote es requerido');
INSERT INTO `lang_definitions` VALUES (3162, 12, 3, 'Un número de lote es requerido!');
INSERT INTO `lang_definitions` VALUES (3163, 13, 3, 'Una letra minúscula');
INSERT INTO `lang_definitions` VALUES (3164, 14, 3, 'Un número');
INSERT INTO `lang_definitions` VALUES (3165, 15, 3, 'Debe seleccionar un paciente para generar un reporte');
INSERT INTO `lang_definitions` VALUES (3166, 16, 3, 'Un paciente con ese Nº ID ya existe');
INSERT INTO `lang_definitions` VALUES (3167, 17, 3, 'Un paciente con este nombre ya existe.');
INSERT INTO `lang_definitions` VALUES (3168, 18, 3, 'Un paciente con este Nº Seguridad Social ya existe');
INSERT INTO `lang_definitions` VALUES (3169, 20, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3170, 21, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3171, 23, 3, 'Una fuente de derivación puede ser especificada para cada visita');
INSERT INTO `lang_definitions` VALUES (3172, 24, 3, 'Un código IPPF relacionado es requerido!');
INSERT INTO `lang_definitions` VALUES (3173, 26, 3, 'Un carácter especial');
INSERT INTO `lang_definitions` VALUES (3174, 27, 3, 'Un valor único para identificar este campo, no visible al usuario');
INSERT INTO `lang_definitions` VALUES (3175, 30, 3, 'antes de las comidas');
INSERT INTO `lang_definitions` VALUES (3176, 31, 3, 'a.m.');
INSERT INTO `lang_definitions` VALUES (3177, 33, 3, 'A/F Nivel de Derecho:');
INSERT INTO `lang_definitions` VALUES (3178, 34, 3, 'AB');
INSERT INTO `lang_definitions` VALUES (3179, 35, 3, 'Abreviatura');
INSERT INTO `lang_definitions` VALUES (3180, 36, 3, 'Abceso:');
INSERT INTO `lang_definitions` VALUES (3181, 37, 3, 'Abdominal');
INSERT INTO `lang_definitions` VALUES (3182, 38, 3, 'Capaz de cargar peso cuatro (4) pasos:');
INSERT INTO `lang_definitions` VALUES (3183, 39, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3184, 40, 3, 'ABN1');
INSERT INTO `lang_definitions` VALUES (3185, 41, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3186, 42, 3, 'Análisis de sangre anormal');
INSERT INTO `lang_definitions` VALUES (3187, 43, 3, 'Crecimiento anormal del pelo');
INSERT INTO `lang_definitions` VALUES (3188, 44, 3, 'Mamografía anormal');
INSERT INTO `lang_definitions` VALUES (3189, 46, 3, 'Aborto');
INSERT INTO `lang_definitions` VALUES (3190, 47, 3, 'Problemas del Aborto');
INSERT INTO `lang_definitions` VALUES (3191, 48, 3, 'Método abortivo');
INSERT INTO `lang_definitions` VALUES (3192, 49, 3, 'Categorías relacionadas al Aborto');
INSERT INTO `lang_definitions` VALUES (3193, 50, 3, 'Abortos');
INSERT INTO `lang_definitions` VALUES (3194, 51, 3, 'Acerca de');
INSERT INTO `lang_definitions` VALUES (3195, 53, 3, 'Acerca del calendario');
INSERT INTO `lang_definitions` VALUES (3196, 56, 3, 'Ausencias por Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3197, 58, 3, 'Aceptar la tarea');
INSERT INTO `lang_definitions` VALUES (3198, 59, 3, 'Aceptar pago por');
INSERT INTO `lang_definitions` VALUES (3199, 60, 3, 'Aceptar Pago por');
INSERT INTO `lang_definitions` VALUES (3200, 61, 3, 'Acepta la tarea');
INSERT INTO `lang_definitions` VALUES (3201, 62, 3, 'Control de acceso');
INSERT INTO `lang_definitions` VALUES (3202, 63, 3, 'Administración de la Lista de Control de Acceso');
INSERT INTO `lang_definitions` VALUES (3203, 70, 3, 'Acceso no permitido');
INSERT INTO `lang_definitions` VALUES (3204, 73, 3, 'Acceder al Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3205, 74, 3, 'Accidente');
INSERT INTO `lang_definitions` VALUES (3206, 80, 3, 'Nombre de la Cuenta');
INSERT INTO `lang_definitions` VALUES (3207, 83, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3208, 88, 3, 'Dolores');
INSERT INTO `lang_definitions` VALUES (3209, 90, 3, 'Solicitud de reconocimiento (ISA14)');
INSERT INTO `lang_definitions` VALUES (3210, 91, 3, 'Reconocimientos, Licencias y Certificaciones');
INSERT INTO `lang_definitions` VALUES (3211, 92, 3, 'ACL');
INSERT INTO `lang_definitions` VALUES (3212, 93, 3, 'ACL Administración');
INSERT INTO `lang_definitions` VALUES (3213, 95, 3, 'ACL Administración no autorizada');
INSERT INTO `lang_definitions` VALUES (3214, 97, 3, 'ACL actualizada exitósamente');
INSERT INTO `lang_definitions` VALUES (3215, 98, 3, 'Acné');
INSERT INTO `lang_definitions` VALUES (3216, 101, 3, 'Acta');
INSERT INTO `lang_definitions` VALUES (3217, 102, 3, 'Fecha de Acta');
INSERT INTO `lang_definitions` VALUES (3218, 103, 3, 'Acción');
INSERT INTO `lang_definitions` VALUES (3219, 107, 3, 'Acciones');
INSERT INTO `lang_definitions` VALUES (3220, 108, 3, 'Activar');
INSERT INTO `lang_definitions` VALUES (3221, 109, 3, 'Activar Reportes CCR/CCD');
INSERT INTO `lang_definitions` VALUES (3222, 113, 3, 'Activo');
INSERT INTO `lang_definitions` VALUES (3223, 114, 3, 'Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3224, 115, 3, 'Reglas de Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3225, 116, 3, 'Alertas activas/Recordatorios');
INSERT INTO `lang_definitions` VALUES (3226, 121, 3, 'Visita Activa');
INSERT INTO `lang_definitions` VALUES (3227, 123, 3, 'Listas Activas');
INSERT INTO `lang_definitions` VALUES (3228, 125, 3, 'Paciente Activo');
INSERT INTO `lang_definitions` VALUES (3229, 126, 3, 'Planes Activos');
INSERT INTO `lang_definitions` VALUES (3230, 128, 3, 'Actividad');
INSERT INTO `lang_definitions` VALUES (3231, 129, 3, 'Tipo de Actividad');
INSERT INTO `lang_definitions` VALUES (3232, 142, 3, 'Agudo en Crónico');
INSERT INTO `lang_definitions` VALUES (3233, 144, 3, 'añadir');
INSERT INTO `lang_definitions` VALUES (3234, 145, 3, 'Añadir');
INSERT INTO `lang_definitions` VALUES (3235, 146, 3, 'AÑADIR');
INSERT INTO `lang_definitions` VALUES (3236, 147, 3, 'Añadir una Sociedad');
INSERT INTO `lang_definitions` VALUES (3237, 150, 3, 'Añadir una Farmacia');
INSERT INTO `lang_definitions` VALUES (3238, 152, 3, 'Añadir un evento para');
INSERT INTO `lang_definitions` VALUES (3239, 153, 3, 'Añadir como nueva nota');
INSERT INTO `lang_definitions` VALUES (3240, 154, 3, 'Añadir como Nuevo');
INSERT INTO `lang_definitions` VALUES (3241, 157, 3, 'Agregar Botones');
INSERT INTO `lang_definitions` VALUES (3242, 158, 3, 'Agregar botones para caracteres especiales, Textos serán mostrados sobre el editor para incluir en el texto con un Click.');
INSERT INTO `lang_definitions` VALUES (3243, 159, 3, 'Añadir Categoría');
INSERT INTO `lang_definitions` VALUES (3244, 160, 3, 'Añadir Constante');
INSERT INTO `lang_definitions` VALUES (3245, 161, 3, 'Añadir Contexto');
INSERT INTO `lang_definitions` VALUES (3246, 162, 3, 'Añadir Co-pago');
INSERT INTO `lang_definitions` VALUES (3247, 163, 3, 'Añadir Criterios');
INSERT INTO `lang_definitions` VALUES (3248, 164, 3, 'Añadir Botón Personalizado');
INSERT INTO `lang_definitions` VALUES (3249, 167, 3, 'Añadir Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3250, 168, 3, 'Añadir Medicamento');
INSERT INTO `lang_definitions` VALUES (3251, 170, 3, 'Añadir Visita');
INSERT INTO `lang_definitions` VALUES (3252, 171, 3, 'Añadir Visita/notas');
INSERT INTO `lang_definitions` VALUES (3253, 172, 3, 'Añadir Centro');
INSERT INTO `lang_definitions` VALUES (3254, 173, 3, 'Añadir Campo');
INSERT INTO `lang_definitions` VALUES (3255, 174, 3, 'Añadir las siguientes líneas al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3256, 175, 3, 'Añadir Grupo');
INSERT INTO `lang_definitions` VALUES (3257, 177, 3, 'Añadir Código CIE');
INSERT INTO `lang_definitions` VALUES (3258, 178, 3, 'Agregar Vacunación');
INSERT INTO `lang_definitions` VALUES (3259, 179, 3, 'Añadir no permitido!');
INSERT INTO `lang_definitions` VALUES (3260, 180, 3, 'Añadir Incidencia');
INSERT INTO `lang_definitions` VALUES (3261, 182, 3, 'Añadir Idioma');
INSERT INTO `lang_definitions` VALUES (3262, 186, 3, 'Añadir Nuevo');
INSERT INTO `lang_definitions` VALUES (3263, 187, 3, 'Añadir nuevo');
INSERT INTO `lang_definitions` VALUES (3264, 188, 3, 'Añadir nueva categoría:');
INSERT INTO `lang_definitions` VALUES (3265, 189, 3, 'Añadir nuevos Certificados al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3266, 193, 3, 'Añadir Nuevo Grupo');
INSERT INTO `lang_definitions` VALUES (3267, 196, 3, 'Añadir nuevo lote y transacción');
INSERT INTO `lang_definitions` VALUES (3268, 197, 3, 'Añadir Nueva Nota');
INSERT INTO `lang_definitions` VALUES (3269, 198, 3, 'Añadir nueva nota');
INSERT INTO `lang_definitions` VALUES (3270, 199, 3, 'Añadir Nuevo Socio');
INSERT INTO `lang_definitions` VALUES (3271, 202, 3, 'Añadir Nota');
INSERT INTO `lang_definitions` VALUES (3272, 206, 3, 'Añadir Registro de Paciente');
INSERT INTO `lang_definitions` VALUES (3273, 207, 3, 'Añadir Receta');
INSERT INTO `lang_definitions` VALUES (3274, 209, 3, 'Añadir numero del proveedor');
INSERT INTO `lang_definitions` VALUES (3275, 211, 3, 'Añadir Rehabilitación');
INSERT INTO `lang_definitions` VALUES (3276, 212, 3, 'Añadir Regla');
INSERT INTO `lang_definitions` VALUES (3277, 214, 3, 'Añadir a');
INSERT INTO `lang_definitions` VALUES (3278, 215, 3, 'Añadir a Lista de Medicación');
INSERT INTO `lang_definitions` VALUES (3279, 216, 3, 'Añadir Nivel Superior');
INSERT INTO `lang_definitions` VALUES (3280, 217, 3, 'Añadir Transacción');
INSERT INTO `lang_definitions` VALUES (3281, 218, 3, 'Añadir Usuario');
INSERT INTO `lang_definitions` VALUES (3282, 219, 3, 'Añadir Usuario al Grupo');
INSERT INTO `lang_definitions` VALUES (3283, 221, 3, 'Añadir/Editar Receta electrónica');
INSERT INTO `lang_definitions` VALUES (3284, 222, 3, 'Añadir/Editar Transacción de paciente');
INSERT INTO `lang_definitions` VALUES (3285, 223, 3, 'añadido');
INSERT INTO `lang_definitions` VALUES (3286, 226, 3, 'Añadir datos demográficos no autorizado.');
INSERT INTO `lang_definitions` VALUES (3287, 228, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3288, 229, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3289, 230, 3, 'Atributos adicionales');
INSERT INTO `lang_definitions` VALUES (3290, 233, 3, 'Diagnóstico adicional:');
INSERT INTO `lang_definitions` VALUES (3291, 235, 3, 'Historia Adicional');
INSERT INTO `lang_definitions` VALUES (3292, 236, 3, 'Notas adicionales a la historia');
INSERT INTO `lang_definitions` VALUES (3293, 237, 3, 'Información adicional');
INSERT INTO `lang_definitions` VALUES (3294, 238, 3, 'Laboratorios adicionales');
INSERT INTO `lang_definitions` VALUES (3295, 239, 3, 'Notas adicionales');
INSERT INTO `lang_definitions` VALUES (3296, 241, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3297, 242, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3298, 243, 3, 'Notas de Rayos X adicionales:');
INSERT INTO `lang_definitions` VALUES (3299, 246, 3, 'Sólo añadir');
INSERT INTO `lang_definitions` VALUES (3300, 248, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3301, 249, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3302, 250, 3, 'Dirección');
INSERT INTO `lang_definitions` VALUES (3303, 251, 3, 'Dirección y Código Postal');
INSERT INTO `lang_definitions` VALUES (3304, 252, 3, 'Dirección y Provincia/Departamento');
INSERT INTO `lang_definitions` VALUES (3305, 253, 3, 'Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3306, 254, 3, 'Entrada a la libreta de Direcciones de la empresa que realiza este procedimiento');
INSERT INTO `lang_definitions` VALUES (3307, 255, 3, 'Entrada a la libreta de Direcciones para el distribuidor');
INSERT INTO `lang_definitions` VALUES (3308, 256, 3, 'Entrada a la Libreta de Direcciones para el vendedor');
INSERT INTO `lang_definitions` VALUES (3309, 257, 3, 'Tipos de Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3310, 258, 3, 'Etiqueta de Dirección');
INSERT INTO `lang_definitions` VALUES (3311, 259, 3, 'Etiquetas de Dirección');
INSERT INTO `lang_definitions` VALUES (3312, 260, 3, 'Dirección Sola');
INSERT INTO `lang_definitions` VALUES (3313, 262, 3, 'Dirección, Provincia/Estado/Departamento y Código Postal');
INSERT INTO `lang_definitions` VALUES (3314, 263, 3, 'Dirección1');
INSERT INTO `lang_definitions` VALUES (3315, 264, 3, 'Dirección2');
INSERT INTO `lang_definitions` VALUES (3316, 266, 3, 'DESTINATARIO');
INSERT INTO `lang_definitions` VALUES (3317, 269, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3318, 270, 3, 'Importe de Ajuste');
INSERT INTO `lang_definitions` VALUES (3319, 271, 3, 'Ajustar');
INSERT INTO `lang_definitions` VALUES (3320, 272, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3321, 273, 3, 'Ajuste importe');
INSERT INTO `lang_definitions` VALUES (3322, 274, 3, 'Motivos del ajuste');
INSERT INTO `lang_definitions` VALUES (3323, 275, 3, 'Valor de ajuste para código');
INSERT INTO `lang_definitions` VALUES (3324, 276, 3, 'Ajustes');
INSERT INTO `lang_definitions` VALUES (3325, 277, 3, 'Ajuste administrador');
INSERT INTO `lang_definitions` VALUES (3326, 278, 3, 'Administrador');
INSERT INTO `lang_definitions` VALUES (3327, 279, 3, 'email administrador');
INSERT INTO `lang_definitions` VALUES (3328, 280, 3, 'Administrar a través de');
INSERT INTO `lang_definitions` VALUES (3329, 281, 3, 'Administrado');
INSERT INTO `lang_definitions` VALUES (3330, 282, 3, 'Administrado por');
INSERT INTO `lang_definitions` VALUES (3331, 283, 3, 'Fecha Administrado');
INSERT INTO `lang_definitions` VALUES (3332, 284, 3, 'Sitio Administrado');
INSERT INTO `lang_definitions` VALUES (3333, 285, 3, 'Administración');
INSERT INTO `lang_definitions` VALUES (3334, 287, 3, 'Sitio de administración');
INSERT INTO `lang_definitions` VALUES (3335, 288, 3, 'Administradores');
INSERT INTO `lang_definitions` VALUES (3336, 289, 3, 'Los administradores pueden hacer todo');
INSERT INTO `lang_definitions` VALUES (3337, 293, 3, 'Revisión Peso de Adulto y Seguimiento');
INSERT INTO `lang_definitions` VALUES (3338, 294, 3, 'Revisión Peso de Adulto y Seguimiento (GCC)');
INSERT INTO `lang_definitions` VALUES (3339, 295, 3, 'Instrucción anticipada');
INSERT INTO `lang_definitions` VALUES (3340, 296, 3, 'Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3341, 297, 3, 'Aviso Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3342, 299, 3, 'Anticipado');
INSERT INTO `lang_definitions` VALUES (3343, 301, 3, 'Consejo');
INSERT INTO `lang_definitions` VALUES (3344, 303, 3, 'Afecta normales');
INSERT INTO `lang_definitions` VALUES (3345, 307, 3, 'llamadas fuera horario laboral');
INSERT INTO `lang_definitions` VALUES (3346, 309, 3, 'Después de hacer las configuraciones mencionadas, importar el certificado del cliente de administrador al navegador y reiniciar el servidor Apache (Contraseña vacía)');
INSERT INTO `lang_definitions` VALUES (3347, 310, 3, 'Después de guardar el PDF, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3348, 311, 3, 'Después de guardar los ficheros de TEXTO, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3349, 312, 3, 'Después de guardar su Batch, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3350, 314, 3, 'Una vez completada la informacion correctamente, click en botón Guardar');
INSERT INTO `lang_definitions` VALUES (3351, 315, 3, 'Después de subir, haga click en el botón \"Importar\"');
INSERT INTO `lang_definitions` VALUES (3352, 317, 3, 'Planificación posterior al cuidado');
INSERT INTO `lang_definitions` VALUES (3353, 318, 3, 'Otra vez');
INSERT INTO `lang_definitions` VALUES (3354, 319, 3, 'Edad');
INSERT INTO `lang_definitions` VALUES (3355, 320, 3, 'Por Edad');
INSERT INTO `lang_definitions` VALUES (3356, 321, 3, 'Categoría edad');
INSERT INTO `lang_definitions` VALUES (3357, 322, 3, 'Dato edad fuera de rango.');
INSERT INTO `lang_definitions` VALUES (3358, 323, 3, 'Formato para mostrar edad');
INSERT INTO `lang_definitions` VALUES (3359, 324, 3, 'Formato edad en \'desde edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3360, 325, 3, 'Formato edad en \'hasta edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3361, 326, 3, 'Edad desde');
INSERT INTO `lang_definitions` VALUES (3362, 327, 3, 'Edad en años para cambio de formato');
INSERT INTO `lang_definitions` VALUES (3363, 328, 3, 'Edad Máxima');
INSERT INTO `lang_definitions` VALUES (3364, 329, 3, 'Edad Mínima');
INSERT INTO `lang_definitions` VALUES (3365, 330, 3, 'Rango de Edad');
INSERT INTO `lang_definitions` VALUES (3366, 332, 3, 'Columnas del envejecimiento:');
INSERT INTO `lang_definitions` VALUES (3367, 334, 3, 'Albanés');
INSERT INTO `lang_definitions` VALUES (3368, 335, 3, 'Alcohol');
INSERT INTO `lang_definitions` VALUES (3369, 336, 3, 'Consumo de alcohol');
INSERT INTO `lang_definitions` VALUES (3370, 339, 3, 'Contador de Alerta');
INSERT INTO `lang_definitions` VALUES (3371, 344, 3, 'Alertas');
INSERT INTO `lang_definitions` VALUES (3372, 348, 3, 'ALEUTIANO');
INSERT INTO `lang_definitions` VALUES (3373, 349, 3, 'Todos');
INSERT INTO `lang_definitions` VALUES (3374, 350, 3, 'TODOS');
INSERT INTO `lang_definitions` VALUES (3375, 352, 3, 'Todos (Formatos Compaginados A)');
INSERT INTO `lang_definitions` VALUES (3376, 353, 3, 'Todos (Formatos Compaginados B)');
INSERT INTO `lang_definitions` VALUES (3377, 354, 3, 'Todos (Acumulativo)');
INSERT INTO `lang_definitions` VALUES (3378, 357, 3, 'Todas las Categorías');
INSERT INTO `lang_definitions` VALUES (3379, 359, 3, 'Todos los Códigos');
INSERT INTO `lang_definitions` VALUES (3380, 361, 3, 'Todo el día');
INSERT INTO `lang_definitions` VALUES (3381, 362, 3, 'Evento de día completo');
INSERT INTO `lang_definitions` VALUES (3382, 363, 3, 'Todos los campos demográficos, con búsqueda y chequeo de dupicados');
INSERT INTO `lang_definitions` VALUES (3383, 365, 3, 'Todas las Clínicas');
INSERT INTO `lang_definitions` VALUES (3384, 366, 3, 'Todas las Lesiones/Problemas/Incidencias');
INSERT INTO `lang_definitions` VALUES (3385, 367, 3, 'Permitidos todos los Idiomas');
INSERT INTO `lang_definitions` VALUES (3386, 370, 3, 'Todo o parte del nombre');
INSERT INTO `lang_definitions` VALUES (3387, 371, 3, 'Todo o parte del apellido');
INSERT INTO `lang_definitions` VALUES (3388, 372, 3, 'Todo o parte de la organización');
INSERT INTO `lang_definitions` VALUES (3389, 374, 3, 'Todos los productos');
INSERT INTO `lang_definitions` VALUES (3390, 375, 3, 'Todos los proveedores');
INSERT INTO `lang_definitions` VALUES (3391, 376, 3, 'Todos Revisados y Negativos:');
INSERT INTO `lang_definitions` VALUES (3392, 378, 3, 'Todos los Temas');
INSERT INTO `lang_definitions` VALUES (3393, 379, 3, 'Todos los Usuarios');
INSERT INTO `lang_definitions` VALUES (3394, 380, 3, 'Alérgico');
INSERT INTO `lang_definitions` VALUES (3395, 382, 3, 'Alergias');
INSERT INTO `lang_definitions` VALUES (3396, 383, 3, 'Alergias:');
INSERT INTO `lang_definitions` VALUES (3397, 384, 3, 'Alergia');
INSERT INTO `lang_definitions` VALUES (3398, 385, 3, 'Importación de Alergia completado con éxito');
INSERT INTO `lang_definitions` VALUES (3399, 387, 3, 'Reacción Alérgica');
INSERT INTO `lang_definitions` VALUES (3400, 390, 3, 'Asignar');
INSERT INTO `lang_definitions` VALUES (3401, 391, 3, 'Permitir');
INSERT INTO `lang_definitions` VALUES (3402, 393, 3, 'Permitir todos los idiomas disponibles como opción en el menú de inicio sesión.');
INSERT INTO `lang_definitions` VALUES (3403, 395, 3, 'Permitir creación de reclamaciones con diagnósticos pero no procedimientos o cargos. La mayoría de clínicas no desean esto.');
INSERT INTO `lang_definitions` VALUES (3404, 396, 3, 'Permitir Depuración de Idioma');
INSERT INTO `lang_definitions` VALUES (3405, 398, 3, 'Permitir Email');
INSERT INTO `lang_definitions` VALUES (3406, 399, 3, '¿Permitir mensajes email?');
INSERT INTO `lang_definitions` VALUES (3407, 400, 3, '¿Permitir Email?');
INSERT INTO `lang_definitions` VALUES (3408, 401, 3, 'Permitir reclamación de Visita');
INSERT INTO `lang_definitions` VALUES (3409, 403, 3, 'Permitir el Intercambio de Información de Salud');
INSERT INTO `lang_definitions` VALUES (3410, 405, 3, 'Permitir Compartir Información de Vacunación');
INSERT INTO `lang_definitions` VALUES (3411, 406, 3, 'Permitir el Uso del Registro de Vacunaciones');
INSERT INTO `lang_definitions` VALUES (3412, 408, 3, 'Permitir mensajes email');
INSERT INTO `lang_definitions` VALUES (3413, 412, 3, 'Permitir Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3414, 414, 3, 'Permitir SMS');
INSERT INTO `lang_definitions` VALUES (3415, 415, 3, '¿Permitir SMS (mensajes de texto)?');
INSERT INTO `lang_definitions` VALUES (3416, 417, 3, '¿Permitir la activación instantánea de los eventos introducidos?');
INSERT INTO `lang_definitions` VALUES (3417, 418, 3, '¿Permitir mensajes telefónicos?');
INSERT INTO `lang_definitions` VALUES (3418, 420, 3, 'Permitir a los usuarios publicar eventos globales');
INSERT INTO `lang_definitions` VALUES (3419, 421, 3, 'Permitir a los usuarios publicar calendarios personales');
INSERT INTO `lang_definitions` VALUES (3420, 427, 3, 'Permitir Mensaje de Voz');
INSERT INTO `lang_definitions` VALUES (3421, 428, 3, 'Permitido');
INSERT INTO `lang_definitions` VALUES (3422, 429, 3, 'Idiomas Permitidos');
INSERT INTO `lang_definitions` VALUES (3423, 431, 3, 'Asignado ©');
INSERT INTO `lang_definitions` VALUES (3424, 432, 3, 'Permite E-sign en todo el encuentro');
INSERT INTO `lang_definitions` VALUES (3425, 433, 3, 'Permite E-sign para formas individuales');
INSERT INTO `lang_definitions` VALUES (3426, 434, 3, 'Permitir Correo Electrónico');
INSERT INTO `lang_definitions` VALUES (3427, 435, 3, 'Permitir Mensajes de voz');
INSERT INTO `lang_definitions` VALUES (3428, 436, 3, 'ya existe');
INSERT INTO `lang_definitions` VALUES (3429, 437, 3, 'ya existe.');
INSERT INTO `lang_definitions` VALUES (3430, 439, 3, 'Identificador ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3431, 440, 3, 'Título ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3432, 441, 3, 'Dirección alternativa');
INSERT INTO `lang_definitions` VALUES (3433, 442, 3, 'modificar');
INSERT INTO `lang_definitions` VALUES (3434, 444, 3, 'De forma alternativa, puede usar la página de búsqueda para cargar un fichero electrónico (X12835) que haya recibido de su pagador. Puede hacerlo presionando el botón Explorar y seleccionar el fichero a cargar, y luego pulsando Explorar para ejecutar la carga y mostrar las facturas correspondientes. En este caso, los otros parámetros mencionados arriba no se aplican y pueden ser ignorados. La carga guarda el fichero pero no procesa su contenido - esto se realiza de forma separada como se describe abajo.');
INSERT INTO `lang_definitions` VALUES (3435, 445, 3, 'AM');
INSERT INTO `lang_definitions` VALUES (3436, 446, 3, 'Programa AM');
INSERT INTO `lang_definitions` VALUES (3437, 451, 3, 'Cálculo Automático de Medidas (CAM)');
INSERT INTO `lang_definitions` VALUES (3438, 452, 3, 'Rastreo CAM');
INSERT INTO `lang_definitions` VALUES (3439, 458, 3, 'Corregir nota existente');
INSERT INTO `lang_definitions` VALUES (3440, 465, 3, 'Indígena americano');
INSERT INTO `lang_definitions` VALUES (3441, 466, 3, 'Indígena americano o Nativo de Alaska');
INSERT INTO `lang_definitions` VALUES (3442, 467, 3, 'AMEX');
INSERT INTO `lang_definitions` VALUES (3443, 468, 3, 'Amárico (Lengua de Etiopia)');
INSERT INTO `lang_definitions` VALUES (3444, 469, 3, 'Importe');
INSERT INTO `lang_definitions` VALUES (3445, 471, 3, 'Importes Cargados');
INSERT INTO `lang_definitions` VALUES (3446, 474, 3, 'Importe Saldo Vencido');
INSERT INTO `lang_definitions` VALUES (3447, 475, 3, 'Importe por esta visita');
INSERT INTO `lang_definitions` VALUES (3448, 476, 3, 'Importe pagado');
INSERT INTO `lang_definitions` VALUES (3449, 477, 3, 'Importe:');
INSERT INTO `lang_definitions` VALUES (3450, 480, 3, 'Importe Facturado');
INSERT INTO `lang_definitions` VALUES (3451, 482, 3, '¡Se requiere una fecha de finalización posterior a la fecha de inicio para los eventos repetidos!');
INSERT INTO `lang_definitions` VALUES (3452, 484, 3, 'Ocurrió un error durante la descarga web de los directorios de OpenEMR');
INSERT INTO `lang_definitions` VALUES (3453, 485, 3, 'Ocurrió un error durante la descarga web de los directorios de phpGACL');
INSERT INTO `lang_definitions` VALUES (3454, 486, 3, 'Ocurrió un error durante la descarga web de los directorios SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3455, 488, 3, 'Una incidencia GCAC incompleta ha sido creada y vinculada. Alguien tendrá que completarla más tarde.');
INSERT INTO `lang_definitions` VALUES (3456, 490, 3, 'Ocurrio un error inesperado.');
INSERT INTO `lang_definitions` VALUES (3457, 491, 3, 'Una letra mayúscula');
INSERT INTO `lang_definitions` VALUES (3458, 493, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3459, 494, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3460, 495, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3461, 496, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3462, 497, 3, '¿y toda la información subordinada? Esta acción será registrada');
INSERT INTO `lang_definitions` VALUES (3463, 498, 3, 'y modificador');
INSERT INTO `lang_definitions` VALUES (3464, 499, 3, 'y procesado.');
INSERT INTO `lang_definitions` VALUES (3465, 500, 3, 'y reiniciar servidor Apache');
INSERT INTO `lang_definitions` VALUES (3466, 501, 3, 'y la Razón es');
INSERT INTO `lang_definitions` VALUES (3467, 502, 3, 'Anemia');
INSERT INTO `lang_definitions` VALUES (3468, 503, 3, 'Tobillo');
INSERT INTO `lang_definitions` VALUES (3469, 504, 3, 'Tobillo + talón');
INSERT INTO `lang_definitions` VALUES (3470, 505, 3, 'Formulario de Evaluación del tobillo');
INSERT INTO `lang_definitions` VALUES (3471, 506, 3, 'Problemas de tobillo');
INSERT INTO `lang_definitions` VALUES (3472, 507, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3473, 508, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3474, 509, 3, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (3475, 510, 3, 'Otra cosa que puede hacer en la ventana de publicación es solicitar facturación secundaria. Si selecciona la casilla de verificación antes de guardar, la reclamación original será reabierta y puesta en cola en la página de Facturación, y será procesada en el siguiente proceso de facturación.');
INSERT INTO `lang_definitions` VALUES (3476, 512, 3, 'ante');
INSERT INTO `lang_definitions` VALUES (3477, 514, 3, 'Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3478, 515, 3, 'Valores por Defecto para el Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3479, 517, 3, 'Ano normal, recto sin distensión ni masa');
INSERT INTO `lang_definitions` VALUES (3480, 518, 3, 'Ansiedad');
INSERT INTO `lang_definitions` VALUES (3481, 519, 3, 'Cualquiera');
INSERT INTO `lang_definitions` VALUES (3482, 522, 3, 'Cualquier Categoría');
INSERT INTO `lang_definitions` VALUES (3483, 525, 3, 'Cualquier parte del código deseado o su descripción');
INSERT INTO `lang_definitions` VALUES (3484, 526, 3, 'Cualquier parte de la especialidad deseada');
INSERT INTO `lang_definitions` VALUES (3485, 527, 3, 'Cualquier parte del identificador o nombre de medicamento');
INSERT INTO `lang_definitions` VALUES (3486, 528, 3, 'Cualquier parte del identificador o nombre de vacuna');
INSERT INTO `lang_definitions` VALUES (3487, 529, 3, 'Cualquier parte del nombre del paciente, o Apellido, Nombre, o X-Y');
INSERT INTO `lang_definitions` VALUES (3488, 531, 3, '¿Algo más ocurre al mismo tiempo?');
INSERT INTO `lang_definitions` VALUES (3489, 533, 3, 'Clave API para puerta enlace SMS');
INSERT INTO `lang_definitions` VALUES (3490, 534, 3, 'Apnea');
INSERT INTO `lang_definitions` VALUES (3491, 536, 3, 'Aspecto');
INSERT INTO `lang_definitions` VALUES (3492, 537, 3, 'Aspecto:');
INSERT INTO `lang_definitions` VALUES (3493, 538, 3, 'Añadir esta nota');
INSERT INTO `lang_definitions` VALUES (3494, 539, 3, 'Añadir a la nota existente');
INSERT INTO `lang_definitions` VALUES (3495, 540, 3, 'Añadir a sta nota');
INSERT INTO `lang_definitions` VALUES (3496, 541, 3, 'Añadir a Esta Nota');
INSERT INTO `lang_definitions` VALUES (3497, 542, 3, 'Apendicectomía');
INSERT INTO `lang_definitions` VALUES (3498, 544, 3, 'Pacientes Aplicables');
INSERT INTO `lang_definitions` VALUES (3499, 546, 3, 'Nombre de aplicación para página de inicio de sesión y título de ventana principal');
INSERT INTO `lang_definitions` VALUES (3500, 547, 3, 'Código de Aplicación del receptor (GS03 - si está en blanco se usará ISA08)');
INSERT INTO `lang_definitions` VALUES (3501, 548, 3, 'Codigo de Aplicacion del Enviador (GS02)');
INSERT INTO `lang_definitions` VALUES (3502, 549, 3, 'Título de Aplicación');
INSERT INTO `lang_definitions` VALUES (3503, 550, 3, 'Se aplica al formulario de Constantes Vitales y Gráfica de Crecimiento');
INSERT INTO `lang_definitions` VALUES (3504, 552, 3, '¿Aplicar los cambios sólo al evento actual, a éste y todos los episodios futuros, o a todos los episodios?');
INSERT INTO `lang_definitions` VALUES (3505, 553, 3, 'aplicar a la zona afectada');
INSERT INTO `lang_definitions` VALUES (3506, 554, 3, 'aplicar a la piel');
INSERT INTO `lang_definitions` VALUES (3507, 555, 3, 'Aplicando');
INSERT INTO `lang_definitions` VALUES (3508, 556, 3, 'Aplicando parche al sitio');
INSERT INTO `lang_definitions` VALUES (3509, 557, 3, 'Cita');
INSERT INTO `lang_definitions` VALUES (3510, 559, 3, 'Fecha de Cita');
INSERT INTO `lang_definitions` VALUES (3511, 565, 3, 'Estilo de visualizacion de la cita');
INSERT INTO `lang_definitions` VALUES (3512, 567, 3, 'Regla para recordar Cita');
INSERT INTO `lang_definitions` VALUES (3513, 569, 3, 'Estado de la Cita');
INSERT INTO `lang_definitions` VALUES (3514, 570, 3, 'Estados de la cita');
INSERT INTO `lang_definitions` VALUES (3515, 571, 3, 'Cita dentro de');
INSERT INTO `lang_definitions` VALUES (3516, 572, 3, 'Color de Cita/Evento');
INSERT INTO `lang_definitions` VALUES (3517, 573, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3518, 574, 3, 'Citas (escriba opcional)');
INSERT INTO `lang_definitions` VALUES (3519, 575, 3, 'Citas (escribir, algunos opcional)');
INSERT INTO `lang_definitions` VALUES (3520, 580, 3, 'Citas y Visitas');
INSERT INTO `lang_definitions` VALUES (3521, 581, 3, 'Encuentros para');
INSERT INTO `lang_definitions` VALUES (3522, 582, 3, 'Informe de citas');
INSERT INTO `lang_definitions` VALUES (3523, 583, 3, 'Informes Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3524, 585, 3, 'Aprobar');
INSERT INTO `lang_definitions` VALUES (3525, 588, 3, 'Aprobado');
INSERT INTO `lang_definitions` VALUES (3526, 589, 3, 'Eventos Administrativos Aprobados');
INSERT INTO `lang_definitions` VALUES (3527, 595, 3, 'Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3528, 597, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3529, 600, 3, 'Abr');
INSERT INTO `lang_definitions` VALUES (3530, 601, 3, 'Abril');
INSERT INTO `lang_definitions` VALUES (3531, 603, 3, 'Arábigo');
INSERT INTO `lang_definitions` VALUES (3532, 604, 3, 'Aragonés');
INSERT INTO `lang_definitions` VALUES (3533, 605, 3, 'Archivo');
INSERT INTO `lang_definitions` VALUES (3534, 606, 3, 'Archivar los Registros Cronológicos');
INSERT INTO `lang_definitions` VALUES (3535, 607, 3, 'Archivas Registros (Logs) Viejos');
INSERT INTO `lang_definitions` VALUES (3536, 608, 3, '¿Se traducen los nombres del grupo de control de acceso?');
INSERT INTO `lang_definitions` VALUES (3537, 609, 3, '¿Se traducen los nombres de las categorías de cita?');
INSERT INTO `lang_definitions` VALUES (3538, 610, 3, '¿Se traducen los nombres de categorías de documento?');
INSERT INTO `lang_definitions` VALUES (3539, 611, 3, '¿Se cobran honorarios por este tipo?');
INSERT INTO `lang_definitions` VALUES (3540, 612, 3, 'están apagados');
INSERT INTO `lang_definitions` VALUES (3541, 613, 3, 'están encendidos');
INSERT INTO `lang_definitions` VALUES (3542, 614, 3, '¿Se traducen los títulos de las notas del paciente?');
INSERT INTO `lang_definitions` VALUES (3543, 615, 3, '¿Están los códigos archivados en tablas sql externas (0-No, 1-CIE10, 2-SNOMED(RF1), 3-SNOMED(rf2))?');
INSERT INTO `lang_definitions` VALUES (3544, 616, 3, '¿Está preparado para completar una nueva incidencia de GCAC (Global Connection Admission Control) para esta visita?');
INSERT INTO `lang_definitions` VALUES (3545, 618, 3, '¿Está seguro de enviar hoy?');
INSERT INTO `lang_definitions` VALUES (3546, 619, 3, '¿Está seguro que quiere aprobar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3547, 620, 3, '¿Está seguro de querer cancelar los cambios?');
INSERT INTO `lang_definitions` VALUES (3548, 621, 3, '¿Está seguro de que desea eliminar por completo este formulario?');
INSERT INTO `lang_definitions` VALUES (3549, 623, 3, '¿Está seguro que desea eliminar este aviso?');
INSERT INTO `lang_definitions` VALUES (3550, 624, 3, '¿Está seguro que quiere eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (3551, 625, 3, '¿Está seguro que quiere eliminar este asunto de la base de datos?');
INSERT INTO `lang_definitions` VALUES (3552, 626, 3, '¿Está usted seguro que quiere eliminar esta nota?');
INSERT INTO `lang_definitions` VALUES (3553, 628, 3, '¿Está seguro que quiere editar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3554, 629, 3, '¿Está seguro que quiere ocultar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3555, 632, 3, '¿Está seguro que quiere visualizar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3556, 633, 3, 'Está seguro que desea eliminar el grupo entero nombrado');
INSERT INTO `lang_definitions` VALUES (3557, 634, 3, 'Está seguro que desea eliminar la lista entera');
INSERT INTO `lang_definitions` VALUES (3558, 635, 3, 'Está seguro que quiere eliminar el campo interno');
INSERT INTO `lang_definitions` VALUES (3559, 636, 3, '¿Está seguro que quiere eliminar los campos seleccionados?');
INSERT INTO `lang_definitions` VALUES (3560, 637, 3, '¿Está seguro que quiere continuar con estas acciones?');
INSERT INTO `lang_definitions` VALUES (3561, 638, 3, 'Zona no especificada');
INSERT INTO `lang_definitions` VALUES (3562, 639, 3, 'Brazo');
INSERT INTO `lang_definitions` VALUES (3563, 640, 3, 'Armenio');
INSERT INTO `lang_definitions` VALUES (3564, 647, 3, 'Arritmia');
INSERT INTO `lang_definitions` VALUES (3565, 648, 3, 'Artritis');
INSERT INTO `lang_definitions` VALUES (3566, 649, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3567, 650, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3568, 653, 3, 'como');
INSERT INTO `lang_definitions` VALUES (3569, 655, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (3570, 658, 3, 'Asiático');
INSERT INTO `lang_definitions` VALUES (3571, 661, 3, 'Evaluación');
INSERT INTO `lang_definitions` VALUES (3572, 663, 3, 'Asignado a');
INSERT INTO `lang_definitions` VALUES (3573, 664, 3, 'Ayudante');
INSERT INTO `lang_definitions` VALUES (3574, 671, 3, 'Asma');
INSERT INTO `lang_definitions` VALUES (3575, 672, 3, 'en');
INSERT INTO `lang_definitions` VALUES (3576, 673, 3, 'Se requiere al menos un parámetro de búsqueda si selecciona Todos.');
INSERT INTO `lang_definitions` VALUES (3577, 674, 3, 'En el Escafoides');
INSERT INTO `lang_definitions` VALUES (3578, 675, 3, 'En el Escafoides:');
INSERT INTO `lang_definitions` VALUES (3579, 676, 3, 'Equipo de atletismo');
INSERT INTO `lang_definitions` VALUES (3580, 678, 3, 'Lesión Deportiva');
INSERT INTO `lang_definitions` VALUES (3581, 679, 3, 'Certificado CA de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3582, 680, 3, 'Host de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3583, 681, 3, 'Certificado local de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3584, 682, 3, 'Puerto de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3585, 685, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3586, 687, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3587, 697, 3, 'Auditoría Backups de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3588, 698, 3, 'Auditoría de inicio de sesión varios');
INSERT INTO `lang_definitions` VALUES (3589, 699, 3, 'Auditoría Orden de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3590, 700, 3, 'Auditoría registro inicio de sesión del paciente');
INSERT INTO `lang_definitions` VALUES (3591, 701, 3, 'Auditoría Planificación inicio sesión');
INSERT INTO `lang_definitions` VALUES (3592, 702, 3, 'Auditoría Administración de Seguridad inicio sesión');
INSERT INTO `lang_definitions` VALUES (3593, 703, 3, 'Auditoría Consulta SELECT inicio sesión');
INSERT INTO `lang_definitions` VALUES (3594, 704, 3, 'Ago');
INSERT INTO `lang_definitions` VALUES (3595, 705, 3, 'Agosto');
INSERT INTO `lang_definitions` VALUES (3596, 707, 3, 'Autorización');
INSERT INTO `lang_definitions` VALUES (3597, 708, 3, 'Autorización/notas');
INSERT INTO `lang_definitions` VALUES (3598, 711, 3, 'Grupo de Autorización');
INSERT INTO `lang_definitions` VALUES (3599, 712, 3, 'Estatus de autorización');
INSERT INTO `lang_definitions` VALUES (3600, 713, 3, 'Autorizaciones');
INSERT INTO `lang_definitions` VALUES (3601, 714, 3, 'Autorizar');
INSERT INTO `lang_definitions` VALUES (3602, 715, 3, 'Autorizar - cualquier visita');
INSERT INTO `lang_definitions` VALUES (3603, 717, 3, 'Autorizar - mis visitas');
INSERT INTO `lang_definitions` VALUES (3604, 721, 3, 'Autorizado');
INSERT INTO `lang_definitions` VALUES (3605, 723, 3, 'Autorización solamente');
INSERT INTO `lang_definitions` VALUES (3606, 726, 3, 'Envío automático');
INSERT INTO `lang_definitions` VALUES (3607, 729, 3, 'Crear automáticamente nuevas visitas');
INSERT INTO `lang_definitions` VALUES (3608, 730, 3, 'Auto-generado');
INSERT INTO `lang_definitions` VALUES (3609, 732, 3, 'Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3610, 737, 3, 'Seguimiento Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3611, 738, 3, 'Medidas Automatizadas');
INSERT INTO `lang_definitions` VALUES (3612, 740, 3, 'Automático');
INSERT INTO `lang_definitions` VALUES (3613, 744, 3, 'Crear automáticamente nuevas visitas cuando en el estado de una cita se selecciona -@- (llegado)');
INSERT INTO `lang_definitions` VALUES (3614, 747, 3, 'Automóvil Médico');
INSERT INTO `lang_definitions` VALUES (3615, 748, 3, 'Autoguardado');
INSERT INTO `lang_definitions` VALUES (3616, 751, 3, 'Categorías Disponibles');
INSERT INTO `lang_definitions` VALUES (3617, 753, 3, 'Horas disponibles');
INSERT INTO `lang_definitions` VALUES (3618, 758, 3, 'Media Mensual');
INSERT INTO `lang_definitions` VALUES (3619, 762, 3, 'Avulsión/fractura por avulsión');
INSERT INTO `lang_definitions` VALUES (3620, 763, 3, 'Avulsión de maleolo lateral');
INSERT INTO `lang_definitions` VALUES (3621, 764, 3, 'Avulsión de maléolo tibial');
INSERT INTO `lang_definitions` VALUES (3622, 765, 3, 'Basado en el Conocimiento');
INSERT INTO `lang_definitions` VALUES (3623, 767, 3, 'Axilar');
INSERT INTO `lang_definitions` VALUES (3624, 774, 3, 'dos veces por día');
INSERT INTO `lang_definitions` VALUES (3625, 775, 3, 'Atrás');
INSERT INTO `lang_definitions` VALUES (3626, 776, 3, 'atrás');
INSERT INTO `lang_definitions` VALUES (3627, 777, 3, 'Retrocede ocho visitas');
INSERT INTO `lang_definitions` VALUES (3628, 778, 3, 'Retrocede once visitas');
INSERT INTO `lang_definitions` VALUES (3629, 779, 3, 'Retroceder cinco visitas');
INSERT INTO `lang_definitions` VALUES (3630, 780, 3, 'Retrocede cuatro visitas');
INSERT INTO `lang_definitions` VALUES (3631, 781, 3, 'Retrocede nueve visitas');
INSERT INTO `lang_definitions` VALUES (3632, 782, 3, 'Retroced una visita');
INSERT INTO `lang_definitions` VALUES (3633, 783, 3, 'Dolor de espalda');
INSERT INTO `lang_definitions` VALUES (3634, 784, 3, 'Problemas de espalda');
INSERT INTO `lang_definitions` VALUES (3635, 785, 3, 'Retrocede siete visitas');
INSERT INTO `lang_definitions` VALUES (3636, 786, 3, 'Retrocede seis visitas');
INSERT INTO `lang_definitions` VALUES (3637, 787, 3, 'Cirugia de espalda');
INSERT INTO `lang_definitions` VALUES (3638, 788, 3, 'Retrocede diez visitas');
INSERT INTO `lang_definitions` VALUES (3639, 789, 3, 'Retrocede tres visitas');
INSERT INTO `lang_definitions` VALUES (3640, 790, 3, 'Volver a la página de Administración');
INSERT INTO `lang_definitions` VALUES (3641, 794, 3, 'Volver al paciente');
INSERT INTO `lang_definitions` VALUES (3642, 795, 3, 'Volver a los usuarios');
INSERT INTO `lang_definitions` VALUES (3643, 796, 3, 'Volver a Vista');
INSERT INTO `lang_definitions` VALUES (3644, 797, 3, 'Retrocede doce visitas');
INSERT INTO `lang_definitions` VALUES (3645, 798, 3, 'Retrocede dos visitas');
INSERT INTO `lang_definitions` VALUES (3646, 800, 3, 'Backup');
INSERT INTO `lang_definitions` VALUES (3647, 801, 3, 'Se ha creado el fichero de backup. Ahora comenzará la descarga.');
INSERT INTO `lang_definitions` VALUES (3648, 803, 3, 'Backup creado correctamente');
INSERT INTO `lang_definitions` VALUES (3649, 804, 3, 'Cheque sin fondos');
INSERT INTO `lang_definitions` VALUES (3650, 805, 3, 'Mal crédito');
INSERT INTO `lang_definitions` VALUES (3651, 806, 3, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (3652, 807, 3, 'Bal');
INSERT INTO `lang_definitions` VALUES (3653, 808, 3, 'Balance');
INSERT INTO `lang_definitions` VALUES (3654, 809, 3, 'balance');
INSERT INTO `lang_definitions` VALUES (3655, 810, 3, 'Importe Balance');
INSERT INTO `lang_definitions` VALUES (3656, 811, 3, 'Balance a pagar');
INSERT INTO `lang_definitions` VALUES (3657, 815, 3, 'Recibo bancario');
INSERT INTO `lang_definitions` VALUES (3658, 819, 3, 'Base del quinto (5to) Metatarsiano');
INSERT INTO `lang_definitions` VALUES (3659, 820, 3, 'Base del quinto (5to) Metatarsiano:');
INSERT INTO `lang_definitions` VALUES (3660, 825, 3, 'Herramienta de Comunicación del Batch');
INSERT INTO `lang_definitions` VALUES (3661, 827, 3, 'Batch de entrada de pagos');
INSERT INTO `lang_definitions` VALUES (3662, 828, 3, 'Serie de Pagos');
INSERT INTO `lang_definitions` VALUES (3663, 829, 3, 'Iniciado proceso Batch; esto puede tardar unos minutos.');
INSERT INTO `lang_definitions` VALUES (3664, 830, 3, 'Resultados de la serie (Batch)');
INSERT INTO `lang_definitions` VALUES (3665, 831, 3, 'Comunicación en serie');
INSERT INTO `lang_definitions` VALUES (3666, 836, 3, 'porque no existe ese id.');
INSERT INTO `lang_definitions` VALUES (3667, 839, 3, 'Empezar');
INSERT INTO `lang_definitions` VALUES (3668, 840, 3, 'Fecha comienzo');
INSERT INTO `lang_definitions` VALUES (3669, 842, 3, 'Fecha de inicio de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (3670, 843, 3, 'Hora de inicio del día para los eventos del calendario');
INSERT INTO `lang_definitions` VALUES (3671, 845, 3, 'Eructo');
INSERT INTO `lang_definitions` VALUES (3672, 847, 3, 'Bengali');
INSERT INTO `lang_definitions` VALUES (3673, 850, 3, 'entre');
INSERT INTO `lang_definitions` VALUES (3674, 856, 3, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (3675, 857, 3, 'Bilateral:');
INSERT INTO `lang_definitions` VALUES (3676, 859, 3, 'Fecha factura:');
INSERT INTO `lang_definitions` VALUES (3677, 860, 3, 'Factura/Cobrar');
INSERT INTO `lang_definitions` VALUES (3678, 861, 3, 'Facturado');
INSERT INTO `lang_definitions` VALUES (3679, 863, 3, 'Facturación');
INSERT INTO `lang_definitions` VALUES (3680, 864, 3, 'Facturación (escritura opcional)');
INSERT INTO `lang_definitions` VALUES (3681, 866, 3, 'Atención facturación');
INSERT INTO `lang_definitions` VALUES (3682, 868, 3, 'Código de facturación para el Servicio Solicitado');
INSERT INTO `lang_definitions` VALUES (3683, 869, 3, 'Códigos de facturación');
INSERT INTO `lang_definitions` VALUES (3684, 870, 3, 'Datos de facturación');
INSERT INTO `lang_definitions` VALUES (3685, 871, 3, 'Departamento de Facturación');
INSERT INTO `lang_definitions` VALUES (3686, 872, 3, 'Centro de Facturación');
INSERT INTO `lang_definitions` VALUES (3687, 873, 3, 'Información facturación');
INSERT INTO `lang_definitions` VALUES (3688, 874, 3, 'Dirección facturación');
INSERT INTO `lang_definitions` VALUES (3689, 879, 3, 'Administrador de Facturación');
INSERT INTO `lang_definitions` VALUES (3690, 880, 3, 'Nota de facturación');
INSERT INTO `lang_definitions` VALUES (3691, 881, 3, 'Nota de facturación para');
INSERT INTO `lang_definitions` VALUES (3692, 882, 3, 'Nota de facturación:');
INSERT INTO `lang_definitions` VALUES (3693, 884, 3, 'Resultados de la cola de la facturación:');
INSERT INTO `lang_definitions` VALUES (3694, 885, 3, 'Informe de Facturación');
INSERT INTO `lang_definitions` VALUES (3695, 886, 3, 'Estado de facturación');
INSERT INTO `lang_definitions` VALUES (3696, 887, 3, 'Estado de Facturación = No facturados');
INSERT INTO `lang_definitions` VALUES (3697, 888, 3, 'facturación para');
INSERT INTO `lang_definitions` VALUES (3698, 892, 3, 'Biopsia');
INSERT INTO `lang_definitions` VALUES (3699, 894, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (3700, 898, 3, 'Negro');
INSERT INTO `lang_definitions` VALUES (3701, 900, 3, 'Pulmón negro');
INSERT INTO `lang_definitions` VALUES (3702, 901, 3, 'Negro o Afroamericano');
INSERT INTO `lang_definitions` VALUES (3703, 902, 3, 'Cáncer de vejiga');
INSERT INTO `lang_definitions` VALUES (3704, 903, 3, 'Infecciones de vejiga');
INSERT INTO `lang_definitions` VALUES (3705, 905, 3, 'Formularios en Blanco');
INSERT INTO `lang_definitions` VALUES (3706, 906, 3, 'Problemas de sangrado');
INSERT INTO `lang_definitions` VALUES (3707, 907, 3, 'Puntos ciegos');
INSERT INTO `lang_definitions` VALUES (3708, 909, 3, 'Hinchazón');
INSERT INTO `lang_definitions` VALUES (3709, 911, 3, 'Atascado');
INSERT INTO `lang_definitions` VALUES (3710, 912, 3, 'Sangre');
INSERT INTO `lang_definitions` VALUES (3711, 913, 3, 'Presión Arterial');
INSERT INTO `lang_definitions` VALUES (3712, 914, 3, 'Presión arterial');
INSERT INTO `lang_definitions` VALUES (3713, 915, 3, 'Sangra por la nariz');
INSERT INTO `lang_definitions` VALUES (3714, 916, 3, 'Blue Cross Blue Shield');
INSERT INTO `lang_definitions` VALUES (3715, 917, 3, 'Las líneas azules en este reporte son informativas. Líneas negras muestran información existente. Líneas verdes muestran cambios aplicados correctamente. Líneas rojas indican errores o cambios que no fueron aplicados, y deben ser procesados manualmente. Reclamaciones actuales denegadas y pagos revertidos no se manejan automáticamente y aparecerán en rojo.');
INSERT INTO `lang_definitions` VALUES (3716, 918, 3, 'Visión borrosa');
INSERT INTO `lang_definitions` VALUES (3717, 919, 3, 'IMC');
INSERT INTO `lang_definitions` VALUES (3718, 920, 3, 'Estado del IMC');
INSERT INTO `lang_definitions` VALUES (3719, 922, 3, 'Región corporal');
INSERT INTO `lang_definitions` VALUES (3720, 923, 3, 'Área Corporal');
INSERT INTO `lang_definitions` VALUES (3721, 924, 3, 'Área corporal, si es aplicable');
INSERT INTO `lang_definitions` VALUES (3722, 925, 3, 'Sensibilidad en hueso:');
INSERT INTO `lang_definitions` VALUES (3723, 926, 3, 'Sensibilidad en hueso: Maléolo Tibial');
INSERT INTO `lang_definitions` VALUES (3724, 927, 3, 'Boleano');
INSERT INTO `lang_definitions` VALUES (3725, 929, 3, 'Infer.');
INSERT INTO `lang_definitions` VALUES (3726, 931, 3, 'Ambos Oídos');
INSERT INTO `lang_definitions` VALUES (3727, 932, 3, 'ambos oídos');
INSERT INTO `lang_definitions` VALUES (3728, 933, 3, 'inferior');
INSERT INTO `lang_definitions` VALUES (3729, 935, 3, 'CASILLA 10 A. relacionados con el Empleo');
INSERT INTO `lang_definitions` VALUES (3730, 936, 3, 'CASILLA 10 B. Accidentes de tráfico');
INSERT INTO `lang_definitions` VALUES (3731, 937, 3, 'CASILLA 10 C. Otros Accidentes');
INSERT INTO `lang_definitions` VALUES (3732, 947, 3, 'CASILLA 15. Fecha de la misma o similar enfermedad (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (3733, 951, 3, 'CASILLA 16. Fecha de incapacidad a partir de (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3734, 954, 3, 'CASILLA 16. Fecha de incapacidad (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3735, 961, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3736, 964, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3737, 967, 3, 'CASILLA 20. ¿Se utiliza Laboratorio externo?');
INSERT INTO `lang_definitions` VALUES (3738, 969, 3, 'CASILLA 22. Código del re-envío de Medicaid (CIE-9)');
INSERT INTO `lang_definitions` VALUES (3739, 971, 3, 'CASILLA 23. Número de Autorización previa');
INSERT INTO `lang_definitions` VALUES (3740, 972, 3, 'PA');
INSERT INTO `lang_definitions` VALUES (3741, 973, 3, 'PA Diastólica');
INSERT INTO `lang_definitions` VALUES (3742, 974, 3, 'PA Sistólica');
INSERT INTO `lang_definitions` VALUES (3743, 976, 3, 'Pad');
INSERT INTO `lang_definitions` VALUES (3744, 980, 3, 'Pas');
INSERT INTO `lang_definitions` VALUES (3745, 982, 3, 'Portugués brasileño');
INSERT INTO `lang_definitions` VALUES (3746, 983, 3, 'mama');
INSERT INTO `lang_definitions` VALUES (3747, 984, 3, 'Biopsia de mama');
INSERT INTO `lang_definitions` VALUES (3748, 985, 3, 'Secreción de la mama');
INSERT INTO `lang_definitions` VALUES (3749, 986, 3, 'Enfermedad de la mama');
INSERT INTO `lang_definitions` VALUES (3750, 987, 3, 'Revisión de mama');
INSERT INTO `lang_definitions` VALUES (3751, 988, 3, 'Masa en la mama');
INSERT INTO `lang_definitions` VALUES (3752, 990, 3, 'Sonidos respiratorios:');
INSERT INTO `lang_definitions` VALUES (3753, 993, 3, 'Huesos fracturados');
INSERT INTO `lang_definitions` VALUES (3754, 995, 3, 'Forma de bronquitis');
INSERT INTO `lang_definitions` VALUES (3755, 998, 3, 'Explorar');
INSERT INTO `lang_definitions` VALUES (3756, 999, 3, 'Explorar para Registro');
INSERT INTO `lang_definitions` VALUES (3757, 1000, 3, 'Contusiones/Hematomas');
INSERT INTO `lang_definitions` VALUES (3758, 1003, 3, 'Abultamiento derecho:');
INSERT INTO `lang_definitions` VALUES (3759, 1005, 3, 'Ardor al orinar');
INSERT INTO `lang_definitions` VALUES (3760, 1006, 3, 'Ardor Al Orinar');
INSERT INTO `lang_definitions` VALUES (3761, 1009, 3, 'Ocupado');
INSERT INTO `lang_definitions` VALUES (3762, 1010, 3, 'pero todavía no procesado.');
INSERT INTO `lang_definitions` VALUES (3763, 1011, 3, 'Glúteo');
INSERT INTO `lang_definitions` VALUES (3764, 1012, 3, 'Gluteos + S.I.');
INSERT INTO `lang_definitions` VALUES (3765, 1013, 3, 'por');
INSERT INTO `lang_definitions` VALUES (3766, 1014, 3, 'Por');
INSERT INTO `lang_definitions` VALUES (3767, 1016, 3, 'por boca');
INSERT INTO `lang_definitions` VALUES (3768, 1017, 3, 'Por/Origen');
INSERT INTO `lang_definitions` VALUES (3769, 1018, 3, 'Por:');
INSERT INTO `lang_definitions` VALUES (3770, 1021, 3, 'C');
INSERT INTO `lang_definitions` VALUES (3771, 1022, 3, 'Certificado de CA para verificar el RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3772, 1023, 3, 'Tiempo de Vida del Caché (en segundos)');
INSERT INTO `lang_definitions` VALUES (3773, 1024, 3, '¿Plantilla de salida del caché?');
INSERT INTO `lang_definitions` VALUES (3774, 1026, 3, 'Consumo de cafeína');
INSERT INTO `lang_definitions` VALUES (3775, 1027, 3, 'Calendario');
INSERT INTO `lang_definitions` VALUES (3776, 1028, 3, 'Fin Hora Calendario');
INSERT INTO `lang_definitions` VALUES (3777, 1029, 3, 'Intervalo Calendario');
INSERT INTO `lang_definitions` VALUES (3778, 1030, 3, 'Pantalla de calendario');
INSERT INTO `lang_definitions` VALUES (3779, 1031, 3, 'Ajustes del calendario');
INSERT INTO `lang_definitions` VALUES (3780, 1033, 3, 'Hora de inicio de calendario');
INSERT INTO `lang_definitions` VALUES (3781, 1034, 3, 'Calendario UI');
INSERT INTO `lang_definitions` VALUES (3782, 1035, 3, 'Vista de Calendario');
INSERT INTO `lang_definitions` VALUES (3783, 1038, 3, 'Llamada para añadir Formulario () va aquí.<br>');
INSERT INTO `lang_definitions` VALUES (3784, 1042, 3, 'Calorías');
INSERT INTO `lang_definitions` VALUES (3785, 1043, 3, 'Camboyano');
INSERT INTO `lang_definitions` VALUES (3786, 1044, 3, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (3787, 1050, 3, 'Cancelar');
INSERT INTO `lang_definitions` VALUES (3788, 1052, 3, 'Cancelar cambios');
INSERT INTO `lang_definitions` VALUES (3789, 1053, 3, 'Cancelado');
INSERT INTO `lang_definitions` VALUES (3790, 1055, 3, 'Cáncer');
INSERT INTO `lang_definitions` VALUES (3791, 1056, 3, 'Detección de Cancer: Detección Cancer de Colon');
INSERT INTO `lang_definitions` VALUES (3792, 1057, 3, 'Detección de Cancer: Mamografía');
INSERT INTO `lang_definitions` VALUES (3793, 1058, 3, 'Detección de Cancer: Prueba de Papanicolau');
INSERT INTO `lang_definitions` VALUES (3794, 1059, 3, 'Detección de Cancer: Detección de Cancer de Próstata');
INSERT INTO `lang_definitions` VALUES (3795, 1060, 3, 'No se puede agregar esta entrada, ¡porque ya existe!');
INSERT INTO `lang_definitions` VALUES (3796, 1061, 3, '¡No se puede agregar/actualizar esta entrada porque ya existe un duplicado!');
INSERT INTO `lang_definitions` VALUES (3797, 1063, 3, 'no puede convertirse a JPEG. ¿probablemente ImageMagick no está instalado?');
INSERT INTO `lang_definitions` VALUES (3798, 1065, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3799, 1066, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador');
INSERT INTO `lang_definitions` VALUES (3800, 1067, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3801, 1068, 3, 'No se puede crear');
INSERT INTO `lang_definitions` VALUES (3802, 1073, 3, 'No se puede encontrar');
INSERT INTO `lang_definitions` VALUES (3803, 1074, 3, 'No se puede encontrar fichero de destino');
INSERT INTO `lang_definitions` VALUES (3804, 1077, 3, 'No puede encontrar al paciente con ese ID de cliente en SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3805, 1078, 3, 'No se puede encontrar el documento de referencia de postscript en');
INSERT INTO `lang_definitions` VALUES (3806, 1079, 3, 'No puede encontrar al facultativo con SQL-Ledger empleado');
INSERT INTO `lang_definitions` VALUES (3807, 1080, 3, 'No puede modificar los pagos. La no-distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (3808, 1082, 3, 'No se puede abrir');
INSERT INTO `lang_definitions` VALUES (3809, 1083, 3, 'No se puede enviar al seguro.La entidad pagadora seleccionada es el paciente.');
INSERT INTO `lang_definitions` VALUES (3810, 1084, 3, 'No puede enviar al Paciente. La Entidad pagadora seleccionada es el seguro.');
INSERT INTO `lang_definitions` VALUES (3811, 1085, 3, 'No puede enviar pagos. La distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (3812, 1086, 3, 'No se puede leer');
INSERT INTO `lang_definitions` VALUES (3813, 1087, 3, 'No se puede leer el directorio');
INSERT INTO `lang_definitions` VALUES (3814, 1088, 3, '¡No se puede actualizar porque no está editando una entrada existente!.');
INSERT INTO `lang_definitions` VALUES (3815, 1089, 3, 'Poner en Mayúsculas');
INSERT INTO `lang_definitions` VALUES (3816, 1091, 3, 'cápsula');
INSERT INTO `lang_definitions` VALUES (3817, 1092, 3, 'Tarjeta');
INSERT INTO `lang_definitions` VALUES (3818, 1099, 3, 'Cateterismo Cardiaco');
INSERT INTO `lang_definitions` VALUES (3819, 1100, 3, 'Ecocardiograma');
INSERT INTO `lang_definitions` VALUES (3820, 1101, 3, 'Cardiovascular');
INSERT INTO `lang_definitions` VALUES (3821, 1110, 3, 'Daño de cartílago/ condral / disco articular.');
INSERT INTO `lang_definitions` VALUES (3822, 1111, 3, 'Lesión de cartílago');
INSERT INTO `lang_definitions` VALUES (3823, 1112, 3, 'Nl Pulsos Carotideos, pulsos pedios nl');
INSERT INTO `lang_definitions` VALUES (3824, 1114, 3, 'efectivo');
INSERT INTO `lang_definitions` VALUES (3825, 1115, 3, 'Efectivo');
INSERT INTO `lang_definitions` VALUES (3826, 1116, 3, 'Entradas Efectivo');
INSERT INTO `lang_definitions` VALUES (3827, 1117, 3, 'Entradas de efectivo por facultativo');
INSERT INTO `lang_definitions` VALUES (3828, 1120, 3, 'Cirugía de cataratas');
INSERT INTO `lang_definitions` VALUES (3829, 1121, 3, 'Cataratas');
INSERT INTO `lang_definitions` VALUES (3830, 1122, 3, 'Categorías');
INSERT INTO `lang_definitions` VALUES (3831, 1123, 3, 'Categorías para');
INSERT INTO `lang_definitions` VALUES (3832, 1124, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (3833, 1125, 3, 'categoría');
INSERT INTO `lang_definitions` VALUES (3834, 1126, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (3835, 1129, 3, 'Detalles de Categoría');
INSERT INTO `lang_definitions` VALUES (3836, 1130, 3, 'Límites de Categoría');
INSERT INTO `lang_definitions` VALUES (3837, 1131, 3, 'Nombre de Categoría');
INSERT INTO `lang_definitions` VALUES (3838, 1132, 3, 'Nombre de la Categoria está vacío');
INSERT INTO `lang_definitions` VALUES (3839, 1133, 3, 'Categoría/Título');
INSERT INTO `lang_definitions` VALUES (3840, 1134, 3, 'Caucásico');
INSERT INTO `lang_definitions` VALUES (3841, 1135, 3, 'Imprime la receta de la visita con la información del proveedor primario');
INSERT INTO `lang_definitions` VALUES (3842, 1153, 3, 'CDR');
INSERT INTO `lang_definitions` VALUES (3843, 1155, 3, 'Celda');
INSERT INTO `lang_definitions` VALUES (3844, 1156, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (3845, 1158, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (3846, 1159, 3, 'Certificación central');
INSERT INTO `lang_definitions` VALUES (3847, 1161, 3, 'Centroamericano/Sudamericano');
INSERT INTO `lang_definitions` VALUES (3848, 1162, 3, 'La localización del fichero de Certificado de Autoridad crt no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (3849, 1163, 3, 'La localizacion de la clave del fichero del Certificado de Autoridad no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (3850, 1164, 3, 'Certificado para enviar a la RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3851, 1165, 3, 'Usuario del Certificado');
INSERT INTO `lang_definitions` VALUES (3852, 1166, 3, 'Certificados');
INSERT INTO `lang_definitions` VALUES (3853, 1168, 3, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (3854, 1169, 3, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (3855, 1170, 3, 'cambiar');
INSERT INTO `lang_definitions` VALUES (3856, 1171, 3, 'Cambio');
INSERT INTO `lang_definitions` VALUES (3857, 1172, 3, 'Cambia actividad');
INSERT INTO `lang_definitions` VALUES (3858, 1175, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (3859, 1176, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (3860, 1179, 3, 'Cambiado');
INSERT INTO `lang_definitions` VALUES (3861, 1180, 3, 'Intestino Cambiado');
INSERT INTO `lang_definitions` VALUES (3862, 1183, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (3863, 1184, 3, 'Caracteres Restantes');
INSERT INTO `lang_definitions` VALUES (3864, 1185, 3, 'Cargo');
INSERT INTO `lang_definitions` VALUES (3865, 1186, 3, 'Ajuste del cargo');
INSERT INTO `lang_definitions` VALUES (3866, 1187, 3, 'Cobro codificado');
INSERT INTO `lang_definitions` VALUES (3867, 1189, 3, 'Cargos');
INSERT INTO `lang_definitions` VALUES (3868, 1190, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (3869, 1191, 3, 'Gráfico de Actividad');
INSERT INTO `lang_definitions` VALUES (3870, 1192, 3, 'Informe de Actividad - Entradas/Salidas de gráficos');
INSERT INTO `lang_definitions` VALUES (3871, 1193, 3, 'Nº Identificación de gráfico');
INSERT INTO `lang_definitions` VALUES (3872, 1194, 3, 'Nº Identificación de gráfico:');
INSERT INTO `lang_definitions` VALUES (3873, 1196, 3, 'Actividad de Localización de Gráficos');
INSERT INTO `lang_definitions` VALUES (3874, 1197, 3, 'Nota en el gráfico');
INSERT INTO `lang_definitions` VALUES (3875, 1198, 3, 'Número de gráfico');
INSERT INTO `lang_definitions` VALUES (3876, 1200, 3, 'Gráfico de Localizaciones archivadas');
INSERT INTO `lang_definitions` VALUES (3877, 1201, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (3878, 1202, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (3879, 1203, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (3880, 1204, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (3881, 1208, 3, 'Comprobar');
INSERT INTO `lang_definitions` VALUES (3882, 1209, 3, 'comprobar');
INSERT INTO `lang_definitions` VALUES (3883, 1210, 3, 'Comprobar todo');
INSERT INTO `lang_definitions` VALUES (3884, 1212, 3, 'Importe del cheque');
INSERT INTO `lang_definitions` VALUES (3885, 1213, 3, 'Fecha del cheque');
INSERT INTO `lang_definitions` VALUES (3886, 1215, 3, 'Comprobar diferencias entre las traducciones con Tabla del Idioma Personalizada');
INSERT INTO `lang_definitions` VALUES (3887, 1220, 3, 'Llegue a');
INSERT INTO `lang_definitions` VALUES (3888, 1221, 3, 'Comprobar Fecha Entrada');
INSERT INTO `lang_definitions` VALUES (3889, 1223, 3, 'Revisar los Resultados de Laboratorio');
INSERT INTO `lang_definitions` VALUES (3890, 1226, 3, 'Número de cheque');
INSERT INTO `lang_definitions` VALUES (3891, 1229, 3, 'Pago por Cheque');
INSERT INTO `lang_definitions` VALUES (3892, 1230, 3, 'Marque la casilla si es un fichero encriptado');
INSERT INTO `lang_definitions` VALUES (3893, 1231, 3, 'Selecciona ésto si quiere que los facultativos vean todas las citas por defecto y no sólo las suyas.');
INSERT INTO `lang_definitions` VALUES (3894, 1233, 3, 'Comprobar Fecha/EOB:');
INSERT INTO `lang_definitions` VALUES (3895, 1234, 3, 'Comprobar Número EOB.:');
INSERT INTO `lang_definitions` VALUES (3896, 1235, 3, 'Comprobar/Número de Referencia');
INSERT INTO `lang_definitions` VALUES (3897, 1236, 3, 'Comprobar/Número de referencia');
INSERT INTO `lang_definitions` VALUES (3898, 1237, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (3899, 1238, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (3900, 1239, 3, 'Casilla con Texto');
INSERT INTO `lang_definitions` VALUES (3901, 1240, 3, 'Casilla con texto');
INSERT INTO `lang_definitions` VALUES (3902, 1244, 3, 'Comprobado');
INSERT INTO `lang_definitions` VALUES (3903, 1246, 3, 'Casilla marcada = sí, vacía = no');
INSERT INTO `lang_definitions` VALUES (3904, 1252, 3, 'Comprobación');
INSERT INTO `lang_definitions` VALUES (3905, 1253, 3, 'Sumatorio');
INSERT INTO `lang_definitions` VALUES (3906, 1254, 3, 'Pecho');
INSERT INTO `lang_definitions` VALUES (3907, 1255, 3, 'Pecho CTAB');
INSERT INTO `lang_definitions` VALUES (3908, 1256, 3, 'Dolor de Pecho');
INSERT INTO `lang_definitions` VALUES (3909, 1257, 3, 'Dolor de Pecho:');
INSERT INTO `lang_definitions` VALUES (3910, 1258, 3, 'Dolores de Pecho');
INSERT INTO `lang_definitions` VALUES (3911, 1260, 3, 'Var');
INSERT INTO `lang_definitions` VALUES (3912, 1262, 3, 'Síntoma Principal');
INSERT INTO `lang_definitions` VALUES (3913, 1265, 3, 'Niño');
INSERT INTO `lang_definitions` VALUES (3914, 1267, 3, 'Estado de vacunación de la niñez (GCC)');
INSERT INTO `lang_definitions` VALUES (3915, 1268, 3, 'Escalofríos');
INSERT INTO `lang_definitions` VALUES (3916, 1269, 3, 'Chino');
INSERT INTO `lang_definitions` VALUES (3917, 1270, 3, 'Chino (simplificado)');
INSERT INTO `lang_definitions` VALUES (3918, 1271, 3, 'Chino (tradicional)');
INSERT INTO `lang_definitions` VALUES (3919, 1273, 3, 'Opciones');
INSERT INTO `lang_definitions` VALUES (3920, 1274, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (3921, 1276, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (3922, 1277, 3, 'Elegir');
INSERT INTO `lang_definitions` VALUES (3923, 1280, 3, 'Elija una sección y haga click en un elemento dentro de ella; luego, en la otra sección, verá remarcados los elementos relacionados, puede hacer click en esa sección para añadir y borrar relaciones.');
INSERT INTO `lang_definitions` VALUES (3924, 1281, 3, 'Criterios de selección');
INSERT INTO `lang_definitions` VALUES (3925, 1287, 3, 'Lista de Selecciones');
INSERT INTO `lang_definitions` VALUES (3926, 1292, 3, 'Seleccione formato de impresión para este informe de visitas.');
INSERT INTO `lang_definitions` VALUES (3927, 1295, 3, 'Bronquitis Crónica');
INSERT INTO `lang_definitions` VALUES (3928, 1296, 3, 'Dolor crónico de articulaciones');
INSERT INTO `lang_definitions` VALUES (3929, 1297, 3, 'Enfermedad Renal Crónica (ERC)');
INSERT INTO `lang_definitions` VALUES (3930, 1300, 3, 'Sinovitis crónica/derrame/dolor articular/gota');
INSERT INTO `lang_definitions` VALUES (3931, 1302, 3, 'Crónico/Recurrente');
INSERT INTO `lang_definitions` VALUES (3932, 1305, 3, 'Cirrosis de hígado');
INSERT INTO `lang_definitions` VALUES (3933, 1306, 3, 'Cirrosis del Hígado');
INSERT INTO `lang_definitions` VALUES (3934, 1307, 3, 'Ciudad');
INSERT INTO `lang_definitions` VALUES (3935, 1308, 3, 'Nombre de Ciudad');
INSERT INTO `lang_definitions` VALUES (3936, 1309, 3, 'Ciudad, Provincia');
INSERT INTO `lang_definitions` VALUES (3937, 1310, 3, 'Ciudad, Código Postal');
INSERT INTO `lang_definitions` VALUES (3938, 1311, 3, 'Ciudad/Provincia');
INSERT INTO `lang_definitions` VALUES (3939, 1312, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (3940, 1313, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (3941, 1316, 3, 'Prueba de Reclamación ha terminado');
INSERT INTO `lang_definitions` VALUES (3942, 1317, 3, 'Tipo de Reclamación');
INSERT INTO `lang_definitions` VALUES (3943, 1318, 3, 'Reclamación generada para presentar');
INSERT INTO `lang_definitions` VALUES (3944, 1319, 3, 'La Reclamación se ha guardado en el fichero');
INSERT INTO `lang_definitions` VALUES (3945, 1320, 3, 'Reclamaciones');
INSERT INTO `lang_definitions` VALUES (3946, 1321, 3, 'Clasificación');
INSERT INTO `lang_definitions` VALUES (3947, 1322, 3, 'Limpiar');
INSERT INTO `lang_definitions` VALUES (3948, 1326, 3, 'Limpiar todos');
INSERT INTO `lang_definitions` VALUES (3949, 1329, 3, 'Limpiar Datos HL7');
INSERT INTO `lang_definitions` VALUES (3950, 1330, 3, 'Limpiar Justificación');
INSERT INTO `lang_definitions` VALUES (3951, 1333, 3, 'Vaciar Cache Smarty');
INSERT INTO `lang_definitions` VALUES (3952, 1334, 3, 'Información requerida por la Cámara de compensación en la creación del Batch EDI 270');
INSERT INTO `lang_definitions` VALUES (3953, 1335, 3, 'Número CLIA');
INSERT INTO `lang_definitions` VALUES (3954, 1336, 3, 'Click');
INSERT INTO `lang_definitions` VALUES (3955, 1337, 3, 'Click \'export\' para exportar su Categoría, Subcategoría, Item o Datos contenidos a un fichero de texto. Cualquier similitud de este fichero con un fichero tipo XML es pura coincidencia. Las etiquetas de abrir y cerrar deben estar en la misma línea y deben ser minúsculas sin espacios. Para importar, localize el fichero y click \'Importar\'. Si los datos son completamente diferentes se unen a los datos existentes. Si hay datos con nombres similares, el nombre más antiguo se mantiene mientras que al nuevo se le agrega un número al final.');
INSERT INTO `lang_definitions` VALUES (3956, 1338, 3, 'Click en el gráfico para nueva anotacion, click de nuevo para eliminarla.');
INSERT INTO `lang_definitions` VALUES (3957, 1339, 3, 'Click descargar Certificado para descargar los certificados en el fichero ssl.zip');
INSERT INTO `lang_definitions` VALUES (3958, 1340, 3, 'Click para más');
INSERT INTO `lang_definitions` VALUES (3959, 1345, 3, 'Click aquí');
INSERT INTO `lang_definitions` VALUES (3960, 1346, 3, 'Click aquí para añadir un nuevo paciente.');
INSERT INTO `lang_definitions` VALUES (3961, 1347, 3, 'Click aqui para añadir un nuevo cambio de estado de la lesion y editar la actividad diaria.');
INSERT INTO `lang_definitions` VALUES (3962, 1349, 3, 'Click aquí para elegir una fecha');
INSERT INTO `lang_definitions` VALUES (3963, 1350, 3, 'Click aquí para elegir una fecha y hora');
INSERT INTO `lang_definitions` VALUES (3964, 1351, 3, 'Click aquí para elegir una fecha de inicio');
INSERT INTO `lang_definitions` VALUES (3965, 1370, 3, 'Click aquí para buscar');
INSERT INTO `lang_definitions` VALUES (3966, 1372, 3, 'Click aquí para actualizar configuración de prioridad, categoría y apodos');
INSERT INTO `lang_definitions` VALUES (3967, 1374, 3, 'Click aquí para ver todo.');
INSERT INTO `lang_definitions` VALUES (3968, 1375, 3, 'Click aqui para vista y gráficos');
INSERT INTO `lang_definitions` VALUES (3969, 1377, 3, 'Click aquí para vista y grafico de todas las constantes vitales.');
INSERT INTO `lang_definitions` VALUES (3970, 1378, 3, 'Click aquí para ver los detalles del paciente');
INSERT INTO `lang_definitions` VALUES (3971, 1379, 3, 'Click aquí para ver todos.');
INSERT INTO `lang_definitions` VALUES (3972, 1382, 3, 'Click botón Instalar para instalar la versión de la base de datos desde la siguiente fecha');
INSERT INTO `lang_definitions` VALUES (3973, 1385, 3, 'Click aquí para aumentar los intervalos de tiempo');
INSERT INTO `lang_definitions` VALUES (3974, 1389, 3, 'Click en Nombre Paciente para abrir el fichero del paciente');
INSERT INTO `lang_definitions` VALUES (3975, 1390, 3, 'Click Refrescar para ver todos los resultados o introduzca un criterio de búsqueda arriba para ver resultados específicos.');
INSERT INTO `lang_definitions` VALUES (3976, 1399, 3, 'Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (3977, 1400, 3, 'Click para agregar nueva consulta');
INSERT INTO `lang_definitions` VALUES (3978, 1403, 3, 'Click para descargar');
INSERT INTO `lang_definitions` VALUES (3979, 1404, 3, 'Click para editar');
INSERT INTO `lang_definitions` VALUES (3980, 1406, 3, 'Click para editar este evento');
INSERT INTO `lang_definitions` VALUES (3981, 1407, 3, 'Click para generar el informe');
INSERT INTO `lang_definitions` VALUES (3982, 1412, 3, 'Click para imprimir');
INSERT INTO `lang_definitions` VALUES (3983, 1413, 3, 'Click para recibir (añadir) nuevo lote');
INSERT INTO `lang_definitions` VALUES (3984, 1414, 3, 'Click para seleccionar');
INSERT INTO `lang_definitions` VALUES (3985, 1415, 3, 'Click Para Seleccionar');
INSERT INTO `lang_definitions` VALUES (3986, 1416, 3, 'Click para seleccionar un código estándar industrial para este procedimiento');
INSERT INTO `lang_definitions` VALUES (3987, 1418, 3, 'Click para seleccionar el codigo de procedimiento opcional');
INSERT INTO `lang_definitions` VALUES (3988, 1420, 3, 'Click para seleccionar o cambiar código CVX');
INSERT INTO `lang_definitions` VALUES (3989, 1421, 3, 'Click para seleccionar o cambiar diagnósticos');
INSERT INTO `lang_definitions` VALUES (3990, 1422, 3, 'Click para seleccionar o cambiar códigos de servicios');
INSERT INTO `lang_definitions` VALUES (3991, 1423, 3, 'Click para seleccionar el paciente');
INSERT INTO `lang_definitions` VALUES (3992, 1424, 3, 'Click para seleccionar un código relacionado');
INSERT INTO `lang_definitions` VALUES (3993, 1425, 3, 'Click para seleccionar servicios a realizar si este resultado es anormal');
INSERT INTO `lang_definitions` VALUES (3994, 1426, 3, 'Click para seleccionar el procedimiento deseado');
INSERT INTO `lang_definitions` VALUES (3995, 1429, 3, 'Click para ver');
INSERT INTO `lang_definitions` VALUES (3996, 1430, 3, 'Click para ver o editar');
INSERT INTO `lang_definitions` VALUES (3997, 1431, 3, 'Click para ver/editar');
INSERT INTO `lang_definitions` VALUES (3998, 1432, 3, 'Click botón Actualizar para actualizar la versión de la base de datos desde la fecha siguiente');
INSERT INTO `lang_definitions` VALUES (3999, 1434, 3, 'Click:');
INSERT INTO `lang_definitions` VALUES (4000, 1437, 3, 'Días para Vencimiento del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4001, 1438, 3, 'Periodo de validación del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4002, 1439, 3, 'El certificado de validación del cliente debe ser un número válido');
INSERT INTO `lang_definitions` VALUES (4003, 1440, 3, 'Copia para el cliente');
INSERT INTO `lang_definitions` VALUES (4004, 1442, 3, 'Resumen de historia clínica del cliente');
INSERT INTO `lang_definitions` VALUES (4005, 1445, 3, 'Perfil de cliente - Nuevos Clientes');
INSERT INTO `lang_definitions` VALUES (4006, 1446, 3, 'Perfil de cliente - Clientes Únicos');
INSERT INTO `lang_definitions` VALUES (4007, 1447, 3, 'Clientes');
INSERT INTO `lang_definitions` VALUES (4008, 1448, 3, 'Clínica');
INSERT INTO `lang_definitions` VALUES (4009, 1449, 3, 'Copia para la Clínica');
INSERT INTO `lang_definitions` VALUES (4010, 1450, 3, 'Registro Diario de la Clínica');
INSERT INTO `lang_definitions` VALUES (4011, 1451, 3, 'Nº Identificación de Clínica');
INSERT INTO `lang_definitions` VALUES (4012, 1452, 3, 'Clínico');
INSERT INTO `lang_definitions` VALUES (4013, 1453, 3, 'Gestor de Alertas para las Reglas de Decisión Clinicas');
INSERT INTO `lang_definitions` VALUES (4014, 1457, 3, 'Planes Clínicos');
INSERT INTO `lang_definitions` VALUES (4015, 1458, 3, 'Medidas de Calidad Clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4016, 1461, 3, 'Recordatorios Clínicos');
INSERT INTO `lang_definitions` VALUES (4017, 1463, 3, 'Reportes Clínicos');
INSERT INTO `lang_definitions` VALUES (4018, 1464, 3, 'Reglas Clínicas para Categoría de Acción');
INSERT INTO `lang_definitions` VALUES (4019, 1465, 3, 'Reglas Clínicas para Asunto de Acción');
INSERT INTO `lang_definitions` VALUES (4020, 1466, 3, 'Reglas Clínicas para Métodos de filtro');
INSERT INTO `lang_definitions` VALUES (4021, 1467, 3, 'Reglas Clínicas para Objetivo de Métodos');
INSERT INTO `lang_definitions` VALUES (4022, 1468, 3, 'Reglas Clínicas');
INSERT INTO `lang_definitions` VALUES (4023, 1469, 3, 'Reglas Clínicas para Intervalos de Edad');
INSERT INTO `lang_definitions` VALUES (4024, 1470, 3, 'Reglas Clínicas de Comparación');
INSERT INTO `lang_definitions` VALUES (4025, 1471, 3, 'Reglas Clínicas de Tipos de Visitas');
INSERT INTO `lang_definitions` VALUES (4026, 1472, 3, 'Reglas Clínicas de opciones de Vencimientos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4027, 1473, 3, 'Reglas Clínicas de opciones de Desactivación de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4028, 1474, 3, 'Reglas Clínicas de intervalos de recordatorios');
INSERT INTO `lang_definitions` VALUES (4029, 1475, 3, 'Reglas Clínicas de Métodos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4030, 1476, 3, 'Reglas Clínicas de Intervalos de Destino');
INSERT INTO `lang_definitions` VALUES (4031, 1477, 3, 'Destinos Clínicos');
INSERT INTO `lang_definitions` VALUES (4032, 1480, 3, 'Vista de Clínica');
INSERT INTO `lang_definitions` VALUES (4033, 1481, 3, 'Médicos');
INSERT INTO `lang_definitions` VALUES (4034, 1482, 3, 'Clonar');
INSERT INTO `lang_definitions` VALUES (4035, 1483, 3, 'Clonar Visita Anterior');
INSERT INTO `lang_definitions` VALUES (4036, 1484, 3, 'Cerrar');
INSERT INTO `lang_definitions` VALUES (4037, 1490, 3, 'Cerrar Ventana');
INSERT INTO `lang_definitions` VALUES (4038, 1491, 3, 'cerrar ventana');
INSERT INTO `lang_definitions` VALUES (4039, 1493, 3, 'Cerrado');
INSERT INTO `lang_definitions` VALUES (4040, 1494, 3, 'cm');
INSERT INTO `lang_definitions` VALUES (4041, 1496, 3, 'Margenes del formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (4042, 1503, 3, 'CMS ID');
INSERT INTO `lang_definitions` VALUES (4043, 1517, 3, 'NC 2-12 Intacto');
INSERT INTO `lang_definitions` VALUES (4044, 1520, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4045, 1521, 3, 'Copago pagado');
INSERT INTO `lang_definitions` VALUES (4046, 1523, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4047, 1525, 3, 'Código');
INSERT INTO `lang_definitions` VALUES (4048, 1526, 3, 'código');
INSERT INTO `lang_definitions` VALUES (4049, 1527, 3, 'Buscador de Código');
INSERT INTO `lang_definitions` VALUES (4050, 1528, 3, 'Código debe ser dos letras en minúscula');
INSERT INTO `lang_definitions` VALUES (4051, 1529, 3, 'Código o símbolo para indicar moneda');
INSERT INTO `lang_definitions` VALUES (4052, 1530, 3, 'Código de Texto');
INSERT INTO `lang_definitions` VALUES (4053, 1532, 3, 'tipo de código');
INSERT INTO `lang_definitions` VALUES (4054, 1535, 3, 'Típos de Código');
INSERT INTO `lang_definitions` VALUES (4055, 1537, 3, 'Codificado');
INSERT INTO `lang_definitions` VALUES (4056, 1538, 3, 'Códigos');
INSERT INTO `lang_definitions` VALUES (4057, 1539, 3, 'Codificando');
INSERT INTO `lang_definitions` VALUES (4058, 1541, 3, 'Codificación - cualquier visita(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4059, 1543, 3, 'Codificación - mis visitas(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4060, 1548, 3, 'Codificación no autorizada');
INSERT INTO `lang_definitions` VALUES (4061, 1549, 3, 'Café');
INSERT INTO `lang_definitions` VALUES (4062, 1552, 3, 'Coseguro');
INSERT INTO `lang_definitions` VALUES (4063, 1553, 3, 'Coll w/o');
INSERT INTO `lang_definitions` VALUES (4064, 1555, 3, 'Contraer');
INSERT INTO `lang_definitions` VALUES (4065, 1556, 3, 'contraer');
INSERT INTO `lang_definitions` VALUES (4066, 1557, 3, 'Contraer Todo');
INSERT INTO `lang_definitions` VALUES (4067, 1558, 3, 'Contraer todo');
INSERT INTO `lang_definitions` VALUES (4068, 1559, 3, 'contraer todo');
INSERT INTO `lang_definitions` VALUES (4069, 1561, 3, 'Fecha de recolecciòn');
INSERT INTO `lang_definitions` VALUES (4070, 1562, 3, 'Recobro');
INSERT INTO `lang_definitions` VALUES (4071, 1563, 3, 'Informe de Recobro');
INSERT INTO `lang_definitions` VALUES (4072, 1564, 3, 'Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4073, 1565, 3, 'Detección de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4074, 1566, 3, 'Cirugía de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4075, 1567, 3, 'Colonoscopia');
INSERT INTO `lang_definitions` VALUES (4076, 1568, 3, 'colonoscopía');
INSERT INTO `lang_definitions` VALUES (4077, 1569, 3, 'Color');
INSERT INTO `lang_definitions` VALUES (4078, 1575, 3, 'Abreviatura de color');
INSERT INTO `lang_definitions` VALUES (4079, 1576, 3, 'Colunma');
INSERT INTO `lang_definitions` VALUES (4080, 1577, 3, 'Columnas');
INSERT INTO `lang_definitions` VALUES (4081, 1579, 3, 'Combinando Lotes');
INSERT INTO `lang_definitions` VALUES (4082, 1580, 3, 'Coma');
INSERT INTO `lang_definitions` VALUES (4083, 1581, 3, 'Comentario');
INSERT INTO `lang_definitions` VALUES (4084, 1582, 3, 'Comentarios');
INSERT INTO `lang_definitions` VALUES (4085, 1583, 3, 'Comentarios para este resultado o recomendación');
INSERT INTO `lang_definitions` VALUES (4086, 1584, 3, 'Sociedad Comercial de Seguros');
INSERT INTO `lang_definitions` VALUES (4087, 1585, 3, 'Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4088, 1588, 3, 'Comunicaciones');
INSERT INTO `lang_definitions` VALUES (4089, 1591, 3, 'Compañía');
INSERT INTO `lang_definitions` VALUES (4090, 1592, 3, 'Nombre Empresa');
INSERT INTO `lang_definitions` VALUES (4091, 1593, 3, 'Completo');
INSERT INTO `lang_definitions` VALUES (4092, 1595, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4093, 1598, 3, 'Terminado?');
INSERT INTO `lang_definitions` VALUES (4094, 1601, 3, 'Conplicaciones por el proveedor de servicios');
INSERT INTO `lang_definitions` VALUES (4095, 1602, 3, 'Complicaciones de aborto');
INSERT INTO `lang_definitions` VALUES (4096, 1603, 3, 'Componentes');
INSERT INTO `lang_definitions` VALUES (4097, 1608, 3, 'Sistema Computarizado de Pedidos Médicos');
INSERT INTO `lang_definitions` VALUES (4098, 1609, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (4099, 1613, 3, 'Config');
INSERT INTO `lang_definitions` VALUES (4100, 1614, 3, 'Configuración');
INSERT INTO `lang_definitions` VALUES (4101, 1615, 3, 'Configuración Exportar/Importar');
INSERT INTO `lang_definitions` VALUES (4102, 1617, 3, 'Configure Apache y OpenEMR para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4103, 1618, 3, 'Configure Apache para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4104, 1619, 3, 'Configure Apache para usar HTTPS');
INSERT INTO `lang_definitions` VALUES (4105, 1620, 3, 'Configure Openemr para usar certificado SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4106, 1624, 3, 'Confirma Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4107, 1626, 3, 'Confirmar Nueva Contraseña');
INSERT INTO `lang_definitions` VALUES (4108, 1627, 3, 'Confirmar Pago');
INSERT INTO `lang_definitions` VALUES (4109, 1634, 3, 'Congénito');
INSERT INTO `lang_definitions` VALUES (4110, 1635, 3, 'Conjuntiva, pupilas');
INSERT INTO `lang_definitions` VALUES (4111, 1638, 3, 'Conectores');
INSERT INTO `lang_definitions` VALUES (4112, 1639, 3, 'Constante');
INSERT INTO `lang_definitions` VALUES (4113, 1640, 3, 'Nombre constante');
INSERT INTO `lang_definitions` VALUES (4114, 1641, 3, 'Nombre constante está en blanco');
INSERT INTO `lang_definitions` VALUES (4115, 1642, 3, 'constantes');
INSERT INTO `lang_definitions` VALUES (4116, 1643, 3, 'Estreñimiento');
INSERT INTO `lang_definitions` VALUES (4117, 1644, 3, 'Constitucional');
INSERT INTO `lang_definitions` VALUES (4118, 1647, 3, 'Breve Descripción de Consulta');
INSERT INTO `lang_definitions` VALUES (4119, 1648, 3, 'Contacto');
INSERT INTO `lang_definitions` VALUES (4120, 1649, 3, 'email del contacto');
INSERT INTO `lang_definitions` VALUES (4121, 1650, 3, 'email de contacto');
INSERT INTO `lang_definitions` VALUES (4122, 1652, 3, 'Informacion de contacto');
INSERT INTO `lang_definitions` VALUES (4123, 1655, 3, 'Lentes de Contacto');
INSERT INTO `lang_definitions` VALUES (4124, 1660, 3, 'Nombre del contacto');
INSERT INTO `lang_definitions` VALUES (4125, 1663, 3, 'Persona de Contacto');
INSERT INTO `lang_definitions` VALUES (4126, 1665, 3, 'Número de Teléfono de Contacto');
INSERT INTO `lang_definitions` VALUES (4127, 1667, 3, 'Contactar ZMG, LLC (zmghealth@gmail.com) para suscribir el servicio de receta electrónica');
INSERT INTO `lang_definitions` VALUES (4128, 1669, 3, 'contiene por lo menos tres de las cuatro cosas siguientes:');
INSERT INTO `lang_definitions` VALUES (4129, 1671, 3, 'Contenido');
INSERT INTO `lang_definitions` VALUES (4130, 1672, 3, 'contenido');
INSERT INTO `lang_definitions` VALUES (4131, 1674, 3, 'Contexto');
INSERT INTO `lang_definitions` VALUES (4132, 1675, 3, 'El nombre de contexto no puede estar vacío');
INSERT INTO `lang_definitions` VALUES (4133, 1676, 3, 'Continuar');
INSERT INTO `lang_definitions` VALUES (4134, 1677, 3, 'Continuidad del Documento de Atención (CCD)');
INSERT INTO `lang_definitions` VALUES (4135, 1678, 3, 'Continuidad del registro de cuidados (CCR)');
INSERT INTO `lang_definitions` VALUES (4136, 1679, 3, 'Contra Clientes');
INSERT INTO `lang_definitions` VALUES (4137, 1680, 3, 'Contracepción');
INSERT INTO `lang_definitions` VALUES (4138, 1681, 3, 'Incidencias de Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4139, 1682, 3, 'Complicación anticonceptivos (especificar)');
INSERT INTO `lang_definitions` VALUES (4140, 1683, 3, 'Método Anticonceptivo');
INSERT INTO `lang_definitions` VALUES (4141, 1684, 3, 'Productos Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4142, 1685, 3, 'Servicios anticonceptivos ya empezados');
INSERT INTO `lang_definitions` VALUES (4143, 1686, 3, 'Comienzo de anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4144, 1691, 3, 'Nº Identificación de control');
INSERT INTO `lang_definitions` VALUES (4145, 1692, 3, 'N º de control');
INSERT INTO `lang_definitions` VALUES (4146, 1700, 3, 'COPAGO');
INSERT INTO `lang_definitions` VALUES (4147, 1701, 3, 'Co-pago');
INSERT INTO `lang_definitions` VALUES (4148, 1702, 3, 'Co-Pago');
INSERT INTO `lang_definitions` VALUES (4149, 1703, 3, 'El Co-pago no es positivo');
INSERT INTO `lang_definitions` VALUES (4150, 1705, 3, 'Co-pagos');
INSERT INTO `lang_definitions` VALUES (4151, 1706, 3, 'COPD');
INSERT INTO `lang_definitions` VALUES (4152, 1707, 3, 'Copiar páginas a la Historia del Paciente');
INSERT INTO `lang_definitions` VALUES (4153, 1709, 3, 'Copiar Valores');
INSERT INTO `lang_definitions` VALUES (4154, 1710, 3, 'Copiando base de datos. Puede tardar algún tiempo');
INSERT INTO `lang_definitions` VALUES (4155, 1711, 3, 'Aviso de Derechos Reservados');
INSERT INTO `lang_definitions` VALUES (4156, 1716, 3, 'Bypass coronario arterial');
INSERT INTO `lang_definitions` VALUES (4157, 1717, 3, 'Cirugía de revascularización coronaria');
INSERT INTO `lang_definitions` VALUES (4158, 1718, 3, 'Corregido');
INSERT INTO `lang_definitions` VALUES (4159, 1720, 3, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (4160, 1721, 3, 'Conexión a CouchDB fallida.');
INSERT INTO `lang_definitions` VALUES (4161, 1722, 3, 'bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4162, 1723, 3, 'Nombre de bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4163, 1724, 3, 'Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4164, 1725, 3, 'Nombre Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4165, 1726, 3, 'Activar Log CouchDB');
INSERT INTO `lang_definitions` VALUES (4166, 1727, 3, 'Contraseña CouchDB');
INSERT INTO `lang_definitions` VALUES (4167, 1728, 3, 'Puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4168, 1729, 3, 'puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4169, 1731, 3, 'Nombre usuario CouchDB');
INSERT INTO `lang_definitions` VALUES (4170, 1732, 3, 'Tos');
INSERT INTO `lang_definitions` VALUES (4171, 1733, 3, 'Tos:');
INSERT INTO `lang_definitions` VALUES (4172, 1738, 3, 'No se pudo leer el fichero');
INSERT INTO `lang_definitions` VALUES (4173, 1740, 3, 'email no enviado por problema en el servidor,');
INSERT INTO `lang_definitions` VALUES (4174, 1742, 3, 'No se pudo enviar email debido a problemas en el servidor.');
INSERT INTO `lang_definitions` VALUES (4175, 1743, 3, 'No se pudo crear el dir de backup:');
INSERT INTO `lang_definitions` VALUES (4176, 1744, 3, 'No se pudo eliminar dir:');
INSERT INTO `lang_definitions` VALUES (4177, 1745, 3, 'No se pudo eliminar el antiguo fichero de Backup:');
INSERT INTO `lang_definitions` VALUES (4178, 1746, 3, 'No se pudo eliminar el antiguo fichero de exportación:');
INSERT INTO `lang_definitions` VALUES (4179, 1747, 3, 'Tratamiento con Coumadin - Seguimiento del Ratio Internacional Normalizado (RIN)');
INSERT INTO `lang_definitions` VALUES (4180, 1748, 3, 'Counseling por Método');
INSERT INTO `lang_definitions` VALUES (4181, 1749, 3, 'Orientación');
INSERT INTO `lang_definitions` VALUES (4182, 1750, 3, 'Actividades de orientación');
INSERT INTO `lang_definitions` VALUES (4183, 1753, 3, 'FORMULARIO CONTADOR DE DERIVACIONES');
INSERT INTO `lang_definitions` VALUES (4184, 1754, 3, 'Contador-Derivación');
INSERT INTO `lang_definitions` VALUES (4185, 1755, 3, 'País');
INSERT INTO `lang_definitions` VALUES (4186, 1757, 3, 'Tipo de datos País');
INSERT INTO `lang_definitions` VALUES (4187, 1758, 3, 'Lista de País');
INSERT INTO `lang_definitions` VALUES (4188, 1759, 3, 'Lista del país (escriba, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4189, 1761, 3, 'Nombre del Pais deber ser representados por dos letras');
INSERT INTO `lang_definitions` VALUES (4190, 1762, 3, 'condado');
INSERT INTO `lang_definitions` VALUES (4191, 1764, 3, 'Cupón');
INSERT INTO `lang_definitions` VALUES (4192, 1768, 3, 'CPT');
INSERT INTO `lang_definitions` VALUES (4193, 1769, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4194, 1770, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4195, 1771, 3, 'Procedimiento/Servicio CPT4');
INSERT INTO `lang_definitions` VALUES (4196, 1772, 3, 'Medidas de Rendimiento CPTII');
INSERT INTO `lang_definitions` VALUES (4197, 1773, 3, 'Gestión Calidad Continua (GCC)');
INSERT INTO `lang_definitions` VALUES (4198, 1774, 3, 'Crujidos, crepitaciones');
INSERT INTO `lang_definitions` VALUES (4199, 1777, 3, 'crema');
INSERT INTO `lang_definitions` VALUES (4200, 1778, 3, 'Crear un certificado SSL del Cliente por usuario o cliente de maquina');
INSERT INTO `lang_definitions` VALUES (4201, 1779, 3, 'Crear un certificado SSL del lado del cliente, ya sea para un usuario o un nombre de host cliente.');
INSERT INTO `lang_definitions` VALUES (4202, 1782, 3, 'Crear un evento');
INSERT INTO `lang_definitions` VALUES (4203, 1783, 3, 'Crear y descargar un respaldo completo');
INSERT INTO `lang_definitions` VALUES (4204, 1785, 3, 'Crear Respaldo');
INSERT INTO `lang_definitions` VALUES (4205, 1786, 3, 'Crear batch');
INSERT INTO `lang_definitions` VALUES (4206, 1787, 3, 'Crear Certificado de Cliente');
INSERT INTO `lang_definitions` VALUES (4207, 1788, 3, 'Crear Certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4208, 1791, 3, 'Crear Duplicado');
INSERT INTO `lang_definitions` VALUES (4209, 1793, 3, 'Crear backup de registro de eventos');
INSERT INTO `lang_definitions` VALUES (4210, 1794, 3, 'Crear nueva incidencia');
INSERT INTO `lang_definitions` VALUES (4211, 1795, 3, 'Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4212, 1797, 3, 'Crear Credenciales para el Portal Offsite');
INSERT INTO `lang_definitions` VALUES (4213, 1798, 3, 'Crear Credenciales para el Portal Onsite');
INSERT INTO `lang_definitions` VALUES (4214, 1799, 3, 'Crear nota de paciente');
INSERT INTO `lang_definitions` VALUES (4215, 1800, 3, 'Crear Certificado de Autoridad SSL y Certificados del Servidor.');
INSERT INTO `lang_definitions` VALUES (4216, 1801, 3, 'Crear visita');
INSERT INTO `lang_definitions` VALUES (4217, 1802, 3, 'Creado');
INSERT INTO `lang_definitions` VALUES (4218, 1804, 3, 'Creando fichero de exportación');
INSERT INTO `lang_definitions` VALUES (4219, 1807, 3, 'Creador');
INSERT INTO `lang_definitions` VALUES (4220, 1808, 3, 'crédito');
INSERT INTO `lang_definitions` VALUES (4221, 1809, 3, 'Tarjeta de Credito');
INSERT INTO `lang_definitions` VALUES (4222, 1810, 3, 'Créditos');
INSERT INTO `lang_definitions` VALUES (4223, 1812, 3, 'Criterio');
INSERT INTO `lang_definitions` VALUES (4224, 1814, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4225, 1815, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4226, 1818, 3, 'CSV');
INSERT INTO `lang_definitions` VALUES (4227, 1819, 3, 'Fichero CSV');
INSERT INTO `lang_definitions` VALUES (4228, 1824, 3, 'MM.CU (Mililitros cubicos)');
INSERT INTO `lang_definitions` VALUES (4229, 1825, 3, 'Cubano');
INSERT INTO `lang_definitions` VALUES (4230, 1827, 3, 'Número de decimales en moneda');
INSERT INTO `lang_definitions` VALUES (4231, 1828, 3, 'Tipo de Cambio - Símbolo de Punto Decimal');
INSERT INTO `lang_definitions` VALUES (4232, 1829, 3, 'Indicador de Tipo de Cambio');
INSERT INTO `lang_definitions` VALUES (4233, 1830, 3, 'Tipo de Cambio - Separador de Miles');
INSERT INTO `lang_definitions` VALUES (4234, 1831, 3, 'Actual');
INSERT INTO `lang_definitions` VALUES (4235, 1832, 3, 'Alcohol actual');
INSERT INTO `lang_definitions` VALUES (4236, 1833, 3, 'Consulta Actual');
INSERT INTO `lang_definitions` VALUES (4237, 1834, 3, 'Criterio Actual');
INSERT INTO `lang_definitions` VALUES (4238, 1835, 3, 'Color resaltado del presente día');
INSERT INTO `lang_definitions` VALUES (4239, 1836, 3, 'Actualmente fumador diario');
INSERT INTO `lang_definitions` VALUES (4240, 1838, 3, 'El nombre de fichero actual fue cambiado a');
INSERT INTO `lang_definitions` VALUES (4241, 1840, 3, 'Hash actual');
INSERT INTO `lang_definitions` VALUES (4242, 1841, 3, 'Ubicación actual');
INSERT INTO `lang_definitions` VALUES (4243, 1843, 3, 'Medicamentos Actuales');
INSERT INTO `lang_definitions` VALUES (4244, 1844, 3, 'Contraseña Actual');
INSERT INTO `lang_definitions` VALUES (4245, 1845, 3, 'Paciente Actual');
INSERT INTO `lang_definitions` VALUES (4246, 1849, 3, 'Drogas no farmacológicas actuales');
INSERT INTO `lang_definitions` VALUES (4247, 1851, 3, 'Actualmente fumador ocasional');
INSERT INTO `lang_definitions` VALUES (4248, 1857, 3, 'Actualmente Activo');
INSERT INTO `lang_definitions` VALUES (4249, 1861, 3, 'Actualmente no hay clínicas');
INSERT INTO `lang_definitions` VALUES (4250, 1863, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4251, 1864, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4252, 1867, 3, 'Costumbre');
INSERT INTO `lang_definitions` VALUES (4253, 1870, 3, '¿Entrada cliente?');
INSERT INTO `lang_definitions` VALUES (4254, 1872, 3, 'Tabla Cliente');
INSERT INTO `lang_definitions` VALUES (4255, 1876, 3, 'Código CVX');
INSERT INTO `lang_definitions` VALUES (4256, 1877, 3, 'Mapa de Código CVX');
INSERT INTO `lang_definitions` VALUES (4257, 1878, 3, 'Vacunación CVX');
INSERT INTO `lang_definitions` VALUES (4258, 1880, 3, 'Ciclo');
INSERT INTO `lang_definitions` VALUES (4259, 1886, 3, 'CYP');
INSERT INTO `lang_definitions` VALUES (4260, 1887, 3, 'Factor de CYP');
INSERT INTO `lang_definitions` VALUES (4261, 1888, 3, 'Informe de CYP');
INSERT INTO `lang_definitions` VALUES (4262, 1889, 3, 'Checo');
INSERT INTO `lang_definitions` VALUES (4263, 1890, 3, 'D');
INSERT INTO `lang_definitions` VALUES (4264, 1891, 3, 'D&C');
INSERT INTO `lang_definitions` VALUES (4265, 1892, 3, 'D&E');
INSERT INTO `lang_definitions` VALUES (4266, 1894, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4267, 1895, 3, 'diariamente');
INSERT INTO `lang_definitions` VALUES (4268, 1896, 3, 'Registro Diario');
INSERT INTO `lang_definitions` VALUES (4269, 1899, 3, 'Danés');
INSERT INTO `lang_definitions` VALUES (4270, 1901, 3, 'Información parecida está ya en la base de datos, por favor cambie el código o la descripción');
INSERT INTO `lang_definitions` VALUES (4271, 1902, 3, 'Información parecida está ya en la base de datos, por favor cambie el nombre de la constante');
INSERT INTO `lang_definitions` VALUES (4272, 1903, 3, 'Datos Cols');
INSERT INTO `lang_definitions` VALUES (4273, 1906, 3, 'Error de datos');
INSERT INTO `lang_definitions` VALUES (4274, 1910, 3, 'Tipo de datos');
INSERT INTO `lang_definitions` VALUES (4275, 1911, 3, 'Base de datos');
INSERT INTO `lang_definitions` VALUES (4276, 1912, 3, 'Base de datos sin instalar');
INSERT INTO `lang_definitions` VALUES (4277, 1914, 3, 'Revisión bbdd');
INSERT INTO `lang_definitions` VALUES (4278, 1915, 3, 'Información de la base de datos');
INSERT INTO `lang_definitions` VALUES (4279, 1917, 3, 'Actualización de base de datos completa');
INSERT INTO `lang_definitions` VALUES (4280, 1918, 3, 'DataCols debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (4281, 1919, 3, 'Fecha');
INSERT INTO `lang_definitions` VALUES (4282, 1920, 3, 'FECHA');
INSERT INTO `lang_definitions` VALUES (4283, 1923, 3, 'Fecha adminstrada');
INSERT INTO `lang_definitions` VALUES (4284, 1924, 3, 'Fecha y hora de coleccion de muestra');
INSERT INTO `lang_definitions` VALUES (4285, 1925, 3, 'Fecha y hora de esta observación');
INSERT INTO `lang_definitions` VALUES (4286, 1927, 3, 'Fecha y hora cuando la muestra fue colectada');
INSERT INTO `lang_definitions` VALUES (4287, 1928, 3, 'La fecha no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4288, 1929, 3, 'Fecha en que fueron provistos inicialmente los servicios anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4289, 1930, 3, 'Fecha Creacion');
INSERT INTO `lang_definitions` VALUES (4290, 1931, 3, 'Fecha Defunción');
INSERT INTO `lang_definitions` VALUES (4291, 1932, 3, 'Fecha destruída');
INSERT INTO `lang_definitions` VALUES (4292, 1933, 3, 'Formato visualización de fecha');
INSERT INTO `lang_definitions` VALUES (4293, 1934, 3, 'Formato fecha para última cita no es válido');
INSERT INTO `lang_definitions` VALUES (4294, 1935, 3, 'Formato fecha para inicio de cita no es válido');
INSERT INTO `lang_definitions` VALUES (4295, 1936, 3, 'Formato fecha en \'Próxima Cita\' no es válido');
INSERT INTO `lang_definitions` VALUES (4296, 1937, 3, 'Formato fecha en \'no visto desde\' no es válido');
INSERT INTO `lang_definitions` VALUES (4297, 1939, 3, 'Formato fecha en \'visto en\' no es válido');
INSERT INTO `lang_definitions` VALUES (4298, 1940, 3, 'Comunicados de fechas de vacunación entregados');
INSERT INTO `lang_definitions` VALUES (4299, 1941, 3, 'Falta fecha para código');
INSERT INTO `lang_definitions` VALUES (4300, 1942, 3, 'Criterio maestro de fecha');
INSERT INTO `lang_definitions` VALUES (4301, 1945, 3, 'Fecha ingreso en banco aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4302, 1946, 3, 'Fecha de factura');
INSERT INTO `lang_definitions` VALUES (4303, 1947, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4304, 1948, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4305, 1949, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4306, 1951, 3, 'Fecha de entrada');
INSERT INTO `lang_definitions` VALUES (4307, 1953, 3, 'Fecha de la lesión');
INSERT INTO `lang_definitions` VALUES (4308, 1957, 3, 'Fecha de pago aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4309, 1959, 3, 'Fecha de derivación');
INSERT INTO `lang_definitions` VALUES (4310, 1961, 3, 'Fecha de la respuesta');
INSERT INTO `lang_definitions` VALUES (4311, 1963, 3, 'Fecha De Servicio');
INSERT INTO `lang_definitions` VALUES (4312, 1965, 3, 'Fecha de servicio');
INSERT INTO `lang_definitions` VALUES (4313, 1966, 3, 'Fecha de servicio = hoy');
INSERT INTO `lang_definitions` VALUES (4314, 1967, 3, 'Fecha de servicio mm/dd/aaaa');
INSERT INTO `lang_definitions` VALUES (4315, 1968, 3, 'Fecha de Servicio:');
INSERT INTO `lang_definitions` VALUES (4316, 1969, 3, 'Fecha de firma');
INSERT INTO `lang_definitions` VALUES (4317, 1972, 3, 'Fecha de esta orden');
INSERT INTO `lang_definitions` VALUES (4318, 1973, 3, 'Fecha de este reporte');
INSERT INTO `lang_definitions` VALUES (4319, 1974, 3, 'Fecha de la Declaración de VIS');
INSERT INTO `lang_definitions` VALUES (4320, 1975, 3, 'Fecha en que se ordenó');
INSERT INTO `lang_definitions` VALUES (4321, 1978, 3, 'Seleccionador de fecha');
INSERT INTO `lang_definitions` VALUES (4322, 1979, 3, 'Fecha Envio');
INSERT INTO `lang_definitions` VALUES (4323, 1980, 3, 'Fecha del mensaje enviado');
INSERT INTO `lang_definitions` VALUES (4324, 1982, 3, 'La fecha no puede estar en blanco');
INSERT INTO `lang_definitions` VALUES (4325, 1985, 3, 'Fecha/Cita');
INSERT INTO `lang_definitions` VALUES (4326, 1986, 3, 'Fecha/Notas');
INSERT INTO `lang_definitions` VALUES (4327, 1987, 3, 'Fecha/Notas de Último');
INSERT INTO `lang_definitions` VALUES (4328, 1988, 3, 'Fecha/Hora');
INSERT INTO `lang_definitions` VALUES (4329, 1989, 3, 'Fecha:');
INSERT INTO `lang_definitions` VALUES (4330, 1991, 3, 'Registro mensaje fechado');
INSERT INTO `lang_definitions` VALUES (4331, 1993, 3, 'Día');
INSERT INTO `lang_definitions` VALUES (4332, 1994, 3, 'dia');
INSERT INTO `lang_definitions` VALUES (4333, 1996, 3, 'Vista de día');
INSERT INTO `lang_definitions` VALUES (4334, 1997, 3, 'Día(s)');
INSERT INTO `lang_definitions` VALUES (4335, 1998, 3, 'Día(s) L-V');
INSERT INTO `lang_definitions` VALUES (4336, 1999, 3, 'días');
INSERT INTO `lang_definitions` VALUES (4337, 2000, 3, 'Días');
INSERT INTO `lang_definitions` VALUES (4338, 2001, 3, 'días pasados');
INSERT INTO `lang_definitions` VALUES (4339, 2002, 3, 'Dïas y juegos perdidos');
INSERT INTO `lang_definitions` VALUES (4340, 2003, 3, 'Días Desde la Última Visita');
INSERT INTO `lang_definitions` VALUES (4341, 2004, 3, 'Dias faltados');
INSERT INTO `lang_definitions` VALUES (4342, 2007, 3, 'Días por columna');
INSERT INTO `lang_definitions` VALUES (4343, 2009, 3, 'Días/Col');
INSERT INTO `lang_definitions` VALUES (4344, 2010, 3, 'DB instalado');
INSERT INTO `lang_definitions` VALUES (4345, 2011, 3, 'DD/MM/AAAA');
INSERT INTO `lang_definitions` VALUES (4346, 2012, 3, 'Anonimato');
INSERT INTO `lang_definitions` VALUES (4347, 2013, 3, 'El proceso de anonimato está completo');
INSERT INTO `lang_definitions` VALUES (4348, 2014, 3, 'El proceso de anonimato está en proceso');
INSERT INTO `lang_definitions` VALUES (4349, 2015, 3, 'El proceso de anonimato ha iniciado y está corriendo en el fondo');
INSERT INTO `lang_definitions` VALUES (4350, 2016, 3, 'Los datos anónimos pueden no estar completos');
INSERT INTO `lang_definitions` VALUES (4351, 2017, 3, 'Los ficheros anónimos serán guardados en');
INSERT INTO `lang_definitions` VALUES (4352, 2018, 3, 'DEA');
INSERT INTO `lang_definitions` VALUES (4353, 2021, 3, 'Sordera');
INSERT INTO `lang_definitions` VALUES (4354, 2022, 3, 'Elimine errores de la información');
INSERT INTO `lang_definitions` VALUES (4355, 2025, 3, 'Dic');
INSERT INTO `lang_definitions` VALUES (4356, 2026, 3, 'DIFUNTO');
INSERT INTO `lang_definitions` VALUES (4357, 2032, 3, 'Diciembre');
INSERT INTO `lang_definitions` VALUES (4358, 2035, 3, 'Deducible');
INSERT INTO `lang_definitions` VALUES (4359, 2036, 3, 'Deducible alcanzado');
INSERT INTO `lang_definitions` VALUES (4360, 2038, 3, 'Por Defecto');
INSERT INTO `lang_definitions` VALUES (4361, 2039, 3, 'Vista Calendario por defecto');
INSERT INTO `lang_definitions` VALUES (4362, 2040, 3, 'Formulario ID para Visita por defecto');
INSERT INTO `lang_definitions` VALUES (4363, 2042, 3, 'Centro por defecto');
INSERT INTO `lang_definitions` VALUES (4364, 2045, 3, 'Idioma por defecto');
INSERT INTO `lang_definitions` VALUES (4365, 2046, 3, 'Idioma por defecto si no se permite otro, o bien elegir.');
INSERT INTO `lang_definitions` VALUES (4366, 2049, 3, 'Lista por defecto (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4367, 2051, 3, 'Método por defecto');
INSERT INTO `lang_definitions` VALUES (4368, 2052, 3, 'Días Expiración Contraseña por Defecto');
INSERT INTO `lang_definitions` VALUES (4369, 2053, 3, 'El periodo de vencimiento de la contraseña por defecto es 0. Ésto significa que la función está desactivada');
INSERT INTO `lang_definitions` VALUES (4370, 2054, 3, 'País por defecto del Paciente');
INSERT INTO `lang_definitions` VALUES (4371, 2058, 3, 'Médico por defecto');
INSERT INTO `lang_definitions` VALUES (4372, 2060, 3, 'Rango por defecto');
INSERT INTO `lang_definitions` VALUES (4373, 2061, 3, 'Razón por defecto de la visita');
INSERT INTO `lang_definitions` VALUES (4374, 2066, 3, 'Configuración por defecto');
INSERT INTO `lang_definitions` VALUES (4375, 2067, 3, 'Estado de la casilla por defecto de nueva ventana en la lista de pacientes.');
INSERT INTO `lang_definitions` VALUES (4376, 2068, 3, 'Plantilla por defecto');
INSERT INTO `lang_definitions` VALUES (4377, 2074, 3, 'Unidades por defecto');
INSERT INTO `lang_definitions` VALUES (4378, 2075, 3, 'Valor por defecto');
INSERT INTO `lang_definitions` VALUES (4379, 2077, 3, 'Deposito por defecto');
INSERT INTO `lang_definitions` VALUES (4380, 2078, 3, 'Socio X12 por defecto');
INSERT INTO `lang_definitions` VALUES (4381, 2079, 3, 'Por defecto/Global');
INSERT INTO `lang_definitions` VALUES (4382, 2083, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4383, 2084, 3, 'borrar');
INSERT INTO `lang_definitions` VALUES (4384, 2085, 3, 'Repetición retrasada (> 12 Mo)');
INSERT INTO `lang_definitions` VALUES (4385, 2086, 3, 'Eliminar');
INSERT INTO `lang_definitions` VALUES (4386, 2087, 3, 'eliminar');
INSERT INTO `lang_definitions` VALUES (4387, 2088, 3, 'Eliminar Categorías con identificador(es) :');
INSERT INTO `lang_definitions` VALUES (4388, 2089, 3, 'Borrar Categoría');
INSERT INTO `lang_definitions` VALUES (4389, 2093, 3, 'Eliminar Grupo');
INSERT INTO `lang_definitions` VALUES (4390, 2094, 3, 'Eliminar Lista');
INSERT INTO `lang_definitions` VALUES (4391, 2096, 3, 'Eliminar Páginas');
INSERT INTO `lang_definitions` VALUES (4392, 2097, 3, 'Borrar Paciente, visita, formulario, Incidencia, Documento, Pago, facturación o Transacción');
INSERT INTO `lang_definitions` VALUES (4393, 2099, 3, 'Borrar fila');
INSERT INTO `lang_definitions` VALUES (4394, 2100, 3, 'Borrar ítems selectos');
INSERT INTO `lang_definitions` VALUES (4395, 2103, 3, 'Eliminar éxito.');
INSERT INTO `lang_definitions` VALUES (4396, 2104, 3, 'Eliminar este documento');
INSERT INTO `lang_definitions` VALUES (4397, 2105, 3, 'Eliminar este formulario');
INSERT INTO `lang_definitions` VALUES (4398, 2107, 3, 'Eliminar esta nota');
INSERT INTO `lang_definitions` VALUES (4399, 2109, 3, 'Borrado Completado');
INSERT INTO `lang_definitions` VALUES (4400, 2111, 3, 'No se puede deshacer la eliminación de este evento. No se puede recuperar una vez que se ha hecho. ¿Está seguro que desea eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (4401, 2119, 3, 'Demencia');
INSERT INTO `lang_definitions` VALUES (4402, 2121, 3, 'Datos demográficos');
INSERT INTO `lang_definitions` VALUES (4403, 2122, 3, 'Demografía (escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4404, 2125, 3, 'Criterio de Filtro Demográficos');
INSERT INTO `lang_definitions` VALUES (4405, 2127, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4406, 2128, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4407, 2129, 3, 'Denegado');
INSERT INTO `lang_definitions` VALUES (4408, 2131, 3, 'Denominador');
INSERT INTO `lang_definitions` VALUES (4409, 2134, 3, 'Dental');
INSERT INTO `lang_definitions` VALUES (4410, 2136, 3, 'Incidencias Dentales');
INSERT INTO `lang_definitions` VALUES (4411, 2139, 3, 'Dependiendo del tipo de cuenta que usted prueba, usted verá salida tipo HCFA en una página en blanco para las cuentas de HCFA, o usted verá muchas líneas de texto e información alteradas, si usted está probando una demanda X12. Ese texto mutilado es el formato del X12 IED 4010A. Usted verá de vez en cuando los caracteres extraños que parecen dominós o basura, se trata de caracteres de control tales como alimentaciones de página y son normales.');
INSERT INTO `lang_definitions` VALUES (4412, 2140, 3, 'Fecha de depósito');
INSERT INTO `lang_definitions` VALUES (4413, 2141, 3, 'La fecha del deposiito no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4414, 2142, 3, 'Fecha del depósito');
INSERT INTO `lang_definitions` VALUES (4415, 2143, 3, 'Depresivo');
INSERT INTO `lang_definitions` VALUES (4416, 2144, 3, 'Depresión');
INSERT INTO `lang_definitions` VALUES (4417, 2149, 3, 'Descripción');
INSERT INTO `lang_definitions` VALUES (4418, 2150, 3, 'descripción');
INSERT INTO `lang_definitions` VALUES (4419, 2152, 3, 'Descripción de la publicación');
INSERT INTO `lang_definitions` VALUES (4420, 2153, 3, 'Desceripcion de este procedimiento o codigo resultante');
INSERT INTO `lang_definitions` VALUES (4421, 2154, 3, 'Traducción de la descripción');
INSERT INTO `lang_definitions` VALUES (4422, 2156, 3, 'Destino');
INSERT INTO `lang_definitions` VALUES (4423, 2157, 3, 'Nombre del fichero destino');
INSERT INTO `lang_definitions` VALUES (4424, 2158, 3, 'Destruir todo el lote');
INSERT INTO `lang_definitions` VALUES (4425, 2159, 3, 'Destruido ...');
INSERT INTO `lang_definitions` VALUES (4426, 2160, 3, 'Destruido');
INSERT INTO `lang_definitions` VALUES (4427, 2161, 3, 'Drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4428, 2162, 3, 'Informe drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4429, 2163, 3, 'Detalle');
INSERT INTO `lang_definitions` VALUES (4430, 2167, 3, 'Detalles');
INSERT INTO `lang_definitions` VALUES (4431, 2169, 3, 'Anormalidad del desarrollo');
INSERT INTO `lang_definitions` VALUES (4432, 2171, 3, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (4433, 2172, 3, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (4434, 2173, 3, 'Diabetes: Gestión presión arterial (GCC)');
INSERT INTO `lang_definitions` VALUES (4435, 2174, 3, 'Diabetes:Examen Ocular');
INSERT INTO `lang_definitions` VALUES (4436, 2175, 3, 'Diabetes: Examen ocular (GCC)');
INSERT INTO `lang_definitions` VALUES (4437, 2176, 3, 'Diabetes: Examen de los pies');
INSERT INTO `lang_definitions` VALUES (4438, 2177, 3, 'Diabetes: Examen de los pies (GCC)');
INSERT INTO `lang_definitions` VALUES (4439, 2178, 3, 'Diabetes:Control HbA1c Deficiente (GCC)');
INSERT INTO `lang_definitions` VALUES (4440, 2179, 3, 'Diabetes: Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (4441, 2180, 3, 'Diabetes: Gestión LDL y Control (GCC)');
INSERT INTO `lang_definitions` VALUES (4442, 2181, 3, 'Diabetes: Microalbúmina de la orina');
INSERT INTO `lang_definitions` VALUES (4443, 2182, 3, 'Diag');
INSERT INTO `lang_definitions` VALUES (4444, 2184, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4445, 2185, 3, 'Cód. Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4446, 2187, 3, 'Fecha de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4447, 2188, 3, 'El diagnóstico debe ser codificado en una visita vinculada');
INSERT INTO `lang_definitions` VALUES (4448, 2189, 3, 'Nombre del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4449, 2190, 3, 'Reporte del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4450, 2191, 3, 'Informe de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4451, 2192, 3, 'Informe sólo de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4452, 2193, 3, 'Título del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4453, 2194, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4454, 2195, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4455, 2197, 3, 'Pruebas diagnósticas:');
INSERT INTO `lang_definitions` VALUES (4456, 2198, 3, 'Diales');
INSERT INTO `lang_definitions` VALUES (4457, 2201, 3, 'Diafragmas/Capuchón cervical');
INSERT INTO `lang_definitions` VALUES (4458, 2202, 3, 'Diarrea');
INSERT INTO `lang_definitions` VALUES (4459, 2204, 3, 'Dictado');
INSERT INTO `lang_definitions` VALUES (4460, 2205, 3, 'Dictado:');
INSERT INTO `lang_definitions` VALUES (4461, 2206, 3, '¿Usted recibió una copia del aviso de HIPAA?');
INSERT INTO `lang_definitions` VALUES (4462, 2207, 3, 'Difuso:');
INSERT INTO `lang_definitions` VALUES (4463, 2208, 3, 'Firmado digitalmente');
INSERT INTO `lang_definitions` VALUES (4464, 2216, 3, 'Correo Directo');
INSERT INTO `lang_definitions` VALUES (4465, 2222, 3, 'Nombre del director');
INSERT INTO `lang_definitions` VALUES (4466, 2224, 3, 'inhabilitación');
INSERT INTO `lang_definitions` VALUES (4467, 2226, 3, 'Deshabilitar calendario');
INSERT INTO `lang_definitions` VALUES (4468, 2227, 3, 'Deshabilitar Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (4469, 2228, 3, 'Deshabilitar vacunaciones');
INSERT INTO `lang_definitions` VALUES (4470, 2229, 3, 'Deshabilitar vieja forma métrica de constantes vitales');
INSERT INTO `lang_definitions` VALUES (4471, 2231, 3, 'Deshabilitar phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (4472, 2232, 3, 'Deshabilitar prescriciones');
INSERT INTO `lang_definitions` VALUES (4473, 2233, 3, 'Deshabilitar grupos de usuarios');
INSERT INTO `lang_definitions` VALUES (4474, 2234, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4475, 2235, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4476, 2236, 3, 'Beneficiario discapacitado menor de 65 años con un Plan de salud para grandes grupos (LGHP)');
INSERT INTO `lang_definitions` VALUES (4477, 2238, 3, 'DISCO');
INSERT INTO `lang_definitions` VALUES (4478, 2241, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4479, 2242, 3, 'Pérdidas/secreciones de la uretra');
INSERT INTO `lang_definitions` VALUES (4480, 2244, 3, 'Derecho de alta');
INSERT INTO `lang_definitions` VALUES (4481, 2245, 3, 'Derecho de alta:');
INSERT INTO `lang_definitions` VALUES (4482, 2249, 3, 'Informacion de publicación');
INSERT INTO `lang_definitions` VALUES (4483, 2250, 3, 'Tipo de publicación');
INSERT INTO `lang_definitions` VALUES (4484, 2251, 3, 'Tipos de publicación');
INSERT INTO `lang_definitions` VALUES (4485, 2252, 3, 'Publicaciones');
INSERT INTO `lang_definitions` VALUES (4486, 2255, 3, 'Descuento');
INSERT INTO `lang_definitions` VALUES (4487, 2256, 3, 'Suma de descuento');
INSERT INTO `lang_definitions` VALUES (4488, 2257, 3, 'Nivel del Descuento');
INSERT INTO `lang_definitions` VALUES (4489, 2258, 3, 'Porcentaje de descuento');
INSERT INTO `lang_definitions` VALUES (4490, 2259, 3, 'Descuentos como importes monetarios');
INSERT INTO `lang_definitions` VALUES (4491, 2260, 3, 'Descuentos a la hora de salida se introducen como cantidades de dinero, a diferencia de porcentaje.');
INSERT INTO `lang_definitions` VALUES (4492, 2261, 3, 'Resultado discreto');
INSERT INTO `lang_definitions` VALUES (4493, 2262, 3, 'Enfermedad');
INSERT INTO `lang_definitions` VALUES (4494, 2264, 3, 'Dislocación');
INSERT INTO `lang_definitions` VALUES (4495, 2267, 3, '# Disp');
INSERT INTO `lang_definitions` VALUES (4496, 2268, 3, 'Informe');
INSERT INTO `lang_definitions` VALUES (4497, 2269, 3, 'Remitir documento recibido');
INSERT INTO `lang_definitions` VALUES (4498, 2273, 3, 'Prescrito');
INSERT INTO `lang_definitions` VALUES (4499, 2276, 3, 'Mostrar las directivas anticipadas en la página de la demografía.');
INSERT INTO `lang_definitions` VALUES (4500, 2278, 3, '¿Mostrar fechas de eventos en bloque?');
INSERT INTO `lang_definitions` VALUES (4501, 2280, 3, '¿Mostrar cuántos eventos?');
INSERT INTO `lang_definitions` VALUES (4502, 2283, 3, '¿Mostrar lugar/sitio en bloque?');
INSERT INTO `lang_definitions` VALUES (4503, 2284, 3, 'Nombre Pantalla');
INSERT INTO `lang_definitions` VALUES (4504, 2286, 3, '¿Mostrar el calendario?');
INSERT INTO `lang_definitions` VALUES (4505, 2293, 3, '¿Mostrar los eventos de hoy en el bloque?');
INSERT INTO `lang_definitions` VALUES (4506, 2294, 3, '¿Mostrar tema en el bloque?');
INSERT INTO `lang_definitions` VALUES (4507, 2295, 3, '¿Mostrar los eventos próximos en tabla?');
INSERT INTO `lang_definitions` VALUES (4508, 2296, 3, 'Mostrar columnas');
INSERT INTO `lang_definitions` VALUES (4509, 2297, 3, 'Viendo el siguiente número de las publicaciones más recientes:');
INSERT INTO `lang_definitions` VALUES (4510, 2298, 3, 'Mostrando el siguiente número de las notas más recientes');
INSERT INTO `lang_definitions` VALUES (4511, 2299, 3, 'Mostrando el siguiente número de las notas más recientes:');
INSERT INTO `lang_definitions` VALUES (4512, 2303, 3, 'Distribución');
INSERT INTO `lang_definitions` VALUES (4513, 2304, 3, 'Distribuciones');
INSERT INTO `lang_definitions` VALUES (4514, 2305, 3, 'Distribuidor');
INSERT INTO `lang_definitions` VALUES (4515, 2310, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4516, 2311, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4517, 2312, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4518, 2313, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4519, 2314, 3, 'Divorciado');
INSERT INTO `lang_definitions` VALUES (4520, 2315, 3, 'Mareo:');
INSERT INTO `lang_definitions` VALUES (4521, 2317, 3, 'No cambiar');
INSERT INTO `lang_definitions` VALUES (4522, 2319, 3, 'No mostrar alergia subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4523, 2321, 3, 'No mostrar medicación subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4524, 2324, 3, 'No mostrar el calendario');
INSERT INTO `lang_definitions` VALUES (4525, 2327, 3, 'No inventariar ni vender nigun producto');
INSERT INTO `lang_definitions` VALUES (4526, 2330, 3, 'No requiere notas del paciente para ser autorizado');
INSERT INTO `lang_definitions` VALUES (4527, 2331, 3, 'Orden de No Resucitar');
INSERT INTO `lang_definitions` VALUES (4528, 2332, 3, 'no guardar');
INSERT INTO `lang_definitions` VALUES (4529, 2333, 3, 'no sustituir');
INSERT INTO `lang_definitions` VALUES (4530, 2335, 3, 'no actuar');
INSERT INTO `lang_definitions` VALUES (4531, 2338, 3, 'De verdad quiere suprimir?');
INSERT INTO `lang_definitions` VALUES (4532, 2339, 3, '¿Verdaderamente desea borrar la selección?');
INSERT INTO `lang_definitions` VALUES (4533, 2340, 3, 'Está seguro que quiere eliminar este grupo');
INSERT INTO `lang_definitions` VALUES (4534, 2342, 3, '¿Quiere continuar?');
INSERT INTO `lang_definitions` VALUES (4535, 2343, 3, '¿Quiere borrar esto?');
INSERT INTO `lang_definitions` VALUES (4536, 2344, 3, '¿Quiere borrar?');
INSERT INTO `lang_definitions` VALUES (4537, 2345, 3, '¿Desea remover este registro?');
INSERT INTO `lang_definitions` VALUES (4538, 2346, 3, '¿Desea continuar añadiendo este nuevo paciente?');
INSERT INTO `lang_definitions` VALUES (4539, 2347, 3, '¿Usted desea continuar con el nuevo nombre?');
INSERT INTO `lang_definitions` VALUES (4540, 2348, 3, '¿Usted desea suprimir DEFINITIVAMENTE este registro de vacunación?');
INSERT INTO `lang_definitions` VALUES (4541, 2349, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4542, 2350, 3, 'Falta F.Nacimiento, por favor insertarla si es posible');
INSERT INTO `lang_definitions` VALUES (4543, 2352, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4544, 2353, 3, 'Médico');
INSERT INTO `lang_definitions` VALUES (4545, 2354, 3, 'Médico:');
INSERT INTO `lang_definitions` VALUES (4546, 2355, 3, 'Nombre del médico y firma');
INSERT INTO `lang_definitions` VALUES (4547, 2356, 3, 'Documento');
INSERT INTO `lang_definitions` VALUES (4548, 2357, 3, 'documento');
INSERT INTO `lang_definitions` VALUES (4549, 2359, 3, 'Categorías documento');
INSERT INTO `lang_definitions` VALUES (4550, 2365, 3, 'El documento no ha podido ser trasladado al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4551, 2367, 3, 'Fecha de documento');
INSERT INTO `lang_definitions` VALUES (4552, 2368, 3, 'Fecha del documento e incidencia actualizadas con éxito');
INSERT INTO `lang_definitions` VALUES (4553, 2369, 3, 'Nº Identificación de Documento');
INSERT INTO `lang_definitions` VALUES (4554, 2371, 3, 'Documento se trasladó a nueva categoría');
INSERT INTO `lang_definitions` VALUES (4555, 2372, 3, 'Documento se trasladó al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4556, 2374, 3, 'Documento aprobó la comprobación de integridad');
INSERT INTO `lang_definitions` VALUES (4557, 2375, 3, 'Método de archivo de documentos');
INSERT INTO `lang_definitions` VALUES (4558, 2376, 3, 'Documento renombrado con éxito');
INSERT INTO `lang_definitions` VALUES (4559, 2381, 3, 'Depósito de documentos/Imágenes');
INSERT INTO `lang_definitions` VALUES (4560, 2383, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4561, 2385, 3, 'Documentos (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4562, 2389, 3, 'DOE');
INSERT INTO `lang_definitions` VALUES (4563, 2395, 3, '¿Este tipo permite codigos relacionados?');
INSERT INTO `lang_definitions` VALUES (4564, 2396, 3, 'Socio doméstico');
INSERT INTO `lang_definitions` VALUES (4565, 2397, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4566, 2398, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4567, 2399, 3, 'No Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4568, 2401, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4569, 2402, 3, 'Hecho con:');
INSERT INTO `lang_definitions` VALUES (4570, 2403, 3, 'Terminado. Ahora se enviará la descarga');
INSERT INTO `lang_definitions` VALUES (4571, 2404, 3, 'DOS');
INSERT INTO `lang_definitions` VALUES (4572, 2405, 3, 'Dosis');
INSERT INTO `lang_definitions` VALUES (4573, 2409, 3, 'Doble click para editar');
INSERT INTO `lang_definitions` VALUES (4574, 2411, 3, 'Visión doble');
INSERT INTO `lang_definitions` VALUES (4575, 2412, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4576, 2415, 3, 'Descargar de todas formas');
INSERT INTO `lang_definitions` VALUES (4577, 2416, 3, 'Descargar expediente de factura, mandar a contabilidad y marcar como facturado.');
INSERT INTO `lang_definitions` VALUES (4578, 2418, 3, 'Certificados de descargas');
INSERT INTO `lang_definitions` VALUES (4579, 2419, 3, 'Descargar datos de configuración');
INSERT INTO `lang_definitions` VALUES (4580, 2423, 3, 'Descargar fichero encriptado');
INSERT INTO `lang_definitions` VALUES (4581, 2424, 3, 'Descargar FAX');
INSERT INTO `lang_definitions` VALUES (4582, 2427, 3, 'Descargar o Borrar una plantilla');
INSERT INTO `lang_definitions` VALUES (4583, 2428, 3, 'Descargar PDF');
INSERT INTO `lang_definitions` VALUES (4584, 2430, 3, 'Descargar seleccionados');
INSERT INTO `lang_definitions` VALUES (4585, 2431, 3, 'Revisar médico');
INSERT INTO `lang_definitions` VALUES (4586, 2432, 3, 'Visitar médico');
INSERT INTO `lang_definitions` VALUES (4587, 2433, 3, 'Dr.');
INSERT INTO `lang_definitions` VALUES (4588, 2437, 3, 'Arrastre para mover');
INSERT INTO `lang_definitions` VALUES (4589, 2439, 3, 'Goteo');
INSERT INTO `lang_definitions` VALUES (4590, 2440, 3, 'Permiso de conducir o D.N.I.');
INSERT INTO `lang_definitions` VALUES (4591, 2442, 3, 'Medicamento');
INSERT INTO `lang_definitions` VALUES (4592, 2445, 3, 'Buscador de medicamentos');
INSERT INTO `lang_definitions` VALUES (4593, 2446, 3, 'Formularios de Medicamento');
INSERT INTO `lang_definitions` VALUES (4594, 2447, 3, 'Nº Identificación medicamento falta!');
INSERT INTO `lang_definitions` VALUES (4595, 2448, 3, 'Intervalos de Medicamento');
INSERT INTO `lang_definitions` VALUES (4596, 2449, 3, 'Inventario de Medicamentos');
INSERT INTO `lang_definitions` VALUES (4597, 2450, 3, 'Nombre del Medicamento');
INSERT INTO `lang_definitions` VALUES (4598, 2451, 3, 'Vía de administración del Medicamento');
INSERT INTO `lang_definitions` VALUES (4599, 2455, 3, 'Unidades de Medicamento');
INSERT INTO `lang_definitions` VALUES (4600, 2460, 3, 'Medicamentos');
INSERT INTO `lang_definitions` VALUES (4601, 2461, 3, 'Medicamentos y productos');
INSERT INTO `lang_definitions` VALUES (4602, 2462, 3, 'Boca seca');
INSERT INTO `lang_definitions` VALUES (4603, 2463, 3, 'Diagnóstico DSMIV');
INSERT INTO `lang_definitions` VALUES (4604, 2464, 3, 'DT 1');
INSERT INTO `lang_definitions` VALUES (4605, 2465, 3, 'DT 2');
INSERT INTO `lang_definitions` VALUES (4606, 2466, 3, 'DT 3');
INSERT INTO `lang_definitions` VALUES (4607, 2467, 3, 'DT 4');
INSERT INTO `lang_definitions` VALUES (4608, 2468, 3, 'DT 5');
INSERT INTO `lang_definitions` VALUES (4609, 2469, 3, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (4610, 2470, 3, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (4611, 2471, 3, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (4612, 2472, 3, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (4613, 2473, 3, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (4614, 2474, 3, 'Adeudado');
INSERT INTO `lang_definitions` VALUES (4615, 2475, 3, 'Fecha del parto');
INSERT INTO `lang_definitions` VALUES (4616, 2476, 3, 'Fecha del parto mm/dd/aaaa o aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4617, 2477, 3, 'Fecha del parto:');
INSERT INTO `lang_definitions` VALUES (4618, 2478, 3, 'Deuda Seguro');
INSERT INTO `lang_definitions` VALUES (4619, 2479, 3, 'Deuda Paciente');
INSERT INTO `lang_definitions` VALUES (4620, 2480, 3, 'Deuda próxima');
INSERT INTO `lang_definitions` VALUES (4621, 2481, 3, 'Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4622, 2482, 3, 'Actualización Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4623, 2483, 3, 'Volcar OpenEMR base de datos');
INSERT INTO `lang_definitions` VALUES (4624, 2484, 3, 'Volcar OpenEMR web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4625, 2485, 3, 'Volcar phpGACL base de datos');
INSERT INTO `lang_definitions` VALUES (4626, 2486, 3, 'volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4627, 2487, 3, 'Volcar SQL-Ledger base de datos');
INSERT INTO `lang_definitions` VALUES (4628, 2488, 3, 'Volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4629, 2489, 3, 'Compruebe duplicado');
INSERT INTO `lang_definitions` VALUES (4630, 2493, 3, 'ID duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4631, 2494, 3, 'Nombre duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4632, 2495, 3, 'AVISO DE DUPLICACION');
INSERT INTO `lang_definitions` VALUES (4633, 2496, 3, 'Poder Legal Duradero');
INSERT INTO `lang_definitions` VALUES (4634, 2497, 3, 'Duración');
INSERT INTO `lang_definitions` VALUES (4635, 2498, 3, 'duración');
INSERT INTO `lang_definitions` VALUES (4636, 2499, 3, 'Holandés');
INSERT INTO `lang_definitions` VALUES (4637, 2500, 3, 'Dx Rep');
INSERT INTO `lang_definitions` VALUES (4638, 2501, 3, 'Disfagia');
INSERT INTO `lang_definitions` VALUES (4639, 2502, 3, 'Disnea');
INSERT INTO `lang_definitions` VALUES (4640, 2503, 3, 'Disuria');
INSERT INTO `lang_definitions` VALUES (4641, 2511, 3, '¿E-Receta?');
INSERT INTO `lang_definitions` VALUES (4642, 2513, 3, 'Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4643, 2515, 3, 'Renovación Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4644, 2518, 3, 'Cada destinatario debe establecer sus propios mensajes como terminados.');
INSERT INTO `lang_definitions` VALUES (4645, 2519, 3, 'Repetición Temprana (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (4646, 2520, 3, 'Orejas');
INSERT INTO `lang_definitions` VALUES (4647, 2521, 3, 'Electrocardiograma');
INSERT INTO `lang_definitions` VALUES (4648, 2522, 3, 'Reclamaciones electrónicas');
INSERT INTO `lang_definitions` VALUES (4649, 2525, 3, 'Edema');
INSERT INTO `lang_definitions` VALUES (4650, 2530, 3, 'Adjuntar fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4651, 2531, 3, 'Respuesta de carga de fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4652, 2532, 3, 'Editar');
INSERT INTO `lang_definitions` VALUES (4653, 2533, 3, 'editar');
INSERT INTO `lang_definitions` VALUES (4654, 2534, 3, 'Editar alergias');
INSERT INTO `lang_definitions` VALUES (4655, 2536, 3, 'Editar categorías');
INSERT INTO `lang_definitions` VALUES (4656, 2538, 3, 'Editar Definiciones');
INSERT INTO `lang_definitions` VALUES (4657, 2539, 3, 'Editar definiciones');
INSERT INTO `lang_definitions` VALUES (4658, 2540, 3, 'Editar diagnóstico para');
INSERT INTO `lang_definitions` VALUES (4659, 2541, 3, 'editar publicación');
INSERT INTO `lang_definitions` VALUES (4660, 2544, 3, 'Editar Clínicas');
INSERT INTO `lang_definitions` VALUES (4661, 2545, 3, 'Editar Centro');
INSERT INTO `lang_definitions` VALUES (4662, 2546, 3, 'Editar información del Centro');
INSERT INTO `lang_definitions` VALUES (4663, 2547, 3, 'Editar información de instalación de usuario específico');
INSERT INTO `lang_definitions` VALUES (4664, 2548, 3, 'editar fichero en');
INSERT INTO `lang_definitions` VALUES (4665, 2549, 3, 'Editar forma');
INSERT INTO `lang_definitions` VALUES (4666, 2550, 3, 'Editar configuración global');
INSERT INTO `lang_definitions` VALUES (4667, 2551, 3, 'Edición no permitida');
INSERT INTO `lang_definitions` VALUES (4668, 2552, 3, 'Editar el diseño');
INSERT INTO `lang_definitions` VALUES (4669, 2554, 3, 'Editar la lista');
INSERT INTO `lang_definitions` VALUES (4670, 2556, 3, 'Editar Pago');
INSERT INTO `lang_definitions` VALUES (4671, 2557, 3, 'Editar estructura');
INSERT INTO `lang_definitions` VALUES (4672, 2560, 3, 'Editar usuario');
INSERT INTO `lang_definitions` VALUES (4673, 2561, 3, 'Editar configuración de usuario');
INSERT INTO `lang_definitions` VALUES (4674, 2562, 3, 'Editar su información');
INSERT INTO `lang_definitions` VALUES (4675, 2563, 3, 'La edición falló');
INSERT INTO `lang_definitions` VALUES (4676, 2564, 3, 'Educación');
INSERT INTO `lang_definitions` VALUES (4677, 2565, 3, 'Fecha educación');
INSERT INTO `lang_definitions` VALUES (4678, 2567, 3, 'Debería haber recibido una copia del GNU con este programa, si no, escriba al Free');
INSERT INTO `lang_definitions` VALUES (4679, 2568, 3, 'Fecha efectiva');
INSERT INTO `lang_definitions` VALUES (4680, 2570, 3, 'Efectividad');
INSERT INTO `lang_definitions` VALUES (4681, 2572, 3, 'EIN');
INSERT INTO `lang_definitions` VALUES (4682, 2574, 3, 'Eyaculaciones');
INSERT INTO `lang_definitions` VALUES (4683, 2575, 3, 'Codo');
INSERT INTO `lang_definitions` VALUES (4684, 2576, 3, 'Problemas del codo');
INSERT INTO `lang_definitions` VALUES (4685, 2577, 3, 'Electrónico');
INSERT INTO `lang_definitions` VALUES (4686, 2580, 3, 'Mandatos Electronicos');
INSERT INTO `lang_definitions` VALUES (4687, 2583, 3, 'Elegibilidad');
INSERT INTO `lang_definitions` VALUES (4688, 2584, 3, 'Elegibilidad Batch Consulta 270');
INSERT INTO `lang_definitions` VALUES (4689, 2585, 3, 'Elegibilidad de Respuesta');
INSERT INTO `lang_definitions` VALUES (4690, 2586, 3, 'Estado de elegibilidad para la vacuna suministrada para niños');
INSERT INTO `lang_definitions` VALUES (4691, 2587, 3, 'Elegible');
INSERT INTO `lang_definitions` VALUES (4692, 2589, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4693, 2592, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4694, 2594, 3, 'email del remitente para los recordatorios de pacientes. Las respuestas de los pacientes irán a esa dirección. Es importante usar una dirección del dominio de la Clínica para evitar que las respuestas de recordatorios de los pacientes vayan a la carpeta de correo basura.');
INSERT INTO `lang_definitions` VALUES (4695, 2595, 3, 'email, si hay, para recibir notificaciones administrativas.');
INSERT INTO `lang_definitions` VALUES (4696, 2596, 3, 'email, si hay, para recibir mensajes de activación de inicio sesión de usuario.');
INSERT INTO `lang_definitions` VALUES (4697, 2597, 3, 'Autenticación email');
INSERT INTO `lang_definitions` VALUES (4698, 2600, 3, 'email de Batchcom');
INSERT INTO `lang_definitions` VALUES (4699, 2601, 3, 'Notificación email');
INSERT INTO `lang_definitions` VALUES (4700, 2602, 3, 'Horario Notificación Email');
INSERT INTO `lang_definitions` VALUES (4701, 2603, 3, 'Informe de notificación de email');
INSERT INTO `lang_definitions` VALUES (4702, 2606, 3, 'email enviado antes');
INSERT INTO `lang_definitions` VALUES (4703, 2607, 3, 'Remitente de email');
INSERT INTO `lang_definitions` VALUES (4704, 2608, 3, 'Email enviado');
INSERT INTO `lang_definitions` VALUES (4705, 2609, 3, 'email enviado a');
INSERT INTO `lang_definitions` VALUES (4706, 2610, 3, 'Asunto del email');
INSERT INTO `lang_definitions` VALUES (4707, 2612, 3, 'Texto del email, etiqueta útil: ***NAME***, Ej. Estimado ***NAME***');
INSERT INTO `lang_definitions` VALUES (4708, 2613, 3, 'Texto email, etiqueta útil:***NAME***, por ej. Querido ***NAME***{{No traducir el elemento ***NAME*** de esta constante}}');
INSERT INTO `lang_definitions` VALUES (4709, 2614, 3, 'Método de envío de email');
INSERT INTO `lang_definitions` VALUES (4710, 2615, 3, 'Email enviado a las siguientes direcciones');
INSERT INTO `lang_definitions` VALUES (4711, 2619, 3, 'Contacto en caso de emergencia');
INSERT INTO `lang_definitions` VALUES (4712, 2620, 3, 'Persona de Contacto de Emergencia');
INSERT INTO `lang_definitions` VALUES (4713, 2621, 3, 'Teléfono de Contacto de Emergencias');
INSERT INTO `lang_definitions` VALUES (4714, 2622, 3, 'Emergencia anticonceptiva');
INSERT INTO `lang_definitions` VALUES (4715, 2623, 3, 'Acceso de Emergencia');
INSERT INTO `lang_definitions` VALUES (4716, 2624, 3, 'Inicio sesión de Emergencia ACL elegido. El usuario esta aún activo, favor desactivar usuario y activarlo cuando la situación de emergencia lo requiera. Visitar Administración>Usuario para activación o deactivación');
INSERT INTO `lang_definitions` VALUES (4717, 2625, 3, 'El email de activación de inicio de sesión de emergencia ha de circular sólo si los siguientes ajustes del fichero interfase/globals.php están configurados:');
INSERT INTO `lang_definitions` VALUES (4718, 2626, 3, 'email de inicio de sesión de emergencia');
INSERT INTO `lang_definitions` VALUES (4719, 2627, 3, 'El usuario de Inicio de sesión de emergencia puede hacer cualquier cosa');
INSERT INTO `lang_definitions` VALUES (4720, 2628, 3, 'Teléfono de emergencia');
INSERT INTO `lang_definitions` VALUES (4721, 2631, 3, 'Enfisema');
INSERT INTO `lang_definitions` VALUES (4722, 2632, 3, 'Empleado');
INSERT INTO `lang_definitions` VALUES (4723, 2633, 3, 'Empresa');
INSERT INTO `lang_definitions` VALUES (4724, 2634, 3, 'Dirección del empleador');
INSERT INTO `lang_definitions` VALUES (4725, 2635, 3, 'Datos de la empresa');
INSERT INTO `lang_definitions` VALUES (4726, 2636, 3, 'Nombre de Empresa');
INSERT INTO `lang_definitions` VALUES (4727, 2637, 3, 'VACIO');
INSERT INTO `lang_definitions` VALUES (4728, 2638, 3, 'Vacio');
INSERT INTO `lang_definitions` VALUES (4729, 2641, 3, 'Valor vacío en -Horas de eEmail-');
INSERT INTO `lang_definitions` VALUES (4730, 2642, 3, 'Valor vacío en -Remitente de email-');
INSERT INTO `lang_definitions` VALUES (4731, 2643, 3, 'Valor vacío en-Tema de email-');
INSERT INTO `lang_definitions` VALUES (4732, 2644, 3, 'Valor vacío en-Texto de email-');
INSERT INTO `lang_definitions` VALUES (4733, 2645, 3, 'Valor vacío en -Nombre del Facultativo-');
INSERT INTO `lang_definitions` VALUES (4734, 2646, 3, 'Valor vacío en -Contraseña-');
INSERT INTO `lang_definitions` VALUES (4735, 2647, 3, 'Valor vacío en -Horas de SMS-');
INSERT INTO `lang_definitions` VALUES (4736, 2648, 3, 'Vaciar en el valor -Texto SMS-');
INSERT INTO `lang_definitions` VALUES (4737, 2649, 3, 'Vaciar en el valor -Usuario-');
INSERT INTO `lang_definitions` VALUES (4738, 2656, 3, 'Activar aviso MCA');
INSERT INTO `lang_definitions` VALUES (4739, 2658, 3, 'Activar Informe MCA');
INSERT INTO `lang_definitions` VALUES (4740, 2659, 3, 'Activar seguimiento MCA');
INSERT INTO `lang_definitions` VALUES (4741, 2661, 3, 'Activar auditoría RANA');
INSERT INTO `lang_definitions` VALUES (4742, 2663, 3, 'Inicio de sesión Auditoría habilitado');
INSERT INTO `lang_definitions` VALUES (4743, 2664, 3, 'Activar Auditoría Registro y Autenticación del Nodo (ATNA)');
INSERT INTO `lang_definitions` VALUES (4744, 2665, 3, 'Activar Informe Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4745, 2668, 3, 'Activar Cliente SSL');
INSERT INTO `lang_definitions` VALUES (4746, 2669, 3, 'Activar Cliente SSL con certificado de autenticación.');
INSERT INTO `lang_definitions` VALUES (4747, 2671, 3, 'Activar Reglas Clínicas de Decisión (CDR)');
INSERT INTO `lang_definitions` VALUES (4748, 2674, 3, 'Activar informe medidas de calidad clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4749, 2675, 3, 'Activar popup recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4750, 2676, 3, 'Activar Widget Recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4751, 2679, 3, 'Activar Informes GCC');
INSERT INTO `lang_definitions` VALUES (4752, 2684, 3, 'Habilitar tarifas en el menú de la izquierda');
INSERT INTO `lang_definitions` VALUES (4753, 2688, 3, 'Activar Soporte Hylafax');
INSERT INTO `lang_definitions` VALUES (4754, 2690, 3, 'Activar el estado de importación de mensajes para Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4755, 2694, 3, 'Activar intercambio Laboratorio');
INSERT INTO `lang_definitions` VALUES (4756, 2696, 3, 'Habilitar registro para documentos subidos/bajados de CouchDB');
INSERT INTO `lang_definitions` VALUES (4757, 2697, 3, 'Activar registro de todas las consultas SQL SELECT.');
INSERT INTO `lang_definitions` VALUES (4758, 2698, 3, 'Activar registro de backup de actividades relacionadas.');
INSERT INTO `lang_definitions` VALUES (4759, 2700, 3, 'Activar inicio sesión de actividades varias.');
INSERT INTO `lang_definitions` VALUES (4760, 2701, 3, 'Activar registro de actividades solicitadas.');
INSERT INTO `lang_definitions` VALUES (4761, 2702, 3, 'Activar registro de modificaciones del registro de pacientes.');
INSERT INTO `lang_definitions` VALUES (4762, 2703, 3, 'Activar registro de programar actividades.');
INSERT INTO `lang_definitions` VALUES (4763, 2704, 3, 'Activar registro de seguridad y administración de actividades.');
INSERT INTO `lang_definitions` VALUES (4764, 2707, 3, 'Activar servicio Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4765, 2709, 3, 'Activar Portal Paciente Externo');
INSERT INTO `lang_definitions` VALUES (4766, 2710, 3, 'Activar Portal paciente desde el exterior.');
INSERT INTO `lang_definitions` VALUES (4767, 2711, 3, 'Activar Portal paciente in-situ');
INSERT INTO `lang_definitions` VALUES (4768, 2713, 3, 'Activar Portal paciente in-situ.');
INSERT INTO `lang_definitions` VALUES (4769, 2714, 3, 'Activar widget recordatorios del paciente');
INSERT INTO `lang_definitions` VALUES (4770, 2717, 3, 'Activar aviso fecha requerida para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4771, 2719, 3, 'Activar Informe de Seguimiento de Fecha para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4772, 2720, 3, 'Activar Soporte escaner');
INSERT INTO `lang_definitions` VALUES (4773, 2724, 3, 'Activar servicio de soporte OpenEMR LLC Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (4774, 2725, 3, 'Activar Certificado de Autenticación del usuario.');
INSERT INTO `lang_definitions` VALUES (4775, 2730, 3, 'Activar servicio ZMG, Receta electrónica LLC');
INSERT INTO `lang_definitions` VALUES (4776, 2731, 3, 'Activado');
INSERT INTO `lang_definitions` VALUES (4777, 2735, 3, 'Activar el viejo panel de cargos para introducir códigos de facturas y pagos. No se recomienda usar la hoja de honorarios en su lugar.');
INSERT INTO `lang_definitions` VALUES (4778, 2737, 3, 'Encuentro');
INSERT INTO `lang_definitions` VALUES (4779, 2738, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4780, 2739, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4781, 2740, 3, 'visita');
INSERT INTO `lang_definitions` VALUES (4782, 2741, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4783, 2742, 3, 'Visita a un hospitalizado agudo o ED');
INSERT INTO `lang_definitions` VALUES (4784, 2748, 3, 'Fecha visita');
INSERT INTO `lang_definitions` VALUES (4785, 2753, 3, 'Formularios visita');
INSERT INTO `lang_definitions` VALUES (4786, 2754, 3, 'visita de salud y evaluación de comportamiento');
INSERT INTO `lang_definitions` VALUES (4787, 2755, 3, 'Histórico de visitas');
INSERT INTO `lang_definitions` VALUES (4788, 2756, 3, 'ID Visita');
INSERT INTO `lang_definitions` VALUES (4789, 2757, 3, 'Visita gripe');
INSERT INTO `lang_definitions` VALUES (4790, 2759, 3, 'número visita');
INSERT INTO `lang_definitions` VALUES (4791, 2761, 3, 'visita cuidado enfermería');
INSERT INTO `lang_definitions` VALUES (4792, 2762, 3, 'visita centro enfermería');
INSERT INTO `lang_definitions` VALUES (4793, 2763, 3, 'visita terapia ocupacional');
INSERT INTO `lang_definitions` VALUES (4794, 2764, 3, 'visita a consultorio');
INSERT INTO `lang_definitions` VALUES (4795, 2765, 3, 'visita paciente externo');
INSERT INTO `lang_definitions` VALUES (4796, 2766, 3, 'visita paciente externo w/PCP y obgyn');
INSERT INTO `lang_definitions` VALUES (4797, 2767, 3, 'Tamaño página visita');
INSERT INTO `lang_definitions` VALUES (4798, 2768, 3, 'Pago visita');
INSERT INTO `lang_definitions` VALUES (4799, 2769, 3, 'visita embarazo');
INSERT INTO `lang_definitions` VALUES (4800, 2770, 3, 'visita medicina preventiva - asesoramiento individual');
INSERT INTO `lang_definitions` VALUES (4801, 2771, 3, 'visita medicina preventiva para mayores de 40');
INSERT INTO `lang_definitions` VALUES (4802, 2772, 3, 'visita de medicina preventiva - asesoramiento en grupo');
INSERT INTO `lang_definitions` VALUES (4803, 2773, 3, 'visita medicina preventiva otros servicios');
INSERT INTO `lang_definitions` VALUES (4804, 2774, 3, 'visita servicios medicina preventiva mayores de 18');
INSERT INTO `lang_definitions` VALUES (4805, 2776, 3, 'visita psiquiatrica y psicológica');
INSERT INTO `lang_definitions` VALUES (4806, 2777, 3, 'Estadísticas de visitas');
INSERT INTO `lang_definitions` VALUES (4807, 2778, 3, 'Resumen de visitas');
INSERT INTO `lang_definitions` VALUES (4808, 2780, 3, 'Visita codificada');
INSERT INTO `lang_definitions` VALUES (4809, 2781, 3, 'Visita:');
INSERT INTO `lang_definitions` VALUES (4810, 2782, 3, 'Visita: visita ingreso no agudo, paciente externo, o oftalmológico');
INSERT INTO `lang_definitions` VALUES (4811, 2783, 3, 'Visitas');
INSERT INTO `lang_definitions` VALUES (4812, 2784, 3, 'Visitas y Formularios');
INSERT INTO `lang_definitions` VALUES (4813, 2785, 3, 'Visitas y Formularios');
INSERT INTO `lang_definitions` VALUES (4814, 2786, 3, 'Visitas no autorizadas');
INSERT INTO `lang_definitions` VALUES (4815, 2787, 3, 'Informe de visitas');
INSERT INTO `lang_definitions` VALUES (4816, 2788, 3, 'Sección visitas');
INSERT INTO `lang_definitions` VALUES (4817, 2790, 3, 'Encriptación');
INSERT INTO `lang_definitions` VALUES (4818, 2791, 3, 'Final');
INSERT INTO `lang_definitions` VALUES (4819, 2792, 3, 'Final (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (4820, 2793, 3, 'Fecha final');
INSERT INTO `lang_definitions` VALUES (4821, 2794, 3, 'Fecha final');
INSERT INTO `lang_definitions` VALUES (4822, 2798, 3, 'Fecha final debe ser posterior a fecha inicio');
INSERT INTO `lang_definitions` VALUES (4823, 2800, 3, 'Fecha Final:');
INSERT INTO `lang_definitions` VALUES (4824, 2804, 3, 'Hora finalización');
INSERT INTO `lang_definitions` VALUES (4825, 2805, 3, 'Enfermedad renal en Etapa Final - Beneficiario de MCP con un Plan de grupo del empleador');
INSERT INTO `lang_definitions` VALUES (4826, 2808, 3, 'Fecha final de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4827, 2809, 3, 'Termina DOS dd/mm/aaaa si desea entrar en una serie');
INSERT INTO `lang_definitions` VALUES (4828, 2810, 3, 'Hora final del día para eventos de calendario');
INSERT INTO `lang_definitions` VALUES (4829, 2811, 3, 'Sangre anormal Endo');
INSERT INTO `lang_definitions` VALUES (4830, 2812, 3, 'Endocrino');
INSERT INTO `lang_definitions` VALUES (4831, 2813, 3, 'Endoscopía');
INSERT INTO `lang_definitions` VALUES (4832, 2817, 3, 'Inglés');
INSERT INTO `lang_definitions` VALUES (4833, 2818, 3, 'Inglés');
INSERT INTO `lang_definitions` VALUES (4834, 2819, 3, 'Ingleses (Indios)');
INSERT INTO `lang_definitions` VALUES (4835, 2820, 3, 'Inglés (Estándar)');
INSERT INTO `lang_definitions` VALUES (4836, 2821, 3, 'Enscript comando usado por Hylafax.');
INSERT INTO `lang_definitions` VALUES (4837, 2822, 3, 'Garantizar OpenEMR tiene privilegios al directorio');
INSERT INTO `lang_definitions` VALUES (4838, 2823, 3, 'ENT Descarga');
INSERT INTO `lang_definitions` VALUES (4839, 2824, 3, 'ENT Dolor');
INSERT INTO `lang_definitions` VALUES (4840, 2825, 3, 'Introduzca un código de la diagnosis para excluir todas las facturas que no lo contienen');
INSERT INTO `lang_definitions` VALUES (4841, 2827, 3, 'Incorpore el cuerpo de la carta aquí');
INSERT INTO `lang_definitions` VALUES (4842, 2829, 3, 'Introduzca Contraseña root para Base Datos');
INSERT INTO `lang_definitions` VALUES (4843, 2830, 3, 'Introduzca Usuario root para Base Datos');
INSERT INTO `lang_definitions` VALUES (4844, 2832, 3, 'Introduzca Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4845, 2833, 3, 'Introduzca Medicamentos');
INSERT INTO `lang_definitions` VALUES (4846, 2838, 3, 'Introduzca Vacunas');
INSERT INTO `lang_definitions` VALUES (4847, 2839, 3, 'Introducir Clave');
INSERT INTO `lang_definitions` VALUES (4848, 2843, 3, 'Escriba el nuevo Estado');
INSERT INTO `lang_definitions` VALUES (4849, 2847, 3, 'Introducir código Re-identificación');
INSERT INTO `lang_definitions` VALUES (4850, 2850, 3, 'Incorpore sus criterios de búsqueda arriba');
INSERT INTO `lang_definitions` VALUES (4851, 2853, 3, 'entradas');
INSERT INTO `lang_definitions` VALUES (4852, 2858, 3, 'Ambiental');
INSERT INTO `lang_definitions` VALUES (4853, 2859, 3, 'Entrada de datos de EOB');
INSERT INTO `lang_definitions` VALUES (4854, 2862, 3, 'EOB envío - Remesas electrónicas');
INSERT INTO `lang_definitions` VALUES (4855, 2863, 3, 'EOB envío - Instrucciones');
INSERT INTO `lang_definitions` VALUES (4856, 2864, 3, 'EOB envío - Factura');
INSERT INTO `lang_definitions` VALUES (4857, 2865, 3, 'EOB envío - Nota del Paciente');
INSERT INTO `lang_definitions` VALUES (4858, 2866, 3, 'EOB envío - Buscar');
INSERT INTO `lang_definitions` VALUES (4859, 2868, 3, 'Epilepsia');
INSERT INTO `lang_definitions` VALUES (4860, 2874, 3, 'ERA (Remesa Electrónica de Aviso)');
INSERT INTO `lang_definitions` VALUES (4861, 2876, 3, 'Envío ERA (Remesa Electrónica de Aviso)');
INSERT INTO `lang_definitions` VALUES (4862, 2877, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4863, 2879, 3, 'Erecciones');
INSERT INTO `lang_definitions` VALUES (4864, 2880, 3, 'Error');
INSERT INTO `lang_definitions` VALUES (4865, 2882, 3, 'Error confirmando la recepción de los resultados del laboratorio');
INSERT INTO `lang_definitions` VALUES (4866, 2884, 3, 'Error al obtener los resultados de laboratorio de la red de intercambio del laboratorio');
INSERT INTO `lang_definitions` VALUES (4867, 2885, 3, 'Error en selección de género');
INSERT INTO `lang_definitions` VALUES (4868, 2886, 3, 'Error en -HIPAA- selección');
INSERT INTO `lang_definitions` VALUES (4869, 2887, 3, 'Error en el -Proceso de selección');
INSERT INTO `lang_definitions` VALUES (4870, 2888, 3, 'El error en la selección de -Puerta enlace SMS-');
INSERT INTO `lang_definitions` VALUES (4871, 2889, 3, 'Error en -Ordenar por- selección');
INSERT INTO `lang_definitions` VALUES (4872, 2890, 3, 'Error del file de compresion gzip');
INSERT INTO `lang_definitions` VALUES (4873, 2891, 3, 'Error en la opción SI o NO');
INSERT INTO `lang_definitions` VALUES (4874, 2893, 3, 'Error al abrir fichero adjunto para lectura');
INSERT INTO `lang_definitions` VALUES (4875, 2896, 3, 'Error al eliminar el mensaje');
INSERT INTO `lang_definitions` VALUES (4876, 2897, 3, 'Error recuperando resultados de la red de intercambio del laboratorio');
INSERT INTO `lang_definitions` VALUES (4877, 2900, 3, 'Error en el fichero de concesión de privilegios para el usuario de OpenEMR.');
INSERT INTO `lang_definitions` VALUES (4878, 2903, 3, 'error al registrar la forma!');
INSERT INTO `lang_definitions` VALUES (4879, 2904, 3, 'Error al guardar el fichero');
INSERT INTO `lang_definitions` VALUES (4880, 2906, 3, 'Error al escribir en el fichero');
INSERT INTO `lang_definitions` VALUES (4881, 2909, 3, 'Error, Este file no existe');
INSERT INTO `lang_definitions` VALUES (4882, 2910, 3, 'ERROR, incapaz de recoger los datos de servidor');
INSERT INTO `lang_definitions` VALUES (4883, 2911, 3, 'Error, incapaz de crear certificado de cliente');
INSERT INTO `lang_definitions` VALUES (4884, 2912, 3, 'Error, incapaz de crear el certificado p12 de Admin');
INSERT INTO `lang_definitions` VALUES (4885, 2913, 3, 'Error. No puede crearse certificadodo de Certificado de Autenticación');
INSERT INTO `lang_definitions` VALUES (4886, 2914, 3, 'Error, incapaz de crear el certificado del servidor');
INSERT INTO `lang_definitions` VALUES (4887, 2915, 3, 'Error, incapaz de abrir el file');
INSERT INTO `lang_definitions` VALUES (4888, 2916, 3, 'Error. Certificado de Autenticación de usuario no está activado en OpenEMR');
INSERT INTO `lang_definitions` VALUES (4889, 2918, 3, 'Error. Necesita instalar el fichero/Tar.php módulo php');
INSERT INTO `lang_definitions` VALUES (4890, 2919, 3, 'ERROR: no pudo abrir tabla sql, formulario roto?');
INSERT INTO `lang_definitions` VALUES (4891, 2922, 3, 'Error: ID duplicado en línea');
INSERT INTO `lang_definitions` VALUES (4892, 2923, 3, 'Error: Nombre duplicado en línea');
INSERT INTO `lang_definitions` VALUES (4893, 2924, 3, 'ERROR: Campo');
INSERT INTO `lang_definitions` VALUES (4894, 2925, 3, 'ERROR: Falta el fichero comprimido del Módulo PHP');
INSERT INTO `lang_definitions` VALUES (4895, 2926, 3, 'ERROR: Sin directorio de importación ICD');
INSERT INTO `lang_definitions` VALUES (4896, 2927, 3, 'Error: las contraseñas no coinciden. Por favor, compruebe lo tecleado.');
INSERT INTO `lang_definitions` VALUES (4897, 2928, 3, 'Error: las contraseñas no coinciden. Por favor, compruebe lo tecleado.');
INSERT INTO `lang_definitions` VALUES (4898, 2929, 3, 'Error, este file no existe');
INSERT INTO `lang_definitions` VALUES (4899, 2930, 3, 'ERROR: La siguiente variable contiene caracteres inválidos');
INSERT INTO `lang_definitions` VALUES (4900, 2931, 3, 'ERROR: No se puede copiar el fichero.');
INSERT INTO `lang_definitions` VALUES (4901, 2932, 3, 'Error, incapaz de crear el fichero de descarga');
INSERT INTO `lang_definitions` VALUES (4902, 2933, 3, 'ERROR: No se puede crear el fichero comprimido.');
INSERT INTO `lang_definitions` VALUES (4903, 2934, 3, 'ERROR: No se puede extraer el fichero.');
INSERT INTO `lang_definitions` VALUES (4904, 2935, 3, 'ERROR: No se puede leer el fichero en la base de datos.');
INSERT INTO `lang_definitions` VALUES (4905, 2936, 3, 'ERROR: No se puede establecer el número de versión.');
INSERT INTO `lang_definitions` VALUES (4906, 2937, 3, 'Errores');
INSERT INTO `lang_definitions` VALUES (4907, 2938, 3, 'Estado cuenta Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4908, 2939, 3, 'Registros Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4909, 2940, 3, 'Nombre Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4910, 2941, 3, 'Contraseña Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4911, 2942, 3, 'Rol Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4912, 2943, 3, 'Usuario Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4913, 2944, 3, 'Eritema');
INSERT INTO `lang_definitions` VALUES (4914, 2947, 3, 'Esquimal');
INSERT INTO `lang_definitions` VALUES (4915, 2951, 3, 'Paciente regular');
INSERT INTO `lang_definitions` VALUES (4916, 2953, 3, 'Raza');
INSERT INTO `lang_definitions` VALUES (4917, 2954, 3, 'La etnia o la raza');
INSERT INTO `lang_definitions` VALUES (4918, 2955, 3, 'Lista de Origen étnico--Raza (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4919, 2958, 3, 'ETIN');
INSERT INTO `lang_definitions` VALUES (4920, 2961, 3, 'Evento');
INSERT INTO `lang_definitions` VALUES (4921, 2962, 3, 'Fecha comienzo de evento');
INSERT INTO `lang_definitions` VALUES (4922, 2963, 3, 'Categoría de evento');
INSERT INTO `lang_definitions` VALUES (4923, 2964, 3, 'Fecha evento');
INSERT INTO `lang_definitions` VALUES (4924, 2966, 3, 'Descripción evento');
INSERT INTO `lang_definitions` VALUES (4925, 2967, 3, 'Detalles evento');
INSERT INTO `lang_definitions` VALUES (4926, 2968, 3, 'Evento no se repite');
INSERT INTO `lang_definitions` VALUES (4927, 2969, 3, 'Duración de Evento');
INSERT INTO `lang_definitions` VALUES (4928, 2970, 3, 'Duración de evento en minutos');
INSERT INTO `lang_definitions` VALUES (4929, 2971, 3, 'Honorarios del evento');
INSERT INTO `lang_definitions` VALUES (4930, 2972, 3, 'Lugar de evento');
INSERT INTO `lang_definitions` VALUES (4931, 2973, 3, 'Evento repite cada');
INSERT INTO `lang_definitions` VALUES (4932, 2974, 3, 'Evento repite en');
INSERT INTO `lang_definitions` VALUES (4933, 2975, 3, 'Hora comienzo evento');
INSERT INTO `lang_definitions` VALUES (4934, 2976, 3, 'Título de evento');
INSERT INTO `lang_definitions` VALUES (4935, 2977, 3, 'Título de Evento');
INSERT INTO `lang_definitions` VALUES (4936, 2978, 3, 'Página web de evento');
INSERT INTO `lang_definitions` VALUES (4937, 2979, 3, 'Eventos');
INSERT INTO `lang_definitions` VALUES (4938, 2980, 3, 'Eventos para');
INSERT INTO `lang_definitions` VALUES (4939, 2981, 3, 'Eventos abre en nueva ventana');
INSERT INTO `lang_definitions` VALUES (4940, 2983, 3, 'cada');
INSERT INTO `lang_definitions` VALUES (4941, 2984, 3, 'Cada');
INSERT INTO `lang_definitions` VALUES (4942, 2986, 3, 'cada 3 horas');
INSERT INTO `lang_definitions` VALUES (4943, 2988, 3, 'cada 4 horas');
INSERT INTO `lang_definitions` VALUES (4944, 2990, 3, 'cada 5 horas');
INSERT INTO `lang_definitions` VALUES (4945, 2992, 3, 'cada 6 horas');
INSERT INTO `lang_definitions` VALUES (4946, 2994, 3, 'cada 8 horas');
INSERT INTO `lang_definitions` VALUES (4947, 2995, 3, 'cada cuarto');
INSERT INTO `lang_definitions` VALUES (4948, 2997, 3, 'uno sí, otro no');
INSERT INTO `lang_definitions` VALUES (4949, 2998, 3, 'cada tercero');
INSERT INTO `lang_definitions` VALUES (4950, 2999, 3, 'Cada, cada otro, cada 3ro, etc.');
INSERT INTO `lang_definitions` VALUES (4951, 3001, 3, 'Examen y los resultados de las pruebas');
INSERT INTO `lang_definitions` VALUES (4952, 3002, 3, 'Resultados del examen');
INSERT INTO `lang_definitions` VALUES (4953, 3005, 3, 'Examen');
INSERT INTO `lang_definitions` VALUES (4954, 3006, 3, 'Fecha de examen');
INSERT INTO `lang_definitions` VALUES (4955, 3007, 3, 'Ejemplo');
INSERT INTO `lang_definitions` VALUES (4956, 3009, 3, 'Ejemplos');
INSERT INTO `lang_definitions` VALUES (4957, 3010, 3, 'Exámenes/Pruebas');
INSERT INTO `lang_definitions` VALUES (4958, 3012, 3, 'Excepto');
INSERT INTO `lang_definitions` VALUES (4959, 3013, 3, 'Lagrimeo Excesivo');
INSERT INTO `lang_definitions` VALUES (4960, 3015, 3, 'Pacientes Excluídos');
INSERT INTO `lang_definitions` VALUES (4961, 3016, 3, 'Exclusiones');
INSERT INTO `lang_definitions` VALUES (4962, 3017, 3, 'Organización de provedor exclusivo (OPE)');
INSERT INTO `lang_definitions` VALUES (4963, 3018, 3, 'Tamaño papel ejecutivo');
INSERT INTO `lang_definitions` VALUES (4964, 3019, 3, 'Ejercicio');
INSERT INTO `lang_definitions` VALUES (4965, 3020, 3, 'Patrones de ejercicio');
INSERT INTO `lang_definitions` VALUES (4966, 3021, 3, 'Patrones del ejercicio');
INSERT INTO `lang_definitions` VALUES (4967, 3022, 3, 'Existe');
INSERT INTO `lang_definitions` VALUES (4968, 3024, 3, 'Salir de Administración');
INSERT INTO `lang_definitions` VALUES (4969, 3028, 3, 'Exp');
INSERT INTO `lang_definitions` VALUES (4970, 3030, 3, 'Expandir');
INSERT INTO `lang_definitions` VALUES (4971, 3031, 3, 'Expandir');
INSERT INTO `lang_definitions` VALUES (4972, 3032, 3, 'Expandir Todo');
INSERT INTO `lang_definitions` VALUES (4973, 3035, 3, 'Vista ampliada');
INSERT INTO `lang_definitions` VALUES (4974, 3036, 3, 'Se espera form_encounter.pid para ser');
INSERT INTO `lang_definitions` VALUES (4975, 3037, 3, 'Caducidad');
INSERT INTO `lang_definitions` VALUES (4976, 3038, 3, 'Fecha de caducidad');
INSERT INTO `lang_definitions` VALUES (4977, 3039, 3, 'Caducidad');
INSERT INTO `lang_definitions` VALUES (4978, 3040, 3, 'Expira en');
INSERT INTO `lang_definitions` VALUES (4979, 3041, 3, 'Exportar');
INSERT INTO `lang_definitions` VALUES (4980, 3042, 3, 'Exportar con CSV');
INSERT INTO `lang_definitions` VALUES (4981, 3044, 3, 'Exportar configuración');
INSERT INTO `lang_definitions` VALUES (4982, 3048, 3, 'Exportación de Demograficos del paciente');
INSERT INTO `lang_definitions` VALUES (4983, 3050, 3, 'Exportar Informe PQRI');
INSERT INTO `lang_definitions` VALUES (4984, 3052, 3, 'Selección de exportación como CSV');
INSERT INTO `lang_definitions` VALUES (4985, 3053, 3, 'Selección de las colecciones a la exportación');
INSERT INTO `lang_definitions` VALUES (4986, 3054, 3, 'Exportar a CSV');
INSERT INTO `lang_definitions` VALUES (4987, 3055, 3, 'Exportación al sistema de facturación externo');
INSERT INTO `lang_definitions` VALUES (4988, 3056, 3, 'Exposición a los países extranjeros');
INSERT INTO `lang_definitions` VALUES (4989, 3057, 3, 'Exposición a Países Extranjeros');
INSERT INTO `lang_definitions` VALUES (4990, 3058, 3, 'Ext tiempo de coleccionar');
INSERT INTO `lang_definitions` VALUES (4991, 3060, 3, 'Externo');
INSERT INTO `lang_definitions` VALUES (4992, 3062, 3, 'Carga de datos externos');
INSERT INTO `lang_definitions` VALUES (4993, 3063, 3, 'Utilidad de importación bbdd externa');
INSERT INTO `lang_definitions` VALUES (4994, 3066, 3, 'D.N.I.');
INSERT INTO `lang_definitions` VALUES (4995, 3067, 3, 'ID externo');
INSERT INTO `lang_definitions` VALUES (4996, 3068, 3, 'identificación externos');
INSERT INTO `lang_definitions` VALUES (4997, 3069, 3, 'Identificador externo');
INSERT INTO `lang_definitions` VALUES (4998, 3072, 3, 'Derivación externa');
INSERT INTO `lang_definitions` VALUES (4999, 3073, 3, 'Seguimiento de Derivaciones Externas');
INSERT INTO `lang_definitions` VALUES (5000, 3074, 3, '¿Derivación externa?');
INSERT INTO `lang_definitions` VALUES (5001, 3075, 3, 'Derivaciones externas');
INSERT INTO `lang_definitions` VALUES (5002, 3076, 3, 'Extraer este file comprimido');
INSERT INTO `lang_definitions` VALUES (5003, 3077, 3, 'Extrayendo fichero. Esto puede tardar algún tiempo...');
INSERT INTO `lang_definitions` VALUES (5004, 3078, 3, 'Exudado:');
INSERT INTO `lang_definitions` VALUES (5005, 3088, 3, 'Irritación de Ojo');
INSERT INTO `lang_definitions` VALUES (5006, 3093, 3, 'Dolor de Ojo');
INSERT INTO `lang_definitions` VALUES (5007, 3097, 3, 'Enrojecimiento de Ojo');
INSERT INTO `lang_definitions` VALUES (5008, 3100, 3, 'Ojos');
INSERT INTO `lang_definitions` VALUES (5009, 3102, 3, 'F');
INSERT INTO `lang_definitions` VALUES (5010, 3103, 3, 'F/H Problemas de Sangre');
INSERT INTO `lang_definitions` VALUES (5011, 3104, 3, 'F/H Hirsutismo Femenino/Estrías');
INSERT INTO `lang_definitions` VALUES (5012, 3105, 3, 'Centros');
INSERT INTO `lang_definitions` VALUES (5013, 3106, 3, 'Centro');
INSERT INTO `lang_definitions` VALUES (5014, 3107, 3, 'centro');
INSERT INTO `lang_definitions` VALUES (5015, 3108, 3, 'Administración del Centro');
INSERT INTO `lang_definitions` VALUES (5016, 3109, 3, 'Ciudad del Centro');
INSERT INTO `lang_definitions` VALUES (5017, 3110, 3, 'Código del Centro');
INSERT INTO `lang_definitions` VALUES (5018, 3112, 3, 'Código País del Centro');
INSERT INTO `lang_definitions` VALUES (5019, 3113, 3, 'Fax del Centro');
INSERT INTO `lang_definitions` VALUES (5020, 3115, 3, 'Nombre del Centro');
INSERT INTO `lang_definitions` VALUES (5021, 3116, 3, 'NPI del Centro');
INSERT INTO `lang_definitions` VALUES (5022, 3117, 3, 'Teléfono del Centro');
INSERT INTO `lang_definitions` VALUES (5023, 3118, 3, 'Información de usuario en el centro especificado');
INSERT INTO `lang_definitions` VALUES (5024, 3119, 3, 'Estado del Centro');
INSERT INTO `lang_definitions` VALUES (5025, 3120, 3, 'Dirección del Centro');
INSERT INTO `lang_definitions` VALUES (5026, 3122, 3, 'Código Postal del Centro');
INSERT INTO `lang_definitions` VALUES (5027, 3124, 3, 'Centro:');
INSERT INTO `lang_definitions` VALUES (5028, 3125, 3, 'Fallo');
INSERT INTO `lang_definitions` VALUES (5029, 3126, 3, 'fallado');
INSERT INTO `lang_definitions` VALUES (5030, 3127, 3, 'Fallado');
INSERT INTO `lang_definitions` VALUES (5031, 3135, 3, 'Fallo al crear la carpeta temporal. CouchDB no funcionará.');
INSERT INTO `lang_definitions` VALUES (5032, 3140, 3, 'Fallo');
INSERT INTO `lang_definitions` VALUES (5033, 3141, 3, 'error');
INSERT INTO `lang_definitions` VALUES (5034, 3148, 3, 'Historia familiar');
INSERT INTO `lang_definitions` VALUES (5035, 3149, 3, 'Historia Familiar de Glaucoma');
INSERT INTO `lang_definitions` VALUES (5036, 3150, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (5037, 3152, 3, 'Familia de pago');
INSERT INTO `lang_definitions` VALUES (5038, 3153, 3, 'Tamaño familia');
INSERT INTO `lang_definitions` VALUES (5039, 3154, 3, 'Suposición');
INSERT INTO `lang_definitions` VALUES (5040, 3156, 3, 'Iraní');
INSERT INTO `lang_definitions` VALUES (5041, 3158, 3, 'Padre');
INSERT INTO `lang_definitions` VALUES (5042, 3160, 3, 'Fatiga');
INSERT INTO `lang_definitions` VALUES (5043, 3161, 3, 'Fatigado');
INSERT INTO `lang_definitions` VALUES (5044, 3162, 3, 'Fax');
INSERT INTO `lang_definitions` VALUES (5045, 3163, 3, 'Contador fax');
INSERT INTO `lang_definitions` VALUES (5046, 3164, 3, 'Número de fax');
INSERT INTO `lang_definitions` VALUES (5047, 3166, 3, 'Fax/Escanear');
INSERT INTO `lang_definitions` VALUES (5048, 3167, 3, 'Faxes entrada');
INSERT INTO `lang_definitions` VALUES (5049, 3168, 3, 'Faxes salida');
INSERT INTO `lang_definitions` VALUES (5050, 3169, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (5051, 3170, 3, 'Feb');
INSERT INTO `lang_definitions` VALUES (5052, 3171, 3, 'Febrero');
INSERT INTO `lang_definitions` VALUES (5053, 3172, 3, 'FECA');
INSERT INTO `lang_definitions` VALUES (5054, 3173, 3, 'Nº Colegiado');
INSERT INTO `lang_definitions` VALUES (5055, 3174, 3, 'Federal EIN');
INSERT INTO `lang_definitions` VALUES (5056, 3175, 3, 'Nº Identificación de impuesto federal');
INSERT INTO `lang_definitions` VALUES (5057, 3177, 3, 'Honorario');
INSERT INTO `lang_definitions` VALUES (5058, 3178, 3, 'honorario');
INSERT INTO `lang_definitions` VALUES (5059, 3179, 3, 'No se permiten honorarios');
INSERT INTO `lang_definitions` VALUES (5060, 3180, 3, 'Hoja de honorarios');
INSERT INTO `lang_definitions` VALUES (5061, 3181, 3, 'Opciones de la hoja de honorarios');
INSERT INTO `lang_definitions` VALUES (5062, 3182, 3, 'Honorarios');
INSERT INTO `lang_definitions` VALUES (5063, 3183, 3, 'Femenino');
INSERT INTO `lang_definitions` VALUES (5064, 3184, 3, 'AP Femenino');
INSERT INTO `lang_definitions` VALUES (5065, 3185, 3, 'Condones femeninos');
INSERT INTO `lang_definitions` VALUES (5066, 3186, 3, 'G Femenino');
INSERT INTO `lang_definitions` VALUES (5067, 3187, 3, 'LC Femenino');
INSERT INTO `lang_definitions` VALUES (5068, 3188, 3, 'P Femenino');
INSERT INTO `lang_definitions` VALUES (5069, 3189, 3, 'Síntomas Femeninos');
INSERT INTO `lang_definitions` VALUES (5070, 3190, 3, 'Mujeres VSC');
INSERT INTO `lang_definitions` VALUES (5071, 3193, 3, 'Fiebre');
INSERT INTO `lang_definitions` VALUES (5072, 3194, 3, 'Fiebre:');
INSERT INTO `lang_definitions` VALUES (5073, 3195, 3, 'Problemas de Sangre FH');
INSERT INTO `lang_definitions` VALUES (5074, 3198, 3, 'Fibromas');
INSERT INTO `lang_definitions` VALUES (5075, 3202, 3, 'Tipo de campo a utilizar para el país del empleador o abonado en demográficos.');
INSERT INTO `lang_definitions` VALUES (5076, 3203, 3, 'Tipo de campo a utilizar para el estado del empleador o abonado en demográficos.');
INSERT INTO `lang_definitions` VALUES (5077, 3204, 3, 'Falta Campo(s)!');
INSERT INTO `lang_definitions` VALUES (5078, 3210, 3, 'Fichero');
INSERT INTO `lang_definitions` VALUES (5079, 3212, 3, 'Fichero en el directorio de documentación para aprender como automatizar el proceso de creación de logs de backup');
INSERT INTO `lang_definitions` VALUES (5080, 3213, 3, 'Ubicacion del file');
INSERT INTO `lang_definitions` VALUES (5081, 3214, 3, 'Gestión de Fichero');
INSERT INTO `lang_definitions` VALUES (5082, 3221, 3, 'Fichero de permisos de usuario de OpenEMR');
INSERT INTO `lang_definitions` VALUES (5083, 3222, 3, 'Fallo en la recuperación de archivo de CouchDB');
INSERT INTO `lang_definitions` VALUES (5084, 3223, 3, 'Sala de archivo');
INSERT INTO `lang_definitions` VALUES (5085, 3224, 3, 'Fichero para adjuntar');
INSERT INTO `lang_definitions` VALUES (5086, 3226, 3, 'Un fichero con el mismo nombre ya existe en la ubicación:');
INSERT INTO `lang_definitions` VALUES (5087, 3227, 3, 'Nombre de fichero');
INSERT INTO `lang_definitions` VALUES (5088, 3229, 3, 'Ficheros');
INSERT INTO `lang_definitions` VALUES (5089, 3232, 3, 'Filipino');
INSERT INTO `lang_definitions` VALUES (5090, 3234, 3, 'Rellene cualquiera de las filas de abajo.');
INSERT INTO `lang_definitions` VALUES (5091, 3235, 3, 'Rellenar sólo si manda notificación a paciente por email');
INSERT INTO `lang_definitions` VALUES (5092, 3236, 3, 'Llenar los valores abajo');
INSERT INTO `lang_definitions` VALUES (5093, 3238, 3, 'Rellene la fila');
INSERT INTO `lang_definitions` VALUES (5094, 3240, 3, 'Filtro');
INSERT INTO `lang_definitions` VALUES (5095, 3241, 3, 'Filtro para los constantes');
INSERT INTO `lang_definitions` VALUES (5096, 3242, 3, 'Filtro por Definición');
INSERT INTO `lang_definitions` VALUES (5097, 3243, 3, 'Filtrado desde');
INSERT INTO `lang_definitions` VALUES (5098, 3244, 3, 'filtros');
INSERT INTO `lang_definitions` VALUES (5099, 3245, 3, 'Filtros');
INSERT INTO `lang_definitions` VALUES (5100, 3246, 3, 'Final');
INSERT INTO `lang_definitions` VALUES (5101, 3247, 3, 'Diagnóstico final');
INSERT INTO `lang_definitions` VALUES (5102, 3248, 3, 'Diagnóstico final por especialista');
INSERT INTO `lang_definitions` VALUES (5103, 3250, 3, 'Financiero');
INSERT INTO `lang_definitions` VALUES (5104, 3251, 3, 'Fecha cierre financiero (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (5105, 3252, 3, 'Información financiera - cualquier cosa');
INSERT INTO `lang_definitions` VALUES (5106, 3254, 3, 'Información financiera - mis visitas');
INSERT INTO `lang_definitions` VALUES (5107, 3257, 3, 'Fecha de revisión financiero');
INSERT INTO `lang_definitions` VALUES (5108, 3258, 3, 'Resumen Financiero por Código de Servicio');
INSERT INTO `lang_definitions` VALUES (5109, 3259, 3, 'Buscar');
INSERT INTO `lang_definitions` VALUES (5110, 3260, 3, 'Buscar disponible');
INSERT INTO `lang_definitions` VALUES (5111, 3261, 3, 'Buscar citas disponibles');
INSERT INTO `lang_definitions` VALUES (5112, 3262, 3, 'Busca paciente');
INSERT INTO `lang_definitions` VALUES (5113, 3263, 3, 'Buscar materiales educativos para el paciente');
INSERT INTO `lang_definitions` VALUES (5114, 3264, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (5115, 3265, 3, 'Conclusiones por especialista');
INSERT INTO `lang_definitions` VALUES (5116, 3266, 3, 'Multa');
INSERT INTO `lang_definitions` VALUES (5117, 3268, 3, 'Final Pagos');
INSERT INTO `lang_definitions` VALUES (5118, 3270, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (5119, 3272, 3, 'Primero');
INSERT INTO `lang_definitions` VALUES (5120, 3275, 3, 'Primer día de la semana');
INSERT INTO `lang_definitions` VALUES (5121, 3278, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (5122, 3279, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (5123, 3280, 3, 'Nombre:');
INSERT INTO `lang_definitions` VALUES (5124, 3285, 3, 'Aptitud');
INSERT INTO `lang_definitions` VALUES (5125, 3286, 3, 'Condicion Fisica');
INSERT INTO `lang_definitions` VALUES (5126, 3287, 3, 'Condicion Fisica para este jugador hoy');
INSERT INTO `lang_definitions` VALUES (5127, 3289, 3, 'Aptitud para jugar');
INSERT INTO `lang_definitions` VALUES (5128, 3290, 3, 'Fijar fechas visita - cualquier visita');
INSERT INTO `lang_definitions` VALUES (5129, 3292, 3, 'Solucionar este');
INSERT INTO `lang_definitions` VALUES (5130, 3293, 3, 'FL');
INSERT INTO `lang_definitions` VALUES (5131, 3295, 3, 'Flatulencia');
INSERT INTO `lang_definitions` VALUES (5132, 3296, 3, 'Flujo');
INSERT INTO `lang_definitions` VALUES (5133, 3311, 3, 'Temporada de gripe');
INSERT INTO `lang_definitions` VALUES (5134, 3312, 3, 'Temporada de Gripe');
INSERT INTO `lang_definitions` VALUES (5135, 3313, 3, 'Vacunación gripe');
INSERT INTO `lang_definitions` VALUES (5136, 3314, 3, 'Problema de fluído y electrolito');
INSERT INTO `lang_definitions` VALUES (5137, 3315, 3, 'FMS');
INSERT INTO `lang_definitions` VALUES (5138, 3316, 3, 'Tamaño papel folio');
INSERT INTO `lang_definitions` VALUES (5139, 3317, 3, 'Seguir manualmente');
INSERT INTO `lang_definitions` VALUES (5140, 3318, 3, 'Siga estas instrucciones para instalar o actualizar la siguiente bbdd');
INSERT INTO `lang_definitions` VALUES (5141, 3319, 3, 'Seguimineto');
INSERT INTO `lang_definitions` VALUES (5142, 3321, 3, 'Motivo de seguimiento');
INSERT INTO `lang_definitions` VALUES (5143, 3323, 3, 'A continuación una nueva constante de cliente:');
INSERT INTO `lang_definitions` VALUES (5144, 3324, 3, 'A continuación un nuevo idioma de cliente:');
INSERT INTO `lang_definitions` VALUES (5145, 3325, 3, 'A continuación una nueva definición (Idioma, Constante, Definición):');
INSERT INTO `lang_definitions` VALUES (5146, 3327, 3, 'Servicios de seguimiento');
INSERT INTO `lang_definitions` VALUES (5147, 3328, 3, 'Seguimiento indicado');
INSERT INTO `lang_definitions` VALUES (5148, 3331, 3, 'Intolerancia del Alimento');
INSERT INTO `lang_definitions` VALUES (5149, 3332, 3, 'Pie');
INSERT INTO `lang_definitions` VALUES (5150, 3333, 3, 'Problemas en los píes');
INSERT INTO `lang_definitions` VALUES (5151, 3334, 3, 'Píe:');
INSERT INTO `lang_definitions` VALUES (5152, 3335, 3, 'Lesiones de fútbol');
INSERT INTO `lang_definitions` VALUES (5153, 3337, 3, 'Informe de lesión futbolística');
INSERT INTO `lang_definitions` VALUES (5154, 3338, 3, 'Tipo de calzado');
INSERT INTO `lang_definitions` VALUES (5155, 3339, 3, 'para');
INSERT INTO `lang_definitions` VALUES (5156, 3340, 3, 'Para');
INSERT INTO `lang_definitions` VALUES (5157, 3343, 3, 'Por Código');
INSERT INTO `lang_definitions` VALUES (5158, 3345, 3, 'Para reclamaciones de visita');
INSERT INTO `lang_definitions` VALUES (5159, 3346, 3, 'Por Ejemplo');
INSERT INTO `lang_definitions` VALUES (5160, 3349, 3, 'Por Factura');
INSERT INTO `lang_definitions` VALUES (5161, 3350, 3, 'Para Seguro médico sólo, obliga al facultativo de referencia a ser el mismo que el facultativo del representado.');
INSERT INTO `lang_definitions` VALUES (5162, 3354, 3, 'Para el profesional/Organizacion referida');
INSERT INTO `lang_definitions` VALUES (5163, 3355, 3, 'Por el pasado');
INSERT INTO `lang_definitions` VALUES (5164, 3357, 3, 'por variable');
INSERT INTO `lang_definitions` VALUES (5165, 3358, 3, 'para:');
INSERT INTO `lang_definitions` VALUES (5166, 3359, 3, 'Fuerza la apertura del widget de facturación');
INSERT INTO `lang_definitions` VALUES (5167, 3360, 3, 'Forzar Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (5168, 3362, 3, 'Antebrazo');
INSERT INTO `lang_definitions` VALUES (5169, 3363, 3, 'Formulario');
INSERT INTO `lang_definitions` VALUES (5170, 3364, 3, 'formulario');
INSERT INTO `lang_definitions` VALUES (5171, 3368, 3, 'Formato');
INSERT INTO `lang_definitions` VALUES (5172, 3369, 3, 'formato');
INSERT INTO `lang_definitions` VALUES (5173, 3371, 3, 'Formato incorrecto para el NDC');
INSERT INTO `lang_definitions` VALUES (5174, 3372, 3, 'Formato usado para la mayoría de fechas');
INSERT INTO `lang_definitions` VALUES (5175, 3373, 3, 'Formato usado para mostrar la mayoría de horas.');
INSERT INTO `lang_definitions` VALUES (5176, 3374, 3, 'Informe Formateado');
INSERT INTO `lang_definitions` VALUES (5177, 3375, 3, 'Ex-fumador');
INSERT INTO `lang_definitions` VALUES (5178, 3376, 3, 'Formularios');
INSERT INTO `lang_definitions` VALUES (5179, 3377, 3, 'Formas de administración');
INSERT INTO `lang_definitions` VALUES (5180, 3381, 3, 'Re-enviar');
INSERT INTO `lang_definitions` VALUES (5181, 3383, 3, 'Reenviar Páginas vía fax');
INSERT INTO `lang_definitions` VALUES (5182, 3384, 3, 'Remitido');
INSERT INTO `lang_definitions` VALUES (5183, 3387, 3, 'Cuarto');
INSERT INTO `lang_definitions` VALUES (5184, 3389, 3, 'Fractura');
INSERT INTO `lang_definitions` VALUES (5185, 3390, 3, 'Fractura de escafoides');
INSERT INTO `lang_definitions` VALUES (5186, 3391, 3, 'Fractura del maléolo lat.');
INSERT INTO `lang_definitions` VALUES (5187, 3392, 3, 'Fractura del maléolo tibial.');
INSERT INTO `lang_definitions` VALUES (5188, 3393, 3, 'Fractura de base quinta (5 ª) metatarsianas');
INSERT INTO `lang_definitions` VALUES (5189, 3394, 3, 'Marco');
INSERT INTO `lang_definitions` VALUES (5190, 3395, 3, 'Soporte para Marcos requeridos');
INSERT INTO `lang_definitions` VALUES (5191, 3396, 3, 'Francés');
INSERT INTO `lang_definitions` VALUES (5192, 3397, 3, 'Francés (Canadiense)');
INSERT INTO `lang_definitions` VALUES (5193, 3398, 3, 'Francés (Standard)');
INSERT INTO `lang_definitions` VALUES (5194, 3399, 3, 'Frecuencia');
INSERT INTO `lang_definitions` VALUES (5195, 3400, 3, 'Resfriados Frecuentes');
INSERT INTO `lang_definitions` VALUES (5196, 3401, 3, 'Enfermedades Frecuentes');
INSERT INTO `lang_definitions` VALUES (5197, 3402, 3, 'Viernes');
INSERT INTO `lang_definitions` VALUES (5198, 3403, 3, 'Viernes');
INSERT INTO `lang_definitions` VALUES (5199, 3405, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (5200, 3406, 3, 'DESDE');
INSERT INTO `lang_definitions` VALUES (5201, 3407, 3, 'desde');
INSERT INTO `lang_definitions` VALUES (5202, 3408, 3, 'Fecha desde no puede ser mayor que fecha hasta');
INSERT INTO `lang_definitions` VALUES (5203, 3411, 3, 'Desde:');
INSERT INTO `lang_definitions` VALUES (5204, 3412, 3, 'Desde:');
INSERT INTO `lang_definitions` VALUES (5205, 3413, 3, 'FROM_CITY');
INSERT INTO `lang_definitions` VALUES (5206, 3415, 3, 'FROM_FNAME');
INSERT INTO `lang_definitions` VALUES (5207, 3416, 3, 'FROM_LNAME');
INSERT INTO `lang_definitions` VALUES (5208, 3417, 3, 'FROM_MNAME');
INSERT INTO `lang_definitions` VALUES (5209, 3419, 3, 'FROM_PHONECELL');
INSERT INTO `lang_definitions` VALUES (5210, 3420, 3, 'FROM_POSTAL');
INSERT INTO `lang_definitions` VALUES (5211, 3421, 3, 'FROM_STATE');
INSERT INTO `lang_definitions` VALUES (5212, 3422, 3, 'FROM_STREET');
INSERT INTO `lang_definitions` VALUES (5213, 3423, 3, 'FROM_TITLE');
INSERT INTO `lang_definitions` VALUES (5214, 3424, 3, 'FROM_VALEDICTORY');
INSERT INTO `lang_definitions` VALUES (5215, 3425, 3, 'Oficina central');
INSERT INTO `lang_definitions` VALUES (5216, 3426, 3, 'Recibos de la Oficina Central');
INSERT INTO `lang_definitions` VALUES (5217, 3427, 3, 'Reportes de Recibos de la Oficina Central');
INSERT INTO `lang_definitions` VALUES (5218, 3428, 3, 'Rec. Oficina Central');
INSERT INTO `lang_definitions` VALUES (5219, 3429, 3, 'La derecha frontal:');
INSERT INTO `lang_definitions` VALUES (5220, 3435, 3, 'Nombre Completo');
INSERT INTO `lang_definitions` VALUES (5221, 3437, 3, 'Ruta completa del directorio que contiene los ejecutables MySQL.');
INSERT INTO `lang_definitions` VALUES (5222, 3438, 3, 'Ruta completa del directorio que contiene los ejecutables Perl.');
INSERT INTO `lang_definitions` VALUES (5223, 3439, 3, 'Ruta completa del directorio para log de eventos de backup');
INSERT INTO `lang_definitions` VALUES (5224, 3440, 3, 'Ruta completa del directorio usado para ficheros temporales');
INSERT INTO `lang_definitions` VALUES (5225, 3441, 3, 'Juego completo');
INSERT INTO `lang_definitions` VALUES (5226, 3443, 3, 'Entrenamiento completo');
INSERT INTO `lang_definitions` VALUES (5227, 3445, 3, 'Pagado Total');
INSERT INTO `lang_definitions` VALUES (5228, 3454, 3, 'G');
INSERT INTO `lang_definitions` VALUES (5229, 3455, 3, 'G/DL');
INSERT INTO `lang_definitions` VALUES (5230, 3457, 3, 'Afección de la vesícula biliar');
INSERT INTO `lang_definitions` VALUES (5231, 3458, 3, 'Piedras en la vesícula');
INSERT INTO `lang_definitions` VALUES (5232, 3459, 3, 'Periodo de Juego');
INSERT INTO `lang_definitions` VALUES (5233, 3460, 3, 'Juegos');
INSERT INTO `lang_definitions` VALUES (5234, 3461, 3, 'Juegos faltados');
INSERT INTO `lang_definitions` VALUES (5235, 3462, 3, 'juegos/eventos');
INSERT INTO `lang_definitions` VALUES (5236, 3463, 3, 'Juegos/Eventos perdidos');
INSERT INTO `lang_definitions` VALUES (5237, 3465, 3, 'Gastritis');
INSERT INTO `lang_definitions` VALUES (5238, 3466, 3, 'Dolor Gastrointestinal');
INSERT INTO `lang_definitions` VALUES (5239, 3467, 3, 'Gastrointestinal');
INSERT INTO `lang_definitions` VALUES (5240, 3468, 3, 'Informe de estadísticas del GCAC');
INSERT INTO `lang_definitions` VALUES (5241, 3469, 3, 'Estadísticas GCAC');
INSERT INTO `lang_definitions` VALUES (5242, 3470, 3, 'Falta la forma de la visita del GCAC');
INSERT INTO `lang_definitions` VALUES (5243, 3471, 3, 'Género');
INSERT INTO `lang_definitions` VALUES (5244, 3472, 3, 'Género');
INSERT INTO `lang_definitions` VALUES (5245, 3473, 3, 'General');
INSERT INTO `lang_definitions` VALUES (5246, 3477, 3, 'Categoría de servicio general');
INSERT INTO `lang_definitions` VALUES (5247, 3481, 3, 'Generar y Descargar');
INSERT INTO `lang_definitions` VALUES (5248, 3483, 3, 'Generar y descargar HCFA 1500 reclamaciones en papel');
INSERT INTO `lang_definitions` VALUES (5249, 3486, 3, 'Generar y descargar batch X12');
INSERT INTO `lang_definitions` VALUES (5250, 3487, 3, 'Generar y descargar batch X12 de reclamación por visita');
INSERT INTO `lang_definitions` VALUES (5251, 3490, 3, 'Generar y transmitir electrónicamente las recetas autorizadas.');
INSERT INTO `lang_definitions` VALUES (5252, 3491, 3, 'Generar formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (5253, 3492, 3, 'Generar formulario CMS 1500 PDF');
INSERT INTO `lang_definitions` VALUES (5254, 3493, 3, 'Generar formulario CMS 1500 TEXTO');
INSERT INTO `lang_definitions` VALUES (5255, 3494, 3, 'Genere HCFA');
INSERT INTO `lang_definitions` VALUES (5256, 3496, 3, 'Generar factura');
INSERT INTO `lang_definitions` VALUES (5257, 3497, 3, 'Genere la Carta');
INSERT INTO `lang_definitions` VALUES (5258, 3498, 3, 'Generar carta relacionada');
INSERT INTO `lang_definitions` VALUES (5259, 3500, 3, 'Generar informe PQRI (Método A)');
INSERT INTO `lang_definitions` VALUES (5260, 3502, 3, 'Generar informe PQRI (Método E)');
INSERT INTO `lang_definitions` VALUES (5261, 3506, 3, 'Generar informe');
INSERT INTO `lang_definitions` VALUES (5262, 3511, 3, 'Generar usuario y contraseña para');
INSERT INTO `lang_definitions` VALUES (5263, 3512, 3, 'Generar X12');
INSERT INTO `lang_definitions` VALUES (5264, 3514, 3, 'Generar visita X12');
INSERT INTO `lang_definitions` VALUES (5265, 3516, 3, 'Generado en');
INSERT INTO `lang_definitions` VALUES (5266, 3518, 3, 'genera');
INSERT INTO `lang_definitions` VALUES (5267, 3523, 3, 'Genitourinario');
INSERT INTO `lang_definitions` VALUES (5268, 3527, 3, 'Alemán');
INSERT INTO `lang_definitions` VALUES (5269, 3532, 3, 'Obtener HL7');
INSERT INTO `lang_definitions` VALUES (5270, 3536, 3, 'Glaucoma');
INSERT INTO `lang_definitions` VALUES (5271, 3537, 3, 'Historia Familiar de Glaucoma');
INSERT INTO `lang_definitions` VALUES (5272, 3539, 3, 'Global');
INSERT INTO `lang_definitions` VALUES (5273, 3542, 3, 'ID Global');
INSERT INTO `lang_definitions` VALUES (5274, 3543, 3, 'Ajustes Globales');
INSERT INTO `lang_definitions` VALUES (5275, 3544, 3, 'Globales');
INSERT INTO `lang_definitions` VALUES (5276, 3545, 3, 'GM/DL');
INSERT INTO `lang_definitions` VALUES (5277, 3546, 3, 'ir');
INSERT INTO `lang_definitions` VALUES (5278, 3548, 3, 'Ir');
INSERT INTO `lang_definitions` VALUES (5279, 3550, 3, 'Ir a');
INSERT INTO `lang_definitions` VALUES (5280, 3551, 3, 'Ir a la semana del');
INSERT INTO `lang_definitions` VALUES (5281, 3552, 3, 'Ir hoy');
INSERT INTO `lang_definitions` VALUES (5282, 3559, 3, 'Grado de la lesión');
INSERT INTO `lang_definitions` VALUES (5283, 3560, 3, 'Grado:');
INSERT INTO `lang_definitions` VALUES (5284, 3561, 3, 'Gramos');
INSERT INTO `lang_definitions` VALUES (5285, 3562, 3, 'Suma total');
INSERT INTO `lang_definitions` VALUES (5286, 3563, 3, 'Sumas totales');
INSERT INTO `lang_definitions` VALUES (5287, 3566, 3, 'Posibilidad de gráfico');
INSERT INTO `lang_definitions` VALUES (5288, 3568, 3, 'Mayor que');
INSERT INTO `lang_definitions` VALUES (5289, 3569, 3, 'Mayor que o Igual a');
INSERT INTO `lang_definitions` VALUES (5290, 3570, 3, 'Griego');
INSERT INTO `lang_definitions` VALUES (5291, 3572, 3, 'Grupo');
INSERT INTO `lang_definitions` VALUES (5292, 3585, 3, 'Nombre de Grupo');
INSERT INTO `lang_definitions` VALUES (5293, 3586, 3, 'Los nombres de los grupos no pueden quedar en blanco');
INSERT INTO `lang_definitions` VALUES (5294, 3587, 3, 'Los nombres de los grupos no pueden iniciar con números');
INSERT INTO `lang_definitions` VALUES (5295, 3588, 3, 'Los nombres de grupo no pueden comenzar con números.');
INSERT INTO `lang_definitions` VALUES (5296, 3589, 3, 'Número de grupo');
INSERT INTO `lang_definitions` VALUES (5297, 3591, 3, 'Grupo de pago');
INSERT INTO `lang_definitions` VALUES (5298, 3597, 3, 'Grupo:');
INSERT INTO `lang_definitions` VALUES (5299, 3598, 3, 'Nombre del grupo');
INSERT INTO `lang_definitions` VALUES (5300, 3600, 3, 'Controles de grupos y accesos');
INSERT INTO `lang_definitions` VALUES (5301, 3601, 3, 'Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (5302, 3602, 3, 'Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (5303, 3603, 3, 'gtts (gotas)');
INSERT INTO `lang_definitions` VALUES (5304, 3604, 3, 'Guamés');
INSERT INTO `lang_definitions` VALUES (5305, 3609, 3, 'Nombre del tutor');
INSERT INTO `lang_definitions` VALUES (5306, 3614, 3, 'Examen ginecológico');
INSERT INTO `lang_definitions` VALUES (5307, 3615, 3, 'h');
INSERT INTO `lang_definitions` VALUES (5308, 3617, 3, 'h.s.');
INSERT INTO `lang_definitions` VALUES (5309, 3618, 3, 'H/O Hepatitis');
INSERT INTO `lang_definitions` VALUES (5310, 3619, 3, 'se ha suprimido con éxito. Cualquier sub-categorías si fueron trasladados abajo');
INSERT INTO `lang_definitions` VALUES (5311, 3620, 3, 'Hematoma/moratón');
INSERT INTO `lang_definitions` VALUES (5312, 3621, 3, 'HAI Estado');
INSERT INTO `lang_definitions` VALUES (5313, 3624, 3, 'manos + dedos');
INSERT INTO `lang_definitions` VALUES (5314, 3625, 3, 'Problemas de manos');
INSERT INTO `lang_definitions` VALUES (5315, 3628, 3, 'Disco Duro');
INSERT INTO `lang_definitions` VALUES (5316, 3629, 3, 'Dificultad sin');
INSERT INTO `lang_definitions` VALUES (5317, 3630, 3, 'se ha ligado para visitar');
INSERT INTO `lang_definitions` VALUES (5318, 3631, 3, 'ha expirado');
INSERT INTO `lang_definitions` VALUES (5319, 3632, 3, 'Función Hash');
INSERT INTO `lang_definitions` VALUES (5320, 3633, 3, 'No existe hash para este fichero. Un nuevo hash será generado.');
INSERT INTO `lang_definitions` VALUES (5321, 3634, 3, 'Hash no coincide. La integridad de datos se ha visto comprometida.');
INSERT INTO `lang_definitions` VALUES (5322, 3636, 3, 'Hawaiano');
INSERT INTO `lang_definitions` VALUES (5323, 3637, 3, 'Actividades peligrosas');
INSERT INTO `lang_definitions` VALUES (5324, 3638, 3, 'Actividades peligrosas');
INSERT INTO `lang_definitions` VALUES (5325, 3641, 3, 'Margen izquierdo de HCFA en puntos');
INSERT INTO `lang_definitions` VALUES (5326, 3642, 3, 'Márgenes de HCFA');
INSERT INTO `lang_definitions` VALUES (5327, 3643, 3, 'Margen superior en puntos de HCFA');
INSERT INTO `lang_definitions` VALUES (5328, 3644, 3, 'Procedimiento/Servicio HCPCS');
INSERT INTO `lang_definitions` VALUES (5329, 3645, 3, 'PostCalendar');
INSERT INTO `lang_definitions` VALUES (5330, 3646, 3, 'Cabeza');
INSERT INTO `lang_definitions` VALUES (5331, 3647, 3, 'Jefe Circ');
INSERT INTO `lang_definitions` VALUES (5332, 3648, 3, 'Circunferencia de la cabeza');
INSERT INTO `lang_definitions` VALUES (5333, 3649, 3, 'Dolor de cabeza');
INSERT INTO `lang_definitions` VALUES (5334, 3650, 3, 'Dolores de cabeza');
INSERT INTO `lang_definitions` VALUES (5335, 3651, 3, 'Operaciones de atención médica');
INSERT INTO `lang_definitions` VALUES (5336, 3652, 3, 'Operaciones de Atención Médica');
INSERT INTO `lang_definitions` VALUES (5337, 3653, 3, 'Centro de salud/clínica');
INSERT INTO `lang_definitions` VALUES (5338, 3654, 3, 'Organización para el mantenimiento de la salud');
INSERT INTO `lang_definitions` VALUES (5339, 3655, 3, 'Riesgo de Seguro médico de la organización de mantenimiento de salud (HMO)');
INSERT INTO `lang_definitions` VALUES (5340, 3656, 3, 'Pérdida de Oído');
INSERT INTO `lang_definitions` VALUES (5341, 3657, 3, 'Ataque al Corazón');
INSERT INTO `lang_definitions` VALUES (5342, 3658, 3, 'Enfermedad del corazón');
INSERT INTO `lang_definitions` VALUES (5343, 3659, 3, 'Fallo cardiaco');
INSERT INTO `lang_definitions` VALUES (5344, 3660, 3, 'Problema del Corazón');
INSERT INTO `lang_definitions` VALUES (5345, 3661, 3, 'Problemas de corazón');
INSERT INTO `lang_definitions` VALUES (5346, 3662, 3, 'Cirugía del Corazón');
INSERT INTO `lang_definitions` VALUES (5347, 3663, 3, 'Transplante de corazón');
INSERT INTO `lang_definitions` VALUES (5348, 3664, 3, 'CORAZÓN:');
INSERT INTO `lang_definitions` VALUES (5349, 3665, 3, 'Ardor de estómago');
INSERT INTO `lang_definitions` VALUES (5350, 3666, 3, 'Calor o Frío');
INSERT INTO `lang_definitions` VALUES (5351, 3667, 3, 'Calor o Frío');
INSERT INTO `lang_definitions` VALUES (5352, 3669, 3, 'Hebreo');
INSERT INTO `lang_definitions` VALUES (5353, 3671, 3, 'HEENT');
INSERT INTO `lang_definitions` VALUES (5354, 3672, 3, 'Altura');
INSERT INTO `lang_definitions` VALUES (5355, 3674, 3, 'Ayuda');
INSERT INTO `lang_definitions` VALUES (5356, 3675, 3, 'ayuda');
INSERT INTO `lang_definitions` VALUES (5357, 3677, 3, 'Hematemesis');
INSERT INTO `lang_definitions` VALUES (5358, 3678, 3, 'Hematoquecia');
INSERT INTO `lang_definitions` VALUES (5359, 3679, 3, 'Hematológico');
INSERT INTO `lang_definitions` VALUES (5360, 3680, 3, 'Hematuria');
INSERT INTO `lang_definitions` VALUES (5361, 3681, 3, 'Hemoglobina');
INSERT INTO `lang_definitions` VALUES (5362, 3682, 3, 'Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (5363, 3683, 3, 'Hemoptisis');
INSERT INTO `lang_definitions` VALUES (5364, 3684, 3, 'Hepatitis');
INSERT INTO `lang_definitions` VALUES (5365, 3685, 3, 'Hepatitis A 1');
INSERT INTO `lang_definitions` VALUES (5366, 3686, 3, 'Hepatitis A 2');
INSERT INTO `lang_definitions` VALUES (5367, 3687, 3, 'Hepatitis B 1');
INSERT INTO `lang_definitions` VALUES (5368, 3688, 3, 'Hepatitis B 2');
INSERT INTO `lang_definitions` VALUES (5369, 3689, 3, 'Hepatitis B 3');
INSERT INTO `lang_definitions` VALUES (5370, 3690, 3, 'aqui');
INSERT INTO `lang_definitions` VALUES (5371, 3693, 3, 'Reparación de la hernia');
INSERT INTO `lang_definitions` VALUES (5372, 3694, 3, 'disco herniado');
INSERT INTO `lang_definitions` VALUES (5373, 3695, 3, 'Herpes');
INSERT INTO `lang_definitions` VALUES (5374, 3698, 3, 'Vacilación');
INSERT INTO `lang_definitions` VALUES (5375, 3699, 3, 'Ey, tú. has estado aquí para');
INSERT INTO `lang_definitions` VALUES (5376, 3700, 3, 'Hib 1');
INSERT INTO `lang_definitions` VALUES (5377, 3701, 3, 'Hib 2');
INSERT INTO `lang_definitions` VALUES (5378, 3702, 3, 'Hib 3');
INSERT INTO `lang_definitions` VALUES (5379, 3703, 3, 'Hib 4');
INSERT INTO `lang_definitions` VALUES (5380, 3704, 3, 'Oculto');
INSERT INTO `lang_definitions` VALUES (5381, 3705, 3, 'Administración de eventos ocultos');
INSERT INTO `lang_definitions` VALUES (5382, 3706, 3, 'Ocultar');
INSERT INTO `lang_definitions` VALUES (5383, 3708, 3, 'Ocultar detalles');
INSERT INTO `lang_definitions` VALUES (5384, 3710, 3, 'Ocultar Opciones Encriptación/Desencriptación en Documento de Gestión');
INSERT INTO `lang_definitions` VALUES (5385, 3711, 3, 'Ocultar Menú');
INSERT INTO `lang_definitions` VALUES (5386, 3713, 3, 'Ocultar avisos');
INSERT INTO `lang_definitions` VALUES (5387, 3715, 3, 'Ocultar/Mostrar Columnas');
INSERT INTO `lang_definitions` VALUES (5388, 3717, 3, 'Alto');
INSERT INTO `lang_definitions` VALUES (5389, 3719, 3, 'Presión Sanguínea Alta');
INSERT INTO `lang_definitions` VALUES (5390, 3720, 3, 'Indú');
INSERT INTO `lang_definitions` VALUES (5391, 3721, 3, 'Cadera + ingle');
INSERT INTO `lang_definitions` VALUES (5392, 3722, 3, 'Cadera y ingle');
INSERT INTO `lang_definitions` VALUES (5393, 3723, 3, 'Problemas de cadera');
INSERT INTO `lang_definitions` VALUES (5394, 3724, 3, 'Reemplazo de Cadera');
INSERT INTO `lang_definitions` VALUES (5395, 3726, 3, 'Aviso Recibido de HIPPA');
INSERT INTO `lang_definitions` VALUES (5396, 3728, 3, 'Hirsutismo/Estrías');
INSERT INTO `lang_definitions` VALUES (5397, 3729, 3, 'Hispano');
INSERT INTO `lang_definitions` VALUES (5398, 3730, 3, 'Hispano - Otro (Nacido en USA)');
INSERT INTO `lang_definitions` VALUES (5399, 3731, 3, 'Hispano - Otro (Nacido fuera de USA)');
INSERT INTO `lang_definitions` VALUES (5400, 3732, 3, 'Hispano o Latino');
INSERT INTO `lang_definitions` VALUES (5401, 3734, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (5402, 3736, 3, 'Historia de Datos');
INSERT INTO `lang_definitions` VALUES (5403, 3737, 3, 'Fecha historia');
INSERT INTO `lang_definitions` VALUES (5404, 3739, 3, 'Historia de Murmullos');
INSERT INTO `lang_definitions` VALUES (5405, 3740, 3, 'Historia no autorizada');
INSERT INTO `lang_definitions` VALUES (5406, 3741, 3, 'Historia de los Murmullos de Corazón');
INSERT INTO `lang_definitions` VALUES (5407, 3745, 3, 'Hits');
INSERT INTO `lang_definitions` VALUES (5408, 3746, 3, 'HIV');
INSERT INTO `lang_definitions` VALUES (5409, 3750, 3, 'Visor HL7');
INSERT INTO `lang_definitions` VALUES (5410, 3752, 3, 'HMO/L');
INSERT INTO `lang_definitions` VALUES (5411, 3753, 3, 'Hmong');
INSERT INTO `lang_definitions` VALUES (5412, 3754, 3, 'Mantener pulsado [Ctrl] para múltiples selecciones o desmarcados');
INSERT INTO `lang_definitions` VALUES (5413, 3755, 3, 'Mantener pulsado Ctrl para seleccionar múltiples elementos');
INSERT INTO `lang_definitions` VALUES (5414, 3756, 3, 'Mantenga presionada la tecla CTRL para seleccionar varios escuadrones');
INSERT INTO `lang_definitions` VALUES (5415, 3758, 3, 'Inicio');
INSERT INTO `lang_definitions` VALUES (5416, 3759, 3, 'Teléfono de casa');
INSERT INTO `lang_definitions` VALUES (5417, 3760, 3, 'Número de Teléfono de Casa');
INSERT INTO `lang_definitions` VALUES (5418, 3762, 3, 'Sin hogar o similares?');
INSERT INTO `lang_definitions` VALUES (5419, 3764, 3, 'Sin hogar, etc.');
INSERT INTO `lang_definitions` VALUES (5420, 3765, 3, 'Sin hogar, etc');
INSERT INTO `lang_definitions` VALUES (5421, 3773, 3, 'Nombre de Huesped');
INSERT INTO `lang_definitions` VALUES (5422, 3774, 3, 'El nombre del huesped no puede estar vacio');
INSERT INTO `lang_definitions` VALUES (5423, 3776, 3, 'Hora');
INSERT INTO `lang_definitions` VALUES (5424, 3777, 3, 'Horas');
INSERT INTO `lang_definitions` VALUES (5425, 3780, 3, '¿Cómo ocurrió la lesión?');
INSERT INTO `lang_definitions` VALUES (5426, 3781, 3, '¿Cómo ocurrió la lesión?:');
INSERT INTO `lang_definitions` VALUES (5427, 3782, 3, 'Como nos ha conocido');
INSERT INTO `lang_definitions` VALUES (5428, 3784, 3, '¿Cuántos meses de antelación a la consulta para los próximos eventos?');
INSERT INTO `lang_definitions` VALUES (5429, 3790, 3, 'HPI:');
INSERT INTO `lang_definitions` VALUES (5430, 3792, 3, 'Altura');
INSERT INTO `lang_definitions` VALUES (5431, 3793, 3, 'HTML');
INSERT INTO `lang_definitions` VALUES (5432, 3796, 3, 'Vínculo Https segurizado para el soporte OpenEMR LLC Laboratorio de intercambio de sevicio.');
INSERT INTO `lang_definitions` VALUES (5433, 3798, 3, 'Húngaro');
INSERT INTO `lang_definitions` VALUES (5434, 3799, 3, 'Hylafax Directorio');
INSERT INTO `lang_definitions` VALUES (5435, 3800, 3, 'Hylafax Commando Enscript');
INSERT INTO `lang_definitions` VALUES (5436, 3801, 3, 'Hylafax Servidor');
INSERT INTO `lang_definitions` VALUES (5437, 3802, 3, 'Hylafax Servidor Hostname');
INSERT INTO `lang_definitions` VALUES (5438, 3803, 3, 'Hiperactivo');
INSERT INTO `lang_definitions` VALUES (5439, 3805, 3, 'Hipertensión');
INSERT INTO `lang_definitions` VALUES (5440, 3806, 3, 'Hipertensión: Medida de presión arterial');
INSERT INTO `lang_definitions` VALUES (5441, 3807, 3, 'Hipertensión: Medida de presión arterial (GCC)');
INSERT INTO `lang_definitions` VALUES (5442, 3808, 3, 'Hipertiroidismo');
INSERT INTO `lang_definitions` VALUES (5443, 3810, 3, 'Hipotiroidismo');
INSERT INTO `lang_definitions` VALUES (5444, 3813, 3, 'Histerectomía');
INSERT INTO `lang_definitions` VALUES (5445, 3814, 3, 'I');
INSERT INTO `lang_definitions` VALUES (5446, 3815, 3, 'Estoy ocupado durante este periodo.');
INSERT INTO `lang_definitions` VALUES (5447, 3816, 3, 'No tengo permiso para leer');
INSERT INTO `lang_definitions` VALUES (5448, 3820, 3, 'CIE');
INSERT INTO `lang_definitions` VALUES (5449, 3821, 3, 'Diagnóstico ICD10');
INSERT INTO `lang_definitions` VALUES (5450, 3822, 3, 'Procedimiento/Servicio ICD10');
INSERT INTO `lang_definitions` VALUES (5451, 3823, 3, 'CIE9');
INSERT INTO `lang_definitions` VALUES (5452, 3824, 3, 'Diagnóstico ICD9');
INSERT INTO `lang_definitions` VALUES (5453, 3825, 3, 'Procedimiento/Servicio ICD9');
INSERT INTO `lang_definitions` VALUES (5454, 3829, 3, 'Nº Identificación');
INSERT INTO `lang_definitions` VALUES (5455, 3831, 3, 'Id');
INSERT INTO `lang_definitions` VALUES (5456, 3832, 3, 'La ID no puede quedar en blanco');
INSERT INTO `lang_definitions` VALUES (5457, 3833, 3, 'Tarjeta ID');
INSERT INTO `lang_definitions` VALUES (5458, 3835, 3, 'IDays');
INSERT INTO `lang_definitions` VALUES (5459, 3836, 3, 'identificado como');
INSERT INTO `lang_definitions` VALUES (5460, 3837, 3, 'Identificador (una palabra)');
INSERT INTO `lang_definitions` VALUES (5461, 3839, 3, 'Tiempo de espera inactivo en segundos');
INSERT INTO `lang_definitions` VALUES (5462, 3845, 3, 'Si todos los datos para todas las columnas están completos para este formulario');
INSERT INTO `lang_definitions` VALUES (5463, 3846, 3, 'Si la justificación de facturación se utiliza introduzca el nombre del código de tipo de diagnóstico.');
INSERT INTO `lang_definitions` VALUES (5464, 3848, 3, 'Si es introducido, seleccione solamente aquel que ha tenido este servicio');
INSERT INTO `lang_definitions` VALUES (5465, 3849, 3, 'Si el nombre, apellido de cualquier parte o apellido, Nombre');
INSERT INTO `lang_definitions` VALUES (5466, 3851, 3, 'Si pagando por');
INSERT INTO `lang_definitions` VALUES (5467, 3852, 3, 'Si la persona ha fallecido, introducir la fecha de la muerte.');
INSERT INTO `lang_definitions` VALUES (5468, 3854, 3, 'Si usa SMTP, nombre del servidor host o la dirección IP.');
INSERT INTO `lang_definitions` VALUES (5469, 3855, 3, 'Si usa SMTP, puerto TCP del servidor (normalmente 25).');
INSERT INTO `lang_definitions` VALUES (5470, 3859, 3, 'Si no tiene trabajo, poner Estudiante');
INSERT INTO `lang_definitions` VALUES (5471, 3862, 3, 'Si cambia el rol de la ePrescripción de receta electrónica, puede afectar al flujo de la ePrescripción. Frente a cualquier dificultad, contacte con su prescriptor de ePrescripción.');
INSERT INTO `lang_definitions` VALUES (5472, 3868, 3, 'Si ha elegido adjuntar las remesas electrónicas, entonces la ventana de búsqueda se vuelve a mostrar con las facturas correspondientes al fichero X12. Puede hacer click en cualquiera de estos números de factura (como se describe a continuación) si desea hacer las correcciones antes de enviar la remesa. Para aplicar los cambios, haga click en el botón de procesar ficheros ERA en la parte inferior de la pantalla. Esto generará una nueva ventana con un informe detallado.');
INSERT INTO `lang_definitions` VALUES (5473, 3869, 3, 'Si ha introducido una Fecha de Pago en la página de búsqueda, esto sobreescribirá la fecha de contabilización de los pagos y ajustes que de otro modo son tomados del fichero X12. Esto puede ser útil para los informes, si usted quiere que sus informes de recetas usen su fecha en lugar que la de proceso de la Sociedad Médica. Recuerde que esto también afectará a las fechas de pagos anteriores y a los ajustes que se ponen en reclamaciones secundarias.');
INSERT INTO `lang_definitions` VALUES (5474, 3871, 3, 'Si quiere cambiar tipos de datos, o añadir filas o columnas');
INSERT INTO `lang_definitions` VALUES (5475, 3872, 3, 'Si quiere actualizar la base de datos, coloque el fichero comprimido de base de datos en el siguiente directorio');
INSERT INTO `lang_definitions` VALUES (5476, 3874, 3, 'Desconocido');
INSERT INTO `lang_definitions` VALUES (5477, 3876, 3, 'Enfermedad');
INSERT INTO `lang_definitions` VALUES (5478, 3877, 3, 'IM');
INSERT INTO `lang_definitions` VALUES (5479, 3882, 3, 'Servicio de imágenes');
INSERT INTO `lang_definitions` VALUES (5480, 3884, 3, 'Vacunación');
INSERT INTO `lang_definitions` VALUES (5481, 3886, 3, 'Código Vacunación');
INSERT INTO `lang_definitions` VALUES (5482, 3888, 3, 'Fecha Vacunación');
INSERT INTO `lang_definitions` VALUES (5483, 3891, 3, 'Número de lote Vacunación');
INSERT INTO `lang_definitions` VALUES (5484, 3892, 3, 'Fabricante de Vacunación');
INSERT INTO `lang_definitions` VALUES (5485, 3897, 3, 'Registro Vacunación');
INSERT INTO `lang_definitions` VALUES (5486, 3901, 3, 'Servicio de Vacunación');
INSERT INTO `lang_definitions` VALUES (5487, 3902, 3, 'Título Vacunación');
INSERT INTO `lang_definitions` VALUES (5488, 3904, 3, 'Vacunaciones');
INSERT INTO `lang_definitions` VALUES (5489, 3905, 3, 'Vacunar');
INSERT INTO `lang_definitions` VALUES (5490, 3906, 3, 'Inmunológicas');
INSERT INTO `lang_definitions` VALUES (5491, 3909, 3, 'Implantes');
INSERT INTO `lang_definitions` VALUES (5492, 3910, 3, 'Importar');
INSERT INTO `lang_definitions` VALUES (5493, 3914, 3, 'Importarr el certificado al buscador');
INSERT INTO `lang_definitions` VALUES (5494, 3915, 3, 'Importar configuración');
INSERT INTO `lang_definitions` VALUES (5495, 3920, 3, 'Importar Paciente');
INSERT INTO `lang_definitions` VALUES (5496, 3921, 3, 'Importar Demográficos del Paciente');
INSERT INTO `lang_definitions` VALUES (5497, 3924, 3, 'Códigos importantes');
INSERT INTO `lang_definitions` VALUES (5498, 3927, 3, 'Importados de Contabilidad');
INSERT INTO `lang_definitions` VALUES (5499, 3932, 3, 'Mejorado');
INSERT INTO `lang_definitions` VALUES (5500, 3934, 3, 'ingreso');
INSERT INTO `lang_definitions` VALUES (5501, 3935, 3, 'ingreso');
INSERT INTO `lang_definitions` VALUES (5502, 3937, 3, 'dentro de cada ojo');
INSERT INTO `lang_definitions` VALUES (5503, 3939, 3, 'en ojo izquierdo');
INSERT INTO `lang_definitions` VALUES (5504, 3940, 3, 'en los agujeros de la nariz');
INSERT INTO `lang_definitions` VALUES (5505, 3941, 3, 'Entrada');
INSERT INTO `lang_definitions` VALUES (5506, 3944, 3, 'en ojo derecho');
INSERT INTO `lang_definitions` VALUES (5507, 3947, 3, 'Dentro de la empresa');
INSERT INTO `lang_definitions` VALUES (5508, 3949, 3, 'Inactivo');
INSERT INTO `lang_definitions` VALUES (5509, 3954, 3, 'Días no activo');
INSERT INTO `lang_definitions` VALUES (5510, 3956, 3, 'Entrada');
INSERT INTO `lang_definitions` VALUES (5511, 3959, 3, 'Incluya checksum');
INSERT INTO `lang_definitions` VALUES (5512, 3960, 3, 'Incluya completado');
INSERT INTO `lang_definitions` VALUES (5513, 3962, 3, 'Incluir los usuarios inactivos');
INSERT INTO `lang_definitions` VALUES (5514, 3963, 3, 'Incluir a un no clasificado');
INSERT INTO `lang_definitions` VALUES (5515, 3964, 3, 'Incluir datos no estructurados');
INSERT INTO `lang_definitions` VALUES (5516, 3965, 3, 'Incluir constantes vitales');
INSERT INTO `lang_definitions` VALUES (5517, 3966, 3, '¿Incluir las constantes vitales?');
INSERT INTO `lang_definitions` VALUES (5518, 3969, 3, 'Inclusión');
INSERT INTO `lang_definitions` VALUES (5519, 3970, 3, 'Ingresos');
INSERT INTO `lang_definitions` VALUES (5520, 3972, 3, 'Incompleto');
INSERT INTO `lang_definitions` VALUES (5521, 3973, 3, 'Tratamiento Aborto incompleto');
INSERT INTO `lang_definitions` VALUES (5522, 3974, 3, 'Incontinencia');
INSERT INTO `lang_definitions` VALUES (5523, 3975, 3, 'Incorporar resultados clínicos del test de laboratorio al certificado tecnológico EHR como estructura');
INSERT INTO `lang_definitions` VALUES (5524, 3977, 3, 'aumentado:');
INSERT INTO `lang_definitions` VALUES (5525, 3978, 3, 'Seguro de Indemnización');
INSERT INTO `lang_definitions` VALUES (5526, 3981, 3, 'indeterminado');
INSERT INTO `lang_definitions` VALUES (5527, 3982, 3, 'Indio');
INSERT INTO `lang_definitions` VALUES (5528, 3985, 3, 'Indica anormalidad');
INSERT INTO `lang_definitions` VALUES (5529, 3987, 3, 'Indica si esta incidencia está activa');
INSERT INTO `lang_definitions` VALUES (5530, 3989, 3, 'Indicador de uso especializado');
INSERT INTO `lang_definitions` VALUES (5531, 3990, 3, 'Pacientes indigentes');
INSERT INTO `lang_definitions` VALUES (5532, 3991, 3, 'Informe de Pacientes Indigentes');
INSERT INTO `lang_definitions` VALUES (5533, 3992, 3, 'Indigentes');
INSERT INTO `lang_definitions` VALUES (5534, 3996, 3, 'Aborto Inducido');
INSERT INTO `lang_definitions` VALUES (5535, 3998, 3, 'Ilegible');
INSERT INTO `lang_definitions` VALUES (5536, 3999, 3, 'Infección/abceso');
INSERT INTO `lang_definitions` VALUES (5537, 4000, 3, 'Infecciones');
INSERT INTO `lang_definitions` VALUES (5538, 4001, 3, 'Consejo Infertilidad');
INSERT INTO `lang_definitions` VALUES (5539, 4002, 3, 'Infertilidad');
INSERT INTO `lang_definitions` VALUES (5540, 4003, 3, 'Gripe 1');
INSERT INTO `lang_definitions` VALUES (5541, 4004, 3, 'Gripe 2');
INSERT INTO `lang_definitions` VALUES (5542, 4005, 3, 'Vacunación gripe p/ pacientes may.50 años');
INSERT INTO `lang_definitions` VALUES (5543, 4006, 3, 'Vacunación gripe p/ pacientes may.50 años (GCC)');
INSERT INTO `lang_definitions` VALUES (5544, 4007, 3, 'Vacuna gripe');
INSERT INTO `lang_definitions` VALUES (5545, 4008, 3, 'Información');
INSERT INTO `lang_definitions` VALUES (5546, 4009, 3, 'Información de ensayo 1');
INSERT INTO `lang_definitions` VALUES (5547, 4010, 3, 'Información de ensayo 2');
INSERT INTO `lang_definitions` VALUES (5548, 4011, 3, 'Información de ensayo 3');
INSERT INTO `lang_definitions` VALUES (5549, 4012, 3, 'Información de ensayo 4');
INSERT INTO `lang_definitions` VALUES (5550, 4013, 3, 'Información de ensayo 5');
INSERT INTO `lang_definitions` VALUES (5551, 4014, 3, 'Información de ensayo 6');
INSERT INTO `lang_definitions` VALUES (5552, 4018, 3, 'Inhalaciones');
INSERT INTO `lang_definitions` VALUES (5553, 4020, 3, 'Inhalaciones');
INSERT INTO `lang_definitions` VALUES (5554, 4023, 3, 'Usuario Inicial');
INSERT INTO `lang_definitions` VALUES (5555, 4025, 3, 'Lesión/Rehabilitación');
INSERT INTO `lang_definitions` VALUES (5556, 4026, 3, 'Inyectables');
INSERT INTO `lang_definitions` VALUES (5557, 4027, 3, 'Inyeccion');
INSERT INTO `lang_definitions` VALUES (5558, 4028, 3, 'Parte del cuerpo lesionada');
INSERT INTO `lang_definitions` VALUES (5559, 4029, 3, 'Herido a Fuera');
INSERT INTO `lang_definitions` VALUES (5560, 4030, 3, 'Herido');
INSERT INTO `lang_definitions` VALUES (5561, 4031, 3, 'Mecanismo de lesión');
INSERT INTO `lang_definitions` VALUES (5562, 4032, 3, 'Informe General de lesión');
INSERT INTO `lang_definitions` VALUES (5563, 4033, 3, 'Vigilancia de Lesiones');
INSERT INTO `lang_definitions` VALUES (5564, 4034, 3, 'Tipo de lesión');
INSERT INTO `lang_definitions` VALUES (5565, 4035, 3, 'Relacionado a lesion/enfermedad');
INSERT INTO `lang_definitions` VALUES (5566, 4040, 3, 'Campos de entrada');
INSERT INTO `lang_definitions` VALUES (5567, 4041, 3, 'Tiempo Protrombina');
INSERT INTO `lang_definitions` VALUES (5568, 4042, 3, 'Ins 1');
INSERT INTO `lang_definitions` VALUES (5569, 4043, 3, 'Ins 2 o Ins 3');
INSERT INTO `lang_definitions` VALUES (5570, 4045, 3, 'Ajuste Seg');
INSERT INTO `lang_definitions` VALUES (5571, 4046, 3, 'Ins bundling');
INSERT INTO `lang_definitions` VALUES (5572, 4047, 3, 'Código Aseguradora');
INSERT INTO `lang_definitions` VALUES (5573, 4050, 3, 'Sobre pago Seg');
INSERT INTO `lang_definitions` VALUES (5574, 4052, 3, 'Reembolso Seg');
INSERT INTO `lang_definitions` VALUES (5575, 4053, 3, 'Resumen Seg');
INSERT INTO `lang_definitions` VALUES (5576, 4055, 3, 'Seg1');
INSERT INTO `lang_definitions` VALUES (5577, 4056, 3, 'Seg2');
INSERT INTO `lang_definitions` VALUES (5578, 4057, 3, 'Seg3');
INSERT INTO `lang_definitions` VALUES (5579, 4059, 3, 'Insertar fallido:');
INSERT INTO `lang_definitions` VALUES (5580, 4063, 3, 'Introduzca los eventos antiguos en tablas');
INSERT INTO `lang_definitions` VALUES (5581, 4066, 3, 'Insomnio');
INSERT INTO `lang_definitions` VALUES (5582, 4068, 3, 'Inspección');
INSERT INTO `lang_definitions` VALUES (5583, 4069, 3, 'Inestabilidad/subluxación');
INSERT INTO `lang_definitions` VALUES (5584, 4070, 3, 'INSTALAR');
INSERT INTO `lang_definitions` VALUES (5585, 4071, 3, 'Instalar');
INSERT INTO `lang_definitions` VALUES (5586, 4073, 3, 'Instalar DB');
INSERT INTO `lang_definitions` VALUES (5587, 4075, 3, 'Versión instalada');
INSERT INTO `lang_definitions` VALUES (5588, 4076, 3, 'instrucciones');
INSERT INTO `lang_definitions` VALUES (5589, 4077, 3, 'Instrucción');
INSERT INTO `lang_definitions` VALUES (5590, 4079, 3, 'instrucciones:');
INSERT INTO `lang_definitions` VALUES (5591, 4081, 3, 'Inventario insuficiente para ID producto');
INSERT INTO `lang_definitions` VALUES (5592, 4082, 3, 'Diabetes insulino dependente');
INSERT INTO `lang_definitions` VALUES (5593, 4083, 3, 'Seguro');
INSERT INTO `lang_definitions` VALUES (5594, 4084, 3, 'Seguro');
INSERT INTO `lang_definitions` VALUES (5595, 4087, 3, 'Saldo del seguro');
INSERT INTO `lang_definitions` VALUES (5596, 4089, 3, 'Sociedad Médica');
INSERT INTO `lang_definitions` VALUES (5597, 4090, 3, 'Sociedades Médicas');
INSERT INTO `lang_definitions` VALUES (5598, 4091, 3, 'Sociedad Médica');
INSERT INTO `lang_definitions` VALUES (5599, 4092, 3, 'Sociedad Médica Buscar/Añadir');
INSERT INTO `lang_definitions` VALUES (5600, 4094, 3, 'Data Seguro');
INSERT INTO `lang_definitions` VALUES (5601, 4095, 3, 'Información del Seguro en fichero');
INSERT INTO `lang_definitions` VALUES (5602, 4096, 3, 'Num Seguro');
INSERT INTO `lang_definitions` VALUES (5603, 4097, 3, 'Pago Aseguradora');
INSERT INTO `lang_definitions` VALUES (5604, 4099, 3, 'Proveedor de Seguro');
INSERT INTO `lang_definitions` VALUES (5605, 4103, 3, 'Asegurado');
INSERT INTO `lang_definitions` VALUES (5606, 4104, 3, 'Conclusión Ingesta');
INSERT INTO `lang_definitions` VALUES (5607, 4105, 3, 'Fecha de Ingesta');
INSERT INTO `lang_definitions` VALUES (5608, 4107, 3, 'Declinación intelectual');
INSERT INTO `lang_definitions` VALUES (5609, 4117, 3, 'Error interno - no se seleccionó ningunas páginas!');
INSERT INTO `lang_definitions` VALUES (5610, 4118, 3, 'Error interno - Nº Identificación del paciente no proporcionado!');
INSERT INTO `lang_definitions` VALUES (5611, 4119, 3, '¡Error interno al accede al fichero adjunto!');
INSERT INTO `lang_definitions` VALUES (5612, 4121, 3, '¡Error interno!');
INSERT INTO `lang_definitions` VALUES (5613, 4122, 3, 'Error interno, Nº Identificación de medicamento no especificado!');
INSERT INTO `lang_definitions` VALUES (5614, 4124, 3, 'Error interno: reclamación');
INSERT INTO `lang_definitions` VALUES (5615, 4125, 3, 'Error Interno: visita \'');
INSERT INTO `lang_definitions` VALUES (5616, 4126, 3, 'Error interno: pid o visita no existe.');
INSERT INTO `lang_definitions` VALUES (5617, 4127, 3, 'Error interno: no parece haber una visita!');
INSERT INTO `lang_definitions` VALUES (5618, 4128, 3, 'Identificador interno (pid)');
INSERT INTO `lang_definitions` VALUES (5619, 4131, 3, 'Derivaciones Internas');
INSERT INTO `lang_definitions` VALUES (5620, 4132, 3, 'Tiempo de coleccion interno');
INSERT INTO `lang_definitions` VALUES (5621, 4133, 3, 'Deber Internacional');
INSERT INTO `lang_definitions` VALUES (5622, 4134, 3, 'Intérprete');
INSERT INTO `lang_definitions` VALUES (5623, 4135, 3, 'Require Intérprete?');
INSERT INTO `lang_definitions` VALUES (5624, 4136, 3, 'Enfermedad Pulmonar Intersticial');
INSERT INTO `lang_definitions` VALUES (5625, 4137, 3, 'Intervalo');
INSERT INTO `lang_definitions` VALUES (5626, 4140, 3, 'Intervención');
INSERT INTO `lang_definitions` VALUES (5627, 4142, 3, 'Intolerancia');
INSERT INTO `lang_definitions` VALUES (5628, 4145, 3, 'Intramuscularmente');
INSERT INTO `lang_definitions` VALUES (5629, 4148, 3, 'Intravenoso');
INSERT INTO `lang_definitions` VALUES (5630, 4149, 3, 'Introducción');
INSERT INTO `lang_definitions` VALUES (5631, 4152, 3, 'Carácter inválido en');
INSERT INTO `lang_definitions` VALUES (5632, 4158, 3, 'Longitud inválida para');
INSERT INTO `lang_definitions` VALUES (5633, 4159, 3, 'Carácter no-numérico inválido en');
INSERT INTO `lang_definitions` VALUES (5634, 4160, 3, 'Inválido o pagador ausente en fuente para código');
INSERT INTO `lang_definitions` VALUES (5635, 4162, 3, 'Códigos de Servicio Inválidos');
INSERT INTO `lang_definitions` VALUES (5636, 4163, 3, 'Designación de la fuente inválida -');
INSERT INTO `lang_definitions` VALUES (5637, 4166, 3, 'InvAmt');
INSERT INTO `lang_definitions` VALUES (5638, 4167, 3, 'Inventario');
INSERT INTO `lang_definitions` VALUES (5639, 4168, 3, 'Actividad de inventario');
INSERT INTO `lang_definitions` VALUES (5640, 4169, 3, 'Inventario y venta, ambos medicamentos y productos no farmacológicos');
INSERT INTO `lang_definitions` VALUES (5641, 4170, 3, 'Inventario y venta medicamentos sólo');
INSERT INTO `lang_definitions` VALUES (5642, 4171, 3, 'El inventario no está disponible para esta orden.');
INSERT INTO `lang_definitions` VALUES (5643, 4172, 3, 'Lista de Inventario');
INSERT INTO `lang_definitions` VALUES (5644, 4173, 3, 'Inventario Transacciones');
INSERT INTO `lang_definitions` VALUES (5645, 4174, 3, 'Factura');
INSERT INTO `lang_definitions` VALUES (5646, 4175, 3, 'factura');
INSERT INTO `lang_definitions` VALUES (5647, 4176, 3, 'Factura saldo');
INSERT INTO `lang_definitions` VALUES (5648, 4177, 3, 'Factura saldo no puede ser enviado. No hay visita creada.');
INSERT INTO `lang_definitions` VALUES (5649, 4178, 3, 'Fecha de Factura');
INSERT INTO `lang_definitions` VALUES (5650, 4179, 3, 'Factura no tiene fecha');
INSERT INTO `lang_definitions` VALUES (5651, 4180, 3, 'Número Factura');
INSERT INTO `lang_definitions` VALUES (5652, 4181, 3, 'Número Referencia Factura');
INSERT INTO `lang_definitions` VALUES (5653, 4182, 3, 'Número referencia factura, si se usa');
INSERT INTO `lang_definitions` VALUES (5654, 4183, 3, 'Número referencia factura');
INSERT INTO `lang_definitions` VALUES (5655, 4184, 3, 'Número referencia factura');
INSERT INTO `lang_definitions` VALUES (5656, 4185, 3, 'Factura:');
INSERT INTO `lang_definitions` VALUES (5657, 4189, 3, 'Fundación Internacional de Planificación Familiar');
INSERT INTO `lang_definitions` VALUES (5658, 4192, 3, 'Datos para SRH IPPF');
INSERT INTO `lang_definitions` VALUES (5659, 4193, 3, 'Informe de las estadísticas de IPPF');
INSERT INTO `lang_definitions` VALUES (5660, 4194, 3, 'Estado Fundación Internacional de Planificación Familiar');
INSERT INTO `lang_definitions` VALUES (5661, 4195, 3, 'IPV 1');
INSERT INTO `lang_definitions` VALUES (5662, 4196, 3, 'IPV 2');
INSERT INTO `lang_definitions` VALUES (5663, 4197, 3, 'IPV 3');
INSERT INTO `lang_definitions` VALUES (5664, 4198, 3, 'IPV 4');
INSERT INTO `lang_definitions` VALUES (5665, 4201, 3, 'Latido de Corazón Irregular');
INSERT INTO `lang_definitions` VALUES (5666, 4202, 3, 'Irritabilidad');
INSERT INTO `lang_definitions` VALUES (5667, 4203, 3, 'Irritación');
INSERT INTO `lang_definitions` VALUES (5668, 4206, 3, 'es la versión más reciente de la siguiente bbdd');
INSERT INTO `lang_definitions` VALUES (5669, 4207, 3, 'es un campo requerido.');
INSERT INTO `lang_definitions` VALUES (5670, 4208, 3, 'es un nodo de raíz y no puede ser suprimido.');
INSERT INTO `lang_definitions` VALUES (5671, 4209, 3, 'es una extensión de la siguiente base de datos');
INSERT INTO `lang_definitions` VALUES (5672, 4212, 3, 'está mal ubicada o es desconocida');
INSERT INTO `lang_definitions` VALUES (5673, 4213, 3, 'no es una dirección de correo electrónico válida');
INSERT INTO `lang_definitions` VALUES (5674, 4214, 3, 'No está seleccionada');
INSERT INTO `lang_definitions` VALUES (5675, 4215, 3, 'no es válida');
INSERT INTO `lang_definitions` VALUES (5676, 4216, 3, 'no es válido (las fracciones decimales están bien).');
INSERT INTO `lang_definitions` VALUES (5677, 4217, 3, '¿El PHP utiliza el modo a prueba de fallos?');
INSERT INTO `lang_definitions` VALUES (5678, 4218, 3, 'Está seleccionada');
INSERT INTO `lang_definitions` VALUES (5679, 4219, 3, '¿Se traduce el texto del formulario plantilla?');
INSERT INTO `lang_definitions` VALUES (5680, 4220, 3, '¿Se traduce el texto de listas?');
INSERT INTO `lang_definitions` VALUES (5681, 4221, 3, '¿Está encriptado el fichero?');
INSERT INTO `lang_definitions` VALUES (5682, 4223, 3, '¿Este es un tipo de diagnóstico?');
INSERT INTO `lang_definitions` VALUES (5683, 4226, 3, '¿Es un tipo de procedimiento/servicio?');
INSERT INTO `lang_definitions` VALUES (5684, 4227, 3, '¿Está esto activo?');
INSERT INTO `lang_definitions` VALUES (5685, 4228, 3, '¿Este tipo de código está activo?');
INSERT INTO `lang_definitions` VALUES (5686, 4229, 3, '¿Este código se usa en reclamaciones?');
INSERT INTO `lang_definitions` VALUES (5687, 4231, 3, '¿Está verdaderamente bien?');
INSERT INTO `lang_definitions` VALUES (5688, 4232, 3, '¿Es un tipo oculto en la hoja de honorarios?');
INSERT INTO `lang_definitions` VALUES (5689, 4233, 3, '¿Se usa en las tablas sql externas? Si es así, elija el formato.');
INSERT INTO `lang_definitions` VALUES (5690, 4234, 3, 'es muy largo');
INSERT INTO `lang_definitions` VALUES (5691, 4235, 3, 'Código ISO 639-2');
INSERT INTO `lang_definitions` VALUES (5692, 4236, 3, 'Incidencia');
INSERT INTO `lang_definitions` VALUES (5693, 4237, 3, 'incidencia');
INSERT INTO `lang_definitions` VALUES (5694, 4238, 3, 'Fecha Incidencia');
INSERT INTO `lang_definitions` VALUES (5695, 4239, 3, 'Nº Identificación incidencia');
INSERT INTO `lang_definitions` VALUES (5696, 4240, 3, 'Subtipos de Incidencias');
INSERT INTO `lang_definitions` VALUES (5697, 4241, 3, 'Título de incidencia');
INSERT INTO `lang_definitions` VALUES (5698, 4242, 3, 'Tipo de Incidencia');
INSERT INTO `lang_definitions` VALUES (5699, 4243, 3, 'Tipos de Incidencia');
INSERT INTO `lang_definitions` VALUES (5700, 4244, 3, 'Incidencias');
INSERT INTO `lang_definitions` VALUES (5701, 4245, 3, 'Incidencias (Lesiones, Médicas, Alergias)');
INSERT INTO `lang_definitions` VALUES (5702, 4246, 3, 'Incidencias (Lesiones, Médicas, Alergias):');
INSERT INTO `lang_definitions` VALUES (5703, 4247, 3, 'Incidencias y Encuentros');
INSERT INTO `lang_definitions` VALUES (5704, 4248, 3, 'Incidencias y Encuentros de');
INSERT INTO `lang_definitions` VALUES (5705, 4250, 3, 'Incidencias no autorizadas');
INSERT INTO `lang_definitions` VALUES (5706, 4251, 3, 'Sección de Incidencias');
INSERT INTO `lang_definitions` VALUES (5707, 4253, 3, 'Italiano');
INSERT INTO `lang_definitions` VALUES (5708, 4254, 3, 'Artículo');
INSERT INTO `lang_definitions` VALUES (5709, 4255, 3, 'Artículo');
INSERT INTO `lang_definitions` VALUES (5710, 4256, 3, 'temas');
INSERT INTO `lang_definitions` VALUES (5711, 4257, 3, 'La carga de artículos falló');
INSERT INTO `lang_definitions` VALUES (5712, 4258, 3, 'IU/L');
INSERT INTO `lang_definitions` VALUES (5713, 4259, 3, 'IUD');
INSERT INTO `lang_definitions` VALUES (5714, 4260, 3, 'IV');
INSERT INTO `lang_definitions` VALUES (5715, 4263, 3, 'Ener');
INSERT INTO `lang_definitions` VALUES (5716, 4264, 3, 'Enero');
INSERT INTO `lang_definitions` VALUES (5717, 4265, 3, 'Japonés');
INSERT INTO `lang_definitions` VALUES (5718, 4266, 3, 'Ictericia');
INSERT INTO `lang_definitions` VALUES (5719, 4268, 3, 'Descripción del trabajo');
INSERT INTO `lang_definitions` VALUES (5720, 4269, 3, 'Nº Identificación del trabajo');
INSERT INTO `lang_definitions` VALUES (5721, 4270, 3, 'Dislocaciones de articulaciones');
INSERT INTO `lang_definitions` VALUES (5722, 4271, 3, 'Dolor en las Articulaciones');
INSERT INTO `lang_definitions` VALUES (5723, 4272, 3, 'Esguinces de articulaciones');
INSERT INTO `lang_definitions` VALUES (5724, 4273, 3, 'Jul');
INSERT INTO `lang_definitions` VALUES (5725, 4274, 3, 'Julio');
INSERT INTO `lang_definitions` VALUES (5726, 4275, 3, 'Jun');
INSERT INTO `lang_definitions` VALUES (5727, 4276, 3, 'Junio');
INSERT INTO `lang_definitions` VALUES (5728, 4277, 3, 'Justo debajo, revise la información del área azul donde pone sus parámetros de búsqueda. Puede buscar por nombre del paciente, número de gráfico, número de visita o fecha de servicio, o cualquier combinación de éstos. También puede ver todas las facturas, facturas pendientes o impagadas (por el paciente). Click en el botón de búsqueda para realizar la búsqueda.');
INSERT INTO `lang_definitions` VALUES (5729, 4278, 3, 'Solo mío');
INSERT INTO `lang_definitions` VALUES (5730, 4280, 3, 'Justificar');
INSERT INTO `lang_definitions` VALUES (5731, 4282, 3, 'Justificar/Guardar');
INSERT INTO `lang_definitions` VALUES (5732, 4284, 3, 'k, aquí está el resto');
INSERT INTO `lang_definitions` VALUES (5733, 4293, 3, 'Clave');
INSERT INTO `lang_definitions` VALUES (5734, 4295, 3, 'Palabras Claves');
INSERT INTO `lang_definitions` VALUES (5735, 4296, 3, 'kg');
INSERT INTO `lang_definitions` VALUES (5736, 4297, 3, 'kg/m^2');
INSERT INTO `lang_definitions` VALUES (5737, 4299, 3, 'Cáncer de Riñon');
INSERT INTO `lang_definitions` VALUES (5738, 4300, 3, 'Fallo Renal');
INSERT INTO `lang_definitions` VALUES (5739, 4301, 3, 'Infecciones de Riñón');
INSERT INTO `lang_definitions` VALUES (5740, 4302, 3, 'Piedra en el Riñón');
INSERT INTO `lang_definitions` VALUES (5741, 4303, 3, 'Transplante de Riñon');
INSERT INTO `lang_definitions` VALUES (5742, 4308, 3, 'Rodilla');
INSERT INTO `lang_definitions` VALUES (5743, 4309, 3, 'Problemas de la rodilla');
INSERT INTO `lang_definitions` VALUES (5744, 4310, 3, 'Reemplazo de Rodilla');
INSERT INTO `lang_definitions` VALUES (5745, 4313, 3, 'Coreano');
INSERT INTO `lang_definitions` VALUES (5746, 4317, 3, 'Laboratorio');
INSERT INTO `lang_definitions` VALUES (5747, 4319, 3, 'Sitio Web del Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (5748, 4320, 3, 'Nº Identificación Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (5749, 4321, 3, 'Nº Identificación ficha Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (5750, 4325, 3, 'Consulta de estado de Laboratorio');
INSERT INTO `lang_definitions` VALUES (5751, 4326, 3, 'Informe del Laboratorio');
INSERT INTO `lang_definitions` VALUES (5752, 4327, 3, 'Resultado Laboratorio');
INSERT INTO `lang_definitions` VALUES (5753, 4328, 3, 'Resultados Laboratorio');
INSERT INTO `lang_definitions` VALUES (5754, 4331, 3, 'Informe Resultados Laboratorio');
INSERT INTO `lang_definitions` VALUES (5755, 4332, 3, 'Servicio de laboratorio');
INSERT INTO `lang_definitions` VALUES (5756, 4333, 3, 'Resultados del test de Laboratorio');
INSERT INTO `lang_definitions` VALUES (5757, 4335, 3, 'Etiqueta');
INSERT INTO `lang_definitions` VALUES (5758, 4336, 3, 'Etiqueta no puede estar en blanco');
INSERT INTO `lang_definitions` VALUES (5759, 4337, 3, 'Col etiqueta');
INSERT INTO `lang_definitions` VALUES (5760, 4338, 3, 'Etiqueta para este tipo');
INSERT INTO `lang_definitions` VALUES (5761, 4340, 3, 'EtiquetasColumn debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (5762, 4341, 3, 'Etiquetas');
INSERT INTO `lang_definitions` VALUES (5763, 4344, 3, 'Laboratorio');
INSERT INTO `lang_definitions` VALUES (5764, 4345, 3, 'Laceración/Cond. Piel');
INSERT INTO `lang_definitions` VALUES (5765, 4346, 3, 'Laceración/abrasión');
INSERT INTO `lang_definitions` VALUES (5766, 4351, 3, 'Idioma');
INSERT INTO `lang_definitions` VALUES (5767, 4352, 3, 'Código Idioma');
INSERT INTO `lang_definitions` VALUES (5768, 4353, 3, 'Definición de lenguaje agregada');
INSERT INTO `lang_definitions` VALUES (5769, 4354, 3, 'Herramienta de interfaz de idioma');
INSERT INTO `lang_definitions` VALUES (5770, 4356, 3, 'Lista de lenguajes (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (5771, 4358, 3, 'Nombre Idioma');
INSERT INTO `lang_definitions` VALUES (5772, 4359, 3, 'Idioma:');
INSERT INTO `lang_definitions` VALUES (5773, 4361, 3, 'Laosiano');
INSERT INTO `lang_definitions` VALUES (5774, 4364, 3, 'Último');
INSERT INTO `lang_definitions` VALUES (5775, 4365, 3, 'Última Actividad Fecha');
INSERT INTO `lang_definitions` VALUES (5776, 4367, 3, 'Última Fecha de Cuenta');
INSERT INTO `lang_definitions` VALUES (5777, 4369, 3, 'Último año calendario');
INSERT INTO `lang_definitions` VALUES (5778, 4373, 3, 'Última visita');
INSERT INTO `lang_definitions` VALUES (5779, 4380, 3, 'Último nivel facturado');
INSERT INTO `lang_definitions` VALUES (5780, 4384, 3, 'Último Mes');
INSERT INTO `lang_definitions` VALUES (5781, 4385, 3, 'Apellido(s)');
INSERT INTO `lang_definitions` VALUES (5782, 4386, 3, 'Apellido(s)');
INSERT INTO `lang_definitions` VALUES (5783, 4390, 3, 'Apellido(s):');
INSERT INTO `lang_definitions` VALUES (5784, 4394, 3, 'Ultima revision');
INSERT INTO `lang_definitions` VALUES (5785, 4396, 3, 'Última guardados');
INSERT INTO `lang_definitions` VALUES (5786, 4400, 3, 'Última actualización por');
INSERT INTO `lang_definitions` VALUES (5787, 4401, 3, 'Ultima verificación el');
INSERT INTO `lang_definitions` VALUES (5788, 4402, 3, 'Última Visita');
INSERT INTO `lang_definitions` VALUES (5789, 4404, 3, 'Recurrencia tardía (2-12 Mes)');
INSERT INTO `lang_definitions` VALUES (5790, 4405, 3, 'Maléolo lateral');
INSERT INTO `lang_definitions` VALUES (5791, 4406, 3, 'Maléolo lateral:');
INSERT INTO `lang_definitions` VALUES (5792, 4407, 3, 'Lateralidad');
INSERT INTO `lang_definitions` VALUES (5793, 4408, 3, 'Lateralidad de este procedimiento si se aplica');
INSERT INTO `lang_definitions` VALUES (5794, 4409, 3, 'desplazados lateralmente PMI:');
INSERT INTO `lang_definitions` VALUES (5795, 4412, 3, 'Últimos resultados únicamente');
INSERT INTO `lang_definitions` VALUES (5796, 4413, 3, 'Última Visita o Consula');
INSERT INTO `lang_definitions` VALUES (5797, 4414, 3, 'Latín');
INSERT INTO `lang_definitions` VALUES (5798, 4415, 3, 'Latvio');
INSERT INTO `lang_definitions` VALUES (5799, 4417, 3, 'Firma de Abogados');
INSERT INTO `lang_definitions` VALUES (5800, 4418, 3, 'Abogado');
INSERT INTO `lang_definitions` VALUES (5801, 4419, 3, 'Distribución en pantalla');
INSERT INTO `lang_definitions` VALUES (5802, 4420, 3, 'Distribución (necesita salir y entrar después de haber cambiado esta opción)');
INSERT INTO `lang_definitions` VALUES (5803, 4421, 3, 'de la base');
INSERT INTO `lang_definitions` VALUES (5804, 4423, 3, 'Redactor de Disposición');
INSERT INTO `lang_definitions` VALUES (5805, 4424, 3, 'Diseño de Grupos');
INSERT INTO `lang_definitions` VALUES (5806, 4427, 3, 'Estilo plantilla');
INSERT INTO `lang_definitions` VALUES (5807, 4429, 3, 'Diseño basado en la visita las formas');
INSERT INTO `lang_definitions` VALUES (5808, 4430, 3, 'Disposición');
INSERT INTO `lang_definitions` VALUES (5809, 4431, 3, 'libra');
INSERT INTO `lang_definitions` VALUES (5810, 4434, 3, 'libra');
INSERT INTO `lang_definitions` VALUES (5811, 4439, 3, 'Colesterol LDL');
INSERT INTO `lang_definitions` VALUES (5812, 4441, 3, 'dejar en blanco si sigue activo');
INSERT INTO `lang_definitions` VALUES (5813, 4442, 3, 'Dejar en blanco para mantener el nombre de fichero original');
INSERT INTO `lang_definitions` VALUES (5814, 4443, 3, 'Deje en blanco para no cambiar la contraseña');
INSERT INTO `lang_definitions` VALUES (5815, 4444, 3, 'Dejar mensaje Con');
INSERT INTO `lang_definitions` VALUES (5816, 4445, 3, 'Salir del Formulario');
INSERT INTO `lang_definitions` VALUES (5817, 4446, 3, 'Dejando la contraseña en blanco no se encriptará el documento');
INSERT INTO `lang_definitions` VALUES (5818, 4448, 3, 'Izquierda');
INSERT INTO `lang_definitions` VALUES (5819, 4449, 3, 'Brazo izquierdo');
INSERT INTO `lang_definitions` VALUES (5820, 4450, 3, 'Deltoide Izquierdo');
INSERT INTO `lang_definitions` VALUES (5821, 4451, 3, 'Oído izquierdo');
INSERT INTO `lang_definitions` VALUES (5822, 4452, 3, 'oreja izquierda');
INSERT INTO `lang_definitions` VALUES (5823, 4453, 3, 'Glúteo Medio Izquierdo');
INSERT INTO `lang_definitions` VALUES (5824, 4454, 3, 'Lente Izquierdo');
INSERT INTO `lang_definitions` VALUES (5825, 4456, 3, 'Margen Izquierdo (mm)');
INSERT INTO `lang_definitions` VALUES (5826, 4460, 3, 'Izquierda:');
INSERT INTO `lang_definitions` VALUES (5827, 4461, 3, 'Izquierda:');
INSERT INTO `lang_definitions` VALUES (5828, 4462, 3, 'Dolor de Pierna/Calambres');
INSERT INTO `lang_definitions` VALUES (5829, 4463, 3, 'Legal');
INSERT INTO `lang_definitions` VALUES (5830, 4465, 3, 'Tamaño papel Legal');
INSERT INTO `lang_definitions` VALUES (5831, 4466, 3, 'Leyenda:');
INSERT INTO `lang_definitions` VALUES (5832, 4467, 3, 'Longitud');
INSERT INTO `lang_definitions` VALUES (5833, 4468, 3, 'Longitud del modificador, 0 si no hay');
INSERT INTO `lang_definitions` VALUES (5834, 4474, 3, 'Menor que');
INSERT INTO `lang_definitions` VALUES (5835, 4475, 3, 'Menor que o Igual a');
INSERT INTO `lang_definitions` VALUES (5836, 4476, 3, 'Menos la información privada (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (5837, 4478, 3, 'Carta');
INSERT INTO `lang_definitions` VALUES (5838, 4479, 3, 'Carta');
INSERT INTO `lang_definitions` VALUES (5839, 4480, 3, 'Tamaño papel Carta');
INSERT INTO `lang_definitions` VALUES (5840, 4481, 3, 'Papelería membretada que el médico firma');
INSERT INTO `lang_definitions` VALUES (5841, 4482, 3, 'Papelería membretada que el paciente firma');
INSERT INTO `lang_definitions` VALUES (5842, 4485, 3, 'Nivel de urgencia');
INSERT INTO `lang_definitions` VALUES (5843, 4488, 3, 'Responsabilidad');
INSERT INTO `lang_definitions` VALUES (5844, 4489, 3, 'Responsabilidad Médica');
INSERT INTO `lang_definitions` VALUES (5845, 4491, 3, 'Licencia/Nº Id.');
INSERT INTO `lang_definitions` VALUES (5846, 4496, 3, 'Apellido del médico');
INSERT INTO `lang_definitions` VALUES (5847, 4497, 3, 'NºColegiado médico');
INSERT INTO `lang_definitions` VALUES (5848, 4498, 3, 'NºColegiado médico');
INSERT INTO `lang_definitions` VALUES (5849, 4501, 3, 'Estilo de Vida');
INSERT INTO `lang_definitions` VALUES (5850, 4502, 3, 'Estadio del estilo de vida');
INSERT INTO `lang_definitions` VALUES (5851, 4503, 3, 'Rasgón o esguince del ligamento');
INSERT INTO `lang_definitions` VALUES (5852, 4506, 3, 'Límite de Eventos');
INSERT INTO `lang_definitions` VALUES (5853, 4509, 3, 'Límites');
INSERT INTO `lang_definitions` VALUES (5854, 4512, 3, 'Vínculo');
INSERT INTO `lang_definitions` VALUES (5855, 4513, 3, 'Vínculo al paciente');
INSERT INTO `lang_definitions` VALUES (5856, 4514, 3, 'Vinculado');
INSERT INTO `lang_definitions` VALUES (5857, 4517, 3, 'Vinculado a un documento');
INSERT INTO `lang_definitions` VALUES (5858, 4519, 3, 'Lista');
INSERT INTO `lang_definitions` VALUES (5859, 4520, 3, 'Cuadro de lista');
INSERT INTO `lang_definitions` VALUES (5860, 4521, 3, 'caja de lista');
INSERT INTO `lang_definitions` VALUES (5861, 4522, 3, 'agrega cuadro de lista');
INSERT INTO `lang_definitions` VALUES (5862, 4523, 3, 'Lista de cuadro con adición');
INSERT INTO `lang_definitions` VALUES (5863, 4524, 3, 'Editor de Lista');
INSERT INTO `lang_definitions` VALUES (5864, 4525, 3, 'Lista de visitas');
INSERT INTO `lang_definitions` VALUES (5865, 4526, 3, 'Lista de grupos');
INSERT INTO `lang_definitions` VALUES (5866, 4527, 3, 'Lista Sociedades Médicas');
INSERT INTO `lang_definitions` VALUES (5867, 4529, 3, 'Lista de temas no puede comenzar con un número');
INSERT INTO `lang_definitions` VALUES (5868, 4530, 3, 'Items listados contienen caracteres ilegales');
INSERT INTO `lang_definitions` VALUES (5869, 4532, 3, 'Lista Listas');
INSERT INTO `lang_definitions` VALUES (5870, 4533, 3, 'Lista de Nombres');
INSERT INTO `lang_definitions` VALUES (5871, 4534, 3, 'Lista de los nombres no puede empezar con números.');
INSERT INTO `lang_definitions` VALUES (5872, 4537, 3, 'Lista de Recetas');
INSERT INTO `lang_definitions` VALUES (5873, 4538, 3, 'Lista Tipo de datos usada para País.');
INSERT INTO `lang_definitions` VALUES (5874, 4539, 3, 'Lista Tipo de datos usada para Estado.');
INSERT INTO `lang_definitions` VALUES (5875, 4540, 3, 'Puerto de escucha de la RFC 5425 TLS en el servidor syslog.');
INSERT INTO `lang_definitions` VALUES (5876, 4541, 3, 'Listas');
INSERT INTO `lang_definitions` VALUES (5877, 4544, 3, 'Deseos Personales de cuidado');
INSERT INTO `lang_definitions` VALUES (5878, 4548, 3, 'LLL:');
INSERT INTO `lang_definitions` VALUES (5879, 4554, 3, 'LMP');
INSERT INTO `lang_definitions` VALUES (5880, 4556, 3, 'Cargar definiciones');
INSERT INTO `lang_definitions` VALUES (5881, 4562, 3, 'Cargando');
INSERT INTO `lang_definitions` VALUES (5882, 4564, 3, 'Cargando ficheros en la base de datos. Esto puede tardar algún tiempo...');
INSERT INTO `lang_definitions` VALUES (5883, 4566, 3, 'LOC');
INSERT INTO `lang_definitions` VALUES (5884, 4567, 3, 'Local');
INSERT INTO `lang_definitions` VALUES (5885, 4570, 3, 'Lugar');
INSERT INTO `lang_definitions` VALUES (5886, 4571, 3, 'Localidad');
INSERT INTO `lang_definitions` VALUES (5887, 4572, 3, 'Localización');
INSERT INTO `lang_definitions` VALUES (5888, 4573, 3, 'Ubicación de la máquina openemr puede contener datos sensible, por eso se recomienda borrar manualmente los ficheros después de su uso');
INSERT INTO `lang_definitions` VALUES (5889, 4574, 3, 'Localizacion de este lote');
INSERT INTO `lang_definitions` VALUES (5890, 4575, 3, 'Lugar no especificado');
INSERT INTO `lang_definitions` VALUES (5891, 4576, 3, 'Directorio dónde Hylafax archiva los faxes');
INSERT INTO `lang_definitions` VALUES (5892, 4577, 3, 'Localización dónde se archivan los escaneados');
INSERT INTO `lang_definitions` VALUES (5893, 4578, 3, 'Localización:');
INSERT INTO `lang_definitions` VALUES (5894, 4579, 3, 'Bloquear');
INSERT INTO `lang_definitions` VALUES (5895, 4586, 3, 'Iniciar sesión');
INSERT INTO `lang_definitions` VALUES (5896, 4587, 3, 'Identificación');
INSERT INTO `lang_definitions` VALUES (5897, 4588, 3, 'Finalizar sesión');
INSERT INTO `lang_definitions` VALUES (5898, 4589, 3, 'Iniciar sesión');
INSERT INTO `lang_definitions` VALUES (5899, 4590, 3, 'Abierto una sesión como');
INSERT INTO `lang_definitions` VALUES (5900, 4591, 3, 'Abierto una sesión como:');
INSERT INTO `lang_definitions` VALUES (5901, 4592, 3, 'Salir de sesión.');
INSERT INTO `lang_definitions` VALUES (5902, 4593, 3, 'Identificando');
INSERT INTO `lang_definitions` VALUES (5903, 4594, 3, 'Iniciar sesión');
INSERT INTO `lang_definitions` VALUES (5904, 4595, 3, 'iniciar sesión');
INSERT INTO `lang_definitions` VALUES (5905, 4599, 3, 'Cerrar sesión');
INSERT INTO `lang_definitions` VALUES (5906, 4600, 3, 'cerrar sesión');
INSERT INTO `lang_definitions` VALUES (5907, 4601, 3, 'Registros');
INSERT INTO `lang_definitions` VALUES (5908, 4602, 3, 'Espectador de los registros');
INSERT INTO `lang_definitions` VALUES (5909, 4605, 3, 'Buscar');
INSERT INTO `lang_definitions` VALUES (5910, 4606, 3, 'Lote');
INSERT INTO `lang_definitions` VALUES (5911, 4607, 3, 'Nº Identificación del lote falta!');
INSERT INTO `lang_definitions` VALUES (5912, 4608, 3, 'Número de Lote');
INSERT INTO `lang_definitions` VALUES (5913, 4609, 3, 'Bajo');
INSERT INTO `lang_definitions` VALUES (5914, 4611, 3, 'inferior de la pierna');
INSERT INTO `lang_definitions` VALUES (5915, 4619, 3, 'Columna lumbar');
INSERT INTO `lang_definitions` VALUES (5916, 4620, 3, 'COMIDA');
INSERT INTO `lang_definitions` VALUES (5917, 4621, 3, 'Comida');
INSERT INTO `lang_definitions` VALUES (5918, 4622, 3, 'cáncer de pulmón');
INSERT INTO `lang_definitions` VALUES (5919, 4623, 3, 'Cirugía del cáncer de pulmón');
INSERT INTO `lang_definitions` VALUES (5920, 4624, 3, 'PULMONES:');
INSERT INTO `lang_definitions` VALUES (5921, 4625, 3, 'pulmones:');
INSERT INTO `lang_definitions` VALUES (5922, 4626, 3, 'Lupus');
INSERT INTO `lang_definitions` VALUES (5923, 4631, 3, 'M');
INSERT INTO `lang_definitions` VALUES (5924, 4632, 3, 'Categoría de MA');
INSERT INTO `lang_definitions` VALUES (5925, 4633, 3, 'MA Cliente acepta aborto');
INSERT INTO `lang_definitions` VALUES (5926, 4634, 3, 'MA estadísticas');
INSERT INTO `lang_definitions` VALUES (5927, 4639, 3, 'Correo enviado');
INSERT INTO `lang_definitions` VALUES (5928, 4640, 3, 'Principal');
INSERT INTO `lang_definitions` VALUES (5929, 4641, 3, 'Dirección principal');
INSERT INTO `lang_definitions` VALUES (5930, 4645, 3, 'Pantalla principal del panel superior');
INSERT INTO `lang_definitions` VALUES (5931, 4647, 3, 'Mantener activa la lista de medicación de alergia.');
INSERT INTO `lang_definitions` VALUES (5932, 4648, 3, 'Mantener activa una lista de medicación.');
INSERT INTO `lang_definitions` VALUES (5933, 4649, 3, 'Mantenga actualizada lista de problemas actuales y diagnósticos activos');
INSERT INTO `lang_definitions` VALUES (5934, 4650, 3, 'Hacer modificaciones a las actuales categorías.');
INSERT INTO `lang_definitions` VALUES (5935, 4651, 3, 'Dar nueva cita para');
INSERT INTO `lang_definitions` VALUES (5936, 4654, 3, 'Cerciorarse -');
INSERT INTO `lang_definitions` VALUES (5937, 4655, 3, 'Hacer un batch de ficheros de texto para adjuntar a la Cámara de compensación y que se marcará como facturado');
INSERT INTO `lang_definitions` VALUES (5938, 4657, 3, 'Malestar:');
INSERT INTO `lang_definitions` VALUES (5939, 4660, 3, 'Masculino');
INSERT INTO `lang_definitions` VALUES (5940, 4661, 3, 'Condones Masculinos');
INSERT INTO `lang_definitions` VALUES (5941, 4662, 3, 'Varón VSC');
INSERT INTO `lang_definitions` VALUES (5942, 4664, 3, 'Mamografía');
INSERT INTO `lang_definitions` VALUES (5943, 4665, 3, 'Manejar');
INSERT INTO `lang_definitions` VALUES (5944, 4671, 3, 'Gestionar traducciones');
INSERT INTO `lang_definitions` VALUES (5945, 4672, 3, 'Gerencia');
INSERT INTO `lang_definitions` VALUES (5946, 4675, 3, 'Campos obligatorios y específicos');
INSERT INTO `lang_definitions` VALUES (5947, 4676, 3, 'Campos obligatorios o específicos sólo, cheques duplicados, no de búsqueda');
INSERT INTO `lang_definitions` VALUES (5948, 4677, 3, 'Campos obligatorios o específicos sólo, búsqueda y comprobación de duplicados');
INSERT INTO `lang_definitions` VALUES (5949, 4680, 3, 'Manual');
INSERT INTO `lang_definitions` VALUES (5950, 4681, 3, 'Manual de envío');
INSERT INTO `lang_definitions` VALUES (5951, 4685, 3, 'Fabricante');
INSERT INTO `lang_definitions` VALUES (5952, 4689, 3, 'Mar');
INSERT INTO `lang_definitions` VALUES (5953, 4693, 3, 'Marzo');
INSERT INTO `lang_definitions` VALUES (5954, 4696, 3, 'Estado Civil');
INSERT INTO `lang_definitions` VALUES (5955, 4699, 3, 'Marcar como facturado pero saltar de facturación');
INSERT INTO `lang_definitions` VALUES (5956, 4700, 3, 'Marcar como Resueltos');
INSERT INTO `lang_definitions` VALUES (5957, 4701, 3, 'Marcar como no facturados');
INSERT INTO `lang_definitions` VALUES (5958, 4704, 3, 'Marcado como despejado');
INSERT INTO `lang_definitions` VALUES (5959, 4705, 3, 'Casado');
INSERT INTO `lang_definitions` VALUES (5960, 4707, 3, 'Formato (Máscara)');
INSERT INTO `lang_definitions` VALUES (5961, 4708, 3, 'Formato para Números de Factura');
INSERT INTO `lang_definitions` VALUES (5962, 4709, 3, 'Formato para ID de Pacientes');
INSERT INTO `lang_definitions` VALUES (5963, 4710, 3, 'Formato para ID de Productos');
INSERT INTO `lang_definitions` VALUES (5964, 4712, 3, 'Concuerda');
INSERT INTO `lang_definitions` VALUES (5965, 4723, 3, 'Max');
INSERT INTO `lang_definitions` VALUES (5966, 4727, 3, 'La derecha maxilar:');
INSERT INTO `lang_definitions` VALUES (5967, 4728, 3, 'Edad Máxima');
INSERT INTO `lang_definitions` VALUES (5968, 4729, 3, 'Número máximo de caracteres');
INSERT INTO `lang_definitions` VALUES (5969, 4730, 3, 'Tiempo máximo inactivo antes de cerrar sesión en segundos. Por defecto es 7200 (2 horas).');
INSERT INTO `lang_definitions` VALUES (5970, 4733, 3, 'Inventario máximo razonable, 0 si no es aplicable');
INSERT INTO `lang_definitions` VALUES (5971, 4734, 3, 'Tamaño máximo');
INSERT INTO `lang_definitions` VALUES (5972, 4735, 3, 'Tamaño máximo (poniendo 0 permite cualquier tamaño)');
INSERT INTO `lang_definitions` VALUES (5973, 4737, 3, 'Mayo');
INSERT INTO `lang_definitions` VALUES (5974, 4738, 3, 'MC');
INSERT INTO `lang_definitions` VALUES (5975, 4739, 3, 'mcg (microgramo)');
INSERT INTO `lang_definitions` VALUES (5976, 4741, 3, 'Significa que ninguna de las tres últimas contraseñas son permitidas para cambiar la contraseña.');
INSERT INTO `lang_definitions` VALUES (5977, 4743, 3, 'Medida del Código de Grupo');
INSERT INTO `lang_definitions` VALUES (5978, 4745, 3, 'Medición');
INSERT INTO `lang_definitions` VALUES (5979, 4747, 3, 'Maléolo tibial:');
INSERT INTO `lang_definitions` VALUES (5980, 4748, 3, 'Seguro de enfermedad');
INSERT INTO `lang_definitions` VALUES (5981, 4749, 3, 'Médico');
INSERT INTO `lang_definitions` VALUES (5982, 4750, 3, 'Aborto Médico');
INSERT INTO `lang_definitions` VALUES (5983, 4751, 3, 'Administración Médica');
INSERT INTO `lang_definitions` VALUES (5984, 4752, 3, 'Historia Médica');
INSERT INTO `lang_definitions` VALUES (5985, 4753, 3, 'Incidencia Médica');
INSERT INTO `lang_definitions` VALUES (5986, 4754, 3, 'Incidencia Médica');
INSERT INTO `lang_definitions` VALUES (5987, 4756, 3, 'Problema médico');
INSERT INTO `lang_definitions` VALUES (5988, 4758, 3, 'Problemas médicos');
INSERT INTO `lang_definitions` VALUES (5989, 4759, 3, 'Registo Médico');
INSERT INTO `lang_definitions` VALUES (5990, 4760, 3, 'Informe médico #');
INSERT INTO `lang_definitions` VALUES (5991, 4761, 3, 'Registros Médicos');
INSERT INTO `lang_definitions` VALUES (5992, 4763, 3, 'Registros Médicos enviados');
INSERT INTO `lang_definitions` VALUES (5993, 4765, 3, 'Resumen Médico entregado');
INSERT INTO `lang_definitions` VALUES (5994, 4766, 3, 'Sistema Médico');
INSERT INTO `lang_definitions` VALUES (5995, 4767, 3, 'Tipo de Médico');
INSERT INTO `lang_definitions` VALUES (5996, 4768, 3, 'Médico / Historia (escribir, añadir sólo opcional)');
INSERT INTO `lang_definitions` VALUES (5997, 4769, 3, 'Parte B de Seguro médico');
INSERT INTO `lang_definitions` VALUES (5998, 4770, 3, 'Seguro médico de referencia restablecido');
INSERT INTO `lang_definitions` VALUES (5999, 4771, 3, 'Medicación');
INSERT INTO `lang_definitions` VALUES (6000, 4772, 3, 'Lista Medicación Alergias');
INSERT INTO `lang_definitions` VALUES (6001, 4774, 3, 'Lista Medicación');
INSERT INTO `lang_definitions` VALUES (6002, 4775, 3, '¿Reconciliación Medicación realizada?');
INSERT INTO `lang_definitions` VALUES (6003, 4776, 3, 'Medicamentos');
INSERT INTO `lang_definitions` VALUES (6004, 4778, 3, 'Medicamentos:');
INSERT INTO `lang_definitions` VALUES (6005, 4779, 3, 'Unidades de Medicina');
INSERT INTO `lang_definitions` VALUES (6006, 4780, 3, 'Mediano');
INSERT INTO `lang_definitions` VALUES (6007, 4783, 3, 'Miembro de la Asociación de Estadística Informe');
INSERT INTO `lang_definitions` VALUES (6008, 4784, 3, 'Problemas de Memoria');
INSERT INTO `lang_definitions` VALUES (6009, 4785, 3, 'Hombres');
INSERT INTO `lang_definitions` VALUES (6010, 4786, 3, 'Hombres y Mujeres');
INSERT INTO `lang_definitions` VALUES (6011, 4787, 3, 'Hombres Solamente');
INSERT INTO `lang_definitions` VALUES (6012, 4788, 3, 'Menarquía');
INSERT INTO `lang_definitions` VALUES (6013, 4789, 3, 'Menopausia');
INSERT INTO `lang_definitions` VALUES (6014, 4790, 3, 'Flujo Menstrual');
INSERT INTO `lang_definitions` VALUES (6015, 4791, 3, 'Menstrual Frequency');
INSERT INTO `lang_definitions` VALUES (6016, 4792, 3, 'Enfermedad Mental');
INSERT INTO `lang_definitions` VALUES (6017, 4801, 3, 'Mensaje');
INSERT INTO `lang_definitions` VALUES (6018, 4802, 3, 'Mensajes y Centro de Avisos');
INSERT INTO `lang_definitions` VALUES (6019, 4807, 3, 'Mensaje Enviado');
INSERT INTO `lang_definitions` VALUES (6020, 4808, 3, 'Estado mensaje');
INSERT INTO `lang_definitions` VALUES (6021, 4813, 3, 'MENSAJE:');
INSERT INTO `lang_definitions` VALUES (6022, 4814, 3, 'Mensajes');
INSERT INTO `lang_definitions` VALUES (6023, 4816, 3, 'Mensajes enviados hoy');
INSERT INTO `lang_definitions` VALUES (6024, 4818, 3, 'Método');
INSERT INTO `lang_definitions` VALUES (6025, 4819, 3, 'Método y especificaciones de Producto');
INSERT INTO `lang_definitions` VALUES (6026, 4821, 3, 'Método para el envío de email saliente');
INSERT INTO `lang_definitions` VALUES (6027, 4822, 3, 'Método de destrucción');
INSERT INTO `lang_definitions` VALUES (6028, 4823, 3, 'Mejicano/MexAmer/Chicano');
INSERT INTO `lang_definitions` VALUES (6029, 4825, 3, 'mg');
INSERT INTO `lang_definitions` VALUES (6030, 4826, 3, 'mg/1cc');
INSERT INTO `lang_definitions` VALUES (6031, 4827, 3, 'mg/2cc');
INSERT INTO `lang_definitions` VALUES (6032, 4828, 3, 'mg/3cc');
INSERT INTO `lang_definitions` VALUES (6033, 4829, 3, 'mg/4cc');
INSERT INTO `lang_definitions` VALUES (6034, 4830, 3, 'mg/5cc');
INSERT INTO `lang_definitions` VALUES (6035, 4831, 3, 'MG/DL');
INSERT INTO `lang_definitions` VALUES (6036, 4833, 3, 'Segundo');
INSERT INTO `lang_definitions` VALUES (6037, 4834, 3, 'Segundo Nombre');
INSERT INTO `lang_definitions` VALUES (6038, 4835, 3, 'Segundo nombre');
INSERT INTO `lang_definitions` VALUES (6039, 4837, 3, 'Prescriptor DEA nivel medio');
INSERT INTO `lang_definitions` VALUES (6040, 4838, 3, 'Nombre Prescriptor nivel medio');
INSERT INTO `lang_definitions` VALUES (6041, 4839, 3, 'Apellido Prescriptor nivel medio');
INSERT INTO `lang_definitions` VALUES (6042, 4840, 3, 'Prefijo Prescriptor nivel medio');
INSERT INTO `lang_definitions` VALUES (6043, 4841, 3, 'Nº médico nivel medio');
INSERT INTO `lang_definitions` VALUES (6044, 4846, 3, 'Semblante');
INSERT INTO `lang_definitions` VALUES (6045, 4847, 3, 'Migrante o trabajador de temporada?');
INSERT INTO `lang_definitions` VALUES (6046, 4849, 3, 'Migrantes / temporada');
INSERT INTO `lang_definitions` VALUES (6047, 4850, 3, 'Mil/CU.MM');
INSERT INTO `lang_definitions` VALUES (6048, 4855, 3, 'Mime Tipo');
INSERT INTO `lang_definitions` VALUES (6049, 4856, 3, 'min');
INSERT INTO `lang_definitions` VALUES (6050, 4857, 3, 'Mínimo');
INSERT INTO `lang_definitions` VALUES (6051, 4859, 3, 'Edad Mínima');
INSERT INTO `lang_definitions` VALUES (6052, 4860, 3, 'Menor tensión conjunta /-Sinovitis');
INSERT INTO `lang_definitions` VALUES (6053, 4862, 3, 'Minuto');
INSERT INTO `lang_definitions` VALUES (6054, 4863, 3, 'minutos');
INSERT INTO `lang_definitions` VALUES (6055, 4864, 3, 'Minutos');
INSERT INTO `lang_definitions` VALUES (6056, 4866, 3, 'Varios');
INSERT INTO `lang_definitions` VALUES (6057, 4867, 3, 'Diversas opciones de facturación');
INSERT INTO `lang_definitions` VALUES (6058, 4868, 3, 'Diversas opciones de facturación para HCFA-1500');
INSERT INTO `lang_definitions` VALUES (6059, 4869, 3, 'Diversas opciones de facturación HCFA');
INSERT INTO `lang_definitions` VALUES (6060, 4870, 3, 'Varios');
INSERT INTO `lang_definitions` VALUES (6061, 4872, 3, 'Faltado');
INSERT INTO `lang_definitions` VALUES (6062, 4873, 3, 'No existe');
INSERT INTO `lang_definitions` VALUES (6063, 4874, 3, 'Falta campo requerido');
INSERT INTO `lang_definitions` VALUES (6064, 4876, 3, 'Falta cuota');
INSERT INTO `lang_definitions` VALUES (6065, 4877, 3, 'Solo modulos faltantes');
INSERT INTO `lang_definitions` VALUES (6066, 4878, 3, 'No existe o Inválido');
INSERT INTO `lang_definitions` VALUES (6067, 4879, 3, 'Falta el PID.');
INSERT INTO `lang_definitions` VALUES (6068, 4880, 3, 'Fecha de reporte falta');
INSERT INTO `lang_definitions` VALUES (6069, 4881, 3, 'Raya vertical que falta después del pagador en la fuente para el código');
INSERT INTO `lang_definitions` VALUES (6070, 4883, 3, 'Mixto');
INSERT INTO `lang_definitions` VALUES (6071, 4885, 3, 'ml');
INSERT INTO `lang_definitions` VALUES (6072, 4886, 3, 'MM/DD/AAAA');
INSERT INTO `lang_definitions` VALUES (6073, 4887, 3, 'mm/hg');
INSERT INTO `lang_definitions` VALUES (6074, 4888, 3, 'mmHg');
INSERT INTO `lang_definitions` VALUES (6075, 4889, 3, 'MMR 1');
INSERT INTO `lang_definitions` VALUES (6076, 4890, 3, 'MMR 2');
INSERT INTO `lang_definitions` VALUES (6077, 4892, 3, 'Móvil');
INSERT INTO `lang_definitions` VALUES (6078, 4893, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (6079, 4895, 3, 'Mod');
INSERT INTO `lang_definitions` VALUES (6080, 4903, 3, 'Modificador');
INSERT INTO `lang_definitions` VALUES (6081, 4909, 3, 'Modificadores');
INSERT INTO `lang_definitions` VALUES (6082, 4910, 3, 'Modificar');
INSERT INTO `lang_definitions` VALUES (6083, 4913, 3, 'Modificar Pagos');
INSERT INTO `lang_definitions` VALUES (6084, 4915, 3, 'Longitud Modelo');
INSERT INTO `lang_definitions` VALUES (6085, 4922, 3, 'Lun');
INSERT INTO `lang_definitions` VALUES (6086, 4923, 3, 'Lun a Vier');
INSERT INTO `lang_definitions` VALUES (6087, 4924, 3, 'Lunes, miércoles y viernes');
INSERT INTO `lang_definitions` VALUES (6088, 4925, 3, 'Lunes');
INSERT INTO `lang_definitions` VALUES (6089, 4929, 3, 'mes');
INSERT INTO `lang_definitions` VALUES (6090, 4930, 3, 'Mes');
INSERT INTO `lang_definitions` VALUES (6091, 4931, 3, 'Ver Mes');
INSERT INTO `lang_definitions` VALUES (6092, 4932, 3, 'Mes(es)');
INSERT INTO `lang_definitions` VALUES (6093, 4933, 3, 'Ingreso Mensual');
INSERT INTO `lang_definitions` VALUES (6094, 4935, 3, 'Meses');
INSERT INTO `lang_definitions` VALUES (6095, 4938, 3, 'Más de 100 registros encontrados. Por favor, reducir su criterio de búsqueda.');
INSERT INTO `lang_definitions` VALUES (6096, 4939, 3, 'Más de 50 resultados, por favor, hacer su búsqueda más específica.');
INSERT INTO `lang_definitions` VALUES (6097, 4940, 3, 'Puede hacer click en la mayoría de las cabeceras de columna para cambiar el orden');
INSERT INTO `lang_definitions` VALUES (6098, 4942, 3, 'Más reciente desde');
INSERT INTO `lang_definitions` VALUES (6099, 4945, 3, 'Constantes vitales mas recientes desde:');
INSERT INTO `lang_definitions` VALUES (6100, 4946, 3, 'Madre');
INSERT INTO `lang_definitions` VALUES (6101, 4947, 3, 'Nombre de la Madre');
INSERT INTO `lang_definitions` VALUES (6102, 4951, 3, 'Boca');
INSERT INTO `lang_definitions` VALUES (6103, 4952, 3, 'Movimiento');
INSERT INTO `lang_definitions` VALUES (6104, 4953, 3, 'Mueva el documento a la categoría:');
INSERT INTO `lang_definitions` VALUES (6105, 4954, 3, 'Mueve Abajo');
INSERT INTO `lang_definitions` VALUES (6106, 4957, 3, 'Mover al paciente');
INSERT INTO `lang_definitions` VALUES (6107, 4958, 3, 'Mover hacia...');
INSERT INTO `lang_definitions` VALUES (6108, 4959, 3, 'Mover Arriba');
INSERT INTO `lang_definitions` VALUES (6109, 4964, 3, 'Sr.');
INSERT INTO `lang_definitions` VALUES (6110, 4969, 3, 'Sra.');
INSERT INTO `lang_definitions` VALUES (6111, 4971, 3, 'Srta.');
INSERT INTO `lang_definitions` VALUES (6112, 4979, 3, 'Código MSP');
INSERT INTO `lang_definitions` VALUES (6113, 4981, 3, 'Herramienta multi idioma');
INSERT INTO `lang_definitions` VALUES (6114, 4983, 3, 'Múltiples áreas');
INSERT INTO `lang_definitions` VALUES (6115, 4986, 3, 'Lotes Multiples');
INSERT INTO `lang_definitions` VALUES (6116, 4987, 3, 'Múltiples modificadores pueden estar separados por dos puntos o espacios, máximo 4 (M1:M2:M3:M4)');
INSERT INTO `lang_definitions` VALUES (6117, 4990, 3, 'Multirracial');
INSERT INTO `lang_definitions` VALUES (6118, 4991, 3, 'Murmullos:');
INSERT INTO `lang_definitions` VALUES (6119, 4992, 3, 'Dolor de Musc');
INSERT INTO `lang_definitions` VALUES (6120, 4993, 3, 'Dolor muscular');
INSERT INTO `lang_definitions` VALUES (6121, 4994, 3, 'Rojez de Musc');
INSERT INTO `lang_definitions` VALUES (6122, 4995, 3, 'Tiesura de Musc');
INSERT INTO `lang_definitions` VALUES (6123, 4996, 3, 'Inflamación muscular');
INSERT INTO `lang_definitions` VALUES (6124, 4997, 3, 'Musc Caliente');
INSERT INTO `lang_definitions` VALUES (6125, 4998, 3, 'Músculo');
INSERT INTO `lang_definitions` VALUES (6126, 4999, 3, 'Lesiones musculares');
INSERT INTO `lang_definitions` VALUES (6127, 5000, 3, 'Musculoesquelético');
INSERT INTO `lang_definitions` VALUES (6128, 5003, 3, 'Debe estar vacío si la autenticación de SMTP no se usa.');
INSERT INTO `lang_definitions` VALUES (6129, 5005, 3, 'Definido mutuamente');
INSERT INTO `lang_definitions` VALUES (6130, 5006, 3, 'MVA');
INSERT INTO `lang_definitions` VALUES (6131, 5012, 3, 'Yo mismo');
INSERT INTO `lang_definitions` VALUES (6132, 5016, 3, 'No Aplicable');
INSERT INTO `lang_definitions` VALUES (6133, 5017, 3, 'no aplicable');
INSERT INTO `lang_definitions` VALUES (6134, 5019, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (6135, 5021, 3, 'Nombre (Selecciona por mas)');
INSERT INTO `lang_definitions` VALUES (6136, 5022, 3, 'Nombre 1');
INSERT INTO `lang_definitions` VALUES (6137, 5023, 3, 'Nombre 2');
INSERT INTO `lang_definitions` VALUES (6138, 5024, 3, 'Nombre y título del administrador de la Vacunación');
INSERT INTO `lang_definitions` VALUES (6139, 5027, 3, 'Nombre de Eventos');
INSERT INTO `lang_definitions` VALUES (6140, 5028, 3, 'Nombre de la Sociedad Médica');
INSERT INTO `lang_definitions` VALUES (6141, 5029, 3, 'Nombre del Facultativo');
INSERT INTO `lang_definitions` VALUES (6142, 5030, 3, 'Nombre del remitente para los recordatorios de paciente.');
INSERT INTO `lang_definitions` VALUES (6143, 5033, 3, 'Nombre de Traducción');
INSERT INTO `lang_definitions` VALUES (6144, 5034, 3, 'Nombre/Valor');
INSERT INTO `lang_definitions` VALUES (6145, 5035, 3, 'Nombre:');
INSERT INTO `lang_definitions` VALUES (6146, 5039, 3, 'NARES:');
INSERT INTO `lang_definitions` VALUES (6147, 5040, 3, 'NARES: Normal Derecho');
INSERT INTO `lang_definitions` VALUES (6148, 5043, 3, 'Mucosa nasal de color rosa, septo de línea media');
INSERT INTO `lang_definitions` VALUES (6149, 5044, 3, 'País Notas');
INSERT INTO `lang_definitions` VALUES (6150, 5047, 3, 'Configurar País Notas');
INSERT INTO `lang_definitions` VALUES (6151, 5049, 3, 'Nacionalidad');
INSERT INTO `lang_definitions` VALUES (6152, 5050, 3, 'PaísNotas');
INSERT INTO `lang_definitions` VALUES (6153, 5052, 3, 'Hawaino nativo u otras Islas del Pacífico');
INSERT INTO `lang_definitions` VALUES (6154, 5058, 3, 'Náuseas');
INSERT INTO `lang_definitions` VALUES (6155, 5060, 3, 'Navegación');
INSERT INTO `lang_definitions` VALUES (6156, 5061, 3, 'Área de navegación incluye formularios de visita');
INSERT INTO `lang_definitions` VALUES (6157, 5062, 3, 'El área de navegación usa la altura completa del marco');
INSERT INTO `lang_definitions` VALUES (6158, 5063, 3, 'Formulario Área Navegación de visita');
INSERT INTO `lang_definitions` VALUES (6159, 5064, 3, 'Ancho del área de navegación');
INSERT INTO `lang_definitions` VALUES (6160, 5065, 3, 'El menú de navegación consiste en pares de botones radiales');
INSERT INTO `lang_definitions` VALUES (6161, 5066, 3, 'El menú de navegación es una vista de árbol');
INSERT INTO `lang_definitions` VALUES (6162, 5067, 3, 'La navegación usa un menú deslizante');
INSERT INTO `lang_definitions` VALUES (6163, 5071, 3, 'NDC');
INSERT INTO `lang_definitions` VALUES (6164, 5072, 3, 'Datos NCD');
INSERT INTO `lang_definitions` VALUES (6165, 5073, 3, 'Número del NDC');
INSERT INTO `lang_definitions` VALUES (6166, 5084, 3, 'Cuello');
INSERT INTO `lang_definitions` VALUES (6167, 5085, 3, 'Problemas de Cuello');
INSERT INTO `lang_definitions` VALUES (6168, 5086, 3, 'Cuello flexible');
INSERT INTO `lang_definitions` VALUES (6169, 5088, 3, 'Necesidad de introducir una descripción');
INSERT INTO `lang_definitions` VALUES (6170, 5089, 3, 'Necesidad de introducir un Valor de Retorno');
INSERT INTO `lang_definitions` VALUES (6171, 5090, 3, 'Necesidad de entrar en el identificador');
INSERT INTO `lang_definitions` VALUES (6172, 5091, 3, 'Necesita introducir título');
INSERT INTO `lang_definitions` VALUES (6173, 5092, 3, 'Requiere autorización');
INSERT INTO `lang_definitions` VALUES (6174, 5093, 3, 'Requiere justificación');
INSERT INTO `lang_definitions` VALUES (6175, 5094, 3, 'Necesita la facturación secundaria');
INSERT INTO `lang_definitions` VALUES (6176, 5095, 3, 'Negativo');
INSERT INTO `lang_definitions` VALUES (6177, 5097, 3, 'Negativos');
INSERT INTO `lang_definitions` VALUES (6178, 5103, 3, 'Lesión del nervio');
INSERT INTO `lang_definitions` VALUES (6179, 5104, 3, 'Condición neural / daño en los nervios');
INSERT INTO `lang_definitions` VALUES (6180, 5106, 3, 'Entumecimiento Neuro');
INSERT INTO `lang_definitions` VALUES (6181, 5107, 3, 'Debilidad Neura');
INSERT INTO `lang_definitions` VALUES (6182, 5110, 3, 'Neurológico');
INSERT INTO `lang_definitions` VALUES (6183, 5114, 3, 'Nunca');
INSERT INTO `lang_definitions` VALUES (6184, 5115, 3, 'No Bebe Alcohol');
INSERT INTO `lang_definitions` VALUES (6185, 5116, 3, 'No Fumador');
INSERT INTO `lang_definitions` VALUES (6186, 5117, 3, 'Nuevo');
INSERT INTO `lang_definitions` VALUES (6187, 5118, 3, 'Nuevo =>');
INSERT INTO `lang_definitions` VALUES (6188, 5119, 3, 'Nuevos aceptadores');
INSERT INTO `lang_definitions` VALUES (6189, 5121, 3, 'Nueva alergia');
INSERT INTO `lang_definitions` VALUES (6190, 5123, 3, 'Cita Nueva');
INSERT INTO `lang_definitions` VALUES (6191, 5124, 3, 'Categoria Nueva');
INSERT INTO `lang_definitions` VALUES (6192, 5125, 3, 'Nueva Categoría');
INSERT INTO `lang_definitions` VALUES (6193, 5126, 3, 'Cliente Nuevo');
INSERT INTO `lang_definitions` VALUES (6194, 5127, 3, 'Nueva consulta');
INSERT INTO `lang_definitions` VALUES (6195, 5128, 3, 'Nuevo cultivo');
INSERT INTO `lang_definitions` VALUES (6196, 5129, 3, 'Nueva definición añadido');
INSERT INTO `lang_definitions` VALUES (6197, 5130, 3, 'Nuevo documento');
INSERT INTO `lang_definitions` VALUES (6198, 5134, 3, 'Nueva visita');
INSERT INTO `lang_definitions` VALUES (6199, 5135, 3, 'Nueva visita creada con id');
INSERT INTO `lang_definitions` VALUES (6200, 5136, 3, 'Formulario Nuevo Encuentro');
INSERT INTO `lang_definitions` VALUES (6201, 5137, 3, 'Nuevas visitas no autorizadas');
INSERT INTO `lang_definitions` VALUES (6202, 5138, 3, 'Nuevos Enctr');
INSERT INTO `lang_definitions` VALUES (6203, 5139, 3, 'Nueva información del Centro');
INSERT INTO `lang_definitions` VALUES (6204, 5143, 3, 'Grupo Nuevo');
INSERT INTO `lang_definitions` VALUES (6205, 5146, 3, 'Nuevo Grupo de Información');
INSERT INTO `lang_definitions` VALUES (6206, 5149, 3, 'Nueva lesión/estado');
INSERT INTO `lang_definitions` VALUES (6207, 5152, 3, 'Nuevo límite de Eventos');
INSERT INTO `lang_definitions` VALUES (6208, 5153, 3, 'Nueva Lista');
INSERT INTO `lang_definitions` VALUES (6209, 5157, 3, 'Nuevos pedidos');
INSERT INTO `lang_definitions` VALUES (6210, 5158, 3, 'Nuevo Párrafo');
INSERT INTO `lang_definitions` VALUES (6211, 5159, 3, 'Nueva Contraseña');
INSERT INTO `lang_definitions` VALUES (6212, 5160, 3, 'Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (6213, 5161, 3, 'NUEVO PACIENTE');
INSERT INTO `lang_definitions` VALUES (6214, 5162, 3, 'Nueva Visita de Paciente');
INSERT INTO `lang_definitions` VALUES (6215, 5163, 3, 'Formulario de Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (6216, 5164, 3, 'Nº Identificación de Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (6217, 5167, 3, 'Nuevo Pago');
INSERT INTO `lang_definitions` VALUES (6218, 5169, 3, 'Nuevos Pt');
INSERT INTO `lang_definitions` VALUES (6219, 5171, 3, 'Nuevos resultados del laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (6220, 5172, 3, 'Nueva Busqueda');
INSERT INTO `lang_definitions` VALUES (6221, 5173, 3, 'Nuevas sumisiones');
INSERT INTO `lang_definitions` VALUES (6222, 5174, 3, 'Nuevo Usuario');
INSERT INTO `lang_definitions` VALUES (6223, 5176, 3, 'Nueva visita');
INSERT INTO `lang_definitions` VALUES (6224, 5177, 3, 'Nuevo/búsqueda');
INSERT INTO `lang_definitions` VALUES (6225, 5178, 3, 'Estado de la cuenta NewCrop');
INSERT INTO `lang_definitions` VALUES (6226, 5179, 3, '*Administrador de NewCrop');
INSERT INTO `lang_definitions` VALUES (6227, 5180, 3, 'Llamada fallida a NewCrop');
INSERT INTO `lang_definitions` VALUES (6228, 5181, 3, 'Doctor NewCrop');
INSERT INTO `lang_definitions` VALUES (6229, 5186, 3, 'Nombre Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6230, 5187, 3, 'Nombre socio Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6231, 5188, 3, 'Contraseña Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6232, 5189, 3, 'Rol Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6233, 5190, 3, 'Rol Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6234, 5191, 3, 'Sitio Web Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6235, 5196, 3, 'Sitio Web servicio Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (6236, 5197, 3, 'Gerente NewCrop');
INSERT INTO `lang_definitions` VALUES (6237, 5198, 3, 'NewCrop MedEntry');
INSERT INTO `lang_definitions` VALUES (6238, 5199, 3, 'Médico nivel medio NewCrop');
INSERT INTO `lang_definitions` VALUES (6239, 5200, 3, 'Enfermera NewCrop');
INSERT INTO `lang_definitions` VALUES (6240, 5201, 3, 'Supervisor médico NewCrop');
INSERT INTO `lang_definitions` VALUES (6241, 5204, 3, 'Periódico');
INSERT INTO `lang_definitions` VALUES (6242, 5205, 3, 'Próximo');
INSERT INTO `lang_definitions` VALUES (6243, 5207, 3, 'Próximo Dia');
INSERT INTO `lang_definitions` VALUES (6244, 5208, 3, 'Próximo mes');
INSERT INTO `lang_definitions` VALUES (6245, 5209, 3, 'Proxima semana');
INSERT INTO `lang_definitions` VALUES (6246, 5214, 3, 'Próxima semana');
INSERT INTO `lang_definitions` VALUES (6247, 5215, 3, 'Año siguiente (Presione para el menu');
INSERT INTO `lang_definitions` VALUES (6248, 5217, 3, 'Apodo');
INSERT INTO `lang_definitions` VALUES (6249, 5219, 3, 'Sudores nocturnos');
INSERT INTO `lang_definitions` VALUES (6250, 5221, 3, 'Órganos genitales de la extensión de NL, mucosa de vag, cuello uterino');
INSERT INTO `lang_definitions` VALUES (6251, 5222, 3, 'NO');
INSERT INTO `lang_definitions` VALUES (6252, 5223, 3, 'No');
INSERT INTO `lang_definitions` VALUES (6253, 5225, 3, 'No tienen acceso');
INSERT INTO `lang_definitions` VALUES (6254, 5226, 3, 'Recordatorios de paciente no activos.');
INSERT INTO `lang_definitions` VALUES (6255, 5227, 3, 'No adenopatías (2 áreas requeridas)');
INSERT INTO `lang_definitions` VALUES (6256, 5228, 3, 'Ninguna razón de tipo de ajuste encontrada para');
INSERT INTO `lang_definitions` VALUES (6257, 5229, 3, 'No dolor/masa en anexos');
INSERT INTO `lang_definitions` VALUES (6258, 5232, 3, 'No hay citas');
INSERT INTO `lang_definitions` VALUES (6259, 5237, 3, 'Sistema de facturación no se encuentra activa');
INSERT INTO `lang_definitions` VALUES (6260, 5238, 3, 'No hay facturas encontradas para incluir en Exportación OFX');
INSERT INTO `lang_definitions` VALUES (6261, 5239, 3, 'No se encontraron cuentas para incluir en la exportación de OFX');
INSERT INTO `lang_definitions` VALUES (6262, 5241, 3, 'No se ha especificado el código!');
INSERT INTO `lang_definitions` VALUES (6263, 5245, 3, 'Sin Diagnóstico');
INSERT INTO `lang_definitions` VALUES (6264, 5248, 3, 'No documentos encontrados');
INSERT INTO `lang_definitions` VALUES (6265, 5249, 3, 'No pueden crearse visitas');
INSERT INTO `lang_definitions` VALUES (6266, 5251, 3, 'Sin fecha de finalización');
INSERT INTO `lang_definitions` VALUES (6267, 5252, 3, 'No se encuentran entradas, utilice el formulario que aparece a continuación para agregar una entrada.');
INSERT INTO `lang_definitions` VALUES (6268, 5253, 3, 'errores no encontrados');
INSERT INTO `lang_definitions` VALUES (6269, 5254, 3, 'No hay Eventos');
INSERT INTO `lang_definitions` VALUES (6270, 5256, 3, 'No hay ficheros preparados para la instalación');
INSERT INTO `lang_definitions` VALUES (6271, 5257, 3, 'Ningún grupo fue seleccionado');
INSERT INTO `lang_definitions` VALUES (6272, 5258, 3, 'Ninguna hernia');
INSERT INTO `lang_definitions` VALUES (6273, 5261, 3, 'No lesion/enfermedad');
INSERT INTO `lang_definitions` VALUES (6274, 5262, 3, 'No se encontro ninguna Sociedad Médica');
INSERT INTO `lang_definitions` VALUES (6275, 5264, 3, 'No hay incidencias');
INSERT INTO `lang_definitions` VALUES (6276, 5266, 3, 'No hay artículos bajo la categoría seleccionada');
INSERT INTO `lang_definitions` VALUES (6277, 5267, 3, '¡Ningun artículo fue seleccionado!');
INSERT INTO `lang_definitions` VALUES (6278, 5282, 3, 'No hay fichero de registro para la fecha seleccionada');
INSERT INTO `lang_definitions` VALUES (6279, 5285, 3, 'Sin masas ni sensibilidad');
INSERT INTO `lang_definitions` VALUES (6280, 5286, 3, 'Ningún registro de paciente encontrado para la Re-identificación dada');
INSERT INTO `lang_definitions` VALUES (6281, 5288, 3, 'No hay coincidencias. Intentar buscar de nuevo.');
INSERT INTO `lang_definitions` VALUES (6282, 5289, 3, 'No se han encontrado coincidencias.');
INSERT INTO `lang_definitions` VALUES (6283, 5290, 3, 'No se encontró. ¿Crear el nuevo paciente ahora?');
INSERT INTO `lang_definitions` VALUES (6284, 5291, 3, 'No hay registros coincidentes');
INSERT INTO `lang_definitions` VALUES (6285, 5294, 3, 'No hay nuevos resultados encontrados');
INSERT INTO `lang_definitions` VALUES (6286, 5295, 3, 'Ningunas notas');
INSERT INTO `lang_definitions` VALUES (6287, 5296, 3, 'No hay organomegalia');
INSERT INTO `lang_definitions` VALUES (6288, 5297, 3, 'No se encontraron huecos para este periodo.');
INSERT INTO `lang_definitions` VALUES (6289, 5298, 3, 'No figuran otros números de teléfono');
INSERT INTO `lang_definitions` VALUES (6290, 5300, 3, 'Socios no encontrados');
INSERT INTO `lang_definitions` VALUES (6291, 5301, 3, 'No hay registros de paciente encontrados para el criterio de selección dado');
INSERT INTO `lang_definitions` VALUES (6292, 5302, 3, 'No hay registros de paciente encontrados para el código de Re-identificación dado');
INSERT INTO `lang_definitions` VALUES (6293, 5303, 3, 'Ningún edema periférico');
INSERT INTO `lang_definitions` VALUES (6294, 5304, 3, 'Ninguna Farmacia Encontrada');
INSERT INTO `lang_definitions` VALUES (6295, 5305, 3, 'Ninguna Prescripción Encontrada');
INSERT INTO `lang_definitions` VALUES (6296, 5307, 3, 'Ninguna enfermedad/lesión actuales');
INSERT INTO `lang_definitions` VALUES (6297, 5308, 3, 'Sin entradas anteriores');
INSERT INTO `lang_definitions` VALUES (6298, 5309, 3, 'Ninguna Empresa Primaria seleccionada en la lista del Centro');
INSERT INTO `lang_definitions` VALUES (6299, 5313, 3, 'Ningun Facultativo Encontrado');
INSERT INTO `lang_definitions` VALUES (6300, 5314, 3, 'Ninguna erupción o lesiones anormales');
INSERT INTO `lang_definitions` VALUES (6301, 5316, 3, 'Registros no encontrados');
INSERT INTO `lang_definitions` VALUES (6302, 5318, 3, 'Registros no encontrados. Por favor amplíe sus criterios de búsqueda.');
INSERT INTO `lang_definitions` VALUES (6303, 5320, 3, 'No hay recordatorios');
INSERT INTO `lang_definitions` VALUES (6304, 5321, 3, 'Resultados no encontrados, para los criterios de búsqueda.');
INSERT INTO `lang_definitions` VALUES (6305, 5322, 3, 'Sin resultados');
INSERT INTO `lang_definitions` VALUES (6306, 5324, 3, 'Búsqueda sin resultado');
INSERT INTO `lang_definitions` VALUES (6307, 5325, 3, 'Ningun resultado, por favor intente de nuevo');
INSERT INTO `lang_definitions` VALUES (6308, 5326, 3, 'Sin resultados, por favor intente de nuevo');
INSERT INTO `lang_definitions` VALUES (6309, 5327, 3, 'Sin resultado, por favor intente de nuevo.');
INSERT INTO `lang_definitions` VALUES (6310, 5329, 3, 'Ausente');
INSERT INTO `lang_definitions` VALUES (6311, 5333, 3, 'Ninguna sensibilidad del Seno:');
INSERT INTO `lang_definitions` VALUES (6312, 5334, 3, 'Sin hoyuelos en la piel o nódulos en la mama');
INSERT INTO `lang_definitions` VALUES (6313, 5335, 3, 'NINGÚN NOMBRE DE CONTEXTO');
INSERT INTO `lang_definitions` VALUES (6314, 5337, 3, 'No hay sensibilidad testicular, masas');
INSERT INTO `lang_definitions` VALUES (6315, 5339, 3, 'Ningunas emociones o tirones');
INSERT INTO `lang_definitions` VALUES (6316, 5342, 3, 'No hay visita');
INSERT INTO `lang_definitions` VALUES (6317, 5343, 3, 'Constantes vitales no han sido documentadas.');
INSERT INTO `lang_definitions` VALUES (6318, 5344, 3, 'No, Cancelar');
INSERT INTO `lang_definitions` VALUES (6319, 5345, 3, 'Ningún seguro de defecto incluyendo Auto es principal');
INSERT INTO `lang_definitions` VALUES (6320, 5346, 3, 'No:');
INSERT INTO `lang_definitions` VALUES (6321, 5347, 3, 'Nocturia');
INSERT INTO `lang_definitions` VALUES (6322, 5348, 3, 'No Pagado');
INSERT INTO `lang_definitions` VALUES (6323, 5349, 3, 'Informe No Reportado');
INSERT INTO `lang_definitions` VALUES (6324, 5350, 3, 'Lesión no específica');
INSERT INTO `lang_definitions` VALUES (6325, 5351, 3, 'No-electrónico');
INSERT INTO `lang_definitions` VALUES (6326, 5352, 3, 'Non-insulin dependent diabetes');
INSERT INTO `lang_definitions` VALUES (6327, 5353, 3, 'No asegurado');
INSERT INTO `lang_definitions` VALUES (6328, 5355, 3, 'No-SRH Médico');
INSERT INTO `lang_definitions` VALUES (6329, 5356, 3, 'No-SRH No-Médico');
INSERT INTO `lang_definitions` VALUES (6330, 5357, 3, 'Ninguno');
INSERT INTO `lang_definitions` VALUES (6331, 5358, 3, 'ninguno');
INSERT INTO `lang_definitions` VALUES (6332, 5359, 3, 'No definido');
INSERT INTO `lang_definitions` VALUES (6333, 5361, 3, 'No ha sido documentado');
INSERT INTO `lang_definitions` VALUES (6334, 5362, 3, 'Ninguna de las anteriores');
INSERT INTO `lang_definitions` VALUES (6335, 5363, 3, 'Ninguna de las Filas de Distribución Superior puede estar Completamente en Blanco.');
INSERT INTO `lang_definitions` VALUES (6336, 5367, 3, 'Diabetes no insulino dependiente');
INSERT INTO `lang_definitions` VALUES (6337, 5368, 3, 'No');
INSERT INTO `lang_definitions` VALUES (6338, 5369, 3, 'Normal');
INSERT INTO `lang_definitions` VALUES (6339, 5371, 3, 'Normal BL');
INSERT INTO `lang_definitions` VALUES (6340, 5372, 3, 'Examen Cardiaco Normal:');
INSERT INTO `lang_definitions` VALUES (6341, 5373, 3, 'Examen Cardiaco Normal:');
INSERT INTO `lang_definitions` VALUES (6342, 5374, 3, 'Examen Normal del Pulmón:');
INSERT INTO `lang_definitions` VALUES (6343, 5375, 3, 'Examen Normal del Pulmón:');
INSERT INTO `lang_definitions` VALUES (6344, 5376, 3, 'Visita normal en el Centro');
INSERT INTO `lang_definitions` VALUES (6345, 5377, 3, 'Orofaringe normal:');
INSERT INTO `lang_definitions` VALUES (6346, 5378, 3, 'Derecho Normal');
INSERT INTO `lang_definitions` VALUES (6347, 5379, 3, 'Derecho Normal:');
INSERT INTO `lang_definitions` VALUES (6348, 5380, 3, 'Ver Normal');
INSERT INTO `lang_definitions` VALUES (6349, 5381, 3, 'normal:');
INSERT INTO `lang_definitions` VALUES (6350, 5382, 3, 'Normalmente esto debe ser comprobado. No relacionado con el control de acceso.');
INSERT INTO `lang_definitions` VALUES (6351, 5385, 3, 'Noruego');
INSERT INTO `lang_definitions` VALUES (6352, 5389, 3, 'Nariz');
INSERT INTO `lang_definitions` VALUES (6353, 5390, 3, 'Sangrado por la nariz');
INSERT INTO `lang_definitions` VALUES (6354, 5391, 3, 'No es letra ni úmero');
INSERT INTO `lang_definitions` VALUES (6355, 5394, 3, 'No todos los campos son obligatorios para todos los códigos o tipos de códigos.');
INSERT INTO `lang_definitions` VALUES (6356, 5395, 3, 'No permitido');
INSERT INTO `lang_definitions` VALUES (6357, 5396, 3, 'No pueden eliminar el grupo Administradores');
INSERT INTO `lang_definitions` VALUES (6358, 5397, 3, 'No permitido Editar');
INSERT INTO `lang_definitions` VALUES (6359, 5398, 3, 'No pueden inactivar todos los objetos de seguridad');
INSERT INTO `lang_definitions` VALUES (6360, 5399, 3, 'No permitido hacer inactivo cualquier cosa de los administradores ACL');
INSERT INTO `lang_definitions` VALUES (6361, 5400, 3, 'No pueden eliminar el usuario administrador del grupo Administradores');
INSERT INTO `lang_definitions` VALUES (6362, 5401, 3, 'No permitido eliminar este usuario del grupo de Administradores');
INSERT INTO `lang_definitions` VALUES (6363, 5403, 3, 'No autorizado para tener acceso al módulo de PostCalendar');
INSERT INTO `lang_definitions` VALUES (6364, 5404, 3, 'No autorizado');
INSERT INTO `lang_definitions` VALUES (6365, 5405, 3, 'No Autorizado');
INSERT INTO `lang_definitions` VALUES (6366, 5406, 3, '¡No autorizado para este equipo!');
INSERT INTO `lang_definitions` VALUES (6367, 5407, 3, 'No autorizados para este equipo.');
INSERT INTO `lang_definitions` VALUES (6368, 5411, 3, 'No disponible');
INSERT INTO `lang_definitions` VALUES (6369, 5413, 3, 'No facturado');
INSERT INTO `lang_definitions` VALUES (6370, 5414, 3, 'No Chequeado');
INSERT INTO `lang_definitions` VALUES (6371, 5415, 3, 'No registró salida');
INSERT INTO `lang_definitions` VALUES (6372, 5416, 3, 'No codificado');
INSERT INTO `lang_definitions` VALUES (6373, 5418, 3, 'No Vencido');
INSERT INTO `lang_definitions` VALUES (6374, 5420, 3, 'No examinado');
INSERT INTO `lang_definitions` VALUES (6375, 5421, 3, 'No Examinado:');
INSERT INTO `lang_definitions` VALUES (6376, 5422, 3, 'No Examinado:');
INSERT INTO `lang_definitions` VALUES (6377, 5424, 3, 'No encontrado');
INSERT INTO `lang_definitions` VALUES (6378, 5426, 3, 'No encontrado!');
INSERT INTO `lang_definitions` VALUES (6379, 5427, 3, 'No Hispano o Latino');
INSERT INTO `lang_definitions` VALUES (6380, 5428, 3, 'No instalado');
INSERT INTO `lang_definitions` VALUES (6381, 5431, 3, 'No visto desde');
INSERT INTO `lang_definitions` VALUES (6382, 5433, 3, 'No enviado todavía');
INSERT INTO `lang_definitions` VALUES (6383, 5435, 3, 'Sin Especificar');
INSERT INTO `lang_definitions` VALUES (6384, 5437, 3, 'Nota');
INSERT INTO `lang_definitions` VALUES (6385, 5438, 3, 'Código Notas');
INSERT INTO `lang_definitions` VALUES (6386, 5439, 3, 'Tenga en cuenta que el proceso completo después de hacer click en instalar puede tardar 5-10 minutos');
INSERT INTO `lang_definitions` VALUES (6387, 5440, 3, 'Tenga en cuenta que el proceso completo después de hacer click en actualizar puede tardar 5-10 minutos');
INSERT INTO `lang_definitions` VALUES (6388, 5441, 3, 'Tenga en cuenta que la Auditoría de inicio sesión necesita estar activada arriba');
INSERT INTO `lang_definitions` VALUES (6389, 5443, 3, 'Tipo de Nota');
INSERT INTO `lang_definitions` VALUES (6390, 5444, 3, 'Nota: 12:00 mediodía es PM, no AM');
INSERT INTO `lang_definitions` VALUES (6391, 5445, 3, 'NOTA: Importar datos externos puede tomar más de una hora dependiendo de su configuración hardware. Por ejemplo, una de las tablas de datos RxNorm contiene más de 6 millones de líneas.');
INSERT INTO `lang_definitions` VALUES (6392, 5446, 3, 'NOTA: Solo la versión Bianual Snomed Internacional es actualmente soportada');
INSERT INTO `lang_definitions` VALUES (6393, 5448, 3, 'NOTA: Solo la versión completa mensual de RxNorm es actualmente soportada');
INSERT INTO `lang_definitions` VALUES (6394, 5452, 3, 'Nota: este código no fue ingresado por un usuario autorizado. Sólo los códigos autorizados pueden ser subidos a la Red Abierta de facturación médica para su procesamiento. Si desea cargar estos códigos, por favor, seleccione un usuario autorizado aquí.');
INSERT INTO `lang_definitions` VALUES (6395, 5454, 3, 'Nota: este código no fue por un usuario autorizado. Sólo están autorizados los códigos pueden ser subidos a la Red Abierta de facturación médica para su procesamiento. Si desea cargar estos códigos, por favor, seleccione un usuario autorizado aquí.');
INSERT INTO `lang_definitions` VALUES (6396, 5455, 3, 'NOTA: Adjuntar ficheros con nombres duplicados hará que los ficheros sean automáticamente renombrados. Por ejemplo \' fichero.jpg\' se convertirá \' fichero.jpg.1\'. Los nombres de fichero se consideran únicos por paciente, no por categoría.');
INSERT INTO `lang_definitions` VALUES (6397, 5456, 3, 'Notas');
INSERT INTO `lang_definitions` VALUES (6398, 5458, 3, 'Notas - cualquier visita(escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (6399, 5460, 3, 'Notas - mis visitas(escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (6400, 5463, 3, 'Notas no autorizados');
INSERT INTO `lang_definitions` VALUES (6401, 5466, 3, 'Nada Grabado');
INSERT INTO `lang_definitions` VALUES (6402, 5468, 3, 'Nada que importar para alergia');
INSERT INTO `lang_definitions` VALUES (6403, 5469, 3, 'Nada que importar para receta');
INSERT INTO `lang_definitions` VALUES (6404, 5471, 3, 'Nada que mostrar');
INSERT INTO `lang_definitions` VALUES (6405, 5472, 3, 'Nada fue seleccionado');
INSERT INTO `lang_definitions` VALUES (6406, 5474, 3, 'AVISO:: Sumisión/modificación de PostCalendar');
INSERT INTO `lang_definitions` VALUES (6407, 5475, 3, 'Notificación');
INSERT INTO `lang_definitions` VALUES (6408, 5476, 3, 'Email para Notificación');
INSERT INTO `lang_definitions` VALUES (6409, 5481, 3, 'Notificaciones');
INSERT INTO `lang_definitions` VALUES (6410, 5482, 3, 'Notificar Administrador Acerca del Evento de envío/Modificación?');
INSERT INTO `lang_definitions` VALUES (6411, 5485, 3, 'Nov');
INSERT INTO `lang_definitions` VALUES (6412, 5486, 3, 'Noviembre');
INSERT INTO `lang_definitions` VALUES (6413, 5487, 3, 'Ahora envío para:');
INSERT INTO `lang_definitions` VALUES (6414, 5488, 3, 'Imprimiendo ahora');
INSERT INTO `lang_definitions` VALUES (6415, 5489, 3, 'Ahora impresión $stmt_count declaraciones y actualización de visitas.');
INSERT INTO `lang_definitions` VALUES (6416, 5490, 3, 'Ahora declaraciones de la impresión $stmt_count y facturas de la puesta al día.');
INSERT INTO `lang_definitions` VALUES (6417, 5491, 3, 'Ahora impresión $stmt_count declaraciones;visitas no serán actualizadas.');
INSERT INTO `lang_definitions` VALUES (6418, 5492, 3, 'Ahora declaraciones de la impresión $stmt_count; las facturas no serán actualizadas.');
INSERT INTO `lang_definitions` VALUES (6419, 5495, 3, 'NPI');
INSERT INTO `lang_definitions` VALUES (6420, 5496, 3, 'National Quality Forum');
INSERT INTO `lang_definitions` VALUES (6421, 5497, 3, 'Número');
INSERT INTO `lang_definitions` VALUES (6422, 5498, 3, 'Número laboratorio');
INSERT INTO `lang_definitions` VALUES (6423, 5503, 3, 'Número de columnas en vista/año.');
INSERT INTO `lang_definitions` VALUES (6424, 5510, 3, 'Número de días de validez para el certificado de cliente.');
INSERT INTO `lang_definitions` VALUES (6425, 5512, 3, 'Número de dígitos después del punto decimal, normalmente 0 o 2.');
INSERT INTO `lang_definitions` VALUES (6426, 5513, 3, 'Número de visitas por página');
INSERT INTO `lang_definitions` VALUES (6427, 5515, 3, 'Número de partidas o eventos perdidos, si hay');
INSERT INTO `lang_definitions` VALUES (6428, 5516, 3, 'Número de horas de antelación para enviar notificaciones por email.');
INSERT INTO `lang_definitions` VALUES (6429, 5517, 3, 'Número de horas de antelación para enviar notificaciones por teléfono.');
INSERT INTO `lang_definitions` VALUES (6430, 5518, 3, 'Número de horas de antelación para enviar notificaciones por SMS.');
INSERT INTO `lang_definitions` VALUES (6431, 5521, 3, 'Número de columnas para historia pasada');
INSERT INTO `lang_definitions` VALUES (6432, 5522, 3, 'Número de pacientes que mostrar por página en la lista de pacientes.');
INSERT INTO `lang_definitions` VALUES (6433, 5523, 3, 'Entumecimiento');
INSERT INTO `lang_definitions` VALUES (6434, 5524, 3, 'Numerador');
INSERT INTO `lang_definitions` VALUES (6435, 5525, 3, 'Orden Númerico mostrado');
INSERT INTO `lang_definitions` VALUES (6436, 5528, 3, 'Nutrición');
INSERT INTO `lang_definitions` VALUES (6437, 5530, 3, 'O.A.F.V.');
INSERT INTO `lang_definitions` VALUES (6438, 5531, 3, 'O2 sat');
INSERT INTO `lang_definitions` VALUES (6439, 5532, 3, 'Obesidad I');
INSERT INTO `lang_definitions` VALUES (6440, 5533, 3, 'Obesidad II');
INSERT INTO `lang_definitions` VALUES (6441, 5534, 3, 'Obesidad III');
INSERT INTO `lang_definitions` VALUES (6442, 5535, 3, 'Objetivo');
INSERT INTO `lang_definitions` VALUES (6443, 5544, 3, 'Ocupación');
INSERT INTO `lang_definitions` VALUES (6444, 5547, 3, 'Episodio');
INSERT INTO `lang_definitions` VALUES (6445, 5548, 3, 'Oct');
INSERT INTO `lang_definitions` VALUES (6446, 5549, 3, 'Octubre');
INSERT INTO `lang_definitions` VALUES (6447, 5550, 3, 'OD');
INSERT INTO `lang_definitions` VALUES (6448, 5553, 3, 'de');
INSERT INTO `lang_definitions` VALUES (6449, 5554, 3, 'de la cantidad');
INSERT INTO `lang_definitions` VALUES (6450, 5555, 3, 'de tabletas');
INSERT INTO `lang_definitions` VALUES (6451, 5556, 3, 'de cada mes');
INSERT INTO `lang_definitions` VALUES (6452, 5557, 3, 'Notas de la oficina');
INSERT INTO `lang_definitions` VALUES (6453, 5558, 3, 'Apagado');
INSERT INTO `lang_definitions` VALUES (6454, 5564, 3, 'Notas de la Oficina');
INSERT INTO `lang_definitions` VALUES (6455, 5565, 3, 'Visita en el Centro');
INSERT INTO `lang_definitions` VALUES (6456, 5566, 3, 'Medidas oficiales de calidad clínica (GCC) Grupos de medida');
INSERT INTO `lang_definitions` VALUES (6457, 5567, 3, 'Vínculo https para el Portal Externo del paciente.');
INSERT INTO `lang_definitions` VALUES (6458, 5568, 3, 'Vínculo Https para el Portal del Paciente Externo (Vínculo Paciente)');
INSERT INTO `lang_definitions` VALUES (6459, 5569, 3, 'Contraseña Portal del Paciente Externo');
INSERT INTO `lang_definitions` VALUES (6460, 5570, 3, 'Contraseña Portal del paciente externo (Dejar en blanco si no está registrado)');
INSERT INTO `lang_definitions` VALUES (6461, 5573, 3, 'Sitio Web del Portal del Paciente Externo');
INSERT INTO `lang_definitions` VALUES (6462, 5574, 3, 'Sitio web del Portal del Paciente Externo (Vínculo Paciente)');
INSERT INTO `lang_definitions` VALUES (6463, 5575, 3, 'Usuario del Portal del Paciente Externo');
INSERT INTO `lang_definitions` VALUES (6464, 5576, 3, 'Usuario del Portal del Paciente Externo (Dejar en blanco si no está registrado).');
INSERT INTO `lang_definitions` VALUES (6465, 5578, 3, 'Descendencia');
INSERT INTO `lang_definitions` VALUES (6466, 5581, 3, 'Ungüento');
INSERT INTO `lang_definitions` VALUES (6467, 5583, 3, 'Esta Bien');
INSERT INTO `lang_definitions` VALUES (6468, 5585, 3, 'OK para enlazar la incidencia GCAC fechada');
INSERT INTO `lang_definitions` VALUES (6469, 5586, 3, 'Viejo');
INSERT INTO `lang_definitions` VALUES (6470, 5588, 3, 'Clientes antiguos');
INSERT INTO `lang_definitions` VALUES (6471, 5589, 3, 'Fractura antigua no/malunión');
INSERT INTO `lang_definitions` VALUES (6472, 5590, 3, 'Diseño Estilo antiguo sin menú a la izquierda');
INSERT INTO `lang_definitions` VALUES (6473, 5591, 3, 'Formulario viejo-estilo sin buscar o comprobar duplicados');
INSERT INTO `lang_definitions` VALUES (6474, 5596, 3, 'Omitir información empleador en demográficos del paciente');
INSERT INTO `lang_definitions` VALUES (6475, 5597, 3, 'Omitir Empleador');
INSERT INTO `lang_definitions` VALUES (6476, 5598, 3, 'Forma omitida, vía e intervalo que serán parte de la dosis');
INSERT INTO `lang_definitions` VALUES (6477, 5599, 3, 'Omitir seguro y otras cosas en el formulario de demograficos');
INSERT INTO `lang_definitions` VALUES (6478, 5600, 3, '¿Omitir usuarios internos?');
INSERT INTO `lang_definitions` VALUES (6479, 5601, 3, 'Omitir método de pago para el panel de co-pago');
INSERT INTO `lang_definitions` VALUES (6480, 5602, 3, 'Omitir para firma automatico');
INSERT INTO `lang_definitions` VALUES (6481, 5603, 3, 'En');
INSERT INTO `lang_definitions` VALUES (6482, 5604, 3, 'en');
INSERT INTO `lang_definitions` VALUES (6483, 5606, 3, 'En mano');
INSERT INTO `lang_definitions` VALUES (6484, 5607, 3, 'En Orden');
INSERT INTO `lang_definitions` VALUES (6485, 5608, 3, 'En el sitio');
INSERT INTO `lang_definitions` VALUES (6486, 5614, 3, 'Una vez asignado el Centro para el negocio principal, no deberá ser cambiado. El cambio del Centro afectará al trabajo en NewCrop ePrescription.');
INSERT INTO `lang_definitions` VALUES (6487, 5615, 3, 'Una vez que cambie su contraseña, tendrá que volver a iniciar sesión.');
INSERT INTO `lang_definitions` VALUES (6488, 5624, 3, 'Soporte en línea');
INSERT INTO `lang_definitions` VALUES (6489, 5625, 3, 'Vínculo de soporte online');
INSERT INTO `lang_definitions` VALUES (6490, 5626, 3, 'Sólo activa');
INSERT INTO `lang_definitions` VALUES (6491, 5631, 3, 'sólo si es ubicación de facturación');
INSERT INTO `lang_definitions` VALUES (6492, 5632, 3, 'Sólo inactivo');
INSERT INTO `lang_definitions` VALUES (6493, 5633, 3, 'Sólo mio');
INSERT INTO `lang_definitions` VALUES (6494, 5636, 3, 'Sólo mostrar los Informes de códigos de diagnóstico');
INSERT INTO `lang_definitions` VALUES (6495, 5637, 3, 'Sólo mostrar Código de Servicio de Informes de Códigos de Finanzas');
INSERT INTO `lang_definitions` VALUES (6496, 5638, 3, 'Sólo subir las prescripciones activas');
INSERT INTO `lang_definitions` VALUES (6497, 5642, 3, 'Inicio Enfermedad:');
INSERT INTO `lang_definitions` VALUES (6498, 5643, 3, 'Inicio Enfermedad:');
INSERT INTO `lang_definitions` VALUES (6499, 5644, 3, 'Inicio de Hinchazón:');
INSERT INTO `lang_definitions` VALUES (6500, 5645, 3, 'Fecha de Inicio/hospital.:');
INSERT INTO `lang_definitions` VALUES (6501, 5649, 3, 'Sitio Web del Portal del Paciente Interno');
INSERT INTO `lang_definitions` VALUES (6502, 5652, 3, '¡Uy!');
INSERT INTO `lang_definitions` VALUES (6503, 5653, 3, 'Abrir');
INSERT INTO `lang_definitions` VALUES (6504, 5657, 3, 'Abrir en ventana nueva');
INSERT INTO `lang_definitions` VALUES (6505, 5663, 3, 'Abrir visitas para hoy');
INSERT INTO `lang_definitions` VALUES (6506, 5680, 3, 'OpenEMR ya tiene un Certificado de Autoridad Configurado');
INSERT INTO `lang_definitions` VALUES (6507, 5682, 3, 'Actualización base de datos OpenEMR');
INSERT INTO `lang_definitions` VALUES (6508, 5683, 3, 'Actualización base de datos OpenEMR para De-identificación');
INSERT INTO `lang_definitions` VALUES (6509, 5684, 3, 'OpenEMR no reconoce el archivo de entrada en el directorio contrib. Esto es probablemente porque necesita configurar la versión en la tabla supported_external_dataloads en la base de datos MySQL.');
INSERT INTO `lang_definitions` VALUES (6510, 5685, 3, 'OpenEMR debe configurarse para usar certificado antes de poder crear cliente');
INSERT INTO `lang_definitions` VALUES (6511, 5688, 3, 'OpenEMR requiere Javascript para realizar la autenticación de usuario.');
INSERT INTO `lang_definitions` VALUES (6512, 5689, 3, 'OpenEMR Usuarios');
INSERT INTO `lang_definitions` VALUES (6513, 5690, 3, 'Vacantes');
INSERT INTO `lang_definitions` VALUES (6514, 5695, 3, 'Oftálmico');
INSERT INTO `lang_definitions` VALUES (6515, 5698, 3, 'Opcion');
INSERT INTO `lang_definitions` VALUES (6516, 5699, 3, 'Opción para guardar el método de almacenamiento de documentos.');
INSERT INTO `lang_definitions` VALUES (6517, 5700, 3, 'Opción para soporte de inventario y ventas de productos');
INSERT INTO `lang_definitions` VALUES (6518, 5701, 3, 'Opcional');
INSERT INTO `lang_definitions` VALUES (6519, 5702, 3, 'Nombre de la categoría opcional para una imagen de la tarjeta de identificación que se puede ver desde la página de resumen del paciente.');
INSERT INTO `lang_definitions` VALUES (6520, 5703, 3, 'Nombre de la categoría opcional para una imagen de foto que se puede ver desde la página de resumen del paciente.');
INSERT INTO `lang_definitions` VALUES (6521, 5704, 3, 'Nombre de la categoría opcional de un documento para vincular desde la página de resumen del paciente. Haga click en el nombre del paciente para ver su tarjeta de identificación.');
INSERT INTO `lang_definitions` VALUES (6522, 5705, 3, 'Rango por defecto opcional para la entrada manual de los resultados');
INSERT INTO `lang_definitions` VALUES (6523, 5706, 3, 'Unidades opcionales por defecto para la entrada manual de los resultados');
INSERT INTO `lang_definitions` VALUES (6524, 5707, 3, 'Nombre de destino opcional');
INSERT INTO `lang_definitions` VALUES (6525, 5708, 3, 'Nombre opcional de medicamento, use % como comodín');
INSERT INTO `lang_definitions` VALUES (6526, 5712, 3, 'Información opcional sobre este evento');
INSERT INTO `lang_definitions` VALUES (6527, 5713, 3, 'Opcional número de lote, usar % como un comodin');
INSERT INTO `lang_definitions` VALUES (6528, 5714, 3, 'Nº Identificación Numérico opcional del paciente');
INSERT INTO `lang_definitions` VALUES (6529, 5715, 3, 'Código opcional del procedimiento');
INSERT INTO `lang_definitions` VALUES (6530, 5716, 3, 'Código procedimiento/servicio opcional');
INSERT INTO `lang_definitions` VALUES (6531, 5717, 3, 'Opciones');
INSERT INTO `lang_definitions` VALUES (6532, 5718, 3, 'O');
INSERT INTO `lang_definitions` VALUES (6533, 5719, 3, 'ó');
INSERT INTO `lang_definitions` VALUES (6534, 5720, 3, 'o elija');
INSERT INTO `lang_definitions` VALUES (6535, 5721, 3, 'o Selecciona y arrastrar para selección mas rapida');
INSERT INTO `lang_definitions` VALUES (6536, 5723, 3, 'O hacia fuera a');
INSERT INTO `lang_definitions` VALUES (6537, 5725, 3, 'o Shif-Selecciona para reducirlo');
INSERT INTO `lang_definitions` VALUES (6538, 5726, 3, 'O adjuntar fichero ERA:');
INSERT INTO `lang_definitions` VALUES (6539, 5728, 3, 'Oral');
INSERT INTO `lang_definitions` VALUES (6540, 5729, 3, 'Mucosa oral rosada, garganta clara');
INSERT INTO `lang_definitions` VALUES (6541, 5730, 3, 'Orden');
INSERT INTO `lang_definitions` VALUES (6542, 5731, 3, 'Orden y tipo de resultados');
INSERT INTO `lang_definitions` VALUES (6543, 5732, 3, 'Catálogo de órdenes');
INSERT INTO `lang_definitions` VALUES (6544, 5733, 3, 'Fecha pedido');
INSERT INTO `lang_definitions` VALUES (6545, 5735, 3, 'Formulario de pedido');
INSERT INTO `lang_definitions` VALUES (6546, 5737, 3, 'Orden debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (6547, 5739, 3, 'Nombre pedido');
INSERT INTO `lang_definitions` VALUES (6548, 5740, 3, 'Solicitud Prioridades');
INSERT INTO `lang_definitions` VALUES (6549, 5741, 3, 'Orden de Procesamiento');
INSERT INTO `lang_definitions` VALUES (6550, 5744, 3, 'estatus de la orden');
INSERT INTO `lang_definitions` VALUES (6551, 5747, 3, 'tipo de orden');
INSERT INTO `lang_definitions` VALUES (6552, 5749, 3, 'Tipo de orden/resultado');
INSERT INTO `lang_definitions` VALUES (6553, 5750, 3, 'Ordenado');
INSERT INTO `lang_definitions` VALUES (6554, 5753, 3, 'Profesional que ordeno');
INSERT INTO `lang_definitions` VALUES (6555, 5756, 3, 'Lesión de órganos');
INSERT INTO `lang_definitions` VALUES (6556, 5757, 3, 'Organización');
INSERT INTO `lang_definitions` VALUES (6557, 5758, 3, 'Nombre de organización');
INSERT INTO `lang_definitions` VALUES (6558, 5759, 3, 'Nombre de la unidad organizacional');
INSERT INTO `lang_definitions` VALUES (6559, 5760, 3, 'Organizacións');
INSERT INTO `lang_definitions` VALUES (6560, 5761, 3, 'Orientada x 3');
INSERT INTO `lang_definitions` VALUES (6561, 5763, 3, 'Original');
INSERT INTO `lang_definitions` VALUES (6562, 5769, 3, 'OROFARINGE:');
INSERT INTO `lang_definitions` VALUES (6563, 5772, 3, 'Orthopnea');
INSERT INTO `lang_definitions` VALUES (6564, 5776, 3, 'OS');
INSERT INTO `lang_definitions` VALUES (6565, 5777, 3, 'Osteoartritis');
INSERT INTO `lang_definitions` VALUES (6566, 5781, 3, 'Otro');
INSERT INTO `lang_definitions` VALUES (6567, 5783, 3, 'otro');
INSERT INTO `lang_definitions` VALUES (6568, 5784, 3, 'Otro (especifique)');
INSERT INTO `lang_definitions` VALUES (6569, 5785, 3, 'Otros - especificado');
INSERT INTO `lang_definitions` VALUES (6570, 5788, 3, 'Otro Progama Federal');
INSERT INTO `lang_definitions` VALUES (6571, 5789, 3, 'Otro HCFA');
INSERT INTO `lang_definitions` VALUES (6572, 5790, 3, 'Otra lesión en otra parte especificada');
INSERT INTO `lang_definitions` VALUES (6573, 5791, 3, 'Otro Seguro de Responsabilidad Civil es Primario');
INSERT INTO `lang_definitions` VALUES (6574, 5792, 3, 'Otro mes');
INSERT INTO `lang_definitions` VALUES (6575, 5793, 3, 'Otros programas No-Federales');
INSERT INTO `lang_definitions` VALUES (6576, 5794, 3, 'Otras Notas');
INSERT INTO `lang_definitions` VALUES (6577, 5795, 3, 'Otros síntomas pertinentes');
INSERT INTO `lang_definitions` VALUES (6578, 5796, 3, 'Otros síntomas pertinentes:');
INSERT INTO `lang_definitions` VALUES (6579, 5799, 3, 'Otra respuesta del paciente');
INSERT INTO `lang_definitions` VALUES (6580, 5801, 3, 'Otros tipos de estrés/lesión uso en');
INSERT INTO `lang_definitions` VALUES (6581, 5802, 3, 'Otro Quirúrgico');
INSERT INTO `lang_definitions` VALUES (6582, 5803, 3, 'Otro/Genérico relacionado con Aborto');
INSERT INTO `lang_definitions` VALUES (6583, 5805, 3, 'Otros');
INSERT INTO `lang_definitions` VALUES (6584, 5806, 3, 'De otra forma usted destruirá las referencias a/de los datos existentes');
INSERT INTO `lang_definitions` VALUES (6585, 5807, 3, 'Reglas de tobillo de Ottawa');
INSERT INTO `lang_definitions` VALUES (6586, 5808, 3, 'OU');
INSERT INTO `lang_definitions` VALUES (6587, 5810, 3, 'SALIDA');
INSERT INTO `lang_definitions` VALUES (6588, 5811, 3, 'Salida');
INSERT INTO `lang_definitions` VALUES (6589, 5813, 3, 'Derivación de salida');
INSERT INTO `lang_definitions` VALUES (6590, 5814, 3, 'Resultado');
INSERT INTO `lang_definitions` VALUES (6591, 5817, 3, 'Outlook');
INSERT INTO `lang_definitions` VALUES (6592, 5823, 3, 'VENCIDO');
INSERT INTO `lang_definitions` VALUES (6593, 5827, 3, 'Sobreuso');
INSERT INTO `lang_definitions` VALUES (6594, 5828, 3, 'Información General');
INSERT INTO `lang_definitions` VALUES (6595, 5829, 3, 'Sobrepeso');
INSERT INTO `lang_definitions` VALUES (6596, 5830, 3, 'Sobrescribir la elección HIPAA');
INSERT INTO `lang_definitions` VALUES (6597, 5832, 3, 'Saturación del Oxígeno');
INSERT INTO `lang_definitions` VALUES (6598, 5834, 3, 'P');
INSERT INTO `lang_definitions` VALUES (6599, 5835, 3, 'p.c.');
INSERT INTO `lang_definitions` VALUES (6600, 5836, 3, 'p.m.');
INSERT INTO `lang_definitions` VALUES (6601, 5837, 3, 'p.r.n.');
INSERT INTO `lang_definitions` VALUES (6602, 5841, 3, 'Isleño del Pacifico');
INSERT INTO `lang_definitions` VALUES (6603, 5842, 3, 'Paedeatric');
INSERT INTO `lang_definitions` VALUES (6604, 5843, 3, 'Página');
INSERT INTO `lang_definitions` VALUES (6605, 5845, 3, 'Páginas');
INSERT INTO `lang_definitions` VALUES (6606, 5846, 3, 'Pago');
INSERT INTO `lang_definitions` VALUES (6607, 5847, 3, 'Cantidad pagada que usted asignará');
INSERT INTO `lang_definitions` VALUES (6608, 5848, 3, 'Importe pagado');
INSERT INTO `lang_definitions` VALUES (6609, 5849, 3, 'Pagado Via');
INSERT INTO `lang_definitions` VALUES (6610, 5850, 3, 'Dolor');
INSERT INTO `lang_definitions` VALUES (6611, 5853, 3, 'Palpitaciones');
INSERT INTO `lang_definitions` VALUES (6612, 5857, 3, 'Prueba de Papanicolaou');
INSERT INTO `lang_definitions` VALUES (6613, 5858, 3, 'Papel');
INSERT INTO `lang_definitions` VALUES (6614, 5859, 3, 'Tamaño papel');
INSERT INTO `lang_definitions` VALUES (6615, 5860, 3, 'Parálisis');
INSERT INTO `lang_definitions` VALUES (6616, 5866, 3, 'Analizar HL7');
INSERT INTO `lang_definitions` VALUES (6617, 5871, 3, 'Socio');
INSERT INTO `lang_definitions` VALUES (6618, 5872, 3, 'Nombre Socio');
INSERT INTO `lang_definitions` VALUES (6619, 5875, 3, 'Frase Contraseña');
INSERT INTO `lang_definitions` VALUES (6620, 5876, 3, 'Frase Contraseña para desencriptar documento');
INSERT INTO `lang_definitions` VALUES (6621, 5877, 3, 'Pacientes pasados');
INSERT INTO `lang_definitions` VALUES (6622, 5878, 3, 'Alerta Pasiva');
INSERT INTO `lang_definitions` VALUES (6623, 5879, 3, 'Reglas de Alerta Pasiva');
INSERT INTO `lang_definitions` VALUES (6624, 5881, 3, 'Contraseña');
INSERT INTO `lang_definitions` VALUES (6625, 5882, 3, 'Cambio de la contraseña');
INSERT INTO `lang_definitions` VALUES (6626, 5884, 3, 'Cambio de contraseña con éxito.');
INSERT INTO `lang_definitions` VALUES (6627, 5886, 3, 'Periodo de Gracia de Expiración de Contraseña');
INSERT INTO `lang_definitions` VALUES (6628, 5888, 3, 'Contraseña para puerta de enlace telefónico. Servicio automático de VOIP desarrollado por Maviq. Por favor visite http://signup.maviq.com para más información.');
INSERT INTO `lang_definitions` VALUES (6629, 5889, 3, 'Contraseña para puerta de enlace SMS.');
INSERT INTO `lang_definitions` VALUES (6630, 5890, 3, 'Contraseña para puerta de enlace SMS.');
INSERT INTO `lang_definitions` VALUES (6631, 5892, 3, 'Contraseña de seguridad ha sido recientemente actualizada.');
INSERT INTO `lang_definitions` VALUES (6632, 5893, 3, 'Contraseña para conectar a CouchDB');
INSERT INTO `lang_definitions` VALUES (6633, 5895, 3, 'Contraseña');
INSERT INTO `lang_definitions` VALUES (6634, 5904, 3, 'Vencimiento');
INSERT INTO `lang_definitions` VALUES (6635, 5905, 3, 'Vencimiento');
INSERT INTO `lang_definitions` VALUES (6636, 5906, 3, 'Intervalo Vencido (Recordatorios clínicos)');
INSERT INTO `lang_definitions` VALUES (6637, 5907, 3, 'Intervalo Vencido (Recordatorios Paciente)');
INSERT INTO `lang_definitions` VALUES (6638, 5908, 3, 'Lista de visitas anteriores');
INSERT INTO `lang_definitions` VALUES (6639, 5909, 3, 'Anteriores visitas');
INSERT INTO `lang_definitions` VALUES (6640, 5910, 3, 'Anteriores visitas y Documentos');
INSERT INTO `lang_definitions` VALUES (6641, 5911, 3, 'Anteriores visitas de');
INSERT INTO `lang_definitions` VALUES (6642, 5919, 3, 'Pegar datos HL7');
INSERT INTO `lang_definitions` VALUES (6643, 5920, 3, 'Pegar los datos de importación en el área de texto a continuación:');
INSERT INTO `lang_definitions` VALUES (6644, 5921, 3, 'Paciente');
INSERT INTO `lang_definitions` VALUES (6645, 5923, 3, 'Parche');
INSERT INTO `lang_definitions` VALUES (6646, 5929, 3, 'Ruta de backup del log de eventos');
INSERT INTO `lang_definitions` VALUES (6647, 5930, 3, 'Ruta del fichero de certificado CA');
INSERT INTO `lang_definitions` VALUES (6648, 5931, 3, 'Ruta del fichero clave CA');
INSERT INTO `lang_definitions` VALUES (6649, 5932, 3, 'Ruta de ficheros binarios MySQL');
INSERT INTO `lang_definitions` VALUES (6650, 5933, 3, 'Ruta de ficheros binarios Perl');
INSERT INTO `lang_definitions` VALUES (6651, 5934, 3, 'Ruta de los ficheros temporales');
INSERT INTO `lang_definitions` VALUES (6652, 5935, 3, 'Paciente');
INSERT INTO `lang_definitions` VALUES (6653, 5936, 3, 'paciente');
INSERT INTO `lang_definitions` VALUES (6654, 5937, 3, 'PACIENTE');
INSERT INTO `lang_definitions` VALUES (6655, 5939, 3, 'Dirección del paciente');
INSERT INTO `lang_definitions` VALUES (6656, 5940, 3, 'Falta la dirección del paciente');
INSERT INTO `lang_definitions` VALUES (6657, 5943, 3, 'Alergias del Paciente');
INSERT INTO `lang_definitions` VALUES (6658, 5944, 3, 'Alergias del Paciente');
INSERT INTO `lang_definitions` VALUES (6659, 5946, 3, 'Cita del Paciente');
INSERT INTO `lang_definitions` VALUES (6660, 5947, 3, 'Balance de paciente');
INSERT INTO `lang_definitions` VALUES (6661, 5952, 3, 'Nº Identificación del gráfico del paciente');
INSERT INTO `lang_definitions` VALUES (6662, 5954, 3, 'Comprobación de paciente');
INSERT INTO `lang_definitions` VALUES (6663, 5955, 3, 'Comprobación de paciente para');
INSERT INTO `lang_definitions` VALUES (6664, 5956, 3, 'Ciudad del Paciente');
INSERT INTO `lang_definitions` VALUES (6665, 5957, 3, 'Falta la ciudad del paciente');
INSERT INTO `lang_definitions` VALUES (6666, 5959, 3, 'Comunicación Enviada al Paciente');
INSERT INTO `lang_definitions` VALUES (6667, 5960, 3, 'Comunicación Enviada al Paciente');
INSERT INTO `lang_definitions` VALUES (6668, 5961, 3, 'Pais del Paciente');
INSERT INTO `lang_definitions` VALUES (6669, 5962, 3, 'Falta la ciudad del paciente. Tampoco ha configurado la ciudad del paciente por defecto en la configuración global');
INSERT INTO `lang_definitions` VALUES (6670, 5963, 3, 'Cobertura de paciente');
INSERT INTO `lang_definitions` VALUES (6671, 5967, 3, 'Datos del Paciente');
INSERT INTO `lang_definitions` VALUES (6672, 5969, 3, 'Falta la F.Nacimiento del paciente');
INSERT INTO `lang_definitions` VALUES (6673, 5972, 3, 'Detalles del Paciente');
INSERT INTO `lang_definitions` VALUES (6674, 5973, 3, 'F.Nacimiento del Paciente');
INSERT INTO `lang_definitions` VALUES (6675, 5975, 3, 'Documentos del Paciente');
INSERT INTO `lang_definitions` VALUES (6676, 5979, 3, 'Material Educativo para el Paciente');
INSERT INTO `lang_definitions` VALUES (6677, 5980, 3, 'Materiales educativos para pacientes');
INSERT INTO `lang_definitions` VALUES (6678, 5981, 3, 'Visitas del Paciente');
INSERT INTO `lang_definitions` VALUES (6679, 5982, 3, 'Formulario de visitas del Paciente');
INSERT INTO `lang_definitions` VALUES (6680, 5983, 3, 'Visitas de Pacientes');
INSERT INTO `lang_definitions` VALUES (6681, 5984, 3, 'Buscador de paciente');
INSERT INTO `lang_definitions` VALUES (6682, 5986, 3, 'Nombre del Paciente');
INSERT INTO `lang_definitions` VALUES (6683, 5988, 3, 'Falta el nombre del paciente');
INSERT INTO `lang_definitions` VALUES (6684, 5993, 3, 'Género del Paciente');
INSERT INTO `lang_definitions` VALUES (6685, 5994, 3, 'Falta el género del paciente');
INSERT INTO `lang_definitions` VALUES (6686, 5995, 3, 'Paciente no autorizado al Portal del paciente');
INSERT INTO `lang_definitions` VALUES (6687, 5996, 3, 'Historia del Paciente');
INSERT INTO `lang_definitions` VALUES (6688, 5997, 3, 'Historia del Paciente/Estilo de Vida');
INSERT INTO `lang_definitions` VALUES (6689, 5998, 3, 'Teléfono Casa del Paciente');
INSERT INTO `lang_definitions` VALUES (6690, 5999, 3, 'ID Paciente');
INSERT INTO `lang_definitions` VALUES (6691, 6000, 3, 'Nº Identificación del Paciente');
INSERT INTO `lang_definitions` VALUES (6692, 6001, 3, 'Nº Identificación Tarjeta del Paciente');
INSERT INTO `lang_definitions` VALUES (6693, 6002, 3, 'Nombre categoría ID paciente');
INSERT INTO `lang_definitions` VALUES (6694, 6004, 3, 'Vacunación del paciente');
INSERT INTO `lang_definitions` VALUES (6695, 6005, 3, 'Información del Paciente');
INSERT INTO `lang_definitions` VALUES (6696, 6007, 3, 'Instrucciones al paciente');
INSERT INTO `lang_definitions` VALUES (6697, 6008, 3, 'Distribución de pacientes Asegurados');
INSERT INTO `lang_definitions` VALUES (6698, 6009, 3, 'Informe de distribución de pacientes asegurados');
INSERT INTO `lang_definitions` VALUES (6699, 6010, 3, 'Incidencias del Paciente');
INSERT INTO `lang_definitions` VALUES (6700, 6012, 3, 'Apellido(s)del Paciente');
INSERT INTO `lang_definitions` VALUES (6701, 6014, 3, 'Falta el apellido del paciente');
INSERT INTO `lang_definitions` VALUES (6702, 6018, 3, 'Lista de Pacientes');
INSERT INTO `lang_definitions` VALUES (6703, 6019, 3, 'Columnas Lista de Pacientes');
INSERT INTO `lang_definitions` VALUES (6704, 6021, 3, 'Nuevas ventanas Lista de Pacientes');
INSERT INTO `lang_definitions` VALUES (6705, 6022, 3, 'Tamaño página Lista de Pacientes');
INSERT INTO `lang_definitions` VALUES (6706, 6023, 3, 'Errores de búsqueda de pacientes');
INSERT INTO `lang_definitions` VALUES (6707, 6026, 3, 'Problemas Médicos del Paciente');
INSERT INTO `lang_definitions` VALUES (6708, 6027, 3, 'Medicamentos del Paciente');
INSERT INTO `lang_definitions` VALUES (6709, 6032, 3, 'Nombre del Paciente');
INSERT INTO `lang_definitions` VALUES (6710, 6033, 3, 'Nombre y Dirección del Paciente');
INSERT INTO `lang_definitions` VALUES (6711, 6036, 3, 'Nombre de Paciente Requerido');
INSERT INTO `lang_definitions` VALUES (6712, 6038, 3, 'Nota del paciente');
INSERT INTO `lang_definitions` VALUES (6713, 6039, 3, 'Nota de tipos de pacientes');
INSERT INTO `lang_definitions` VALUES (6714, 6040, 3, 'Notas del Paciente');
INSERT INTO `lang_definitions` VALUES (6715, 6041, 3, 'Notas del paciente (escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (6716, 6043, 3, 'Número del Paciente');
INSERT INTO `lang_definitions` VALUES (6717, 6044, 3, 'Pago del paciente');
INSERT INTO `lang_definitions` VALUES (6718, 6046, 3, 'Nombre de Categoría de Foto del Paciente');
INSERT INTO `lang_definitions` VALUES (6719, 6047, 3, 'Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (6720, 6051, 3, 'Portal del Paciente está apagado');
INSERT INTO `lang_definitions` VALUES (6721, 6052, 3, 'Inicio sesión Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (6722, 6054, 3, 'Sitio web del Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (6723, 6055, 3, 'Informe Impreso del Paciente');
INSERT INTO `lang_definitions` VALUES (6724, 6057, 3, 'Informe de registro del paciente');
INSERT INTO `lang_definitions` VALUES (6725, 6058, 3, 'Solicitud Registro de Paciente');
INSERT INTO `lang_definitions` VALUES (6726, 6059, 3, 'Solicitud Registros de Pacientes');
INSERT INTO `lang_definitions` VALUES (6727, 6061, 3, 'Recordatorios del paciente');
INSERT INTO `lang_definitions` VALUES (6728, 6062, 3, 'Batch Recordatorio del Paciente');
INSERT INTO `lang_definitions` VALUES (6729, 6064, 3, 'Reglas Recordatorio del Paciente');
INSERT INTO `lang_definitions` VALUES (6730, 6065, 3, 'email Remitente de Recordatorio del Paciente');
INSERT INTO `lang_definitions` VALUES (6731, 6066, 3, 'Nombre Remitente de Recordatorio del Paciente');
INSERT INTO `lang_definitions` VALUES (6732, 6067, 3, 'Recordatorios del Paciente');
INSERT INTO `lang_definitions` VALUES (6733, 6069, 3, 'Inforne del Paciente');
INSERT INTO `lang_definitions` VALUES (6734, 6071, 3, 'Solicitud del Paciente');
INSERT INTO `lang_definitions` VALUES (6735, 6072, 3, 'Paciente solicitó Registros Médicos');
INSERT INTO `lang_definitions` VALUES (6736, 6074, 3, 'Resultados del paciente');
INSERT INTO `lang_definitions` VALUES (6737, 6077, 3, 'Resultados de búsqueda de estilo de paciente');
INSERT INTO `lang_definitions` VALUES (6738, 6078, 3, 'Pantalla Buscar/añadir paciente');
INSERT INTO `lang_definitions` VALUES (6739, 6079, 3, 'Ajustes paciente');
INSERT INTO `lang_definitions` VALUES (6740, 6083, 3, 'Estado paciente');
INSERT INTO `lang_definitions` VALUES (6741, 6089, 3, 'Resumen del Paciente');
INSERT INTO `lang_definitions` VALUES (6742, 6091, 3, 'Transacciones del Pacientes');
INSERT INTO `lang_definitions` VALUES (6743, 6093, 3, 'Código Postal paciente');
INSERT INTO `lang_definitions` VALUES (6744, 6096, 3, 'Paciente(s) en la BBDD que coinciden con la información demográfica que usted ha ingresado.');
INSERT INTO `lang_definitions` VALUES (6745, 6097, 3, 'Paciente/Cliente');
INSERT INTO `lang_definitions` VALUES (6746, 6098, 3, 'Paciente:');
INSERT INTO `lang_definitions` VALUES (6747, 6099, 3, 'PacienteID');
INSERT INTO `lang_definitions` VALUES (6748, 6100, 3, 'Pacientes');
INSERT INTO `lang_definitions` VALUES (6749, 6103, 3, 'Pago');
INSERT INTO `lang_definitions` VALUES (6750, 6104, 3, 'Preste atención a la -Hecho con- casillas de verificación. Después de los seguros están marcados completa luego empezaremos a pedir a la paciente a pagar el saldo restante, si usted no marca la totalidad de los seguros luego completar la cantidad restante no serán recogidos! También si hay un equilibrio que el paciente debe pagar, a continuación, establezca la fecha apropiada, ya que esto afecta a la lengua que aparece en las declaraciones del paciente.');
INSERT INTO `lang_definitions` VALUES (6751, 6105, 3, 'Fecha de Pago:');
INSERT INTO `lang_definitions` VALUES (6752, 6107, 3, 'Estado de Pago');
INSERT INTO `lang_definitions` VALUES (6753, 6108, 3, 'Nombre del beneficiario');
INSERT INTO `lang_definitions` VALUES (6754, 6109, 3, 'Pagador');
INSERT INTO `lang_definitions` VALUES (6755, 6110, 3, 'Tipo Pagador');
INSERT INTO `lang_definitions` VALUES (6756, 6111, 3, 'Pagar');
INSERT INTO `lang_definitions` VALUES (6757, 6112, 3, 'Entidad pagadora');
INSERT INTO `lang_definitions` VALUES (6758, 6113, 3, 'Pago');
INSERT INTO `lang_definitions` VALUES (6759, 6114, 3, 'pago');
INSERT INTO `lang_definitions` VALUES (6760, 6115, 3, 'Código ajuste pago');
INSERT INTO `lang_definitions` VALUES (6761, 6116, 3, 'Pago contra');
INSERT INTO `lang_definitions` VALUES (6762, 6117, 3, 'Imnporte pago');
INSERT INTO `lang_definitions` VALUES (6763, 6118, 3, 'Importe pago debe ser numérico');
INSERT INTO `lang_definitions` VALUES (6764, 6119, 3, 'Categoría pago');
INSERT INTO `lang_definitions` VALUES (6765, 6120, 3, 'Fecha de Pago');
INSERT INTO `lang_definitions` VALUES (6766, 6121, 3, 'pago ingresado el');
INSERT INTO `lang_definitions` VALUES (6767, 6122, 3, 'Pago desde');
INSERT INTO `lang_definitions` VALUES (6768, 6123, 3, 'Pasarela de pagos');
INSERT INTO `lang_definitions` VALUES (6769, 6125, 3, 'Imputar pagos');
INSERT INTO `lang_definitions` VALUES (6770, 6126, 3, 'Lista de pagos');
INSERT INTO `lang_definitions` VALUES (6771, 6127, 3, 'Método de Pago');
INSERT INTO `lang_definitions` VALUES (6772, 6128, 3, 'Ordenar pagos por');
INSERT INTO `lang_definitions` VALUES (6773, 6129, 3, 'Estado pagos');
INSERT INTO `lang_definitions` VALUES (6774, 6132, 3, 'Tipo pagos');
INSERT INTO `lang_definitions` VALUES (6775, 6134, 3, 'Valor de pago para el código');
INSERT INTO `lang_definitions` VALUES (6776, 6135, 3, 'Pagos');
INSERT INTO `lang_definitions` VALUES (6777, 6137, 3, 'PCP');
INSERT INTO `lang_definitions` VALUES (6778, 6141, 3, 'PDF');
INSERT INTO `lang_definitions` VALUES (6779, 6143, 3, 'Descargar PDF de seleccionados');
INSERT INTO `lang_definitions` VALUES (6780, 6144, 3, 'Lenguaje del PDF');
INSERT INTO `lang_definitions` VALUES (6781, 6149, 3, 'Pelvis y nalga');
INSERT INTO `lang_definitions` VALUES (6782, 6150, 3, 'Pénfigo');
INSERT INTO `lang_definitions` VALUES (6783, 6151, 3, 'Lápiz');
INSERT INTO `lang_definitions` VALUES (6784, 6152, 3, 'Pend');
INSERT INTO `lang_definitions` VALUES (6785, 6153, 3, 'Pendiente');
INSERT INTO `lang_definitions` VALUES (6786, 6155, 3, 'Aprobación Pendiente');
INSERT INTO `lang_definitions` VALUES (6787, 6157, 3, 'Pendiente F/U');
INSERT INTO `lang_definitions` VALUES (6788, 6158, 3, 'Seguimento Pendiente');
INSERT INTO `lang_definitions` VALUES (6789, 6159, 3, 'Seguimiento de resultados pendientes');
INSERT INTO `lang_definitions` VALUES (6790, 6160, 3, 'Ordenes pendientes');
INSERT INTO `lang_definitions` VALUES (6791, 6161, 3, 'Ordenes pendientes');
INSERT INTO `lang_definitions` VALUES (6792, 6162, 3, 'Revisión Pendientes');
INSERT INTO `lang_definitions` VALUES (6793, 6163, 3, 'Contador Recetas pendientes');
INSERT INTO `lang_definitions` VALUES (6794, 6164, 3, 'Alergia a penicilina');
INSERT INTO `lang_definitions` VALUES (6795, 6165, 3, 'Pennington firme OpenEMR v');
INSERT INTO `lang_definitions` VALUES (6796, 6166, 3, 'La úlcera péptica');
INSERT INTO `lang_definitions` VALUES (6797, 6167, 3, 'Por Encuentro');
INSERT INTO `lang_definitions` VALUES (6798, 6168, 3, 'por minuto');
INSERT INTO `lang_definitions` VALUES (6799, 6169, 3, 'Por las fosas nasales');
INSERT INTO `lang_definitions` VALUES (6800, 6170, 3, 'por las fosas nasales');
INSERT INTO `lang_definitions` VALUES (6801, 6171, 3, 'Por Oris');
INSERT INTO `lang_definitions` VALUES (6802, 6172, 3, 'por oris');
INSERT INTO `lang_definitions` VALUES (6803, 6173, 3, 'Por Recto');
INSERT INTO `lang_definitions` VALUES (6804, 6174, 3, 'por recto');
INSERT INTO `lang_definitions` VALUES (6805, 6175, 3, 'Porcentaje');
INSERT INTO `lang_definitions` VALUES (6806, 6176, 3, 'Porcentaje de Pacientes a Probar Medicamento');
INSERT INTO `lang_definitions` VALUES (6807, 6178, 3, 'Percentil');
INSERT INTO `lang_definitions` VALUES (6808, 6179, 3, 'Derecho Perforado:');
INSERT INTO `lang_definitions` VALUES (6809, 6180, 3, 'Realizar la búsqueda');
INSERT INTO `lang_definitions` VALUES (6810, 6181, 3, 'Realizar esta acción');
INSERT INTO `lang_definitions` VALUES (6811, 6182, 3, 'Porcentaje Rendimiento');
INSERT INTO `lang_definitions` VALUES (6812, 6183, 3, 'realizado');
INSERT INTO `lang_definitions` VALUES (6813, 6184, 3, 'ejecutante');
INSERT INTO `lang_definitions` VALUES (6814, 6185, 3, 'Realización Laboratorio del Centro');
INSERT INTO `lang_definitions` VALUES (6815, 6187, 3, 'Periodo');
INSERT INTO `lang_definitions` VALUES (6816, 6188, 3, 'Periodo en días donde un usuario puede iniciar sesión con una contraseña caducada.');
INSERT INTO `lang_definitions` VALUES (6817, 6189, 3, 'Cuidados perioperatorios');
INSERT INTO `lang_definitions` VALUES (6818, 6191, 3, 'Periférico');
INSERT INTO `lang_definitions` VALUES (6819, 6195, 3, 'Persa');
INSERT INTO `lang_definitions` VALUES (6820, 6196, 3, 'Persa (Farsi)');
INSERT INTO `lang_definitions` VALUES (6821, 6197, 3, 'Persona');
INSERT INTO `lang_definitions` VALUES (6822, 6198, 3, 'Personalizar');
INSERT INTO `lang_definitions` VALUES (6823, 6200, 3, 'PG');
INSERT INTO `lang_definitions` VALUES (6824, 6201, 3, 'Farmacia');
INSERT INTO `lang_definitions` VALUES (6825, 6202, 3, 'Pharm Com Count');
INSERT INTO `lang_definitions` VALUES (6826, 6203, 3, 'Farmacias');
INSERT INTO `lang_definitions` VALUES (6827, 6204, 3, 'Farmacia');
INSERT INTO `lang_definitions` VALUES (6828, 6205, 3, 'Dispensario de la Farmacia');
INSERT INTO `lang_definitions` VALUES (6829, 6209, 3, 'Neumotorax');
INSERT INTO `lang_definitions` VALUES (6830, 6218, 3, 'Teléfono');
INSERT INTO `lang_definitions` VALUES (6831, 6220, 3, 'Lista de llamadas de teléfono');
INSERT INTO `lang_definitions` VALUES (6832, 6222, 3, 'Informe Lista de llamadas');
INSERT INTO `lang_definitions` VALUES (6833, 6224, 3, 'Célula de Teléfono');
INSERT INTO `lang_definitions` VALUES (6834, 6226, 3, 'Contraseña de la puerta de enlace telefónico');
INSERT INTO `lang_definitions` VALUES (6835, 6227, 3, 'URL de la puerta de enlace telefónico');
INSERT INTO `lang_definitions` VALUES (6836, 6228, 3, 'Usuario puerta de enlace telefónico');
INSERT INTO `lang_definitions` VALUES (6837, 6229, 3, 'Teléfono de Casa');
INSERT INTO `lang_definitions` VALUES (6838, 6230, 3, 'Hora notificación teléfono');
INSERT INTO `lang_definitions` VALUES (6839, 6231, 3, 'Número de teléfono');
INSERT INTO `lang_definitions` VALUES (6840, 6232, 3, 'Número de teléfono');
INSERT INTO `lang_definitions` VALUES (6841, 6233, 3, 'Número de teléfono para consultas de facturación');
INSERT INTO `lang_definitions` VALUES (6842, 6234, 3, 'Número de teléfono de Soporte de Fabricante que aparece en la página de \"Acerca de\"');
INSERT INTO `lang_definitions` VALUES (6843, 6236, 3, 'Fotofobia');
INSERT INTO `lang_definitions` VALUES (6844, 6237, 3, 'Fotografías');
INSERT INTO `lang_definitions` VALUES (6845, 6238, 3, 'PHP comprimida');
INSERT INTO `lang_definitions` VALUES (6846, 6239, 3, 'Módulo PHP CURL debe estar activado en su servidor.');
INSERT INTO `lang_definitions` VALUES (6847, 6240, 3, 'Extraído de PHP');
INSERT INTO `lang_definitions` VALUES (6848, 6241, 3, 'controles de acceso de PHP-GACL están desactivados.');
INSERT INTO `lang_definitions` VALUES (6849, 6242, 3, 'controles de acceso de PHP-GACL are desactivados.');
INSERT INTO `lang_definitions` VALUES (6850, 6243, 3, 'Examen Físico');
INSERT INTO `lang_definitions` VALUES (6851, 6244, 3, 'Médico');
INSERT INTO `lang_definitions` VALUES (6852, 6245, 3, 'Solicitud de Fisio');
INSERT INTO `lang_definitions` VALUES (6853, 6246, 3, 'Firma del Fisio');
INSERT INTO `lang_definitions` VALUES (6854, 6247, 3, 'Tipo de Médico');
INSERT INTO `lang_definitions` VALUES (6855, 6248, 3, 'Fisios');
INSERT INTO `lang_definitions` VALUES (6856, 6252, 3, 'escoger');
INSERT INTO `lang_definitions` VALUES (6857, 6253, 3, 'Seleccionar');
INSERT INTO `lang_definitions` VALUES (6858, 6254, 3, 'Seleccionar un tema CSS');
INSERT INTO `lang_definitions` VALUES (6859, 6256, 3, 'PID');
INSERT INTO `lang_definitions` VALUES (6860, 6258, 3, 'PID (enfermedad pélvica inflamatoria)');
INSERT INTO `lang_definitions` VALUES (6861, 6259, 3, 'Tamaño de la Píldora');
INSERT INTO `lang_definitions` VALUES (6862, 6260, 3, 'Píldoras');
INSERT INTO `lang_definitions` VALUES (6863, 6263, 3, 'Coloque el fichero de database zip en el siguiente directorio si quiere la opción de instalar');
INSERT INTO `lang_definitions` VALUES (6864, 6264, 3, 'Ponga el fichero zip de bbdd ICD 10 en la siguiente carpeta');
INSERT INTO `lang_definitions` VALUES (6865, 6265, 3, 'Ponga el fichero zip de bbdd ICD 9 en la siguiente carpeta');
INSERT INTO `lang_definitions` VALUES (6866, 6266, 3, 'Ponga el fichero zip de bbdd RxNorm en la siguiente carpeta');
INSERT INTO `lang_definitions` VALUES (6867, 6267, 3, 'Ponga el fichero zip de bbdd Snomed en la siguiente carpeta');
INSERT INTO `lang_definitions` VALUES (6868, 6269, 3, 'Marcador de posición');
INSERT INTO `lang_definitions` VALUES (6869, 6270, 3, 'Marcador de posición (Mantiene vacia ACL)');
INSERT INTO `lang_definitions` VALUES (6870, 6273, 3, 'Texto sin Formato');
INSERT INTO `lang_definitions` VALUES (6871, 6274, 3, 'Plan');
INSERT INTO `lang_definitions` VALUES (6872, 6275, 3, 'El plan se agregó de manera exitosa');
INSERT INTO `lang_definitions` VALUES (6873, 6276, 3, 'El plan ya está en las opciones de lista');
INSERT INTO `lang_definitions` VALUES (6874, 6278, 3, 'Nombre del Plan');
INSERT INTO `lang_definitions` VALUES (6875, 6279, 3, 'El Nombre del Plan ya existe');
INSERT INTO `lang_definitions` VALUES (6876, 6280, 3, 'El Nombre ya ha sido tomada');
INSERT INTO `lang_definitions` VALUES (6877, 6281, 3, 'Falta el nombre del plan');
INSERT INTO `lang_definitions` VALUES (6878, 6284, 3, 'Ajuste Planes');
INSERT INTO `lang_definitions` VALUES (6879, 6285, 3, 'Estado del Plan Cambió');
INSERT INTO `lang_definitions` VALUES (6880, 6286, 3, 'Falló el Cambio del Estado del Plan');
INSERT INTO `lang_definitions` VALUES (6881, 6287, 3, 'El Plan se actualizó de manera exitosa');
INSERT INTO `lang_definitions` VALUES (6882, 6288, 3, 'Plan:');
INSERT INTO `lang_definitions` VALUES (6883, 6289, 3, 'Actividad Planeada');
INSERT INTO `lang_definitions` VALUES (6884, 6290, 3, 'Fecha Planeada');
INSERT INTO `lang_definitions` VALUES (6885, 6291, 3, 'Planes');
INSERT INTO `lang_definitions` VALUES (6886, 6292, 3, 'Configuración de Planes');
INSERT INTO `lang_definitions` VALUES (6887, 6293, 3, 'Jugador');
INSERT INTO `lang_definitions` VALUES (6888, 6294, 3, 'Posición de juego');
INSERT INTO `lang_definitions` VALUES (6889, 6295, 3, 'Favor de llamar si la informacion arriba es incorrecta');
INSERT INTO `lang_definitions` VALUES (6890, 6296, 3, 'Favor de llamar si la informacion arriba es incorrecta');
INSERT INTO `lang_definitions` VALUES (6891, 6299, 3, 'Por favor cambie su contraseña');
INSERT INTO `lang_definitions` VALUES (6892, 6300, 3, 'Por favor, elige un fichero');
INSERT INTO `lang_definitions` VALUES (6893, 6301, 3, 'Por favor, elige un paciente');
INSERT INTO `lang_definitions` VALUES (6894, 6302, 3, 'Por favor, elija una selección válida de la lista.');
INSERT INTO `lang_definitions` VALUES (6895, 6303, 3, 'Por favor elige una selecion valida');
INSERT INTO `lang_definitions` VALUES (6896, 6304, 3, 'Por favor, elija un valor para');
INSERT INTO `lang_definitions` VALUES (6897, 6305, 3, 'Por favor elija el rango de fechas, y haga click en refrescar para ver los resultados.');
INSERT INTO `lang_definitions` VALUES (6898, 6306, 3, 'Por favor elegir el formato adecuado del fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (6899, 6307, 3, 'Por favor click en el botón Descargar para descargar los datos de DE identificación');
INSERT INTO `lang_definitions` VALUES (6900, 6308, 3, 'Por favor click en el botón descargar para descargar los datos de Re-identificación');
INSERT INTO `lang_definitions` VALUES (6901, 6309, 3, 'Por favor, cierre esta ventana.');
INSERT INTO `lang_definitions` VALUES (6902, 6310, 3, 'Por favor, comparar el nuevo nombre');
INSERT INTO `lang_definitions` VALUES (6903, 6311, 3, 'Por favor consider enviar una donación a:');
INSERT INTO `lang_definitions` VALUES (6904, 6313, 3, 'Por favor contacte a su administrador del sistema, los siguientes componentes son requeridos pero no se encuentran disponibles:');
INSERT INTO `lang_definitions` VALUES (6905, 6314, 3, 'Por favor corrija los valores antes de continuar!');
INSERT INTO `lang_definitions` VALUES (6906, 6315, 3, 'Por favor cree la siguiente carpeta antes de proceder');
INSERT INTO `lang_definitions` VALUES (6907, 6316, 3, 'No acepte por favor esta prescripción a menos que fuera recibida vía facimile.');
INSERT INTO `lang_definitions` VALUES (6908, 6317, 3, 'Por favor no aceptar esta receta a menos que sea recibida por fax.');
INSERT INTO `lang_definitions` VALUES (6909, 6318, 3, 'Por favor, no utilice el botón de parada o recarga de su navegador, mientras esta página está funcionando a menos que transcurran mas de 10 minutos, esto no detendrá el proceso en el servidor y consumirá recursos innecesarios.');
INSERT INTO `lang_definitions` VALUES (6910, 6319, 3, 'POR FAVOR ACTIVE LA EXTENSIÓN CURL');
INSERT INTO `lang_definitions` VALUES (6911, 6320, 3, 'POR FAVOR ACTIVE LA EXTENSIÓN OPENSSL');
INSERT INTO `lang_definitions` VALUES (6912, 6321, 3, 'POR FAVOR ACTIVE LA EXTENSIÓN SOAP');
INSERT INTO `lang_definitions` VALUES (6913, 6322, 3, 'POR FAVOR ACTIVE LA EXTENSIÓN XML');
INSERT INTO `lang_definitions` VALUES (6914, 6323, 3, 'Favor de entrar fecha de la ultima revision');
INSERT INTO `lang_definitions` VALUES (6915, 6324, 3, 'Por favor introduzca la fecha');
INSERT INTO `lang_definitions` VALUES (6916, 6326, 3, 'Por favor introduzca una fecha de vencimiento');
INSERT INTO `lang_definitions` VALUES (6917, 6327, 3, 'Por favor introduzca un mensaje');
INSERT INTO `lang_definitions` VALUES (6918, 6328, 3, 'Por favor, introduzca un importe monetario, utilizando sólo números y un punto decimal.');
INSERT INTO `lang_definitions` VALUES (6919, 6329, 3, 'Por favor introduzca una Nueva Contraseña');
INSERT INTO `lang_definitions` VALUES (6920, 6330, 3, 'Por favor, escriba un título!');
INSERT INTO `lang_definitions` VALUES (6921, 6335, 3, 'Por favor introduzca el código de Re-identificación correcto');
INSERT INTO `lang_definitions` VALUES (6922, 6337, 3, 'Por favor, introduzca el dato de la nueva búsqueda');
INSERT INTO `lang_definitions` VALUES (6923, 6338, 3, 'Por favor introduzca el código de re-identificación');
INSERT INTO `lang_definitions` VALUES (6924, 6339, 3, 'Por favor introduzca contraseña');
INSERT INTO `lang_definitions` VALUES (6925, 6341, 3, 'Por favor rellene el número de cheque');
INSERT INTO `lang_definitions` VALUES (6926, 6342, 3, 'Por favor rellene el número Check/Ref');
INSERT INTO `lang_definitions` VALUES (6927, 6343, 3, 'Por favor rellene la fecha');
INSERT INTO `lang_definitions` VALUES (6928, 6344, 3, 'Por favor rellene el importe del pago');
INSERT INTO `lang_definitions` VALUES (6929, 6345, 3, 'Por favor rellene la categoría del pago');
INSERT INTO `lang_definitions` VALUES (6930, 6346, 3, 'Por favor rellene la procedencia del pago');
INSERT INTO `lang_definitions` VALUES (6931, 6347, 3, 'Por favor rellene la casilla de la Fecha');
INSERT INTO `lang_definitions` VALUES (6932, 6348, 3, 'Favor de llenar antes de continuar');
INSERT INTO `lang_definitions` VALUES (6933, 6349, 3, 'Por favor indique el motivo de la visita');
INSERT INTO `lang_definitions` VALUES (6934, 6351, 3, 'Por favor introducir criterios de búsqueda arriba, haga clic en aceptar para ver los resultados.');
INSERT INTO `lang_definitions` VALUES (6935, 6352, 3, 'Por favor introduzca los criterios de búsqueda arriba, y haga click en aceptar para ver los resultados. (Los resultados serán mostrados en una ventana emergente)');
INSERT INTO `lang_definitions` VALUES (6936, 6353, 3, 'Por favor inicie sesión de nuevo');
INSERT INTO `lang_definitions` VALUES (6937, 6354, 3, 'Por Favor tenga en cuenta que esto puede tomar mucho tiempo, hasta varios minutos, el navegador web puede no aparecer muy activa durante este tiempo, pero la generación de una factura es un proceso complicado y su navegador web está a la espera de más información.');
INSERT INTO `lang_definitions` VALUES (6938, 6355, 3, 'Por favor Nota: constantes son sensibles a mayúsculas y minúsculas y se permite cualquier cadena.');
INSERT INTO `lang_definitions` VALUES (6939, 6356, 3, 'Por favor, utilice únicamente caracteres alfabéticos');
INSERT INTO `lang_definitions` VALUES (6940, 6357, 3, 'Por favor, utilice únicamente caracteres alfabéticos sin espacios');
INSERT INTO `lang_definitions` VALUES (6941, 6358, 3, 'Por favor, pagar esta cantidad');
INSERT INTO `lang_definitions` VALUES (6942, 6359, 3, 'Por favor ponga sus ficheros de instalación en la siguiente carpeta');
INSERT INTO `lang_definitions` VALUES (6943, 6362, 3, 'Favor de referise a');
INSERT INTO `lang_definitions` VALUES (6944, 6363, 3, 'Por favor, reinicie la contraseña.');
INSERT INTO `lang_definitions` VALUES (6945, 6364, 3, 'Por favor resetear el servidor apache antes de intentar la finalización de sesión');
INSERT INTO `lang_definitions` VALUES (6946, 6367, 3, 'Por favor vea el PDF adjunto.');
INSERT INTO `lang_definitions` VALUES (6947, 6368, 3, 'Por favor seleccione');
INSERT INTO `lang_definitions` VALUES (6948, 6369, 3, 'Por favor seleccione un formato');
INSERT INTO `lang_definitions` VALUES (6949, 6370, 3, 'Por favor seleccione un idioma');
INSERT INTO `lang_definitions` VALUES (6950, 6371, 3, 'Por favor seleccione un Paciente');
INSERT INTO `lang_definitions` VALUES (6951, 6372, 3, 'Por favor seleccione una entidad de negocio primario con \'C.I.F.\' como su centro \'C.I.F.\'. Si usted es autónomo, ponga su \'C.I.F.\'. Será usado para identificarle en el sistema NewCrop.');
INSERT INTO `lang_definitions` VALUES (6952, 6375, 3, 'Por favor Seleccione un Destinatario');
INSERT INTO `lang_definitions` VALUES (6953, 6376, 3, 'Por favor seleccione la fecha de inicio y fin');
INSERT INTO `lang_definitions` VALUES (6954, 6377, 3, 'Por favor Seleccione un Destinatario válido');
INSERT INTO `lang_definitions` VALUES (6955, 6379, 3, 'Por favor, seleccione un razón de ajuste para el código');
INSERT INTO `lang_definitions` VALUES (6956, 6380, 3, 'Por favor, seleccione un evento');
INSERT INTO `lang_definitions` VALUES (6957, 6381, 3, 'Por favor seleccione una Opción de Búsqueda');
INSERT INTO `lang_definitions` VALUES (6958, 6384, 3, 'Favor seleccionar al menos una receta');
INSERT INTO `lang_definitions` VALUES (6959, 6388, 3, 'Por favor, seleccione las pags. que desee copiar o reenviar:');
INSERT INTO `lang_definitions` VALUES (6960, 6389, 3, 'Por favor seleccione la Forma de Pago');
INSERT INTO `lang_definitions` VALUES (6961, 6391, 3, 'Por favor seleccione el tipo de pago.');
INSERT INTO `lang_definitions` VALUES (6962, 6393, 3, 'Por favor seleccione socio X12, requerido para crear el batch 270');
INSERT INTO `lang_definitions` VALUES (6963, 6394, 3, 'Por favor ajuste');
INSERT INTO `lang_definitions` VALUES (6964, 6395, 3, 'Por favor ponga la variable de_identification_config a cero');
INSERT INTO `lang_definitions` VALUES (6965, 6398, 3, 'Por favor inicie un nuevo proceso de De identificación');
INSERT INTO `lang_definitions` VALUES (6966, 6399, 3, 'Por favor actualice la base de datos OpenEMR para incluir procedimientos, funciones, tablas para De identificación');
INSERT INTO `lang_definitions` VALUES (6967, 6400, 3, 'Por favor, consulte la tabla de log de errores de De Identificación para más detalles');
INSERT INTO `lang_definitions` VALUES (6968, 6401, 3, 'Por favor visite la pantalla de Re-Identificación después de algún tiempo');
INSERT INTO `lang_definitions` VALUES (6969, 6402, 3, 'Por favor visite la pantalla de Re-Identificación después de algún tiempo');
INSERT INTO `lang_definitions` VALUES (6970, 6403, 3, 'Por favor visite la página pasado algún tiempo');
INSERT INTO `lang_definitions` VALUES (6971, 6411, 3, 'PM');
INSERT INTO `lang_definitions` VALUES (6972, 6412, 3, 'PM Program');
INSERT INTO `lang_definitions` VALUES (6973, 6418, 3, 'Método de pago');
INSERT INTO `lang_definitions` VALUES (6974, 6419, 3, 'PND');
INSERT INTO `lang_definitions` VALUES (6975, 6420, 3, 'Conjugado Neumocócico 1');
INSERT INTO `lang_definitions` VALUES (6976, 6421, 3, 'Conjugado Neumocócico 2');
INSERT INTO `lang_definitions` VALUES (6977, 6422, 3, 'Conjugado Neumocócico 3');
INSERT INTO `lang_definitions` VALUES (6978, 6423, 3, 'Conjugado Neumocócico 4');
INSERT INTO `lang_definitions` VALUES (6979, 6424, 3, 'vacuna contra el neumococo');
INSERT INTO `lang_definitions` VALUES (6980, 6425, 3, 'Vacunación Neumonía');
INSERT INTO `lang_definitions` VALUES (6981, 6426, 3, 'Estado de vacunación de neumonía de adultos mayores');
INSERT INTO `lang_definitions` VALUES (6982, 6427, 3, 'Estado de vacunación de neumonía de adultos mayores (GCC)');
INSERT INTO `lang_definitions` VALUES (6983, 6428, 3, 'Podológica');
INSERT INTO `lang_definitions` VALUES (6984, 6431, 3, 'Punto del servicio (posición)');
INSERT INTO `lang_definitions` VALUES (6985, 6432, 3, 'Póliza');
INSERT INTO `lang_definitions` VALUES (6986, 6435, 3, 'Póliza Nº');
INSERT INTO `lang_definitions` VALUES (6987, 6436, 3, 'Número Póliza');
INSERT INTO `lang_definitions` VALUES (6988, 6437, 3, 'Polaco');
INSERT INTO `lang_definitions` VALUES (6989, 6438, 3, 'Polidipsia');
INSERT INTO `lang_definitions` VALUES (6990, 6440, 3, 'Pólipos');
INSERT INTO `lang_definitions` VALUES (6991, 6441, 3, 'Poliuria');
INSERT INTO `lang_definitions` VALUES (6992, 6442, 3, 'Falta de Apetito');
INSERT INTO `lang_definitions` VALUES (6993, 6443, 3, 'Pobre Circulación');
INSERT INTO `lang_definitions` VALUES (6994, 6444, 3, 'Déficit auditivo');
INSERT INTO `lang_definitions` VALUES (6995, 6446, 3, 'Pop-ups necesitan estar activos para ver estos reportes');
INSERT INTO `lang_definitions` VALUES (6996, 6448, 3, '¿Rellenar la vista del año con eventos?');
INSERT INTO `lang_definitions` VALUES (6997, 6449, 3, 'Los menús emergentes');
INSERT INTO `lang_definitions` VALUES (6998, 6451, 3, 'Portal');
INSERT INTO `lang_definitions` VALUES (6999, 6452, 3, 'Actividad del Portal');
INSERT INTO `lang_definitions` VALUES (7000, 6461, 3, 'Portugués');
INSERT INTO `lang_definitions` VALUES (7001, 6462, 3, 'Portugués (Brasileño)');
INSERT INTO `lang_definitions` VALUES (7002, 6463, 3, 'Portugués (Europeo)');
INSERT INTO `lang_definitions` VALUES (7003, 6464, 3, 'Código de POS');
INSERT INTO `lang_definitions` VALUES (7004, 6467, 3, 'Positivo');
INSERT INTO `lang_definitions` VALUES (7005, 6468, 3, 'Positivos');
INSERT INTO `lang_definitions` VALUES (7006, 6471, 3, 'Enviar por');
INSERT INTO `lang_definitions` VALUES (7007, 6472, 3, 'Goteo nasal posterior');
INSERT INTO `lang_definitions` VALUES (7008, 6474, 3, 'Enviar pagos');
INSERT INTO `lang_definitions` VALUES (7009, 6475, 3, 'Post-quirúrgico');
INSERT INTO `lang_definitions` VALUES (7010, 6476, 3, 'Publique en la contabilidad y marque como facturado');
INSERT INTO `lang_definitions` VALUES (7011, 6477, 3, 'Publicar en fecha');
INSERT INTO `lang_definitions` VALUES (7012, 6478, 3, 'Publicar en fecha no puede ser mayor que hoy');
INSERT INTO `lang_definitions` VALUES (7013, 6479, 3, 'Publicar en fecha debe ser mayor que la fecha de cierre financiero');
INSERT INTO `lang_definitions` VALUES (7014, 6480, 3, 'Cuidado del Post-Aborto');
INSERT INTO `lang_definitions` VALUES (7015, 6481, 3, 'Contracepción del Post-Aborto');
INSERT INTO `lang_definitions` VALUES (7016, 6482, 3, 'Asesoramiento del Post-Aborto');
INSERT INTO `lang_definitions` VALUES (7017, 6483, 3, 'Seguimiento Post-Aborto');
INSERT INTO `lang_definitions` VALUES (7018, 6484, 3, 'Postal');
INSERT INTO `lang_definitions` VALUES (7019, 6485, 3, 'Código Postal');
INSERT INTO `lang_definitions` VALUES (7020, 6486, 3, 'Código Postal');
INSERT INTO `lang_definitions` VALUES (7021, 6488, 3, 'PostCalendar');
INSERT INTO `lang_definitions` VALUES (7022, 6489, 3, 'Administración del PostCalendar');
INSERT INTO `lang_definitions` VALUES (7023, 6490, 3, 'Configuración de la Categoría PostCalendar');
INSERT INTO `lang_definitions` VALUES (7024, 6491, 3, 'Configuración Global de PostCalendar');
INSERT INTO `lang_definitions` VALUES (7025, 6496, 3, 'Publicado en');
INSERT INTO `lang_definitions` VALUES (7026, 6499, 3, 'Fecha de Envío');
INSERT INTO `lang_definitions` VALUES (7027, 6505, 3, 'Desarrollado por');
INSERT INTO `lang_definitions` VALUES (7028, 6506, 3, 'PPE+ Prev Med/Surg Hx');
INSERT INTO `lang_definitions` VALUES (7029, 6507, 3, 'PQRI (Iniciativa Informe Calidad Médica)');
INSERT INTO `lang_definitions` VALUES (7030, 6508, 3, 'Registro ID PQRI');
INSERT INTO `lang_definitions` VALUES (7031, 6509, 3, 'Registro Nombre PQRI');
INSERT INTO `lang_definitions` VALUES (7032, 6510, 3, 'Práctica');
INSERT INTO `lang_definitions` VALUES (7033, 6511, 3, 'Centro establecido por defecto');
INSERT INTO `lang_definitions` VALUES (7034, 6512, 3, 'Ajustes del Centro');
INSERT INTO `lang_definitions` VALUES (7035, 6514, 3, 'Prestador');
INSERT INTO `lang_definitions` VALUES (7036, 6516, 3, 'Pago anticipado');
INSERT INTO `lang_definitions` VALUES (7037, 6517, 3, 'Prepago');
INSERT INTO `lang_definitions` VALUES (7038, 6518, 3, 'Consulta del Pre-Aborto');
INSERT INTO `lang_definitions` VALUES (7039, 6519, 3, 'Asesoramiento del Pre-Aborto');
INSERT INTO `lang_definitions` VALUES (7040, 6521, 3, 'Categoría Pref');
INSERT INTO `lang_definitions` VALUES (7041, 6523, 3, 'Preferencias');
INSERT INTO `lang_definitions` VALUES (7042, 6525, 3, 'Categoría preferida del evento');
INSERT INTO `lang_definitions` VALUES (7043, 6526, 3, 'Lengua preferida');
INSERT INTO `lang_definitions` VALUES (7044, 6527, 3, 'Preferencia Farmacia');
INSERT INTO `lang_definitions` VALUES (7045, 6528, 3, 'Organización Proveedora Preferida (PPO)');
INSERT INTO `lang_definitions` VALUES (7046, 6529, 3, 'Prueba de embarazo');
INSERT INTO `lang_definitions` VALUES (7047, 6530, 3, 'Preliminar');
INSERT INTO `lang_definitions` VALUES (7048, 6532, 3, 'Pague por Adelantado');
INSERT INTO `lang_definitions` VALUES (7049, 6533, 3, 'Prescripción');
INSERT INTO `lang_definitions` VALUES (7050, 6534, 3, 'Receta ha alcanzado sus limites de');
INSERT INTO `lang_definitions` VALUES (7051, 6535, 3, 'Histórico de Prescripciones');
INSERT INTO `lang_definitions` VALUES (7052, 6536, 3, 'Importación de Histórico de Prescripciones completado');
INSERT INTO `lang_definitions` VALUES (7053, 6537, 3, 'Etiqueta de la prescripción');
INSERT INTO `lang_definitions` VALUES (7054, 6538, 3, 'Informe de Prescripción');
INSERT INTO `lang_definitions` VALUES (7055, 6541, 3, 'Prescripciónes');
INSERT INTO `lang_definitions` VALUES (7056, 6543, 3, 'Prescripciones y dispensaciones');
INSERT INTO `lang_definitions` VALUES (7057, 6544, 3, 'Recetas y otras derivaciones');
INSERT INTO `lang_definitions` VALUES (7058, 6545, 3, 'Prescripciones y/o derivaciones a especialista');
INSERT INTO `lang_definitions` VALUES (7059, 6546, 3, 'Informe de las prescripciones');
INSERT INTO `lang_definitions` VALUES (7060, 6547, 3, 'Prescripciones/Derivaciones');
INSERT INTO `lang_definitions` VALUES (7061, 6548, 3, 'Presente');
INSERT INTO `lang_definitions` VALUES (7062, 6549, 3, 'Presentación de queja');
INSERT INTO `lang_definitions` VALUES (7063, 6551, 3, 'Pulse Continuar para proseguir');
INSERT INTO `lang_definitions` VALUES (7064, 6553, 3, 'Presunción de Diagnóstico');
INSERT INTO `lang_definitions` VALUES (7065, 6554, 3, 'Presunción de Diagnóstico por el especialista');
INSERT INTO `lang_definitions` VALUES (7066, 6555, 3, 'Previa');
INSERT INTO `lang_definitions` VALUES (7067, 6556, 3, 'Prev Med/Surg Hx');
INSERT INTO `lang_definitions` VALUES (7068, 6557, 3, 'Mes anterior. (Presione para menu)');
INSERT INTO `lang_definitions` VALUES (7069, 6558, 3, 'Año anterior (Presione para el menu)');
INSERT INTO `lang_definitions` VALUES (7070, 6559, 3, 'Cuidado Preventivo');
INSERT INTO `lang_definitions` VALUES (7071, 6562, 3, 'Vista previa del evento');
INSERT INTO `lang_definitions` VALUES (7072, 6565, 3, 'Previsualización de');
INSERT INTO `lang_definitions` VALUES (7073, 6566, 3, 'Anterior');
INSERT INTO `lang_definitions` VALUES (7074, 6567, 3, 'Consultas Anteriores');
INSERT INTO `lang_definitions` VALUES (7075, 6568, 3, 'Dia Anterior');
INSERT INTO `lang_definitions` VALUES (7076, 6569, 3, 'Para Historia');
INSERT INTO `lang_definitions` VALUES (7077, 6570, 3, 'Mes Anterior');
INSERT INTO `lang_definitions` VALUES (7078, 6571, 3, 'Semana Anterior');
INSERT INTO `lang_definitions` VALUES (7079, 6572, 3, 'Precio');
INSERT INTO `lang_definitions` VALUES (7080, 6574, 3, 'Precio de descuento');
INSERT INTO `lang_definitions` VALUES (7081, 6575, 3, 'Nivel de Precio');
INSERT INTO `lang_definitions` VALUES (7082, 6577, 3, 'Nivel de Precio:');
INSERT INTO `lang_definitions` VALUES (7083, 6579, 3, 'Precios');
INSERT INTO `lang_definitions` VALUES (7084, 6580, 3, 'Primario');
INSERT INTO `lang_definitions` VALUES (7085, 6581, 3, 'Entidad Empresa Primaria');
INSERT INTO `lang_definitions` VALUES (7086, 6582, 3, 'La entidad de negocio principal es usada como cuenta Id para la ePrescipción. Cambiando el centro afectará al funcionamiento en NewCrop.');
INSERT INTO `lang_definitions` VALUES (7087, 6591, 3, 'Seguro principal');
INSERT INTO `lang_definitions` VALUES (7088, 6592, 3, 'Seguro principal');
INSERT INTO `lang_definitions` VALUES (7089, 6593, 3, 'Datos principales del Seguro');
INSERT INTO `lang_definitions` VALUES (7090, 6594, 3, 'Proveedor principal del Seguro');
INSERT INTO `lang_definitions` VALUES (7091, 6595, 3, 'Proveedor primario');
INSERT INTO `lang_definitions` VALUES (7092, 6596, 3, 'Imprimir');
INSERT INTO `lang_definitions` VALUES (7093, 6597, 3, 'Imprimir (HTML)');
INSERT INTO `lang_definitions` VALUES (7094, 6598, 3, 'Imprimir (PDF)');
INSERT INTO `lang_definitions` VALUES (7095, 6600, 3, 'Imprimir cualquier visita');
INSERT INTO `lang_definitions` VALUES (7096, 6601, 3, 'Imprimir el formulario de derivación en blanco');
INSERT INTO `lang_definitions` VALUES (7097, 6602, 3, 'Comando Imprimir');
INSERT INTO `lang_definitions` VALUES (7098, 6609, 3, 'Imprimir el Formato');
INSERT INTO `lang_definitions` VALUES (7099, 6610, 3, 'Imprimir cuatro paneles');
INSERT INTO `lang_definitions` VALUES (7100, 6613, 3, 'Mensaje Imprimir');
INSERT INTO `lang_definitions` VALUES (7101, 6614, 3, 'Imprimir Múltiples');
INSERT INTO `lang_definitions` VALUES (7102, 6615, 3, 'Para imprimir múltiples Fax');
INSERT INTO `lang_definitions` VALUES (7103, 6616, 3, 'Imprima nombre, fecha y firma');
INSERT INTO `lang_definitions` VALUES (7104, 6617, 3, 'Imprimir notas');
INSERT INTO `lang_definitions` VALUES (7105, 6618, 3, 'Imprimir Página 1');
INSERT INTO `lang_definitions` VALUES (7106, 6619, 3, 'Imprimir Página 2');
INSERT INTO `lang_definitions` VALUES (7107, 6622, 3, 'Impresión Receta del Facultativo');
INSERT INTO `lang_definitions` VALUES (7108, 6623, 3, 'Grabar Imprimir');
INSERT INTO `lang_definitions` VALUES (7109, 6626, 3, 'Imprimir Seleccionados');
INSERT INTO `lang_definitions` VALUES (7110, 6627, 3, 'Registro de tiro impresión');
INSERT INTO `lang_definitions` VALUES (7111, 6629, 3, 'Imprimir ásta visita');
INSERT INTO `lang_definitions` VALUES (7112, 6631, 3, 'Imprimir esta nota');
INSERT INTO `lang_definitions` VALUES (7113, 6632, 3, 'Imprimir Esta Nota');
INSERT INTO `lang_definitions` VALUES (7114, 6634, 3, 'Para imprimir Fax');
INSERT INTO `lang_definitions` VALUES (7115, 6635, 3, 'Ver Imprenta');
INSERT INTO `lang_definitions` VALUES (7116, 6636, 3, 'Imprimible');
INSERT INTO `lang_definitions` VALUES (7117, 6637, 3, 'Versión Imprimible');
INSERT INTO `lang_definitions` VALUES (7118, 6638, 3, 'Impreso');
INSERT INTO `lang_definitions` VALUES (7119, 6641, 3, 'Resultados de la impresión:');
INSERT INTO `lang_definitions` VALUES (7120, 6642, 3, 'Impresión omitida; ver la salida de prueba en');
INSERT INTO `lang_definitions` VALUES (7121, 6643, 3, 'Impresión saltado; ver la prueba de salida en');
INSERT INTO `lang_definitions` VALUES (7122, 6645, 3, 'Antes de autentificación');
INSERT INTO `lang_definitions` VALUES (7123, 6646, 3, 'Formulario de Autorización Previa');
INSERT INTO `lang_definitions` VALUES (7124, 6650, 3, 'Antes de visita');
INSERT INTO `lang_definitions` VALUES (7125, 6652, 3, 'Prioridad');
INSERT INTO `lang_definitions` VALUES (7126, 6653, 3, 'Prioridad');
INSERT INTO `lang_definitions` VALUES (7127, 6657, 3, 'Privado');
INSERT INTO `lang_definitions` VALUES (7128, 6658, 3, 'Problema');
INSERT INTO `lang_definitions` VALUES (7129, 6659, 3, 'Problema Diagnóstico (DX)');
INSERT INTO `lang_definitions` VALUES (7130, 6660, 3, 'Lista de Problema');
INSERT INTO `lang_definitions` VALUES (7131, 6662, 3, 'Problemas/Incidencias');
INSERT INTO `lang_definitions` VALUES (7132, 6663, 3, 'Proc Bat');
INSERT INTO `lang_definitions` VALUES (7133, 6664, 3, 'Proc Cat');
INSERT INTO `lang_definitions` VALUES (7134, 6666, 3, 'Proc.Pendientes Revisión');
INSERT INTO `lang_definitions` VALUES (7135, 6668, 3, 'Proc Res');
INSERT INTO `lang_definitions` VALUES (7136, 6669, 3, 'Procedimiento');
INSERT INTO `lang_definitions` VALUES (7137, 6670, 3, 'Procedmiento por area corporal');
INSERT INTO `lang_definitions` VALUES (7138, 6671, 3, 'Procedimientos con resultados Boolean');
INSERT INTO `lang_definitions` VALUES (7139, 6672, 3, 'Codigo de Procedimiento');
INSERT INTO `lang_definitions` VALUES (7140, 6673, 3, 'Códigos de procedimiento');
INSERT INTO `lang_definitions` VALUES (7141, 6674, 3, 'Lateralidades del procedimiento');
INSERT INTO `lang_definitions` VALUES (7142, 6676, 3, 'Orden del procedimiento');
INSERT INTO `lang_definitions` VALUES (7143, 6678, 3, 'Procedimiento ordenado para');
INSERT INTO `lang_definitions` VALUES (7144, 6685, 3, 'Informe Procedimiento');
INSERT INTO `lang_definitions` VALUES (7145, 6686, 3, 'Situaciones del reporte de procedimientos');
INSERT INTO `lang_definitions` VALUES (7146, 6687, 3, 'Resultado anormal del procedimiento');
INSERT INTO `lang_definitions` VALUES (7147, 6688, 3, 'Situacion del resultado del procedimiento');
INSERT INTO `lang_definitions` VALUES (7148, 6689, 3, 'Resultados del procedimientos');
INSERT INTO `lang_definitions` VALUES (7149, 6690, 3, 'Rutas del procedimiento');
INSERT INTO `lang_definitions` VALUES (7150, 6691, 3, 'Tipos de especímenes del procedimiento');
INSERT INTO `lang_definitions` VALUES (7151, 6692, 3, 'Reportes estadísticos del procedimiento');
INSERT INTO `lang_definitions` VALUES (7152, 6693, 3, 'Tipo del procedimiento');
INSERT INTO `lang_definitions` VALUES (7153, 6694, 3, 'Tipos de procedimientos');
INSERT INTO `lang_definitions` VALUES (7154, 6695, 3, 'Unidades del procedimiento');
INSERT INTO `lang_definitions` VALUES (7155, 6696, 3, 'Procedimiento/Servicio');
INSERT INTO `lang_definitions` VALUES (7156, 6697, 3, 'Procedimientos');
INSERT INTO `lang_definitions` VALUES (7157, 6699, 3, 'Aceptar');
INSERT INTO `lang_definitions` VALUES (7158, 6701, 3, 'Procesar fichero ERA');
INSERT INTO `lang_definitions` VALUES (7159, 6705, 3, 'El proceso puede tardar algún tiempo');
INSERT INTO `lang_definitions` VALUES (7160, 6706, 3, 'Procesado');
INSERT INTO `lang_definitions` VALUES (7161, 6707, 3, 'Procesado por');
INSERT INTO `lang_definitions` VALUES (7162, 6708, 3, 'Fecha procesado');
INSERT INTO `lang_definitions` VALUES (7163, 6710, 3, 'Procesamiento');
INSERT INTO `lang_definitions` VALUES (7164, 6715, 3, 'Producto');
INSERT INTO `lang_definitions` VALUES (7165, 6717, 3, 'Método Producto Anticonceptivo');
INSERT INTO `lang_definitions` VALUES (7166, 6720, 3, 'Productos');
INSERT INTO `lang_definitions` VALUES (7167, 6721, 3, 'Productos pero no medicamentos con receta y sin plantillas');
INSERT INTO `lang_definitions` VALUES (7168, 6723, 3, 'Prof.');
INSERT INTO `lang_definitions` VALUES (7169, 6729, 3, 'Notas de progreso');
INSERT INTO `lang_definitions` VALUES (7170, 6732, 3, 'Cáncer de Próstata');
INSERT INTO `lang_definitions` VALUES (7171, 6733, 3, 'Detección de cancer de próstata');
INSERT INTO `lang_definitions` VALUES (7172, 6734, 3, 'Examen de Próstata');
INSERT INTO `lang_definitions` VALUES (7173, 6735, 3, 'Problemas de Próstata');
INSERT INTO `lang_definitions` VALUES (7174, 6736, 3, 'Próstata sin enlrgmt, nódulos, dolor');
INSERT INTO `lang_definitions` VALUES (7175, 6740, 3, 'Provee ruta absoluta');
INSERT INTO `lang_definitions` VALUES (7176, 6741, 3, 'Provee ruta absoluta del file');
INSERT INTO `lang_definitions` VALUES (7177, 6743, 3, 'Proporcione resúmenes clínicos a los pacientes en cada visita.');
INSERT INTO `lang_definitions` VALUES (7178, 6744, 3, 'Proporcionar a los pacientes una copia electrónica de su información de salud (incluyendo resultados de pruebas de diagnóstico, lista de problemas, lista de medicamentos, medicación para alergias), bajo petición.');
INSERT INTO `lang_definitions` VALUES (7179, 6745, 3, 'Ofrecer a los pacientes el acceso oportuno a su información electrónica de salud (incluyendo resultados de laboratorio, lista de problemas, listas de medicamentos, alergias a medicamentos) dentro de cuatro días hábiles de que la información esté disponible para el EP.');
INSERT INTO `lang_definitions` VALUES (7180, 6746, 3, 'Proporcionar Registros de Paciente por Visita');
INSERT INTO `lang_definitions` VALUES (7181, 6747, 3, 'Proporcionar email válido');
INSERT INTO `lang_definitions` VALUES (7182, 6748, 3, '¿Resumen médico proporcionado?');
INSERT INTO `lang_definitions` VALUES (7183, 6749, 3, '¿Recusros educativos proporcionados?');
INSERT INTO `lang_definitions` VALUES (7184, 6750, 3, 'Facultativo');
INSERT INTO `lang_definitions` VALUES (7185, 6754, 3, 'Facultativo ID');
INSERT INTO `lang_definitions` VALUES (7186, 6755, 3, 'Facultativo ID en el centro especificado');
INSERT INTO `lang_definitions` VALUES (7187, 6756, 3, 'Errores de correspondencia de Proveedor');
INSERT INTO `lang_definitions` VALUES (7188, 6760, 3, 'Número de Proveedor');
INSERT INTO `lang_definitions` VALUES (7189, 6766, 3, 'Facultativo:');
INSERT INTO `lang_definitions` VALUES (7190, 6767, 3, 'Facultativos');
INSERT INTO `lang_definitions` VALUES (7191, 6768, 3, 'NPI Facultativos');
INSERT INTO `lang_definitions` VALUES (7192, 6769, 3, 'Proveedores Ver calendario completo');
INSERT INTO `lang_definitions` VALUES (7193, 6770, 3, 'Prv');
INSERT INTO `lang_definitions` VALUES (7194, 6771, 3, 'PSA');
INSERT INTO `lang_definitions` VALUES (7195, 6772, 3, 'Psoriasis');
INSERT INTO `lang_definitions` VALUES (7196, 6774, 3, 'Psiqu. Diagnóstico');
INSERT INTO `lang_definitions` VALUES (7197, 6775, 3, 'Psych Medicamentos');
INSERT INTO `lang_definitions` VALUES (7198, 6776, 3, 'Psiquiátricos');
INSERT INTO `lang_definitions` VALUES (7199, 6777, 3, 'Breve carta Psiquiátrica');
INSERT INTO `lang_definitions` VALUES (7200, 6778, 3, 'Diagnóstico psiquiátrico');
INSERT INTO `lang_definitions` VALUES (7201, 6779, 3, 'Examinación psiquiátrica');
INSERT INTO `lang_definitions` VALUES (7202, 6781, 3, 'Historia Psiquiátrica');
INSERT INTO `lang_definitions` VALUES (7203, 6782, 3, 'Producto Psiquiátrico');
INSERT INTO `lang_definitions` VALUES (7204, 6783, 3, 'Medicación Psiquiátrica');
INSERT INTO `lang_definitions` VALUES (7205, 6787, 3, 'Pt %');
INSERT INTO `lang_definitions` VALUES (7206, 6788, 3, 'Notas Paciente');
INSERT INTO `lang_definitions` VALUES (7207, 6789, 3, 'Notas/Autorización PAciente');
INSERT INTO `lang_definitions` VALUES (7208, 6790, 3, 'Pt en exceso');
INSERT INTO `lang_definitions` VALUES (7209, 6791, 3, 'Pt Pagado');
INSERT INTO `lang_definitions` VALUES (7210, 6792, 3, 'Solicitud Registro Pacienten');
INSERT INTO `lang_definitions` VALUES (7211, 6793, 3, 'Pt Reembolso');
INSERT INTO `lang_definitions` VALUES (7212, 6794, 3, 'Pt liberados');
INSERT INTO `lang_definitions` VALUES (7213, 6795, 3, 'Informe Paciente');
INSERT INTO `lang_definitions` VALUES (7214, 6796, 3, 'PT Estudiante, o dejar en blanco');
INSERT INTO `lang_definitions` VALUES (7215, 6797, 3, 'PT_CITY');
INSERT INTO `lang_definitions` VALUES (7216, 6798, 3, 'PT_DOB');
INSERT INTO `lang_definitions` VALUES (7217, 6800, 3, 'PT_FNAME');
INSERT INTO `lang_definitions` VALUES (7218, 6801, 3, 'PT_LNAME');
INSERT INTO `lang_definitions` VALUES (7219, 6802, 3, 'PT_MNAME');
INSERT INTO `lang_definitions` VALUES (7220, 6805, 3, 'PT_POSTAL');
INSERT INTO `lang_definitions` VALUES (7221, 6807, 3, 'PT_STATE');
INSERT INTO `lang_definitions` VALUES (7222, 6808, 3, 'PT_STREET');
INSERT INTO `lang_definitions` VALUES (7223, 6810, 3, 'Público');
INSERT INTO `lang_definitions` VALUES (7224, 6814, 3, 'Seguridad Social (SS) u otro organismo oficial');
INSERT INTO `lang_definitions` VALUES (7225, 6821, 3, 'Puertorriqueño');
INSERT INTO `lang_definitions` VALUES (7226, 6823, 3, 'Pulmonar');
INSERT INTO `lang_definitions` VALUES (7227, 6825, 3, 'Pulso');
INSERT INTO `lang_definitions` VALUES (7228, 6826, 3, 'Penyabí');
INSERT INTO `lang_definitions` VALUES (7229, 6828, 3, 'Comprar');
INSERT INTO `lang_definitions` VALUES (7230, 6829, 3, 'Compra/Devolución');
INSERT INTO `lang_definitions` VALUES (7231, 6830, 3, 'Adquisiciones');
INSERT INTO `lang_definitions` VALUES (7232, 6834, 3, 'q.3h');
INSERT INTO `lang_definitions` VALUES (7233, 6835, 3, 'q.4h');
INSERT INTO `lang_definitions` VALUES (7234, 6836, 3, 'q.5h');
INSERT INTO `lang_definitions` VALUES (7235, 6837, 3, 'q.6h');
INSERT INTO `lang_definitions` VALUES (7236, 6838, 3, 'q.8h');
INSERT INTO `lang_definitions` VALUES (7237, 6839, 3, 'q.d.');
INSERT INTO `lang_definitions` VALUES (7238, 6840, 3, 'q.i.d.');
INSERT INTO `lang_definitions` VALUES (7239, 6842, 3, 'QOH');
INSERT INTO `lang_definitions` VALUES (7240, 6843, 3, 'QOH es menor que el consumo mensual');
INSERT INTO `lang_definitions` VALUES (7241, 6844, 3, 'Cantidad');
INSERT INTO `lang_definitions` VALUES (7242, 6845, 3, 'Cantidad');
INSERT INTO `lang_definitions` VALUES (7243, 6846, 3, 'Calidad');
INSERT INTO `lang_definitions` VALUES (7244, 6847, 3, 'Medidas de calidad (GCC)');
INSERT INTO `lang_definitions` VALUES (7245, 6848, 3, 'Cantidad');
INSERT INTO `lang_definitions` VALUES (7246, 6850, 3, 'Cantidad para NDC');
INSERT INTO `lang_definitions` VALUES (7247, 6851, 3, 'Cantidad En Mano');
INSERT INTO `lang_definitions` VALUES (7248, 6852, 3, 'cantidad parece inservible');
INSERT INTO `lang_definitions` VALUES (7249, 6855, 3, 'interrogante');
INSERT INTO `lang_definitions` VALUES (7250, 6856, 3, 'HCFA cola de proceso batch');
INSERT INTO `lang_definitions` VALUES (7251, 6857, 3, 'HCFA cola de proceso batch y de impresión');
INSERT INTO `lang_definitions` VALUES (7252, 6858, 3, 'Cola de la UB-92 del proceso batch');
INSERT INTO `lang_definitions` VALUES (7253, 6859, 3, 'Cola de la UB-92 del proceso batch y de impresión');
INSERT INTO `lang_definitions` VALUES (7254, 6860, 3, 'Cola');
INSERT INTO `lang_definitions` VALUES (7255, 6861, 3, 'Administración de Eventos en cola');
INSERT INTO `lang_definitions` VALUES (7256, 6862, 3, 'Cola para');
INSERT INTO `lang_definitions` VALUES (7257, 6864, 3, 'Cola de Peticiones Administración');
INSERT INTO `lang_definitions` VALUES (7258, 6866, 3, 'Dejar');
INSERT INTO `lang_definitions` VALUES (7259, 6867, 3, 'Dejar el alcohol');
INSERT INTO `lang_definitions` VALUES (7260, 6868, 3, 'R');
INSERT INTO `lang_definitions` VALUES (7261, 6875, 3, 'Raza');
INSERT INTO `lang_definitions` VALUES (7262, 6876, 3, 'Raza y Etnia');
INSERT INTO `lang_definitions` VALUES (7263, 6877, 3, 'Raza/etnia');
INSERT INTO `lang_definitions` VALUES (7264, 6879, 3, 'Radio');
INSERT INTO `lang_definitions` VALUES (7265, 6880, 3, 'Botones de radio');
INSERT INTO `lang_definitions` VALUES (7266, 6883, 3, 'Rango');
INSERT INTO `lang_definitions` VALUES (7267, 6884, 3, 'Erupciones');
INSERT INTO `lang_definitions` VALUES (7268, 6885, 3, 'Tasa');
INSERT INTO `lang_definitions` VALUES (7269, 6887, 3, 'Proporcion');
INSERT INTO `lang_definitions` VALUES (7270, 6888, 3, 'Informe sin procesar');
INSERT INTO `lang_definitions` VALUES (7271, 6896, 3, 'Re-Identificación');
INSERT INTO `lang_definitions` VALUES (7272, 6897, 3, 'Proceso Re-Identificación completado');
INSERT INTO `lang_definitions` VALUES (7273, 6898, 3, 'Proceso Re identificación en curso');
INSERT INTO `lang_definitions` VALUES (7274, 6899, 3, 'Ficheros de Re-identificación serán salvados en');
INSERT INTO `lang_definitions` VALUES (7275, 6900, 3, '¿Misma lesión?');
INSERT INTO `lang_definitions` VALUES (7276, 6901, 3, 'Abra de nuevo');
INSERT INTO `lang_definitions` VALUES (7277, 6903, 3, 'Volvió a abrir');
INSERT INTO `lang_definitions` VALUES (7278, 6905, 3, 'Reacción');
INSERT INTO `lang_definitions` VALUES (7279, 6906, 3, 'reacciones');
INSERT INTO `lang_definitions` VALUES (7280, 6909, 3, 'Leído');
INSERT INTO `lang_definitions` VALUES (7281, 6912, 3, 'Nombre Real');
INSERT INTO `lang_definitions` VALUES (7282, 6913, 3, 'Realmente borrado');
INSERT INTO `lang_definitions` VALUES (7283, 6914, 3, 'Razón');
INSERT INTO `lang_definitions` VALUES (7284, 6915, 3, 'Motivo del fallecimiento');
INSERT INTO `lang_definitions` VALUES (7285, 6916, 3, 'Motivo de la Muerte');
INSERT INTO `lang_definitions` VALUES (7286, 6918, 3, 'Motivo de la derivación');
INSERT INTO `lang_definitions` VALUES (7287, 6919, 3, 'Motivo de la Visita');
INSERT INTO `lang_definitions` VALUES (7288, 6920, 3, 'Motivo/Forma');
INSERT INTO `lang_definitions` VALUES (7289, 6933, 3, 'Recibo');
INSERT INTO `lang_definitions` VALUES (7290, 6934, 3, 'Recibo de Pago');
INSERT INTO `lang_definitions` VALUES (7291, 6935, 3, 'Recibo de Creación');
INSERT INTO `lang_definitions` VALUES (7292, 6936, 3, 'Recibos de pago por Informe');
INSERT INTO `lang_definitions` VALUES (7293, 6937, 3, 'Resumen del Recibo');
INSERT INTO `lang_definitions` VALUES (7294, 6938, 3, 'Recibido');
INSERT INTO `lang_definitions` VALUES (7295, 6939, 3, 'Recibido Por');
INSERT INTO `lang_definitions` VALUES (7296, 6940, 3, 'Recibido faxes');
INSERT INTO `lang_definitions` VALUES (7297, 6943, 3, 'Receptor');
INSERT INTO `lang_definitions` VALUES (7298, 6944, 3, 'Nº Identificación del destinatario');
INSERT INTO `lang_definitions` VALUES (7299, 6945, 3, 'Recibidor ID (ISA08)');
INSERT INTO `lang_definitions` VALUES (7300, 6946, 3, 'Calificador del recibidor ID (ISA07)');
INSERT INTO `lang_definitions` VALUES (7301, 6948, 3, 'Las últimas tres contraseñas no están permitidas.');
INSERT INTO `lang_definitions` VALUES (7302, 6950, 3, 'Beneficiario');
INSERT INTO `lang_definitions` VALUES (7303, 6951, 3, 'Lista de Beneficiarios vacía');
INSERT INTO `lang_definitions` VALUES (7304, 6952, 3, 'Nombre destinatario');
INSERT INTO `lang_definitions` VALUES (7305, 6953, 3, 'Destinatario de la publicación');
INSERT INTO `lang_definitions` VALUES (7306, 6955, 3, 'Recomendación');
INSERT INTO `lang_definitions` VALUES (7307, 6957, 3, 'Recomendaciones');
INSERT INTO `lang_definitions` VALUES (7308, 6958, 3, 'Recomendaciones y el tratamiento');
INSERT INTO `lang_definitions` VALUES (7309, 6959, 3, 'Recomendaciones del especialista');
INSERT INTO `lang_definitions` VALUES (7310, 6961, 3, 'Registro');
INSERT INTO `lang_definitions` VALUES (7311, 6962, 3, 'Registro ya existe');
INSERT INTO `lang_definitions` VALUES (7312, 6968, 3, 'Registro y gráfico de los cambios en las constantes vitales.');
INSERT INTO `lang_definitions` VALUES (7313, 6969, 3, 'Registro demográficos.');
INSERT INTO `lang_definitions` VALUES (7314, 6970, 3, 'Grabar aviso');
INSERT INTO `lang_definitions` VALUES (7315, 6971, 3, 'Registro de estado físico');
INSERT INTO `lang_definitions` VALUES (7316, 6972, 3, 'Pago de Registro');
INSERT INTO `lang_definitions` VALUES (7317, 6974, 3, 'Fecha registro de solicitud');
INSERT INTO `lang_definitions` VALUES (7318, 6975, 3, 'Registro estado pacientes fumadores de 13 años o más');
INSERT INTO `lang_definitions` VALUES (7319, 6976, 3, 'Registros');
INSERT INTO `lang_definitions` VALUES (7320, 6977, 3, 'registros encontrados');
INSERT INTO `lang_definitions` VALUES (7321, 6978, 3, 'registros encontrados.');
INSERT INTO `lang_definitions` VALUES (7322, 6980, 3, 'Uso de drogas no farmacológicas');
INSERT INTO `lang_definitions` VALUES (7323, 6981, 3, 'Drogas no farmacológicas');
INSERT INTO `lang_definitions` VALUES (7324, 6982, 3, 'Rectal');
INSERT INTO `lang_definitions` VALUES (7325, 6983, 3, 'Examen Rectal');
INSERT INTO `lang_definitions` VALUES (7326, 6984, 3, 'Rectal');
INSERT INTO `lang_definitions` VALUES (7327, 6991, 3, 'Redirección');
INSERT INTO `lang_definitions` VALUES (7328, 6992, 3, 'Enrojecimiento');
INSERT INTO `lang_definitions` VALUES (7329, 6994, 3, 'Reducido:');
INSERT INTO `lang_definitions` VALUES (7330, 6995, 3, 'Referir');
INSERT INTO `lang_definitions` VALUES (7331, 6996, 3, 'Referir Por');
INSERT INTO `lang_definitions` VALUES (7332, 6997, 3, 'Referir Fecha');
INSERT INTO `lang_definitions` VALUES (7333, 6998, 3, 'Referir Para');
INSERT INTO `lang_definitions` VALUES (7334, 7000, 3, 'Clasificación de referencia (nivel de riesgo)');
INSERT INTO `lang_definitions` VALUES (7335, 7001, 3, 'Referencia de rango de resultados');
INSERT INTO `lang_definitions` VALUES (7336, 7002, 3, 'Motivo de referencia');
INSERT INTO `lang_definitions` VALUES (7337, 7005, 3, 'Referer nombre y la firma');
INSERT INTO `lang_definitions` VALUES (7338, 7006, 3, 'Derivación');
INSERT INTO `lang_definitions` VALUES (7339, 7007, 3, 'Derivado Por');
INSERT INTO `lang_definitions` VALUES (7340, 7008, 3, 'Tarjeta de derivado');
INSERT INTO `lang_definitions` VALUES (7341, 7009, 3, 'Fecha de derivación');
INSERT INTO `lang_definitions` VALUES (7342, 7010, 3, 'Formulario de derivación');
INSERT INTO `lang_definitions` VALUES (7343, 7011, 3, 'FORMULARIO DE DERIVACIÓN');
INSERT INTO `lang_definitions` VALUES (7344, 7012, 3, 'Nº ID derivación');
INSERT INTO `lang_definitions` VALUES (7345, 7015, 3, 'Origen derivación');
INSERT INTO `lang_definitions` VALUES (7346, 7016, 3, 'Origen derivación para visitas');
INSERT INTO `lang_definitions` VALUES (7347, 7017, 3, 'Derivado a');
INSERT INTO `lang_definitions` VALUES (7348, 7018, 3, 'Derivados');
INSERT INTO `lang_definitions` VALUES (7349, 7019, 3, 'Informes de Derivados');
INSERT INTO `lang_definitions` VALUES (7350, 7020, 3, 'Derivado por');
INSERT INTO `lang_definitions` VALUES (7351, 7021, 3, 'Referido Por');
INSERT INTO `lang_definitions` VALUES (7352, 7022, 3, 'Referido a');
INSERT INTO `lang_definitions` VALUES (7353, 7023, 3, 'Referencia');
INSERT INTO `lang_definitions` VALUES (7354, 7025, 3, 'Diagnóstico de Referencia');
INSERT INTO `lang_definitions` VALUES (7355, 7026, 3, 'Diagnóstico de referencia');
INSERT INTO `lang_definitions` VALUES (7356, 7028, 3, 'Fisio de referencia y centro');
INSERT INTO `lang_definitions` VALUES (7357, 7030, 3, 'Facultativo de referencia');
INSERT INTO `lang_definitions` VALUES (7358, 7031, 3, 'Recargar');
INSERT INTO `lang_definitions` VALUES (7359, 7033, 3, 'Repuesto');
INSERT INTO `lang_definitions` VALUES (7360, 7034, 3, 'repuestos');
INSERT INTO `lang_definitions` VALUES (7361, 7035, 3, 'Reflejos normales');
INSERT INTO `lang_definitions` VALUES (7362, 7039, 3, 'Refrescar');
INSERT INTO `lang_definitions` VALUES (7363, 7041, 3, 'Refrescando avisos');
INSERT INTO `lang_definitions` VALUES (7364, 7044, 3, 'Se negó a declarar');
INSERT INTO `lang_definitions` VALUES (7365, 7045, 3, 'reg_re');
INSERT INTO `lang_definitions` VALUES (7366, 7047, 3, 'Registrar');
INSERT INTO `lang_definitions` VALUES (7367, 7050, 3, 'Registrado');
INSERT INTO `lang_definitions` VALUES (7368, 7051, 3, 'registrado');
INSERT INTO `lang_definitions` VALUES (7369, 7055, 3, 'Fecha de Registro');
INSERT INTO `lang_definitions` VALUES (7370, 7056, 3, 'Formulario de Inscripción');
INSERT INTO `lang_definitions` VALUES (7371, 7057, 3, 'Rehabilitación');
INSERT INTO `lang_definitions` VALUES (7372, 7061, 3, 'Relaciónese Con');
INSERT INTO `lang_definitions` VALUES (7373, 7062, 3, 'Relacionado');
INSERT INTO `lang_definitions` VALUES (7374, 7063, 3, 'Incidencia relacionada');
INSERT INTO `lang_definitions` VALUES (7375, 7065, 3, 'Relacion(es)/niños');
INSERT INTO `lang_definitions` VALUES (7376, 7066, 3, 'Relaciones');
INSERT INTO `lang_definitions` VALUES (7377, 7067, 3, 'Relación');
INSERT INTO `lang_definitions` VALUES (7378, 7068, 3, 'Orden relativo de esta entidad');
INSERT INTO `lang_definitions` VALUES (7379, 7069, 3, 'Familiares');
INSERT INTO `lang_definitions` VALUES (7380, 7079, 3, 'Las credenciales de la salud del relais faltan de esta cuenta de usuario.');
INSERT INTO `lang_definitions` VALUES (7381, 7080, 3, 'Relay Health ID');
INSERT INTO `lang_definitions` VALUES (7382, 7082, 3, 'Fecha versión');
INSERT INTO `lang_definitions` VALUES (7383, 7083, 3, 'Religión');
INSERT INTO `lang_definitions` VALUES (7384, 7088, 3, 'Reinicie sesión');
INSERT INTO `lang_definitions` VALUES (7385, 7089, 3, 'Aviso');
INSERT INTO `lang_definitions` VALUES (7386, 7090, 3, 'Recordar Centro Seleccionado');
INSERT INTO `lang_definitions` VALUES (7387, 7091, 3, 'Recordatorio');
INSERT INTO `lang_definitions` VALUES (7388, 7094, 3, 'Intervalos recordatorio');
INSERT INTO `lang_definitions` VALUES (7389, 7095, 3, 'Recordatorio No Enviado Todavía');
INSERT INTO `lang_definitions` VALUES (7390, 7099, 3, 'Recordatorio Enviado El');
INSERT INTO `lang_definitions` VALUES (7391, 7104, 3, 'Avisos');
INSERT INTO `lang_definitions` VALUES (7392, 7105, 3, 'REMITIR A');
INSERT INTO `lang_definitions` VALUES (7393, 7107, 3, 'Quitar');
INSERT INTO `lang_definitions` VALUES (7394, 7110, 3, 'Eliminar Grupo');
INSERT INTO `lang_definitions` VALUES (7395, 7112, 3, 'Eliminar el formulario del grupo');
INSERT INTO `lang_definitions` VALUES (7396, 7115, 3, 'Eliminar soporte para las vacunas');
INSERT INTO `lang_definitions` VALUES (7397, 7116, 3, 'Eliminar soporte para phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (7398, 7117, 3, 'Eliminar soporte para prescripciones');
INSERT INTO `lang_definitions` VALUES (7399, 7119, 3, 'Elimina la función del gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (7400, 7120, 3, 'Litiasis Renal');
INSERT INTO `lang_definitions` VALUES (7401, 7121, 3, 'Renombrar');
INSERT INTO `lang_definitions` VALUES (7402, 7122, 3, 'Renombrar Grupo');
INSERT INTO `lang_definitions` VALUES (7403, 7123, 3, 'Representación');
INSERT INTO `lang_definitions` VALUES (7404, 7124, 3, 'Representación del Facultativo');
INSERT INTO `lang_definitions` VALUES (7405, 7125, 3, 'Número Representación del Facultativo');
INSERT INTO `lang_definitions` VALUES (7406, 7127, 3, 'Reordenar');
INSERT INTO `lang_definitions` VALUES (7407, 7128, 3, 'Al reordenar');
INSERT INTO `lang_definitions` VALUES (7408, 7129, 3, 'Alcanzado el punto de pedido');
INSERT INTO `lang_definitions` VALUES (7409, 7130, 3, 'Punto de pedido, 0 no es válido');
INSERT INTO `lang_definitions` VALUES (7410, 7135, 3, 'Repetición eventos');
INSERT INTO `lang_definitions` VALUES (7411, 7136, 3, 'Repetir Información:');
INSERT INTO `lang_definitions` VALUES (7412, 7137, 3, 'Repite');
INSERT INTO `lang_definitions` VALUES (7413, 7144, 3, 'Fecha de Respuesta');
INSERT INTO `lang_definitions` VALUES (7414, 7145, 3, 'De respuesta');
INSERT INTO `lang_definitions` VALUES (7415, 7147, 3, 'Informe');
INSERT INTO `lang_definitions` VALUES (7416, 7149, 3, 'Informe Clínico');
INSERT INTO `lang_definitions` VALUES (7417, 7151, 3, 'Informe por');
INSERT INTO `lang_definitions` VALUES (7418, 7161, 3, 'Reporte de estatus');
INSERT INTO `lang_definitions` VALUES (7419, 7162, 3, 'Informe Totales');
INSERT INTO `lang_definitions` VALUES (7420, 7164, 3, 'Informe/Formulario');
INSERT INTO `lang_definitions` VALUES (7421, 7166, 3, 'Informable');
INSERT INTO `lang_definitions` VALUES (7422, 7167, 3, 'Reportado');
INSERT INTO `lang_definitions` VALUES (7423, 7168, 3, 'Fecha Informada');
INSERT INTO `lang_definitions` VALUES (7424, 7169, 3, 'Informes');
INSERT INTO `lang_definitions` VALUES (7425, 7173, 3, '¡Solicitud ignorada - proceso de reclamaciones ya se está ejecutando!');
INSERT INTO `lang_definitions` VALUES (7426, 7181, 3, 'Servicio Solicitado');
INSERT INTO `lang_definitions` VALUES (7427, 7183, 3, 'Se requiere Contraseña más compleja');
INSERT INTO `lang_definitions` VALUES (7428, 7184, 3, 'Se requiere Contraseña única');
INSERT INTO `lang_definitions` VALUES (7429, 7185, 3, 'Requerido');
INSERT INTO `lang_definitions` VALUES (7430, 7186, 3, 'Copago requerido');
INSERT INTO `lang_definitions` VALUES (7431, 7187, 3, 'Falta campo requerido:Por favor elija el fichero EDI-271 para adjuntar');
INSERT INTO `lang_definitions` VALUES (7432, 7188, 3, 'Falta campo requerido: Por favor introduzca el nombre');
INSERT INTO `lang_definitions` VALUES (7433, 7189, 3, 'Falta campo requerido: Por favor introduzca el apellido');
INSERT INTO `lang_definitions` VALUES (7434, 7190, 3, 'Falta campo requerido: Por favor introduzca el nombre de usuario');
INSERT INTO `lang_definitions` VALUES (7435, 7191, 3, 'Campos requeridos');
INSERT INTO `lang_definitions` VALUES (7436, 7192, 3, 'Requerimientos');
INSERT INTO `lang_definitions` VALUES (7437, 7193, 3, 'RESERVADO');
INSERT INTO `lang_definitions` VALUES (7438, 7194, 3, 'Reservado');
INSERT INTO `lang_definitions` VALUES (7439, 7195, 3, 'Reservado para uso del Tiempo Programado de Vacaciones');
INSERT INTO `lang_definitions` VALUES (7440, 7196, 3, 'Reservado para definir cuando un facultativo no podrá tener citas disponibles posteriores.');
INSERT INTO `lang_definitions` VALUES (7441, 7197, 3, 'Reservado para definir cuando un evento no ocurrió como se especificó.');
INSERT INTO `lang_definitions` VALUES (7442, 7198, 3, 'Reservados para definir cuando un facultativo puede tener citas disponibles posteriores.');
INSERT INTO `lang_definitions` VALUES (7443, 7199, 3, 'Reinicio');
INSERT INTO `lang_definitions` VALUES (7444, 7203, 3, 'Resetear credenciales del Portal externo');
INSERT INTO `lang_definitions` VALUES (7445, 7204, 3, 'Resetear credenciales del Portal interno');
INSERT INTO `lang_definitions` VALUES (7446, 7210, 3, 'Resuelto');
INSERT INTO `lang_definitions` VALUES (7447, 7213, 3, 'Respiración');
INSERT INTO `lang_definitions` VALUES (7448, 7214, 3, 'Esfuerzo al Respirar');
INSERT INTO `lang_definitions` VALUES (7449, 7215, 3, 'Respiratorias');
INSERT INTO `lang_definitions` VALUES (7450, 7220, 3, 'Restringir a usuarios no autorizados el calendario de la clínica establecido en usuario admin.');
INSERT INTO `lang_definitions` VALUES (7451, 7221, 3, 'Restringir usuarios a Clínicas');
INSERT INTO `lang_definitions` VALUES (7452, 7222, 3, 'Entrenamiento Restringido');
INSERT INTO `lang_definitions` VALUES (7453, 7223, 3, 'Resultado');
INSERT INTO `lang_definitions` VALUES (7454, 7225, 3, 'Estado del resultado');
INSERT INTO `lang_definitions` VALUES (7455, 7226, 3, 'Estado del resultado o anormalidad ausente');
INSERT INTO `lang_definitions` VALUES (7456, 7227, 3, 'Resultado, use % como comodín');
INSERT INTO `lang_definitions` VALUES (7457, 7229, 3, 'Resultados y');
INSERT INTO `lang_definitions` VALUES (7458, 7230, 3, 'Resultados Encontrados para la Búsqueda');
INSERT INTO `lang_definitions` VALUES (7459, 7231, 3, 'Grupo Resultados');
INSERT INTO `lang_definitions` VALUES (7460, 7234, 3, 'Resultados por página');
INSERT INTO `lang_definitions` VALUES (7461, 7235, 3, 'Resultados / Detalles');
INSERT INTO `lang_definitions` VALUES (7462, 7238, 3, 'Examen de Retina');
INSERT INTO `lang_definitions` VALUES (7463, 7239, 3, 'Se retractó de la derecha:');
INSERT INTO `lang_definitions` VALUES (7464, 7240, 3, 'Volver');
INSERT INTO `lang_definitions` VALUES (7465, 7241, 3, 'Retorne la parte superior con su pago');
INSERT INTO `lang_definitions` VALUES (7466, 7244, 3, 'Retornar al calendario');
INSERT INTO `lang_definitions` VALUES (7467, 7246, 3, 'Vuelva a esta página y podrá completar el proceso de instalación ICD 10 haciendo click en la sección de la cabecera ICD 10');
INSERT INTO `lang_definitions` VALUES (7468, 7247, 3, 'Vuelva a esta página y podrá completar el proceso de instalación ICD 9 haciendo click en la sección de la cabecera ICD 9');
INSERT INTO `lang_definitions` VALUES (7469, 7248, 3, 'Vuelva a esta página y podrá completar el proceso de instalación RxNorm haciendo click en la sección de la cabecera RXNORM');
INSERT INTO `lang_definitions` VALUES (7470, 7249, 3, 'Vuelva a esta página y podrá completar el proceso de instalación Snomed haciendo click en la sección de la cabecera SNOMED');
INSERT INTO `lang_definitions` VALUES (7471, 7251, 3, 'Valor Devuelto');
INSERT INTO `lang_definitions` VALUES (7472, 7252, 3, 'Visita de Vuelta');
INSERT INTO `lang_definitions` VALUES (7473, 7253, 3, 'Volvió a jugar');
INSERT INTO `lang_definitions` VALUES (7474, 7265, 3, 'Examen de PMH:');
INSERT INTO `lang_definitions` VALUES (7475, 7267, 3, 'Revisión de los sistemas');
INSERT INTO `lang_definitions` VALUES (7476, 7268, 3, 'Revisión de chequeos de sistemas');
INSERT INTO `lang_definitions` VALUES (7477, 7271, 3, 'Revisado');
INSERT INTO `lang_definitions` VALUES (7478, 7274, 3, 'Revisión');
INSERT INTO `lang_definitions` VALUES (7479, 7275, 3, 'Artritis reumatoide');
INSERT INTO `lang_definitions` VALUES (7480, 7276, 3, 'Artritis reumatoide');
INSERT INTO `lang_definitions` VALUES (7481, 7278, 3, 'Derecho');
INSERT INTO `lang_definitions` VALUES (7482, 7281, 3, 'Oido Derecho');
INSERT INTO `lang_definitions` VALUES (7483, 7282, 3, 'oido derecho');
INSERT INTO `lang_definitions` VALUES (7484, 7289, 3, 'Derecho:');
INSERT INTO `lang_definitions` VALUES (7485, 7290, 3, 'Zumbido en Oídos');
INSERT INTO `lang_definitions` VALUES (7486, 7291, 3, 'Sonido en Oídos');
INSERT INTO `lang_definitions` VALUES (7487, 7293, 3, 'Factores Riesgo');
INSERT INTO `lang_definitions` VALUES (7488, 7294, 3, 'Nivel de Riesgo');
INSERT INTO `lang_definitions` VALUES (7489, 7297, 3, 'RLL:');
INSERT INTO `lang_definitions` VALUES (7490, 7302, 3, 'ROM');
INSERT INTO `lang_definitions` VALUES (7491, 7303, 3, 'Rumano');
INSERT INTO `lang_definitions` VALUES (7492, 7310, 3, 'Lista');
INSERT INTO `lang_definitions` VALUES (7493, 7313, 3, 'Ruta');
INSERT INTO `lang_definitions` VALUES (7494, 7314, 3, 'Ruta de administracion si aplicable');
INSERT INTO `lang_definitions` VALUES (7495, 7315, 3, 'Encaminado');
INSERT INTO `lang_definitions` VALUES (7496, 7316, 3, 'Filas');
INSERT INTO `lang_definitions` VALUES (7497, 7318, 3, 'RRR sin MOR');
INSERT INTO `lang_definitions` VALUES (7498, 7319, 3, 'Frotar');
INSERT INTO `lang_definitions` VALUES (7499, 7320, 3, 'Frotaciones:');
INSERT INTO `lang_definitions` VALUES (7500, 7321, 3, 'Regla');
INSERT INTO `lang_definitions` VALUES (7501, 7322, 3, 'Añadir regla');
INSERT INTO `lang_definitions` VALUES (7502, 7323, 3, 'Detalle Regla');
INSERT INTO `lang_definitions` VALUES (7503, 7325, 3, 'Editar Regla');
INSERT INTO `lang_definitions` VALUES (7504, 7328, 3, 'Ajuste Regla');
INSERT INTO `lang_definitions` VALUES (7505, 7331, 3, 'Reglas');
INSERT INTO `lang_definitions` VALUES (7506, 7333, 3, 'Configuración Regla');
INSERT INTO `lang_definitions` VALUES (7507, 7336, 3, 'Ejecutando comando');
INSERT INTO `lang_definitions` VALUES (7508, 7337, 3, 'ruptura');
INSERT INTO `lang_definitions` VALUES (7509, 7339, 3, 'Ruso');
INSERT INTO `lang_definitions` VALUES (7510, 7341, 3, 'Receta');
INSERT INTO `lang_definitions` VALUES (7511, 7342, 3, 'Receta');
INSERT INTO `lang_definitions` VALUES (7512, 7343, 3, 'Margen inferior Receta (px)');
INSERT INTO `lang_definitions` VALUES (7513, 7347, 3, 'Receta Activa DEA#');
INSERT INTO `lang_definitions` VALUES (7514, 7348, 3, 'Receta Activa NPI');
INSERT INTO `lang_definitions` VALUES (7515, 7349, 3, 'Receta Activa Estado Lic.#');
INSERT INTO `lang_definitions` VALUES (7516, 7352, 3, 'Margen izquierdo Receta (px)');
INSERT INTO `lang_definitions` VALUES (7517, 7355, 3, 'Tamaño papel Receta');
INSERT INTO `lang_definitions` VALUES (7518, 7356, 3, 'Margen derecho Receta (px)');
INSERT INTO `lang_definitions` VALUES (7519, 7357, 3, 'Mostrar Receta DEA#');
INSERT INTO `lang_definitions` VALUES (7520, 7358, 3, 'Mostrar Receta NPI');
INSERT INTO `lang_definitions` VALUES (7521, 7359, 3, 'Mostrar Receta Estado Lic.#');
INSERT INTO `lang_definitions` VALUES (7522, 7360, 3, 'Margen superior Receta (px)');
INSERT INTO `lang_definitions` VALUES (7523, 7365, 3, 'Receta Normal (RxNorm)');
INSERT INTO `lang_definitions` VALUES (7524, 7366, 3, 'Base de datos RxNorm');
INSERT INTO `lang_definitions` VALUES (7525, 7369, 3, 'S');
INSERT INTO `lang_definitions` VALUES (7526, 7370, 3, 'S.S.');
INSERT INTO `lang_definitions` VALUES (7527, 7371, 3, 'S3:');
INSERT INTO `lang_definitions` VALUES (7528, 7372, 3, 'S4:');
INSERT INTO `lang_definitions` VALUES (7529, 7373, 3, 'SA ** para leer la licencia por favor lea la documentos/licencia.texto o visite * http://www.gnu.org/copyleft/gpl.html * * / / /');
INSERT INTO `lang_definitions` VALUES (7530, 7375, 3, 'Venta');
INSERT INTO `lang_definitions` VALUES (7531, 7376, 3, 'Ventas');
INSERT INTO `lang_definitions` VALUES (7532, 7377, 3, 'Ventas por Partida');
INSERT INTO `lang_definitions` VALUES (7533, 7378, 3, 'Informe de ventas por producto');
INSERT INTO `lang_definitions` VALUES (7534, 7379, 3, 'Saliva');
INSERT INTO `lang_definitions` VALUES (7535, 7380, 3, 'Mismo Día');
INSERT INTO `lang_definitions` VALUES (7536, 7381, 3, 'Samoano');
INSERT INTO `lang_definitions` VALUES (7537, 7382, 3, 'Muestra');
INSERT INTO `lang_definitions` VALUES (7538, 7383, 3, 'Tipo de sanción');
INSERT INTO `lang_definitions` VALUES (7539, 7388, 3, 'Sabado');
INSERT INTO `lang_definitions` VALUES (7540, 7389, 3, 'Sábado y Domingo');
INSERT INTO `lang_definitions` VALUES (7541, 7390, 3, 'Sabado');
INSERT INTO `lang_definitions` VALUES (7542, 7391, 3, 'Guardar');
INSERT INTO `lang_definitions` VALUES (7543, 7392, 3, 'SALVAR');
INSERT INTO `lang_definitions` VALUES (7544, 7395, 3, 'Guardar y Cerrar');
INSERT INTO `lang_definitions` VALUES (7545, 7398, 3, 'Guardar y Distribuir');
INSERT INTO `lang_definitions` VALUES (7546, 7401, 3, 'Guradar como Nuevo');
INSERT INTO `lang_definitions` VALUES (7547, 7402, 3, 'Guarda como nota nueva');
INSERT INTO `lang_definitions` VALUES (7548, 7405, 3, 'Guardar configuración del certificado');
INSERT INTO `lang_definitions` VALUES (7549, 7406, 3, 'Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (7550, 7414, 3, 'Guardar Formulario');
INSERT INTO `lang_definitions` VALUES (7551, 7415, 3, 'Guardar Vacunación');
INSERT INTO `lang_definitions` VALUES (7552, 7416, 3, 'Guardar Nuevo Campo');
INSERT INTO `lang_definitions` VALUES (7553, 7417, 3, 'Guardar Nuevo Grupo');
INSERT INTO `lang_definitions` VALUES (7554, 7418, 3, 'Guardar Nueva Lista');
INSERT INTO `lang_definitions` VALUES (7555, 7419, 3, 'Guardar la nueva plantilla');
INSERT INTO `lang_definitions` VALUES (7556, 7421, 3, 'Guardar Demograficas de Paciente');
INSERT INTO `lang_definitions` VALUES (7557, 7425, 3, 'Nº Identificación gráfico guardado correctamente');
INSERT INTO `lang_definitions` VALUES (7558, 7427, 3, 'Guardar ITransacción');
INSERT INTO `lang_definitions` VALUES (7559, 7433, 3, 'Escaneados');
INSERT INTO `lang_definitions` VALUES (7560, 7434, 3, 'Nota Escaneada de visita');
INSERT INTO `lang_definitions` VALUES (7561, 7435, 3, 'Directorio del escáner');
INSERT INTO `lang_definitions` VALUES (7562, 7436, 3, 'Escáner En');
INSERT INTO `lang_definitions` VALUES (7563, 7439, 3, 'Horario');
INSERT INTO `lang_definitions` VALUES (7564, 7440, 3, 'Calendario de Clínicas:');
INSERT INTO `lang_definitions` VALUES (7565, 7451, 3, 'Nota Escolar');
INSERT INTO `lang_definitions` VALUES (7566, 7456, 3, 'Escoliosis');
INSERT INTO `lang_definitions` VALUES (7567, 7463, 3, 'SE');
INSERT INTO `lang_definitions` VALUES (7568, 7464, 3, 'SE Dirección');
INSERT INTO `lang_definitions` VALUES (7569, 7465, 3, 'SE Ciudad');
INSERT INTO `lang_definitions` VALUES (7570, 7466, 3, 'SE Pais');
INSERT INTO `lang_definitions` VALUES (7571, 7467, 3, 'SE Localidad');
INSERT INTO `lang_definitions` VALUES (7572, 7468, 3, 'SE Código Postal');
INSERT INTO `lang_definitions` VALUES (7573, 7469, 3, 'SE Estado');
INSERT INTO `lang_definitions` VALUES (7574, 7470, 3, 'SE Código Postal');
INSERT INTO `lang_definitions` VALUES (7575, 7471, 3, 'Buscar');
INSERT INTO `lang_definitions` VALUES (7576, 7473, 3, 'Buscar');
INSERT INTO `lang_definitions` VALUES (7577, 7474, 3, 'Búsqar Nuevamente');
INSERT INTO `lang_definitions` VALUES (7578, 7475, 3, 'Buscar en todas las columnas');
INSERT INTO `lang_definitions` VALUES (7579, 7476, 3, 'Buscar Cita');
INSERT INTO `lang_definitions` VALUES (7580, 7478, 3, 'Búscar por:');
INSERT INTO `lang_definitions` VALUES (7581, 7480, 3, 'Buscar por');
INSERT INTO `lang_definitions` VALUES (7582, 7481, 3, 'Búscar para:');
INSERT INTO `lang_definitions` VALUES (7583, 7482, 3, 'Buscar en');
INSERT INTO `lang_definitions` VALUES (7584, 7483, 3, 'Buscar en');
INSERT INTO `lang_definitions` VALUES (7585, 7485, 3, 'Buscar o Añadir Paciente');
INSERT INTO `lang_definitions` VALUES (7586, 7486, 3, 'Buscar Pago');
INSERT INTO `lang_definitions` VALUES (7587, 7488, 3, 'Resultados de búsqueda');
INSERT INTO `lang_definitions` VALUES (7588, 7489, 3, 'Resultados de la Búsqueda:');
INSERT INTO `lang_definitions` VALUES (7589, 7490, 3, 'Buscar seleccionados');
INSERT INTO `lang_definitions` VALUES (7590, 7492, 3, 'Cadena buscada no coincide con la lista de la base de datos');
INSERT INTO `lang_definitions` VALUES (7591, 7493, 3, 'Cadena buscada debe tener al menos tres caracteres');
INSERT INTO `lang_definitions` VALUES (7592, 7494, 3, 'Buscar Texto');
INSERT INTO `lang_definitions` VALUES (7593, 7495, 3, 'Búsqueda de eventos');
INSERT INTO `lang_definitions` VALUES (7594, 7496, 3, 'Buscar/añadir');
INSERT INTO `lang_definitions` VALUES (7595, 7497, 3, 'Buscar/Añadir Asegurador');
INSERT INTO `lang_definitions` VALUES (7596, 7498, 3, 'Buscando las citas');
INSERT INTO `lang_definitions` VALUES (7597, 7499, 3, 'Buscando');
INSERT INTO `lang_definitions` VALUES (7598, 7500, 3, 'Cinturón de Seguridad');
INSERT INTO `lang_definitions` VALUES (7599, 7501, 3, 'Uso de cinturón de seguridad');
INSERT INTO `lang_definitions` VALUES (7600, 7502, 3, 'Uso de cinturón de seguridad');
INSERT INTO `lang_definitions` VALUES (7601, 7503, 3, 'Segundo');
INSERT INTO `lang_definitions` VALUES (7602, 7504, 3, 'segundo');
INSERT INTO `lang_definitions` VALUES (7603, 7506, 3, 'Secundario');
INSERT INTO `lang_definitions` VALUES (7604, 7507, 3, 'Seguro Secundario');
INSERT INTO `lang_definitions` VALUES (7605, 7508, 3, 'Datos de Seguro Secundario');
INSERT INTO `lang_definitions` VALUES (7606, 7509, 3, 'Proveedor del Seguro Secundario');
INSERT INTO `lang_definitions` VALUES (7607, 7510, 3, 'Tipo secundario de Medicare');
INSERT INTO `lang_definitions` VALUES (7608, 7512, 3, 'ID de Sección');
INSERT INTO `lang_definitions` VALUES (7609, 7513, 3, 'ID de Sección');
INSERT INTO `lang_definitions` VALUES (7610, 7522, 3, 'Seguridad');
INSERT INTO `lang_definitions` VALUES (7611, 7523, 3, 'Ver Todo');
INSERT INTO `lang_definitions` VALUES (7612, 7525, 3, 'Ver Autorizaciones');
INSERT INTO `lang_definitions` VALUES (7613, 7526, 3, 'Véase el Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (7614, 7527, 3, 'Ver los mensajes de la última serie de reclamaciones generadas');
INSERT INTO `lang_definitions` VALUES (7615, 7529, 3, 'Visto en');
INSERT INTO `lang_definitions` VALUES (7616, 7533, 3, 'Convulsiones');
INSERT INTO `lang_definitions` VALUES (7617, 7534, 3, 'Seleción');
INSERT INTO `lang_definitions` VALUES (7618, 7535, 3, 'Seleción');
INSERT INTO `lang_definitions` VALUES (7619, 7536, 3, 'seleccionar');
INSERT INTO `lang_definitions` VALUES (7620, 7537, 3, 'Seleccionar un componente');
INSERT INTO `lang_definitions` VALUES (7621, 7538, 3, 'Seleccionar un contexto');
INSERT INTO `lang_definitions` VALUES (7622, 7540, 3, 'Seleccione un intervalo de tiempo');
INSERT INTO `lang_definitions` VALUES (7623, 7541, 3, 'Seleccionar un usuario');
INSERT INTO `lang_definitions` VALUES (7624, 7543, 3, 'Seleccionar Todos');
INSERT INTO `lang_definitions` VALUES (7625, 7546, 3, 'Elegir entrads CAMOS para impresión');
INSERT INTO `lang_definitions` VALUES (7626, 7548, 3, 'Seleccionar una categoría');
INSERT INTO `lang_definitions` VALUES (7627, 7550, 3, 'Seleccionar las casillas correspondientes para borrar');
INSERT INTO `lang_definitions` VALUES (7628, 7551, 3, 'Seleccionar el criterio para eliminar');
INSERT INTO `lang_definitions` VALUES (7629, 7553, 3, 'Seleccione datos requeridos para De Identificación');
INSERT INTO `lang_definitions` VALUES (7630, 7554, 3, 'Seleccione datos para incluir en los datos de De Identificación');
INSERT INTO `lang_definitions` VALUES (7631, 7555, 3, 'Elegir fecha');
INSERT INTO `lang_definitions` VALUES (7632, 7556, 3, 'Seleccione plantilla deseada');
INSERT INTO `lang_definitions` VALUES (7633, 7557, 3, 'Seleccione diagnóstico');
INSERT INTO `lang_definitions` VALUES (7634, 7558, 3, 'Seleccione diagnóstico para identificación DE requerida');
INSERT INTO `lang_definitions` VALUES (7635, 7559, 3, 'Seleccione Medicamento');
INSERT INTO `lang_definitions` VALUES (7636, 7560, 3, 'Seleccione Medicamentos');
INSERT INTO `lang_definitions` VALUES (7637, 7561, 3, 'Seleccione los medicamentos para la solicitud anónima');
INSERT INTO `lang_definitions` VALUES (7638, 7562, 3, 'Seleccione fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (7639, 7563, 3, 'Seleccione encuentro');
INSERT INTO `lang_definitions` VALUES (7640, 7564, 3, 'Elegir campo');
INSERT INTO `lang_definitions` VALUES (7641, 7566, 3, 'Seleccione Sector');
INSERT INTO `lang_definitions` VALUES (7642, 7567, 3, 'Seleccionar para Imprimir');
INSERT INTO `lang_definitions` VALUES (7643, 7570, 3, 'Seleccione vacunas');
INSERT INTO `lang_definitions` VALUES (7644, 7571, 3, 'Seleccione las vacunas para la solicitud anónima');
INSERT INTO `lang_definitions` VALUES (7645, 7572, 3, 'Seleccionar Seguro, escribiendo');
INSERT INTO `lang_definitions` VALUES (7646, 7573, 3, 'Seleccione Incidencia');
INSERT INTO `lang_definitions` VALUES (7647, 7574, 3, 'Seleccione items');
INSERT INTO `lang_definitions` VALUES (7648, 7575, 3, 'Seleccionar idioma');
INSERT INTO `lang_definitions` VALUES (7649, 7578, 3, 'Seleccione uno');
INSERT INTO `lang_definitions` VALUES (7650, 7579, 3, 'Seleccione uno o más códigos de diagnóstico para justificar el servicio');
INSERT INTO `lang_definitions` VALUES (7651, 7580, 3, 'Seleccione uno o más archivos para subir');
INSERT INTO `lang_definitions` VALUES (7652, 7581, 3, 'Seleccione salida');
INSERT INTO `lang_definitions` VALUES (7653, 7583, 3, 'SELECCIONAR PLAN');
INSERT INTO `lang_definitions` VALUES (7654, 7585, 3, 'Seleccione origen del pedido');
INSERT INTO `lang_definitions` VALUES (7655, 7586, 3, 'Selecionar rol');
INSERT INTO `lang_definitions` VALUES (7656, 7588, 3, 'Seleccionar fuente');
INSERT INTO `lang_definitions` VALUES (7657, 7590, 3, 'Seleccionar plantilla');
INSERT INTO `lang_definitions` VALUES (7658, 7591, 3, 'Elija los items de configuración para exportar');
INSERT INTO `lang_definitions` VALUES (7659, 7596, 3, 'Elija la incidencia principal responsable para los eventos fallidos en este día');
INSERT INTO `lang_definitions` VALUES (7660, 7599, 3, 'Seleccione pista');
INSERT INTO `lang_definitions` VALUES (7661, 7601, 3, 'Seleccionar usuario');
INSERT INTO `lang_definitions` VALUES (7662, 7603, 3, 'Seleccionar usuarios de la lista desplegable');
INSERT INTO `lang_definitions` VALUES (7663, 7604, 3, 'Seleccionar que idiomas, si los hay, pueden ser elegidos al inicio de sesión. (solo si arriba todos los idiomas permitidos está desactivados)');
INSERT INTO `lang_definitions` VALUES (7664, 7606, 3, 'Seleccione Sí para confirmar la eliminación del grupo');
INSERT INTO `lang_definitions` VALUES (7665, 7609, 3, 'Seleccionado');
INSERT INTO `lang_definitions` VALUES (7666, 7610, 3, 'Visita seleccionada');
INSERT INTO `lang_definitions` VALUES (7667, 7613, 3, 'Seleccionando ésto se creará un mensaje que necesita ser procesado por cada receptor individualmente (ésto no es una tarea de grupo)');
INSERT INTO `lang_definitions` VALUES (7668, 7615, 3, 'Uno Mismo');
INSERT INTO `lang_definitions` VALUES (7669, 7616, 3, 'Paga del uno mismo');
INSERT INTO `lang_definitions` VALUES (7670, 7618, 3, 'Enviar');
INSERT INTO `lang_definitions` VALUES (7671, 7619, 3, 'Enviar Fecha aviso');
INSERT INTO `lang_definitions` VALUES (7672, 7620, 3, 'Enviar un Recordatorio');
INSERT INTO `lang_definitions` VALUES (7673, 7625, 3, 'Envíe en curso');
INSERT INTO `lang_definitions` VALUES (7674, 7627, 3, 'enviar mensaje');
INSERT INTO `lang_definitions` VALUES (7675, 7630, 3, 'Batch de Envío de Recordatorios');
INSERT INTO `lang_definitions` VALUES (7676, 7631, 3, 'Enviar recordatorios a pacientes por preferencia para preventiva/seguimiento de cuidados.');
INSERT INTO `lang_definitions` VALUES (7677, 7634, 3, 'Enviar resúmenes con derivados');
INSERT INTO `lang_definitions` VALUES (7678, 7635, 3, 'Enviar este file');
INSERT INTO `lang_definitions` VALUES (7679, 7636, 3, 'Enviar este mensaje');
INSERT INTO `lang_definitions` VALUES (7680, 7637, 3, 'Enviar a');
INSERT INTO `lang_definitions` VALUES (7681, 7640, 3, 'Enviar a todos');
INSERT INTO `lang_definitions` VALUES (7682, 7642, 3, 'Enviar al portal');
INSERT INTO `lang_definitions` VALUES (7683, 7643, 3, 'Enviar al portal');
INSERT INTO `lang_definitions` VALUES (7684, 7645, 3, 'Remitente');
INSERT INTO `lang_definitions` VALUES (7685, 7646, 3, 'Nº Identificación del remitente');
INSERT INTO `lang_definitions` VALUES (7686, 7647, 3, 'Remitente ID (ISA06)');
INSERT INTO `lang_definitions` VALUES (7687, 7648, 3, 'Calificador del remitente ID (ISA05)');
INSERT INTO `lang_definitions` VALUES (7688, 7653, 3, 'Sensibilidades');
INSERT INTO `lang_definitions` VALUES (7689, 7655, 3, 'Sensibilidad:');
INSERT INTO `lang_definitions` VALUES (7690, 7656, 3, 'Examen sensorial normal');
INSERT INTO `lang_definitions` VALUES (7691, 7657, 3, 'Enviado');
INSERT INTO `lang_definitions` VALUES (7692, 7658, 3, 'Enviado - Confirmado');
INSERT INTO `lang_definitions` VALUES (7693, 7659, 3, 'Enviado por, dejar en blanco para todos');
INSERT INTO `lang_definitions` VALUES (7694, 7660, 3, 'Enviado por:');
INSERT INTO `lang_definitions` VALUES (7695, 7661, 3, 'Fecha de envio');
INSERT INTO `lang_definitions` VALUES (7696, 7662, 3, 'Incidencias Enviadas');
INSERT INTO `lang_definitions` VALUES (7697, 7663, 3, '¿Enviar Registros Médicos?');
INSERT INTO `lang_definitions` VALUES (7698, 7664, 3, 'Enviado con éxito');
INSERT INTO `lang_definitions` VALUES (7699, 7667, 3, 'Enviado a Impresora');
INSERT INTO `lang_definitions` VALUES (7700, 7668, 3, 'Enviado a, dejar en blanco para todos');
INSERT INTO `lang_definitions` VALUES (7701, 7672, 3, 'Sep');
INSERT INTO `lang_definitions` VALUES (7702, 7673, 3, 'Separado');
INSERT INTO `lang_definitions` VALUES (7703, 7674, 3, 'Septiembre');
INSERT INTO `lang_definitions` VALUES (7704, 7676, 3, 'Secuencia');
INSERT INTO `lang_definitions` VALUES (7705, 7683, 3, 'Servicio');
INSERT INTO `lang_definitions` VALUES (7706, 7685, 3, 'Categoría de Servicio');
INSERT INTO `lang_definitions` VALUES (7707, 7686, 3, 'Código Servicio');
INSERT INTO `lang_definitions` VALUES (7708, 7687, 3, 'Informe de códigos de servicio Financiero');
INSERT INTO `lang_definitions` VALUES (7709, 7688, 3, 'Códigos Servicio');
INSERT INTO `lang_definitions` VALUES (7710, 7689, 3, 'Fecha de Servicio');
INSERT INTO `lang_definitions` VALUES (7711, 7690, 3, 'Fecha de Servicio:');
INSERT INTO `lang_definitions` VALUES (7712, 7694, 3, 'Servicio de Localización');
INSERT INTO `lang_definitions` VALUES (7713, 7696, 3, 'Servicio prestado por el especialista');
INSERT INTO `lang_definitions` VALUES (7714, 7698, 3, 'Informe de servicio');
INSERT INTO `lang_definitions` VALUES (7715, 7699, 3, 'Informe de servicio sólo');
INSERT INTO `lang_definitions` VALUES (7716, 7700, 3, 'Servicios');
INSERT INTO `lang_definitions` VALUES (7717, 7701, 3, 'Servicios por Categoría');
INSERT INTO `lang_definitions` VALUES (7718, 7702, 3, 'Servicios proporcionados');
INSERT INTO `lang_definitions` VALUES (7719, 7703, 3, 'Servicios prestados');
INSERT INTO `lang_definitions` VALUES (7720, 7704, 3, 'Servicios/Productos');
INSERT INTO `lang_definitions` VALUES (7721, 7705, 3, 'Tipo Sesión');
INSERT INTO `lang_definitions` VALUES (7722, 7706, 3, 'Set');
INSERT INTO `lang_definitions` VALUES (7723, 7707, 3, 'Habilitar cookie para recordar el centro seleccionado entre sesiones.');
INSERT INTO `lang_definitions` VALUES (7724, 7708, 3, 'Definir como terminado');
INSERT INTO `lang_definitions` VALUES (7725, 7712, 3, 'Asignar este para la ruta absoluta. Para crear certificados clientes SSL para HTTPPS.');
INSERT INTO `lang_definitions` VALUES (7726, 7713, 3, 'Ajustar a');
INSERT INTO `lang_definitions` VALUES (7727, 7714, 3, 'Ajustar por defecto');
INSERT INTO `lang_definitions` VALUES (7728, 7717, 3, 'Ajustar el número de versión en la base de datos...');
INSERT INTO `lang_definitions` VALUES (7729, 7718, 3, 'Ajustes');
INSERT INTO `lang_definitions` VALUES (7730, 7721, 3, 'Migraña Grave');
INSERT INTO `lang_definitions` VALUES (7731, 7723, 3, 'Severidad del dolor');
INSERT INTO `lang_definitions` VALUES (7732, 7724, 3, 'Severidad del dolor');
INSERT INTO `lang_definitions` VALUES (7733, 7725, 3, 'Sexo');
INSERT INTO `lang_definitions` VALUES (7734, 7726, 3, 'Enfermedades de Transmisión Sexual');
INSERT INTO `lang_definitions` VALUES (7735, 7729, 3, 'Conpartir');
INSERT INTO `lang_definitions` VALUES (7736, 7730, 3, 'Intérprete de comandos para imprimir desde el servidor');
INSERT INTO `lang_definitions` VALUES (7737, 7736, 3, 'Falta de aire al respirar');
INSERT INTO `lang_definitions` VALUES (7738, 7737, 3, 'Falta de Aliento');
INSERT INTO `lang_definitions` VALUES (7739, 7738, 3, 'Falta de Aliento 2');
INSERT INTO `lang_definitions` VALUES (7740, 7739, 3, 'Registro de Tiro');
INSERT INTO `lang_definitions` VALUES (7741, 7740, 3, 'Fecha de Expediente de Tiro:');
INSERT INTO `lang_definitions` VALUES (7742, 7742, 3, 'debe ser como nnnnn-nnnn-nn');
INSERT INTO `lang_definitions` VALUES (7743, 7743, 3, 'Deben ser dos letras');
INSERT INTO `lang_definitions` VALUES (7744, 7744, 3, 'Debe contener 10 dígitos');
INSERT INTO `lang_definitions` VALUES (7745, 7745, 3, 'Debe contener sólo 10 dígitos');
INSERT INTO `lang_definitions` VALUES (7746, 7746, 3, 'Hombro');
INSERT INTO `lang_definitions` VALUES (7747, 7747, 3, 'Hombro + Clavicula');
INSERT INTO `lang_definitions` VALUES (7748, 7748, 3, 'Prob. de Hombro');
INSERT INTO `lang_definitions` VALUES (7749, 7749, 3, 'Presente');
INSERT INTO `lang_definitions` VALUES (7750, 7750, 3, 'Mostar Activo');
INSERT INTO `lang_definitions` VALUES (7751, 7753, 3, 'Mostrar Todo');
INSERT INTO `lang_definitions` VALUES (7752, 7757, 3, 'Mostrar Todas las Transacciones');
INSERT INTO `lang_definitions` VALUES (7753, 7758, 3, 'Occupado');
INSERT INTO `lang_definitions` VALUES (7754, 7759, 3, 'Mostrar Sólo Autorizado');
INSERT INTO `lang_definitions` VALUES (7755, 7760, 3, 'Mostrar Horas Disponibles');
INSERT INTO `lang_definitions` VALUES (7756, 7761, 3, 'Mostrar ambos US y métrica (unidad principal es métrica)');
INSERT INTO `lang_definitions` VALUES (7757, 7762, 3, 'Mostrar ambos US y métrica (unidad principal es US)');
INSERT INTO `lang_definitions` VALUES (7758, 7764, 3, 'Mostrar Detalles');
INSERT INTO `lang_definitions` VALUES (7759, 7768, 3, 'Mostrar Gráfico');
INSERT INTO `lang_definitions` VALUES (7760, 7769, 3, '¿Demuestre el texto de cernido del acontecimiento en mouseover?');
INSERT INTO `lang_definitions` VALUES (7761, 7770, 3, 'Mostrar el número de eventos en las páginas de administrador?');
INSERT INTO `lang_definitions` VALUES (7762, 7771, 3, 'Mostrar Inactivo');
INSERT INTO `lang_definitions` VALUES (7763, 7775, 3, 'Mostrar Menú');
INSERT INTO `lang_definitions` VALUES (7764, 7776, 3, 'Mostrar sólo métrica');
INSERT INTO `lang_definitions` VALUES (7765, 7779, 3, 'Cuantos eventos mostrar en paginas de admin');
INSERT INTO `lang_definitions` VALUES (7766, 7784, 3, 'Mostrar notas de pacientes');
INSERT INTO `lang_definitions` VALUES (7767, 7787, 3, 'Mostrar primario completo');
INSERT INTO `lang_definitions` VALUES (7768, 7790, 3, 'Mostrar avisos');
INSERT INTO `lang_definitions` VALUES (7769, 7791, 3, 'Mostrar Informe');
INSERT INTO `lang_definitions` VALUES (7770, 7792, 3, 'Mostrar enlace búsqueda/aceptar en bloque?');
INSERT INTO `lang_definitions` VALUES (7771, 7796, 3, 'Mostrar el formulario de estado personalizado para agregar a lista de widget (preguntará por el título y la abreviatura).');
INSERT INTO `lang_definitions` VALUES (7772, 7800, 3, 'Mostrar sólo no facturados');
INSERT INTO `lang_definitions` VALUES (7773, 7801, 3, 'Mostrar solo USA');
INSERT INTO `lang_definitions` VALUES (7774, 7804, 3, 'Mostrando');
INSERT INTO `lang_definitions` VALUES (7775, 7812, 3, 'Hermanos');
INSERT INTO `lang_definitions` VALUES (7776, 7813, 3, 'Célula de hoz (falciforme)');
INSERT INTO `lang_definitions` VALUES (7777, 7814, 3, 'Sig');
INSERT INTO `lang_definitions` VALUES (7778, 7815, 3, 'Sigmoide/Colonoscopia');
INSERT INTO `lang_definitions` VALUES (7779, 7818, 3, 'Firma resultados laboratorio (escribir, opcional sólo añadir)');
INSERT INTO `lang_definitions` VALUES (7780, 7820, 3, 'Firmar Resultados');
INSERT INTO `lang_definitions` VALUES (7781, 7823, 3, 'Firma');
INSERT INTO `lang_definitions` VALUES (7782, 7826, 3, 'Firma:');
INSERT INTO `lang_definitions` VALUES (7783, 7827, 3, 'Receta firmada');
INSERT INTO `lang_definitions` VALUES (7784, 7829, 3, 'Hinchazón Significativa:');
INSERT INTO `lang_definitions` VALUES (7785, 7831, 3, 'Co-Pago Simplificado');
INSERT INTO `lang_definitions` VALUES (7786, 7832, 3, 'Demográficos Simplificados');
INSERT INTO `lang_definitions` VALUES (7787, 7833, 3, 'Prescripciones Simplificadas');
INSERT INTO `lang_definitions` VALUES (7788, 7834, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (7789, 7835, 3, 'Sinceramente,');
INSERT INTO `lang_definitions` VALUES (7790, 7837, 3, 'Soltero');
INSERT INTO `lang_definitions` VALUES (7791