# View Helper - Sitemap

The `sitemap()` helper is used for generating XML sitemaps, as defined by the
[Sitemaps XML format](http://www.sitemaps.org/protocol.php). Read more about
[Sitemaps on Wikipedia](http://en.wikipedia.org/wiki/Sitemaps).

By default, the sitemap helper uses [sitemap validators](https://github.com/zendframework/zend-validator)
to validate each element that is rendered. This can be disabled by calling
`$helper->setUseSitemapValidators(false)`.

### Sitemap XML elements

Element    | Type   | Description
---------- | ------ | -----------
loc        | string | Absolute URL to page. An absolute URL will be generated by the helper.
lastmod    | string | The date of last modification of the file, in W3C Datetime format. This time portion can be omitted if desired, and only use YYYY-MM-DD. The helper will try to retrieve the lastmod value from the page's custom property lastmod if it is set in the page. If the value is not a valid date, it is ignored.
changefreq | string | How frequently the page is likely to change. This value provides general information to search engines and may not correlate exactly to how often they crawl the page. Valid values are: "always", "hourly", "daily", "weekly", "monthly", "yearly", and "never". The helper will try to retrieve the changefreq value from the page's custom property changefreq if it is set in the page. If the value is not valid, it is ignored.
priority   | float  | The priority of this URL relative to other URLs on your site. Valid values range from 0.0 to 1.0. The helper will try to retrieve the priority value from the page's custom property priority if it is set in the page. If the value is not valid, it is ignored.

> ### Validation only when enabled
>
> If you disable sitemap validators, the custom properties (see table) are not
> validated at all.

The sitemap helper also supports [Sitemap XSD Schema](http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd)
validation of the generated sitemap. This is disabled by default, since it will
require a request to the schema file. It can be enabled with
`$helper->setUseSchemaValidation(true)`.

Methods in the sitemap helper:

Method signature                                        | Description
------------------------------------------------------- | -----------
`getFormatOutput() : bool`                              | Retrieve the flag indicating whether or not generated XML should be formatted. Default is `false`.
`setFormatOutput(bool $flag) : self`                    | Set the flag indicating whether or not generated XML should be formatted. The flag corresponds to the the `formatOutput` property of the native `DOMDocument` class. Read more in the [DOMDocument documentation](http://php.net/domdocument).
`getUseXmlDeclaration() : bool`                         | Retrieve the flag indicating whether or not to emit the XML declaration when rendering; defaults to `true`.
`setUseXmlDeclaration(bool $flag) : self`               | Set the flag indicating whether or not to emit the XML declaration when rendering.
`getUseSitemapValidators() : bool`                      | Retrieve the flag indicating whether or not sitemap validators should be used when generating the DOM; default is `true`.
`setUseSitemapValidators(bool $flag) : self`            | Set the flag indicating whether or not sitemap validators should be used when generating the DOM.
`getUseSchemaValidation() : bool`                       | Retrieve the flag indicating whether or not the helper should use XML schema validation when generating the DOM; default is `false`.
`setUseSchemaValidation(bool $flag) : self`             | Set the flag indicating whether or not the helper should use XML schema validation when generating the DOM.
`getServerUrl() : string`                               | Retrieve the server URL to prepend to non-absolute URIs via the `url()` method; if none is present, it will be determined by the helper.
`setServerUrl(string $url) : self`                      | Set the base server URL to prepend to non-absolute URIs.
`url(AbstractPage $page) : string`                      | Generate an absolute URL for the provided page.
`getDomSitemap(AbstractContainer = null) : DOMDocument` | Generates a DOMDocument sitemap representation from the given container.

## Basic usage

This example shows how to render an *XML* sitemap based on the setup we did further up.

```php
// In a view script or layout:

// format output
$this->navigation()
      ->sitemap()
      ->setFormatOutput(true); // default is false

// Other possible methods:
// ->setUseXmlDeclaration(false);             // default is true
// ->setServerUrl('http://my.otherhost.com'); // default is to detect automatically

// print sitemap
echo $this->navigation()->sitemap();
```

Notice how pages that are invisible or pages with ACL roles incompatible with
the view helper are filtered out:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc>http://www.example.com/</loc>
  </url>
  <url>
    <loc>http://www.example.com/products</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server/faq</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server/editions</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server/requirements</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio/customers</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio/support</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/about</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/about/investors</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/news</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/news/press</loc>
  </url>
  <url>
    <loc>http://www.example.com/archive</loc>
  </url>
  <url>
    <loc>http://www.example.com/community</loc>
  </url>
  <url>
    <loc>http://www.example.com/community/account</loc>
  </url>
  <url>
    <loc>http://forums.example.com/</loc>
  </url>
</urlset>
```

## Rendering using no ACL role

Render the sitemap using no ACL role (should filter out `/community/account`):

```php
echo $this->navigation()->sitemap()
    ->setFormatOutput(true)
    ->setRole();
```

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc>http://www.example.com/</loc>
  </url>
  <url>
    <loc>http://www.example.com/products</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server/faq</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server/editions</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server/requirements</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio/customers</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio/support</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/about</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/about/investors</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/news</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/news/press</loc>
  </url>
  <url>
    <loc>http://www.example.com/archive</loc>
  </url>
  <url>
    <loc>http://www.example.com/community</loc>
  </url>
  <url>
    <loc>http://forums.example.com/</loc>
  </url>
</urlset>
```

## Rendering using a maximum depth

Render the sitemap using a maximum depth of 1.

```php
echo $this->navigation()->sitemap()
    ->setFormatOutput(true)
    ->setMaxDepth(1);
```

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc>http://www.example.com/</loc>
  </url>
  <url>
    <loc>http://www.example.com/products</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/server</loc>
  </url>
  <url>
    <loc>http://www.example.com/products/studio</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/about</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/about/investors</loc>
  </url>
  <url>
    <loc>http://www.example.com/company/news</loc>
  </url>
  <url>
    <loc>http://www.example.com/community</loc>
  </url>
  <url>
    <loc>http://www.example.com/community/account</loc>
  </url>
  <url>
    <loc>http://forums.example.com/</loc>
  </url>
</urlset>
```

> ### UTF-8 encoding used by default
>
> By default, zend-view uses UTF-8 as its default encoding.  If you want to use
> another encoding with `Sitemap`, you will have do three things:
>
> 1. Create a custom renderer and implement a `getEncoding()` method.
> 2. Create a custom rendering strategy that will return an instance of your custom renderer.
> 3. Attach the custom strategy in the `ViewEvent`.
>
> See the [example from the HeadStyle documentation](https://github.com/zendframework/zend-view)
> to see how you can achieve this.
