<?php namespace HL7\FHIR\STU3;

/*!
 * This class was generated with the PHPFHIR library (https://github.com/dcarbone/php-fhir) using
 * class definitions from HL7 FHIR (https://www.hl7.org/fhir/)
 * 
 * Class creation date: February 10th, 2018
 * 
 * PHPFHIR Copyright:
 * 
 * Copyright 2016-2017 Daniel Carbone (daniel.p.carbone@gmail.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

class PHPFHIRAutoloader
{
    const ROOT_DIR = __DIR__;

    /** @var array */
    private static $_classMap = array (
    'HL7\\FHIR\\STU3\\PHPFHIRParserMap' => 'HL7/FHIR/STU3/PHPFHIRParserMap.php',
    'HL7\\FHIR\\STU3\\PHPFHIRHelper' => 'HL7/FHIR/STU3/PHPFHIRHelper.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate' => 'HL7/FHIR/STU3/FHIRElement/FHIRDate.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime' => 'HL7/FHIR/STU3/FHIRElement/FHIRDateTime.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode' => 'HL7/FHIR/STU3/FHIRElement/FHIRCode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString' => 'HL7/FHIR/STU3/FHIRElement/FHIRString.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger' => 'HL7/FHIR/STU3/FHIRElement/FHIRInteger.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid' => 'HL7/FHIR/STU3/FHIRElement/FHIROid.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri' => 'HL7/FHIR/STU3/FHIRElement/FHIRUri.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUuid' => 'HL7/FHIR/STU3/FHIRElement/FHIRUuid.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant' => 'HL7/FHIR/STU3/FHIRElement/FHIRInstant.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean' => 'HL7/FHIR/STU3/FHIRElement/FHIRBoolean.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary' => 'HL7/FHIR/STU3/FHIRElement/FHIRBase64Binary.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt' => 'HL7/FHIR/STU3/FHIRElement/FHIRUnsignedInt.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown' => 'HL7/FHIR/STU3/FHIRElement/FHIRMarkdown.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime' => 'HL7/FHIR/STU3/FHIRElement/FHIRTime.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId' => 'HL7/FHIR/STU3/FHIRElement/FHIRId.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt' => 'HL7/FHIR/STU3/FHIRElement/FHIRPositiveInt.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal' => 'HL7/FHIR/STU3/FHIRElement/FHIRDecimal.php',
    'HL7\\FHIR\\STU3\\FHIRResourceContainer' => 'HL7/FHIR/STU3/FHIRResourceContainer.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension' => 'HL7/FHIR/STU3/FHIRElement/FHIRExtension.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBackboneElement' => 'HL7/FHIR/STU3/FHIRElement/FHIRBackboneElement.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative' => 'HL7/FHIR/STU3/FHIRElement/FHIRNarrative.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrativeStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRNarrativeStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement' => 'HL7/FHIR/STU3/FHIRElement.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference' => 'HL7/FHIR/STU3/FHIRElement/FHIRReference.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantity.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantityComparator.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod' => 'HL7/FHIR/STU3/FHIRElement/FHIRPeriod.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment' => 'HL7/FHIR/STU3/FHIRElement/FHIRAttachment.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantity/FHIRDuration.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantity/FHIRCount.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange' => 'HL7/FHIR/STU3/FHIRElement/FHIRRange.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation' => 'HL7/FHIR/STU3/FHIRElement/FHIRAnnotation.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantity/FHIRMoney.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier' => 'HL7/FHIR/STU3/FHIRElement/FHIRIdentifier.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifierUse' => 'HL7/FHIR/STU3/FHIRElement/FHIRIdentifierUse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding' => 'HL7/FHIR/STU3/FHIRElement/FHIRCoding.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature' => 'HL7/FHIR/STU3/FHIRElement/FHIRSignature.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData' => 'HL7/FHIR/STU3/FHIRElement/FHIRSampledData.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledDataDataType' => 'HL7/FHIR/STU3/FHIRElement/FHIRSampledDataDataType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio' => 'HL7/FHIR/STU3/FHIRElement/FHIRRatio.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantity/FHIRDistance.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuantity/FHIRAge.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept' => 'HL7/FHIR/STU3/FHIRElement/FHIRCodeableConcept.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta' => 'HL7/FHIR/STU3/FHIRElement/FHIRMeta.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress' => 'HL7/FHIR/STU3/FHIRElement/FHIRAddress.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddressUse' => 'HL7/FHIR/STU3/FHIRElement/FHIRAddressUse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddressType' => 'HL7/FHIR/STU3/FHIRElement/FHIRAddressType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTriggerDefinition' => 'HL7/FHIR/STU3/FHIRElement/FHIRTriggerDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTriggerType' => 'HL7/FHIR/STU3/FHIRElement/FHIRTriggerType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributor' => 'HL7/FHIR/STU3/FHIRElement/FHIRContributor.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributorType' => 'HL7/FHIR/STU3/FHIRElement/FHIRContributorType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataRequirement' => 'HL7/FHIR/STU3/FHIRElement/FHIRDataRequirement.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementCodeFilter' => 'HL7/FHIR/STU3/FHIRResource/FHIRDataRequirement/FHIRDataRequirementCodeFilter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementDateFilter' => 'HL7/FHIR/STU3/FHIRResource/FHIRDataRequirement/FHIRDataRequirementDateFilter.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDosage' => 'HL7/FHIR/STU3/FHIRElement/FHIRDosage.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifact' => 'HL7/FHIR/STU3/FHIRElement/FHIRRelatedArtifact.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifactType' => 'HL7/FHIR/STU3/FHIRElement/FHIRRelatedArtifactType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail' => 'HL7/FHIR/STU3/FHIRElement/FHIRContactDetail.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName' => 'HL7/FHIR/STU3/FHIRElement/FHIRHumanName.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNameUse' => 'HL7/FHIR/STU3/FHIRElement/FHIRNameUse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint' => 'HL7/FHIR/STU3/FHIRElement/FHIRContactPoint.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPointSystem' => 'HL7/FHIR/STU3/FHIRElement/FHIRContactPointSystem.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPointUse' => 'HL7/FHIR/STU3/FHIRElement/FHIRContactPointUse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext' => 'HL7/FHIR/STU3/FHIRElement/FHIRUsageContext.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming' => 'HL7/FHIR/STU3/FHIRElement/FHIRTiming.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTiming\\FHIRTimingRepeat' => 'HL7/FHIR/STU3/FHIRResource/FHIRTiming/FHIRTimingRepeat.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnitsOfTime' => 'HL7/FHIR/STU3/FHIRElement/FHIRUnitsOfTime.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventTiming' => 'HL7/FHIR/STU3/FHIRElement/FHIREventTiming.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRElementDefinition' => 'HL7/FHIR/STU3/FHIRElement/FHIRElementDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionConstraint' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionConstraint.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionMapping' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionMapping.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBase' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionBase.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionType' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionType.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionExample' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionExample.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionSlicing' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionSlicing.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBinding' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionBinding.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionDiscriminator' => 'HL7/FHIR/STU3/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionDiscriminator.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPropertyRepresentation' => 'HL7/FHIR/STU3/FHIRElement/FHIRPropertyRepresentation.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConstraintSeverity' => 'HL7/FHIR/STU3/FHIRElement/FHIRConstraintSeverity.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAggregationMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRAggregationMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReferenceVersionRules' => 'HL7/FHIR/STU3/FHIRElement/FHIRReferenceVersionRules.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSlicingRules' => 'HL7/FHIR/STU3/FHIRElement/FHIRSlicingRules.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBindingStrength' => 'HL7/FHIR/STU3/FHIRElement/FHIRBindingStrength.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDiscriminatorType' => 'HL7/FHIR/STU3/FHIRElement/FHIRDiscriminatorType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParameterDefinition' => 'HL7/FHIR/STU3/FHIRElement/FHIRParameterDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDomainResource' => 'HL7/FHIR/STU3/FHIRResource/FHIRDomainResource.php',
    'HL7\\FHIR\\STU3\\FHIRResource' => 'HL7/FHIR/STU3/FHIRResource.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRPublicationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchParamType' => 'HL7/FHIR/STU3/FHIRElement/FHIRSearchParamType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdministrativeGender' => 'HL7/FHIR/STU3/FHIRElement/FHIRAdministrativeGender.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRemittanceOutcome' => 'HL7/FHIR/STU3/FHIRElement/FHIRRemittanceOutcome.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNoteType' => 'HL7/FHIR/STU3/FHIRElement/FHIRNoteType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConceptMapEquivalence' => 'HL7/FHIR/STU3/FHIRElement/FHIRConceptMapEquivalence.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentReferenceStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRDocumentReferenceStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAccount' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRAccount.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAccount\\FHIRAccountCoverage' => 'HL7/FHIR/STU3/FHIRResource/FHIRAccount/FHIRAccountCoverage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAccount\\FHIRAccountGuarantor' => 'HL7/FHIR/STU3/FHIRResource/FHIRAccount/FHIRAccountGuarantor.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAccountStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRAccountStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRActivityDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRActivityDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIRActivityDefinition/FHIRActivityDefinitionParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionDynamicValue' => 'HL7/FHIR/STU3/FHIRResource/FHIRActivityDefinition/FHIRActivityDefinitionDynamicValue.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionParticipantType' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionParticipantType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType' => 'HL7/FHIR/STU3/FHIRElement/FHIRResourceType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAdverseEvent' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRAdverseEvent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventSuspectEntity' => 'HL7/FHIR/STU3/FHIRResource/FHIRAdverseEvent/FHIRAdverseEventSuspectEntity.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdverseEventCausality' => 'HL7/FHIR/STU3/FHIRElement/FHIRAdverseEventCausality.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdverseEventCategory' => 'HL7/FHIR/STU3/FHIRElement/FHIRAdverseEventCategory.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAllergyIntolerance' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRAllergyIntolerance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAllergyIntolerance\\FHIRAllergyIntoleranceReaction' => 'HL7/FHIR/STU3/FHIRResource/FHIRAllergyIntolerance/FHIRAllergyIntoleranceReaction.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceCriticality' => 'HL7/FHIR/STU3/FHIRElement/FHIRAllergyIntoleranceCriticality.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceType' => 'HL7/FHIR/STU3/FHIRElement/FHIRAllergyIntoleranceType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceCategory' => 'HL7/FHIR/STU3/FHIRElement/FHIRAllergyIntoleranceCategory.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceVerificationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRAllergyIntoleranceVerificationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceSeverity' => 'HL7/FHIR/STU3/FHIRElement/FHIRAllergyIntoleranceSeverity.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceClinicalStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRAllergyIntoleranceClinicalStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAppointment' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRAppointment.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAppointment\\FHIRAppointmentParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIRAppointment/FHIRAppointmentParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipantRequired' => 'HL7/FHIR/STU3/FHIRElement/FHIRParticipantRequired.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAppointmentStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRAppointmentStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRParticipationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAppointmentResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRAppointmentResponse.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAuditEvent' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRAuditEvent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventAgent' => 'HL7/FHIR/STU3/FHIRResource/FHIRAuditEvent/FHIRAuditEventAgent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventNetwork' => 'HL7/FHIR/STU3/FHIRResource/FHIRAuditEvent/FHIRAuditEventNetwork.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventSource' => 'HL7/FHIR/STU3/FHIRResource/FHIRAuditEvent/FHIRAuditEventSource.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventEntity' => 'HL7/FHIR/STU3/FHIRResource/FHIRAuditEvent/FHIRAuditEventEntity.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRAuditEvent/FHIRAuditEventDetail.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventOutcome' => 'HL7/FHIR/STU3/FHIRElement/FHIRAuditEventOutcome.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventAction' => 'HL7/FHIR/STU3/FHIRElement/FHIRAuditEventAction.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventAgentNetworkType' => 'HL7/FHIR/STU3/FHIRElement/FHIRAuditEventAgentNetworkType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRBasic' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRBasic.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBinary' => 'HL7/FHIR/STU3/FHIRResource/FHIRBinary.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRBodySite' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRBodySite.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle' => 'HL7/FHIR/STU3/FHIRResource/FHIRBundle.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleLink' => 'HL7/FHIR/STU3/FHIRResource/FHIRBundle/FHIRBundleLink.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleEntry' => 'HL7/FHIR/STU3/FHIRResource/FHIRBundle/FHIRBundleEntry.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleSearch' => 'HL7/FHIR/STU3/FHIRResource/FHIRBundle/FHIRBundleSearch.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleRequest' => 'HL7/FHIR/STU3/FHIRResource/FHIRBundle/FHIRBundleRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleResponse' => 'HL7/FHIR/STU3/FHIRResource/FHIRBundle/FHIRBundleResponse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHTTPVerb' => 'HL7/FHIR/STU3/FHIRElement/FHIRHTTPVerb.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBundleType' => 'HL7/FHIR/STU3/FHIRElement/FHIRBundleType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchEntryMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRSearchEntryMode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCapabilityStatement' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCapabilityStatement.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSoftware' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSoftware.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementImplementation' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementImplementation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementRest' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementRest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSecurity' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSecurity.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementCertificate' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementCertificate.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementResource' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementResource.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementInteraction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSearchParam.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction1' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementInteraction1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementOperation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementMessaging' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementMessaging.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEndpoint' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementEndpoint.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSupportedMessage' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSupportedMessage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEvent' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementEvent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementDocument' => 'HL7/FHIR/STU3/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementDocument.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCapabilityStatementKind' => 'HL7/FHIR/STU3/FHIRElement/FHIRCapabilityStatementKind.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventCapabilityMode' => 'HL7/FHIR/STU3/FHIRElement/FHIREventCapabilityMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceVersionPolicy' => 'HL7/FHIR/STU3/FHIRElement/FHIRResourceVersionPolicy.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMessageSignificanceCategory' => 'HL7/FHIR/STU3/FHIRElement/FHIRMessageSignificanceCategory.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRDocumentMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRestfulCapabilityMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRRestfulCapabilityMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnknownContentCode' => 'HL7/FHIR/STU3/FHIRElement/FHIRUnknownContentCode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTypeRestfulInteraction' => 'HL7/FHIR/STU3/FHIRElement/FHIRTypeRestfulInteraction.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSystemRestfulInteraction' => 'HL7/FHIR/STU3/FHIRElement/FHIRSystemRestfulInteraction.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionalReadStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRConditionalReadStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReferenceHandlingPolicy' => 'HL7/FHIR/STU3/FHIRElement/FHIRReferenceHandlingPolicy.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionalDeleteStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRConditionalDeleteStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCarePlan' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCarePlan.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanActivity' => 'HL7/FHIR/STU3/FHIRResource/FHIRCarePlan/FHIRCarePlanActivity.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRCarePlan/FHIRCarePlanDetail.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRCarePlanStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanActivityStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRCarePlanActivityStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanIntent' => 'HL7/FHIR/STU3/FHIRElement/FHIRCarePlanIntent.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCareTeam' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCareTeam.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCareTeam\\FHIRCareTeamParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIRCareTeam/FHIRCareTeamParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCareTeamStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRCareTeamStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRChargeItem' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRChargeItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRChargeItem\\FHIRChargeItemParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIRChargeItem/FHIRChargeItemParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRChargeItemStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRChargeItemStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClaim' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRClaim.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimRelated' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimRelated.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimPayee' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimPayee.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimCareTeam' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimCareTeam.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimInformation' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimInformation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimDiagnosis' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimDiagnosis.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimProcedure' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimProcedure.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimInsurance' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimInsurance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimAccident' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimAccident.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimDetail.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimSubDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaim/FHIRClaimSubDetail.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUse' => 'HL7/FHIR/STU3/FHIRElement/FHIRUse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes' => 'HL7/FHIR/STU3/FHIRElement/FHIRFinancialResourceStatusCodes.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClaimResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRClaimResponse.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseAdjudication.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseDetail.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseSubDetail.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAddItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseAddItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail1' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseDetail1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseError' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseError.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponsePayment' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponsePayment.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseProcessNote' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseProcessNote.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseInsurance' => 'HL7/FHIR/STU3/FHIRResource/FHIRClaimResponse/FHIRClaimResponseInsurance.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClinicalImpression' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRClinicalImpression.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionInvestigation' => 'HL7/FHIR/STU3/FHIRResource/FHIRClinicalImpression/FHIRClinicalImpressionInvestigation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionFinding' => 'HL7/FHIR/STU3/FHIRResource/FHIRClinicalImpression/FHIRClinicalImpressionFinding.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRClinicalImpressionStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRClinicalImpressionStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCodeSystem' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCodeSystem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemFilter' => 'HL7/FHIR/STU3/FHIRResource/FHIRCodeSystem/FHIRCodeSystemFilter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty' => 'HL7/FHIR/STU3/FHIRResource/FHIRCodeSystem/FHIRCodeSystemProperty.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept' => 'HL7/FHIR/STU3/FHIRResource/FHIRCodeSystem/FHIRCodeSystemConcept.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemDesignation' => 'HL7/FHIR/STU3/FHIRResource/FHIRCodeSystem/FHIRCodeSystemDesignation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty1' => 'HL7/FHIR/STU3/FHIRResource/FHIRCodeSystem/FHIRCodeSystemProperty1.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFilterOperator' => 'HL7/FHIR/STU3/FHIRElement/FHIRFilterOperator.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPropertyType' => 'HL7/FHIR/STU3/FHIRElement/FHIRPropertyType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeSystemHierarchyMeaning' => 'HL7/FHIR/STU3/FHIRElement/FHIRCodeSystemHierarchyMeaning.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeSystemContentMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRCodeSystemContentMode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCommunication' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCommunication.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunication\\FHIRCommunicationPayload' => 'HL7/FHIR/STU3/FHIRResource/FHIRCommunication/FHIRCommunicationPayload.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIREventStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCommunicationRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCommunicationRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestPayload' => 'HL7/FHIR/STU3/FHIRResource/FHIRCommunicationRequest/FHIRCommunicationRequestPayload.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRCommunicationRequest/FHIRCommunicationRequestRequester.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRRequestStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestPriority' => 'HL7/FHIR/STU3/FHIRElement/FHIRRequestPriority.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCompartmentDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCompartmentDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCompartmentDefinition\\FHIRCompartmentDefinitionResource' => 'HL7/FHIR/STU3/FHIRResource/FHIRCompartmentDefinition/FHIRCompartmentDefinitionResource.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompartmentType' => 'HL7/FHIR/STU3/FHIRElement/FHIRCompartmentType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRComposition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRComposition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionAttester' => 'HL7/FHIR/STU3/FHIRResource/FHIRComposition/FHIRCompositionAttester.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionRelatesTo' => 'HL7/FHIR/STU3/FHIRResource/FHIRComposition/FHIRCompositionRelatesTo.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionEvent' => 'HL7/FHIR/STU3/FHIRResource/FHIRComposition/FHIRCompositionEvent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionSection' => 'HL7/FHIR/STU3/FHIRResource/FHIRComposition/FHIRCompositionSection.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRCompositionStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConfidentialityClassification' => 'HL7/FHIR/STU3/FHIRElement/FHIRConfidentialityClassification.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentRelationshipType' => 'HL7/FHIR/STU3/FHIRElement/FHIRDocumentRelationshipType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionAttestationMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRCompositionAttestationMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRListMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRListMode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRConceptMap' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRConceptMap.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapGroup' => 'HL7/FHIR/STU3/FHIRResource/FHIRConceptMap/FHIRConceptMapGroup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapElement' => 'HL7/FHIR/STU3/FHIRResource/FHIRConceptMap/FHIRConceptMapElement.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapTarget' => 'HL7/FHIR/STU3/FHIRResource/FHIRConceptMap/FHIRConceptMapTarget.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn' => 'HL7/FHIR/STU3/FHIRResource/FHIRConceptMap/FHIRConceptMapDependsOn.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapUnmapped' => 'HL7/FHIR/STU3/FHIRResource/FHIRConceptMap/FHIRConceptMapUnmapped.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConceptMapGroupUnmappedMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRConceptMapGroupUnmappedMode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCondition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCondition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCondition\\FHIRConditionStage' => 'HL7/FHIR/STU3/FHIRResource/FHIRCondition/FHIRConditionStage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCondition\\FHIRConditionEvidence' => 'HL7/FHIR/STU3/FHIRResource/FHIRCondition/FHIRConditionEvidence.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionVerificationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRConditionVerificationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionClinicalStatusCodes' => 'HL7/FHIR/STU3/FHIRElement/FHIRConditionClinicalStatusCodes.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRConsent' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRConsent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentActor' => 'HL7/FHIR/STU3/FHIRResource/FHIRConsent/FHIRConsentActor.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentPolicy' => 'HL7/FHIR/STU3/FHIRResource/FHIRConsent/FHIRConsentPolicy.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentData' => 'HL7/FHIR/STU3/FHIRResource/FHIRConsent/FHIRConsentData.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentExcept' => 'HL7/FHIR/STU3/FHIRResource/FHIRConsent/FHIRConsentExcept.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentActor1' => 'HL7/FHIR/STU3/FHIRResource/FHIRConsent/FHIRConsentActor1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentData1' => 'HL7/FHIR/STU3/FHIRResource/FHIRConsent/FHIRConsentData1.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentDataMeaning' => 'HL7/FHIR/STU3/FHIRElement/FHIRConsentDataMeaning.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentState' => 'HL7/FHIR/STU3/FHIRElement/FHIRConsentState.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentExceptType' => 'HL7/FHIR/STU3/FHIRElement/FHIRConsentExceptType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRContract' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRContract.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractAgent' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractAgent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractSigner' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractSigner.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractValuedItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractValuedItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractTerm' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractTerm.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractAgent1' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractAgent1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractValuedItem1' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractValuedItem1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractFriendly' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractFriendly.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractLegal' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractLegal.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractRule' => 'HL7/FHIR/STU3/FHIRResource/FHIRContract/FHIRContractRule.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContractResourceStatusCodes' => 'HL7/FHIR/STU3/FHIRElement/FHIRContractResourceStatusCodes.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCoverage' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRCoverage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCoverage\\FHIRCoverageGrouping' => 'HL7/FHIR/STU3/FHIRResource/FHIRCoverage/FHIRCoverageGrouping.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDataElement' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDataElement.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataElement\\FHIRDataElementMapping' => 'HL7/FHIR/STU3/FHIRResource/FHIRDataElement/FHIRDataElementMapping.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataElementStringency' => 'HL7/FHIR/STU3/FHIRElement/FHIRDataElementStringency.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDetectedIssue' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDetectedIssue.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueMitigation' => 'HL7/FHIR/STU3/FHIRResource/FHIRDetectedIssue/FHIRDetectedIssueMitigation.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRObservationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDetectedIssueSeverity' => 'HL7/FHIR/STU3/FHIRElement/FHIRDetectedIssueSeverity.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDevice' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDevice.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDevice\\FHIRDeviceUdi' => 'HL7/FHIR/STU3/FHIRResource/FHIRDevice/FHIRDeviceUdi.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRDeviceStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRFHIRDeviceStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUDIEntryType' => 'HL7/FHIR/STU3/FHIRElement/FHIRUDIEntryType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceComponent' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDeviceComponent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceComponent\\FHIRDeviceComponentProductionSpecification' => 'HL7/FHIR/STU3/FHIRResource/FHIRDeviceComponent/FHIRDeviceComponentProductionSpecification.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasmntPrinciple' => 'HL7/FHIR/STU3/FHIRElement/FHIRMeasmntPrinciple.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceMetric' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDeviceMetric.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceMetric\\FHIRDeviceMetricCalibration' => 'HL7/FHIR/STU3/FHIRResource/FHIRDeviceMetric/FHIRDeviceMetricCalibration.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCalibrationType' => 'HL7/FHIR/STU3/FHIRElement/FHIRDeviceMetricCalibrationType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricColor' => 'HL7/FHIR/STU3/FHIRElement/FHIRDeviceMetricColor.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCalibrationState' => 'HL7/FHIR/STU3/FHIRElement/FHIRDeviceMetricCalibrationState.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricOperationalStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRDeviceMetricOperationalStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCategory' => 'HL7/FHIR/STU3/FHIRElement/FHIRDeviceMetricCategory.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDeviceRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceRequest\\FHIRDeviceRequestRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRDeviceRequest/FHIRDeviceRequestRequester.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceUseStatement' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDeviceUseStatement.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceUseStatementStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRDeviceUseStatementStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDiagnosticReport' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDiagnosticReport.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportPerformer' => 'HL7/FHIR/STU3/FHIRResource/FHIRDiagnosticReport/FHIRDiagnosticReportPerformer.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportImage' => 'HL7/FHIR/STU3/FHIRResource/FHIRDiagnosticReport/FHIRDiagnosticReportImage.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDiagnosticReportStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRDiagnosticReportStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDocumentManifest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDocumentManifest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestContent' => 'HL7/FHIR/STU3/FHIRResource/FHIRDocumentManifest/FHIRDocumentManifestContent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestRelated' => 'HL7/FHIR/STU3/FHIRResource/FHIRDocumentManifest/FHIRDocumentManifestRelated.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDocumentReference' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRDocumentReference.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelatesTo' => 'HL7/FHIR/STU3/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceRelatesTo.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContent' => 'HL7/FHIR/STU3/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceContent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContext' => 'HL7/FHIR/STU3/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceContext.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelated' => 'HL7/FHIR/STU3/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceRelated.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREligibilityRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREligibilityRequest.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREligibilityResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREligibilityResponse.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseInsurance' => 'HL7/FHIR/STU3/FHIRResource/FHIREligibilityResponse/FHIREligibilityResponseInsurance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseBenefitBalance' => 'HL7/FHIR/STU3/FHIRResource/FHIREligibilityResponse/FHIREligibilityResponseBenefitBalance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseFinancial' => 'HL7/FHIR/STU3/FHIRResource/FHIREligibilityResponse/FHIREligibilityResponseFinancial.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseError' => 'HL7/FHIR/STU3/FHIRResource/FHIREligibilityResponse/FHIREligibilityResponseError.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREncounter' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREncounter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterStatusHistory' => 'HL7/FHIR/STU3/FHIRResource/FHIREncounter/FHIREncounterStatusHistory.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterClassHistory' => 'HL7/FHIR/STU3/FHIRResource/FHIREncounter/FHIREncounterClassHistory.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIREncounter/FHIREncounterParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterDiagnosis' => 'HL7/FHIR/STU3/FHIRResource/FHIREncounter/FHIREncounterDiagnosis.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterHospitalization' => 'HL7/FHIR/STU3/FHIRResource/FHIREncounter/FHIREncounterHospitalization.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterLocation' => 'HL7/FHIR/STU3/FHIRResource/FHIREncounter/FHIREncounterLocation.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterLocationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIREncounterLocationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIREncounterStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREndpoint' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREndpoint.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREndpointStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIREndpointStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREnrollmentRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREnrollmentRequest.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREnrollmentResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREnrollmentResponse.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREpisodeOfCare' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIREpisodeOfCare.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareStatusHistory' => 'HL7/FHIR/STU3/FHIRResource/FHIREpisodeOfCare/FHIREpisodeOfCareStatusHistory.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareDiagnosis' => 'HL7/FHIR/STU3/FHIRResource/FHIREpisodeOfCare/FHIREpisodeOfCareDiagnosis.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIREpisodeOfCareStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIREpisodeOfCareStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRExpansionProfile' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRExpansionProfile.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileFixedVersion' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileFixedVersion.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileExcludedSystem' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileExcludedSystem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileDesignation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileInclude' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileInclude.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation1' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileDesignation1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileExclude' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileExclude.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation2' => 'HL7/FHIR/STU3/FHIRResource/FHIRExpansionProfile/FHIRExpansionProfileDesignation2.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSystemVersionProcessingMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRSystemVersionProcessingMode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRExplanationOfBenefit' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRExplanationOfBenefit.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitRelated' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitRelated.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayee' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitPayee.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInformation' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitInformation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitCareTeam' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitCareTeam.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDiagnosis' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDiagnosis.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcedure' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitProcedure.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInsurance' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitInsurance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAccident' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAccident.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAdjudication.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDetail.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSubDetail.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAddItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAddItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail1' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDetail1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayment' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitPayment.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcessNote' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitProcessNote.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitBenefitBalance' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitBenefitBalance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitFinancial' => 'HL7/FHIR/STU3/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitFinancial.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExplanationOfBenefitStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRExplanationOfBenefitStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRFamilyMemberHistory' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRFamilyMemberHistory.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRFamilyMemberHistory\\FHIRFamilyMemberHistoryCondition' => 'HL7/FHIR/STU3/FHIRResource/FHIRFamilyMemberHistory/FHIRFamilyMemberHistoryCondition.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFamilyHistoryStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRFamilyHistoryStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRFlag' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRFlag.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFlagStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRFlagStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGoal' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRGoal.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGoal\\FHIRGoalTarget' => 'HL7/FHIR/STU3/FHIRResource/FHIRGoal/FHIRGoalTarget.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGoalStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRGoalStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGraphDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRGraphDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink' => 'HL7/FHIR/STU3/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionLink.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionTarget' => 'HL7/FHIR/STU3/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionTarget.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionCompartment' => 'HL7/FHIR/STU3/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionCompartment.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGraphCompartmentRule' => 'HL7/FHIR/STU3/FHIRElement/FHIRGraphCompartmentRule.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGroup' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRGroup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGroup\\FHIRGroupCharacteristic' => 'HL7/FHIR/STU3/FHIRResource/FHIRGroup/FHIRGroupCharacteristic.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGroup\\FHIRGroupMember' => 'HL7/FHIR/STU3/FHIRResource/FHIRGroup/FHIRGroupMember.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGroupType' => 'HL7/FHIR/STU3/FHIRElement/FHIRGroupType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGuidanceResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRGuidanceResponse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuidanceResponseStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRGuidanceResponseStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRHealthcareService' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRHealthcareService.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceAvailableTime' => 'HL7/FHIR/STU3/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceAvailableTime.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceNotAvailable' => 'HL7/FHIR/STU3/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceNotAvailable.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDaysOfWeek' => 'HL7/FHIR/STU3/FHIRElement/FHIRDaysOfWeek.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImagingManifest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRImagingManifest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestStudy' => 'HL7/FHIR/STU3/FHIRResource/FHIRImagingManifest/FHIRImagingManifestStudy.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestSeries' => 'HL7/FHIR/STU3/FHIRResource/FHIRImagingManifest/FHIRImagingManifestSeries.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestInstance' => 'HL7/FHIR/STU3/FHIRResource/FHIRImagingManifest/FHIRImagingManifestInstance.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImagingStudy' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRImagingStudy.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudySeries' => 'HL7/FHIR/STU3/FHIRResource/FHIRImagingStudy/FHIRImagingStudySeries.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyInstance' => 'HL7/FHIR/STU3/FHIRResource/FHIRImagingStudy/FHIRImagingStudyInstance.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstanceAvailability' => 'HL7/FHIR/STU3/FHIRElement/FHIRInstanceAvailability.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImmunization' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRImmunization.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationPractitioner' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunization/FHIRImmunizationPractitioner.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationExplanation' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunization/FHIRImmunizationExplanation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationReaction' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunization/FHIRImmunizationReaction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationVaccinationProtocol' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunization/FHIRImmunizationVaccinationProtocol.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRImmunizationStatusCodes' => 'HL7/FHIR/STU3/FHIRElement/FHIRImmunizationStatusCodes.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImmunizationRecommendation' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRImmunizationRecommendation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationRecommendation' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationRecommendation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationDateCriterion' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationDateCriterion.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationProtocol' => 'HL7/FHIR/STU3/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationProtocol.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImplementationGuide' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRImplementationGuide.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDependency' => 'HL7/FHIR/STU3/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideDependency.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePackage' => 'HL7/FHIR/STU3/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuidePackage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource' => 'HL7/FHIR/STU3/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideResource.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGlobal' => 'HL7/FHIR/STU3/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideGlobal.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage' => 'HL7/FHIR/STU3/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuidePage.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuideDependencyType' => 'HL7/FHIR/STU3/FHIRElement/FHIRGuideDependencyType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuidePageKind' => 'HL7/FHIR/STU3/FHIRElement/FHIRGuidePageKind.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLibrary' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRLibrary.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLinkage' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRLinkage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRLinkage\\FHIRLinkageItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRLinkage/FHIRLinkageItem.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLinkageType' => 'HL7/FHIR/STU3/FHIRElement/FHIRLinkageType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRList' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRList.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRList\\FHIRListEntry' => 'HL7/FHIR/STU3/FHIRResource/FHIRList/FHIRListEntry.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRListStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRListStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLocation' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRLocation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRLocation\\FHIRLocationPosition' => 'HL7/FHIR/STU3/FHIRResource/FHIRLocation/FHIRLocationPosition.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLocationMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRLocationMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLocationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRLocationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMeasure' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMeasure.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureGroup' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasure/FHIRMeasureGroup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasurePopulation' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasure/FHIRMeasurePopulation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureStratifier' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasure/FHIRMeasureStratifier.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureSupplementalData' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasure/FHIRMeasureSupplementalData.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMeasureReport' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMeasureReport.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportGroup' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasureReport/FHIRMeasureReportGroup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasureReport/FHIRMeasureReportPopulation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratifier' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasureReport/FHIRMeasureReportStratifier.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratum' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasureReport/FHIRMeasureReportStratum.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation1' => 'HL7/FHIR/STU3/FHIRResource/FHIRMeasureReport/FHIRMeasureReportPopulation1.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasureReportStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRMeasureReportStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasureReportType' => 'HL7/FHIR/STU3/FHIRElement/FHIRMeasureReportType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedia' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMedia.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDigitalMediaType' => 'HL7/FHIR/STU3/FHIRElement/FHIRDigitalMediaType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedication' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMedication.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationIngredient' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedication/FHIRMedicationIngredient.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationPackage' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedication/FHIRMedicationPackage.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationContent' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedication/FHIRMedicationContent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationBatch' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedication/FHIRMedicationBatch.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationAdministration' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMedicationAdministration.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationPerformer' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationAdministration/FHIRMedicationAdministrationPerformer.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationDosage' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationAdministration/FHIRMedicationAdministrationDosage.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationAdministrationStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationAdministrationStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationDispense' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMedicationDispense.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispensePerformer' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationDispense/FHIRMedicationDispensePerformer.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispenseSubstitution' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationDispense/FHIRMedicationDispenseSubstitution.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationDispenseStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationDispenseStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMedicationRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestRequester.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestDispenseRequest' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestDispenseRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestSubstitution' => 'HL7/FHIR/STU3/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestSubstitution.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationRequestStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestPriority' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationRequestPriority.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestIntent' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationRequestIntent.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationStatement' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMedicationStatement.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatementStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationStatementStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatementTaken' => 'HL7/FHIR/STU3/FHIRElement/FHIRMedicationStatementTaken.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMessageDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMessageDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionFocus' => 'HL7/FHIR/STU3/FHIRResource/FHIRMessageDefinition/FHIRMessageDefinitionFocus.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionAllowedResponse' => 'HL7/FHIR/STU3/FHIRResource/FHIRMessageDefinition/FHIRMessageDefinitionAllowedResponse.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMessageHeader' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRMessageHeader.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderDestination' => 'HL7/FHIR/STU3/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderDestination.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderSource' => 'HL7/FHIR/STU3/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderSource.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderResponse' => 'HL7/FHIR/STU3/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderResponse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResponseType' => 'HL7/FHIR/STU3/FHIRElement/FHIRResponseType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRNamingSystem' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRNamingSystem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNamingSystem\\FHIRNamingSystemUniqueId' => 'HL7/FHIR/STU3/FHIRResource/FHIRNamingSystem/FHIRNamingSystemUniqueId.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNamingSystemIdentifierType' => 'HL7/FHIR/STU3/FHIRElement/FHIRNamingSystemIdentifierType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNamingSystemType' => 'HL7/FHIR/STU3/FHIRElement/FHIRNamingSystemType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRNutritionOrder' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRNutritionOrder.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderOralDiet' => 'HL7/FHIR/STU3/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderOralDiet.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderNutrient' => 'HL7/FHIR/STU3/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderNutrient.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderTexture' => 'HL7/FHIR/STU3/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderTexture.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderSupplement' => 'HL7/FHIR/STU3/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderSupplement.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderEnteralFormula' => 'HL7/FHIR/STU3/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderEnteralFormula.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderAdministration' => 'HL7/FHIR/STU3/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderAdministration.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNutritionOrderStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRNutritionOrderStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRObservation' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRObservation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationReferenceRange' => 'HL7/FHIR/STU3/FHIRResource/FHIRObservation/FHIRObservationReferenceRange.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationRelated' => 'HL7/FHIR/STU3/FHIRResource/FHIRObservation/FHIRObservationRelated.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationComponent' => 'HL7/FHIR/STU3/FHIRResource/FHIRObservation/FHIRObservationComponent.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationRelationshipType' => 'HL7/FHIR/STU3/FHIRElement/FHIRObservationRelationshipType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROperationDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIROperationDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionParameter' => 'HL7/FHIR/STU3/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionParameter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionBinding' => 'HL7/FHIR/STU3/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionBinding.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionOverload' => 'HL7/FHIR/STU3/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionOverload.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRAllTypes' => 'HL7/FHIR/STU3/FHIRElement/FHIRFHIRAllTypes.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIROperationParameterUse' => 'HL7/FHIR/STU3/FHIRElement/FHIROperationParameterUse.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIROperationKind' => 'HL7/FHIR/STU3/FHIRElement/FHIROperationKind.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROperationOutcome' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIROperationOutcome.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationOutcome\\FHIROperationOutcomeIssue' => 'HL7/FHIR/STU3/FHIRResource/FHIROperationOutcome/FHIROperationOutcomeIssue.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIssueType' => 'HL7/FHIR/STU3/FHIRElement/FHIRIssueType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIssueSeverity' => 'HL7/FHIR/STU3/FHIRElement/FHIRIssueSeverity.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROrganization' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIROrganization.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIROrganization\\FHIROrganizationContact' => 'HL7/FHIR/STU3/FHIRResource/FHIROrganization/FHIROrganizationContact.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters' => 'HL7/FHIR/STU3/FHIRResource/FHIRParameters.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters\\FHIRParametersParameter' => 'HL7/FHIR/STU3/FHIRResource/FHIRParameters/FHIRParametersParameter.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPatient' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPatient.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientContact' => 'HL7/FHIR/STU3/FHIRResource/FHIRPatient/FHIRPatientContact.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientAnimal' => 'HL7/FHIR/STU3/FHIRResource/FHIRPatient/FHIRPatientAnimal.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientCommunication' => 'HL7/FHIR/STU3/FHIRResource/FHIRPatient/FHIRPatientCommunication.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientLink' => 'HL7/FHIR/STU3/FHIRResource/FHIRPatient/FHIRPatientLink.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLinkType' => 'HL7/FHIR/STU3/FHIRElement/FHIRLinkType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPaymentNotice' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPaymentNotice.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPaymentReconciliation' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPaymentReconciliation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationDetail' => 'HL7/FHIR/STU3/FHIRResource/FHIRPaymentReconciliation/FHIRPaymentReconciliationDetail.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationProcessNote' => 'HL7/FHIR/STU3/FHIRResource/FHIRPaymentReconciliation/FHIRPaymentReconciliationProcessNote.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPerson' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPerson.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPerson\\FHIRPersonLink' => 'HL7/FHIR/STU3/FHIRResource/FHIRPerson/FHIRPersonLink.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentityAssuranceLevel' => 'HL7/FHIR/STU3/FHIRElement/FHIRIdentityAssuranceLevel.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPlanDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPlanDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionGoal' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionGoal.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionTarget' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionTarget.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionAction' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionAction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionCondition' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionCondition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionRelatedAction' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionRelatedAction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionDynamicValue' => 'HL7/FHIR/STU3/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionDynamicValue.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionRequiredBehavior' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionRequiredBehavior.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionRelationshipType' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionRelationshipType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionGroupingBehavior' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionGroupingBehavior.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionSelectionBehavior' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionSelectionBehavior.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionCardinalityBehavior' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionCardinalityBehavior.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionPrecheckBehavior' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionPrecheckBehavior.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionConditionKind' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionConditionKind.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPractitioner' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPractitioner.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPractitioner\\FHIRPractitionerQualification' => 'HL7/FHIR/STU3/FHIRResource/FHIRPractitioner/FHIRPractitionerQualification.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPractitionerRole' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRPractitionerRole.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPractitionerRole\\FHIRPractitionerRoleAvailableTime' => 'HL7/FHIR/STU3/FHIRResource/FHIRPractitionerRole/FHIRPractitionerRoleAvailableTime.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPractitionerRole\\FHIRPractitionerRoleNotAvailable' => 'HL7/FHIR/STU3/FHIRResource/FHIRPractitionerRole/FHIRPractitionerRoleNotAvailable.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcedure' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRProcedure.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProcedure\\FHIRProcedurePerformer' => 'HL7/FHIR/STU3/FHIRResource/FHIRProcedure/FHIRProcedurePerformer.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProcedure\\FHIRProcedureFocalDevice' => 'HL7/FHIR/STU3/FHIRResource/FHIRProcedure/FHIRProcedureFocalDevice.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcedureRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRProcedureRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProcedureRequest\\FHIRProcedureRequestRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRProcedureRequest/FHIRProcedureRequestRequester.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestIntent' => 'HL7/FHIR/STU3/FHIRElement/FHIRRequestIntent.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcessRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRProcessRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProcessRequest\\FHIRProcessRequestItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRProcessRequest/FHIRProcessRequestItem.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionList' => 'HL7/FHIR/STU3/FHIRElement/FHIRActionList.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcessResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRProcessResponse.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProcessResponse\\FHIRProcessResponseProcessNote' => 'HL7/FHIR/STU3/FHIRResource/FHIRProcessResponse/FHIRProcessResponseProcessNote.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProvenance' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRProvenance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProvenance\\FHIRProvenanceAgent' => 'HL7/FHIR/STU3/FHIRResource/FHIRProvenance/FHIRProvenanceAgent.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRProvenance\\FHIRProvenanceEntity' => 'HL7/FHIR/STU3/FHIRResource/FHIRProvenance/FHIRProvenanceEntity.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRProvenanceEntityRole' => 'HL7/FHIR/STU3/FHIRElement/FHIRProvenanceEntityRole.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRQuestionnaire' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRQuestionnaire.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireEnableWhen' => 'HL7/FHIR/STU3/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireEnableWhen.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireOption' => 'HL7/FHIR/STU3/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireOption.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuestionnaireItemType' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuestionnaireItemType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRQuestionnaireResponse' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRQuestionnaireResponse.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRQuestionnaireResponse\\FHIRQuestionnaireResponseItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRQuestionnaireResponse/FHIRQuestionnaireResponseItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRQuestionnaireResponse\\FHIRQuestionnaireResponseAnswer' => 'HL7/FHIR/STU3/FHIRResource/FHIRQuestionnaireResponse/FHIRQuestionnaireResponseAnswer.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuestionnaireResponseStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRQuestionnaireResponseStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRReferralRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRReferralRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRReferralRequest\\FHIRReferralRequestRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRReferralRequest/FHIRReferralRequestRequester.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRRelatedPerson' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRRelatedPerson.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRRequestGroup' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRRequestGroup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRRequestGroup\\FHIRRequestGroupAction' => 'HL7/FHIR/STU3/FHIRResource/FHIRRequestGroup/FHIRRequestGroupAction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRRequestGroup\\FHIRRequestGroupCondition' => 'HL7/FHIR/STU3/FHIRResource/FHIRRequestGroup/FHIRRequestGroupCondition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRRequestGroup\\FHIRRequestGroupRelatedAction' => 'HL7/FHIR/STU3/FHIRResource/FHIRRequestGroup/FHIRRequestGroupRelatedAction.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRResearchStudy' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRResearchStudy.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRResearchStudy\\FHIRResearchStudyArm' => 'HL7/FHIR/STU3/FHIRResource/FHIRResearchStudy/FHIRResearchStudyArm.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResearchStudyStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRResearchStudyStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRResearchSubject' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRResearchSubject.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResearchSubjectStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRResearchSubjectStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRRiskAssessment' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRRiskAssessment.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRRiskAssessment\\FHIRRiskAssessmentPrediction' => 'HL7/FHIR/STU3/FHIRResource/FHIRRiskAssessment/FHIRRiskAssessmentPrediction.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSchedule' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSchedule.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSearchParameter' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSearchParameter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSearchParameter\\FHIRSearchParameterComponent' => 'HL7/FHIR/STU3/FHIRResource/FHIRSearchParameter/FHIRSearchParameterComponent.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRXPathUsageType' => 'HL7/FHIR/STU3/FHIRElement/FHIRXPathUsageType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchModifierCode' => 'HL7/FHIR/STU3/FHIRElement/FHIRSearchModifierCode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchComparator' => 'HL7/FHIR/STU3/FHIRElement/FHIRSearchComparator.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSequence' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSequence.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSequence\\FHIRSequenceReferenceSeq' => 'HL7/FHIR/STU3/FHIRResource/FHIRSequence/FHIRSequenceReferenceSeq.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSequence\\FHIRSequenceVariant' => 'HL7/FHIR/STU3/FHIRResource/FHIRSequence/FHIRSequenceVariant.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSequence\\FHIRSequenceQuality' => 'HL7/FHIR/STU3/FHIRResource/FHIRSequence/FHIRSequenceQuality.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSequence\\FHIRSequenceRepository' => 'HL7/FHIR/STU3/FHIRResource/FHIRSequence/FHIRSequenceRepository.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRepositoryType' => 'HL7/FHIR/STU3/FHIRElement/FHIRRepositoryType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQualityType' => 'HL7/FHIR/STU3/FHIRElement/FHIRQualityType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRServiceDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRServiceDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSlot' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSlot.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSlotStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRSlotStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSpecimen' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSpecimen.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSpecimen\\FHIRSpecimenCollection' => 'HL7/FHIR/STU3/FHIRResource/FHIRSpecimen/FHIRSpecimenCollection.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSpecimen\\FHIRSpecimenProcessing' => 'HL7/FHIR/STU3/FHIRResource/FHIRSpecimen/FHIRSpecimenProcessing.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSpecimen\\FHIRSpecimenContainer' => 'HL7/FHIR/STU3/FHIRResource/FHIRSpecimen/FHIRSpecimenContainer.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSpecimenStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRSpecimenStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRStructureDefinition' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRStructureDefinition.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionMapping' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionMapping.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionSnapshot' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionSnapshot.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionDifferential' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionDifferential.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureDefinitionKind' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureDefinitionKind.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTypeDerivationRule' => 'HL7/FHIR/STU3/FHIRElement/FHIRTypeDerivationRule.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtensionContext' => 'HL7/FHIR/STU3/FHIRElement/FHIRExtensionContext.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRStructureMap' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRStructureMap.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapStructure' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapStructure.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapGroup' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapGroup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapInput' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapInput.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapRule' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapRule.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapSource' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapSource.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapTarget' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapTarget.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapParameter' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapParameter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapDependent' => 'HL7/FHIR/STU3/FHIRResource/FHIRStructureMap/FHIRStructureMapDependent.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapInputMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapInputMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapContextType' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapContextType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapTargetListMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapTargetListMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapTransform' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapTransform.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapSourceListMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapSourceListMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapGroupTypeMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapGroupTypeMode.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRStructureMapModelMode' => 'HL7/FHIR/STU3/FHIRElement/FHIRStructureMapModelMode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSubscription' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSubscription.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSubscription\\FHIRSubscriptionChannel' => 'HL7/FHIR/STU3/FHIRResource/FHIRSubscription/FHIRSubscriptionChannel.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSubscriptionStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRSubscriptionStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSubscriptionChannelType' => 'HL7/FHIR/STU3/FHIRElement/FHIRSubscriptionChannelType.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSubstance' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSubstance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSubstance\\FHIRSubstanceInstance' => 'HL7/FHIR/STU3/FHIRResource/FHIRSubstance/FHIRSubstanceInstance.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSubstance\\FHIRSubstanceIngredient' => 'HL7/FHIR/STU3/FHIRResource/FHIRSubstance/FHIRSubstanceIngredient.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRSubstanceStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRFHIRSubstanceStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSupplyDelivery' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSupplyDelivery.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSupplyDelivery\\FHIRSupplyDeliverySuppliedItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRSupplyDelivery/FHIRSupplyDeliverySuppliedItem.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSupplyDeliveryStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRSupplyDeliveryStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSupplyRequest' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRSupplyRequest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSupplyRequest\\FHIRSupplyRequestOrderedItem' => 'HL7/FHIR/STU3/FHIRResource/FHIRSupplyRequest/FHIRSupplyRequestOrderedItem.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRSupplyRequest\\FHIRSupplyRequestRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRSupplyRequest/FHIRSupplyRequestRequester.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSupplyRequestStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRSupplyRequestStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRTask' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRTask.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTask\\FHIRTaskRequester' => 'HL7/FHIR/STU3/FHIRResource/FHIRTask/FHIRTaskRequester.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTask\\FHIRTaskRestriction' => 'HL7/FHIR/STU3/FHIRResource/FHIRTask/FHIRTaskRestriction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTask\\FHIRTaskInput' => 'HL7/FHIR/STU3/FHIRResource/FHIRTask/FHIRTaskInput.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTask\\FHIRTaskOutput' => 'HL7/FHIR/STU3/FHIRResource/FHIRTask/FHIRTaskOutput.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTaskStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRTaskStatus.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRTestReport' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRTestReport.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportParticipant' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportParticipant.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportSetup' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportSetup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportAction' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportAction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportOperation' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportOperation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportAssert' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportAssert.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportTest' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportTest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportAction1' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportAction1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportTeardown' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportTeardown.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestReport\\FHIRTestReportAction2' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestReport/FHIRTestReportAction2.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTestReportStatus' => 'HL7/FHIR/STU3/FHIRElement/FHIRTestReportStatus.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTestReportActionResult' => 'HL7/FHIR/STU3/FHIRElement/FHIRTestReportActionResult.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTestReportParticipantType' => 'HL7/FHIR/STU3/FHIRElement/FHIRTestReportParticipantType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTestReportResult' => 'HL7/FHIR/STU3/FHIRElement/FHIRTestReportResult.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRTestScript' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRTestScript.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptOrigin' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptOrigin.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptDestination' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptDestination.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptMetadata' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptMetadata.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptLink' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptLink.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptCapability' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptCapability.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptFixture' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptFixture.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptVariable' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptVariable.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRule' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRule.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptParam' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptParam.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRuleset' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRuleset.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRule1' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRule1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptParam1' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptParam1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptSetup' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptSetup.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAction' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptAction.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptOperation' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptOperation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRequestHeader' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRequestHeader.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAssert' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptAssert.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRule2' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRule2.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptParam2' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptParam2.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRuleset1' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRuleset1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRule3' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptRule3.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptParam3' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptParam3.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptTest' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptTest.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAction1' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptAction1.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptTeardown' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptTeardown.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAction2' => 'HL7/FHIR/STU3/FHIRResource/FHIRTestScript/FHIRTestScriptAction2.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRDefinedType' => 'HL7/FHIR/STU3/FHIRElement/FHIRFHIRDefinedType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContentType' => 'HL7/FHIR/STU3/FHIRElement/FHIRContentType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAssertionDirectionType' => 'HL7/FHIR/STU3/FHIRElement/FHIRAssertionDirectionType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAssertionOperatorType' => 'HL7/FHIR/STU3/FHIRElement/FHIRAssertionOperatorType.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAssertionResponseTypes' => 'HL7/FHIR/STU3/FHIRElement/FHIRAssertionResponseTypes.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTestScriptRequestMethodCode' => 'HL7/FHIR/STU3/FHIRElement/FHIRTestScriptRequestMethodCode.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRValueSet' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRValueSet.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetCompose' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetCompose.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetInclude' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetInclude.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetConcept' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetConcept.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetDesignation' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetDesignation.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetFilter' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetFilter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetExpansion' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetExpansion.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetParameter' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetParameter.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRValueSet\\FHIRValueSetContains' => 'HL7/FHIR/STU3/FHIRResource/FHIRValueSet/FHIRValueSetContains.php',
    'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRVisionPrescription' => 'HL7/FHIR/STU3/FHIRDomainResource/FHIRVisionPrescription.php',
    'HL7\\FHIR\\STU3\\FHIRResource\\FHIRVisionPrescription\\FHIRVisionPrescriptionDispense' => 'HL7/FHIR/STU3/FHIRResource/FHIRVisionPrescription/FHIRVisionPrescriptionDispense.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRVisionBase' => 'HL7/FHIR/STU3/FHIRElement/FHIRVisionBase.php',
    'HL7\\FHIR\\STU3\\FHIRElement\\FHIRVisionEyes' => 'HL7/FHIR/STU3/FHIRElement/FHIRVisionEyes.php',
    );

    /** @var bool */
    private static $_registered = false;

    /**
     * @return bool
     * @throws \Exception
     */
    public static function register()
    {
        if (self::$_registered) {
            return self::$_registered;
        }
        return self::$_registered = spl_autoload_register(array(__CLASS__, 'loadClass'), true);
    }

    /**
     * @return bool
     */
    public static function unregister()
    {
        if (self::$_registered) {
            if (spl_autoload_unregister(array(__CLASS__, 'loadClass'))) {
                self::$_registered = false;
                return true;
            }
        }
        return false;
    }

    /**
     * Please see associated documentation for more information on what this method looks for.
     *
     * @param string $class
     * @return bool|null
     */
    public static function loadClass($class)
    {
        if (isset(self::$_classMap[$class])) {
            return (bool)require sprintf('%s/%s', self::ROOT_DIR, self::$_classMap[$class]);
        }
        return null;
    }
}
